<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0">
    <xsl:output method="text" indent="no"/>
    <xsl:template match="/">
        <xsl:apply-templates select="//valueSet"/>
    </xsl:template>
    <xsl:template match="valueSet[conceptList/concept]">
/*
This is autogenerated stub SQL. It has been tested on PostgreSQL. It is not intended as a ready solution for all environments.
Before using it, adapt to suit your database design and local SQL flavor.

If the table has not been created, or is outdated, uncomment the DROP and/or CREATE statements.

DROP TABLE art_decor_valuesets;

CREATE TABLE art_decor_valuesets (
    valueset_id varchar(255) NOT NULL,
    valueset_effectiveDate varchar(255) NOT NULL,
    valueset_name varchar(255) NOT NULL,
    code varchar(255) NOT NULL,
    codeSystem varchar(255) NOT NULL,
    displayName varchar(255) NOT NULL,
    level SMALLINT,
    type CHARACTER(1)
    );
*/
    <xsl:for-each select="conceptList/concept">
INSERT INTO art_decor_valuesets (
    valueset_id,
    valueset_effectiveDate,
    valueset_name,
    code,
    codeSystem,
    displayName,
    level,
    type
    )
VALUES (
    '<xsl:value-of select="../../@id"/>', 
    '<xsl:value-of select="../../@effectiveDate"/>', 
    '<xsl:value-of select="../../@name"/>', 
    '<xsl:value-of select="@code"/>', 
    '<xsl:value-of select="@codeSystem"/>', 
    '<xsl:value-of select="translate(@displayName, '''', '')"/>',
    '<xsl:value-of select="@level"/>', 
    '<xsl:value-of select="@type"/>'
    );
        
    </xsl:for-each>
    </xsl:template>

    <xsl:template match="@*|node()">
    </xsl:template>
</xsl:stylesheet>