<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0">
    <xsl:output method="text" indent="no"/>
    <xsl:template match="/">
        <xsl:apply-templates select="//valueSet"/>
    </xsl:template>
    <xsl:template match="valueSet[conceptList/concept]">
        <xsl:variable name="tablename" select="concat(translate(@name, '-', '_'), '_', translate(@effectiveDate, '-:T', ''))"/>
/*
This is autogenerated stub SQL. It has been tested on PostgreSQL. It is not intended as a ready solution for all environments.
Before using it, adapt to suit your database design and local SQL flavor.
*/
--DROP TABLE <xsl:value-of select="$tablename"/> CASCADE;
CREATE TABLE <xsl:value-of select="$tablename"/> (
    <xsl:value-of select="translate(@name, '-', '_')"/>_id int NOT NULL PRIMARY KEY,
    code varchar(255) NOT NULL,
    codeSystem varchar(255) NOT NULL,
    displayName varchar(255) NOT NULL
    );
    <xsl:for-each select="conceptList/concept">
INSERT INTO <xsl:value-of select="$tablename"/> (<xsl:value-of select="translate(../../@name, '-', '_')"/>_id, code, codeSystem, displayName)
        VALUES (<xsl:value-of select="if (@localId) then @localId else position()"/>, '<xsl:value-of select="@code"/>', '<xsl:value-of select="@codeSystem"/>', '<xsl:value-of select="translate(@displayName, '''', '')"/>');

    </xsl:for-each>
    </xsl:template>
    <xsl:template match="@*|node()">
        <xsl:apply-templates select="@*|node()"/>
    </xsl:template>
</xsl:stylesheet>