var myUrl = new URLSearchParams(window.location.search)
var decor = {};
decor.strLanguage = myUrl.get('language');
decor.strId = myUrl.get('id');
decor.strEffectiveDate = myUrl.get('effectiveDate');
decor.strVersion = myUrl.get('version');

function getQuestionnaire() {
return new Promise(
    function(resolve, reject) {
        var request = new XMLHttpRequest();
        var strUrl = 'RetrieveQuestionnaire?id=' + decor.strId + '&effectiveDate=' + decor.strEffectiveDate + '&language=' + decor.strLanguage + '&format=json'
        if (decor.strVersion) strUrl = strUrl + '&version=' + decor.strVersion
        request.onload = function() {
            if (request.status == 200) {
                resolve(request.responseText);
            }
            else {
                reject('Error, got status: ' + request.status + '\nbody: ' + request.responseText + '\nfor query: ' + strUrl);
            }
            document.getElementById("loading").innerHTML = "";
        }
        document.getElementById("loading").innerHTML = "Loading...";
        request.open("GET", strUrl, true);
        request.send();
    });
}

function initForm(json) {
    var fhirQ = JSON.parse(json) 
    // Convert FHIR Questionnaire to LForms format
    var lformsQ = LForms.FHIR.R4.SDC.convertQuestionnaireToLForms(fhirQ);
    
    // Turn off the top-level questions and controls (optional)
    lformsQ.templateOptions = {
        showFormHeader: false,
        hideFormControls: true,
        allowHTMLInInstructions: true,
        showCodingInstruction: true
    };
        
    // Add the form to the page
    LForms.Util.addFormToPage(lformsQ, formContainer);
}

function formError(error) {
    console.error(error);
    window.alert(error);
}

// Define the function for showing the QuestionnaireResponse
function showQR() {
    var qr = LForms.Util.getFormFHIRData('QuestionnaireResponse', 'R4');
    window.alert(JSON.stringify(qr, null, 2));
}

getQuestionnaire().then(initForm, formError)