<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
                xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://hl7.org/fhir"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all"
                version="3.0">
   <xd:doc scope="stylesheet">
      <xd:desc>
         <xd:p>
            <xd:b>Generated:</xd:b> 2022-04-03T07:39:49.348+02:00</xd:p>
         <xd:p>
            <xd:b>By:</xd:b> schema2xmlxsl.xsl version 1.0.0</xd:p>
         <xd:p>Takes in an expath map (http://www.w3.org/2005/xpath-functions) as constructed by json-to-xml() and convert that to FHIR XML</xd:p>
         <xd:p>Known 'issue': does not handle array of fhir_comments as xml comment(), and basically ignores them</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:output indent="yes"
               method="xml"
               media-type="application/xml"
               omit-xml-declaration="yes"/>
   <xsl:variable name="theJSON"
                 select="if (/fn:map) then . else fn:json-to-xml(.)"
                 as="document-node()"/>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="/">
      <xsl:apply-templates select="$theJSON/fn:map"/>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="/fn:map">
      <xsl:variable name="theName" select="fn:string[@key = 'resourceType']"/>
      <xsl:choose>
         <xsl:when test="$theName = 'Account'">
            <xsl:apply-templates select="." mode="Account">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'AllergyIntolerance'">
            <xsl:apply-templates select="." mode="AllergyIntolerance">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Appointment'">
            <xsl:apply-templates select="." mode="Appointment">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'AppointmentResponse'">
            <xsl:apply-templates select="." mode="AppointmentResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'AuditEvent'">
            <xsl:apply-templates select="." mode="AuditEvent">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Basic'">
            <xsl:apply-templates select="." mode="Basic">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Binary'">
            <xsl:apply-templates select="." mode="Binary">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'BodySite'">
            <xsl:apply-templates select="." mode="BodySite">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Bundle'">
            <xsl:apply-templates select="." mode="Bundle">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'CarePlan'">
            <xsl:apply-templates select="." mode="CarePlan">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Claim'">
            <xsl:apply-templates select="." mode="Claim">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ClaimResponse'">
            <xsl:apply-templates select="." mode="ClaimResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ClinicalImpression'">
            <xsl:apply-templates select="." mode="ClinicalImpression">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Communication'">
            <xsl:apply-templates select="." mode="Communication">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'CommunicationRequest'">
            <xsl:apply-templates select="." mode="CommunicationRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Composition'">
            <xsl:apply-templates select="." mode="Composition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ConceptMap'">
            <xsl:apply-templates select="." mode="ConceptMap">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Condition'">
            <xsl:apply-templates select="." mode="Condition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Conformance'">
            <xsl:apply-templates select="." mode="Conformance">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Contract'">
            <xsl:apply-templates select="." mode="Contract">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Coverage'">
            <xsl:apply-templates select="." mode="Coverage">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DataElement'">
            <xsl:apply-templates select="." mode="DataElement">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DetectedIssue'">
            <xsl:apply-templates select="." mode="DetectedIssue">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Device'">
            <xsl:apply-templates select="." mode="Device">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DeviceComponent'">
            <xsl:apply-templates select="." mode="DeviceComponent">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DeviceMetric'">
            <xsl:apply-templates select="." mode="DeviceMetric">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DeviceUseRequest'">
            <xsl:apply-templates select="." mode="DeviceUseRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DeviceUseStatement'">
            <xsl:apply-templates select="." mode="DeviceUseStatement">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DiagnosticOrder'">
            <xsl:apply-templates select="." mode="DiagnosticOrder">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DiagnosticReport'">
            <xsl:apply-templates select="." mode="DiagnosticReport">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DocumentManifest'">
            <xsl:apply-templates select="." mode="DocumentManifest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DocumentReference'">
            <xsl:apply-templates select="." mode="DocumentReference">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EligibilityRequest'">
            <xsl:apply-templates select="." mode="EligibilityRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EligibilityResponse'">
            <xsl:apply-templates select="." mode="EligibilityResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Encounter'">
            <xsl:apply-templates select="." mode="Encounter">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EnrollmentRequest'">
            <xsl:apply-templates select="." mode="EnrollmentRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EnrollmentResponse'">
            <xsl:apply-templates select="." mode="EnrollmentResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EpisodeOfCare'">
            <xsl:apply-templates select="." mode="EpisodeOfCare">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ExplanationOfBenefit'">
            <xsl:apply-templates select="." mode="ExplanationOfBenefit">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'FamilyMemberHistory'">
            <xsl:apply-templates select="." mode="FamilyMemberHistory">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Flag'">
            <xsl:apply-templates select="." mode="Flag">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Goal'">
            <xsl:apply-templates select="." mode="Goal">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Group'">
            <xsl:apply-templates select="." mode="Group">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'HealthcareService'">
            <xsl:apply-templates select="." mode="HealthcareService">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ImagingObjectSelection'">
            <xsl:apply-templates select="." mode="ImagingObjectSelection">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ImagingStudy'">
            <xsl:apply-templates select="." mode="ImagingStudy">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Immunization'">
            <xsl:apply-templates select="." mode="Immunization">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ImmunizationRecommendation'">
            <xsl:apply-templates select="." mode="ImmunizationRecommendation">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ImplementationGuide'">
            <xsl:apply-templates select="." mode="ImplementationGuide">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'List'">
            <xsl:apply-templates select="." mode="List">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Location'">
            <xsl:apply-templates select="." mode="Location">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Media'">
            <xsl:apply-templates select="." mode="Media">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Medication'">
            <xsl:apply-templates select="." mode="Medication">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MedicationAdministration'">
            <xsl:apply-templates select="." mode="MedicationAdministration">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MedicationDispense'">
            <xsl:apply-templates select="." mode="MedicationDispense">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MedicationOrder'">
            <xsl:apply-templates select="." mode="MedicationOrder">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MedicationStatement'">
            <xsl:apply-templates select="." mode="MedicationStatement">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MessageHeader'">
            <xsl:apply-templates select="." mode="MessageHeader">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'NamingSystem'">
            <xsl:apply-templates select="." mode="NamingSystem">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'NutritionOrder'">
            <xsl:apply-templates select="." mode="NutritionOrder">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Observation'">
            <xsl:apply-templates select="." mode="Observation">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'OperationDefinition'">
            <xsl:apply-templates select="." mode="OperationDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'OperationOutcome'">
            <xsl:apply-templates select="." mode="OperationOutcome">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Order'">
            <xsl:apply-templates select="." mode="Order">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'OrderResponse'">
            <xsl:apply-templates select="." mode="OrderResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Organization'">
            <xsl:apply-templates select="." mode="Organization">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Patient'">
            <xsl:apply-templates select="." mode="Patient">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'PaymentNotice'">
            <xsl:apply-templates select="." mode="PaymentNotice">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'PaymentReconciliation'">
            <xsl:apply-templates select="." mode="PaymentReconciliation">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Person'">
            <xsl:apply-templates select="." mode="Person">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Practitioner'">
            <xsl:apply-templates select="." mode="Practitioner">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Procedure'">
            <xsl:apply-templates select="." mode="Procedure">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ProcedureRequest'">
            <xsl:apply-templates select="." mode="ProcedureRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ProcessRequest'">
            <xsl:apply-templates select="." mode="ProcessRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ProcessResponse'">
            <xsl:apply-templates select="." mode="ProcessResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Provenance'">
            <xsl:apply-templates select="." mode="Provenance">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Questionnaire'">
            <xsl:apply-templates select="." mode="Questionnaire">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'QuestionnaireResponse'">
            <xsl:apply-templates select="." mode="QuestionnaireResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ReferralRequest'">
            <xsl:apply-templates select="." mode="ReferralRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'RelatedPerson'">
            <xsl:apply-templates select="." mode="RelatedPerson">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'RiskAssessment'">
            <xsl:apply-templates select="." mode="RiskAssessment">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Schedule'">
            <xsl:apply-templates select="." mode="Schedule">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'SearchParameter'">
            <xsl:apply-templates select="." mode="SearchParameter">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Slot'">
            <xsl:apply-templates select="." mode="Slot">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Specimen'">
            <xsl:apply-templates select="." mode="Specimen">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'StructureDefinition'">
            <xsl:apply-templates select="." mode="StructureDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Subscription'">
            <xsl:apply-templates select="." mode="Subscription">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Substance'">
            <xsl:apply-templates select="." mode="Substance">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'SupplyDelivery'">
            <xsl:apply-templates select="." mode="SupplyDelivery">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'SupplyRequest'">
            <xsl:apply-templates select="." mode="SupplyRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'TestScript'">
            <xsl:apply-templates select="." mode="TestScript">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ValueSet'">
            <xsl:apply-templates select="." mode="ValueSet">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'VisionPrescription'">
            <xsl:apply-templates select="." mode="VisionPrescription">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Parameters'">
            <xsl:apply-templates select="." mode="Parameters">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:message terminate="yes">Unknown resourceType <xsl:value-of select="fn:string[@key = 'resourceType']"/>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A string that may contain markdown syntax for optional processing by a mark down presentation engine</xd:p>
         <xd:p>Systems are not required to have markdown support, and there is considerable variation in markdown syntax, so the text should be readable without markdown processing. The preferred markdown syntax is described here: http://daringfireball.net/projects/markdown/syntax (and tests here: http://daringfireball.net/projects/downloads/MarkdownTest_1.0.zip)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="markdown">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A whole number</xd:p>
         <xd:p>32 bit number; for values larger than this, use decimal</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="integer">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A date, date-time or partial date (e.g. just year or year + month).  If hours and minutes are specified, a time zone SHALL be populated. The format is a union of the schema types gYear, gYearMonth, date and dateTime. Seconds must be provided due to schema type constraints but may be zero-filled and may be ignored.                 Dates SHALL be valid dates.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="dateTime">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An integer with a value that is not negative (e.g. &gt;= 0)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="unsignedInt">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A string which has at least one character and no leading or trailing whitespace and where there is no whitespace other than single spaces in the contents</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="code">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A date or partial date (e.g. just year or year + month). There is no time zone. The format is a union of the schema types gYear, gYearMonth and date.  Dates SHALL be valid dates.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="date">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A rational number with implicit precision</xd:p>
         <xd:p>Do not use a IEEE type floating point type, instead use something that works like a true decimal, with inbuilt precision (e.g. Java BigInteger)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="decimal">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>String of characters used to identify a name or a resource</xd:p>
         <xd:p>see http://en.wikipedia.org/wiki/Uniform_resource_identifier</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="uri">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Any combination of letters, numerals, "-" and ".", with a length limit of 64 characters.  (This might be an integer, an unprefixed OID, UUID or any other identifier pattern that meets these constraints.)  Ids are case-insensitive.</xd:p>
         <xd:p>RFC 4122</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="id">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A stream of bytes</xd:p>
         <xd:p>A stream of bytes, base64 encoded</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="base64Binary">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A time during the day, with no date specified</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="time">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An oid represented as a URI</xd:p>
         <xd:p>RFC 3001. See also ISO/IEC 8824:1990 €</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="oid">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An integer with a value that is positive (e.g. &gt;0)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="positiveInt">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A sequence of Unicode characters</xd:p>
         <xd:p>Note that FHIR strings may not exceed 1MB in size</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="string">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Value of "true" or "false"</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="boolean">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A UUID, represented as a URI</xd:p>
         <xd:p>See The Open Group, CDE 1.1 Remote Procedure Call specification, Appendix A.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="uuid">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An instant in time - known at least to the second</xd:p>
         <xd:p>Note: This is intended for precisely observed times, typically system logs etc., and not human-reported times - for them, see date and dateTime below. Time zone is always required</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="instant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ResourceContainer">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
            <!--Account 1..1 Account-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Account']]" mode="Account">
                  <xsl:with-param name="key" select="'Account'"/>
               </xsl:apply-templates>
               <!--AllergyIntolerance 1..1 AllergyIntolerance-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'AllergyIntolerance']]"
                                    mode="AllergyIntolerance">
                  <xsl:with-param name="key" select="'AllergyIntolerance'"/>
               </xsl:apply-templates>
               <!--Appointment 1..1 Appointment-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Appointment']]"
                                    mode="Appointment">
                  <xsl:with-param name="key" select="'Appointment'"/>
               </xsl:apply-templates>
               <!--AppointmentResponse 1..1 AppointmentResponse-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'AppointmentResponse']]"
                                    mode="AppointmentResponse">
                  <xsl:with-param name="key" select="'AppointmentResponse'"/>
               </xsl:apply-templates>
               <!--AuditEvent 1..1 AuditEvent-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'AuditEvent']]"
                                    mode="AuditEvent">
                  <xsl:with-param name="key" select="'AuditEvent'"/>
               </xsl:apply-templates>
               <!--Basic 1..1 Basic-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Basic']]" mode="Basic">
                  <xsl:with-param name="key" select="'Basic'"/>
               </xsl:apply-templates>
               <!--Binary 1..1 Binary-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Binary']]" mode="Binary">
                  <xsl:with-param name="key" select="'Binary'"/>
               </xsl:apply-templates>
               <!--BodySite 1..1 BodySite-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'BodySite']]" mode="BodySite">
                  <xsl:with-param name="key" select="'BodySite'"/>
               </xsl:apply-templates>
               <!--Bundle 1..1 Bundle-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Bundle']]" mode="Bundle">
                  <xsl:with-param name="key" select="'Bundle'"/>
               </xsl:apply-templates>
               <!--CarePlan 1..1 CarePlan-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'CarePlan']]" mode="CarePlan">
                  <xsl:with-param name="key" select="'CarePlan'"/>
               </xsl:apply-templates>
               <!--Claim 1..1 Claim-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Claim']]" mode="Claim">
                  <xsl:with-param name="key" select="'Claim'"/>
               </xsl:apply-templates>
               <!--ClaimResponse 1..1 ClaimResponse-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ClaimResponse']]"
                                    mode="ClaimResponse">
                  <xsl:with-param name="key" select="'ClaimResponse'"/>
               </xsl:apply-templates>
               <!--ClinicalImpression 1..1 ClinicalImpression-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ClinicalImpression']]"
                                    mode="ClinicalImpression">
                  <xsl:with-param name="key" select="'ClinicalImpression'"/>
               </xsl:apply-templates>
               <!--Communication 1..1 Communication-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Communication']]"
                                    mode="Communication">
                  <xsl:with-param name="key" select="'Communication'"/>
               </xsl:apply-templates>
               <!--CommunicationRequest 1..1 CommunicationRequest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'CommunicationRequest']]"
                                    mode="CommunicationRequest">
                  <xsl:with-param name="key" select="'CommunicationRequest'"/>
               </xsl:apply-templates>
               <!--Composition 1..1 Composition-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Composition']]"
                                    mode="Composition">
                  <xsl:with-param name="key" select="'Composition'"/>
               </xsl:apply-templates>
               <!--ConceptMap 1..1 ConceptMap-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ConceptMap']]"
                                    mode="ConceptMap">
                  <xsl:with-param name="key" select="'ConceptMap'"/>
               </xsl:apply-templates>
               <!--Condition 1..1 Condition-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Condition']]" mode="Condition">
                  <xsl:with-param name="key" select="'Condition'"/>
               </xsl:apply-templates>
               <!--Conformance 1..1 Conformance-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Conformance']]"
                                    mode="Conformance">
                  <xsl:with-param name="key" select="'Conformance'"/>
               </xsl:apply-templates>
               <!--Contract 1..1 Contract-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Contract']]" mode="Contract">
                  <xsl:with-param name="key" select="'Contract'"/>
               </xsl:apply-templates>
               <!--Coverage 1..1 Coverage-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Coverage']]" mode="Coverage">
                  <xsl:with-param name="key" select="'Coverage'"/>
               </xsl:apply-templates>
               <!--DataElement 1..1 DataElement-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DataElement']]"
                                    mode="DataElement">
                  <xsl:with-param name="key" select="'DataElement'"/>
               </xsl:apply-templates>
               <!--DetectedIssue 1..1 DetectedIssue-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DetectedIssue']]"
                                    mode="DetectedIssue">
                  <xsl:with-param name="key" select="'DetectedIssue'"/>
               </xsl:apply-templates>
               <!--Device 1..1 Device-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Device']]" mode="Device">
                  <xsl:with-param name="key" select="'Device'"/>
               </xsl:apply-templates>
               <!--DeviceComponent 1..1 DeviceComponent-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DeviceComponent']]"
                                    mode="DeviceComponent">
                  <xsl:with-param name="key" select="'DeviceComponent'"/>
               </xsl:apply-templates>
               <!--DeviceMetric 1..1 DeviceMetric-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DeviceMetric']]"
                                    mode="DeviceMetric">
                  <xsl:with-param name="key" select="'DeviceMetric'"/>
               </xsl:apply-templates>
               <!--DeviceUseRequest 1..1 DeviceUseRequest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DeviceUseRequest']]"
                                    mode="DeviceUseRequest">
                  <xsl:with-param name="key" select="'DeviceUseRequest'"/>
               </xsl:apply-templates>
               <!--DeviceUseStatement 1..1 DeviceUseStatement-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DeviceUseStatement']]"
                                    mode="DeviceUseStatement">
                  <xsl:with-param name="key" select="'DeviceUseStatement'"/>
               </xsl:apply-templates>
               <!--DiagnosticOrder 1..1 DiagnosticOrder-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DiagnosticOrder']]"
                                    mode="DiagnosticOrder">
                  <xsl:with-param name="key" select="'DiagnosticOrder'"/>
               </xsl:apply-templates>
               <!--DiagnosticReport 1..1 DiagnosticReport-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DiagnosticReport']]"
                                    mode="DiagnosticReport">
                  <xsl:with-param name="key" select="'DiagnosticReport'"/>
               </xsl:apply-templates>
               <!--DocumentManifest 1..1 DocumentManifest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DocumentManifest']]"
                                    mode="DocumentManifest">
                  <xsl:with-param name="key" select="'DocumentManifest'"/>
               </xsl:apply-templates>
               <!--DocumentReference 1..1 DocumentReference-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DocumentReference']]"
                                    mode="DocumentReference">
                  <xsl:with-param name="key" select="'DocumentReference'"/>
               </xsl:apply-templates>
               <!--EligibilityRequest 1..1 EligibilityRequest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EligibilityRequest']]"
                                    mode="EligibilityRequest">
                  <xsl:with-param name="key" select="'EligibilityRequest'"/>
               </xsl:apply-templates>
               <!--EligibilityResponse 1..1 EligibilityResponse-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EligibilityResponse']]"
                                    mode="EligibilityResponse">
                  <xsl:with-param name="key" select="'EligibilityResponse'"/>
               </xsl:apply-templates>
               <!--Encounter 1..1 Encounter-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Encounter']]" mode="Encounter">
                  <xsl:with-param name="key" select="'Encounter'"/>
               </xsl:apply-templates>
               <!--EnrollmentRequest 1..1 EnrollmentRequest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EnrollmentRequest']]"
                                    mode="EnrollmentRequest">
                  <xsl:with-param name="key" select="'EnrollmentRequest'"/>
               </xsl:apply-templates>
               <!--EnrollmentResponse 1..1 EnrollmentResponse-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EnrollmentResponse']]"
                                    mode="EnrollmentResponse">
                  <xsl:with-param name="key" select="'EnrollmentResponse'"/>
               </xsl:apply-templates>
               <!--EpisodeOfCare 1..1 EpisodeOfCare-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EpisodeOfCare']]"
                                    mode="EpisodeOfCare">
                  <xsl:with-param name="key" select="'EpisodeOfCare'"/>
               </xsl:apply-templates>
               <!--ExplanationOfBenefit 1..1 ExplanationOfBenefit-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ExplanationOfBenefit']]"
                                    mode="ExplanationOfBenefit">
                  <xsl:with-param name="key" select="'ExplanationOfBenefit'"/>
               </xsl:apply-templates>
               <!--FamilyMemberHistory 1..1 FamilyMemberHistory-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'FamilyMemberHistory']]"
                                    mode="FamilyMemberHistory">
                  <xsl:with-param name="key" select="'FamilyMemberHistory'"/>
               </xsl:apply-templates>
               <!--Flag 1..1 Flag-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Flag']]" mode="Flag">
                  <xsl:with-param name="key" select="'Flag'"/>
               </xsl:apply-templates>
               <!--Goal 1..1 Goal-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Goal']]" mode="Goal">
                  <xsl:with-param name="key" select="'Goal'"/>
               </xsl:apply-templates>
               <!--Group 1..1 Group-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Group']]" mode="Group">
                  <xsl:with-param name="key" select="'Group'"/>
               </xsl:apply-templates>
               <!--HealthcareService 1..1 HealthcareService-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'HealthcareService']]"
                                    mode="HealthcareService">
                  <xsl:with-param name="key" select="'HealthcareService'"/>
               </xsl:apply-templates>
               <!--ImagingObjectSelection 1..1 ImagingObjectSelection-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ImagingObjectSelection']]"
                                    mode="ImagingObjectSelection">
                  <xsl:with-param name="key" select="'ImagingObjectSelection'"/>
               </xsl:apply-templates>
               <!--ImagingStudy 1..1 ImagingStudy-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ImagingStudy']]"
                                    mode="ImagingStudy">
                  <xsl:with-param name="key" select="'ImagingStudy'"/>
               </xsl:apply-templates>
               <!--Immunization 1..1 Immunization-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Immunization']]"
                                    mode="Immunization">
                  <xsl:with-param name="key" select="'Immunization'"/>
               </xsl:apply-templates>
               <!--ImmunizationRecommendation 1..1 ImmunizationRecommendation-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ImmunizationRecommendation']]"
                                    mode="ImmunizationRecommendation">
                  <xsl:with-param name="key" select="'ImmunizationRecommendation'"/>
               </xsl:apply-templates>
               <!--ImplementationGuide 1..1 ImplementationGuide-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ImplementationGuide']]"
                                    mode="ImplementationGuide">
                  <xsl:with-param name="key" select="'ImplementationGuide'"/>
               </xsl:apply-templates>
               <!--List 1..1 List-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'List']]" mode="List">
                  <xsl:with-param name="key" select="'List'"/>
               </xsl:apply-templates>
               <!--Location 1..1 Location-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Location']]" mode="Location">
                  <xsl:with-param name="key" select="'Location'"/>
               </xsl:apply-templates>
               <!--Media 1..1 Media-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Media']]" mode="Media">
                  <xsl:with-param name="key" select="'Media'"/>
               </xsl:apply-templates>
               <!--Medication 1..1 Medication-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Medication']]"
                                    mode="Medication">
                  <xsl:with-param name="key" select="'Medication'"/>
               </xsl:apply-templates>
               <!--MedicationAdministration 1..1 MedicationAdministration-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MedicationAdministration']]"
                                    mode="MedicationAdministration">
                  <xsl:with-param name="key" select="'MedicationAdministration'"/>
               </xsl:apply-templates>
               <!--MedicationDispense 1..1 MedicationDispense-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MedicationDispense']]"
                                    mode="MedicationDispense">
                  <xsl:with-param name="key" select="'MedicationDispense'"/>
               </xsl:apply-templates>
               <!--MedicationOrder 1..1 MedicationOrder-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MedicationOrder']]"
                                    mode="MedicationOrder">
                  <xsl:with-param name="key" select="'MedicationOrder'"/>
               </xsl:apply-templates>
               <!--MedicationStatement 1..1 MedicationStatement-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MedicationStatement']]"
                                    mode="MedicationStatement">
                  <xsl:with-param name="key" select="'MedicationStatement'"/>
               </xsl:apply-templates>
               <!--MessageHeader 1..1 MessageHeader-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MessageHeader']]"
                                    mode="MessageHeader">
                  <xsl:with-param name="key" select="'MessageHeader'"/>
               </xsl:apply-templates>
               <!--NamingSystem 1..1 NamingSystem-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'NamingSystem']]"
                                    mode="NamingSystem">
                  <xsl:with-param name="key" select="'NamingSystem'"/>
               </xsl:apply-templates>
               <!--NutritionOrder 1..1 NutritionOrder-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'NutritionOrder']]"
                                    mode="NutritionOrder">
                  <xsl:with-param name="key" select="'NutritionOrder'"/>
               </xsl:apply-templates>
               <!--Observation 1..1 Observation-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Observation']]"
                                    mode="Observation">
                  <xsl:with-param name="key" select="'Observation'"/>
               </xsl:apply-templates>
               <!--OperationDefinition 1..1 OperationDefinition-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'OperationDefinition']]"
                                    mode="OperationDefinition">
                  <xsl:with-param name="key" select="'OperationDefinition'"/>
               </xsl:apply-templates>
               <!--OperationOutcome 1..1 OperationOutcome-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'OperationOutcome']]"
                                    mode="OperationOutcome">
                  <xsl:with-param name="key" select="'OperationOutcome'"/>
               </xsl:apply-templates>
               <!--Order 1..1 Order-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Order']]" mode="Order">
                  <xsl:with-param name="key" select="'Order'"/>
               </xsl:apply-templates>
               <!--OrderResponse 1..1 OrderResponse-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'OrderResponse']]"
                                    mode="OrderResponse">
                  <xsl:with-param name="key" select="'OrderResponse'"/>
               </xsl:apply-templates>
               <!--Organization 1..1 Organization-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Organization']]"
                                    mode="Organization">
                  <xsl:with-param name="key" select="'Organization'"/>
               </xsl:apply-templates>
               <!--Patient 1..1 Patient-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Patient']]" mode="Patient">
                  <xsl:with-param name="key" select="'Patient'"/>
               </xsl:apply-templates>
               <!--PaymentNotice 1..1 PaymentNotice-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'PaymentNotice']]"
                                    mode="PaymentNotice">
                  <xsl:with-param name="key" select="'PaymentNotice'"/>
               </xsl:apply-templates>
               <!--PaymentReconciliation 1..1 PaymentReconciliation-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'PaymentReconciliation']]"
                                    mode="PaymentReconciliation">
                  <xsl:with-param name="key" select="'PaymentReconciliation'"/>
               </xsl:apply-templates>
               <!--Person 1..1 Person-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Person']]" mode="Person">
                  <xsl:with-param name="key" select="'Person'"/>
               </xsl:apply-templates>
               <!--Practitioner 1..1 Practitioner-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Practitioner']]"
                                    mode="Practitioner">
                  <xsl:with-param name="key" select="'Practitioner'"/>
               </xsl:apply-templates>
               <!--Procedure 1..1 Procedure-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Procedure']]" mode="Procedure">
                  <xsl:with-param name="key" select="'Procedure'"/>
               </xsl:apply-templates>
               <!--ProcedureRequest 1..1 ProcedureRequest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ProcedureRequest']]"
                                    mode="ProcedureRequest">
                  <xsl:with-param name="key" select="'ProcedureRequest'"/>
               </xsl:apply-templates>
               <!--ProcessRequest 1..1 ProcessRequest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ProcessRequest']]"
                                    mode="ProcessRequest">
                  <xsl:with-param name="key" select="'ProcessRequest'"/>
               </xsl:apply-templates>
               <!--ProcessResponse 1..1 ProcessResponse-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ProcessResponse']]"
                                    mode="ProcessResponse">
                  <xsl:with-param name="key" select="'ProcessResponse'"/>
               </xsl:apply-templates>
               <!--Provenance 1..1 Provenance-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Provenance']]"
                                    mode="Provenance">
                  <xsl:with-param name="key" select="'Provenance'"/>
               </xsl:apply-templates>
               <!--Questionnaire 1..1 Questionnaire-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Questionnaire']]"
                                    mode="Questionnaire">
                  <xsl:with-param name="key" select="'Questionnaire'"/>
               </xsl:apply-templates>
               <!--QuestionnaireResponse 1..1 QuestionnaireResponse-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'QuestionnaireResponse']]"
                                    mode="QuestionnaireResponse">
                  <xsl:with-param name="key" select="'QuestionnaireResponse'"/>
               </xsl:apply-templates>
               <!--ReferralRequest 1..1 ReferralRequest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ReferralRequest']]"
                                    mode="ReferralRequest">
                  <xsl:with-param name="key" select="'ReferralRequest'"/>
               </xsl:apply-templates>
               <!--RelatedPerson 1..1 RelatedPerson-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'RelatedPerson']]"
                                    mode="RelatedPerson">
                  <xsl:with-param name="key" select="'RelatedPerson'"/>
               </xsl:apply-templates>
               <!--RiskAssessment 1..1 RiskAssessment-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'RiskAssessment']]"
                                    mode="RiskAssessment">
                  <xsl:with-param name="key" select="'RiskAssessment'"/>
               </xsl:apply-templates>
               <!--Schedule 1..1 Schedule-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Schedule']]" mode="Schedule">
                  <xsl:with-param name="key" select="'Schedule'"/>
               </xsl:apply-templates>
               <!--SearchParameter 1..1 SearchParameter-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'SearchParameter']]"
                                    mode="SearchParameter">
                  <xsl:with-param name="key" select="'SearchParameter'"/>
               </xsl:apply-templates>
               <!--Slot 1..1 Slot-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Slot']]" mode="Slot">
                  <xsl:with-param name="key" select="'Slot'"/>
               </xsl:apply-templates>
               <!--Specimen 1..1 Specimen-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Specimen']]" mode="Specimen">
                  <xsl:with-param name="key" select="'Specimen'"/>
               </xsl:apply-templates>
               <!--StructureDefinition 1..1 StructureDefinition-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'StructureDefinition']]"
                                    mode="StructureDefinition">
                  <xsl:with-param name="key" select="'StructureDefinition'"/>
               </xsl:apply-templates>
               <!--Subscription 1..1 Subscription-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Subscription']]"
                                    mode="Subscription">
                  <xsl:with-param name="key" select="'Subscription'"/>
               </xsl:apply-templates>
               <!--Substance 1..1 Substance-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Substance']]" mode="Substance">
                  <xsl:with-param name="key" select="'Substance'"/>
               </xsl:apply-templates>
               <!--SupplyDelivery 1..1 SupplyDelivery-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'SupplyDelivery']]"
                                    mode="SupplyDelivery">
                  <xsl:with-param name="key" select="'SupplyDelivery'"/>
               </xsl:apply-templates>
               <!--SupplyRequest 1..1 SupplyRequest-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'SupplyRequest']]"
                                    mode="SupplyRequest">
                  <xsl:with-param name="key" select="'SupplyRequest'"/>
               </xsl:apply-templates>
               <!--TestScript 1..1 TestScript-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'TestScript']]"
                                    mode="TestScript">
                  <xsl:with-param name="key" select="'TestScript'"/>
               </xsl:apply-templates>
               <!--ValueSet 1..1 ValueSet-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ValueSet']]" mode="ValueSet">
                  <xsl:with-param name="key" select="'ValueSet'"/>
               </xsl:apply-templates>
               <!--VisionPrescription 1..1 VisionPrescription-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'VisionPrescription']]"
                                    mode="VisionPrescription">
                  <xsl:with-param name="key" select="'VisionPrescription'"/>
               </xsl:apply-templates>
               <!--Parameters 1..1 Parameters-->   <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Parameters']]"
                                    mode="Parameters">
                  <xsl:with-param name="key" select="'Parameters'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Optional Extensions Element - found in all resources.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Extension">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    
                        
                        <!--valueBoolean 1..1 boolean--><xsl:apply-templates select="*[@key = 'valueBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'valueBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueBoolean'])][*[@key = '_valueBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_valueBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'valueBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueInteger 1..1 integer--><xsl:apply-templates select="*[@key = 'valueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'valueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueInteger'])][*[@key = '_valueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_valueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'valueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueDecimal 1..1 decimal--><xsl:apply-templates select="*[@key = 'valueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'valueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDecimal'])][*[@key = '_valueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'valueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueBase64Binary 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'valueBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'valueBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueBase64Binary'])][*[@key = '_valueBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_valueBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'valueBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueInstant 1..1 instant--><xsl:apply-templates select="*[@key = 'valueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'valueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueInstant'])][*[@key = '_valueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_valueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'valueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueString 1..1 string--><xsl:apply-templates select="*[@key = 'valueString']" mode="string">
                  <xsl:with-param name="key" select="'valueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueString'])][*[@key = '_valueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString"/>
                        <xsl:copy-of select="fn:map[@key = '_valueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'valueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueUri 1..1 uri--><xsl:apply-templates select="*[@key = 'valueUri']" mode="uri">
                  <xsl:with-param name="key" select="'valueUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueUri'])][*[@key = '_valueUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUri"/>
                        <xsl:copy-of select="fn:map[@key = '_valueUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'valueUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueDate 1..1 date--><xsl:apply-templates select="*[@key = 'valueDate']" mode="date">
                  <xsl:with-param name="key" select="'valueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDate'])][*[@key = '_valueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'valueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'valueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'valueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDateTime'])][*[@key = '_valueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'valueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueTime 1..1 time--><xsl:apply-templates select="*[@key = 'valueTime']" mode="time">
                  <xsl:with-param name="key" select="'valueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueTime'])][*[@key = '_valueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_valueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'valueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueCode 1..1 code--><xsl:apply-templates select="*[@key = 'valueCode']" mode="code">
                  <xsl:with-param name="key" select="'valueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueCode'])][*[@key = '_valueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_valueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'valueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueOid 1..1 oid--><xsl:apply-templates select="*[@key = 'valueOid']" mode="oid">
                  <xsl:with-param name="key" select="'valueOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueOid'])][*[@key = '_valueOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueOid"/>
                        <xsl:copy-of select="fn:map[@key = '_valueOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'valueOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueUuid 1..1 uuid--><xsl:apply-templates select="*[@key = 'valueUuid']" mode="uuid">
                  <xsl:with-param name="key" select="'valueUuid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueUuid'])][*[@key = '_valueUuid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUuid"/>
                        <xsl:copy-of select="fn:map[@key = '_valueUuid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uuid">
                     <xsl:with-param name="key" select="'valueUuid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueId 1..1 id--><xsl:apply-templates select="*[@key = 'valueId']" mode="id">
                  <xsl:with-param name="key" select="'valueId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueId'])][*[@key = '_valueId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueId"/>
                        <xsl:copy-of select="fn:map[@key = '_valueId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'valueId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueUnsignedInt 1..1 unsignedInt--><xsl:apply-templates select="*[@key = 'valueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'valueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueUnsignedInt'])][*[@key = '_valueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_valueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'valueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valuePositiveInt 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'valuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'valuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valuePositiveInt'])][*[@key = '_valuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_valuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'valuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueMarkdown 1..1 markdown--><xsl:apply-templates select="*[@key = 'valueMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'valueMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueMarkdown'])][*[@key = '_valueMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_valueMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'valueMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueAnnotation 1..1 Annotation--><xsl:apply-templates select="*[@key = 'valueAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'valueAnnotation'"/>
               </xsl:apply-templates>
                        <!--valueAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'valueAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'valueAttachment'"/>
               </xsl:apply-templates>
                        <!--valueIdentifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'valueIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'valueIdentifier'"/>
               </xsl:apply-templates>
                        <!--valueCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'valueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'valueCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--valueCoding 1..1 Coding--><xsl:apply-templates select="*[@key = 'valueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'valueCoding'"/>
               </xsl:apply-templates>
                        <!--valueQuantity 1..1 Quantity--><xsl:apply-templates select="*[@key = 'valueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'valueQuantity'"/>
               </xsl:apply-templates>
                        <!--valueRange 1..1 Range--><xsl:apply-templates select="*[@key = 'valueRange']" mode="Range">
                  <xsl:with-param name="key" select="'valueRange'"/>
               </xsl:apply-templates>
                        <!--valuePeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'valuePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'valuePeriod'"/>
               </xsl:apply-templates>
                        <!--valueRatio 1..1 Ratio--><xsl:apply-templates select="*[@key = 'valueRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'valueRatio'"/>
               </xsl:apply-templates>
                        <!--valueReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'valueReference']" mode="Reference">
                  <xsl:with-param name="key" select="'valueReference'"/>
               </xsl:apply-templates>
                        <!--valueSampledData 1..1 SampledData--><xsl:apply-templates select="*[@key = 'valueSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'valueSampledData'"/>
               </xsl:apply-templates>
                        <!--valueSignature 1..1 Signature--><xsl:apply-templates select="*[@key = 'valueSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'valueSignature'"/>
               </xsl:apply-templates>
                        <!--valueHumanName 1..1 HumanName--><xsl:apply-templates select="*[@key = 'valueHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'valueHumanName'"/>
               </xsl:apply-templates>
                        <!--valueAddress 1..1 Address--><xsl:apply-templates select="*[@key = 'valueAddress']" mode="Address">
                  <xsl:with-param name="key" select="'valueAddress'"/>
               </xsl:apply-templates>
                        <!--valueContactPoint 1..1 ContactPoint--><xsl:apply-templates select="*[@key = 'valueContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'valueContactPoint'"/>
               </xsl:apply-templates>
                        <!--valueTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'valueTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'valueTiming'"/>
               </xsl:apply-templates>
                        <!--valueMeta 1..1 Meta--><xsl:apply-templates select="*[@key = 'valueMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'valueMeta'"/>
               </xsl:apply-templates>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'url']">
                        <xsl:attribute name="url" select="*[@key = 'url']"/>
                     </xsl:if>
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Base definition for all elements that are defined inside a resource - but not those in a data type.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="BackboneElement">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--modifierExtension 0..* Extension--><xsl:apply-templates select="*[@key = 'modifierExtension']" mode="Extension">
                  <xsl:with-param name="key" select="'modifierExtension'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A human-readable formatted text, including images.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Narrative">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--status 1..1 NarrativeStatus--><xsl:apply-templates select="*[@key = 'status']" mode="NarrativeStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="NarrativeStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--xhtml:div 1..1 --><xsl:for-each select="*[@key = 'div']">
                  <xsl:variable name="div" select="fn:parse-xml(.)/*" as="element()?"/>
                  <xsl:if test="$div">
                     <xsl:element name="{local-name($div)}" namespace="{fn:namespace-uri($div)}">
                        <xsl:copy-of select="$div/node()"/>
                     </xsl:element>
                  </xsl:if>
               </xsl:for-each>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of a resource narrative</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="NarrativeStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Base definition for all elements in a resource.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Element">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
            <!--extension 0..* Extension-->   <xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A time period defined by a start and end date and optionally time.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Period">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--start 0..1 dateTime--><xsl:apply-templates select="*[@key = 'start']" mode="dateTime">
                  <xsl:with-param name="key" select="'start'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'start'])][*[@key = '_start']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="start"/>
                        <xsl:copy-of select="fn:map[@key = '_start']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'start'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--end 0..1 dateTime--><xsl:apply-templates select="*[@key = 'end']" mode="dateTime">
                  <xsl:with-param name="key" select="'end'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'end'])][*[@key = '_end']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="end"/>
                        <xsl:copy-of select="fn:map[@key = '_end']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'end'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a code defined by a terminology system.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Coding">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--version 0..1 string--><xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--display 0..1 string--><xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--userSelected 0..1 boolean--><xsl:apply-templates select="*[@key = 'userSelected']" mode="boolean">
                  <xsl:with-param name="key" select="'userSelected'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'userSelected'])][*[@key = '_userSelected']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="userSelected"/>
                        <xsl:copy-of select="fn:map[@key = '_userSelected']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'userSelected'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of ordered Quantities defined by a low and high limit.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Range">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--low 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'low']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'low'"/>
               </xsl:apply-templates>
                    <!--high 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'high']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'high'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A measured amount (or an amount that can potentially be measured). Note that measured amounts include amounts that are not precisely quantified, including amounts involving arbitrary units and floating currencies.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Quantity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comparator 0..1 QuantityComparator--><xsl:apply-templates select="*[@key = 'comparator']" mode="QuantityComparator">
                  <xsl:with-param name="key" select="'comparator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comparator'])][*[@key = '_comparator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator"/>
                        <xsl:copy-of select="fn:map[@key = '_comparator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="QuantityComparator">
                     <xsl:with-param name="key" select="'comparator'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--unit 0..1 string--><xsl:apply-templates select="*[@key = 'unit']" mode="string">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'unit'])][*[@key = '_unit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit"/>
                        <xsl:copy-of select="fn:map[@key = '_unit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'unit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How the Quantity should be understood and represented.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="QuantityComparator">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>For referring to data content defined in other formats.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Attachment">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--contentType 0..1 code--><xsl:apply-templates select="*[@key = 'contentType']" mode="code">
                  <xsl:with-param name="key" select="'contentType'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentType'])][*[@key = '_contentType']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType"/>
                        <xsl:copy-of select="fn:map[@key = '_contentType']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'contentType'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--language 0..1 code--><xsl:apply-templates select="*[@key = 'language']" mode="code">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'language'])][*[@key = '_language']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="language"/>
                        <xsl:copy-of select="fn:map[@key = '_language']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'language'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--data 0..1 base64Binary--><xsl:apply-templates select="*[@key = 'data']" mode="base64Binary">
                  <xsl:with-param name="key" select="'data'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'data'])][*[@key = '_data']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="data"/>
                        <xsl:copy-of select="fn:map[@key = '_data']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'data'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--url 0..1 uri--><xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--size 0..1 unsignedInt--><xsl:apply-templates select="*[@key = 'size']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'size'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'size'])][*[@key = '_size']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="size"/>
                        <xsl:copy-of select="fn:map[@key = '_size']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'size'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--hash 0..1 base64Binary--><xsl:apply-templates select="*[@key = 'hash']" mode="base64Binary">
                  <xsl:with-param name="key" select="'hash'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'hash'])][*[@key = '_hash']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="hash"/>
                        <xsl:copy-of select="fn:map[@key = '_hash']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'hash'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--title 0..1 string--><xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--creation 0..1 dateTime--><xsl:apply-templates select="*[@key = 'creation']" mode="dateTime">
                  <xsl:with-param name="key" select="'creation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'creation'])][*[@key = '_creation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="creation"/>
                        <xsl:copy-of select="fn:map[@key = '_creation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'creation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A relationship of two Quantity values - expressed as a numerator and a denominator.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Ratio">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--numerator 0..1 Quantity--><xsl:apply-templates select="*[@key = 'numerator']" mode="Quantity">
                  <xsl:with-param name="key" select="'numerator'"/>
               </xsl:apply-templates>
                    <!--denominator 0..1 Quantity--><xsl:apply-templates select="*[@key = 'denominator']" mode="Quantity">
                  <xsl:with-param name="key" select="'denominator'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A  text note which also  contains information about who made the statement and when.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Annotation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    
                        
                        <!--authorReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'authorReference']" mode="Reference">
                  <xsl:with-param name="key" select="'authorReference'"/>
               </xsl:apply-templates>
                        <!--authorString 1..1 string--><xsl:apply-templates select="*[@key = 'authorString']" mode="string">
                  <xsl:with-param name="key" select="'authorString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'authorString'])][*[@key = '_authorString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="authorString"/>
                        <xsl:copy-of select="fn:map[@key = '_authorString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'authorString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                    <!--time 0..1 dateTime--><xsl:apply-templates select="*[@key = 'time']" mode="dateTime">
                  <xsl:with-param name="key" select="'time'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'time'])][*[@key = '_time']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="time"/>
                        <xsl:copy-of select="fn:map[@key = '_time']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'time'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--text 1..1 string--><xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A series of measurements taken by a device, with upper and lower limits. There may be more than one dimension in the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SampledData">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--origin 1..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'origin']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'origin'"/>
               </xsl:apply-templates>
                    <!--period 1..1 decimal--><xsl:apply-templates select="*[@key = 'period']" mode="decimal">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'period'])][*[@key = '_period']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="period"/>
                        <xsl:copy-of select="fn:map[@key = '_period']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'period'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--factor 0..1 decimal--><xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--lowerLimit 0..1 decimal--><xsl:apply-templates select="*[@key = 'lowerLimit']" mode="decimal">
                  <xsl:with-param name="key" select="'lowerLimit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lowerLimit'])][*[@key = '_lowerLimit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lowerLimit"/>
                        <xsl:copy-of select="fn:map[@key = '_lowerLimit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'lowerLimit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--upperLimit 0..1 decimal--><xsl:apply-templates select="*[@key = 'upperLimit']" mode="decimal">
                  <xsl:with-param name="key" select="'upperLimit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'upperLimit'])][*[@key = '_upperLimit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="upperLimit"/>
                        <xsl:copy-of select="fn:map[@key = '_upperLimit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'upperLimit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--dimensions 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'dimensions']" mode="positiveInt">
                  <xsl:with-param name="key" select="'dimensions'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'dimensions'])][*[@key = '_dimensions']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="dimensions"/>
                        <xsl:copy-of select="fn:map[@key = '_dimensions']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'dimensions'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--data 1..1 SampledDataDataType--><xsl:apply-templates select="*[@key = 'data']" mode="SampledDataDataType">
                  <xsl:with-param name="key" select="'data'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'data'])][*[@key = '_data']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="data"/>
                        <xsl:copy-of select="fn:map[@key = '_data']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SampledDataDataType">
                     <xsl:with-param name="key" select="'data'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SampledDataDataType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference from one resource to another.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Reference">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--reference 0..1 string--><xsl:apply-templates select="*[@key = 'reference']" mode="string">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'reference'])][*[@key = '_reference']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="reference"/>
                        <xsl:copy-of select="fn:map[@key = '_reference']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'reference'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--display 0..1 string--><xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A concept that may be defined by a formal reference to a terminology or ontology or may be provided by text.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeableConcept">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--coding 0..* Coding--><xsl:apply-templates select="*[@key = 'coding']" mode="Coding">
                  <xsl:with-param name="key" select="'coding'"/>
               </xsl:apply-templates>
                    <!--text 0..1 string--><xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A technical identifier - identifies some entity uniquely and unambiguously.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Identifier">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--use 0..1 IdentifierUse--><xsl:apply-templates select="*[@key = 'use']" mode="IdentifierUse">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="IdentifierUse">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--value 0..1 string--><xsl:apply-templates select="*[@key = 'value']" mode="string">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--period 0..1 Period--><xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
                    <!--assigner 0..1 Reference--><xsl:apply-templates select="*[@key = 'assigner']" mode="Reference">
                  <xsl:with-param name="key" select="'assigner'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Identifies the purpose for this identifier, if known .</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="IdentifierUse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A digital signature along with supporting context. The signature may be electronic/cryptographic in nature, or a graphical image representing a hand-written signature, or a signature process. Different Signature approaches have different utilities.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Signature">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--type 1..* Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--when 1..1 instant--><xsl:apply-templates select="*[@key = 'when']" mode="instant">
                  <xsl:with-param name="key" select="'when'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'when'])][*[@key = '_when']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="when"/>
                        <xsl:copy-of select="fn:map[@key = '_when']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'when'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                        
                        <!--whoUri 1..1 uri--><xsl:apply-templates select="*[@key = 'whoUri']" mode="uri">
                  <xsl:with-param name="key" select="'whoUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'whoUri'])][*[@key = '_whoUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="whoUri"/>
                        <xsl:copy-of select="fn:map[@key = '_whoUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'whoUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--whoReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'whoReference']" mode="Reference">
                  <xsl:with-param name="key" select="'whoReference'"/>
               </xsl:apply-templates>
                    
                    <!--contentType 1..1 code--><xsl:apply-templates select="*[@key = 'contentType']" mode="code">
                  <xsl:with-param name="key" select="'contentType'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentType'])][*[@key = '_contentType']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType"/>
                        <xsl:copy-of select="fn:map[@key = '_contentType']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'contentType'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--blob 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'blob']" mode="base64Binary">
                  <xsl:with-param name="key" select="'blob'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'blob'])][*[@key = '_blob']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="blob"/>
                        <xsl:copy-of select="fn:map[@key = '_blob']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'blob'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Age">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
                    <!--extension 0..* Extension--><xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comparator 0..1 QuantityComparator--><xsl:apply-templates select="*[@key = 'comparator']" mode="QuantityComparator">
                  <xsl:with-param name="key" select="'comparator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comparator'])][*[@key = '_comparator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator"/>
                        <xsl:copy-of select="fn:map[@key = '_comparator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="QuantityComparator">
                     <xsl:with-param name="key" select="'comparator'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--unit 0..1 string--><xsl:apply-templates select="*[@key = 'unit']" mode="string">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'unit'])][*[@key = '_unit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit"/>
                        <xsl:copy-of select="fn:map[@key = '_unit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'unit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Count">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
                    <!--extension 0..* Extension--><xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comparator 0..1 QuantityComparator--><xsl:apply-templates select="*[@key = 'comparator']" mode="QuantityComparator">
                  <xsl:with-param name="key" select="'comparator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comparator'])][*[@key = '_comparator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator"/>
                        <xsl:copy-of select="fn:map[@key = '_comparator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="QuantityComparator">
                     <xsl:with-param name="key" select="'comparator'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--unit 0..1 string--><xsl:apply-templates select="*[@key = 'unit']" mode="string">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'unit'])][*[@key = '_unit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit"/>
                        <xsl:copy-of select="fn:map[@key = '_unit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'unit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Money">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
                    <!--extension 0..* Extension--><xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comparator 0..1 QuantityComparator--><xsl:apply-templates select="*[@key = 'comparator']" mode="QuantityComparator">
                  <xsl:with-param name="key" select="'comparator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comparator'])][*[@key = '_comparator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator"/>
                        <xsl:copy-of select="fn:map[@key = '_comparator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="QuantityComparator">
                     <xsl:with-param name="key" select="'comparator'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--unit 0..1 string--><xsl:apply-templates select="*[@key = 'unit']" mode="string">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'unit'])][*[@key = '_unit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit"/>
                        <xsl:copy-of select="fn:map[@key = '_unit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'unit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Distance">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
                    <!--extension 0..* Extension--><xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comparator 0..1 QuantityComparator--><xsl:apply-templates select="*[@key = 'comparator']" mode="QuantityComparator">
                  <xsl:with-param name="key" select="'comparator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comparator'])][*[@key = '_comparator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator"/>
                        <xsl:copy-of select="fn:map[@key = '_comparator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="QuantityComparator">
                     <xsl:with-param name="key" select="'comparator'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--unit 0..1 string--><xsl:apply-templates select="*[@key = 'unit']" mode="string">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'unit'])][*[@key = '_unit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit"/>
                        <xsl:copy-of select="fn:map[@key = '_unit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'unit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Duration">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
                    <!--extension 0..* Extension--><xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comparator 0..1 QuantityComparator--><xsl:apply-templates select="*[@key = 'comparator']" mode="QuantityComparator">
                  <xsl:with-param name="key" select="'comparator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comparator'])][*[@key = '_comparator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator"/>
                        <xsl:copy-of select="fn:map[@key = '_comparator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="QuantityComparator">
                     <xsl:with-param name="key" select="'comparator'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--unit 0..1 string--><xsl:apply-templates select="*[@key = 'unit']" mode="string">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'unit'])][*[@key = '_unit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit"/>
                        <xsl:copy-of select="fn:map[@key = '_unit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'unit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SimpleQuantity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
                    <!--extension 0..* Extension--><xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comparator 0..0 QuantityComparator--><xsl:apply-templates select="*[@key = 'comparator']" mode="QuantityComparator">
                  <xsl:with-param name="key" select="'comparator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comparator'])][*[@key = '_comparator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator"/>
                        <xsl:copy-of select="fn:map[@key = '_comparator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="QuantityComparator">
                     <xsl:with-param name="key" select="'comparator'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--unit 0..1 string--><xsl:apply-templates select="*[@key = 'unit']" mode="string">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'unit'])][*[@key = '_unit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit"/>
                        <xsl:copy-of select="fn:map[@key = '_unit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'unit'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--system 0..1 uri--><xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--path 1..1 string--><xsl:apply-templates select="*[@key = 'path']" mode="string">
                  <xsl:with-param name="key" select="'path'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'path'])][*[@key = '_path']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="path"/>
                        <xsl:copy-of select="fn:map[@key = '_path']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'path'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--representation 0..* PropertyRepresentation--><xsl:apply-templates select="*[@key = 'representation']" mode="PropertyRepresentation">
                  <xsl:with-param name="key" select="'representation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'representation'])][*[@key = '_representation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="representation"/>
                        <xsl:copy-of select="fn:map[@key = '_representation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="PropertyRepresentation">
                     <xsl:with-param name="key" select="'representation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--label 0..1 string--><xsl:apply-templates select="*[@key = 'label']" mode="string">
                  <xsl:with-param name="key" select="'label'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'label'])][*[@key = '_label']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="label"/>
                        <xsl:copy-of select="fn:map[@key = '_label']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'label'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..* Coding--><xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--slicing 0..1 ElementDefinition.Slicing--><xsl:apply-templates select="*[@key = 'slicing']" mode="ElementDefinition.Slicing">
                  <xsl:with-param name="key" select="'slicing'"/>
               </xsl:apply-templates>
                    <!--short 0..1 string--><xsl:apply-templates select="*[@key = 'short']" mode="string">
                  <xsl:with-param name="key" select="'short'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'short'])][*[@key = '_short']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="short"/>
                        <xsl:copy-of select="fn:map[@key = '_short']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'short'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--definition 0..1 markdown--><xsl:apply-templates select="*[@key = 'definition']" mode="markdown">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'definition'])][*[@key = '_definition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition"/>
                        <xsl:copy-of select="fn:map[@key = '_definition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'definition'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comments 0..1 markdown--><xsl:apply-templates select="*[@key = 'comments']" mode="markdown">
                  <xsl:with-param name="key" select="'comments'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comments'])][*[@key = '_comments']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comments"/>
                        <xsl:copy-of select="fn:map[@key = '_comments']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'comments'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--requirements 0..1 markdown--><xsl:apply-templates select="*[@key = 'requirements']" mode="markdown">
                  <xsl:with-param name="key" select="'requirements'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requirements'])][*[@key = '_requirements']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements"/>
                        <xsl:copy-of select="fn:map[@key = '_requirements']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'requirements'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--alias 0..* string--><xsl:apply-templates select="*[@key = 'alias']" mode="string">
                  <xsl:with-param name="key" select="'alias'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'alias'])][*[@key = '_alias']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="alias"/>
                        <xsl:copy-of select="fn:map[@key = '_alias']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'alias'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--min 0..1 integer--><xsl:apply-templates select="*[@key = 'min']" mode="integer">
                  <xsl:with-param name="key" select="'min'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'min'])][*[@key = '_min']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="min"/>
                        <xsl:copy-of select="fn:map[@key = '_min']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'min'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--max 0..1 string--><xsl:apply-templates select="*[@key = 'max']" mode="string">
                  <xsl:with-param name="key" select="'max'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'max'])][*[@key = '_max']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="max"/>
                        <xsl:copy-of select="fn:map[@key = '_max']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'max'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--base 0..1 ElementDefinition.Base--><xsl:apply-templates select="*[@key = 'base']" mode="ElementDefinition.Base">
                  <xsl:with-param name="key" select="'base'"/>
               </xsl:apply-templates>
                    <!--type 0..* ElementDefinition.Type--><xsl:apply-templates select="*[@key = 'type']" mode="ElementDefinition.Type">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--nameReference 0..1 string--><xsl:apply-templates select="*[@key = 'nameReference']" mode="string">
                  <xsl:with-param name="key" select="'nameReference'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'nameReference'])][*[@key = '_nameReference']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="nameReference"/>
                        <xsl:copy-of select="fn:map[@key = '_nameReference']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'nameReference'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                        
                        <!--defaultValueBoolean 1..1 boolean--><xsl:apply-templates select="*[@key = 'defaultValueBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'defaultValueBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueBoolean'])][*[@key = '_defaultValueBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'defaultValueBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueInteger 1..1 integer--><xsl:apply-templates select="*[@key = 'defaultValueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'defaultValueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueInteger'])][*[@key = '_defaultValueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'defaultValueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueDecimal 1..1 decimal--><xsl:apply-templates select="*[@key = 'defaultValueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'defaultValueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueDecimal'])][*[@key = '_defaultValueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'defaultValueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueBase64Binary 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'defaultValueBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'defaultValueBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueBase64Binary'])][*[@key = '_defaultValueBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="defaultValueBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'defaultValueBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueInstant 1..1 instant--><xsl:apply-templates select="*[@key = 'defaultValueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'defaultValueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueInstant'])][*[@key = '_defaultValueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'defaultValueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueString 1..1 string--><xsl:apply-templates select="*[@key = 'defaultValueString']" mode="string">
                  <xsl:with-param name="key" select="'defaultValueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueString'])][*[@key = '_defaultValueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueString"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'defaultValueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueUri 1..1 uri--><xsl:apply-templates select="*[@key = 'defaultValueUri']" mode="uri">
                  <xsl:with-param name="key" select="'defaultValueUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueUri'])][*[@key = '_defaultValueUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueUri"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'defaultValueUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueDate 1..1 date--><xsl:apply-templates select="*[@key = 'defaultValueDate']" mode="date">
                  <xsl:with-param name="key" select="'defaultValueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueDate'])][*[@key = '_defaultValueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'defaultValueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'defaultValueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'defaultValueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueDateTime'])][*[@key = '_defaultValueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'defaultValueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueTime 1..1 time--><xsl:apply-templates select="*[@key = 'defaultValueTime']" mode="time">
                  <xsl:with-param name="key" select="'defaultValueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueTime'])][*[@key = '_defaultValueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'defaultValueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueCode 1..1 code--><xsl:apply-templates select="*[@key = 'defaultValueCode']" mode="code">
                  <xsl:with-param name="key" select="'defaultValueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueCode'])][*[@key = '_defaultValueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'defaultValueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueOid 1..1 oid--><xsl:apply-templates select="*[@key = 'defaultValueOid']" mode="oid">
                  <xsl:with-param name="key" select="'defaultValueOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueOid'])][*[@key = '_defaultValueOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueOid"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'defaultValueOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueUuid 1..1 uuid--><xsl:apply-templates select="*[@key = 'defaultValueUuid']" mode="uuid">
                  <xsl:with-param name="key" select="'defaultValueUuid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueUuid'])][*[@key = '_defaultValueUuid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueUuid"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueUuid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uuid">
                     <xsl:with-param name="key" select="'defaultValueUuid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueId 1..1 id--><xsl:apply-templates select="*[@key = 'defaultValueId']" mode="id">
                  <xsl:with-param name="key" select="'defaultValueId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueId'])][*[@key = '_defaultValueId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueId"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'defaultValueId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueUnsignedInt 1..1 unsignedInt--><xsl:apply-templates select="*[@key = 'defaultValueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'defaultValueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueUnsignedInt'])][*[@key = '_defaultValueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="defaultValueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'defaultValueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValuePositiveInt 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'defaultValuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'defaultValuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValuePositiveInt'])][*[@key = '_defaultValuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="defaultValuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'defaultValuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueMarkdown 1..1 markdown--><xsl:apply-templates select="*[@key = 'defaultValueMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'defaultValueMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueMarkdown'])][*[@key = '_defaultValueMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'defaultValueMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--defaultValueAnnotation 1..1 Annotation--><xsl:apply-templates select="*[@key = 'defaultValueAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'defaultValueAnnotation'"/>
               </xsl:apply-templates>
                        <!--defaultValueAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'defaultValueAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'defaultValueAttachment'"/>
               </xsl:apply-templates>
                        <!--defaultValueIdentifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'defaultValueIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'defaultValueIdentifier'"/>
               </xsl:apply-templates>
                        <!--defaultValueCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'defaultValueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'defaultValueCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--defaultValueCoding 1..1 Coding--><xsl:apply-templates select="*[@key = 'defaultValueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'defaultValueCoding'"/>
               </xsl:apply-templates>
                        <!--defaultValueQuantity 1..1 Quantity--><xsl:apply-templates select="*[@key = 'defaultValueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'defaultValueQuantity'"/>
               </xsl:apply-templates>
                        <!--defaultValueRange 1..1 Range--><xsl:apply-templates select="*[@key = 'defaultValueRange']" mode="Range">
                  <xsl:with-param name="key" select="'defaultValueRange'"/>
               </xsl:apply-templates>
                        <!--defaultValuePeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'defaultValuePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'defaultValuePeriod'"/>
               </xsl:apply-templates>
                        <!--defaultValueRatio 1..1 Ratio--><xsl:apply-templates select="*[@key = 'defaultValueRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'defaultValueRatio'"/>
               </xsl:apply-templates>
                        <!--defaultValueReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'defaultValueReference']" mode="Reference">
                  <xsl:with-param name="key" select="'defaultValueReference'"/>
               </xsl:apply-templates>
                        <!--defaultValueSampledData 1..1 SampledData--><xsl:apply-templates select="*[@key = 'defaultValueSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'defaultValueSampledData'"/>
               </xsl:apply-templates>
                        <!--defaultValueSignature 1..1 Signature--><xsl:apply-templates select="*[@key = 'defaultValueSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'defaultValueSignature'"/>
               </xsl:apply-templates>
                        <!--defaultValueHumanName 1..1 HumanName--><xsl:apply-templates select="*[@key = 'defaultValueHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'defaultValueHumanName'"/>
               </xsl:apply-templates>
                        <!--defaultValueAddress 1..1 Address--><xsl:apply-templates select="*[@key = 'defaultValueAddress']" mode="Address">
                  <xsl:with-param name="key" select="'defaultValueAddress'"/>
               </xsl:apply-templates>
                        <!--defaultValueContactPoint 1..1 ContactPoint--><xsl:apply-templates select="*[@key = 'defaultValueContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'defaultValueContactPoint'"/>
               </xsl:apply-templates>
                        <!--defaultValueTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'defaultValueTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'defaultValueTiming'"/>
               </xsl:apply-templates>
                        <!--defaultValueMeta 1..1 Meta--><xsl:apply-templates select="*[@key = 'defaultValueMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'defaultValueMeta'"/>
               </xsl:apply-templates>
                    
                    <!--meaningWhenMissing 0..1 markdown--><xsl:apply-templates select="*[@key = 'meaningWhenMissing']" mode="markdown">
                  <xsl:with-param name="key" select="'meaningWhenMissing'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'meaningWhenMissing'])][*[@key = '_meaningWhenMissing']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="meaningWhenMissing"/>
                        <xsl:copy-of select="fn:map[@key = '_meaningWhenMissing']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'meaningWhenMissing'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                        
                        <!--fixedBoolean 1..1 boolean--><xsl:apply-templates select="*[@key = 'fixedBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'fixedBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedBoolean'])][*[@key = '_fixedBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'fixedBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedInteger 1..1 integer--><xsl:apply-templates select="*[@key = 'fixedInteger']" mode="integer">
                  <xsl:with-param name="key" select="'fixedInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedInteger'])][*[@key = '_fixedInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'fixedInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedDecimal 1..1 decimal--><xsl:apply-templates select="*[@key = 'fixedDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'fixedDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedDecimal'])][*[@key = '_fixedDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'fixedDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedBase64Binary 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'fixedBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'fixedBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedBase64Binary'])][*[@key = '_fixedBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'fixedBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedInstant 1..1 instant--><xsl:apply-templates select="*[@key = 'fixedInstant']" mode="instant">
                  <xsl:with-param name="key" select="'fixedInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedInstant'])][*[@key = '_fixedInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'fixedInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedString 1..1 string--><xsl:apply-templates select="*[@key = 'fixedString']" mode="string">
                  <xsl:with-param name="key" select="'fixedString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedString'])][*[@key = '_fixedString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedString"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'fixedString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedUri 1..1 uri--><xsl:apply-templates select="*[@key = 'fixedUri']" mode="uri">
                  <xsl:with-param name="key" select="'fixedUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedUri'])][*[@key = '_fixedUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUri"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'fixedUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedDate 1..1 date--><xsl:apply-templates select="*[@key = 'fixedDate']" mode="date">
                  <xsl:with-param name="key" select="'fixedDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedDate'])][*[@key = '_fixedDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDate"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'fixedDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'fixedDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'fixedDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedDateTime'])][*[@key = '_fixedDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'fixedDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedTime 1..1 time--><xsl:apply-templates select="*[@key = 'fixedTime']" mode="time">
                  <xsl:with-param name="key" select="'fixedTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedTime'])][*[@key = '_fixedTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedTime"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'fixedTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedCode 1..1 code--><xsl:apply-templates select="*[@key = 'fixedCode']" mode="code">
                  <xsl:with-param name="key" select="'fixedCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedCode'])][*[@key = '_fixedCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCode"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'fixedCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedOid 1..1 oid--><xsl:apply-templates select="*[@key = 'fixedOid']" mode="oid">
                  <xsl:with-param name="key" select="'fixedOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedOid'])][*[@key = '_fixedOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedOid"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'fixedOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedUuid 1..1 uuid--><xsl:apply-templates select="*[@key = 'fixedUuid']" mode="uuid">
                  <xsl:with-param name="key" select="'fixedUuid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedUuid'])][*[@key = '_fixedUuid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUuid"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedUuid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uuid">
                     <xsl:with-param name="key" select="'fixedUuid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedId 1..1 id--><xsl:apply-templates select="*[@key = 'fixedId']" mode="id">
                  <xsl:with-param name="key" select="'fixedId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedId'])][*[@key = '_fixedId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedId"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'fixedId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedUnsignedInt 1..1 unsignedInt--><xsl:apply-templates select="*[@key = 'fixedUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'fixedUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedUnsignedInt'])][*[@key = '_fixedUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'fixedUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedPositiveInt 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'fixedPositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'fixedPositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedPositiveInt'])][*[@key = '_fixedPositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedPositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedPositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'fixedPositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedMarkdown 1..1 markdown--><xsl:apply-templates select="*[@key = 'fixedMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'fixedMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedMarkdown'])][*[@key = '_fixedMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'fixedMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--fixedAnnotation 1..1 Annotation--><xsl:apply-templates select="*[@key = 'fixedAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'fixedAnnotation'"/>
               </xsl:apply-templates>
                        <!--fixedAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'fixedAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'fixedAttachment'"/>
               </xsl:apply-templates>
                        <!--fixedIdentifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'fixedIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'fixedIdentifier'"/>
               </xsl:apply-templates>
                        <!--fixedCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'fixedCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'fixedCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--fixedCoding 1..1 Coding--><xsl:apply-templates select="*[@key = 'fixedCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'fixedCoding'"/>
               </xsl:apply-templates>
                        <!--fixedQuantity 1..1 Quantity--><xsl:apply-templates select="*[@key = 'fixedQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'fixedQuantity'"/>
               </xsl:apply-templates>
                        <!--fixedRange 1..1 Range--><xsl:apply-templates select="*[@key = 'fixedRange']" mode="Range">
                  <xsl:with-param name="key" select="'fixedRange'"/>
               </xsl:apply-templates>
                        <!--fixedPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'fixedPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'fixedPeriod'"/>
               </xsl:apply-templates>
                        <!--fixedRatio 1..1 Ratio--><xsl:apply-templates select="*[@key = 'fixedRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'fixedRatio'"/>
               </xsl:apply-templates>
                        <!--fixedReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'fixedReference']" mode="Reference">
                  <xsl:with-param name="key" select="'fixedReference'"/>
               </xsl:apply-templates>
                        <!--fixedSampledData 1..1 SampledData--><xsl:apply-templates select="*[@key = 'fixedSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'fixedSampledData'"/>
               </xsl:apply-templates>
                        <!--fixedSignature 1..1 Signature--><xsl:apply-templates select="*[@key = 'fixedSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'fixedSignature'"/>
               </xsl:apply-templates>
                        <!--fixedHumanName 1..1 HumanName--><xsl:apply-templates select="*[@key = 'fixedHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'fixedHumanName'"/>
               </xsl:apply-templates>
                        <!--fixedAddress 1..1 Address--><xsl:apply-templates select="*[@key = 'fixedAddress']" mode="Address">
                  <xsl:with-param name="key" select="'fixedAddress'"/>
               </xsl:apply-templates>
                        <!--fixedContactPoint 1..1 ContactPoint--><xsl:apply-templates select="*[@key = 'fixedContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'fixedContactPoint'"/>
               </xsl:apply-templates>
                        <!--fixedTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'fixedTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'fixedTiming'"/>
               </xsl:apply-templates>
                        <!--fixedMeta 1..1 Meta--><xsl:apply-templates select="*[@key = 'fixedMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'fixedMeta'"/>
               </xsl:apply-templates>
                    
                    
                        
                        <!--patternBoolean 1..1 boolean--><xsl:apply-templates select="*[@key = 'patternBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'patternBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternBoolean'])][*[@key = '_patternBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_patternBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'patternBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternInteger 1..1 integer--><xsl:apply-templates select="*[@key = 'patternInteger']" mode="integer">
                  <xsl:with-param name="key" select="'patternInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternInteger'])][*[@key = '_patternInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_patternInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'patternInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternDecimal 1..1 decimal--><xsl:apply-templates select="*[@key = 'patternDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'patternDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternDecimal'])][*[@key = '_patternDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_patternDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'patternDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternBase64Binary 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'patternBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'patternBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternBase64Binary'])][*[@key = '_patternBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_patternBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'patternBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternInstant 1..1 instant--><xsl:apply-templates select="*[@key = 'patternInstant']" mode="instant">
                  <xsl:with-param name="key" select="'patternInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternInstant'])][*[@key = '_patternInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_patternInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'patternInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternString 1..1 string--><xsl:apply-templates select="*[@key = 'patternString']" mode="string">
                  <xsl:with-param name="key" select="'patternString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternString'])][*[@key = '_patternString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternString"/>
                        <xsl:copy-of select="fn:map[@key = '_patternString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'patternString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternUri 1..1 uri--><xsl:apply-templates select="*[@key = 'patternUri']" mode="uri">
                  <xsl:with-param name="key" select="'patternUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternUri'])][*[@key = '_patternUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternUri"/>
                        <xsl:copy-of select="fn:map[@key = '_patternUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'patternUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternDate 1..1 date--><xsl:apply-templates select="*[@key = 'patternDate']" mode="date">
                  <xsl:with-param name="key" select="'patternDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternDate'])][*[@key = '_patternDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDate"/>
                        <xsl:copy-of select="fn:map[@key = '_patternDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'patternDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'patternDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'patternDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternDateTime'])][*[@key = '_patternDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_patternDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'patternDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternTime 1..1 time--><xsl:apply-templates select="*[@key = 'patternTime']" mode="time">
                  <xsl:with-param name="key" select="'patternTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternTime'])][*[@key = '_patternTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternTime"/>
                        <xsl:copy-of select="fn:map[@key = '_patternTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'patternTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternCode 1..1 code--><xsl:apply-templates select="*[@key = 'patternCode']" mode="code">
                  <xsl:with-param name="key" select="'patternCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternCode'])][*[@key = '_patternCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternCode"/>
                        <xsl:copy-of select="fn:map[@key = '_patternCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'patternCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternOid 1..1 oid--><xsl:apply-templates select="*[@key = 'patternOid']" mode="oid">
                  <xsl:with-param name="key" select="'patternOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternOid'])][*[@key = '_patternOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternOid"/>
                        <xsl:copy-of select="fn:map[@key = '_patternOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'patternOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternUuid 1..1 uuid--><xsl:apply-templates select="*[@key = 'patternUuid']" mode="uuid">
                  <xsl:with-param name="key" select="'patternUuid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternUuid'])][*[@key = '_patternUuid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternUuid"/>
                        <xsl:copy-of select="fn:map[@key = '_patternUuid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uuid">
                     <xsl:with-param name="key" select="'patternUuid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternId 1..1 id--><xsl:apply-templates select="*[@key = 'patternId']" mode="id">
                  <xsl:with-param name="key" select="'patternId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternId'])][*[@key = '_patternId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternId"/>
                        <xsl:copy-of select="fn:map[@key = '_patternId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'patternId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternUnsignedInt 1..1 unsignedInt--><xsl:apply-templates select="*[@key = 'patternUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'patternUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternUnsignedInt'])][*[@key = '_patternUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_patternUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'patternUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternPositiveInt 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'patternPositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'patternPositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternPositiveInt'])][*[@key = '_patternPositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternPositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_patternPositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'patternPositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternMarkdown 1..1 markdown--><xsl:apply-templates select="*[@key = 'patternMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'patternMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternMarkdown'])][*[@key = '_patternMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_patternMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'patternMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--patternAnnotation 1..1 Annotation--><xsl:apply-templates select="*[@key = 'patternAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'patternAnnotation'"/>
               </xsl:apply-templates>
                        <!--patternAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'patternAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'patternAttachment'"/>
               </xsl:apply-templates>
                        <!--patternIdentifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'patternIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'patternIdentifier'"/>
               </xsl:apply-templates>
                        <!--patternCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'patternCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'patternCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--patternCoding 1..1 Coding--><xsl:apply-templates select="*[@key = 'patternCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'patternCoding'"/>
               </xsl:apply-templates>
                        <!--patternQuantity 1..1 Quantity--><xsl:apply-templates select="*[@key = 'patternQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'patternQuantity'"/>
               </xsl:apply-templates>
                        <!--patternRange 1..1 Range--><xsl:apply-templates select="*[@key = 'patternRange']" mode="Range">
                  <xsl:with-param name="key" select="'patternRange'"/>
               </xsl:apply-templates>
                        <!--patternPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'patternPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'patternPeriod'"/>
               </xsl:apply-templates>
                        <!--patternRatio 1..1 Ratio--><xsl:apply-templates select="*[@key = 'patternRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'patternRatio'"/>
               </xsl:apply-templates>
                        <!--patternReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'patternReference']" mode="Reference">
                  <xsl:with-param name="key" select="'patternReference'"/>
               </xsl:apply-templates>
                        <!--patternSampledData 1..1 SampledData--><xsl:apply-templates select="*[@key = 'patternSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'patternSampledData'"/>
               </xsl:apply-templates>
                        <!--patternSignature 1..1 Signature--><xsl:apply-templates select="*[@key = 'patternSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'patternSignature'"/>
               </xsl:apply-templates>
                        <!--patternHumanName 1..1 HumanName--><xsl:apply-templates select="*[@key = 'patternHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'patternHumanName'"/>
               </xsl:apply-templates>
                        <!--patternAddress 1..1 Address--><xsl:apply-templates select="*[@key = 'patternAddress']" mode="Address">
                  <xsl:with-param name="key" select="'patternAddress'"/>
               </xsl:apply-templates>
                        <!--patternContactPoint 1..1 ContactPoint--><xsl:apply-templates select="*[@key = 'patternContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'patternContactPoint'"/>
               </xsl:apply-templates>
                        <!--patternTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'patternTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'patternTiming'"/>
               </xsl:apply-templates>
                        <!--patternMeta 1..1 Meta--><xsl:apply-templates select="*[@key = 'patternMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'patternMeta'"/>
               </xsl:apply-templates>
                    
                    
                        
                        <!--exampleBoolean 1..1 boolean--><xsl:apply-templates select="*[@key = 'exampleBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'exampleBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleBoolean'])][*[@key = '_exampleBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'exampleBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleInteger 1..1 integer--><xsl:apply-templates select="*[@key = 'exampleInteger']" mode="integer">
                  <xsl:with-param name="key" select="'exampleInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleInteger'])][*[@key = '_exampleInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'exampleInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleDecimal 1..1 decimal--><xsl:apply-templates select="*[@key = 'exampleDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'exampleDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleDecimal'])][*[@key = '_exampleDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'exampleDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleBase64Binary 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'exampleBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'exampleBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleBase64Binary'])][*[@key = '_exampleBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'exampleBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleInstant 1..1 instant--><xsl:apply-templates select="*[@key = 'exampleInstant']" mode="instant">
                  <xsl:with-param name="key" select="'exampleInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleInstant'])][*[@key = '_exampleInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'exampleInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleString 1..1 string--><xsl:apply-templates select="*[@key = 'exampleString']" mode="string">
                  <xsl:with-param name="key" select="'exampleString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleString'])][*[@key = '_exampleString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleString"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'exampleString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleUri 1..1 uri--><xsl:apply-templates select="*[@key = 'exampleUri']" mode="uri">
                  <xsl:with-param name="key" select="'exampleUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleUri'])][*[@key = '_exampleUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleUri"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'exampleUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleDate 1..1 date--><xsl:apply-templates select="*[@key = 'exampleDate']" mode="date">
                  <xsl:with-param name="key" select="'exampleDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleDate'])][*[@key = '_exampleDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleDate"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'exampleDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'exampleDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'exampleDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleDateTime'])][*[@key = '_exampleDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'exampleDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleTime 1..1 time--><xsl:apply-templates select="*[@key = 'exampleTime']" mode="time">
                  <xsl:with-param name="key" select="'exampleTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleTime'])][*[@key = '_exampleTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleTime"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'exampleTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleCode 1..1 code--><xsl:apply-templates select="*[@key = 'exampleCode']" mode="code">
                  <xsl:with-param name="key" select="'exampleCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleCode'])][*[@key = '_exampleCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleCode"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'exampleCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleOid 1..1 oid--><xsl:apply-templates select="*[@key = 'exampleOid']" mode="oid">
                  <xsl:with-param name="key" select="'exampleOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleOid'])][*[@key = '_exampleOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleOid"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'exampleOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleUuid 1..1 uuid--><xsl:apply-templates select="*[@key = 'exampleUuid']" mode="uuid">
                  <xsl:with-param name="key" select="'exampleUuid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleUuid'])][*[@key = '_exampleUuid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleUuid"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleUuid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uuid">
                     <xsl:with-param name="key" select="'exampleUuid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleId 1..1 id--><xsl:apply-templates select="*[@key = 'exampleId']" mode="id">
                  <xsl:with-param name="key" select="'exampleId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleId'])][*[@key = '_exampleId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleId"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'exampleId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleUnsignedInt 1..1 unsignedInt--><xsl:apply-templates select="*[@key = 'exampleUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'exampleUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleUnsignedInt'])][*[@key = '_exampleUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'exampleUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--examplePositiveInt 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'examplePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'examplePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'examplePositiveInt'])][*[@key = '_examplePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="examplePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_examplePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'examplePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleMarkdown 1..1 markdown--><xsl:apply-templates select="*[@key = 'exampleMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'exampleMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'exampleMarkdown'])][*[@key = '_exampleMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_exampleMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'exampleMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--exampleAnnotation 1..1 Annotation--><xsl:apply-templates select="*[@key = 'exampleAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'exampleAnnotation'"/>
               </xsl:apply-templates>
                        <!--exampleAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'exampleAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'exampleAttachment'"/>
               </xsl:apply-templates>
                        <!--exampleIdentifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'exampleIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'exampleIdentifier'"/>
               </xsl:apply-templates>
                        <!--exampleCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'exampleCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'exampleCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--exampleCoding 1..1 Coding--><xsl:apply-templates select="*[@key = 'exampleCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'exampleCoding'"/>
               </xsl:apply-templates>
                        <!--exampleQuantity 1..1 Quantity--><xsl:apply-templates select="*[@key = 'exampleQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'exampleQuantity'"/>
               </xsl:apply-templates>
                        <!--exampleRange 1..1 Range--><xsl:apply-templates select="*[@key = 'exampleRange']" mode="Range">
                  <xsl:with-param name="key" select="'exampleRange'"/>
               </xsl:apply-templates>
                        <!--examplePeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'examplePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'examplePeriod'"/>
               </xsl:apply-templates>
                        <!--exampleRatio 1..1 Ratio--><xsl:apply-templates select="*[@key = 'exampleRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'exampleRatio'"/>
               </xsl:apply-templates>
                        <!--exampleReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'exampleReference']" mode="Reference">
                  <xsl:with-param name="key" select="'exampleReference'"/>
               </xsl:apply-templates>
                        <!--exampleSampledData 1..1 SampledData--><xsl:apply-templates select="*[@key = 'exampleSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'exampleSampledData'"/>
               </xsl:apply-templates>
                        <!--exampleSignature 1..1 Signature--><xsl:apply-templates select="*[@key = 'exampleSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'exampleSignature'"/>
               </xsl:apply-templates>
                        <!--exampleHumanName 1..1 HumanName--><xsl:apply-templates select="*[@key = 'exampleHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'exampleHumanName'"/>
               </xsl:apply-templates>
                        <!--exampleAddress 1..1 Address--><xsl:apply-templates select="*[@key = 'exampleAddress']" mode="Address">
                  <xsl:with-param name="key" select="'exampleAddress'"/>
               </xsl:apply-templates>
                        <!--exampleContactPoint 1..1 ContactPoint--><xsl:apply-templates select="*[@key = 'exampleContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'exampleContactPoint'"/>
               </xsl:apply-templates>
                        <!--exampleTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'exampleTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'exampleTiming'"/>
               </xsl:apply-templates>
                        <!--exampleMeta 1..1 Meta--><xsl:apply-templates select="*[@key = 'exampleMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'exampleMeta'"/>
               </xsl:apply-templates>
                    
                    
                        
                        <!--minValueBoolean 1..1 boolean--><xsl:apply-templates select="*[@key = 'minValueBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'minValueBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueBoolean'])][*[@key = '_minValueBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'minValueBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueInteger 1..1 integer--><xsl:apply-templates select="*[@key = 'minValueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'minValueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueInteger'])][*[@key = '_minValueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'minValueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueDecimal 1..1 decimal--><xsl:apply-templates select="*[@key = 'minValueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'minValueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueDecimal'])][*[@key = '_minValueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'minValueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueBase64Binary 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'minValueBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'minValueBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueBase64Binary'])][*[@key = '_minValueBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'minValueBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueInstant 1..1 instant--><xsl:apply-templates select="*[@key = 'minValueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'minValueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueInstant'])][*[@key = '_minValueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'minValueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueString 1..1 string--><xsl:apply-templates select="*[@key = 'minValueString']" mode="string">
                  <xsl:with-param name="key" select="'minValueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueString'])][*[@key = '_minValueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueString"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'minValueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueUri 1..1 uri--><xsl:apply-templates select="*[@key = 'minValueUri']" mode="uri">
                  <xsl:with-param name="key" select="'minValueUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueUri'])][*[@key = '_minValueUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueUri"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'minValueUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueDate 1..1 date--><xsl:apply-templates select="*[@key = 'minValueDate']" mode="date">
                  <xsl:with-param name="key" select="'minValueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueDate'])][*[@key = '_minValueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'minValueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'minValueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'minValueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueDateTime'])][*[@key = '_minValueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'minValueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueTime 1..1 time--><xsl:apply-templates select="*[@key = 'minValueTime']" mode="time">
                  <xsl:with-param name="key" select="'minValueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueTime'])][*[@key = '_minValueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'minValueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueCode 1..1 code--><xsl:apply-templates select="*[@key = 'minValueCode']" mode="code">
                  <xsl:with-param name="key" select="'minValueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueCode'])][*[@key = '_minValueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'minValueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueOid 1..1 oid--><xsl:apply-templates select="*[@key = 'minValueOid']" mode="oid">
                  <xsl:with-param name="key" select="'minValueOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueOid'])][*[@key = '_minValueOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueOid"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'minValueOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueUuid 1..1 uuid--><xsl:apply-templates select="*[@key = 'minValueUuid']" mode="uuid">
                  <xsl:with-param name="key" select="'minValueUuid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueUuid'])][*[@key = '_minValueUuid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueUuid"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueUuid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uuid">
                     <xsl:with-param name="key" select="'minValueUuid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueId 1..1 id--><xsl:apply-templates select="*[@key = 'minValueId']" mode="id">
                  <xsl:with-param name="key" select="'minValueId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueId'])][*[@key = '_minValueId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueId"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'minValueId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueUnsignedInt 1..1 unsignedInt--><xsl:apply-templates select="*[@key = 'minValueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'minValueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueUnsignedInt'])][*[@key = '_minValueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'minValueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValuePositiveInt 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'minValuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'minValuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValuePositiveInt'])][*[@key = '_minValuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_minValuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'minValuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueMarkdown 1..1 markdown--><xsl:apply-templates select="*[@key = 'minValueMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'minValueMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueMarkdown'])][*[@key = '_minValueMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'minValueMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--minValueAnnotation 1..1 Annotation--><xsl:apply-templates select="*[@key = 'minValueAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'minValueAnnotation'"/>
               </xsl:apply-templates>
                        <!--minValueAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'minValueAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'minValueAttachment'"/>
               </xsl:apply-templates>
                        <!--minValueIdentifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'minValueIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'minValueIdentifier'"/>
               </xsl:apply-templates>
                        <!--minValueCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'minValueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'minValueCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--minValueCoding 1..1 Coding--><xsl:apply-templates select="*[@key = 'minValueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'minValueCoding'"/>
               </xsl:apply-templates>
                        <!--minValueQuantity 1..1 Quantity--><xsl:apply-templates select="*[@key = 'minValueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'minValueQuantity'"/>
               </xsl:apply-templates>
                        <!--minValueRange 1..1 Range--><xsl:apply-templates select="*[@key = 'minValueRange']" mode="Range">
                  <xsl:with-param name="key" select="'minValueRange'"/>
               </xsl:apply-templates>
                        <!--minValuePeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'minValuePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'minValuePeriod'"/>
               </xsl:apply-templates>
                        <!--minValueRatio 1..1 Ratio--><xsl:apply-templates select="*[@key = 'minValueRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'minValueRatio'"/>
               </xsl:apply-templates>
                        <!--minValueReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'minValueReference']" mode="Reference">
                  <xsl:with-param name="key" select="'minValueReference'"/>
               </xsl:apply-templates>
                        <!--minValueSampledData 1..1 SampledData--><xsl:apply-templates select="*[@key = 'minValueSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'minValueSampledData'"/>
               </xsl:apply-templates>
                        <!--minValueSignature 1..1 Signature--><xsl:apply-templates select="*[@key = 'minValueSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'minValueSignature'"/>
               </xsl:apply-templates>
                        <!--minValueHumanName 1..1 HumanName--><xsl:apply-templates select="*[@key = 'minValueHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'minValueHumanName'"/>
               </xsl:apply-templates>
                        <!--minValueAddress 1..1 Address--><xsl:apply-templates select="*[@key = 'minValueAddress']" mode="Address">
                  <xsl:with-param name="key" select="'minValueAddress'"/>
               </xsl:apply-templates>
                        <!--minValueContactPoint 1..1 ContactPoint--><xsl:apply-templates select="*[@key = 'minValueContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'minValueContactPoint'"/>
               </xsl:apply-templates>
                        <!--minValueTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'minValueTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'minValueTiming'"/>
               </xsl:apply-templates>
                        <!--minValueMeta 1..1 Meta--><xsl:apply-templates select="*[@key = 'minValueMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'minValueMeta'"/>
               </xsl:apply-templates>
                    
                    
                        
                        <!--maxValueBoolean 1..1 boolean--><xsl:apply-templates select="*[@key = 'maxValueBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'maxValueBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueBoolean'])][*[@key = '_maxValueBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'maxValueBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueInteger 1..1 integer--><xsl:apply-templates select="*[@key = 'maxValueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'maxValueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueInteger'])][*[@key = '_maxValueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'maxValueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueDecimal 1..1 decimal--><xsl:apply-templates select="*[@key = 'maxValueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'maxValueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueDecimal'])][*[@key = '_maxValueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'maxValueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueBase64Binary 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'maxValueBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'maxValueBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueBase64Binary'])][*[@key = '_maxValueBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'maxValueBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueInstant 1..1 instant--><xsl:apply-templates select="*[@key = 'maxValueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'maxValueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueInstant'])][*[@key = '_maxValueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'maxValueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueString 1..1 string--><xsl:apply-templates select="*[@key = 'maxValueString']" mode="string">
                  <xsl:with-param name="key" select="'maxValueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueString'])][*[@key = '_maxValueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueString"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'maxValueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueUri 1..1 uri--><xsl:apply-templates select="*[@key = 'maxValueUri']" mode="uri">
                  <xsl:with-param name="key" select="'maxValueUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueUri'])][*[@key = '_maxValueUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueUri"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'maxValueUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueDate 1..1 date--><xsl:apply-templates select="*[@key = 'maxValueDate']" mode="date">
                  <xsl:with-param name="key" select="'maxValueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueDate'])][*[@key = '_maxValueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'maxValueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'maxValueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'maxValueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueDateTime'])][*[@key = '_maxValueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'maxValueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueTime 1..1 time--><xsl:apply-templates select="*[@key = 'maxValueTime']" mode="time">
                  <xsl:with-param name="key" select="'maxValueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueTime'])][*[@key = '_maxValueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'maxValueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueCode 1..1 code--><xsl:apply-templates select="*[@key = 'maxValueCode']" mode="code">
                  <xsl:with-param name="key" select="'maxValueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueCode'])][*[@key = '_maxValueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'maxValueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueOid 1..1 oid--><xsl:apply-templates select="*[@key = 'maxValueOid']" mode="oid">
                  <xsl:with-param name="key" select="'maxValueOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueOid'])][*[@key = '_maxValueOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueOid"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'maxValueOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueUuid 1..1 uuid--><xsl:apply-templates select="*[@key = 'maxValueUuid']" mode="uuid">
                  <xsl:with-param name="key" select="'maxValueUuid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueUuid'])][*[@key = '_maxValueUuid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueUuid"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueUuid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uuid">
                     <xsl:with-param name="key" select="'maxValueUuid'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueId 1..1 id--><xsl:apply-templates select="*[@key = 'maxValueId']" mode="id">
                  <xsl:with-param name="key" select="'maxValueId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueId'])][*[@key = '_maxValueId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueId"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'maxValueId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueUnsignedInt 1..1 unsignedInt--><xsl:apply-templates select="*[@key = 'maxValueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'maxValueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueUnsignedInt'])][*[@key = '_maxValueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'maxValueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValuePositiveInt 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'maxValuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'maxValuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValuePositiveInt'])][*[@key = '_maxValuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'maxValuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueMarkdown 1..1 markdown--><xsl:apply-templates select="*[@key = 'maxValueMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'maxValueMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueMarkdown'])][*[@key = '_maxValueMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'maxValueMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--maxValueAnnotation 1..1 Annotation--><xsl:apply-templates select="*[@key = 'maxValueAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'maxValueAnnotation'"/>
               </xsl:apply-templates>
                        <!--maxValueAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'maxValueAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'maxValueAttachment'"/>
               </xsl:apply-templates>
                        <!--maxValueIdentifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'maxValueIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'maxValueIdentifier'"/>
               </xsl:apply-templates>
                        <!--maxValueCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'maxValueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'maxValueCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--maxValueCoding 1..1 Coding--><xsl:apply-templates select="*[@key = 'maxValueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'maxValueCoding'"/>
               </xsl:apply-templates>
                        <!--maxValueQuantity 1..1 Quantity--><xsl:apply-templates select="*[@key = 'maxValueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'maxValueQuantity'"/>
               </xsl:apply-templates>
                        <!--maxValueRange 1..1 Range--><xsl:apply-templates select="*[@key = 'maxValueRange']" mode="Range">
                  <xsl:with-param name="key" select="'maxValueRange'"/>
               </xsl:apply-templates>
                        <!--maxValuePeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'maxValuePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'maxValuePeriod'"/>
               </xsl:apply-templates>
                        <!--maxValueRatio 1..1 Ratio--><xsl:apply-templates select="*[@key = 'maxValueRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'maxValueRatio'"/>
               </xsl:apply-templates>
                        <!--maxValueReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'maxValueReference']" mode="Reference">
                  <xsl:with-param name="key" select="'maxValueReference'"/>
               </xsl:apply-templates>
                        <!--maxValueSampledData 1..1 SampledData--><xsl:apply-templates select="*[@key = 'maxValueSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'maxValueSampledData'"/>
               </xsl:apply-templates>
                        <!--maxValueSignature 1..1 Signature--><xsl:apply-templates select="*[@key = 'maxValueSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'maxValueSignature'"/>
               </xsl:apply-templates>
                        <!--maxValueHumanName 1..1 HumanName--><xsl:apply-templates select="*[@key = 'maxValueHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'maxValueHumanName'"/>
               </xsl:apply-templates>
                        <!--maxValueAddress 1..1 Address--><xsl:apply-templates select="*[@key = 'maxValueAddress']" mode="Address">
                  <xsl:with-param name="key" select="'maxValueAddress'"/>
               </xsl:apply-templates>
                        <!--maxValueContactPoint 1..1 ContactPoint--><xsl:apply-templates select="*[@key = 'maxValueContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'maxValueContactPoint'"/>
               </xsl:apply-templates>
                        <!--maxValueTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'maxValueTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'maxValueTiming'"/>
               </xsl:apply-templates>
                        <!--maxValueMeta 1..1 Meta--><xsl:apply-templates select="*[@key = 'maxValueMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'maxValueMeta'"/>
               </xsl:apply-templates>
                    
                    <!--maxLength 0..1 integer--><xsl:apply-templates select="*[@key = 'maxLength']" mode="integer">
                  <xsl:with-param name="key" select="'maxLength'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxLength'])][*[@key = '_maxLength']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxLength"/>
                        <xsl:copy-of select="fn:map[@key = '_maxLength']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'maxLength'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--condition 0..* id--><xsl:apply-templates select="*[@key = 'condition']" mode="id">
                  <xsl:with-param name="key" select="'condition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'condition'])][*[@key = '_condition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="condition"/>
                        <xsl:copy-of select="fn:map[@key = '_condition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'condition'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--constraint 0..* ElementDefinition.Constraint--><xsl:apply-templates select="*[@key = 'constraint']" mode="ElementDefinition.Constraint">
                  <xsl:with-param name="key" select="'constraint'"/>
               </xsl:apply-templates>
                    <!--mustSupport 0..1 boolean--><xsl:apply-templates select="*[@key = 'mustSupport']" mode="boolean">
                  <xsl:with-param name="key" select="'mustSupport'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mustSupport'])][*[@key = '_mustSupport']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mustSupport"/>
                        <xsl:copy-of select="fn:map[@key = '_mustSupport']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'mustSupport'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--isModifier 0..1 boolean--><xsl:apply-templates select="*[@key = 'isModifier']" mode="boolean">
                  <xsl:with-param name="key" select="'isModifier'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'isModifier'])][*[@key = '_isModifier']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="isModifier"/>
                        <xsl:copy-of select="fn:map[@key = '_isModifier']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'isModifier'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--isSummary 0..1 boolean--><xsl:apply-templates select="*[@key = 'isSummary']" mode="boolean">
                  <xsl:with-param name="key" select="'isSummary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'isSummary'])][*[@key = '_isSummary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="isSummary"/>
                        <xsl:copy-of select="fn:map[@key = '_isSummary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'isSummary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--binding 0..1 ElementDefinition.Binding--><xsl:apply-templates select="*[@key = 'binding']" mode="ElementDefinition.Binding">
                  <xsl:with-param name="key" select="'binding'"/>
               </xsl:apply-templates>
                    <!--mapping 0..* ElementDefinition.Mapping--><xsl:apply-templates select="*[@key = 'mapping']" mode="ElementDefinition.Mapping">
                  <xsl:with-param name="key" select="'mapping'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Mapping">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--identity 1..1 id--><xsl:apply-templates select="*[@key = 'identity']" mode="id">
                  <xsl:with-param name="key" select="'identity'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'identity'])][*[@key = '_identity']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="identity"/>
                        <xsl:copy-of select="fn:map[@key = '_identity']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'identity'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--language 0..1 code--><xsl:apply-templates select="*[@key = 'language']" mode="code">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'language'])][*[@key = '_language']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="language"/>
                        <xsl:copy-of select="fn:map[@key = '_language']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'language'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--map 1..1 string--><xsl:apply-templates select="*[@key = 'map']" mode="string">
                  <xsl:with-param name="key" select="'map'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'map'])][*[@key = '_map']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="map"/>
                        <xsl:copy-of select="fn:map[@key = '_map']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'map'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Slicing">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--discriminator 0..* string--><xsl:apply-templates select="*[@key = 'discriminator']" mode="string">
                  <xsl:with-param name="key" select="'discriminator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'discriminator'])][*[@key = '_discriminator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="discriminator"/>
                        <xsl:copy-of select="fn:map[@key = '_discriminator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'discriminator'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--ordered 0..1 boolean--><xsl:apply-templates select="*[@key = 'ordered']" mode="boolean">
                  <xsl:with-param name="key" select="'ordered'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ordered'])][*[@key = '_ordered']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ordered"/>
                        <xsl:copy-of select="fn:map[@key = '_ordered']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'ordered'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--rules 1..1 SlicingRules--><xsl:apply-templates select="*[@key = 'rules']" mode="SlicingRules">
                  <xsl:with-param name="key" select="'rules'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'rules'])][*[@key = '_rules']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="rules"/>
                        <xsl:copy-of select="fn:map[@key = '_rules']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SlicingRules">
                     <xsl:with-param name="key" select="'rules'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Binding">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--strength 1..1 BindingStrength--><xsl:apply-templates select="*[@key = 'strength']" mode="BindingStrength">
                  <xsl:with-param name="key" select="'strength'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'strength'])][*[@key = '_strength']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="strength"/>
                        <xsl:copy-of select="fn:map[@key = '_strength']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="BindingStrength">
                     <xsl:with-param name="key" select="'strength'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                        
                        <!--valueSetUri 1..1 uri--><xsl:apply-templates select="*[@key = 'valueSetUri']" mode="uri">
                  <xsl:with-param name="key" select="'valueSetUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueSetUri'])][*[@key = '_valueSetUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetUri"/>
                        <xsl:copy-of select="fn:map[@key = '_valueSetUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'valueSetUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--valueSetReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'valueSetReference']" mode="Reference">
                  <xsl:with-param name="key" select="'valueSetReference'"/>
               </xsl:apply-templates>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Type">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--code 1..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--profile 0..* uri--><xsl:apply-templates select="*[@key = 'profile']" mode="uri">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'profile'])][*[@key = '_profile']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="profile"/>
                        <xsl:copy-of select="fn:map[@key = '_profile']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'profile'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--aggregation 0..* AggregationMode--><xsl:apply-templates select="*[@key = 'aggregation']" mode="AggregationMode">
                  <xsl:with-param name="key" select="'aggregation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'aggregation'])][*[@key = '_aggregation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="aggregation"/>
                        <xsl:copy-of select="fn:map[@key = '_aggregation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AggregationMode">
                     <xsl:with-param name="key" select="'aggregation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Base">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--path 1..1 string--><xsl:apply-templates select="*[@key = 'path']" mode="string">
                  <xsl:with-param name="key" select="'path'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'path'])][*[@key = '_path']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="path"/>
                        <xsl:copy-of select="fn:map[@key = '_path']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'path'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--min 1..1 integer--><xsl:apply-templates select="*[@key = 'min']" mode="integer">
                  <xsl:with-param name="key" select="'min'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'min'])][*[@key = '_min']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="min"/>
                        <xsl:copy-of select="fn:map[@key = '_min']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'min'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--max 1..1 string--><xsl:apply-templates select="*[@key = 'max']" mode="string">
                  <xsl:with-param name="key" select="'max'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'max'])][*[@key = '_max']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="max"/>
                        <xsl:copy-of select="fn:map[@key = '_max']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'max'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Constraint">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--key 1..1 id--><xsl:apply-templates select="*[@key = 'key']" mode="id">
                  <xsl:with-param name="key" select="'key'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'key'])][*[@key = '_key']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="key"/>
                        <xsl:copy-of select="fn:map[@key = '_key']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'key'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--requirements 0..1 string--><xsl:apply-templates select="*[@key = 'requirements']" mode="string">
                  <xsl:with-param name="key" select="'requirements'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requirements'])][*[@key = '_requirements']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements"/>
                        <xsl:copy-of select="fn:map[@key = '_requirements']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'requirements'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--severity 1..1 ConstraintSeverity--><xsl:apply-templates select="*[@key = 'severity']" mode="ConstraintSeverity">
                  <xsl:with-param name="key" select="'severity'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'severity'])][*[@key = '_severity']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity"/>
                        <xsl:copy-of select="fn:map[@key = '_severity']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConstraintSeverity">
                     <xsl:with-param name="key" select="'severity'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--human 1..1 string--><xsl:apply-templates select="*[@key = 'human']" mode="string">
                  <xsl:with-param name="key" select="'human'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'human'])][*[@key = '_human']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="human"/>
                        <xsl:copy-of select="fn:map[@key = '_human']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'human'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--xpath 1..1 string--><xsl:apply-templates select="*[@key = 'xpath']" mode="string">
                  <xsl:with-param name="key" select="'xpath'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'xpath'])][*[@key = '_xpath']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="xpath"/>
                        <xsl:copy-of select="fn:map[@key = '_xpath']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'xpath'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a property is represented on the wire.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="PropertyRepresentation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How slices are interpreted when evaluating an instance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SlicingRules">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indication of the degree of conformance expectations associated with a binding.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="BindingStrength">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How resource references can be aggregated.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AggregationMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>SHALL applications comply with this constraint?</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConstraintSeverity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies an event that may occur multiple times. Timing schedules are used to record when things are expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Timing">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--event 0..* dateTime--><xsl:apply-templates select="*[@key = 'event']" mode="dateTime">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'event'])][*[@key = '_event']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="event"/>
                        <xsl:copy-of select="fn:map[@key = '_event']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'event'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--repeat 0..1 Timing.Repeat--><xsl:apply-templates select="*[@key = 'repeat']" mode="Timing.Repeat">
                  <xsl:with-param name="key" select="'repeat'"/>
               </xsl:apply-templates>
                    <!--code 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies an event that may occur multiple times. Timing schedules are used to record when things are expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Timing.Repeat">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    
                        
                        <!--boundsQuantity 1..1 Duration--><xsl:apply-templates select="*[@key = 'boundsQuantity']" mode="Duration">
                  <xsl:with-param name="key" select="'boundsQuantity'"/>
               </xsl:apply-templates>
                        <!--boundsRange 1..1 Range--><xsl:apply-templates select="*[@key = 'boundsRange']" mode="Range">
                  <xsl:with-param name="key" select="'boundsRange'"/>
               </xsl:apply-templates>
                        <!--boundsPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'boundsPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'boundsPeriod'"/>
               </xsl:apply-templates>
                    
                    <!--count 0..1 integer--><xsl:apply-templates select="*[@key = 'count']" mode="integer">
                  <xsl:with-param name="key" select="'count'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'count'])][*[@key = '_count']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="count"/>
                        <xsl:copy-of select="fn:map[@key = '_count']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'count'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--duration 0..1 decimal--><xsl:apply-templates select="*[@key = 'duration']" mode="decimal">
                  <xsl:with-param name="key" select="'duration'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'duration'])][*[@key = '_duration']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="duration"/>
                        <xsl:copy-of select="fn:map[@key = '_duration']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'duration'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--durationMax 0..1 decimal--><xsl:apply-templates select="*[@key = 'durationMax']" mode="decimal">
                  <xsl:with-param name="key" select="'durationMax'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'durationMax'])][*[@key = '_durationMax']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="durationMax"/>
                        <xsl:copy-of select="fn:map[@key = '_durationMax']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'durationMax'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--durationUnits 0..1 UnitsOfTime--><xsl:apply-templates select="*[@key = 'durationUnits']" mode="UnitsOfTime">
                  <xsl:with-param name="key" select="'durationUnits'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'durationUnits'])][*[@key = '_durationUnits']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="durationUnits"/>
                        <xsl:copy-of select="fn:map[@key = '_durationUnits']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="UnitsOfTime">
                     <xsl:with-param name="key" select="'durationUnits'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--frequency 0..1 integer--><xsl:apply-templates select="*[@key = 'frequency']" mode="integer">
                  <xsl:with-param name="key" select="'frequency'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'frequency'])][*[@key = '_frequency']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="frequency"/>
                        <xsl:copy-of select="fn:map[@key = '_frequency']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'frequency'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--frequencyMax 0..1 integer--><xsl:apply-templates select="*[@key = 'frequencyMax']" mode="integer">
                  <xsl:with-param name="key" select="'frequencyMax'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'frequencyMax'])][*[@key = '_frequencyMax']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="frequencyMax"/>
                        <xsl:copy-of select="fn:map[@key = '_frequencyMax']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'frequencyMax'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--period 0..1 decimal--><xsl:apply-templates select="*[@key = 'period']" mode="decimal">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'period'])][*[@key = '_period']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="period"/>
                        <xsl:copy-of select="fn:map[@key = '_period']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'period'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--periodMax 0..1 decimal--><xsl:apply-templates select="*[@key = 'periodMax']" mode="decimal">
                  <xsl:with-param name="key" select="'periodMax'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'periodMax'])][*[@key = '_periodMax']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="periodMax"/>
                        <xsl:copy-of select="fn:map[@key = '_periodMax']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'periodMax'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--periodUnits 0..1 UnitsOfTime--><xsl:apply-templates select="*[@key = 'periodUnits']" mode="UnitsOfTime">
                  <xsl:with-param name="key" select="'periodUnits'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'periodUnits'])][*[@key = '_periodUnits']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="periodUnits"/>
                        <xsl:copy-of select="fn:map[@key = '_periodUnits']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="UnitsOfTime">
                     <xsl:with-param name="key" select="'periodUnits'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--when 0..1 EventTiming--><xsl:apply-templates select="*[@key = 'when']" mode="EventTiming">
                  <xsl:with-param name="key" select="'when'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'when'])][*[@key = '_when']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="when"/>
                        <xsl:copy-of select="fn:map[@key = '_when']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="EventTiming">
                     <xsl:with-param name="key" select="'when'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A unit of time (units from UCUM).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="UnitsOfTime">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Real world event that the relating to the schedule.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="EventTiming">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>There is a variety of postal address formats defined around the world. This format defines a superset that is the basis for all addresses around the world.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Address">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--use 0..1 AddressUse--><xsl:apply-templates select="*[@key = 'use']" mode="AddressUse">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AddressUse">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 0..1 AddressType--><xsl:apply-templates select="*[@key = 'type']" mode="AddressType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AddressType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--text 0..1 string--><xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--line 0..* string--><xsl:apply-templates select="*[@key = 'line']" mode="string">
                  <xsl:with-param name="key" select="'line'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'line'])][*[@key = '_line']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="line"/>
                        <xsl:copy-of select="fn:map[@key = '_line']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'line'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--city 0..1 string--><xsl:apply-templates select="*[@key = 'city']" mode="string">
                  <xsl:with-param name="key" select="'city'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'city'])][*[@key = '_city']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="city"/>
                        <xsl:copy-of select="fn:map[@key = '_city']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'city'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--district 0..1 string--><xsl:apply-templates select="*[@key = 'district']" mode="string">
                  <xsl:with-param name="key" select="'district'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'district'])][*[@key = '_district']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="district"/>
                        <xsl:copy-of select="fn:map[@key = '_district']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'district'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--state 0..1 string--><xsl:apply-templates select="*[@key = 'state']" mode="string">
                  <xsl:with-param name="key" select="'state'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'state'])][*[@key = '_state']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="state"/>
                        <xsl:copy-of select="fn:map[@key = '_state']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'state'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--postalCode 0..1 string--><xsl:apply-templates select="*[@key = 'postalCode']" mode="string">
                  <xsl:with-param name="key" select="'postalCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'postalCode'])][*[@key = '_postalCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="postalCode"/>
                        <xsl:copy-of select="fn:map[@key = '_postalCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'postalCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--country 0..1 string--><xsl:apply-templates select="*[@key = 'country']" mode="string">
                  <xsl:with-param name="key" select="'country'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'country'])][*[@key = '_country']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="country"/>
                        <xsl:copy-of select="fn:map[@key = '_country']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'country'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--period 0..1 Period--><xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The use of an address</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AddressUse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of an address (physical / postal)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AddressType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A human's name with the ability to identify parts and usage.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="HumanName">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--use 0..1 NameUse--><xsl:apply-templates select="*[@key = 'use']" mode="NameUse">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="NameUse">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--text 0..1 string--><xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--family 0..* string--><xsl:apply-templates select="*[@key = 'family']" mode="string">
                  <xsl:with-param name="key" select="'family'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'family'])][*[@key = '_family']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="family"/>
                        <xsl:copy-of select="fn:map[@key = '_family']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'family'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--given 0..* string--><xsl:apply-templates select="*[@key = 'given']" mode="string">
                  <xsl:with-param name="key" select="'given'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'given'])][*[@key = '_given']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="given"/>
                        <xsl:copy-of select="fn:map[@key = '_given']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'given'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--prefix 0..* string--><xsl:apply-templates select="*[@key = 'prefix']" mode="string">
                  <xsl:with-param name="key" select="'prefix'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'prefix'])][*[@key = '_prefix']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="prefix"/>
                        <xsl:copy-of select="fn:map[@key = '_prefix']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'prefix'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--suffix 0..* string--><xsl:apply-templates select="*[@key = 'suffix']" mode="string">
                  <xsl:with-param name="key" select="'suffix'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'suffix'])][*[@key = '_suffix']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="suffix"/>
                        <xsl:copy-of select="fn:map[@key = '_suffix']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'suffix'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--period 0..1 Period--><xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The use of a human name</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="NameUse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The metadata about a resource. This is content in the resource that is maintained by the infrastructure. Changes to the content may not always be associated with version changes to the resource.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Meta">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--versionId 0..1 id--><xsl:apply-templates select="*[@key = 'versionId']" mode="id">
                  <xsl:with-param name="key" select="'versionId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'versionId'])][*[@key = '_versionId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="versionId"/>
                        <xsl:copy-of select="fn:map[@key = '_versionId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'versionId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--lastUpdated 0..1 instant--><xsl:apply-templates select="*[@key = 'lastUpdated']" mode="instant">
                  <xsl:with-param name="key" select="'lastUpdated'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lastUpdated'])][*[@key = '_lastUpdated']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastUpdated"/>
                        <xsl:copy-of select="fn:map[@key = '_lastUpdated']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'lastUpdated'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--profile 0..* uri--><xsl:apply-templates select="*[@key = 'profile']" mode="uri">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'profile'])][*[@key = '_profile']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="profile"/>
                        <xsl:copy-of select="fn:map[@key = '_profile']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'profile'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--security 0..* Coding--><xsl:apply-templates select="*[@key = 'security']" mode="Coding">
                  <xsl:with-param name="key" select="'security'"/>
               </xsl:apply-templates>
                    <!--tag 0..* Coding--><xsl:apply-templates select="*[@key = 'tag']" mode="Coding">
                  <xsl:with-param name="key" select="'tag'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Details for all kinds of technology mediated contact points for a person or organization, including telephone, email, etc.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ContactPoint">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
                    <!--system 0..1 ContactPointSystem--><xsl:apply-templates select="*[@key = 'system']" mode="ContactPointSystem">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ContactPointSystem">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--value 0..1 string--><xsl:apply-templates select="*[@key = 'value']" mode="string">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--use 0..1 ContactPointUse--><xsl:apply-templates select="*[@key = 'use']" mode="ContactPointUse">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ContactPointUse">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--rank 0..1 positiveInt--><xsl:apply-templates select="*[@key = 'rank']" mode="positiveInt">
                  <xsl:with-param name="key" select="'rank'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'rank'])][*[@key = '_rank']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="rank"/>
                        <xsl:copy-of select="fn:map[@key = '_rank']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'rank'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--period 0..1 Period--><xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Telecommunications form for contact point</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ContactPointSystem">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use of contact point</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ContactPointUse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This is the base resource type for everything.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Resource">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
            <!--id 0..1 id-->   <xsl:apply-templates select="*[@key = 'id']" mode="id">
                  <xsl:with-param name="key" select="'id'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'id'])][*[@key = '_id']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="id"/>
                        <xsl:copy-of select="fn:map[@key = '_id']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'id'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--meta 0..1 Meta-->   <xsl:apply-templates select="*[@key = 'meta']" mode="Meta">
                  <xsl:with-param name="key" select="'meta'"/>
               </xsl:apply-templates>
               <!--implicitRules 0..1 uri-->   <xsl:apply-templates select="*[@key = 'implicitRules']" mode="uri">
                  <xsl:with-param name="key" select="'implicitRules'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'implicitRules'])][*[@key = '_implicitRules']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="implicitRules"/>
                        <xsl:copy-of select="fn:map[@key = '_implicitRules']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'implicitRules'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--language 0..1 code-->   <xsl:apply-templates select="*[@key = 'language']" mode="code">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'language'])][*[@key = '_language']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="language"/>
                        <xsl:copy-of select="fn:map[@key = '_language']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'language'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A resource that includes narrative, extensions, and contained resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DomainResource">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Resource"/>
                    <!--text 0..1 Narrative--><xsl:apply-templates select="*[@key = 'text']" mode="Narrative">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
                    <!--contained 0..* ResourceContainer--><xsl:apply-templates select="*[@key = 'contained']" mode="ResourceContainer">
                  <xsl:with-param name="key" select="'contained'"/>
               </xsl:apply-templates>
                    <!--extension 0..* Extension--><xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
                    <!--modifierExtension 0..* Extension--><xsl:apply-templates select="*[@key = 'modifierExtension']" mode="Extension">
                  <xsl:with-param name="key" select="'modifierExtension'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="NoteType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReferenceStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMapEquivalence">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="RemittanceOutcome">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConformanceResourceStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AdministrativeGender">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SearchParamType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centres, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Account">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--status 0..1 AccountStatus--><xsl:apply-templates select="*[@key = 'status']" mode="AccountStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AccountStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--activePeriod 0..1 Period--><xsl:apply-templates select="*[@key = 'activePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'activePeriod'"/>
               </xsl:apply-templates>
                    <!--currency 0..1 Coding--><xsl:apply-templates select="*[@key = 'currency']" mode="Coding">
                  <xsl:with-param name="key" select="'currency'"/>
               </xsl:apply-templates>
                    <!--balance 0..1 Money--><xsl:apply-templates select="*[@key = 'balance']" mode="Money">
                  <xsl:with-param name="key" select="'balance'"/>
               </xsl:apply-templates>
                    <!--coveragePeriod 0..1 Period--><xsl:apply-templates select="*[@key = 'coveragePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'coveragePeriod'"/>
               </xsl:apply-templates>
                    <!--subject 0..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--owner 0..1 Reference--><xsl:apply-templates select="*[@key = 'owner']" mode="Reference">
                  <xsl:with-param name="key" select="'owner'"/>
               </xsl:apply-templates>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the account is available to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AccountStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntolerance">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--onset 0..1 dateTime--><xsl:apply-templates select="*[@key = 'onset']" mode="dateTime">
                  <xsl:with-param name="key" select="'onset'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onset'])][*[@key = '_onset']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onset"/>
                        <xsl:copy-of select="fn:map[@key = '_onset']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'onset'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--recordedDate 0..1 dateTime--><xsl:apply-templates select="*[@key = 'recordedDate']" mode="dateTime">
                  <xsl:with-param name="key" select="'recordedDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'recordedDate'])][*[@key = '_recordedDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="recordedDate"/>
                        <xsl:copy-of select="fn:map[@key = '_recordedDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'recordedDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--recorder 0..1 Reference--><xsl:apply-templates select="*[@key = 'recorder']" mode="Reference">
                  <xsl:with-param name="key" select="'recorder'"/>
               </xsl:apply-templates>
                    <!--patient 1..1 Reference--><xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
                    <!--reporter 0..1 Reference--><xsl:apply-templates select="*[@key = 'reporter']" mode="Reference">
                  <xsl:with-param name="key" select="'reporter'"/>
               </xsl:apply-templates>
                    <!--substance 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'substance']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'substance'"/>
               </xsl:apply-templates>
                    <!--status 0..1 AllergyIntoleranceStatus--><xsl:apply-templates select="*[@key = 'status']" mode="AllergyIntoleranceStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--criticality 0..1 AllergyIntoleranceCriticality--><xsl:apply-templates select="*[@key = 'criticality']" mode="AllergyIntoleranceCriticality">
                  <xsl:with-param name="key" select="'criticality'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'criticality'])][*[@key = '_criticality']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="criticality"/>
                        <xsl:copy-of select="fn:map[@key = '_criticality']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceCriticality">
                     <xsl:with-param name="key" select="'criticality'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 0..1 AllergyIntoleranceType--><xsl:apply-templates select="*[@key = 'type']" mode="AllergyIntoleranceType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--category 0..1 AllergyIntoleranceCategory--><xsl:apply-templates select="*[@key = 'category']" mode="AllergyIntoleranceCategory">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'category'])][*[@key = '_category']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="category"/>
                        <xsl:copy-of select="fn:map[@key = '_category']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceCategory">
                     <xsl:with-param name="key" select="'category'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--lastOccurence 0..1 dateTime--><xsl:apply-templates select="*[@key = 'lastOccurence']" mode="dateTime">
                  <xsl:with-param name="key" select="'lastOccurence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lastOccurence'])][*[@key = '_lastOccurence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastOccurence"/>
                        <xsl:copy-of select="fn:map[@key = '_lastOccurence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'lastOccurence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--note 0..1 Annotation--><xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
                    <!--reaction 0..* AllergyIntolerance.Reaction--><xsl:apply-templates select="*[@key = 'reaction']" mode="AllergyIntolerance.Reaction">
                  <xsl:with-param name="key" select="'reaction'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntolerance.Reaction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--substance 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'substance']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'substance'"/>
               </xsl:apply-templates>
                    <!--certainty 0..1 AllergyIntoleranceCertainty--><xsl:apply-templates select="*[@key = 'certainty']" mode="AllergyIntoleranceCertainty">
                  <xsl:with-param name="key" select="'certainty'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'certainty'])][*[@key = '_certainty']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="certainty"/>
                        <xsl:copy-of select="fn:map[@key = '_certainty']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceCertainty">
                     <xsl:with-param name="key" select="'certainty'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--manifestation 1..* CodeableConcept--><xsl:apply-templates select="*[@key = 'manifestation']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'manifestation'"/>
               </xsl:apply-templates>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--onset 0..1 dateTime--><xsl:apply-templates select="*[@key = 'onset']" mode="dateTime">
                  <xsl:with-param name="key" select="'onset'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onset'])][*[@key = '_onset']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onset"/>
                        <xsl:copy-of select="fn:map[@key = '_onset']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'onset'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--severity 0..1 AllergyIntoleranceSeverity--><xsl:apply-templates select="*[@key = 'severity']" mode="AllergyIntoleranceSeverity">
                  <xsl:with-param name="key" select="'severity'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'severity'])][*[@key = '_severity']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity"/>
                        <xsl:copy-of select="fn:map[@key = '_severity']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceSeverity">
                     <xsl:with-param name="key" select="'severity'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--exposureRoute 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'exposureRoute']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'exposureRoute'"/>
               </xsl:apply-templates>
                    <!--note 0..1 Annotation--><xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Statement about the degree of clinical certainty that a Specific Substance was the cause of the Manifestation in an reaction event.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCertainty">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Identification of the underlying physiological mechanism for a Reaction Risk.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Clinical assessment of the severity of a reaction event as a whole, potentially considering multiple different manifestations.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceSeverity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Estimate of the potential clinical harm, or seriousness, of a reaction to an identified Substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCriticality">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Category of an identified Substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCategory">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Assertion about certainty associated with a propensity, or potential risk, of a reaction to the identified Substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Appointment">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--status 1..1 AppointmentStatus--><xsl:apply-templates select="*[@key = 'status']" mode="AppointmentStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AppointmentStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--reason 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'reason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
                    <!--priority 0..1 unsignedInt--><xsl:apply-templates select="*[@key = 'priority']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'priority'])][*[@key = '_priority']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority"/>
                        <xsl:copy-of select="fn:map[@key = '_priority']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'priority'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--start 0..1 instant--><xsl:apply-templates select="*[@key = 'start']" mode="instant">
                  <xsl:with-param name="key" select="'start'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'start'])][*[@key = '_start']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="start"/>
                        <xsl:copy-of select="fn:map[@key = '_start']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'start'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--end 0..1 instant--><xsl:apply-templates select="*[@key = 'end']" mode="instant">
                  <xsl:with-param name="key" select="'end'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'end'])][*[@key = '_end']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="end"/>
                        <xsl:copy-of select="fn:map[@key = '_end']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'end'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--minutesDuration 0..1 positiveInt--><xsl:apply-templates select="*[@key = 'minutesDuration']" mode="positiveInt">
                  <xsl:with-param name="key" select="'minutesDuration'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minutesDuration'])][*[@key = '_minutesDuration']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minutesDuration"/>
                        <xsl:copy-of select="fn:map[@key = '_minutesDuration']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'minutesDuration'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--slot 0..* Reference--><xsl:apply-templates select="*[@key = 'slot']" mode="Reference">
                  <xsl:with-param name="key" select="'slot'"/>
               </xsl:apply-templates>
                    <!--comment 0..1 string--><xsl:apply-templates select="*[@key = 'comment']" mode="string">
                  <xsl:with-param name="key" select="'comment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comment'])][*[@key = '_comment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment"/>
                        <xsl:copy-of select="fn:map[@key = '_comment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comment'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--participant 1..* Appointment.Participant--><xsl:apply-templates select="*[@key = 'participant']" mode="Appointment.Participant">
                  <xsl:with-param name="key" select="'participant'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Appointment.Participant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--actor 0..1 Reference--><xsl:apply-templates select="*[@key = 'actor']" mode="Reference">
                  <xsl:with-param name="key" select="'actor'"/>
               </xsl:apply-templates>
                    <!--required 0..1 ParticipantRequired--><xsl:apply-templates select="*[@key = 'required']" mode="ParticipantRequired">
                  <xsl:with-param name="key" select="'required'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'required'])][*[@key = '_required']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="required"/>
                        <xsl:copy-of select="fn:map[@key = '_required']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ParticipantRequired">
                     <xsl:with-param name="key" select="'required'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--status 1..1 ParticipationStatus--><xsl:apply-templates select="*[@key = 'status']" mode="ParticipationStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ParticipationStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Is the Participant required to attend the appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ParticipantRequired">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The free/busy status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AppointmentStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Participation status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ParticipationStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AppointmentResponse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--appointment 1..1 Reference--><xsl:apply-templates select="*[@key = 'appointment']" mode="Reference">
                  <xsl:with-param name="key" select="'appointment'"/>
               </xsl:apply-templates>
                    <!--start 0..1 instant--><xsl:apply-templates select="*[@key = 'start']" mode="instant">
                  <xsl:with-param name="key" select="'start'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'start'])][*[@key = '_start']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="start"/>
                        <xsl:copy-of select="fn:map[@key = '_start']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'start'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--end 0..1 instant--><xsl:apply-templates select="*[@key = 'end']" mode="instant">
                  <xsl:with-param name="key" select="'end'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'end'])][*[@key = '_end']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="end"/>
                        <xsl:copy-of select="fn:map[@key = '_end']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'end'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--participantType 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'participantType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'participantType'"/>
               </xsl:apply-templates>
                    <!--actor 0..1 Reference--><xsl:apply-templates select="*[@key = 'actor']" mode="Reference">
                  <xsl:with-param name="key" select="'actor'"/>
               </xsl:apply-templates>
                    <!--participantStatus 1..1 ParticipantStatus--><xsl:apply-templates select="*[@key = 'participantStatus']" mode="ParticipantStatus">
                  <xsl:with-param name="key" select="'participantStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'participantStatus'])][*[@key = '_participantStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="participantStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_participantStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ParticipantStatus">
                     <xsl:with-param name="key" select="'participantStatus'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comment 0..1 string--><xsl:apply-templates select="*[@key = 'comment']" mode="string">
                  <xsl:with-param name="key" select="'comment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comment'])][*[@key = '_comment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment"/>
                        <xsl:copy-of select="fn:map[@key = '_comment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comment'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Participation status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ParticipantStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--event 1..1 AuditEvent.Event--><xsl:apply-templates select="*[@key = 'event']" mode="AuditEvent.Event">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
                    <!--participant 1..* AuditEvent.Participant--><xsl:apply-templates select="*[@key = 'participant']" mode="AuditEvent.Participant">
                  <xsl:with-param name="key" select="'participant'"/>
               </xsl:apply-templates>
                    <!--source 1..1 AuditEvent.Source--><xsl:apply-templates select="*[@key = 'source']" mode="AuditEvent.Source">
                  <xsl:with-param name="key" select="'source'"/>
               </xsl:apply-templates>
                    <!--object 0..* AuditEvent.Object--><xsl:apply-templates select="*[@key = 'object']" mode="AuditEvent.Object">
                  <xsl:with-param name="key" select="'object'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Event">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--subtype 0..* Coding--><xsl:apply-templates select="*[@key = 'subtype']" mode="Coding">
                  <xsl:with-param name="key" select="'subtype'"/>
               </xsl:apply-templates>
                    <!--action 0..1 AuditEventAction--><xsl:apply-templates select="*[@key = 'action']" mode="AuditEventAction">
                  <xsl:with-param name="key" select="'action'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'action'])][*[@key = '_action']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="action"/>
                        <xsl:copy-of select="fn:map[@key = '_action']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AuditEventAction">
                     <xsl:with-param name="key" select="'action'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--dateTime 1..1 instant--><xsl:apply-templates select="*[@key = 'dateTime']" mode="instant">
                  <xsl:with-param name="key" select="'dateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'dateTime'])][*[@key = '_dateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_dateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'dateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--outcome 0..1 AuditEventOutcome--><xsl:apply-templates select="*[@key = 'outcome']" mode="AuditEventOutcome">
                  <xsl:with-param name="key" select="'outcome'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'outcome'])][*[@key = '_outcome']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome"/>
                        <xsl:copy-of select="fn:map[@key = '_outcome']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AuditEventOutcome">
                     <xsl:with-param name="key" select="'outcome'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--outcomeDesc 0..1 string--><xsl:apply-templates select="*[@key = 'outcomeDesc']" mode="string">
                  <xsl:with-param name="key" select="'outcomeDesc'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'outcomeDesc'])][*[@key = '_outcomeDesc']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcomeDesc"/>
                        <xsl:copy-of select="fn:map[@key = '_outcomeDesc']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'outcomeDesc'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--purposeOfEvent 0..* Coding--><xsl:apply-templates select="*[@key = 'purposeOfEvent']" mode="Coding">
                  <xsl:with-param name="key" select="'purposeOfEvent'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Participant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--role 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
                    <!--reference 0..1 Reference--><xsl:apply-templates select="*[@key = 'reference']" mode="Reference">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
                    <!--userId 0..1 Identifier--><xsl:apply-templates select="*[@key = 'userId']" mode="Identifier">
                  <xsl:with-param name="key" select="'userId'"/>
               </xsl:apply-templates>
                    <!--altId 0..1 string--><xsl:apply-templates select="*[@key = 'altId']" mode="string">
                  <xsl:with-param name="key" select="'altId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'altId'])][*[@key = '_altId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="altId"/>
                        <xsl:copy-of select="fn:map[@key = '_altId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'altId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--requestor 1..1 boolean--><xsl:apply-templates select="*[@key = 'requestor']" mode="boolean">
                  <xsl:with-param name="key" select="'requestor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requestor'])][*[@key = '_requestor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requestor"/>
                        <xsl:copy-of select="fn:map[@key = '_requestor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'requestor'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--location 0..1 Reference--><xsl:apply-templates select="*[@key = 'location']" mode="Reference">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
                    <!--policy 0..* uri--><xsl:apply-templates select="*[@key = 'policy']" mode="uri">
                  <xsl:with-param name="key" select="'policy'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'policy'])][*[@key = '_policy']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="policy"/>
                        <xsl:copy-of select="fn:map[@key = '_policy']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'policy'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--media 0..1 Coding--><xsl:apply-templates select="*[@key = 'media']" mode="Coding">
                  <xsl:with-param name="key" select="'media'"/>
               </xsl:apply-templates>
                    <!--network 0..1 AuditEvent.Network--><xsl:apply-templates select="*[@key = 'network']" mode="AuditEvent.Network">
                  <xsl:with-param name="key" select="'network'"/>
               </xsl:apply-templates>
                    <!--purposeOfUse 0..* Coding--><xsl:apply-templates select="*[@key = 'purposeOfUse']" mode="Coding">
                  <xsl:with-param name="key" select="'purposeOfUse'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Network">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--address 0..1 string--><xsl:apply-templates select="*[@key = 'address']" mode="string">
                  <xsl:with-param name="key" select="'address'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'address'])][*[@key = '_address']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="address"/>
                        <xsl:copy-of select="fn:map[@key = '_address']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'address'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 0..1 AuditEventParticipantNetworkType--><xsl:apply-templates select="*[@key = 'type']" mode="AuditEventParticipantNetworkType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AuditEventParticipantNetworkType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Source">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--site 0..1 string--><xsl:apply-templates select="*[@key = 'site']" mode="string">
                  <xsl:with-param name="key" select="'site'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'site'])][*[@key = '_site']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="site"/>
                        <xsl:copy-of select="fn:map[@key = '_site']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'site'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--identifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--type 0..* Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Object">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--reference 0..1 Reference--><xsl:apply-templates select="*[@key = 'reference']" mode="Reference">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
                    <!--type 0..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--role 0..1 Coding--><xsl:apply-templates select="*[@key = 'role']" mode="Coding">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
                    <!--lifecycle 0..1 Coding--><xsl:apply-templates select="*[@key = 'lifecycle']" mode="Coding">
                  <xsl:with-param name="key" select="'lifecycle'"/>
               </xsl:apply-templates>
                    <!--securityLabel 0..* Coding--><xsl:apply-templates select="*[@key = 'securityLabel']" mode="Coding">
                  <xsl:with-param name="key" select="'securityLabel'"/>
               </xsl:apply-templates>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--query 0..1 base64Binary--><xsl:apply-templates select="*[@key = 'query']" mode="base64Binary">
                  <xsl:with-param name="key" select="'query'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'query'])][*[@key = '_query']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="query"/>
                        <xsl:copy-of select="fn:map[@key = '_query']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'query'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--detail 0..* AuditEvent.Detail--><xsl:apply-templates select="*[@key = 'detail']" mode="AuditEvent.Detail">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Detail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 string--><xsl:apply-templates select="*[@key = 'type']" mode="string">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--value 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'value']" mode="base64Binary">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicator for type of action performed during the event that generated the audit.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventAction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the event succeeded or failed</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventOutcome">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of network access point of this participant in the audit event</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventParticipantNetworkType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Basic">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--code 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--subject 0..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--author 0..1 Reference--><xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
                    <!--created 0..1 date--><xsl:apply-templates select="*[@key = 'created']" mode="date">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A binary resource can contain any content, whether text, image, pdf, zip archive, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Binary">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Resource"/>
                    <!--contentType 1..1 code--><xsl:apply-templates select="*[@key = 'contentType']" mode="code">
                  <xsl:with-param name="key" select="'contentType'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentType'])][*[@key = '_contentType']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType"/>
                        <xsl:copy-of select="fn:map[@key = '_contentType']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'contentType'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--content 1..1 base64Binary--><xsl:apply-templates select="*[@key = 'content']" mode="base64Binary">
                  <xsl:with-param name="key" select="'content'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'content'])][*[@key = '_content']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="content"/>
                        <xsl:copy-of select="fn:map[@key = '_content']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'content'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Record details about the anatomical location of a specimen or body part.  This resource may be used when a coded concept does not provide the necessary detail needed for the use case.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="BodySite">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--patient 1..1 Reference--><xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--code 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--modifier 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'modifier']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'modifier'"/>
               </xsl:apply-templates>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--image 0..* Attachment--><xsl:apply-templates select="*[@key = 'image']" mode="Attachment">
                  <xsl:with-param name="key" select="'image'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Resource"/>
                    <!--type 1..1 BundleType--><xsl:apply-templates select="*[@key = 'type']" mode="BundleType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="BundleType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--total 0..1 unsignedInt--><xsl:apply-templates select="*[@key = 'total']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'total'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'total'])][*[@key = '_total']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="total"/>
                        <xsl:copy-of select="fn:map[@key = '_total']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'total'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--link 0..* Bundle.Link--><xsl:apply-templates select="*[@key = 'link']" mode="Bundle.Link">
                  <xsl:with-param name="key" select="'link'"/>
               </xsl:apply-templates>
                    <!--entry 0..* Bundle.Entry--><xsl:apply-templates select="*[@key = 'entry']" mode="Bundle.Entry">
                  <xsl:with-param name="key" select="'entry'"/>
               </xsl:apply-templates>
                    <!--signature 0..1 Signature--><xsl:apply-templates select="*[@key = 'signature']" mode="Signature">
                  <xsl:with-param name="key" select="'signature'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Link">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--relation 1..1 string--><xsl:apply-templates select="*[@key = 'relation']" mode="string">
                  <xsl:with-param name="key" select="'relation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'relation'])][*[@key = '_relation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="relation"/>
                        <xsl:copy-of select="fn:map[@key = '_relation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'relation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--url 1..1 uri--><xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Entry">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--link 0..* Bundle.Link--><xsl:apply-templates select="*[@key = 'link']" mode="Bundle.Link">
                  <xsl:with-param name="key" select="'link'"/>
               </xsl:apply-templates>
                    <!--fullUrl 0..1 uri--><xsl:apply-templates select="*[@key = 'fullUrl']" mode="uri">
                  <xsl:with-param name="key" select="'fullUrl'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fullUrl'])][*[@key = '_fullUrl']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fullUrl"/>
                        <xsl:copy-of select="fn:map[@key = '_fullUrl']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'fullUrl'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--resource 0..1 ResourceContainer--><xsl:apply-templates select="*[@key = 'resource']" mode="ResourceContainer">
                  <xsl:with-param name="key" select="'resource'"/>
               </xsl:apply-templates>
                    <!--search 0..1 Bundle.Search--><xsl:apply-templates select="*[@key = 'search']" mode="Bundle.Search">
                  <xsl:with-param name="key" select="'search'"/>
               </xsl:apply-templates>
                    <!--request 0..1 Bundle.Request--><xsl:apply-templates select="*[@key = 'request']" mode="Bundle.Request">
                  <xsl:with-param name="key" select="'request'"/>
               </xsl:apply-templates>
                    <!--response 0..1 Bundle.Response--><xsl:apply-templates select="*[@key = 'response']" mode="Bundle.Response">
                  <xsl:with-param name="key" select="'response'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Search">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--mode 0..1 SearchEntryMode--><xsl:apply-templates select="*[@key = 'mode']" mode="SearchEntryMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SearchEntryMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--score 0..1 decimal--><xsl:apply-templates select="*[@key = 'score']" mode="decimal">
                  <xsl:with-param name="key" select="'score'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'score'])][*[@key = '_score']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="score"/>
                        <xsl:copy-of select="fn:map[@key = '_score']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'score'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Request">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--method 1..1 HTTPVerb--><xsl:apply-templates select="*[@key = 'method']" mode="HTTPVerb">
                  <xsl:with-param name="key" select="'method'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'method'])][*[@key = '_method']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="method"/>
                        <xsl:copy-of select="fn:map[@key = '_method']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="HTTPVerb">
                     <xsl:with-param name="key" select="'method'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--url 1..1 uri--><xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--ifNoneMatch 0..1 string--><xsl:apply-templates select="*[@key = 'ifNoneMatch']" mode="string">
                  <xsl:with-param name="key" select="'ifNoneMatch'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ifNoneMatch'])][*[@key = '_ifNoneMatch']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifNoneMatch"/>
                        <xsl:copy-of select="fn:map[@key = '_ifNoneMatch']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'ifNoneMatch'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--ifModifiedSince 0..1 instant--><xsl:apply-templates select="*[@key = 'ifModifiedSince']" mode="instant">
                  <xsl:with-param name="key" select="'ifModifiedSince'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ifModifiedSince'])][*[@key = '_ifModifiedSince']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifModifiedSince"/>
                        <xsl:copy-of select="fn:map[@key = '_ifModifiedSince']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'ifModifiedSince'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--ifMatch 0..1 string--><xsl:apply-templates select="*[@key = 'ifMatch']" mode="string">
                  <xsl:with-param name="key" select="'ifMatch'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ifMatch'])][*[@key = '_ifMatch']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifMatch"/>
                        <xsl:copy-of select="fn:map[@key = '_ifMatch']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'ifMatch'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--ifNoneExist 0..1 string--><xsl:apply-templates select="*[@key = 'ifNoneExist']" mode="string">
                  <xsl:with-param name="key" select="'ifNoneExist'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ifNoneExist'])][*[@key = '_ifNoneExist']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifNoneExist"/>
                        <xsl:copy-of select="fn:map[@key = '_ifNoneExist']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'ifNoneExist'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Response">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--status 1..1 string--><xsl:apply-templates select="*[@key = 'status']" mode="string">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--location 0..1 uri--><xsl:apply-templates select="*[@key = 'location']" mode="uri">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'location'])][*[@key = '_location']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="location"/>
                        <xsl:copy-of select="fn:map[@key = '_location']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'location'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--etag 0..1 string--><xsl:apply-templates select="*[@key = 'etag']" mode="string">
                  <xsl:with-param name="key" select="'etag'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'etag'])][*[@key = '_etag']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="etag"/>
                        <xsl:copy-of select="fn:map[@key = '_etag']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'etag'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--lastModified 0..1 instant--><xsl:apply-templates select="*[@key = 'lastModified']" mode="instant">
                  <xsl:with-param name="key" select="'lastModified'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lastModified'])][*[@key = '_lastModified']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastModified"/>
                        <xsl:copy-of select="fn:map[@key = '_lastModified']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'lastModified'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>HTTP verbs (in the HTTP command line).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="HTTPVerb">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Why an entry is in the result set - whether it's included as a match or because of an _include requirement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SearchEntryMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the purpose of a bundle - how it was intended to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="BundleType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--subject 0..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--status 1..1 CarePlanStatus--><xsl:apply-templates select="*[@key = 'status']" mode="CarePlanStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CarePlanStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--context 0..1 Reference--><xsl:apply-templates select="*[@key = 'context']" mode="Reference">
                  <xsl:with-param name="key" select="'context'"/>
               </xsl:apply-templates>
                    <!--period 0..1 Period--><xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
                    <!--author 0..* Reference--><xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
                    <!--modified 0..1 dateTime--><xsl:apply-templates select="*[@key = 'modified']" mode="dateTime">
                  <xsl:with-param name="key" select="'modified'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'modified'])][*[@key = '_modified']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="modified"/>
                        <xsl:copy-of select="fn:map[@key = '_modified']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'modified'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--category 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--addresses 0..* Reference--><xsl:apply-templates select="*[@key = 'addresses']" mode="Reference">
                  <xsl:with-param name="key" select="'addresses'"/>
               </xsl:apply-templates>
                    <!--support 0..* Reference--><xsl:apply-templates select="*[@key = 'support']" mode="Reference">
                  <xsl:with-param name="key" select="'support'"/>
               </xsl:apply-templates>
                    <!--relatedPlan 0..* CarePlan.RelatedPlan--><xsl:apply-templates select="*[@key = 'relatedPlan']" mode="CarePlan.RelatedPlan">
                  <xsl:with-param name="key" select="'relatedPlan'"/>
               </xsl:apply-templates>
                    <!--participant 0..* CarePlan.Participant--><xsl:apply-templates select="*[@key = 'participant']" mode="CarePlan.Participant">
                  <xsl:with-param name="key" select="'participant'"/>
               </xsl:apply-templates>
                    <!--goal 0..* Reference--><xsl:apply-templates select="*[@key = 'goal']" mode="Reference">
                  <xsl:with-param name="key" select="'goal'"/>
               </xsl:apply-templates>
                    <!--activity 0..* CarePlan.Activity--><xsl:apply-templates select="*[@key = 'activity']" mode="CarePlan.Activity">
                  <xsl:with-param name="key" select="'activity'"/>
               </xsl:apply-templates>
                    <!--note 0..1 Annotation--><xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.RelatedPlan">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 0..1 CarePlanRelationship--><xsl:apply-templates select="*[@key = 'code']" mode="CarePlanRelationship">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CarePlanRelationship">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--plan 1..1 Reference--><xsl:apply-templates select="*[@key = 'plan']" mode="Reference">
                  <xsl:with-param name="key" select="'plan'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Participant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--role 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
                    <!--member 0..1 Reference--><xsl:apply-templates select="*[@key = 'member']" mode="Reference">
                  <xsl:with-param name="key" select="'member'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Activity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--actionResulting 0..* Reference--><xsl:apply-templates select="*[@key = 'actionResulting']" mode="Reference">
                  <xsl:with-param name="key" select="'actionResulting'"/>
               </xsl:apply-templates>
                    <!--progress 0..* Annotation--><xsl:apply-templates select="*[@key = 'progress']" mode="Annotation">
                  <xsl:with-param name="key" select="'progress'"/>
               </xsl:apply-templates>
                    <!--reference 0..1 Reference--><xsl:apply-templates select="*[@key = 'reference']" mode="Reference">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
                    <!--detail 0..1 CarePlan.Detail--><xsl:apply-templates select="*[@key = 'detail']" mode="CarePlan.Detail">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Detail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--category 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
                    <!--code 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--reasonCode 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'reasonCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reasonCode'"/>
               </xsl:apply-templates>
                    <!--reasonReference 0..* Reference--><xsl:apply-templates select="*[@key = 'reasonReference']" mode="Reference">
                  <xsl:with-param name="key" select="'reasonReference'"/>
               </xsl:apply-templates>
                    <!--goal 0..* Reference--><xsl:apply-templates select="*[@key = 'goal']" mode="Reference">
                  <xsl:with-param name="key" select="'goal'"/>
               </xsl:apply-templates>
                    <!--status 0..1 CarePlanActivityStatus--><xsl:apply-templates select="*[@key = 'status']" mode="CarePlanActivityStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CarePlanActivityStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--statusReason 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'statusReason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'statusReason'"/>
               </xsl:apply-templates>
                    <!--prohibited 1..1 boolean--><xsl:apply-templates select="*[@key = 'prohibited']" mode="boolean">
                  <xsl:with-param name="key" select="'prohibited'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'prohibited'])][*[@key = '_prohibited']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="prohibited"/>
                        <xsl:copy-of select="fn:map[@key = '_prohibited']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'prohibited'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                        
                        <!--scheduledTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'scheduledTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'scheduledTiming'"/>
               </xsl:apply-templates>
                        <!--scheduledPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'scheduledPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'scheduledPeriod'"/>
               </xsl:apply-templates>
                        <!--scheduledString 1..1 string--><xsl:apply-templates select="*[@key = 'scheduledString']" mode="string">
                  <xsl:with-param name="key" select="'scheduledString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'scheduledString'])][*[@key = '_scheduledString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledString"/>
                        <xsl:copy-of select="fn:map[@key = '_scheduledString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'scheduledString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                    <!--location 0..1 Reference--><xsl:apply-templates select="*[@key = 'location']" mode="Reference">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
                    <!--performer 0..* Reference--><xsl:apply-templates select="*[@key = 'performer']" mode="Reference">
                  <xsl:with-param name="key" select="'performer'"/>
               </xsl:apply-templates>
                    
                        
                        <!--productCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'productCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'productCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--productReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'productReference']" mode="Reference">
                  <xsl:with-param name="key" select="'productReference'"/>
               </xsl:apply-templates>
                    
                    <!--dailyAmount 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'dailyAmount']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'dailyAmount'"/>
               </xsl:apply-templates>
                    <!--quantity 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'quantity']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes identifying the types of relationships between two plans.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanRelationship">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates where the activity is at in its overall life cycle.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanActivityStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--type 1..1 ClaimType--><xsl:apply-templates select="*[@key = 'type']" mode="ClaimType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ClaimType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--ruleset 0..1 Coding--><xsl:apply-templates select="*[@key = 'ruleset']" mode="Coding">
                  <xsl:with-param name="key" select="'ruleset'"/>
               </xsl:apply-templates>
                    <!--originalRuleset 0..1 Coding--><xsl:apply-templates select="*[@key = 'originalRuleset']" mode="Coding">
                  <xsl:with-param name="key" select="'originalRuleset'"/>
               </xsl:apply-templates>
                    <!--created 0..1 dateTime--><xsl:apply-templates select="*[@key = 'created']" mode="dateTime">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--target 0..1 Reference--><xsl:apply-templates select="*[@key = 'target']" mode="Reference">
                  <xsl:with-param name="key" select="'target'"/>
               </xsl:apply-templates>
                    <!--provider 0..1 Reference--><xsl:apply-templates select="*[@key = 'provider']" mode="Reference">
                  <xsl:with-param name="key" select="'provider'"/>
               </xsl:apply-templates>
                    <!--organization 0..1 Reference--><xsl:apply-templates select="*[@key = 'organization']" mode="Reference">
                  <xsl:with-param name="key" select="'organization'"/>
               </xsl:apply-templates>
                    <!--use 0..1 Use--><xsl:apply-templates select="*[@key = 'use']" mode="Use">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="Use">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--priority 0..1 Coding--><xsl:apply-templates select="*[@key = 'priority']" mode="Coding">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
                    <!--fundsReserve 0..1 Coding--><xsl:apply-templates select="*[@key = 'fundsReserve']" mode="Coding">
                  <xsl:with-param name="key" select="'fundsReserve'"/>
               </xsl:apply-templates>
                    <!--enterer 0..1 Reference--><xsl:apply-templates select="*[@key = 'enterer']" mode="Reference">
                  <xsl:with-param name="key" select="'enterer'"/>
               </xsl:apply-templates>
                    <!--facility 0..1 Reference--><xsl:apply-templates select="*[@key = 'facility']" mode="Reference">
                  <xsl:with-param name="key" select="'facility'"/>
               </xsl:apply-templates>
                    <!--prescription 0..1 Reference--><xsl:apply-templates select="*[@key = 'prescription']" mode="Reference">
                  <xsl:with-param name="key" select="'prescription'"/>
               </xsl:apply-templates>
                    <!--originalPrescription 0..1 Reference--><xsl:apply-templates select="*[@key = 'originalPrescription']" mode="Reference">
                  <xsl:with-param name="key" select="'originalPrescription'"/>
               </xsl:apply-templates>
                    <!--payee 0..1 Claim.Payee--><xsl:apply-templates select="*[@key = 'payee']" mode="Claim.Payee">
                  <xsl:with-param name="key" select="'payee'"/>
               </xsl:apply-templates>
                    <!--referral 0..1 Reference--><xsl:apply-templates select="*[@key = 'referral']" mode="Reference">
                  <xsl:with-param name="key" select="'referral'"/>
               </xsl:apply-templates>
                    <!--diagnosis 0..* Claim.Diagnosis--><xsl:apply-templates select="*[@key = 'diagnosis']" mode="Claim.Diagnosis">
                  <xsl:with-param name="key" select="'diagnosis'"/>
               </xsl:apply-templates>
                    <!--condition 0..* Coding--><xsl:apply-templates select="*[@key = 'condition']" mode="Coding">
                  <xsl:with-param name="key" select="'condition'"/>
               </xsl:apply-templates>
                    <!--patient 1..1 Reference--><xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
                    <!--coverage 0..* Claim.Coverage--><xsl:apply-templates select="*[@key = 'coverage']" mode="Claim.Coverage">
                  <xsl:with-param name="key" select="'coverage'"/>
               </xsl:apply-templates>
                    <!--exception 0..* Coding--><xsl:apply-templates select="*[@key = 'exception']" mode="Coding">
                  <xsl:with-param name="key" select="'exception'"/>
               </xsl:apply-templates>
                    <!--school 0..1 string--><xsl:apply-templates select="*[@key = 'school']" mode="string">
                  <xsl:with-param name="key" select="'school'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'school'])][*[@key = '_school']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="school"/>
                        <xsl:copy-of select="fn:map[@key = '_school']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'school'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--accident 0..1 date--><xsl:apply-templates select="*[@key = 'accident']" mode="date">
                  <xsl:with-param name="key" select="'accident'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'accident'])][*[@key = '_accident']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="accident"/>
                        <xsl:copy-of select="fn:map[@key = '_accident']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'accident'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--accidentType 0..1 Coding--><xsl:apply-templates select="*[@key = 'accidentType']" mode="Coding">
                  <xsl:with-param name="key" select="'accidentType'"/>
               </xsl:apply-templates>
                    <!--interventionException 0..* Coding--><xsl:apply-templates select="*[@key = 'interventionException']" mode="Coding">
                  <xsl:with-param name="key" select="'interventionException'"/>
               </xsl:apply-templates>
                    <!--item 0..* Claim.Item--><xsl:apply-templates select="*[@key = 'item']" mode="Claim.Item">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
                    <!--additionalMaterials 0..* Coding--><xsl:apply-templates select="*[@key = 'additionalMaterials']" mode="Coding">
                  <xsl:with-param name="key" select="'additionalMaterials'"/>
               </xsl:apply-templates>
                    <!--missingTeeth 0..* Claim.MissingTeeth--><xsl:apply-templates select="*[@key = 'missingTeeth']" mode="Claim.MissingTeeth">
                  <xsl:with-param name="key" select="'missingTeeth'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Payee">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--provider 0..1 Reference--><xsl:apply-templates select="*[@key = 'provider']" mode="Reference">
                  <xsl:with-param name="key" select="'provider'"/>
               </xsl:apply-templates>
                    <!--organization 0..1 Reference--><xsl:apply-templates select="*[@key = 'organization']" mode="Reference">
                  <xsl:with-param name="key" select="'organization'"/>
               </xsl:apply-templates>
                    <!--person 0..1 Reference--><xsl:apply-templates select="*[@key = 'person']" mode="Reference">
                  <xsl:with-param name="key" select="'person'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Diagnosis">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--diagnosis 1..1 Coding--><xsl:apply-templates select="*[@key = 'diagnosis']" mode="Coding">
                  <xsl:with-param name="key" select="'diagnosis'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Coverage">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--focal 1..1 boolean--><xsl:apply-templates select="*[@key = 'focal']" mode="boolean">
                  <xsl:with-param name="key" select="'focal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'focal'])][*[@key = '_focal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="focal"/>
                        <xsl:copy-of select="fn:map[@key = '_focal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'focal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--coverage 1..1 Reference--><xsl:apply-templates select="*[@key = 'coverage']" mode="Reference">
                  <xsl:with-param name="key" select="'coverage'"/>
               </xsl:apply-templates>
                    <!--businessArrangement 0..1 string--><xsl:apply-templates select="*[@key = 'businessArrangement']" mode="string">
                  <xsl:with-param name="key" select="'businessArrangement'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'businessArrangement'])][*[@key = '_businessArrangement']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement"/>
                        <xsl:copy-of select="fn:map[@key = '_businessArrangement']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'businessArrangement'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--relationship 1..1 Coding--><xsl:apply-templates select="*[@key = 'relationship']" mode="Coding">
                  <xsl:with-param name="key" select="'relationship'"/>
               </xsl:apply-templates>
                    <!--preAuthRef 0..* string--><xsl:apply-templates select="*[@key = 'preAuthRef']" mode="string">
                  <xsl:with-param name="key" select="'preAuthRef'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'preAuthRef'])][*[@key = '_preAuthRef']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="preAuthRef"/>
                        <xsl:copy-of select="fn:map[@key = '_preAuthRef']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'preAuthRef'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--claimResponse 0..1 Reference--><xsl:apply-templates select="*[@key = 'claimResponse']" mode="Reference">
                  <xsl:with-param name="key" select="'claimResponse'"/>
               </xsl:apply-templates>
                    <!--originalRuleset 0..1 Coding--><xsl:apply-templates select="*[@key = 'originalRuleset']" mode="Coding">
                  <xsl:with-param name="key" select="'originalRuleset'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Item">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 1..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--provider 0..1 Reference--><xsl:apply-templates select="*[@key = 'provider']" mode="Reference">
                  <xsl:with-param name="key" select="'provider'"/>
               </xsl:apply-templates>
                    <!--diagnosisLinkId 0..* positiveInt--><xsl:apply-templates select="*[@key = 'diagnosisLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'diagnosisLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'diagnosisLinkId'])][*[@key = '_diagnosisLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosisLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_diagnosisLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'diagnosisLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--service 1..1 Coding--><xsl:apply-templates select="*[@key = 'service']" mode="Coding">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
                    <!--serviceDate 0..1 date--><xsl:apply-templates select="*[@key = 'serviceDate']" mode="date">
                  <xsl:with-param name="key" select="'serviceDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'serviceDate'])][*[@key = '_serviceDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="serviceDate"/>
                        <xsl:copy-of select="fn:map[@key = '_serviceDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'serviceDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'quantity']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
                    <!--unitPrice 0..1 Money--><xsl:apply-templates select="*[@key = 'unitPrice']" mode="Money">
                  <xsl:with-param name="key" select="'unitPrice'"/>
               </xsl:apply-templates>
                    <!--factor 0..1 decimal--><xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--points 0..1 decimal--><xsl:apply-templates select="*[@key = 'points']" mode="decimal">
                  <xsl:with-param name="key" select="'points'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'points'])][*[@key = '_points']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="points"/>
                        <xsl:copy-of select="fn:map[@key = '_points']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'points'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--net 0..1 Money--><xsl:apply-templates select="*[@key = 'net']" mode="Money">
                  <xsl:with-param name="key" select="'net'"/>
               </xsl:apply-templates>
                    <!--udi 0..1 Coding--><xsl:apply-templates select="*[@key = 'udi']" mode="Coding">
                  <xsl:with-param name="key" select="'udi'"/>
               </xsl:apply-templates>
                    <!--bodySite 0..1 Coding--><xsl:apply-templates select="*[@key = 'bodySite']" mode="Coding">
                  <xsl:with-param name="key" select="'bodySite'"/>
               </xsl:apply-templates>
                    <!--subSite 0..* Coding--><xsl:apply-templates select="*[@key = 'subSite']" mode="Coding">
                  <xsl:with-param name="key" select="'subSite'"/>
               </xsl:apply-templates>
                    <!--modifier 0..* Coding--><xsl:apply-templates select="*[@key = 'modifier']" mode="Coding">
                  <xsl:with-param name="key" select="'modifier'"/>
               </xsl:apply-templates>
                    <!--detail 0..* Claim.Detail--><xsl:apply-templates select="*[@key = 'detail']" mode="Claim.Detail">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
                    <!--prosthesis 0..1 Claim.Prosthesis--><xsl:apply-templates select="*[@key = 'prosthesis']" mode="Claim.Prosthesis">
                  <xsl:with-param name="key" select="'prosthesis'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Detail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 1..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--service 1..1 Coding--><xsl:apply-templates select="*[@key = 'service']" mode="Coding">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
                    <!--quantity 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'quantity']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
                    <!--unitPrice 0..1 Money--><xsl:apply-templates select="*[@key = 'unitPrice']" mode="Money">
                  <xsl:with-param name="key" select="'unitPrice'"/>
               </xsl:apply-templates>
                    <!--factor 0..1 decimal--><xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--points 0..1 decimal--><xsl:apply-templates select="*[@key = 'points']" mode="decimal">
                  <xsl:with-param name="key" select="'points'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'points'])][*[@key = '_points']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="points"/>
                        <xsl:copy-of select="fn:map[@key = '_points']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'points'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--net 0..1 Money--><xsl:apply-templates select="*[@key = 'net']" mode="Money">
                  <xsl:with-param name="key" select="'net'"/>
               </xsl:apply-templates>
                    <!--udi 0..1 Coding--><xsl:apply-templates select="*[@key = 'udi']" mode="Coding">
                  <xsl:with-param name="key" select="'udi'"/>
               </xsl:apply-templates>
                    <!--subDetail 0..* Claim.SubDetail--><xsl:apply-templates select="*[@key = 'subDetail']" mode="Claim.SubDetail">
                  <xsl:with-param name="key" select="'subDetail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.SubDetail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 1..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--service 1..1 Coding--><xsl:apply-templates select="*[@key = 'service']" mode="Coding">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
                    <!--quantity 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'quantity']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
                    <!--unitPrice 0..1 Money--><xsl:apply-templates select="*[@key = 'unitPrice']" mode="Money">
                  <xsl:with-param name="key" select="'unitPrice'"/>
               </xsl:apply-templates>
                    <!--factor 0..1 decimal--><xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--points 0..1 decimal--><xsl:apply-templates select="*[@key = 'points']" mode="decimal">
                  <xsl:with-param name="key" select="'points'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'points'])][*[@key = '_points']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="points"/>
                        <xsl:copy-of select="fn:map[@key = '_points']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'points'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--net 0..1 Money--><xsl:apply-templates select="*[@key = 'net']" mode="Money">
                  <xsl:with-param name="key" select="'net'"/>
               </xsl:apply-templates>
                    <!--udi 0..1 Coding--><xsl:apply-templates select="*[@key = 'udi']" mode="Coding">
                  <xsl:with-param name="key" select="'udi'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Prosthesis">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--initial 0..1 boolean--><xsl:apply-templates select="*[@key = 'initial']" mode="boolean">
                  <xsl:with-param name="key" select="'initial'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'initial'])][*[@key = '_initial']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="initial"/>
                        <xsl:copy-of select="fn:map[@key = '_initial']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'initial'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--priorDate 0..1 date--><xsl:apply-templates select="*[@key = 'priorDate']" mode="date">
                  <xsl:with-param name="key" select="'priorDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'priorDate'])][*[@key = '_priorDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="priorDate"/>
                        <xsl:copy-of select="fn:map[@key = '_priorDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'priorDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--priorMaterial 0..1 Coding--><xsl:apply-templates select="*[@key = 'priorMaterial']" mode="Coding">
                  <xsl:with-param name="key" select="'priorMaterial'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.MissingTeeth">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--tooth 1..1 Coding--><xsl:apply-templates select="*[@key = 'tooth']" mode="Coding">
                  <xsl:with-param name="key" select="'tooth'"/>
               </xsl:apply-templates>
                    <!--reason 0..1 Coding--><xsl:apply-templates select="*[@key = 'reason']" mode="Coding">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
                    <!--extractionDate 0..1 date--><xsl:apply-templates select="*[@key = 'extractionDate']" mode="date">
                  <xsl:with-param name="key" select="'extractionDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'extractionDate'])][*[@key = '_extractionDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="extractionDate"/>
                        <xsl:copy-of select="fn:map[@key = '_extractionDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'extractionDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type or discipline-style of the claim.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Complete, proposed, exploratory, other.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Use">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--request 0..1 Reference--><xsl:apply-templates select="*[@key = 'request']" mode="Reference">
                  <xsl:with-param name="key" select="'request'"/>
               </xsl:apply-templates>
                    <!--ruleset 0..1 Coding--><xsl:apply-templates select="*[@key = 'ruleset']" mode="Coding">
                  <xsl:with-param name="key" select="'ruleset'"/>
               </xsl:apply-templates>
                    <!--originalRuleset 0..1 Coding--><xsl:apply-templates select="*[@key = 'originalRuleset']" mode="Coding">
                  <xsl:with-param name="key" select="'originalRuleset'"/>
               </xsl:apply-templates>
                    <!--created 0..1 dateTime--><xsl:apply-templates select="*[@key = 'created']" mode="dateTime">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--organization 0..1 Reference--><xsl:apply-templates select="*[@key = 'organization']" mode="Reference">
                  <xsl:with-param name="key" select="'organization'"/>
               </xsl:apply-templates>
                    <!--requestProvider 0..1 Reference--><xsl:apply-templates select="*[@key = 'requestProvider']" mode="Reference">
                  <xsl:with-param name="key" select="'requestProvider'"/>
               </xsl:apply-templates>
                    <!--requestOrganization 0..1 Reference--><xsl:apply-templates select="*[@key = 'requestOrganization']" mode="Reference">
                  <xsl:with-param name="key" select="'requestOrganization'"/>
               </xsl:apply-templates>
                    <!--outcome 0..1 code--><xsl:apply-templates select="*[@key = 'outcome']" mode="code">
                  <xsl:with-param name="key" select="'outcome'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'outcome'])][*[@key = '_outcome']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome"/>
                        <xsl:copy-of select="fn:map[@key = '_outcome']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'outcome'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--disposition 0..1 string--><xsl:apply-templates select="*[@key = 'disposition']" mode="string">
                  <xsl:with-param name="key" select="'disposition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'disposition'])][*[@key = '_disposition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition"/>
                        <xsl:copy-of select="fn:map[@key = '_disposition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'disposition'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--payeeType 0..1 Coding--><xsl:apply-templates select="*[@key = 'payeeType']" mode="Coding">
                  <xsl:with-param name="key" select="'payeeType'"/>
               </xsl:apply-templates>
                    <!--item 0..* ClaimResponse.Item--><xsl:apply-templates select="*[@key = 'item']" mode="ClaimResponse.Item">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
                    <!--addItem 0..* ClaimResponse.AddItem--><xsl:apply-templates select="*[@key = 'addItem']" mode="ClaimResponse.AddItem">
                  <xsl:with-param name="key" select="'addItem'"/>
               </xsl:apply-templates>
                    <!--error 0..* ClaimResponse.Error--><xsl:apply-templates select="*[@key = 'error']" mode="ClaimResponse.Error">
                  <xsl:with-param name="key" select="'error'"/>
               </xsl:apply-templates>
                    <!--totalCost 0..1 Money--><xsl:apply-templates select="*[@key = 'totalCost']" mode="Money">
                  <xsl:with-param name="key" select="'totalCost'"/>
               </xsl:apply-templates>
                    <!--unallocDeductable 0..1 Money--><xsl:apply-templates select="*[@key = 'unallocDeductable']" mode="Money">
                  <xsl:with-param name="key" select="'unallocDeductable'"/>
               </xsl:apply-templates>
                    <!--totalBenefit 0..1 Money--><xsl:apply-templates select="*[@key = 'totalBenefit']" mode="Money">
                  <xsl:with-param name="key" select="'totalBenefit'"/>
               </xsl:apply-templates>
                    <!--paymentAdjustment 0..1 Money--><xsl:apply-templates select="*[@key = 'paymentAdjustment']" mode="Money">
                  <xsl:with-param name="key" select="'paymentAdjustment'"/>
               </xsl:apply-templates>
                    <!--paymentAdjustmentReason 0..1 Coding--><xsl:apply-templates select="*[@key = 'paymentAdjustmentReason']" mode="Coding">
                  <xsl:with-param name="key" select="'paymentAdjustmentReason'"/>
               </xsl:apply-templates>
                    <!--paymentDate 0..1 date--><xsl:apply-templates select="*[@key = 'paymentDate']" mode="date">
                  <xsl:with-param name="key" select="'paymentDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'paymentDate'])][*[@key = '_paymentDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="paymentDate"/>
                        <xsl:copy-of select="fn:map[@key = '_paymentDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'paymentDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--paymentAmount 0..1 Money--><xsl:apply-templates select="*[@key = 'paymentAmount']" mode="Money">
                  <xsl:with-param name="key" select="'paymentAmount'"/>
               </xsl:apply-templates>
                    <!--paymentRef 0..1 Identifier--><xsl:apply-templates select="*[@key = 'paymentRef']" mode="Identifier">
                  <xsl:with-param name="key" select="'paymentRef'"/>
               </xsl:apply-templates>
                    <!--reserved 0..1 Coding--><xsl:apply-templates select="*[@key = 'reserved']" mode="Coding">
                  <xsl:with-param name="key" select="'reserved'"/>
               </xsl:apply-templates>
                    <!--form 0..1 Coding--><xsl:apply-templates select="*[@key = 'form']" mode="Coding">
                  <xsl:with-param name="key" select="'form'"/>
               </xsl:apply-templates>
                    <!--note 0..* ClaimResponse.Note--><xsl:apply-templates select="*[@key = 'note']" mode="ClaimResponse.Note">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
                    <!--coverage 0..* ClaimResponse.Coverage--><xsl:apply-templates select="*[@key = 'coverage']" mode="ClaimResponse.Coverage">
                  <xsl:with-param name="key" select="'coverage'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Item">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--noteNumber 0..* positiveInt--><xsl:apply-templates select="*[@key = 'noteNumber']" mode="positiveInt">
                  <xsl:with-param name="key" select="'noteNumber'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'noteNumber'])][*[@key = '_noteNumber']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber"/>
                        <xsl:copy-of select="fn:map[@key = '_noteNumber']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'noteNumber'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication--><xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
                    <!--detail 0..* ClaimResponse.Detail--><xsl:apply-templates select="*[@key = 'detail']" mode="ClaimResponse.Detail">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--amount 0..1 Money--><xsl:apply-templates select="*[@key = 'amount']" mode="Money">
                  <xsl:with-param name="key" select="'amount'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Detail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication1--><xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication1">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
                    <!--subDetail 0..* ClaimResponse.SubDetail--><xsl:apply-templates select="*[@key = 'subDetail']" mode="ClaimResponse.SubDetail">
                  <xsl:with-param name="key" select="'subDetail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication1">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--amount 0..1 Money--><xsl:apply-templates select="*[@key = 'amount']" mode="Money">
                  <xsl:with-param name="key" select="'amount'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.SubDetail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication2--><xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication2">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication2">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--amount 0..1 Money--><xsl:apply-templates select="*[@key = 'amount']" mode="Money">
                  <xsl:with-param name="key" select="'amount'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.AddItem">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 0..* positiveInt--><xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--service 1..1 Coding--><xsl:apply-templates select="*[@key = 'service']" mode="Coding">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
                    <!--fee 0..1 Money--><xsl:apply-templates select="*[@key = 'fee']" mode="Money">
                  <xsl:with-param name="key" select="'fee'"/>
               </xsl:apply-templates>
                    <!--noteNumberLinkId 0..* positiveInt--><xsl:apply-templates select="*[@key = 'noteNumberLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'noteNumberLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'noteNumberLinkId'])][*[@key = '_noteNumberLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumberLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_noteNumberLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'noteNumberLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication3--><xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication3">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
                    <!--detail 0..* ClaimResponse.Detail1--><xsl:apply-templates select="*[@key = 'detail']" mode="ClaimResponse.Detail1">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication3">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--amount 0..1 Money--><xsl:apply-templates select="*[@key = 'amount']" mode="Money">
                  <xsl:with-param name="key" select="'amount'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Detail1">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--service 1..1 Coding--><xsl:apply-templates select="*[@key = 'service']" mode="Coding">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
                    <!--fee 0..1 Money--><xsl:apply-templates select="*[@key = 'fee']" mode="Money">
                  <xsl:with-param name="key" select="'fee'"/>
               </xsl:apply-templates>
                    <!--adjudication 0..* ClaimResponse.Adjudication4--><xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication4">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication4">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--amount 0..1 Money--><xsl:apply-templates select="*[@key = 'amount']" mode="Money">
                  <xsl:with-param name="key" select="'amount'"/>
               </xsl:apply-templates>
                    <!--value 0..1 decimal--><xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Error">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 0..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--detailSequenceLinkId 0..1 positiveInt--><xsl:apply-templates select="*[@key = 'detailSequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'detailSequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'detailSequenceLinkId'])][*[@key = '_detailSequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="detailSequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_detailSequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'detailSequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--subdetailSequenceLinkId 0..1 positiveInt--><xsl:apply-templates select="*[@key = 'subdetailSequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'subdetailSequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'subdetailSequenceLinkId'])][*[@key = '_subdetailSequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="subdetailSequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_subdetailSequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'subdetailSequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 1..1 Coding--><xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Note">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--number 0..1 positiveInt--><xsl:apply-templates select="*[@key = 'number']" mode="positiveInt">
                  <xsl:with-param name="key" select="'number'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'number'])][*[@key = '_number']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="number"/>
                        <xsl:copy-of select="fn:map[@key = '_number']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'number'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 0..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--text 0..1 string--><xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Coverage">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--focal 1..1 boolean--><xsl:apply-templates select="*[@key = 'focal']" mode="boolean">
                  <xsl:with-param name="key" select="'focal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'focal'])][*[@key = '_focal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="focal"/>
                        <xsl:copy-of select="fn:map[@key = '_focal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'focal'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--coverage 1..1 Reference--><xsl:apply-templates select="*[@key = 'coverage']" mode="Reference">
                  <xsl:with-param name="key" select="'coverage'"/>
               </xsl:apply-templates>
                    <!--businessArrangement 0..1 string--><xsl:apply-templates select="*[@key = 'businessArrangement']" mode="string">
                  <xsl:with-param name="key" select="'businessArrangement'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'businessArrangement'])][*[@key = '_businessArrangement']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement"/>
                        <xsl:copy-of select="fn:map[@key = '_businessArrangement']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'businessArrangement'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--relationship 1..1 Coding--><xsl:apply-templates select="*[@key = 'relationship']" mode="Coding">
                  <xsl:with-param name="key" select="'relationship'"/>
               </xsl:apply-templates>
                    <!--preAuthRef 0..* string--><xsl:apply-templates select="*[@key = 'preAuthRef']" mode="string">
                  <xsl:with-param name="key" select="'preAuthRef'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'preAuthRef'])][*[@key = '_preAuthRef']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="preAuthRef"/>
                        <xsl:copy-of select="fn:map[@key = '_preAuthRef']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'preAuthRef'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--claimResponse 0..1 Reference--><xsl:apply-templates select="*[@key = 'claimResponse']" mode="Reference">
                  <xsl:with-param name="key" select="'claimResponse'"/>
               </xsl:apply-templates>
                    <!--originalRuleset 0..1 Coding--><xsl:apply-templates select="*[@key = 'originalRuleset']" mode="Coding">
                  <xsl:with-param name="key" select="'originalRuleset'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--patient 1..1 Reference--><xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
                    <!--assessor 0..1 Reference--><xsl:apply-templates select="*[@key = 'assessor']" mode="Reference">
                  <xsl:with-param name="key" select="'assessor'"/>
               </xsl:apply-templates>
                    <!--status 1..1 ClinicalImpressionStatus--><xsl:apply-templates select="*[@key = 'status']" mode="ClinicalImpressionStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ClinicalImpressionStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--date 0..1 dateTime--><xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--previous 0..1 Reference--><xsl:apply-templates select="*[@key = 'previous']" mode="Reference">
                  <xsl:with-param name="key" select="'previous'"/>
               </xsl:apply-templates>
                    <!--problem 0..* Reference--><xsl:apply-templates select="*[@key = 'problem']" mode="Reference">
                  <xsl:with-param name="key" select="'problem'"/>
               </xsl:apply-templates>
                    
                        
                        <!--triggerCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'triggerCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'triggerCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--triggerReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'triggerReference']" mode="Reference">
                  <xsl:with-param name="key" select="'triggerReference'"/>
               </xsl:apply-templates>
                    
                    <!--investigations 0..* ClinicalImpression.Investigations--><xsl:apply-templates select="*[@key = 'investigations']"
                                    mode="ClinicalImpression.Investigations">
                  <xsl:with-param name="key" select="'investigations'"/>
               </xsl:apply-templates>
                    <!--protocol 0..1 uri--><xsl:apply-templates select="*[@key = 'protocol']" mode="uri">
                  <xsl:with-param name="key" select="'protocol'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'protocol'])][*[@key = '_protocol']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="protocol"/>
                        <xsl:copy-of select="fn:map[@key = '_protocol']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'protocol'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--summary 0..1 string--><xsl:apply-templates select="*[@key = 'summary']" mode="string">
                  <xsl:with-param name="key" select="'summary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'summary'])][*[@key = '_summary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="summary"/>
                        <xsl:copy-of select="fn:map[@key = '_summary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'summary'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--finding 0..* ClinicalImpression.Finding--><xsl:apply-templates select="*[@key = 'finding']" mode="ClinicalImpression.Finding">
                  <xsl:with-param name="key" select="'finding'"/>
               </xsl:apply-templates>
                    <!--resolved 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'resolved']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'resolved'"/>
               </xsl:apply-templates>
                    <!--ruledOut 0..* ClinicalImpression.RuledOut--><xsl:apply-templates select="*[@key = 'ruledOut']" mode="ClinicalImpression.RuledOut">
                  <xsl:with-param name="key" select="'ruledOut'"/>
               </xsl:apply-templates>
                    <!--prognosis 0..1 string--><xsl:apply-templates select="*[@key = 'prognosis']" mode="string">
                  <xsl:with-param name="key" select="'prognosis'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'prognosis'])][*[@key = '_prognosis']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="prognosis"/>
                        <xsl:copy-of select="fn:map[@key = '_prognosis']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'prognosis'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--plan 0..* Reference--><xsl:apply-templates select="*[@key = 'plan']" mode="Reference">
                  <xsl:with-param name="key" select="'plan'"/>
               </xsl:apply-templates>
                    <!--action 0..* Reference--><xsl:apply-templates select="*[@key = 'action']" mode="Reference">
                  <xsl:with-param name="key" select="'action'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.Investigations">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--item 0..* Reference--><xsl:apply-templates select="*[@key = 'item']" mode="Reference">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.Finding">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--item 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'item']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
                    <!--cause 0..1 string--><xsl:apply-templates select="*[@key = 'cause']" mode="string">
                  <xsl:with-param name="key" select="'cause'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'cause'])][*[@key = '_cause']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="cause"/>
                        <xsl:copy-of select="fn:map[@key = '_cause']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'cause'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.RuledOut">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--item 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'item']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
                    <!--reason 0..1 string--><xsl:apply-templates select="*[@key = 'reason']" mode="string">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'reason'])][*[@key = '_reason']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="reason"/>
                        <xsl:copy-of select="fn:map[@key = '_reason']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'reason'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The workflow state of a clinical impression.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpressionStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Communication">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--category 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
                    <!--sender 0..1 Reference--><xsl:apply-templates select="*[@key = 'sender']" mode="Reference">
                  <xsl:with-param name="key" select="'sender'"/>
               </xsl:apply-templates>
                    <!--recipient 0..* Reference--><xsl:apply-templates select="*[@key = 'recipient']" mode="Reference">
                  <xsl:with-param name="key" select="'recipient'"/>
               </xsl:apply-templates>
                    <!--payload 0..* Communication.Payload--><xsl:apply-templates select="*[@key = 'payload']" mode="Communication.Payload">
                  <xsl:with-param name="key" select="'payload'"/>
               </xsl:apply-templates>
                    <!--medium 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'medium']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'medium'"/>
               </xsl:apply-templates>
                    <!--status 0..1 CommunicationStatus--><xsl:apply-templates select="*[@key = 'status']" mode="CommunicationStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CommunicationStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
                    <!--sent 0..1 dateTime--><xsl:apply-templates select="*[@key = 'sent']" mode="dateTime">
                  <xsl:with-param name="key" select="'sent'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sent'])][*[@key = '_sent']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sent"/>
                        <xsl:copy-of select="fn:map[@key = '_sent']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'sent'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--received 0..1 dateTime--><xsl:apply-templates select="*[@key = 'received']" mode="dateTime">
                  <xsl:with-param name="key" select="'received'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'received'])][*[@key = '_received']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="received"/>
                        <xsl:copy-of select="fn:map[@key = '_received']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'received'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--reason 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'reason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
                    <!--subject 0..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--requestDetail 0..1 Reference--><xsl:apply-templates select="*[@key = 'requestDetail']" mode="Reference">
                  <xsl:with-param name="key" select="'requestDetail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Communication.Payload">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentString 1..1 string--><xsl:apply-templates select="*[@key = 'contentString']" mode="string">
                  <xsl:with-param name="key" select="'contentString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentString'])][*[@key = '_contentString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentString"/>
                        <xsl:copy-of select="fn:map[@key = '_contentString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'contentString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--contentAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'contentAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'contentAttachment'"/>
               </xsl:apply-templates>
                        <!--contentReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'contentReference']" mode="Reference">
                  <xsl:with-param name="key" select="'contentReference'"/>
               </xsl:apply-templates>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the communication.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--category 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
                    <!--sender 0..1 Reference--><xsl:apply-templates select="*[@key = 'sender']" mode="Reference">
                  <xsl:with-param name="key" select="'sender'"/>
               </xsl:apply-templates>
                    <!--recipient 0..* Reference--><xsl:apply-templates select="*[@key = 'recipient']" mode="Reference">
                  <xsl:with-param name="key" select="'recipient'"/>
               </xsl:apply-templates>
                    <!--payload 0..* CommunicationRequest.Payload--><xsl:apply-templates select="*[@key = 'payload']" mode="CommunicationRequest.Payload">
                  <xsl:with-param name="key" select="'payload'"/>
               </xsl:apply-templates>
                    <!--medium 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'medium']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'medium'"/>
               </xsl:apply-templates>
                    <!--requester 0..1 Reference--><xsl:apply-templates select="*[@key = 'requester']" mode="Reference">
                  <xsl:with-param name="key" select="'requester'"/>
               </xsl:apply-templates>
                    <!--status 0..1 CommunicationRequestStatus--><xsl:apply-templates select="*[@key = 'status']" mode="CommunicationRequestStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CommunicationRequestStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
                    
                        
                        <!--scheduledDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'scheduledDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'scheduledDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'scheduledDateTime'])][*[@key = '_scheduledDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_scheduledDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'scheduledDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--scheduledPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'scheduledPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'scheduledPeriod'"/>
               </xsl:apply-templates>
                    
                    <!--reason 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'reason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
                    <!--requestedOn 0..1 dateTime--><xsl:apply-templates select="*[@key = 'requestedOn']" mode="dateTime">
                  <xsl:with-param name="key" select="'requestedOn'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requestedOn'])][*[@key = '_requestedOn']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requestedOn"/>
                        <xsl:copy-of select="fn:map[@key = '_requestedOn']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'requestedOn'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--subject 0..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--priority 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'priority']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest.Payload">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentString 1..1 string--><xsl:apply-templates select="*[@key = 'contentString']" mode="string">
                  <xsl:with-param name="key" select="'contentString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentString'])][*[@key = '_contentString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentString"/>
                        <xsl:copy-of select="fn:map[@key = '_contentString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'contentString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--contentAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'contentAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'contentAttachment'"/>
               </xsl:apply-templates>
                        <!--contentReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'contentReference']" mode="Reference">
                  <xsl:with-param name="key" select="'contentReference'"/>
               </xsl:apply-templates>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the communication.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequestStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--date 1..1 dateTime--><xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--class 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'class']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'class'"/>
               </xsl:apply-templates>
                    <!--title 1..1 string--><xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--status 1..1 CompositionStatus--><xsl:apply-templates select="*[@key = 'status']" mode="CompositionStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CompositionStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--confidentiality 0..1 code--><xsl:apply-templates select="*[@key = 'confidentiality']" mode="code">
                  <xsl:with-param name="key" select="'confidentiality'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'confidentiality'])][*[@key = '_confidentiality']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="confidentiality"/>
                        <xsl:copy-of select="fn:map[@key = '_confidentiality']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'confidentiality'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--subject 1..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--author 1..* Reference--><xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
                    <!--attester 0..* Composition.Attester--><xsl:apply-templates select="*[@key = 'attester']" mode="Composition.Attester">
                  <xsl:with-param name="key" select="'attester'"/>
               </xsl:apply-templates>
                    <!--custodian 0..1 Reference--><xsl:apply-templates select="*[@key = 'custodian']" mode="Reference">
                  <xsl:with-param name="key" select="'custodian'"/>
               </xsl:apply-templates>
                    <!--event 0..* Composition.Event--><xsl:apply-templates select="*[@key = 'event']" mode="Composition.Event">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
                    <!--encounter 0..1 Reference--><xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
                    <!--section 0..* Composition.Section--><xsl:apply-templates select="*[@key = 'section']" mode="Composition.Section">
                  <xsl:with-param name="key" select="'section'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Attester">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--mode 1..* CompositionAttestationMode--><xsl:apply-templates select="*[@key = 'mode']" mode="CompositionAttestationMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CompositionAttestationMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--time 0..1 dateTime--><xsl:apply-templates select="*[@key = 'time']" mode="dateTime">
                  <xsl:with-param name="key" select="'time'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'time'])][*[@key = '_time']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="time"/>
                        <xsl:copy-of select="fn:map[@key = '_time']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'time'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--party 0..1 Reference--><xsl:apply-templates select="*[@key = 'party']" mode="Reference">
                  <xsl:with-param name="key" select="'party'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Event">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--period 0..1 Period--><xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
                    <!--detail 0..* Reference--><xsl:apply-templates select="*[@key = 'detail']" mode="Reference">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Section">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--title 0..1 string--><xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--text 0..1 Narrative--><xsl:apply-templates select="*[@key = 'text']" mode="Narrative">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
                    <!--mode 0..1 code--><xsl:apply-templates select="*[@key = 'mode']" mode="code">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--orderedBy 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'orderedBy']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'orderedBy'"/>
               </xsl:apply-templates>
                    <!--entry 0..* Reference--><xsl:apply-templates select="*[@key = 'entry']" mode="Reference">
                  <xsl:with-param name="key" select="'entry'"/>
               </xsl:apply-templates>
                    <!--emptyReason 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'emptyReason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'emptyReason'"/>
               </xsl:apply-templates>
                    <!--section 0..* Composition.Section--><xsl:apply-templates select="*[@key = 'section']" mode="Composition.Section">
                  <xsl:with-param name="key" select="'section'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The workflow/clinical status of the composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CompositionStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The way in which a person authenticated a composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CompositionAttestationMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--url 0..1 uri--><xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--version 0..1 string--><xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--status 1..1 code--><xsl:apply-templates select="*[@key = 'status']" mode="code">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--experimental 0..1 boolean--><xsl:apply-templates select="*[@key = 'experimental']" mode="boolean">
                  <xsl:with-param name="key" select="'experimental'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'experimental'])][*[@key = '_experimental']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="experimental"/>
                        <xsl:copy-of select="fn:map[@key = '_experimental']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'experimental'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--publisher 0..1 string--><xsl:apply-templates select="*[@key = 'publisher']" mode="string">
                  <xsl:with-param name="key" select="'publisher'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'publisher'])][*[@key = '_publisher']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher"/>
                        <xsl:copy-of select="fn:map[@key = '_publisher']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'publisher'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--contact 0..* ConceptMap.Contact--><xsl:apply-templates select="*[@key = 'contact']" mode="ConceptMap.Contact">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
                    <!--date 0..1 dateTime--><xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--useContext 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'useContext']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'useContext'"/>
               </xsl:apply-templates>
                    <!--requirements 0..1 string--><xsl:apply-templates select="*[@key = 'requirements']" mode="string">
                  <xsl:with-param name="key" select="'requirements'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requirements'])][*[@key = '_requirements']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements"/>
                        <xsl:copy-of select="fn:map[@key = '_requirements']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'requirements'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--copyright 0..1 string--><xsl:apply-templates select="*[@key = 'copyright']" mode="string">
                  <xsl:with-param name="key" select="'copyright'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'copyright'])][*[@key = '_copyright']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright"/>
                        <xsl:copy-of select="fn:map[@key = '_copyright']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'copyright'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                        
                        <!--sourceUri 1..1 uri--><xsl:apply-templates select="*[@key = 'sourceUri']" mode="uri">
                  <xsl:with-param name="key" select="'sourceUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sourceUri'])][*[@key = '_sourceUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sourceUri"/>
                        <xsl:copy-of select="fn:map[@key = '_sourceUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'sourceUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--sourceReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'sourceReference']" mode="Reference">
                  <xsl:with-param name="key" select="'sourceReference'"/>
               </xsl:apply-templates>
                    
                    
                        
                        <!--targetUri 1..1 uri--><xsl:apply-templates select="*[@key = 'targetUri']" mode="uri">
                  <xsl:with-param name="key" select="'targetUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'targetUri'])][*[@key = '_targetUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetUri"/>
                        <xsl:copy-of select="fn:map[@key = '_targetUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'targetUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--targetReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'targetReference']" mode="Reference">
                  <xsl:with-param name="key" select="'targetReference'"/>
               </xsl:apply-templates>
                    
                    <!--element 0..* ConceptMap.Element--><xsl:apply-templates select="*[@key = 'element']" mode="ConceptMap.Element">
                  <xsl:with-param name="key" select="'element'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Contact">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:apply-templates select="*[@key = 'telecom']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'telecom'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Element">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--codeSystem 0..1 uri--><xsl:apply-templates select="*[@key = 'codeSystem']" mode="uri">
                  <xsl:with-param name="key" select="'codeSystem'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'codeSystem'])][*[@key = '_codeSystem']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="codeSystem"/>
                        <xsl:copy-of select="fn:map[@key = '_codeSystem']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'codeSystem'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--target 0..* ConceptMap.Target--><xsl:apply-templates select="*[@key = 'target']" mode="ConceptMap.Target">
                  <xsl:with-param name="key" select="'target'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Target">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--codeSystem 0..1 uri--><xsl:apply-templates select="*[@key = 'codeSystem']" mode="uri">
                  <xsl:with-param name="key" select="'codeSystem'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'codeSystem'])][*[@key = '_codeSystem']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="codeSystem"/>
                        <xsl:copy-of select="fn:map[@key = '_codeSystem']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'codeSystem'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 0..1 code--><xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--equivalence 1..1 code--><xsl:apply-templates select="*[@key = 'equivalence']" mode="code">
                  <xsl:with-param name="key" select="'equivalence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'equivalence'])][*[@key = '_equivalence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="equivalence"/>
                        <xsl:copy-of select="fn:map[@key = '_equivalence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'equivalence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comments 0..1 string--><xsl:apply-templates select="*[@key = 'comments']" mode="string">
                  <xsl:with-param name="key" select="'comments'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comments'])][*[@key = '_comments']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comments"/>
                        <xsl:copy-of select="fn:map[@key = '_comments']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comments'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--dependsOn 0..* ConceptMap.DependsOn--><xsl:apply-templates select="*[@key = 'dependsOn']" mode="ConceptMap.DependsOn">
                  <xsl:with-param name="key" select="'dependsOn'"/>
               </xsl:apply-templates>
                    <!--product 0..* ConceptMap.DependsOn--><xsl:apply-templates select="*[@key = 'product']" mode="ConceptMap.DependsOn">
                  <xsl:with-param name="key" select="'product'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.DependsOn">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--element 1..1 uri--><xsl:apply-templates select="*[@key = 'element']" mode="uri">
                  <xsl:with-param name="key" select="'element'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'element'])][*[@key = '_element']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="element"/>
                        <xsl:copy-of select="fn:map[@key = '_element']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'element'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--codeSystem 1..1 uri--><xsl:apply-templates select="*[@key = 'codeSystem']" mode="uri">
                  <xsl:with-param name="key" select="'codeSystem'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'codeSystem'])][*[@key = '_codeSystem']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="codeSystem"/>
                        <xsl:copy-of select="fn:map[@key = '_codeSystem']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'codeSystem'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 1..1 string--><xsl:apply-templates select="*[@key = 'code']" mode="string">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Use to record detailed information about conditions, problems or diagnoses recognized by a clinician. There are many uses including: recording a diagnosis during an encounter; populating a problem list or a summary statement, such as a discharge summary.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Condition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--patient 1..1 Reference--><xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
                    <!--encounter 0..1 Reference--><xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
                    <!--asserter 0..1 Reference--><xsl:apply-templates select="*[@key = 'asserter']" mode="Reference">
                  <xsl:with-param name="key" select="'asserter'"/>
               </xsl:apply-templates>
                    <!--dateRecorded 0..1 date--><xsl:apply-templates select="*[@key = 'dateRecorded']" mode="date">
                  <xsl:with-param name="key" select="'dateRecorded'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'dateRecorded'])][*[@key = '_dateRecorded']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateRecorded"/>
                        <xsl:copy-of select="fn:map[@key = '_dateRecorded']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'dateRecorded'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--code 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--category 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
                    <!--clinicalStatus 0..1 code--><xsl:apply-templates select="*[@key = 'clinicalStatus']" mode="code">
                  <xsl:with-param name="key" select="'clinicalStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'clinicalStatus'])][*[@key = '_clinicalStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="clinicalStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_clinicalStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'clinicalStatus'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--verificationStatus 1..1 ConditionVerificationStatus--><xsl:apply-templates select="*[@key = 'verificationStatus']"
                                    mode="ConditionVerificationStatus">
                  <xsl:with-param name="key" select="'verificationStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'verificationStatus'])][*[@key = '_verificationStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="verificationStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_verificationStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConditionVerificationStatus">
                     <xsl:with-param name="key" select="'verificationStatus'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--severity 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'severity']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'severity'"/>
               </xsl:apply-templates>
                    
                        
                        <!--onsetDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'onsetDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'onsetDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onsetDateTime'])][*[@key = '_onsetDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_onsetDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'onsetDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--onsetQuantity 1..1 Age--><xsl:apply-templates select="*[@key = 'onsetQuantity']" mode="Age">
                  <xsl:with-param name="key" select="'onsetQuantity'"/>
               </xsl:apply-templates>
                        <!--onsetPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'onsetPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'onsetPeriod'"/>
               </xsl:apply-templates>
                        <!--onsetRange 1..1 Range--><xsl:apply-templates select="*[@key = 'onsetRange']" mode="Range">
                  <xsl:with-param name="key" select="'onsetRange'"/>
               </xsl:apply-templates>
                        <!--onsetString 1..1 string--><xsl:apply-templates select="*[@key = 'onsetString']" mode="string">
                  <xsl:with-param name="key" select="'onsetString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onsetString'])][*[@key = '_onsetString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetString"/>
                        <xsl:copy-of select="fn:map[@key = '_onsetString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'onsetString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                    
                        
                        <!--abatementDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'abatementDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'abatementDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'abatementDateTime'])][*[@key = '_abatementDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="abatementDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_abatementDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'abatementDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--abatementQuantity 1..1 Age--><xsl:apply-templates select="*[@key = 'abatementQuantity']" mode="Age">
                  <xsl:with-param name="key" select="'abatementQuantity'"/>
               </xsl:apply-templates>
                        <!--abatementBoolean 1..1 boolean--><xsl:apply-templates select="*[@key = 'abatementBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'abatementBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'abatementBoolean'])][*[@key = '_abatementBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="abatementBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_abatementBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'abatementBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--abatementPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'abatementPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'abatementPeriod'"/>
               </xsl:apply-templates>
                        <!--abatementRange 1..1 Range--><xsl:apply-templates select="*[@key = 'abatementRange']" mode="Range">
                  <xsl:with-param name="key" select="'abatementRange'"/>
               </xsl:apply-templates>
                        <!--abatementString 1..1 string--><xsl:apply-templates select="*[@key = 'abatementString']" mode="string">
                  <xsl:with-param name="key" select="'abatementString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'abatementString'])][*[@key = '_abatementString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="abatementString"/>
                        <xsl:copy-of select="fn:map[@key = '_abatementString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'abatementString'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                    <!--stage 0..1 Condition.Stage--><xsl:apply-templates select="*[@key = 'stage']" mode="Condition.Stage">
                  <xsl:with-param name="key" select="'stage'"/>
               </xsl:apply-templates>
                    <!--evidence 0..* Condition.Evidence--><xsl:apply-templates select="*[@key = 'evidence']" mode="Condition.Evidence">
                  <xsl:with-param name="key" select="'evidence'"/>
               </xsl:apply-templates>
                    <!--bodySite 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'bodySite']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'bodySite'"/>
               </xsl:apply-templates>
                    <!--notes 0..1 string--><xsl:apply-templates select="*[@key = 'notes']" mode="string">
                  <xsl:with-param name="key" select="'notes'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'notes'])][*[@key = '_notes']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="notes"/>
                        <xsl:copy-of select="fn:map[@key = '_notes']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'notes'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use to record detailed information about conditions, problems or diagnoses recognized by a clinician. There are many uses including: recording a diagnosis during an encounter; populating a problem list or a summary statement, such as a discharge summary.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Condition.Stage">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--summary 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'summary']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'summary'"/>
               </xsl:apply-templates>
                    <!--assessment 0..* Reference--><xsl:apply-templates select="*[@key = 'assessment']" mode="Reference">
                  <xsl:with-param name="key" select="'assessment'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use to record detailed information about conditions, problems or diagnoses recognized by a clinician. There are many uses including: recording a diagnosis during an encounter; populating a problem list or a summary statement, such as a discharge summary.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Condition.Evidence">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--detail 0..* Reference--><xsl:apply-templates select="*[@key = 'detail']" mode="Reference">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The verification status to support or decline the clinical status of the condition or diagnosis.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConditionVerificationStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--url 0..1 uri--><xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--version 0..1 string--><xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--status 0..1 code--><xsl:apply-templates select="*[@key = 'status']" mode="code">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--experimental 0..1 boolean--><xsl:apply-templates select="*[@key = 'experimental']" mode="boolean">
                  <xsl:with-param name="key" select="'experimental'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'experimental'])][*[@key = '_experimental']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="experimental"/>
                        <xsl:copy-of select="fn:map[@key = '_experimental']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'experimental'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--publisher 0..1 string--><xsl:apply-templates select="*[@key = 'publisher']" mode="string">
                  <xsl:with-param name="key" select="'publisher'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'publisher'])][*[@key = '_publisher']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher"/>
                        <xsl:copy-of select="fn:map[@key = '_publisher']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'publisher'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--contact 0..* Conformance.Contact--><xsl:apply-templates select="*[@key = 'contact']" mode="Conformance.Contact">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
                    <!--date 1..1 dateTime--><xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--requirements 0..1 string--><xsl:apply-templates select="*[@key = 'requirements']" mode="string">
                  <xsl:with-param name="key" select="'requirements'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requirements'])][*[@key = '_requirements']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements"/>
                        <xsl:copy-of select="fn:map[@key = '_requirements']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'requirements'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--copyright 0..1 string--><xsl:apply-templates select="*[@key = 'copyright']" mode="string">
                  <xsl:with-param name="key" select="'copyright'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'copyright'])][*[@key = '_copyright']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright"/>
                        <xsl:copy-of select="fn:map[@key = '_copyright']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'copyright'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--kind 1..1 ConformanceStatementKind--><xsl:apply-templates select="*[@key = 'kind']" mode="ConformanceStatementKind">
                  <xsl:with-param name="key" select="'kind'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'kind'])][*[@key = '_kind']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="kind"/>
                        <xsl:copy-of select="fn:map[@key = '_kind']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConformanceStatementKind">
                     <xsl:with-param name="key" select="'kind'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--software 0..1 Conformance.Software--><xsl:apply-templates select="*[@key = 'software']" mode="Conformance.Software">
                  <xsl:with-param name="key" select="'software'"/>
               </xsl:apply-templates>
                    <!--implementation 0..1 Conformance.Implementation--><xsl:apply-templates select="*[@key = 'implementation']" mode="Conformance.Implementation">
                  <xsl:with-param name="key" select="'implementation'"/>
               </xsl:apply-templates>
                    <!--fhirVersion 1..1 id--><xsl:apply-templates select="*[@key = 'fhirVersion']" mode="id">
                  <xsl:with-param name="key" select="'fhirVersion'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fhirVersion'])][*[@key = '_fhirVersion']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fhirVersion"/>
                        <xsl:copy-of select="fn:map[@key = '_fhirVersion']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'fhirVersion'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--acceptUnknown 1..1 UnknownContentCode--><xsl:apply-templates select="*[@key = 'acceptUnknown']" mode="UnknownContentCode">
                  <xsl:with-param name="key" select="'acceptUnknown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'acceptUnknown'])][*[@key = '_acceptUnknown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="acceptUnknown"/>
                        <xsl:copy-of select="fn:map[@key = '_acceptUnknown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="UnknownContentCode">
                     <xsl:with-param name="key" select="'acceptUnknown'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--format 1..* code--><xsl:apply-templates select="*[@key = 'format']" mode="code">
                  <xsl:with-param name="key" select="'format'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'format'])][*[@key = '_format']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="format"/>
                        <xsl:copy-of select="fn:map[@key = '_format']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'format'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--profile 0..* Reference--><xsl:apply-templates select="*[@key = 'profile']" mode="Reference">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
                    <!--rest 0..* Conformance.Rest--><xsl:apply-templates select="*[@key = 'rest']" mode="Conformance.Rest">
                  <xsl:with-param name="key" select="'rest'"/>
               </xsl:apply-templates>
                    <!--messaging 0..* Conformance.Messaging--><xsl:apply-templates select="*[@key = 'messaging']" mode="Conformance.Messaging">
                  <xsl:with-param name="key" select="'messaging'"/>
               </xsl:apply-templates>
                    <!--document 0..* Conformance.Document--><xsl:apply-templates select="*[@key = 'document']" mode="Conformance.Document">
                  <xsl:with-param name="key" select="'document'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Contact">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:apply-templates select="*[@key = 'telecom']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'telecom'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Software">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 1..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--version 0..1 string--><xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--releaseDate 0..1 dateTime--><xsl:apply-templates select="*[@key = 'releaseDate']" mode="dateTime">
                  <xsl:with-param name="key" select="'releaseDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'releaseDate'])][*[@key = '_releaseDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="releaseDate"/>
                        <xsl:copy-of select="fn:map[@key = '_releaseDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'releaseDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Implementation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--description 1..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--url 0..1 uri--><xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Rest">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--mode 1..1 RestfulConformanceMode--><xsl:apply-templates select="*[@key = 'mode']" mode="RestfulConformanceMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="RestfulConformanceMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--documentation 0..1 string--><xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--security 0..1 Conformance.Security--><xsl:apply-templates select="*[@key = 'security']" mode="Conformance.Security">
                  <xsl:with-param name="key" select="'security'"/>
               </xsl:apply-templates>
                    <!--resource 1..* Conformance.Resource--><xsl:apply-templates select="*[@key = 'resource']" mode="Conformance.Resource">
                  <xsl:with-param name="key" select="'resource'"/>
               </xsl:apply-templates>
                    <!--interaction 0..* Conformance.Interaction1--><xsl:apply-templates select="*[@key = 'interaction']" mode="Conformance.Interaction1">
                  <xsl:with-param name="key" select="'interaction'"/>
               </xsl:apply-templates>
                    <!--transactionMode 0..1 TransactionMode--><xsl:apply-templates select="*[@key = 'transactionMode']" mode="TransactionMode">
                  <xsl:with-param name="key" select="'transactionMode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'transactionMode'])][*[@key = '_transactionMode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="transactionMode"/>
                        <xsl:copy-of select="fn:map[@key = '_transactionMode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="TransactionMode">
                     <xsl:with-param name="key" select="'transactionMode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--searchParam 0..* Conformance.SearchParam--><xsl:apply-templates select="*[@key = 'searchParam']" mode="Conformance.SearchParam">
                  <xsl:with-param name="key" select="'searchParam'"/>
               </xsl:apply-templates>
                    <!--operation 0..* Conformance.Operation--><xsl:apply-templates select="*[@key = 'operation']" mode="Conformance.Operation">
                  <xsl:with-param name="key" select="'operation'"/>
               </xsl:apply-templates>
                    <!--compartment 0..* uri--><xsl:apply-templates select="*[@key = 'compartment']" mode="uri">
                  <xsl:with-param name="key" select="'compartment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'compartment'])][*[@key = '_compartment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="compartment"/>
                        <xsl:copy-of select="fn:map[@key = '_compartment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'compartment'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Security">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--cors 0..1 boolean--><xsl:apply-templates select="*[@key = 'cors']" mode="boolean">
                  <xsl:with-param name="key" select="'cors'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'cors'])][*[@key = '_cors']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="cors"/>
                        <xsl:copy-of select="fn:map[@key = '_cors']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'cors'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--service 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'service']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--certificate 0..* Conformance.Certificate--><xsl:apply-templates select="*[@key = 'certificate']" mode="Conformance.Certificate">
                  <xsl:with-param name="key" select="'certificate'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Certificate">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..1 code--><xsl:apply-templates select="*[@key = 'type']" mode="code">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--blob 0..1 base64Binary--><xsl:apply-templates select="*[@key = 'blob']" mode="base64Binary">
                  <xsl:with-param name="key" select="'blob'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'blob'])][*[@key = '_blob']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="blob"/>
                        <xsl:copy-of select="fn:map[@key = '_blob']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'blob'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Resource">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 code--><xsl:apply-templates select="*[@key = 'type']" mode="code">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--profile 0..1 Reference--><xsl:apply-templates select="*[@key = 'profile']" mode="Reference">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
                    <!--interaction 1..* Conformance.Interaction--><xsl:apply-templates select="*[@key = 'interaction']" mode="Conformance.Interaction">
                  <xsl:with-param name="key" select="'interaction'"/>
               </xsl:apply-templates>
                    <!--versioning 0..1 ResourceVersionPolicy--><xsl:apply-templates select="*[@key = 'versioning']" mode="ResourceVersionPolicy">
                  <xsl:with-param name="key" select="'versioning'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'versioning'])][*[@key = '_versioning']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="versioning"/>
                        <xsl:copy-of select="fn:map[@key = '_versioning']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ResourceVersionPolicy">
                     <xsl:with-param name="key" select="'versioning'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--readHistory 0..1 boolean--><xsl:apply-templates select="*[@key = 'readHistory']" mode="boolean">
                  <xsl:with-param name="key" select="'readHistory'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'readHistory'])][*[@key = '_readHistory']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="readHistory"/>
                        <xsl:copy-of select="fn:map[@key = '_readHistory']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'readHistory'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--updateCreate 0..1 boolean--><xsl:apply-templates select="*[@key = 'updateCreate']" mode="boolean">
                  <xsl:with-param name="key" select="'updateCreate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'updateCreate'])][*[@key = '_updateCreate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="updateCreate"/>
                        <xsl:copy-of select="fn:map[@key = '_updateCreate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'updateCreate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--conditionalCreate 0..1 boolean--><xsl:apply-templates select="*[@key = 'conditionalCreate']" mode="boolean">
                  <xsl:with-param name="key" select="'conditionalCreate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'conditionalCreate'])][*[@key = '_conditionalCreate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalCreate"/>
                        <xsl:copy-of select="fn:map[@key = '_conditionalCreate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'conditionalCreate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--conditionalUpdate 0..1 boolean--><xsl:apply-templates select="*[@key = 'conditionalUpdate']" mode="boolean">
                  <xsl:with-param name="key" select="'conditionalUpdate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'conditionalUpdate'])][*[@key = '_conditionalUpdate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalUpdate"/>
                        <xsl:copy-of select="fn:map[@key = '_conditionalUpdate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'conditionalUpdate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--conditionalDelete 0..1 ConditionalDeleteStatus--><xsl:apply-templates select="*[@key = 'conditionalDelete']" mode="ConditionalDeleteStatus">
                  <xsl:with-param name="key" select="'conditionalDelete'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'conditionalDelete'])][*[@key = '_conditionalDelete']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalDelete"/>
                        <xsl:copy-of select="fn:map[@key = '_conditionalDelete']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConditionalDeleteStatus">
                     <xsl:with-param name="key" select="'conditionalDelete'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--searchInclude 0..* string--><xsl:apply-templates select="*[@key = 'searchInclude']" mode="string">
                  <xsl:with-param name="key" select="'searchInclude'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'searchInclude'])][*[@key = '_searchInclude']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="searchInclude"/>
                        <xsl:copy-of select="fn:map[@key = '_searchInclude']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'searchInclude'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--searchRevInclude 0..* string--><xsl:apply-templates select="*[@key = 'searchRevInclude']" mode="string">
                  <xsl:with-param name="key" select="'searchRevInclude'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'searchRevInclude'])][*[@key = '_searchRevInclude']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="searchRevInclude"/>
                        <xsl:copy-of select="fn:map[@key = '_searchRevInclude']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'searchRevInclude'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--searchParam 0..* Conformance.SearchParam--><xsl:apply-templates select="*[@key = 'searchParam']" mode="Conformance.SearchParam">
                  <xsl:with-param name="key" select="'searchParam'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Interaction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 TypeRestfulInteraction--><xsl:apply-templates select="*[@key = 'code']" mode="TypeRestfulInteraction">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="TypeRestfulInteraction">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--documentation 0..1 string--><xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.SearchParam">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 1..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--definition 0..1 uri--><xsl:apply-templates select="*[@key = 'definition']" mode="uri">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'definition'])][*[@key = '_definition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition"/>
                        <xsl:copy-of select="fn:map[@key = '_definition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'definition'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--type 1..1 code--><xsl:apply-templates select="*[@key = 'type']" mode="code">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--documentation 0..1 string--><xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--target 0..* code--><xsl:apply-templates select="*[@key = 'target']" mode="code">
                  <xsl:with-param name="key" select="'target'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'target'])][*[@key = '_target']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="target"/>
                        <xsl:copy-of select="fn:map[@key = '_target']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'target'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--modifier 0..* SearchModifierCode--><xsl:apply-templates select="*[@key = 'modifier']" mode="SearchModifierCode">
                  <xsl:with-param name="key" select="'modifier'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'modifier'])][*[@key = '_modifier']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="modifier"/>
                        <xsl:copy-of select="fn:map[@key = '_modifier']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SearchModifierCode">
                     <xsl:with-param name="key" select="'modifier'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--chain 0..* string--><xsl:apply-templates select="*[@key = 'chain']" mode="string">
                  <xsl:with-param name="key" select="'chain'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'chain'])][*[@key = '_chain']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="chain"/>
                        <xsl:copy-of select="fn:map[@key = '_chain']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'chain'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Interaction1">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 SystemRestfulInteraction--><xsl:apply-templates select="*[@key = 'code']" mode="SystemRestfulInteraction">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SystemRestfulInteraction">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--documentation 0..1 string--><xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Operation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 1..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--definition 1..1 Reference--><xsl:apply-templates select="*[@key = 'definition']" mode="Reference">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Messaging">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--endpoint 0..* Conformance.Endpoint--><xsl:apply-templates select="*[@key = 'endpoint']" mode="Conformance.Endpoint">
                  <xsl:with-param name="key" select="'endpoint'"/>
               </xsl:apply-templates>
                    <!--reliableCache 0..1 unsignedInt--><xsl:apply-templates select="*[@key = 'reliableCache']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'reliableCache'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'reliableCache'])][*[@key = '_reliableCache']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="reliableCache"/>
                        <xsl:copy-of select="fn:map[@key = '_reliableCache']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'reliableCache'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--documentation 0..1 string--><xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--event 1..* Conformance.Event--><xsl:apply-templates select="*[@key = 'event']" mode="Conformance.Event">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Endpoint">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--protocol 1..1 Coding--><xsl:apply-templates select="*[@key = 'protocol']" mode="Coding">
                  <xsl:with-param name="key" select="'protocol'"/>
               </xsl:apply-templates>
                    <!--address 1..1 uri--><xsl:apply-templates select="*[@key = 'address']" mode="uri">
                  <xsl:with-param name="key" select="'address'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'address'])][*[@key = '_address']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="address"/>
                        <xsl:copy-of select="fn:map[@key = '_address']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'address'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Event">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--category 0..1 MessageSignificanceCategory--><xsl:apply-templates select="*[@key = 'category']" mode="MessageSignificanceCategory">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'category'])][*[@key = '_category']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="category"/>
                        <xsl:copy-of select="fn:map[@key = '_category']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="MessageSignificanceCategory">
                     <xsl:with-param name="key" select="'category'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--mode 1..1 ConformanceEventMode--><xsl:apply-templates select="*[@key = 'mode']" mode="ConformanceEventMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConformanceEventMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--focus 1..1 code--><xsl:apply-templates select="*[@key = 'focus']" mode="code">
                  <xsl:with-param name="key" select="'focus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'focus'])][*[@key = '_focus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="focus"/>
                        <xsl:copy-of select="fn:map[@key = '_focus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'focus'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--request 1..1 Reference--><xsl:apply-templates select="*[@key = 'request']" mode="Reference">
                  <xsl:with-param name="key" select="'request'"/>
               </xsl:apply-templates>
                    <!--response 1..1 Reference--><xsl:apply-templates select="*[@key = 'response']" mode="Reference">
                  <xsl:with-param name="key" select="'response'"/>
               </xsl:apply-templates>
                    <!--documentation 0..1 string--><xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Document">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--mode 1..1 DocumentMode--><xsl:apply-templates select="*[@key = 'mode']" mode="DocumentMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DocumentMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--documentation 0..1 string--><xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--profile 1..1 Reference--><xsl:apply-templates select="*[@key = 'profile']" mode="Reference">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Whether the application produces or consumes documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Operations supported by REST at the system level.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SystemRestfulInteraction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How the system supports versioning for a resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ResourceVersionPolicy">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The mode of a RESTful conformance statement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="RestfulConformanceMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Operations supported by REST at the type or instance level.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="TypeRestfulInteraction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates how the server supports conditional delete.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConditionalDeleteStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a conformance statement is intended to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConformanceStatementKind">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A supported modifier for a search parameter.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SearchModifierCode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The mode of a message conformance statement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConformanceEventMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The impact of the content of a message.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="MessageSignificanceCategory">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates whether an application accepts unknown elements or extensions when reading resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="UnknownContentCode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates how transactions are supported.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="TransactionMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--issued 0..1 dateTime--><xsl:apply-templates select="*[@key = 'issued']" mode="dateTime">
                  <xsl:with-param name="key" select="'issued'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'issued'])][*[@key = '_issued']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued"/>
                        <xsl:copy-of select="fn:map[@key = '_issued']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'issued'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--applies 0..1 Period--><xsl:apply-templates select="*[@key = 'applies']" mode="Period">
                  <xsl:with-param name="key" select="'applies'"/>
               </xsl:apply-templates>
                    <!--subject 0..* Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--authority 0..* Reference--><xsl:apply-templates select="*[@key = 'authority']" mode="Reference">
                  <xsl:with-param name="key" select="'authority'"/>
               </xsl:apply-templates>
                    <!--domain 0..* Reference--><xsl:apply-templates select="*[@key = 'domain']" mode="Reference">
                  <xsl:with-param name="key" select="'domain'"/>
               </xsl:apply-templates>
                    <!--type 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--subType 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'subType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'subType'"/>
               </xsl:apply-templates>
                    <!--action 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'action']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'action'"/>
               </xsl:apply-templates>
                    <!--actionReason 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'actionReason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'actionReason'"/>
               </xsl:apply-templates>
                    <!--actor 0..* Contract.Actor--><xsl:apply-templates select="*[@key = 'actor']" mode="Contract.Actor">
                  <xsl:with-param name="key" select="'actor'"/>
               </xsl:apply-templates>
                    <!--valuedItem 0..* Contract.ValuedItem--><xsl:apply-templates select="*[@key = 'valuedItem']" mode="Contract.ValuedItem">
                  <xsl:with-param name="key" select="'valuedItem'"/>
               </xsl:apply-templates>
                    <!--signer 0..* Contract.Signer--><xsl:apply-templates select="*[@key = 'signer']" mode="Contract.Signer">
                  <xsl:with-param name="key" select="'signer'"/>
               </xsl:apply-templates>
                    <!--term 0..* Contract.Term--><xsl:apply-templates select="*[@key = 'term']" mode="Contract.Term">
                  <xsl:with-param name="key" select="'term'"/>
               </xsl:apply-templates>
                    
                        
                        <!--bindingAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'bindingAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'bindingAttachment'"/>
               </xsl:apply-templates>
                        <!--bindingReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'bindingReference']" mode="Reference">
                  <xsl:with-param name="key" select="'bindingReference'"/>
               </xsl:apply-templates>
                    
                    <!--friendly 0..* Contract.Friendly--><xsl:apply-templates select="*[@key = 'friendly']" mode="Contract.Friendly">
                  <xsl:with-param name="key" select="'friendly'"/>
               </xsl:apply-templates>
                    <!--legal 0..* Contract.Legal--><xsl:apply-templates select="*[@key = 'legal']" mode="Contract.Legal">
                  <xsl:with-param name="key" select="'legal'"/>
               </xsl:apply-templates>
                    <!--rule 0..* Contract.Rule--><xsl:apply-templates select="*[@key = 'rule']" mode="Contract.Rule">
                  <xsl:with-param name="key" select="'rule'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Actor">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--entity 1..1 Reference--><xsl:apply-templates select="*[@key = 'entity']" mode="Reference">
                  <xsl:with-param name="key" select="'entity'"/>
               </xsl:apply-templates>
                    <!--role 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.ValuedItem">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--entityCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'entityCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'entityCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--entityReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'entityReference']" mode="Reference">
                  <xsl:with-param name="key" select="'entityReference'"/>
               </xsl:apply-templates>
                    
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--effectiveTime 0..1 dateTime--><xsl:apply-templates select="*[@key = 'effectiveTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'effectiveTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'effectiveTime'])][*[@key = '_effectiveTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveTime"/>
                        <xsl:copy-of select="fn:map[@key = '_effectiveTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'effectiveTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'quantity']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
                    <!--unitPrice 0..1 Money--><xsl:apply-templates select="*[@key = 'unitPrice']" mode="Money">
                  <xsl:with-param name="key" select="'unitPrice'"/>
               </xsl:apply-templates>
                    <!--factor 0..1 decimal--><xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--points 0..1 decimal--><xsl:apply-templates select="*[@key = 'points']" mode="decimal">
                  <xsl:with-param name="key" select="'points'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'points'])][*[@key = '_points']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="points"/>
                        <xsl:copy-of select="fn:map[@key = '_points']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'points'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--net 0..1 Money--><xsl:apply-templates select="*[@key = 'net']" mode="Money">
                  <xsl:with-param name="key" select="'net'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Signer">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--party 1..1 Reference--><xsl:apply-templates select="*[@key = 'party']" mode="Reference">
                  <xsl:with-param name="key" select="'party'"/>
               </xsl:apply-templates>
                    <!--signature 1..1 string--><xsl:apply-templates select="*[@key = 'signature']" mode="string">
                  <xsl:with-param name="key" select="'signature'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'signature'])][*[@key = '_signature']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="signature"/>
                        <xsl:copy-of select="fn:map[@key = '_signature']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'signature'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Term">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--issued 0..1 dateTime--><xsl:apply-templates select="*[@key = 'issued']" mode="dateTime">
                  <xsl:with-param name="key" select="'issued'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'issued'])][*[@key = '_issued']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued"/>
                        <xsl:copy-of select="fn:map[@key = '_issued']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'issued'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--applies 0..1 Period--><xsl:apply-templates select="*[@key = 'applies']" mode="Period">
                  <xsl:with-param name="key" select="'applies'"/>
               </xsl:apply-templates>
                    <!--type 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--subType 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'subType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'subType'"/>
               </xsl:apply-templates>
                    <!--subject 0..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--action 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'action']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'action'"/>
               </xsl:apply-templates>
                    <!--actionReason 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'actionReason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'actionReason'"/>
               </xsl:apply-templates>
                    <!--actor 0..* Contract.Actor1--><xsl:apply-templates select="*[@key = 'actor']" mode="Contract.Actor1">
                  <xsl:with-param name="key" select="'actor'"/>
               </xsl:apply-templates>
                    <!--text 0..1 string--><xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--valuedItem 0..* Contract.ValuedItem1--><xsl:apply-templates select="*[@key = 'valuedItem']" mode="Contract.ValuedItem1">
                  <xsl:with-param name="key" select="'valuedItem'"/>
               </xsl:apply-templates>
                    <!--group 0..* Contract.Term--><xsl:apply-templates select="*[@key = 'group']" mode="Contract.Term">
                  <xsl:with-param name="key" select="'group'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Actor1">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--entity 1..1 Reference--><xsl:apply-templates select="*[@key = 'entity']" mode="Reference">
                  <xsl:with-param name="key" select="'entity'"/>
               </xsl:apply-templates>
                    <!--role 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.ValuedItem1">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--entityCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'entityCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'entityCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--entityReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'entityReference']" mode="Reference">
                  <xsl:with-param name="key" select="'entityReference'"/>
               </xsl:apply-templates>
                    
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--effectiveTime 0..1 dateTime--><xsl:apply-templates select="*[@key = 'effectiveTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'effectiveTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'effectiveTime'])][*[@key = '_effectiveTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveTime"/>
                        <xsl:copy-of select="fn:map[@key = '_effectiveTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'effectiveTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:apply-templates select="*[@key = 'quantity']" mode="SimpleQuantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
                    <!--unitPrice 0..1 Money--><xsl:apply-templates select="*[@key = 'unitPrice']" mode="Money">
                  <xsl:with-param name="key" select="'unitPrice'"/>
               </xsl:apply-templates>
                    <!--factor 0..1 decimal--><xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--points 0..1 decimal--><xsl:apply-templates select="*[@key = 'points']" mode="decimal">
                  <xsl:with-param name="key" select="'points'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'points'])][*[@key = '_points']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="points"/>
                        <xsl:copy-of select="fn:map[@key = '_points']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'points'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--net 0..1 Money--><xsl:apply-templates select="*[@key = 'net']" mode="Money">
                  <xsl:with-param name="key" select="'net'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Friendly">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'contentAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'contentAttachment'"/>
               </xsl:apply-templates>
                        <!--contentReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'contentReference']" mode="Reference">
                  <xsl:with-param name="key" select="'contentReference'"/>
               </xsl:apply-templates>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Legal">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'contentAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'contentAttachment'"/>
               </xsl:apply-templates>
                        <!--contentReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'contentReference']" mode="Reference">
                  <xsl:with-param name="key" select="'contentReference'"/>
               </xsl:apply-templates>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Rule">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'contentAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'contentAttachment'"/>
               </xsl:apply-templates>
                        <!--contentReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'contentReference']" mode="Reference">
                  <xsl:with-param name="key" select="'contentReference'"/>
               </xsl:apply-templates>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Financial instrument which may be used to pay for or reimburse health care products and services.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Coverage">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--issuer 0..1 Reference--><xsl:apply-templates select="*[@key = 'issuer']" mode="Reference">
                  <xsl:with-param name="key" select="'issuer'"/>
               </xsl:apply-templates>
                    <!--bin 0..1 Identifier--><xsl:apply-templates select="*[@key = 'bin']" mode="Identifier">
                  <xsl:with-param name="key" select="'bin'"/>
               </xsl:apply-templates>
                    <!--period 0..1 Period--><xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
                    <!--type 0..1 Coding--><xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--subscriberId 0..1 Identifier--><xsl:apply-templates select="*[@key = 'subscriberId']" mode="Identifier">
                  <xsl:with-param name="key" select="'subscriberId'"/>
               </xsl:apply-templates>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--group 0..1 string--><xsl:apply-templates select="*[@key = 'group']" mode="string">
                  <xsl:with-param name="key" select="'group'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'group'])][*[@key = '_group']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="group"/>
                        <xsl:copy-of select="fn:map[@key = '_group']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'group'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--plan 0..1 string--><xsl:apply-templates select="*[@key = 'plan']" mode="string">
                  <xsl:with-param name="key" select="'plan'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'plan'])][*[@key = '_plan']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="plan"/>
                        <xsl:copy-of select="fn:map[@key = '_plan']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'plan'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--subPlan 0..1 string--><xsl:apply-templates select="*[@key = 'subPlan']" mode="string">
                  <xsl:with-param name="key" select="'subPlan'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'subPlan'])][*[@key = '_subPlan']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="subPlan"/>
                        <xsl:copy-of select="fn:map[@key = '_subPlan']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'subPlan'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--dependent 0..1 positiveInt--><xsl:apply-templates select="*[@key = 'dependent']" mode="positiveInt">
                  <xsl:with-param name="key" select="'dependent'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'dependent'])][*[@key = '_dependent']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="dependent"/>
                        <xsl:copy-of select="fn:map[@key = '_dependent']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'dependent'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--sequence 0..1 positiveInt--><xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--subscriber 0..1 Reference--><xsl:apply-templates select="*[@key = 'subscriber']" mode="Reference">
                  <xsl:with-param name="key" select="'subscriber'"/>
               </xsl:apply-templates>
                    <!--network 0..1 Identifier--><xsl:apply-templates select="*[@key = 'network']" mode="Identifier">
                  <xsl:with-param name="key" select="'network'"/>
               </xsl:apply-templates>
                    <!--contract 0..* Reference--><xsl:apply-templates select="*[@key = 'contract']" mode="Reference">
                  <xsl:with-param name="key" select="'contract'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>The formal description of a single piece of information that can be gathered and reported.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DataElement">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--url 0..1 uri--><xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--version 0..1 string--><xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--status 1..1 code--><xsl:apply-templates select="*[@key = 'status']" mode="code">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--experimental 0..1 boolean--><xsl:apply-templates select="*[@key = 'experimental']" mode="boolean">
                  <xsl:with-param name="key" select="'experimental'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'experimental'])][*[@key = '_experimental']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="experimental"/>
                        <xsl:copy-of select="fn:map[@key = '_experimental']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'experimental'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--publisher 0..1 string--><xsl:apply-templates select="*[@key = 'publisher']" mode="string">
                  <xsl:with-param name="key" select="'publisher'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'publisher'])][*[@key = '_publisher']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher"/>
                        <xsl:copy-of select="fn:map[@key = '_publisher']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'publisher'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--contact 0..* DataElement.Contact--><xsl:apply-templates select="*[@key = 'contact']" mode="DataElement.Contact">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
                    <!--date 0..1 dateTime--><xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--useContext 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'useContext']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'useContext'"/>
               </xsl:apply-templates>
                    <!--copyright 0..1 string--><xsl:apply-templates select="*[@key = 'copyright']" mode="string">
                  <xsl:with-param name="key" select="'copyright'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'copyright'])][*[@key = '_copyright']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright"/>
                        <xsl:copy-of select="fn:map[@key = '_copyright']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'copyright'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--stringency 0..1 DataElementStringency--><xsl:apply-templates select="*[@key = 'stringency']" mode="DataElementStringency">
                  <xsl:with-param name="key" select="'stringency'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'stringency'])][*[@key = '_stringency']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="stringency"/>
                        <xsl:copy-of select="fn:map[@key = '_stringency']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DataElementStringency">
                     <xsl:with-param name="key" select="'stringency'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--mapping 0..* DataElement.Mapping--><xsl:apply-templates select="*[@key = 'mapping']" mode="DataElement.Mapping">
                  <xsl:with-param name="key" select="'mapping'"/>
               </xsl:apply-templates>
                    <!--element 1..* ElementDefinition--><xsl:apply-templates select="*[@key = 'element']" mode="ElementDefinition">
                  <xsl:with-param name="key" select="'element'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The formal description of a single piece of information that can be gathered and reported.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DataElement.Contact">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:apply-templates select="*[@key = 'telecom']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'telecom'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The formal description of a single piece of information that can be gathered and reported.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DataElement.Mapping">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identity 1..1 id--><xsl:apply-templates select="*[@key = 'identity']" mode="id">
                  <xsl:with-param name="key" select="'identity'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'identity'])][*[@key = '_identity']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="identity"/>
                        <xsl:copy-of select="fn:map[@key = '_identity']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'identity'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--uri 0..1 uri--><xsl:apply-templates select="*[@key = 'uri']" mode="uri">
                  <xsl:with-param name="key" select="'uri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'uri'])][*[@key = '_uri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="uri"/>
                        <xsl:copy-of select="fn:map[@key = '_uri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'uri'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--name 0..1 string--><xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--comments 0..1 string--><xsl:apply-templates select="*[@key = 'comments']" mode="string">
                  <xsl:with-param name="key" select="'comments'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comments'])][*[@key = '_comments']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comments"/>
                        <xsl:copy-of select="fn:map[@key = '_comments']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comments'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the degree of precision of the data element definition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DataElementStringency">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssue">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--patient 0..1 Reference--><xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
                    <!--category 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
                    <!--severity 0..1 DetectedIssueSeverity--><xsl:apply-templates select="*[@key = 'severity']" mode="DetectedIssueSeverity">
                  <xsl:with-param name="key" select="'severity'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'severity'])][*[@key = '_severity']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity"/>
                        <xsl:copy-of select="fn:map[@key = '_severity']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DetectedIssueSeverity">
                     <xsl:with-param name="key" select="'severity'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--implicated 0..* Reference--><xsl:apply-templates select="*[@key = 'implicated']" mode="Reference">
                  <xsl:with-param name="key" select="'implicated'"/>
               </xsl:apply-templates>
                    <!--detail 0..1 string--><xsl:apply-templates select="*[@key = 'detail']" mode="string">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'detail'])][*[@key = '_detail']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="detail"/>
                        <xsl:copy-of select="fn:map[@key = '_detail']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'detail'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--date 0..1 dateTime--><xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--author 0..1 Reference--><xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--reference 0..1 uri--><xsl:apply-templates select="*[@key = 'reference']" mode="uri">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'reference'])][*[@key = '_reference']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="reference"/>
                        <xsl:copy-of select="fn:map[@key = '_reference']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'reference'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--mitigation 0..* DetectedIssue.Mitigation--><xsl:apply-templates select="*[@key = 'mitigation']" mode="DetectedIssue.Mitigation">
                  <xsl:with-param name="key" select="'mitigation'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssue.Mitigation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--action 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'action']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'action'"/>
               </xsl:apply-templates>
                    <!--date 0..1 dateTime--><xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--author 0..1 Reference--><xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the potential degree of impact of the identified issue on the patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssueSeverity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>This resource identifies an instance of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.  Medical devices includes durable (reusable) medical equipment, implantable devices, as well as disposable equipment used for diagnostic, treatment, and research for healthcare and public health.  Non-medical devices may include items such as a machine, cellphone, computer, application, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Device">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--type 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--note 0..* Annotation--><xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
                    <!--status 0..1 DeviceStatus--><xsl:apply-templates select="*[@key = 'status']" mode="DeviceStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DeviceStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--manufacturer 0..1 string--><xsl:apply-templates select="*[@key = 'manufacturer']" mode="string">
                  <xsl:with-param name="key" select="'manufacturer'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'manufacturer'])][*[@key = '_manufacturer']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="manufacturer"/>
                        <xsl:copy-of select="fn:map[@key = '_manufacturer']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'manufacturer'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--model 0..1 string--><xsl:apply-templates select="*[@key = 'model']" mode="string">
                  <xsl:with-param name="key" select="'model'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'model'])][*[@key = '_model']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="model"/>
                        <xsl:copy-of select="fn:map[@key = '_model']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'model'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--version 0..1 string--><xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--manufactureDate 0..1 dateTime--><xsl:apply-templates select="*[@key = 'manufactureDate']" mode="dateTime">
                  <xsl:with-param name="key" select="'manufactureDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'manufactureDate'])][*[@key = '_manufactureDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="manufactureDate"/>
                        <xsl:copy-of select="fn:map[@key = '_manufactureDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'manufactureDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--expiry 0..1 dateTime--><xsl:apply-templates select="*[@key = 'expiry']" mode="dateTime">
                  <xsl:with-param name="key" select="'expiry'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'expiry'])][*[@key = '_expiry']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="expiry"/>
                        <xsl:copy-of select="fn:map[@key = '_expiry']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'expiry'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--udi 0..1 string--><xsl:apply-templates select="*[@key = 'udi']" mode="string">
                  <xsl:with-param name="key" select="'udi'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'udi'])][*[@key = '_udi']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="udi"/>
                        <xsl:copy-of select="fn:map[@key = '_udi']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'udi'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--lotNumber 0..1 string--><xsl:apply-templates select="*[@key = 'lotNumber']" mode="string">
                  <xsl:with-param name="key" select="'lotNumber'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lotNumber'])][*[@key = '_lotNumber']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lotNumber"/>
                        <xsl:copy-of select="fn:map[@key = '_lotNumber']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'lotNumber'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--owner 0..1 Reference--><xsl:apply-templates select="*[@key = 'owner']" mode="Reference">
                  <xsl:with-param name="key" select="'owner'"/>
               </xsl:apply-templates>
                    <!--location 0..1 Reference--><xsl:apply-templates select="*[@key = 'location']" mode="Reference">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
                    <!--patient 0..1 Reference--><xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
                    <!--contact 0..* ContactPoint--><xsl:apply-templates select="*[@key = 'contact']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
                    <!--url 0..1 uri--><xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The availability status of the device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Describes the characteristics, operational status and capabilities of a medical-related component of a medical device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceComponent">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--type 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--identifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--lastSystemChange 1..1 instant--><xsl:apply-templates select="*[@key = 'lastSystemChange']" mode="instant">
                  <xsl:with-param name="key" select="'lastSystemChange'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lastSystemChange'])][*[@key = '_lastSystemChange']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastSystemChange"/>
                        <xsl:copy-of select="fn:map[@key = '_lastSystemChange']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'lastSystemChange'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--source 0..1 Reference--><xsl:apply-templates select="*[@key = 'source']" mode="Reference">
                  <xsl:with-param name="key" select="'source'"/>
               </xsl:apply-templates>
                    <!--parent 0..1 Reference--><xsl:apply-templates select="*[@key = 'parent']" mode="Reference">
                  <xsl:with-param name="key" select="'parent'"/>
               </xsl:apply-templates>
                    <!--operationalStatus 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'operationalStatus']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'operationalStatus'"/>
               </xsl:apply-templates>
                    <!--parameterGroup 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'parameterGroup']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'parameterGroup'"/>
               </xsl:apply-templates>
                    <!--measurementPrinciple 0..1 Measmnt-Principle--><xsl:apply-templates select="*[@key = 'measurementPrinciple']" mode="Measmnt-Principle">
                  <xsl:with-param name="key" select="'measurementPrinciple'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'measurementPrinciple'])][*[@key = '_measurementPrinciple']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="measurementPrinciple"/>
                        <xsl:copy-of select="fn:map[@key = '_measurementPrinciple']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="Measmnt-Principle">
                     <xsl:with-param name="key" select="'measurementPrinciple'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--productionSpecification 0..* DeviceComponent.ProductionSpecification--><xsl:apply-templates select="*[@key = 'productionSpecification']"
                                    mode="DeviceComponent.ProductionSpecification">
                  <xsl:with-param name="key" select="'productionSpecification'"/>
               </xsl:apply-templates>
                    <!--languageCode 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'languageCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'languageCode'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the characteristics, operational status and capabilities of a medical-related component of a medical device.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceComponent.ProductionSpecification">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--specType 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'specType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'specType'"/>
               </xsl:apply-templates>
                    <!--componentId 0..1 Identifier--><xsl:apply-templates select="*[@key = 'componentId']" mode="Identifier">
                  <xsl:with-param name="key" select="'componentId'"/>
               </xsl:apply-templates>
                    <!--productionSpec 0..1 string--><xsl:apply-templates select="*[@key = 'productionSpec']" mode="string">
                  <xsl:with-param name="key" select="'productionSpec'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'productionSpec'])][*[@key = '_productionSpec']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="productionSpec"/>
                        <xsl:copy-of select="fn:map[@key = '_productionSpec']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'productionSpec'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Different measurement principle supported by the device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Measmnt-Principle">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Describes a measurement, calculation or setting capability of a medical device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetric">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--type 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--identifier 1..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--unit 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'unit']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
                    <!--source 0..1 Reference--><xsl:apply-templates select="*[@key = 'source']" mode="Reference">
                  <xsl:with-param name="key" select="'source'"/>
               </xsl:apply-templates>
                    <!--parent 0..1 Reference--><xsl:apply-templates select="*[@key = 'parent']" mode="Reference">
                  <xsl:with-param name="key" select="'parent'"/>
               </xsl:apply-templates>
                    <!--operationalStatus 0..1 DeviceMetricOperationalStatus--><xsl:apply-templates select="*[@key = 'operationalStatus']"
                                    mode="DeviceMetricOperationalStatus">
                  <xsl:with-param name="key" select="'operationalStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'operationalStatus'])][*[@key = '_operationalStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="operationalStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_operationalStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DeviceMetricOperationalStatus">
                     <xsl:with-param name="key" select="'operationalStatus'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--color 0..1 DeviceMetricColor--><xsl:apply-templates select="*[@key = 'color']" mode="DeviceMetricColor">
                  <xsl:with-param name="key" select="'color'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'color'])][*[@key = '_color']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="color"/>
                        <xsl:copy-of select="fn:map[@key = '_color']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DeviceMetricColor">
                     <xsl:with-param name="key" select="'color'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--category 1..1 DeviceMetricCategory--><xsl:apply-templates select="*[@key = 'category']" mode="DeviceMetricCategory">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'category'])][*[@key = '_category']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="category"/>
                        <xsl:copy-of select="fn:map[@key = '_category']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DeviceMetricCategory">
                     <xsl:with-param name="key" select="'category'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--measurementPeriod 0..1 Timing--><xsl:apply-templates select="*[@key = 'measurementPeriod']" mode="Timing">
                  <xsl:with-param name="key" select="'measurementPeriod'"/>
               </xsl:apply-templates>
                    <!--calibration 0..* DeviceMetric.Calibration--><xsl:apply-templates select="*[@key = 'calibration']" mode="DeviceMetric.Calibration">
                  <xsl:with-param name="key" select="'calibration'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a measurement, calculation or setting capability of a medical device.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetric.Calibration">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..1 DeviceMetricCalibrationType--><xsl:apply-templates select="*[@key = 'type']" mode="DeviceMetricCalibrationType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DeviceMetricCalibrationType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--state 0..1 DeviceMetricCalibrationState--><xsl:apply-templates select="*[@key = 'state']" mode="DeviceMetricCalibrationState">
                  <xsl:with-param name="key" select="'state'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'state'])][*[@key = '_state']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="state"/>
                        <xsl:copy-of select="fn:map[@key = '_state']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DeviceMetricCalibrationState">
                     <xsl:with-param name="key" select="'state'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--time 0..1 instant--><xsl:apply-templates select="*[@key = 'time']" mode="instant">
                  <xsl:with-param name="key" select="'time'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'time'])][*[@key = '_time']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="time"/>
                        <xsl:copy-of select="fn:map[@key = '_time']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'time'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the typical color of representation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricColor">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the state of a metric calibration.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCalibrationState">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the type of a metric calibration.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCalibrationType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the category of the metric.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCategory">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the operational status of the DeviceMetric.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricOperationalStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseRequest">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    
                        
                        <!--bodySiteCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'bodySiteCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'bodySiteCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--bodySiteReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'bodySiteReference']" mode="Reference">
                  <xsl:with-param name="key" select="'bodySiteReference'"/>
               </xsl:apply-templates>
                    
                    <!--status 0..1 DeviceUseRequestStatus--><xsl:apply-templates select="*[@key = 'status']" mode="DeviceUseRequestStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DeviceUseRequestStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--device 1..1 Reference--><xsl:apply-templates select="*[@key = 'device']" mode="Reference">
                  <xsl:with-param name="key" select="'device'"/>
               </xsl:apply-templates>
                    <!--encounter 0..1 Reference--><xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--indication 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'indication']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'indication'"/>
               </xsl:apply-templates>
                    <!--notes 0..* string--><xsl:apply-templates select="*[@key = 'notes']" mode="string">
                  <xsl:with-param name="key" select="'notes'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'notes'])][*[@key = '_notes']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="notes"/>
                        <xsl:copy-of select="fn:map[@key = '_notes']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'notes'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--prnReason 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'prnReason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'prnReason'"/>
               </xsl:apply-templates>
                    <!--orderedOn 0..1 dateTime--><xsl:apply-templates select="*[@key = 'orderedOn']" mode="dateTime">
                  <xsl:with-param name="key" select="'orderedOn'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'orderedOn'])][*[@key = '_orderedOn']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="orderedOn"/>
                        <xsl:copy-of select="fn:map[@key = '_orderedOn']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'orderedOn'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--recordedOn 0..1 dateTime--><xsl:apply-templates select="*[@key = 'recordedOn']" mode="dateTime">
                  <xsl:with-param name="key" select="'recordedOn'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'recordedOn'])][*[@key = '_recordedOn']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="recordedOn"/>
                        <xsl:copy-of select="fn:map[@key = '_recordedOn']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'recordedOn'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--subject 1..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    
                        
                        <!--timingTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'timingTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'timingTiming'"/>
               </xsl:apply-templates>
                        <!--timingPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'timingPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'timingPeriod'"/>
               </xsl:apply-templates>
                        <!--timingDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'timingDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'timingDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'timingDateTime'])][*[@key = '_timingDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_timingDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'timingDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                    <!--priority 0..1 DeviceUseRequestPriority--><xsl:apply-templates select="*[@key = 'priority']" mode="DeviceUseRequestPriority">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'priority'])][*[@key = '_priority']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority"/>
                        <xsl:copy-of select="fn:map[@key = '_priority']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DeviceUseRequestPriority">
                     <xsl:with-param name="key" select="'priority'"/>
                  </xsl:apply-templates>
               </xsl:if>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes representing the status of the request.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseRequestStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes representing the priority of the request.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseRequestPriority">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseStatement">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    
                        
                        <!--bodySiteCodeableConcept 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'bodySiteCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'bodySiteCodeableConcept'"/>
               </xsl:apply-templates>
                        <!--bodySiteReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'bodySiteReference']" mode="Reference">
                  <xsl:with-param name="key" select="'bodySiteReference'"/>
               </xsl:apply-templates>
                    
                    <!--whenUsed 0..1 Period--><xsl:apply-templates select="*[@key = 'whenUsed']" mode="Period">
                  <xsl:with-param name="key" select="'whenUsed'"/>
               </xsl:apply-templates>
                    <!--device 1..1 Reference--><xsl:apply-templates select="*[@key = 'device']" mode="Reference">
                  <xsl:with-param name="key" select="'device'"/>
               </xsl:apply-templates>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--indication 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'indication']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'indication'"/>
               </xsl:apply-templates>
                    <!--notes 0..* string--><xsl:apply-templates select="*[@key = 'notes']" mode="string">
                  <xsl:with-param name="key" select="'notes'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'notes'])][*[@key = '_notes']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="notes"/>
                        <xsl:copy-of select="fn:map[@key = '_notes']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'notes'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--recordedOn 0..1 dateTime--><xsl:apply-templates select="*[@key = 'recordedOn']" mode="dateTime">
                  <xsl:with-param name="key" select="'recordedOn'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'recordedOn'])][*[@key = '_recordedOn']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="recordedOn"/>
                        <xsl:copy-of select="fn:map[@key = '_recordedOn']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'recordedOn'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--subject 1..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    
                        
                        <!--timingTiming 1..1 Timing--><xsl:apply-templates select="*[@key = 'timingTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'timingTiming'"/>
               </xsl:apply-templates>
                        <!--timingPeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'timingPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'timingPeriod'"/>
               </xsl:apply-templates>
                        <!--timingDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'timingDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'timingDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'timingDateTime'])][*[@key = '_timingDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_timingDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'timingDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A record of a request for a diagnostic investigation service to be performed.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrder">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--subject 1..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--orderer 0..1 Reference--><xsl:apply-templates select="*[@key = 'orderer']" mode="Reference">
                  <xsl:with-param name="key" select="'orderer'"/>
               </xsl:apply-templates>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--encounter 0..1 Reference--><xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
                    <!--reason 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'reason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
                    <!--supportingInformation 0..* Reference--><xsl:apply-templates select="*[@key = 'supportingInformation']" mode="Reference">
                  <xsl:with-param name="key" select="'supportingInformation'"/>
               </xsl:apply-templates>
                    <!--specimen 0..* Reference--><xsl:apply-templates select="*[@key = 'specimen']" mode="Reference">
                  <xsl:with-param name="key" select="'specimen'"/>
               </xsl:apply-templates>
                    <!--status 0..1 DiagnosticOrderStatus--><xsl:apply-templates select="*[@key = 'status']" mode="DiagnosticOrderStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DiagnosticOrderStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--priority 0..1 DiagnosticOrderPriority--><xsl:apply-templates select="*[@key = 'priority']" mode="DiagnosticOrderPriority">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'priority'])][*[@key = '_priority']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority"/>
                        <xsl:copy-of select="fn:map[@key = '_priority']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DiagnosticOrderPriority">
                     <xsl:with-param name="key" select="'priority'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--event 0..* DiagnosticOrder.Event--><xsl:apply-templates select="*[@key = 'event']" mode="DiagnosticOrder.Event">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
                    <!--item 0..* DiagnosticOrder.Item--><xsl:apply-templates select="*[@key = 'item']" mode="DiagnosticOrder.Item">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
                    <!--note 0..* Annotation--><xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a request for a diagnostic investigation service to be performed.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrder.Event">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--status 1..1 DiagnosticOrderStatus--><xsl:apply-templates select="*[@key = 'status']" mode="DiagnosticOrderStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DiagnosticOrderStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'description']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
                    <!--dateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'dateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'dateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'dateTime'])][*[@key = '_dateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_dateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'dateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--actor 0..1 Reference--><xsl:apply-templates select="*[@key = 'actor']" mode="Reference">
                  <xsl:with-param name="key" select="'actor'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a request for a diagnostic investigation service to be performed.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrder.Item">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--specimen 0..* Reference--><xsl:apply-templates select="*[@key = 'specimen']" mode="Reference">
                  <xsl:with-param name="key" select="'specimen'"/>
               </xsl:apply-templates>
                    <!--bodySite 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'bodySite']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'bodySite'"/>
               </xsl:apply-templates>
                    <!--status 0..1 DiagnosticOrderStatus--><xsl:apply-templates select="*[@key = 'status']" mode="DiagnosticOrderStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DiagnosticOrderStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--event 0..* DiagnosticOrder.Event--><xsl:apply-templates select="*[@key = 'event']" mode="DiagnosticOrder.Event">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of a diagnostic order.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrderStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The clinical priority of a diagnostic order.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrderPriority">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReport">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--status 1..1 DiagnosticReportStatus--><xsl:apply-templates select="*[@key = 'status']" mode="DiagnosticReportStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DiagnosticReportStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--category 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
                    <!--code 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
                    <!--subject 1..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--encounter 0..1 Reference--><xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
                    
                        
                        <!--effectiveDateTime 1..1 dateTime--><xsl:apply-templates select="*[@key = 'effectiveDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'effectiveDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'effectiveDateTime'])][*[@key = '_effectiveDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_effectiveDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'effectiveDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
                        <!--effectivePeriod 1..1 Period--><xsl:apply-templates select="*[@key = 'effectivePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'effectivePeriod'"/>
               </xsl:apply-templates>
                    
                    <!--issued 1..1 instant--><xsl:apply-templates select="*[@key = 'issued']" mode="instant">
                  <xsl:with-param name="key" select="'issued'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'issued'])][*[@key = '_issued']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued"/>
                        <xsl:copy-of select="fn:map[@key = '_issued']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'issued'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--performer 1..1 Reference--><xsl:apply-templates select="*[@key = 'performer']" mode="Reference">
                  <xsl:with-param name="key" select="'performer'"/>
               </xsl:apply-templates>
                    <!--request 0..* Reference--><xsl:apply-templates select="*[@key = 'request']" mode="Reference">
                  <xsl:with-param name="key" select="'request'"/>
               </xsl:apply-templates>
                    <!--specimen 0..* Reference--><xsl:apply-templates select="*[@key = 'specimen']" mode="Reference">
                  <xsl:with-param name="key" select="'specimen'"/>
               </xsl:apply-templates>
                    <!--result 0..* Reference--><xsl:apply-templates select="*[@key = 'result']" mode="Reference">
                  <xsl:with-param name="key" select="'result'"/>
               </xsl:apply-templates>
                    <!--imagingStudy 0..* Reference--><xsl:apply-templates select="*[@key = 'imagingStudy']" mode="Reference">
                  <xsl:with-param name="key" select="'imagingStudy'"/>
               </xsl:apply-templates>
                    <!--image 0..* DiagnosticReport.Image--><xsl:apply-templates select="*[@key = 'image']" mode="DiagnosticReport.Image">
                  <xsl:with-param name="key" select="'image'"/>
               </xsl:apply-templates>
                    <!--conclusion 0..1 string--><xsl:apply-templates select="*[@key = 'conclusion']" mode="string">
                  <xsl:with-param name="key" select="'conclusion'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'conclusion'])][*[@key = '_conclusion']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="conclusion"/>
                        <xsl:copy-of select="fn:map[@key = '_conclusion']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'conclusion'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--codedDiagnosis 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'codedDiagnosis']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'codedDiagnosis'"/>
               </xsl:apply-templates>
                    <!--presentedForm 0..* Attachment--><xsl:apply-templates select="*[@key = 'presentedForm']" mode="Attachment">
                  <xsl:with-param name="key" select="'presentedForm'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReport.Image">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--comment 0..1 string--><xsl:apply-templates select="*[@key = 'comment']" mode="string">
                  <xsl:with-param name="key" select="'comment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comment'])][*[@key = '_comment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment"/>
                        <xsl:copy-of select="fn:map[@key = '_comment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comment'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--link 1..1 Reference--><xsl:apply-templates select="*[@key = 'link']" mode="Reference">
                  <xsl:with-param name="key" select="'link'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the diagnostic report as a whole.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReportStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A manifest that defines a set of documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--masterIdentifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'masterIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'masterIdentifier'"/>
               </xsl:apply-templates>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--subject 0..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--recipient 0..* Reference--><xsl:apply-templates select="*[@key = 'recipient']" mode="Reference">
                  <xsl:with-param name="key" select="'recipient'"/>
               </xsl:apply-templates>
                    <!--type 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--author 0..* Reference--><xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
                    <!--created 0..1 dateTime--><xsl:apply-templates select="*[@key = 'created']" mode="dateTime">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--source 0..1 uri--><xsl:apply-templates select="*[@key = 'source']" mode="uri">
                  <xsl:with-param name="key" select="'source'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'source'])][*[@key = '_source']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="source"/>
                        <xsl:copy-of select="fn:map[@key = '_source']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'source'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--status 1..1 code--><xsl:apply-templates select="*[@key = 'status']" mode="code">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--content 1..* DocumentManifest.Content--><xsl:apply-templates select="*[@key = 'content']" mode="DocumentManifest.Content">
                  <xsl:with-param name="key" select="'content'"/>
               </xsl:apply-templates>
                    <!--related 0..* DocumentManifest.Related--><xsl:apply-templates select="*[@key = 'related']" mode="DocumentManifest.Related">
                  <xsl:with-param name="key" select="'related'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest that defines a set of documents.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest.Content">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--pAttachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'pAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'pAttachment'"/>
               </xsl:apply-templates>
                        <!--pReference 1..1 Reference--><xsl:apply-templates select="*[@key = 'pReference']" mode="Reference">
                  <xsl:with-param name="key" select="'pReference'"/>
               </xsl:apply-templates>
                    
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest that defines a set of documents.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest.Related">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--ref 0..1 Reference--><xsl:apply-templates select="*[@key = 'ref']" mode="Reference">
                  <xsl:with-param name="key" select="'ref'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--masterIdentifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'masterIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'masterIdentifier'"/>
               </xsl:apply-templates>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--subject 0..1 Reference--><xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
                    <!--type 1..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
                    <!--class 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'class']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'class'"/>
               </xsl:apply-templates>
                    <!--author 0..* Reference--><xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
                    <!--custodian 0..1 Reference--><xsl:apply-templates select="*[@key = 'custodian']" mode="Reference">
                  <xsl:with-param name="key" select="'custodian'"/>
               </xsl:apply-templates>
                    <!--authenticator 0..1 Reference--><xsl:apply-templates select="*[@key = 'authenticator']" mode="Reference">
                  <xsl:with-param name="key" select="'authenticator'"/>
               </xsl:apply-templates>
                    <!--created 0..1 dateTime--><xsl:apply-templates select="*[@key = 'created']" mode="dateTime">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--indexed 1..1 instant--><xsl:apply-templates select="*[@key = 'indexed']" mode="instant">
                  <xsl:with-param name="key" select="'indexed'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'indexed'])][*[@key = '_indexed']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="indexed"/>
                        <xsl:copy-of select="fn:map[@key = '_indexed']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'indexed'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--status 1..1 code--><xsl:apply-templates select="*[@key = 'status']" mode="code">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--docStatus 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'docStatus']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'docStatus'"/>
               </xsl:apply-templates>
                    <!--relatesTo 0..* DocumentReference.RelatesTo--><xsl:apply-templates select="*[@key = 'relatesTo']" mode="DocumentReference.RelatesTo">
                  <xsl:with-param name="key" select="'relatesTo'"/>
               </xsl:apply-templates>
                    <!--description 0..1 string--><xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--securityLabel 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'securityLabel']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'securityLabel'"/>
               </xsl:apply-templates>
                    <!--content 1..* DocumentReference.Content--><xsl:apply-templates select="*[@key = 'content']" mode="DocumentReference.Content">
                  <xsl:with-param name="key" select="'content'"/>
               </xsl:apply-templates>
                    <!--context 0..1 DocumentReference.Context--><xsl:apply-templates select="*[@key = 'context']" mode="DocumentReference.Context">
                  <xsl:with-param name="key" select="'context'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.RelatesTo">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 DocumentRelationshipType--><xsl:apply-templates select="*[@key = 'code']" mode="DocumentRelationshipType">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DocumentRelationshipType">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--target 1..1 Reference--><xsl:apply-templates select="*[@key = 'target']" mode="Reference">
                  <xsl:with-param name="key" select="'target'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Content">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--attachment 1..1 Attachment--><xsl:apply-templates select="*[@key = 'attachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'attachment'"/>
               </xsl:apply-templates>
                    <!--format 0..* Coding--><xsl:apply-templates select="*[@key = 'format']" mode="Coding">
                  <xsl:with-param name="key" select="'format'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Context">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--encounter 0..1 Reference--><xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
                    <!--event 0..* CodeableConcept--><xsl:apply-templates select="*[@key = 'event']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
                    <!--period 0..1 Period--><xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
                    <!--facilityType 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'facilityType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'facilityType'"/>
               </xsl:apply-templates>
                    <!--practiceSetting 0..1 CodeableConcept--><xsl:apply-templates select="*[@key = 'practiceSetting']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'practiceSetting'"/>
               </xsl:apply-templates>
                    <!--sourcePatientInfo 0..1 Reference--><xsl:apply-templates select="*[@key = 'sourcePatientInfo']" mode="Reference">
                  <xsl:with-param name="key" select="'sourcePatientInfo'"/>
               </xsl:apply-templates>
                    <!--related 0..* DocumentReference.Related--><xsl:apply-templates select="*[@key = 'related']" mode="DocumentReference.Related">
                  <xsl:with-param name="key" select="'related'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Related">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identifier 0..1 Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--ref 0..1 Reference--><xsl:apply-templates select="*[@key = 'ref']" mode="Reference">
                  <xsl:with-param name="key" select="'ref'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of relationship between documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentRelationshipType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the insurance eligibility details from the insurer regarding a specified coverage and optionally some class of service.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityRequest">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--ruleset 0..1 Coding--><xsl:apply-templates select="*[@key = 'ruleset']" mode="Coding">
                  <xsl:with-param name="key" select="'ruleset'"/>
               </xsl:apply-templates>
                    <!--originalRuleset 0..1 Coding--><xsl:apply-templates select="*[@key = 'originalRuleset']" mode="Coding">
                  <xsl:with-param name="key" select="'originalRuleset'"/>
               </xsl:apply-templates>
                    <!--created 0..1 dateTime--><xsl:apply-templates select="*[@key = 'created']" mode="dateTime">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
                    <!--target 0..1 Reference--><xsl:apply-templates select="*[@key = 'target']" mode="Reference">
                  <xsl:with-param name="key" select="'target'"/>
               </xsl:apply-templates>
                    <!--provider 0..1 Reference--><xsl:apply-templates select="*[@key = 'provider']" mode="Reference">
                  <xsl:with-param name="key" select="'provider'"/>
               </xsl:apply-templates>
                    <!--organization 0..1 Reference--><xsl:apply-templates select="*[@key = 'organization']" mode="Reference">
                  <xsl:with-param name="key" select="'organization'"/>
               </xsl:apply-templates>
                </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
        
    <xd:doc>
      <xd:desc>
         <xd:p>This resource provides eligibility and plan details from the processing of an Eligibility resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityResponse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
                    <!--request 0..1 Reference--><xsl:apply-templates select="*[@key = 'request']" mode="Reference">
                  <xsl:with-param nam