<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
                xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://hl7.org/fhir"
                xmlns:xh="http://www.w3.org/1999/xhtml"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all"
                version="3.0">
   <xd:doc scope="stylesheet">
      <xd:desc>
         <xd:p>
            <xd:b>Generated:</xd:b> 2022-04-03T07:39:46.942+02:00</xd:p>
         <xd:p>
            <xd:b>By:</xd:b> schema2mapxsl.xsl version 1.0.0</xd:p>
         <xd:p>Takes in FHIR XSD fhir-single.xsd and constructs a stylesheet that will take in a FHIR XML instance and produce an expath map (http://www.w3.org/2005/xpath-functions) that may be converted into a valid FHIR JSON instance</xd:p>
         <xd:p>Known 'issue': does not handle xml comment() as array of fhir_comments, and basically ignores xml comment()</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:output indent="yes"
               method="xml"
               media-type="application/xml"
               omit-xml-declaration="yes"/>
   <xd:doc>
      <xd:desc>Process FHIR instances and error on anything else</xd:desc>
   </xd:doc>
   <xsl:template match="/">
      <xsl:choose>
         <xsl:when test="f:Account">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Account"/>
            </map>
         </xsl:when>
         <xsl:when test="f:AllergyIntolerance">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="AllergyIntolerance"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Appointment">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Appointment"/>
            </map>
         </xsl:when>
         <xsl:when test="f:AppointmentResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="AppointmentResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:AuditEvent">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="AuditEvent"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Basic">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Basic"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Binary">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Binary"/>
            </map>
         </xsl:when>
         <xsl:when test="f:BodySite">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="BodySite"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Bundle">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Bundle"/>
            </map>
         </xsl:when>
         <xsl:when test="f:CarePlan">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="CarePlan"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Claim">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Claim"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ClaimResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ClaimResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ClinicalImpression">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ClinicalImpression"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Communication">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Communication"/>
            </map>
         </xsl:when>
         <xsl:when test="f:CommunicationRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="CommunicationRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Composition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Composition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ConceptMap">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ConceptMap"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Condition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Condition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Conformance">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Conformance"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Contract">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Contract"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Coverage">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Coverage"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DataElement">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DataElement"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DetectedIssue">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DetectedIssue"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Device">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Device"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DeviceComponent">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DeviceComponent"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DeviceMetric">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DeviceMetric"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DeviceUseRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DeviceUseRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DeviceUseStatement">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DeviceUseStatement"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DiagnosticOrder">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DiagnosticOrder"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DiagnosticReport">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DiagnosticReport"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DocumentManifest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DocumentManifest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DocumentReference">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DocumentReference"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EligibilityRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EligibilityRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EligibilityResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EligibilityResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Encounter">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Encounter"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EnrollmentRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EnrollmentRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EnrollmentResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EnrollmentResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EpisodeOfCare">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EpisodeOfCare"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ExplanationOfBenefit">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ExplanationOfBenefit"/>
            </map>
         </xsl:when>
         <xsl:when test="f:FamilyMemberHistory">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="FamilyMemberHistory"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Flag">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Flag"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Goal">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Goal"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Group">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Group"/>
            </map>
         </xsl:when>
         <xsl:when test="f:HealthcareService">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="HealthcareService"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ImagingObjectSelection">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ImagingObjectSelection"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ImagingStudy">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ImagingStudy"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Immunization">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Immunization"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ImmunizationRecommendation">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ImmunizationRecommendation"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ImplementationGuide">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ImplementationGuide"/>
            </map>
         </xsl:when>
         <xsl:when test="f:List">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="List"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Location">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Location"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Media">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Media"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Medication">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Medication"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MedicationAdministration">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MedicationAdministration"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MedicationDispense">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MedicationDispense"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MedicationOrder">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MedicationOrder"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MedicationStatement">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MedicationStatement"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MessageHeader">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MessageHeader"/>
            </map>
         </xsl:when>
         <xsl:when test="f:NamingSystem">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="NamingSystem"/>
            </map>
         </xsl:when>
         <xsl:when test="f:NutritionOrder">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="NutritionOrder"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Observation">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Observation"/>
            </map>
         </xsl:when>
         <xsl:when test="f:OperationDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="OperationDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:OperationOutcome">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="OperationOutcome"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Order">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Order"/>
            </map>
         </xsl:when>
         <xsl:when test="f:OrderResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="OrderResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Organization">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Organization"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Patient">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Patient"/>
            </map>
         </xsl:when>
         <xsl:when test="f:PaymentNotice">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="PaymentNotice"/>
            </map>
         </xsl:when>
         <xsl:when test="f:PaymentReconciliation">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="PaymentReconciliation"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Person">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Person"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Practitioner">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Practitioner"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Procedure">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Procedure"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ProcedureRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ProcedureRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ProcessRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ProcessRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ProcessResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ProcessResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Provenance">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Provenance"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Questionnaire">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Questionnaire"/>
            </map>
         </xsl:when>
         <xsl:when test="f:QuestionnaireResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="QuestionnaireResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ReferralRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ReferralRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:RelatedPerson">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="RelatedPerson"/>
            </map>
         </xsl:when>
         <xsl:when test="f:RiskAssessment">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="RiskAssessment"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Schedule">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Schedule"/>
            </map>
         </xsl:when>
         <xsl:when test="f:SearchParameter">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="SearchParameter"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Slot">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Slot"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Specimen">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Specimen"/>
            </map>
         </xsl:when>
         <xsl:when test="f:StructureDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="StructureDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Subscription">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Subscription"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Substance">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Substance"/>
            </map>
         </xsl:when>
         <xsl:when test="f:SupplyDelivery">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="SupplyDelivery"/>
            </map>
         </xsl:when>
         <xsl:when test="f:SupplyRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="SupplyRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:TestScript">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="TestScript"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ValueSet">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ValueSet"/>
            </map>
         </xsl:when>
         <xsl:when test="f:VisionPrescription">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="VisionPrescription"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Parameters">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Parameters"/>
            </map>
         </xsl:when>
         <xsl:otherwise>
            <xsl:message terminate="yes">Unknown resourceType or not in FHIR namespace: {<xsl:value-of select="*[1]/namespace-uri()"/>}:<xsl:value-of select="*[1]/local-name()"/>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A string that may contain markdown syntax for optional processing by a mark down presentation engine</xd:p>
         <xd:p>Systems are not required to have markdown support, and there is considerable variation in markdown syntax, so the text should be readable without markdown processing. The preferred markdown syntax is described here: http://daringfireball.net/projects/markdown/syntax (and tests here: http://daringfireball.net/projects/downloads/MarkdownTest_1.0.zip)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="markdown">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A whole number</xd:p>
         <xd:p>32 bit number; for values larger than this, use decimal</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="integer">
      <xsl:if test="@value">
         <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </number>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A date, date-time or partial date (e.g. just year or year + month).  If hours and minutes are specified, a time zone SHALL be populated. The format is a union of the schema types gYear, gYearMonth, date and dateTime. Seconds must be provided due to schema type constraints but may be zero-filled and may be ignored.                 Dates SHALL be valid dates.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="dateTime">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An integer with a value that is not negative (e.g. &gt;= 0)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="unsignedInt">
      <xsl:if test="@value">
         <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </number>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A string which has at least one character and no leading or trailing whitespace and where there is no whitespace other than single spaces in the contents</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="code">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A date or partial date (e.g. just year or year + month). There is no time zone. The format is a union of the schema types gYear, gYearMonth and date.  Dates SHALL be valid dates.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="date">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A rational number with implicit precision</xd:p>
         <xd:p>Do not use a IEEE type floating point type, instead use something that works like a true decimal, with inbuilt precision (e.g. Java BigInteger)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="decimal">
      <xsl:if test="@value">
         <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </number>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>String of characters used to identify a name or a resource</xd:p>
         <xd:p>see http://en.wikipedia.org/wiki/Uniform_resource_identifier</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="uri">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Any combination of letters, numerals, "-" and ".", with a length limit of 64 characters.  (This might be an integer, an unprefixed OID, UUID or any other identifier pattern that meets these constraints.)  Ids are case-insensitive.</xd:p>
         <xd:p>RFC 4122</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="id">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A stream of bytes</xd:p>
         <xd:p>A stream of bytes, base64 encoded</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="base64Binary">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A time during the day, with no date specified</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="time">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An oid represented as a URI</xd:p>
         <xd:p>RFC 3001. See also ISO/IEC 8824:1990 €</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="oid">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An integer with a value that is positive (e.g. &gt;0)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="positiveInt">
      <xsl:if test="@value">
         <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </number>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A sequence of Unicode characters</xd:p>
         <xd:p>Note that FHIR strings may not exceed 1MB in size</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="string">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Value of "true" or "false"</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="boolean">
      <xsl:if test="@value">
         <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </boolean>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A UUID, represented as a URI</xd:p>
         <xd:p>See The Open Group, CDE 1.1 Remote Procedure Call specification, Appendix A.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="uuid">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An instant in time - known at least to the second</xd:p>
         <xd:p>Note: This is intended for precisely observed times, typically system logs etc., and not human-reported times - for them, see date and dateTime below. Time zone is always required</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="instant">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="ResourceContainer">
            <!--Account 1..1 Account--><xsl:if test="f:Account">
         <xsl:apply-templates select="f:Account" mode="Account"/>
      </xsl:if>
            <!--AllergyIntolerance 1..1 AllergyIntolerance--><xsl:if test="f:AllergyIntolerance">
         <xsl:apply-templates select="f:AllergyIntolerance" mode="AllergyIntolerance"/>
      </xsl:if>
            <!--Appointment 1..1 Appointment--><xsl:if test="f:Appointment">
         <xsl:apply-templates select="f:Appointment" mode="Appointment"/>
      </xsl:if>
            <!--AppointmentResponse 1..1 AppointmentResponse--><xsl:if test="f:AppointmentResponse">
         <xsl:apply-templates select="f:AppointmentResponse" mode="AppointmentResponse"/>
      </xsl:if>
            <!--AuditEvent 1..1 AuditEvent--><xsl:if test="f:AuditEvent">
         <xsl:apply-templates select="f:AuditEvent" mode="AuditEvent"/>
      </xsl:if>
            <!--Basic 1..1 Basic--><xsl:if test="f:Basic">
         <xsl:apply-templates select="f:Basic" mode="Basic"/>
      </xsl:if>
            <!--Binary 1..1 Binary--><xsl:if test="f:Binary">
         <xsl:apply-templates select="f:Binary" mode="Binary"/>
      </xsl:if>
            <!--BodySite 1..1 BodySite--><xsl:if test="f:BodySite">
         <xsl:apply-templates select="f:BodySite" mode="BodySite"/>
      </xsl:if>
            <!--Bundle 1..1 Bundle--><xsl:if test="f:Bundle">
         <xsl:apply-templates select="f:Bundle" mode="Bundle"/>
      </xsl:if>
            <!--CarePlan 1..1 CarePlan--><xsl:if test="f:CarePlan">
         <xsl:apply-templates select="f:CarePlan" mode="CarePlan"/>
      </xsl:if>
            <!--Claim 1..1 Claim--><xsl:if test="f:Claim">
         <xsl:apply-templates select="f:Claim" mode="Claim"/>
      </xsl:if>
            <!--ClaimResponse 1..1 ClaimResponse--><xsl:if test="f:ClaimResponse">
         <xsl:apply-templates select="f:ClaimResponse" mode="ClaimResponse"/>
      </xsl:if>
            <!--ClinicalImpression 1..1 ClinicalImpression--><xsl:if test="f:ClinicalImpression">
         <xsl:apply-templates select="f:ClinicalImpression" mode="ClinicalImpression"/>
      </xsl:if>
            <!--Communication 1..1 Communication--><xsl:if test="f:Communication">
         <xsl:apply-templates select="f:Communication" mode="Communication"/>
      </xsl:if>
            <!--CommunicationRequest 1..1 CommunicationRequest--><xsl:if test="f:CommunicationRequest">
         <xsl:apply-templates select="f:CommunicationRequest" mode="CommunicationRequest"/>
      </xsl:if>
            <!--Composition 1..1 Composition--><xsl:if test="f:Composition">
         <xsl:apply-templates select="f:Composition" mode="Composition"/>
      </xsl:if>
            <!--ConceptMap 1..1 ConceptMap--><xsl:if test="f:ConceptMap">
         <xsl:apply-templates select="f:ConceptMap" mode="ConceptMap"/>
      </xsl:if>
            <!--Condition 1..1 Condition--><xsl:if test="f:Condition">
         <xsl:apply-templates select="f:Condition" mode="Condition"/>
      </xsl:if>
            <!--Conformance 1..1 Conformance--><xsl:if test="f:Conformance">
         <xsl:apply-templates select="f:Conformance" mode="Conformance"/>
      </xsl:if>
            <!--Contract 1..1 Contract--><xsl:if test="f:Contract">
         <xsl:apply-templates select="f:Contract" mode="Contract"/>
      </xsl:if>
            <!--Coverage 1..1 Coverage--><xsl:if test="f:Coverage">
         <xsl:apply-templates select="f:Coverage" mode="Coverage"/>
      </xsl:if>
            <!--DataElement 1..1 DataElement--><xsl:if test="f:DataElement">
         <xsl:apply-templates select="f:DataElement" mode="DataElement"/>
      </xsl:if>
            <!--DetectedIssue 1..1 DetectedIssue--><xsl:if test="f:DetectedIssue">
         <xsl:apply-templates select="f:DetectedIssue" mode="DetectedIssue"/>
      </xsl:if>
            <!--Device 1..1 Device--><xsl:if test="f:Device">
         <xsl:apply-templates select="f:Device" mode="Device"/>
      </xsl:if>
            <!--DeviceComponent 1..1 DeviceComponent--><xsl:if test="f:DeviceComponent">
         <xsl:apply-templates select="f:DeviceComponent" mode="DeviceComponent"/>
      </xsl:if>
            <!--DeviceMetric 1..1 DeviceMetric--><xsl:if test="f:DeviceMetric">
         <xsl:apply-templates select="f:DeviceMetric" mode="DeviceMetric"/>
      </xsl:if>
            <!--DeviceUseRequest 1..1 DeviceUseRequest--><xsl:if test="f:DeviceUseRequest">
         <xsl:apply-templates select="f:DeviceUseRequest" mode="DeviceUseRequest"/>
      </xsl:if>
            <!--DeviceUseStatement 1..1 DeviceUseStatement--><xsl:if test="f:DeviceUseStatement">
         <xsl:apply-templates select="f:DeviceUseStatement" mode="DeviceUseStatement"/>
      </xsl:if>
            <!--DiagnosticOrder 1..1 DiagnosticOrder--><xsl:if test="f:DiagnosticOrder">
         <xsl:apply-templates select="f:DiagnosticOrder" mode="DiagnosticOrder"/>
      </xsl:if>
            <!--DiagnosticReport 1..1 DiagnosticReport--><xsl:if test="f:DiagnosticReport">
         <xsl:apply-templates select="f:DiagnosticReport" mode="DiagnosticReport"/>
      </xsl:if>
            <!--DocumentManifest 1..1 DocumentManifest--><xsl:if test="f:DocumentManifest">
         <xsl:apply-templates select="f:DocumentManifest" mode="DocumentManifest"/>
      </xsl:if>
            <!--DocumentReference 1..1 DocumentReference--><xsl:if test="f:DocumentReference">
         <xsl:apply-templates select="f:DocumentReference" mode="DocumentReference"/>
      </xsl:if>
            <!--EligibilityRequest 1..1 EligibilityRequest--><xsl:if test="f:EligibilityRequest">
         <xsl:apply-templates select="f:EligibilityRequest" mode="EligibilityRequest"/>
      </xsl:if>
            <!--EligibilityResponse 1..1 EligibilityResponse--><xsl:if test="f:EligibilityResponse">
         <xsl:apply-templates select="f:EligibilityResponse" mode="EligibilityResponse"/>
      </xsl:if>
            <!--Encounter 1..1 Encounter--><xsl:if test="f:Encounter">
         <xsl:apply-templates select="f:Encounter" mode="Encounter"/>
      </xsl:if>
            <!--EnrollmentRequest 1..1 EnrollmentRequest--><xsl:if test="f:EnrollmentRequest">
         <xsl:apply-templates select="f:EnrollmentRequest" mode="EnrollmentRequest"/>
      </xsl:if>
            <!--EnrollmentResponse 1..1 EnrollmentResponse--><xsl:if test="f:EnrollmentResponse">
         <xsl:apply-templates select="f:EnrollmentResponse" mode="EnrollmentResponse"/>
      </xsl:if>
            <!--EpisodeOfCare 1..1 EpisodeOfCare--><xsl:if test="f:EpisodeOfCare">
         <xsl:apply-templates select="f:EpisodeOfCare" mode="EpisodeOfCare"/>
      </xsl:if>
            <!--ExplanationOfBenefit 1..1 ExplanationOfBenefit--><xsl:if test="f:ExplanationOfBenefit">
         <xsl:apply-templates select="f:ExplanationOfBenefit" mode="ExplanationOfBenefit"/>
      </xsl:if>
            <!--FamilyMemberHistory 1..1 FamilyMemberHistory--><xsl:if test="f:FamilyMemberHistory">
         <xsl:apply-templates select="f:FamilyMemberHistory" mode="FamilyMemberHistory"/>
      </xsl:if>
            <!--Flag 1..1 Flag--><xsl:if test="f:Flag">
         <xsl:apply-templates select="f:Flag" mode="Flag"/>
      </xsl:if>
            <!--Goal 1..1 Goal--><xsl:if test="f:Goal">
         <xsl:apply-templates select="f:Goal" mode="Goal"/>
      </xsl:if>
            <!--Group 1..1 Group--><xsl:if test="f:Group">
         <xsl:apply-templates select="f:Group" mode="Group"/>
      </xsl:if>
            <!--HealthcareService 1..1 HealthcareService--><xsl:if test="f:HealthcareService">
         <xsl:apply-templates select="f:HealthcareService" mode="HealthcareService"/>
      </xsl:if>
            <!--ImagingObjectSelection 1..1 ImagingObjectSelection--><xsl:if test="f:ImagingObjectSelection">
         <xsl:apply-templates select="f:ImagingObjectSelection" mode="ImagingObjectSelection"/>
      </xsl:if>
            <!--ImagingStudy 1..1 ImagingStudy--><xsl:if test="f:ImagingStudy">
         <xsl:apply-templates select="f:ImagingStudy" mode="ImagingStudy"/>
      </xsl:if>
            <!--Immunization 1..1 Immunization--><xsl:if test="f:Immunization">
         <xsl:apply-templates select="f:Immunization" mode="Immunization"/>
      </xsl:if>
            <!--ImmunizationRecommendation 1..1 ImmunizationRecommendation--><xsl:if test="f:ImmunizationRecommendation">
         <xsl:apply-templates select="f:ImmunizationRecommendation" mode="ImmunizationRecommendation"/>
      </xsl:if>
            <!--ImplementationGuide 1..1 ImplementationGuide--><xsl:if test="f:ImplementationGuide">
         <xsl:apply-templates select="f:ImplementationGuide" mode="ImplementationGuide"/>
      </xsl:if>
            <!--List 1..1 List--><xsl:if test="f:List">
         <xsl:apply-templates select="f:List" mode="List"/>
      </xsl:if>
            <!--Location 1..1 Location--><xsl:if test="f:Location">
         <xsl:apply-templates select="f:Location" mode="Location"/>
      </xsl:if>
            <!--Media 1..1 Media--><xsl:if test="f:Media">
         <xsl:apply-templates select="f:Media" mode="Media"/>
      </xsl:if>
            <!--Medication 1..1 Medication--><xsl:if test="f:Medication">
         <xsl:apply-templates select="f:Medication" mode="Medication"/>
      </xsl:if>
            <!--MedicationAdministration 1..1 MedicationAdministration--><xsl:if test="f:MedicationAdministration">
         <xsl:apply-templates select="f:MedicationAdministration" mode="MedicationAdministration"/>
      </xsl:if>
            <!--MedicationDispense 1..1 MedicationDispense--><xsl:if test="f:MedicationDispense">
         <xsl:apply-templates select="f:MedicationDispense" mode="MedicationDispense"/>
      </xsl:if>
            <!--MedicationOrder 1..1 MedicationOrder--><xsl:if test="f:MedicationOrder">
         <xsl:apply-templates select="f:MedicationOrder" mode="MedicationOrder"/>
      </xsl:if>
            <!--MedicationStatement 1..1 MedicationStatement--><xsl:if test="f:MedicationStatement">
         <xsl:apply-templates select="f:MedicationStatement" mode="MedicationStatement"/>
      </xsl:if>
            <!--MessageHeader 1..1 MessageHeader--><xsl:if test="f:MessageHeader">
         <xsl:apply-templates select="f:MessageHeader" mode="MessageHeader"/>
      </xsl:if>
            <!--NamingSystem 1..1 NamingSystem--><xsl:if test="f:NamingSystem">
         <xsl:apply-templates select="f:NamingSystem" mode="NamingSystem"/>
      </xsl:if>
            <!--NutritionOrder 1..1 NutritionOrder--><xsl:if test="f:NutritionOrder">
         <xsl:apply-templates select="f:NutritionOrder" mode="NutritionOrder"/>
      </xsl:if>
            <!--Observation 1..1 Observation--><xsl:if test="f:Observation">
         <xsl:apply-templates select="f:Observation" mode="Observation"/>
      </xsl:if>
            <!--OperationDefinition 1..1 OperationDefinition--><xsl:if test="f:OperationDefinition">
         <xsl:apply-templates select="f:OperationDefinition" mode="OperationDefinition"/>
      </xsl:if>
            <!--OperationOutcome 1..1 OperationOutcome--><xsl:if test="f:OperationOutcome">
         <xsl:apply-templates select="f:OperationOutcome" mode="OperationOutcome"/>
      </xsl:if>
            <!--Order 1..1 Order--><xsl:if test="f:Order">
         <xsl:apply-templates select="f:Order" mode="Order"/>
      </xsl:if>
            <!--OrderResponse 1..1 OrderResponse--><xsl:if test="f:OrderResponse">
         <xsl:apply-templates select="f:OrderResponse" mode="OrderResponse"/>
      </xsl:if>
            <!--Organization 1..1 Organization--><xsl:if test="f:Organization">
         <xsl:apply-templates select="f:Organization" mode="Organization"/>
      </xsl:if>
            <!--Patient 1..1 Patient--><xsl:if test="f:Patient">
         <xsl:apply-templates select="f:Patient" mode="Patient"/>
      </xsl:if>
            <!--PaymentNotice 1..1 PaymentNotice--><xsl:if test="f:PaymentNotice">
         <xsl:apply-templates select="f:PaymentNotice" mode="PaymentNotice"/>
      </xsl:if>
            <!--PaymentReconciliation 1..1 PaymentReconciliation--><xsl:if test="f:PaymentReconciliation">
         <xsl:apply-templates select="f:PaymentReconciliation" mode="PaymentReconciliation"/>
      </xsl:if>
            <!--Person 1..1 Person--><xsl:if test="f:Person">
         <xsl:apply-templates select="f:Person" mode="Person"/>
      </xsl:if>
            <!--Practitioner 1..1 Practitioner--><xsl:if test="f:Practitioner">
         <xsl:apply-templates select="f:Practitioner" mode="Practitioner"/>
      </xsl:if>
            <!--Procedure 1..1 Procedure--><xsl:if test="f:Procedure">
         <xsl:apply-templates select="f:Procedure" mode="Procedure"/>
      </xsl:if>
            <!--ProcedureRequest 1..1 ProcedureRequest--><xsl:if test="f:ProcedureRequest">
         <xsl:apply-templates select="f:ProcedureRequest" mode="ProcedureRequest"/>
      </xsl:if>
            <!--ProcessRequest 1..1 ProcessRequest--><xsl:if test="f:ProcessRequest">
         <xsl:apply-templates select="f:ProcessRequest" mode="ProcessRequest"/>
      </xsl:if>
            <!--ProcessResponse 1..1 ProcessResponse--><xsl:if test="f:ProcessResponse">
         <xsl:apply-templates select="f:ProcessResponse" mode="ProcessResponse"/>
      </xsl:if>
            <!--Provenance 1..1 Provenance--><xsl:if test="f:Provenance">
         <xsl:apply-templates select="f:Provenance" mode="Provenance"/>
      </xsl:if>
            <!--Questionnaire 1..1 Questionnaire--><xsl:if test="f:Questionnaire">
         <xsl:apply-templates select="f:Questionnaire" mode="Questionnaire"/>
      </xsl:if>
            <!--QuestionnaireResponse 1..1 QuestionnaireResponse--><xsl:if test="f:QuestionnaireResponse">
         <xsl:apply-templates select="f:QuestionnaireResponse" mode="QuestionnaireResponse"/>
      </xsl:if>
            <!--ReferralRequest 1..1 ReferralRequest--><xsl:if test="f:ReferralRequest">
         <xsl:apply-templates select="f:ReferralRequest" mode="ReferralRequest"/>
      </xsl:if>
            <!--RelatedPerson 1..1 RelatedPerson--><xsl:if test="f:RelatedPerson">
         <xsl:apply-templates select="f:RelatedPerson" mode="RelatedPerson"/>
      </xsl:if>
            <!--RiskAssessment 1..1 RiskAssessment--><xsl:if test="f:RiskAssessment">
         <xsl:apply-templates select="f:RiskAssessment" mode="RiskAssessment"/>
      </xsl:if>
            <!--Schedule 1..1 Schedule--><xsl:if test="f:Schedule">
         <xsl:apply-templates select="f:Schedule" mode="Schedule"/>
      </xsl:if>
            <!--SearchParameter 1..1 SearchParameter--><xsl:if test="f:SearchParameter">
         <xsl:apply-templates select="f:SearchParameter" mode="SearchParameter"/>
      </xsl:if>
            <!--Slot 1..1 Slot--><xsl:if test="f:Slot">
         <xsl:apply-templates select="f:Slot" mode="Slot"/>
      </xsl:if>
            <!--Specimen 1..1 Specimen--><xsl:if test="f:Specimen">
         <xsl:apply-templates select="f:Specimen" mode="Specimen"/>
      </xsl:if>
            <!--StructureDefinition 1..1 StructureDefinition--><xsl:if test="f:StructureDefinition">
         <xsl:apply-templates select="f:StructureDefinition" mode="StructureDefinition"/>
      </xsl:if>
            <!--Subscription 1..1 Subscription--><xsl:if test="f:Subscription">
         <xsl:apply-templates select="f:Subscription" mode="Subscription"/>
      </xsl:if>
            <!--Substance 1..1 Substance--><xsl:if test="f:Substance">
         <xsl:apply-templates select="f:Substance" mode="Substance"/>
      </xsl:if>
            <!--SupplyDelivery 1..1 SupplyDelivery--><xsl:if test="f:SupplyDelivery">
         <xsl:apply-templates select="f:SupplyDelivery" mode="SupplyDelivery"/>
      </xsl:if>
            <!--SupplyRequest 1..1 SupplyRequest--><xsl:if test="f:SupplyRequest">
         <xsl:apply-templates select="f:SupplyRequest" mode="SupplyRequest"/>
      </xsl:if>
            <!--TestScript 1..1 TestScript--><xsl:if test="f:TestScript">
         <xsl:apply-templates select="f:TestScript" mode="TestScript"/>
      </xsl:if>
            <!--ValueSet 1..1 ValueSet--><xsl:if test="f:ValueSet">
         <xsl:apply-templates select="f:ValueSet" mode="ValueSet"/>
      </xsl:if>
            <!--VisionPrescription 1..1 VisionPrescription--><xsl:if test="f:VisionPrescription">
         <xsl:apply-templates select="f:VisionPrescription" mode="VisionPrescription"/>
      </xsl:if>
            <!--Parameters 1..1 Parameters--><xsl:if test="f:Parameters">
         <xsl:apply-templates select="f:Parameters" mode="Parameters"/>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Optional Extensions Element - found in all resources.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Extension">
      <xsl:if test="@url">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
            <xsl:value-of select="@url"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
                    
                        
                        <!--valueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:valueBoolean">
         <xsl:if test="f:valueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean">
               <xsl:value-of select="f:valueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:valueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueBoolean">
               <xsl:apply-templates select="f:valueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueInteger 1..1 integer (json type: number)--><xsl:if test="f:valueInteger">
         <xsl:if test="f:valueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueInteger">
               <xsl:value-of select="f:valueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueInteger">
               <xsl:apply-templates select="f:valueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:valueDecimal">
         <xsl:if test="f:valueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueDecimal">
               <xsl:value-of select="f:valueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDecimal">
               <xsl:apply-templates select="f:valueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:valueBase64Binary">
         <xsl:if test="f:valueBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBase64Binary">
               <xsl:value-of select="f:valueBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueBase64Binary">
               <xsl:apply-templates select="f:valueBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueInstant 1..1 instant (json type: string)--><xsl:if test="f:valueInstant">
         <xsl:if test="f:valueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInstant">
               <xsl:value-of select="f:valueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueInstant">
               <xsl:apply-templates select="f:valueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueString 1..1 string (json type: string)--><xsl:if test="f:valueString">
         <xsl:if test="f:valueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString">
               <xsl:value-of select="f:valueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueString">
               <xsl:apply-templates select="f:valueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueUri 1..1 uri (json type: string)--><xsl:if test="f:valueUri">
         <xsl:if test="f:valueUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUri">
               <xsl:value-of select="f:valueUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueUri">
               <xsl:apply-templates select="f:valueUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueDate 1..1 date (json type: string)--><xsl:if test="f:valueDate">
         <xsl:if test="f:valueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDate">
               <xsl:value-of select="f:valueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDate">
               <xsl:apply-templates select="f:valueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:valueDateTime">
         <xsl:if test="f:valueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime">
               <xsl:value-of select="f:valueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDateTime">
               <xsl:apply-templates select="f:valueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueTime 1..1 time (json type: string)--><xsl:if test="f:valueTime">
         <xsl:if test="f:valueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueTime">
               <xsl:value-of select="f:valueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueTime">
               <xsl:apply-templates select="f:valueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueCode 1..1 code (json type: string)--><xsl:if test="f:valueCode">
         <xsl:if test="f:valueCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode">
               <xsl:value-of select="f:valueCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueCode">
               <xsl:apply-templates select="f:valueCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueOid 1..1 oid (json type: string)--><xsl:if test="f:valueOid">
         <xsl:if test="f:valueOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueOid">
               <xsl:value-of select="f:valueOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueOid">
               <xsl:apply-templates select="f:valueOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueUuid 1..1 uuid (json type: string)--><xsl:if test="f:valueUuid">
         <xsl:if test="f:valueUuid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUuid">
               <xsl:value-of select="f:valueUuid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueUuid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueUuid">
               <xsl:apply-templates select="f:valueUuid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueId 1..1 id (json type: string)--><xsl:if test="f:valueId">
         <xsl:if test="f:valueId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueId">
               <xsl:value-of select="f:valueId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueId">
               <xsl:apply-templates select="f:valueId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:valueUnsignedInt">
         <xsl:if test="f:valueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueUnsignedInt">
               <xsl:value-of select="f:valueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueUnsignedInt">
               <xsl:apply-templates select="f:valueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:valuePositiveInt">
         <xsl:if test="f:valuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valuePositiveInt">
               <xsl:value-of select="f:valuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valuePositiveInt">
               <xsl:apply-templates select="f:valuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:valueMarkdown">
         <xsl:if test="f:valueMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueMarkdown">
               <xsl:value-of select="f:valueMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueMarkdown">
               <xsl:apply-templates select="f:valueMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueAnnotation 1..1 Annotation--><xsl:if test="f:valueAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAnnotation">
            <xsl:apply-templates select="f:valueAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
                        <!--valueAttachment 1..1 Attachment--><xsl:if test="f:valueAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAttachment">
            <xsl:apply-templates select="f:valueAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--valueIdentifier 1..1 Identifier--><xsl:if test="f:valueIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueIdentifier">
            <xsl:apply-templates select="f:valueIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                        <!--valueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:valueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCodeableConcept">
            <xsl:apply-templates select="f:valueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--valueCoding 1..1 Coding--><xsl:if test="f:valueCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCoding">
            <xsl:apply-templates select="f:valueCoding" mode="Coding"/>
         </map>
      </xsl:if>
                        <!--valueQuantity 1..1 Quantity--><xsl:if test="f:valueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueQuantity">
            <xsl:apply-templates select="f:valueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
                        <!--valueRange 1..1 Range--><xsl:if test="f:valueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueRange">
            <xsl:apply-templates select="f:valueRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--valuePeriod 1..1 Period--><xsl:if test="f:valuePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valuePeriod">
            <xsl:apply-templates select="f:valuePeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--valueRatio 1..1 Ratio--><xsl:if test="f:valueRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueRatio">
            <xsl:apply-templates select="f:valueRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--valueReference 1..1 Reference--><xsl:if test="f:valueReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueReference">
            <xsl:apply-templates select="f:valueReference" mode="Reference"/>
         </map>
      </xsl:if>
                        <!--valueSampledData 1..1 SampledData--><xsl:if test="f:valueSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSampledData">
            <xsl:apply-templates select="f:valueSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
                        <!--valueSignature 1..1 Signature--><xsl:if test="f:valueSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSignature">
            <xsl:apply-templates select="f:valueSignature" mode="Signature"/>
         </map>
      </xsl:if>
                        <!--valueHumanName 1..1 HumanName--><xsl:if test="f:valueHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueHumanName">
            <xsl:apply-templates select="f:valueHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
                        <!--valueAddress 1..1 Address--><xsl:if test="f:valueAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAddress">
            <xsl:apply-templates select="f:valueAddress" mode="Address"/>
         </map>
      </xsl:if>
                        <!--valueContactPoint 1..1 ContactPoint--><xsl:if test="f:valueContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueContactPoint">
            <xsl:apply-templates select="f:valueContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
                        <!--valueTiming 1..1 Timing--><xsl:if test="f:valueTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueTiming">
            <xsl:apply-templates select="f:valueTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--valueMeta 1..1 Meta--><xsl:if test="f:valueMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueMeta">
            <xsl:apply-templates select="f:valueMeta" mode="Meta"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Base definition for all elements that are defined inside a resource - but not those in a data type.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="BackboneElement">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--modifierExtension 0..* Extension--><xsl:if test="f:modifierExtension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifierExtension">
            <xsl:for-each select="f:modifierExtension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A human-readable formatted text, including images.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Narrative">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--status 1..1 NarrativeStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--xhtml:div 1..1 --><xsl:if test="xhtml:div">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="div">
            <xsl:value-of select="fn:serialize(xhtml:div)"/>
         </string>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of a resource narrative</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="NarrativeStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Base definition for all elements in a resource.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Element">
      <xsl:if test="@id">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
            <xsl:value-of select="@id"/>
         </string>
      </xsl:if>
            <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A time period defined by a start and end date and optionally time.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Period">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--start 0..1 dateTime (json type: string)--><xsl:if test="f:start">
         <xsl:if test="f:start/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="start">
               <xsl:value-of select="f:start/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:start[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_start">
               <xsl:apply-templates select="f:start" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--end 0..1 dateTime (json type: string)--><xsl:if test="f:end">
         <xsl:if test="f:end/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="end">
               <xsl:value-of select="f:end/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:end[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_end">
               <xsl:apply-templates select="f:end" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a code defined by a terminology system.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Coding">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--userSelected 0..1 boolean (json type: boolean)--><xsl:if test="f:userSelected">
         <xsl:if test="f:userSelected/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="userSelected">
               <xsl:value-of select="f:userSelected/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:userSelected[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_userSelected">
               <xsl:apply-templates select="f:userSelected" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of ordered Quantities defined by a low and high limit.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Range">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--low 0..1 SimpleQuantity--><xsl:if test="f:low">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="low">
            <xsl:apply-templates select="f:low" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--high 0..1 SimpleQuantity--><xsl:if test="f:high">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="high">
            <xsl:apply-templates select="f:high" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A measured amount (or an amount that can potentially be measured). Note that measured amounts include amounts that are not precisely quantified, including amounts involving arbitrary units and floating currencies.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Quantity">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comparator 0..1 QuantityComparator (json type: string)--><xsl:if test="f:comparator">
         <xsl:if test="f:comparator/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator">
               <xsl:value-of select="f:comparator/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comparator[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comparator">
               <xsl:apply-templates select="f:comparator" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--unit 0..1 string (json type: string)--><xsl:if test="f:unit">
         <xsl:if test="f:unit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
               <xsl:value-of select="f:unit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:unit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_unit">
               <xsl:apply-templates select="f:unit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How the Quantity should be understood and represented.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="QuantityComparator">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>For referring to data content defined in other formats.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Attachment">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--contentType 0..1 code (json type: string)--><xsl:if test="f:contentType">
         <xsl:if test="f:contentType/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType">
               <xsl:value-of select="f:contentType/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentType[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentType">
               <xsl:apply-templates select="f:contentType" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--data 0..1 base64Binary (json type: string)--><xsl:if test="f:data">
         <xsl:if test="f:data/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="data">
               <xsl:value-of select="f:data/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:data[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_data">
               <xsl:apply-templates select="f:data" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--size 0..1 unsignedInt (json type: number)--><xsl:if test="f:size">
         <xsl:if test="f:size/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="size">
               <xsl:value-of select="f:size/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:size[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_size">
               <xsl:apply-templates select="f:size" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--hash 0..1 base64Binary (json type: string)--><xsl:if test="f:hash">
         <xsl:if test="f:hash/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="hash">
               <xsl:value-of select="f:hash/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:hash[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_hash">
               <xsl:apply-templates select="f:hash" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--creation 0..1 dateTime (json type: string)--><xsl:if test="f:creation">
         <xsl:if test="f:creation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="creation">
               <xsl:value-of select="f:creation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:creation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_creation">
               <xsl:apply-templates select="f:creation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A relationship of two Quantity values - expressed as a numerator and a denominator.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Ratio">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--numerator 0..1 Quantity--><xsl:if test="f:numerator">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="numerator">
            <xsl:apply-templates select="f:numerator" mode="Quantity"/>
         </map>
      </xsl:if>
                    <!--denominator 0..1 Quantity--><xsl:if test="f:denominator">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="denominator">
            <xsl:apply-templates select="f:denominator" mode="Quantity"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A  text note which also  contains information about who made the statement and when.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Annotation">
      <xsl:apply-templates select="." mode="Element"/>
                    
                        
                        <!--authorReference 1..1 Reference--><xsl:if test="f:authorReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="authorReference">
            <xsl:apply-templates select="f:authorReference" mode="Reference"/>
         </map>
      </xsl:if>
                        <!--authorString 1..1 string (json type: string)--><xsl:if test="f:authorString">
         <xsl:if test="f:authorString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="authorString">
               <xsl:value-of select="f:authorString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:authorString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_authorString">
               <xsl:apply-templates select="f:authorString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    <!--time 0..1 dateTime (json type: string)--><xsl:if test="f:time">
         <xsl:if test="f:time/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="time">
               <xsl:value-of select="f:time/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:time[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_time">
               <xsl:apply-templates select="f:time" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--text 1..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A series of measurements taken by a device, with upper and lower limits. There may be more than one dimension in the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SampledData">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--origin 1..1 SimpleQuantity--><xsl:if test="f:origin">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="origin">
            <xsl:apply-templates select="f:origin" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--period 1..1 decimal (json type: number)--><xsl:if test="f:period">
         <xsl:if test="f:period/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="period">
               <xsl:value-of select="f:period/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:period[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_period">
               <xsl:apply-templates select="f:period" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--lowerLimit 0..1 decimal (json type: number)--><xsl:if test="f:lowerLimit">
         <xsl:if test="f:lowerLimit/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="lowerLimit">
               <xsl:value-of select="f:lowerLimit/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:lowerLimit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lowerLimit">
               <xsl:apply-templates select="f:lowerLimit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--upperLimit 0..1 decimal (json type: number)--><xsl:if test="f:upperLimit">
         <xsl:if test="f:upperLimit/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="upperLimit">
               <xsl:value-of select="f:upperLimit/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:upperLimit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_upperLimit">
               <xsl:apply-templates select="f:upperLimit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--dimensions 1..1 positiveInt (json type: number)--><xsl:if test="f:dimensions">
         <xsl:if test="f:dimensions/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="dimensions">
               <xsl:value-of select="f:dimensions/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:dimensions[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dimensions">
               <xsl:apply-templates select="f:dimensions" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--data 1..1 SampledDataDataType (json type: string)--><xsl:if test="f:data">
         <xsl:if test="f:data/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="data">
               <xsl:value-of select="f:data/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:data[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_data">
               <xsl:apply-templates select="f:data" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="SampledDataDataType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference from one resource to another.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Reference">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--reference 0..1 string (json type: string)--><xsl:if test="f:reference">
         <xsl:if test="f:reference/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
               <xsl:value-of select="f:reference/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:reference[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reference">
               <xsl:apply-templates select="f:reference" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A concept that may be defined by a formal reference to a terminology or ontology or may be provided by text.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeableConcept">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--coding 0..* Coding--><xsl:if test="f:coding">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="coding">
            <xsl:for-each select="f:coding">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A technical identifier - identifies some entity uniquely and unambiguously.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Identifier">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--use 0..1 IdentifierUse (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--value 0..1 string (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--assigner 0..1 Reference--><xsl:if test="f:assigner">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="assigner">
            <xsl:apply-templates select="f:assigner" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Identifies the purpose for this identifier, if known .</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="IdentifierUse">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A digital signature along with supporting context. The signature may be electronic/cryptographic in nature, or a graphical image representing a hand-written signature, or a signature process. Different Signature approaches have different utilities.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Signature">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--type 1..* Coding--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--when 1..1 instant (json type: string)--><xsl:if test="f:when">
         <xsl:if test="f:when/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="when">
               <xsl:value-of select="f:when/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:when[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_when">
               <xsl:apply-templates select="f:when" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--whoUri 1..1 uri (json type: string)--><xsl:if test="f:whoUri">
         <xsl:if test="f:whoUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="whoUri">
               <xsl:value-of select="f:whoUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:whoUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_whoUri">
               <xsl:apply-templates select="f:whoUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--whoReference 1..1 Reference--><xsl:if test="f:whoReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="whoReference">
            <xsl:apply-templates select="f:whoReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--contentType 1..1 code (json type: string)--><xsl:if test="f:contentType">
         <xsl:if test="f:contentType/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType">
               <xsl:value-of select="f:contentType/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentType[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentType">
               <xsl:apply-templates select="f:contentType" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--blob 1..1 base64Binary (json type: string)--><xsl:if test="f:blob">
         <xsl:if test="f:blob/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="blob">
               <xsl:value-of select="f:blob/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:blob[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_blob">
               <xsl:apply-templates select="f:blob" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="Age">
      <xsl:if test="@id">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
            <xsl:value-of select="@id"/>
         </string>
      </xsl:if>
                    <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comparator 0..1 QuantityComparator (json type: string)--><xsl:if test="f:comparator">
         <xsl:if test="f:comparator/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator">
               <xsl:value-of select="f:comparator/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comparator[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comparator">
               <xsl:apply-templates select="f:comparator" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--unit 0..1 string (json type: string)--><xsl:if test="f:unit">
         <xsl:if test="f:unit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
               <xsl:value-of select="f:unit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:unit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_unit">
               <xsl:apply-templates select="f:unit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="Count">
      <xsl:if test="@id">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
            <xsl:value-of select="@id"/>
         </string>
      </xsl:if>
                    <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comparator 0..1 QuantityComparator (json type: string)--><xsl:if test="f:comparator">
         <xsl:if test="f:comparator/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator">
               <xsl:value-of select="f:comparator/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comparator[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comparator">
               <xsl:apply-templates select="f:comparator" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--unit 0..1 string (json type: string)--><xsl:if test="f:unit">
         <xsl:if test="f:unit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
               <xsl:value-of select="f:unit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:unit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_unit">
               <xsl:apply-templates select="f:unit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="Money">
      <xsl:if test="@id">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
            <xsl:value-of select="@id"/>
         </string>
      </xsl:if>
                    <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comparator 0..1 QuantityComparator (json type: string)--><xsl:if test="f:comparator">
         <xsl:if test="f:comparator/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator">
               <xsl:value-of select="f:comparator/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comparator[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comparator">
               <xsl:apply-templates select="f:comparator" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--unit 0..1 string (json type: string)--><xsl:if test="f:unit">
         <xsl:if test="f:unit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
               <xsl:value-of select="f:unit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:unit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_unit">
               <xsl:apply-templates select="f:unit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="Distance">
      <xsl:if test="@id">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
            <xsl:value-of select="@id"/>
         </string>
      </xsl:if>
                    <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comparator 0..1 QuantityComparator (json type: string)--><xsl:if test="f:comparator">
         <xsl:if test="f:comparator/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator">
               <xsl:value-of select="f:comparator/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comparator[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comparator">
               <xsl:apply-templates select="f:comparator" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--unit 0..1 string (json type: string)--><xsl:if test="f:unit">
         <xsl:if test="f:unit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
               <xsl:value-of select="f:unit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:unit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_unit">
               <xsl:apply-templates select="f:unit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="Duration">
      <xsl:if test="@id">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
            <xsl:value-of select="@id"/>
         </string>
      </xsl:if>
                    <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comparator 0..1 QuantityComparator (json type: string)--><xsl:if test="f:comparator">
         <xsl:if test="f:comparator/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator">
               <xsl:value-of select="f:comparator/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comparator[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comparator">
               <xsl:apply-templates select="f:comparator" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--unit 0..1 string (json type: string)--><xsl:if test="f:unit">
         <xsl:if test="f:unit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
               <xsl:value-of select="f:unit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:unit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_unit">
               <xsl:apply-templates select="f:unit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="SimpleQuantity">
      <xsl:if test="@id">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
            <xsl:value-of select="@id"/>
         </string>
      </xsl:if>
                    <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comparator 0..0 QuantityComparator (json type: string)--><xsl:if test="f:comparator">
         <xsl:if test="f:comparator/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator">
               <xsl:value-of select="f:comparator/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comparator[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comparator">
               <xsl:apply-templates select="f:comparator" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--unit 0..1 string (json type: string)--><xsl:if test="f:unit">
         <xsl:if test="f:unit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
               <xsl:value-of select="f:unit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:unit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_unit">
               <xsl:apply-templates select="f:unit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--path 1..1 string (json type: string)--><xsl:if test="f:path">
         <xsl:if test="f:path/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="path">
               <xsl:value-of select="f:path/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:path[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_path">
               <xsl:apply-templates select="f:path" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--representation 0..* PropertyRepresentation (json type: string)--><xsl:if test="f:representation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="representation">
            <xsl:for-each select="f:representation">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:representation[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_representation">
               <xsl:for-each select="f:representation">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--label 0..1 string (json type: string)--><xsl:if test="f:label">
         <xsl:if test="f:label/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="label">
               <xsl:value-of select="f:label/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:label[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_label">
               <xsl:apply-templates select="f:label" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..* Coding--><xsl:if test="f:code">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:for-each select="f:code">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--slicing 0..1 ElementDefinition.Slicing--><xsl:if test="f:slicing">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="slicing">
            <xsl:apply-templates select="f:slicing" mode="ElementDefinition.Slicing"/>
         </map>
      </xsl:if>
                    <!--short 0..1 string (json type: string)--><xsl:if test="f:short">
         <xsl:if test="f:short/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="short">
               <xsl:value-of select="f:short/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:short[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_short">
               <xsl:apply-templates select="f:short" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--definition 0..1 markdown (json type: string)--><xsl:if test="f:definition">
         <xsl:if test="f:definition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
               <xsl:value-of select="f:definition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:definition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_definition">
               <xsl:apply-templates select="f:definition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comments 0..1 markdown (json type: string)--><xsl:if test="f:comments">
         <xsl:if test="f:comments/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comments">
               <xsl:value-of select="f:comments/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comments[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comments">
               <xsl:apply-templates select="f:comments" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--requirements 0..1 markdown (json type: string)--><xsl:if test="f:requirements">
         <xsl:if test="f:requirements/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements">
               <xsl:value-of select="f:requirements/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:requirements[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requirements">
               <xsl:apply-templates select="f:requirements" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--alias 0..* string (json type: string)--><xsl:if test="f:alias">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="alias">
            <xsl:for-each select="f:alias">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:alias[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_alias">
               <xsl:for-each select="f:alias">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--min 0..1 integer (json type: number)--><xsl:if test="f:min">
         <xsl:if test="f:min/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="min">
               <xsl:value-of select="f:min/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:min[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_min">
               <xsl:apply-templates select="f:min" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--max 0..1 string (json type: string)--><xsl:if test="f:max">
         <xsl:if test="f:max/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="max">
               <xsl:value-of select="f:max/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:max[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_max">
               <xsl:apply-templates select="f:max" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--base 0..1 ElementDefinition.Base--><xsl:if test="f:base">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="base">
            <xsl:apply-templates select="f:base" mode="ElementDefinition.Base"/>
         </map>
      </xsl:if>
                    <!--type 0..* ElementDefinition.Type--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition.Type"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--nameReference 0..1 string (json type: string)--><xsl:if test="f:nameReference">
         <xsl:if test="f:nameReference/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="nameReference">
               <xsl:value-of select="f:nameReference/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:nameReference[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_nameReference">
               <xsl:apply-templates select="f:nameReference" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--defaultValueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:defaultValueBoolean">
         <xsl:if test="f:defaultValueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueBoolean">
               <xsl:value-of select="f:defaultValueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:defaultValueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueBoolean">
               <xsl:apply-templates select="f:defaultValueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueInteger 1..1 integer (json type: number)--><xsl:if test="f:defaultValueInteger">
         <xsl:if test="f:defaultValueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueInteger">
               <xsl:value-of select="f:defaultValueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:defaultValueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueInteger">
               <xsl:apply-templates select="f:defaultValueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:defaultValueDecimal">
         <xsl:if test="f:defaultValueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDecimal">
               <xsl:value-of select="f:defaultValueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:defaultValueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueDecimal">
               <xsl:apply-templates select="f:defaultValueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:defaultValueBase64Binary">
         <xsl:if test="f:defaultValueBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions"
                    key="defaultValueBase64Binary">
               <xsl:value-of select="f:defaultValueBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_defaultValueBase64Binary">
               <xsl:apply-templates select="f:defaultValueBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueInstant 1..1 instant (json type: string)--><xsl:if test="f:defaultValueInstant">
         <xsl:if test="f:defaultValueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueInstant">
               <xsl:value-of select="f:defaultValueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueInstant">
               <xsl:apply-templates select="f:defaultValueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueString 1..1 string (json type: string)--><xsl:if test="f:defaultValueString">
         <xsl:if test="f:defaultValueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueString">
               <xsl:value-of select="f:defaultValueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueString">
               <xsl:apply-templates select="f:defaultValueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueUri 1..1 uri (json type: string)--><xsl:if test="f:defaultValueUri">
         <xsl:if test="f:defaultValueUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueUri">
               <xsl:value-of select="f:defaultValueUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueUri">
               <xsl:apply-templates select="f:defaultValueUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueDate 1..1 date (json type: string)--><xsl:if test="f:defaultValueDate">
         <xsl:if test="f:defaultValueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDate">
               <xsl:value-of select="f:defaultValueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueDate">
               <xsl:apply-templates select="f:defaultValueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:defaultValueDateTime">
         <xsl:if test="f:defaultValueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDateTime">
               <xsl:value-of select="f:defaultValueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueDateTime">
               <xsl:apply-templates select="f:defaultValueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueTime 1..1 time (json type: string)--><xsl:if test="f:defaultValueTime">
         <xsl:if test="f:defaultValueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueTime">
               <xsl:value-of select="f:defaultValueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueTime">
               <xsl:apply-templates select="f:defaultValueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueCode 1..1 code (json type: string)--><xsl:if test="f:defaultValueCode">
         <xsl:if test="f:defaultValueCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueCode">
               <xsl:value-of select="f:defaultValueCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueCode">
               <xsl:apply-templates select="f:defaultValueCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueOid 1..1 oid (json type: string)--><xsl:if test="f:defaultValueOid">
         <xsl:if test="f:defaultValueOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueOid">
               <xsl:value-of select="f:defaultValueOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueOid">
               <xsl:apply-templates select="f:defaultValueOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueUuid 1..1 uuid (json type: string)--><xsl:if test="f:defaultValueUuid">
         <xsl:if test="f:defaultValueUuid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueUuid">
               <xsl:value-of select="f:defaultValueUuid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueUuid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueUuid">
               <xsl:apply-templates select="f:defaultValueUuid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueId 1..1 id (json type: string)--><xsl:if test="f:defaultValueId">
         <xsl:if test="f:defaultValueId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueId">
               <xsl:value-of select="f:defaultValueId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueId">
               <xsl:apply-templates select="f:defaultValueId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:defaultValueUnsignedInt">
         <xsl:if test="f:defaultValueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions"
                    key="defaultValueUnsignedInt">
               <xsl:value-of select="f:defaultValueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:defaultValueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_defaultValueUnsignedInt">
               <xsl:apply-templates select="f:defaultValueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:defaultValuePositiveInt">
         <xsl:if test="f:defaultValuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions"
                    key="defaultValuePositiveInt">
               <xsl:value-of select="f:defaultValuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:defaultValuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_defaultValuePositiveInt">
               <xsl:apply-templates select="f:defaultValuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:defaultValueMarkdown">
         <xsl:if test="f:defaultValueMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueMarkdown">
               <xsl:value-of select="f:defaultValueMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueMarkdown">
               <xsl:apply-templates select="f:defaultValueMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--defaultValueAnnotation 1..1 Annotation--><xsl:if test="f:defaultValueAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueAnnotation">
            <xsl:apply-templates select="f:defaultValueAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
                        <!--defaultValueAttachment 1..1 Attachment--><xsl:if test="f:defaultValueAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueAttachment">
            <xsl:apply-templates select="f:defaultValueAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--defaultValueIdentifier 1..1 Identifier--><xsl:if test="f:defaultValueIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueIdentifier">
            <xsl:apply-templates select="f:defaultValueIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                        <!--defaultValueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:defaultValueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="defaultValueCodeableConcept">
            <xsl:apply-templates select="f:defaultValueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--defaultValueCoding 1..1 Coding--><xsl:if test="f:defaultValueCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueCoding">
            <xsl:apply-templates select="f:defaultValueCoding" mode="Coding"/>
         </map>
      </xsl:if>
                        <!--defaultValueQuantity 1..1 Quantity--><xsl:if test="f:defaultValueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueQuantity">
            <xsl:apply-templates select="f:defaultValueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
                        <!--defaultValueRange 1..1 Range--><xsl:if test="f:defaultValueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueRange">
            <xsl:apply-templates select="f:defaultValueRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--defaultValuePeriod 1..1 Period--><xsl:if test="f:defaultValuePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValuePeriod">
            <xsl:apply-templates select="f:defaultValuePeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--defaultValueRatio 1..1 Ratio--><xsl:if test="f:defaultValueRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueRatio">
            <xsl:apply-templates select="f:defaultValueRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--defaultValueReference 1..1 Reference--><xsl:if test="f:defaultValueReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueReference">
            <xsl:apply-templates select="f:defaultValueReference" mode="Reference"/>
         </map>
      </xsl:if>
                        <!--defaultValueSampledData 1..1 SampledData--><xsl:if test="f:defaultValueSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="defaultValueSampledData">
            <xsl:apply-templates select="f:defaultValueSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
                        <!--defaultValueSignature 1..1 Signature--><xsl:if test="f:defaultValueSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueSignature">
            <xsl:apply-templates select="f:defaultValueSignature" mode="Signature"/>
         </map>
      </xsl:if>
                        <!--defaultValueHumanName 1..1 HumanName--><xsl:if test="f:defaultValueHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueHumanName">
            <xsl:apply-templates select="f:defaultValueHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
                        <!--defaultValueAddress 1..1 Address--><xsl:if test="f:defaultValueAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueAddress">
            <xsl:apply-templates select="f:defaultValueAddress" mode="Address"/>
         </map>
      </xsl:if>
                        <!--defaultValueContactPoint 1..1 ContactPoint--><xsl:if test="f:defaultValueContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="defaultValueContactPoint">
            <xsl:apply-templates select="f:defaultValueContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
                        <!--defaultValueTiming 1..1 Timing--><xsl:if test="f:defaultValueTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueTiming">
            <xsl:apply-templates select="f:defaultValueTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--defaultValueMeta 1..1 Meta--><xsl:if test="f:defaultValueMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueMeta">
            <xsl:apply-templates select="f:defaultValueMeta" mode="Meta"/>
         </map>
      </xsl:if>
                    
                    <!--meaningWhenMissing 0..1 markdown (json type: string)--><xsl:if test="f:meaningWhenMissing">
         <xsl:if test="f:meaningWhenMissing/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="meaningWhenMissing">
               <xsl:value-of select="f:meaningWhenMissing/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:meaningWhenMissing[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_meaningWhenMissing">
               <xsl:apply-templates select="f:meaningWhenMissing" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--fixedBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:fixedBoolean">
         <xsl:if test="f:fixedBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="fixedBoolean">
               <xsl:value-of select="f:fixedBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:fixedBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedBoolean">
               <xsl:apply-templates select="f:fixedBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedInteger 1..1 integer (json type: number)--><xsl:if test="f:fixedInteger">
         <xsl:if test="f:fixedInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="fixedInteger">
               <xsl:value-of select="f:fixedInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:fixedInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedInteger">
               <xsl:apply-templates select="f:fixedInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedDecimal 1..1 decimal (json type: number)--><xsl:if test="f:fixedDecimal">
         <xsl:if test="f:fixedDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDecimal">
               <xsl:value-of select="f:fixedDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:fixedDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedDecimal">
               <xsl:apply-templates select="f:fixedDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:fixedBase64Binary">
         <xsl:if test="f:fixedBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedBase64Binary">
               <xsl:value-of select="f:fixedBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedBase64Binary">
               <xsl:apply-templates select="f:fixedBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedInstant 1..1 instant (json type: string)--><xsl:if test="f:fixedInstant">
         <xsl:if test="f:fixedInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedInstant">
               <xsl:value-of select="f:fixedInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedInstant">
               <xsl:apply-templates select="f:fixedInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedString 1..1 string (json type: string)--><xsl:if test="f:fixedString">
         <xsl:if test="f:fixedString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedString">
               <xsl:value-of select="f:fixedString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedString">
               <xsl:apply-templates select="f:fixedString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedUri 1..1 uri (json type: string)--><xsl:if test="f:fixedUri">
         <xsl:if test="f:fixedUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUri">
               <xsl:value-of select="f:fixedUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedUri">
               <xsl:apply-templates select="f:fixedUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedDate 1..1 date (json type: string)--><xsl:if test="f:fixedDate">
         <xsl:if test="f:fixedDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDate">
               <xsl:value-of select="f:fixedDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedDate">
               <xsl:apply-templates select="f:fixedDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:fixedDateTime">
         <xsl:if test="f:fixedDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDateTime">
               <xsl:value-of select="f:fixedDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedDateTime">
               <xsl:apply-templates select="f:fixedDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedTime 1..1 time (json type: string)--><xsl:if test="f:fixedTime">
         <xsl:if test="f:fixedTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedTime">
               <xsl:value-of select="f:fixedTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedTime">
               <xsl:apply-templates select="f:fixedTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedCode 1..1 code (json type: string)--><xsl:if test="f:fixedCode">
         <xsl:if test="f:fixedCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCode">
               <xsl:value-of select="f:fixedCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedCode">
               <xsl:apply-templates select="f:fixedCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedOid 1..1 oid (json type: string)--><xsl:if test="f:fixedOid">
         <xsl:if test="f:fixedOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedOid">
               <xsl:value-of select="f:fixedOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedOid">
               <xsl:apply-templates select="f:fixedOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedUuid 1..1 uuid (json type: string)--><xsl:if test="f:fixedUuid">
         <xsl:if test="f:fixedUuid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUuid">
               <xsl:value-of select="f:fixedUuid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedUuid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedUuid">
               <xsl:apply-templates select="f:fixedUuid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedId 1..1 id (json type: string)--><xsl:if test="f:fixedId">
         <xsl:if test="f:fixedId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedId">
               <xsl:value-of select="f:fixedId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedId">
               <xsl:apply-templates select="f:fixedId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:fixedUnsignedInt">
         <xsl:if test="f:fixedUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUnsignedInt">
               <xsl:value-of select="f:fixedUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:fixedUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedUnsignedInt">
               <xsl:apply-templates select="f:fixedUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedPositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:fixedPositiveInt">
         <xsl:if test="f:fixedPositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="fixedPositiveInt">
               <xsl:value-of select="f:fixedPositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:fixedPositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedPositiveInt">
               <xsl:apply-templates select="f:fixedPositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:fixedMarkdown">
         <xsl:if test="f:fixedMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedMarkdown">
               <xsl:value-of select="f:fixedMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedMarkdown">
               <xsl:apply-templates select="f:fixedMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--fixedAnnotation 1..1 Annotation--><xsl:if test="f:fixedAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedAnnotation">
            <xsl:apply-templates select="f:fixedAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
                        <!--fixedAttachment 1..1 Attachment--><xsl:if test="f:fixedAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedAttachment">
            <xsl:apply-templates select="f:fixedAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--fixedIdentifier 1..1 Identifier--><xsl:if test="f:fixedIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedIdentifier">
            <xsl:apply-templates select="f:fixedIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                        <!--fixedCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:fixedCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCodeableConcept">
            <xsl:apply-templates select="f:fixedCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--fixedCoding 1..1 Coding--><xsl:if test="f:fixedCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCoding">
            <xsl:apply-templates select="f:fixedCoding" mode="Coding"/>
         </map>
      </xsl:if>
                        <!--fixedQuantity 1..1 Quantity--><xsl:if test="f:fixedQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedQuantity">
            <xsl:apply-templates select="f:fixedQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
                        <!--fixedRange 1..1 Range--><xsl:if test="f:fixedRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedRange">
            <xsl:apply-templates select="f:fixedRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--fixedPeriod 1..1 Period--><xsl:if test="f:fixedPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedPeriod">
            <xsl:apply-templates select="f:fixedPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--fixedRatio 1..1 Ratio--><xsl:if test="f:fixedRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedRatio">
            <xsl:apply-templates select="f:fixedRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--fixedReference 1..1 Reference--><xsl:if test="f:fixedReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedReference">
            <xsl:apply-templates select="f:fixedReference" mode="Reference"/>
         </map>
      </xsl:if>
                        <!--fixedSampledData 1..1 SampledData--><xsl:if test="f:fixedSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedSampledData">
            <xsl:apply-templates select="f:fixedSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
                        <!--fixedSignature 1..1 Signature--><xsl:if test="f:fixedSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedSignature">
            <xsl:apply-templates select="f:fixedSignature" mode="Signature"/>
         </map>
      </xsl:if>
                        <!--fixedHumanName 1..1 HumanName--><xsl:if test="f:fixedHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedHumanName">
            <xsl:apply-templates select="f:fixedHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
                        <!--fixedAddress 1..1 Address--><xsl:if test="f:fixedAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedAddress">
            <xsl:apply-templates select="f:fixedAddress" mode="Address"/>
         </map>
      </xsl:if>
                        <!--fixedContactPoint 1..1 ContactPoint--><xsl:if test="f:fixedContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedContactPoint">
            <xsl:apply-templates select="f:fixedContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
                        <!--fixedTiming 1..1 Timing--><xsl:if test="f:fixedTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedTiming">
            <xsl:apply-templates select="f:fixedTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--fixedMeta 1..1 Meta--><xsl:if test="f:fixedMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedMeta">
            <xsl:apply-templates select="f:fixedMeta" mode="Meta"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--patternBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:patternBoolean">
         <xsl:if test="f:patternBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="patternBoolean">
               <xsl:value-of select="f:patternBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:patternBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternBoolean">
               <xsl:apply-templates select="f:patternBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternInteger 1..1 integer (json type: number)--><xsl:if test="f:patternInteger">
         <xsl:if test="f:patternInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="patternInteger">
               <xsl:value-of select="f:patternInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:patternInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternInteger">
               <xsl:apply-templates select="f:patternInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternDecimal 1..1 decimal (json type: number)--><xsl:if test="f:patternDecimal">
         <xsl:if test="f:patternDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="patternDecimal">
               <xsl:value-of select="f:patternDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:patternDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternDecimal">
               <xsl:apply-templates select="f:patternDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:patternBase64Binary">
         <xsl:if test="f:patternBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternBase64Binary">
               <xsl:value-of select="f:patternBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternBase64Binary">
               <xsl:apply-templates select="f:patternBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternInstant 1..1 instant (json type: string)--><xsl:if test="f:patternInstant">
         <xsl:if test="f:patternInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternInstant">
               <xsl:value-of select="f:patternInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternInstant">
               <xsl:apply-templates select="f:patternInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternString 1..1 string (json type: string)--><xsl:if test="f:patternString">
         <xsl:if test="f:patternString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternString">
               <xsl:value-of select="f:patternString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternString">
               <xsl:apply-templates select="f:patternString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternUri 1..1 uri (json type: string)--><xsl:if test="f:patternUri">
         <xsl:if test="f:patternUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternUri">
               <xsl:value-of select="f:patternUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternUri">
               <xsl:apply-templates select="f:patternUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternDate 1..1 date (json type: string)--><xsl:if test="f:patternDate">
         <xsl:if test="f:patternDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDate">
               <xsl:value-of select="f:patternDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternDate">
               <xsl:apply-templates select="f:patternDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:patternDateTime">
         <xsl:if test="f:patternDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDateTime">
               <xsl:value-of select="f:patternDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternDateTime">
               <xsl:apply-templates select="f:patternDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternTime 1..1 time (json type: string)--><xsl:if test="f:patternTime">
         <xsl:if test="f:patternTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternTime">
               <xsl:value-of select="f:patternTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternTime">
               <xsl:apply-templates select="f:patternTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternCode 1..1 code (json type: string)--><xsl:if test="f:patternCode">
         <xsl:if test="f:patternCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternCode">
               <xsl:value-of select="f:patternCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternCode">
               <xsl:apply-templates select="f:patternCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternOid 1..1 oid (json type: string)--><xsl:if test="f:patternOid">
         <xsl:if test="f:patternOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternOid">
               <xsl:value-of select="f:patternOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternOid">
               <xsl:apply-templates select="f:patternOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternUuid 1..1 uuid (json type: string)--><xsl:if test="f:patternUuid">
         <xsl:if test="f:patternUuid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternUuid">
               <xsl:value-of select="f:patternUuid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternUuid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternUuid">
               <xsl:apply-templates select="f:patternUuid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternId 1..1 id (json type: string)--><xsl:if test="f:patternId">
         <xsl:if test="f:patternId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternId">
               <xsl:value-of select="f:patternId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternId">
               <xsl:apply-templates select="f:patternId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:patternUnsignedInt">
         <xsl:if test="f:patternUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="patternUnsignedInt">
               <xsl:value-of select="f:patternUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:patternUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternUnsignedInt">
               <xsl:apply-templates select="f:patternUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternPositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:patternPositiveInt">
         <xsl:if test="f:patternPositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="patternPositiveInt">
               <xsl:value-of select="f:patternPositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:patternPositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternPositiveInt">
               <xsl:apply-templates select="f:patternPositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:patternMarkdown">
         <xsl:if test="f:patternMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternMarkdown">
               <xsl:value-of select="f:patternMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternMarkdown">
               <xsl:apply-templates select="f:patternMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--patternAnnotation 1..1 Annotation--><xsl:if test="f:patternAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternAnnotation">
            <xsl:apply-templates select="f:patternAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
                        <!--patternAttachment 1..1 Attachment--><xsl:if test="f:patternAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternAttachment">
            <xsl:apply-templates select="f:patternAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--patternIdentifier 1..1 Identifier--><xsl:if test="f:patternIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternIdentifier">
            <xsl:apply-templates select="f:patternIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                        <!--patternCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:patternCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternCodeableConcept">
            <xsl:apply-templates select="f:patternCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--patternCoding 1..1 Coding--><xsl:if test="f:patternCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternCoding">
            <xsl:apply-templates select="f:patternCoding" mode="Coding"/>
         </map>
      </xsl:if>
                        <!--patternQuantity 1..1 Quantity--><xsl:if test="f:patternQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternQuantity">
            <xsl:apply-templates select="f:patternQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
                        <!--patternRange 1..1 Range--><xsl:if test="f:patternRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternRange">
            <xsl:apply-templates select="f:patternRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--patternPeriod 1..1 Period--><xsl:if test="f:patternPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternPeriod">
            <xsl:apply-templates select="f:patternPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--patternRatio 1..1 Ratio--><xsl:if test="f:patternRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternRatio">
            <xsl:apply-templates select="f:patternRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--patternReference 1..1 Reference--><xsl:if test="f:patternReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternReference">
            <xsl:apply-templates select="f:patternReference" mode="Reference"/>
         </map>
      </xsl:if>
                        <!--patternSampledData 1..1 SampledData--><xsl:if test="f:patternSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternSampledData">
            <xsl:apply-templates select="f:patternSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
                        <!--patternSignature 1..1 Signature--><xsl:if test="f:patternSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternSignature">
            <xsl:apply-templates select="f:patternSignature" mode="Signature"/>
         </map>
      </xsl:if>
                        <!--patternHumanName 1..1 HumanName--><xsl:if test="f:patternHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternHumanName">
            <xsl:apply-templates select="f:patternHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
                        <!--patternAddress 1..1 Address--><xsl:if test="f:patternAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternAddress">
            <xsl:apply-templates select="f:patternAddress" mode="Address"/>
         </map>
      </xsl:if>
                        <!--patternContactPoint 1..1 ContactPoint--><xsl:if test="f:patternContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternContactPoint">
            <xsl:apply-templates select="f:patternContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
                        <!--patternTiming 1..1 Timing--><xsl:if test="f:patternTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternTiming">
            <xsl:apply-templates select="f:patternTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--patternMeta 1..1 Meta--><xsl:if test="f:patternMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternMeta">
            <xsl:apply-templates select="f:patternMeta" mode="Meta"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--exampleBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:exampleBoolean">
         <xsl:if test="f:exampleBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="exampleBoolean">
               <xsl:value-of select="f:exampleBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:exampleBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleBoolean">
               <xsl:apply-templates select="f:exampleBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleInteger 1..1 integer (json type: number)--><xsl:if test="f:exampleInteger">
         <xsl:if test="f:exampleInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="exampleInteger">
               <xsl:value-of select="f:exampleInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:exampleInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleInteger">
               <xsl:apply-templates select="f:exampleInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleDecimal 1..1 decimal (json type: number)--><xsl:if test="f:exampleDecimal">
         <xsl:if test="f:exampleDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="exampleDecimal">
               <xsl:value-of select="f:exampleDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:exampleDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleDecimal">
               <xsl:apply-templates select="f:exampleDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:exampleBase64Binary">
         <xsl:if test="f:exampleBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleBase64Binary">
               <xsl:value-of select="f:exampleBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleBase64Binary">
               <xsl:apply-templates select="f:exampleBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleInstant 1..1 instant (json type: string)--><xsl:if test="f:exampleInstant">
         <xsl:if test="f:exampleInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleInstant">
               <xsl:value-of select="f:exampleInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleInstant">
               <xsl:apply-templates select="f:exampleInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleString 1..1 string (json type: string)--><xsl:if test="f:exampleString">
         <xsl:if test="f:exampleString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleString">
               <xsl:value-of select="f:exampleString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleString">
               <xsl:apply-templates select="f:exampleString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleUri 1..1 uri (json type: string)--><xsl:if test="f:exampleUri">
         <xsl:if test="f:exampleUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleUri">
               <xsl:value-of select="f:exampleUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleUri">
               <xsl:apply-templates select="f:exampleUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleDate 1..1 date (json type: string)--><xsl:if test="f:exampleDate">
         <xsl:if test="f:exampleDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleDate">
               <xsl:value-of select="f:exampleDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleDate">
               <xsl:apply-templates select="f:exampleDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:exampleDateTime">
         <xsl:if test="f:exampleDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleDateTime">
               <xsl:value-of select="f:exampleDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleDateTime">
               <xsl:apply-templates select="f:exampleDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleTime 1..1 time (json type: string)--><xsl:if test="f:exampleTime">
         <xsl:if test="f:exampleTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleTime">
               <xsl:value-of select="f:exampleTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleTime">
               <xsl:apply-templates select="f:exampleTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleCode 1..1 code (json type: string)--><xsl:if test="f:exampleCode">
         <xsl:if test="f:exampleCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleCode">
               <xsl:value-of select="f:exampleCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleCode">
               <xsl:apply-templates select="f:exampleCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleOid 1..1 oid (json type: string)--><xsl:if test="f:exampleOid">
         <xsl:if test="f:exampleOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleOid">
               <xsl:value-of select="f:exampleOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleOid">
               <xsl:apply-templates select="f:exampleOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleUuid 1..1 uuid (json type: string)--><xsl:if test="f:exampleUuid">
         <xsl:if test="f:exampleUuid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleUuid">
               <xsl:value-of select="f:exampleUuid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleUuid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleUuid">
               <xsl:apply-templates select="f:exampleUuid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleId 1..1 id (json type: string)--><xsl:if test="f:exampleId">
         <xsl:if test="f:exampleId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleId">
               <xsl:value-of select="f:exampleId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleId">
               <xsl:apply-templates select="f:exampleId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:exampleUnsignedInt">
         <xsl:if test="f:exampleUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="exampleUnsignedInt">
               <xsl:value-of select="f:exampleUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:exampleUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleUnsignedInt">
               <xsl:apply-templates select="f:exampleUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--examplePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:examplePositiveInt">
         <xsl:if test="f:examplePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="examplePositiveInt">
               <xsl:value-of select="f:examplePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:examplePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_examplePositiveInt">
               <xsl:apply-templates select="f:examplePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:exampleMarkdown">
         <xsl:if test="f:exampleMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="exampleMarkdown">
               <xsl:value-of select="f:exampleMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:exampleMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exampleMarkdown">
               <xsl:apply-templates select="f:exampleMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--exampleAnnotation 1..1 Annotation--><xsl:if test="f:exampleAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleAnnotation">
            <xsl:apply-templates select="f:exampleAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
                        <!--exampleAttachment 1..1 Attachment--><xsl:if test="f:exampleAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleAttachment">
            <xsl:apply-templates select="f:exampleAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--exampleIdentifier 1..1 Identifier--><xsl:if test="f:exampleIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleIdentifier">
            <xsl:apply-templates select="f:exampleIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                        <!--exampleCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:exampleCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleCodeableConcept">
            <xsl:apply-templates select="f:exampleCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--exampleCoding 1..1 Coding--><xsl:if test="f:exampleCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleCoding">
            <xsl:apply-templates select="f:exampleCoding" mode="Coding"/>
         </map>
      </xsl:if>
                        <!--exampleQuantity 1..1 Quantity--><xsl:if test="f:exampleQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleQuantity">
            <xsl:apply-templates select="f:exampleQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
                        <!--exampleRange 1..1 Range--><xsl:if test="f:exampleRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleRange">
            <xsl:apply-templates select="f:exampleRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--examplePeriod 1..1 Period--><xsl:if test="f:examplePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="examplePeriod">
            <xsl:apply-templates select="f:examplePeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--exampleRatio 1..1 Ratio--><xsl:if test="f:exampleRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleRatio">
            <xsl:apply-templates select="f:exampleRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--exampleReference 1..1 Reference--><xsl:if test="f:exampleReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleReference">
            <xsl:apply-templates select="f:exampleReference" mode="Reference"/>
         </map>
      </xsl:if>
                        <!--exampleSampledData 1..1 SampledData--><xsl:if test="f:exampleSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleSampledData">
            <xsl:apply-templates select="f:exampleSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
                        <!--exampleSignature 1..1 Signature--><xsl:if test="f:exampleSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleSignature">
            <xsl:apply-templates select="f:exampleSignature" mode="Signature"/>
         </map>
      </xsl:if>
                        <!--exampleHumanName 1..1 HumanName--><xsl:if test="f:exampleHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleHumanName">
            <xsl:apply-templates select="f:exampleHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
                        <!--exampleAddress 1..1 Address--><xsl:if test="f:exampleAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleAddress">
            <xsl:apply-templates select="f:exampleAddress" mode="Address"/>
         </map>
      </xsl:if>
                        <!--exampleContactPoint 1..1 ContactPoint--><xsl:if test="f:exampleContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleContactPoint">
            <xsl:apply-templates select="f:exampleContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
                        <!--exampleTiming 1..1 Timing--><xsl:if test="f:exampleTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleTiming">
            <xsl:apply-templates select="f:exampleTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--exampleMeta 1..1 Meta--><xsl:if test="f:exampleMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleMeta">
            <xsl:apply-templates select="f:exampleMeta" mode="Meta"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--minValueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:minValueBoolean">
         <xsl:if test="f:minValueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="minValueBoolean">
               <xsl:value-of select="f:minValueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:minValueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueBoolean">
               <xsl:apply-templates select="f:minValueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueInteger 1..1 integer (json type: number)--><xsl:if test="f:minValueInteger">
         <xsl:if test="f:minValueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minValueInteger">
               <xsl:value-of select="f:minValueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minValueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueInteger">
               <xsl:apply-templates select="f:minValueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:minValueDecimal">
         <xsl:if test="f:minValueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDecimal">
               <xsl:value-of select="f:minValueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minValueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueDecimal">
               <xsl:apply-templates select="f:minValueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:minValueBase64Binary">
         <xsl:if test="f:minValueBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueBase64Binary">
               <xsl:value-of select="f:minValueBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueBase64Binary">
               <xsl:apply-templates select="f:minValueBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueInstant 1..1 instant (json type: string)--><xsl:if test="f:minValueInstant">
         <xsl:if test="f:minValueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueInstant">
               <xsl:value-of select="f:minValueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueInstant">
               <xsl:apply-templates select="f:minValueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueString 1..1 string (json type: string)--><xsl:if test="f:minValueString">
         <xsl:if test="f:minValueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueString">
               <xsl:value-of select="f:minValueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueString">
               <xsl:apply-templates select="f:minValueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueUri 1..1 uri (json type: string)--><xsl:if test="f:minValueUri">
         <xsl:if test="f:minValueUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueUri">
               <xsl:value-of select="f:minValueUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueUri">
               <xsl:apply-templates select="f:minValueUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueDate 1..1 date (json type: string)--><xsl:if test="f:minValueDate">
         <xsl:if test="f:minValueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDate">
               <xsl:value-of select="f:minValueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueDate">
               <xsl:apply-templates select="f:minValueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:minValueDateTime">
         <xsl:if test="f:minValueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDateTime">
               <xsl:value-of select="f:minValueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueDateTime">
               <xsl:apply-templates select="f:minValueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueTime 1..1 time (json type: string)--><xsl:if test="f:minValueTime">
         <xsl:if test="f:minValueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueTime">
               <xsl:value-of select="f:minValueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueTime">
               <xsl:apply-templates select="f:minValueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueCode 1..1 code (json type: string)--><xsl:if test="f:minValueCode">
         <xsl:if test="f:minValueCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueCode">
               <xsl:value-of select="f:minValueCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueCode">
               <xsl:apply-templates select="f:minValueCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueOid 1..1 oid (json type: string)--><xsl:if test="f:minValueOid">
         <xsl:if test="f:minValueOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueOid">
               <xsl:value-of select="f:minValueOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueOid">
               <xsl:apply-templates select="f:minValueOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueUuid 1..1 uuid (json type: string)--><xsl:if test="f:minValueUuid">
         <xsl:if test="f:minValueUuid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueUuid">
               <xsl:value-of select="f:minValueUuid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueUuid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueUuid">
               <xsl:apply-templates select="f:minValueUuid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueId 1..1 id (json type: string)--><xsl:if test="f:minValueId">
         <xsl:if test="f:minValueId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueId">
               <xsl:value-of select="f:minValueId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueId">
               <xsl:apply-templates select="f:minValueId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:minValueUnsignedInt">
         <xsl:if test="f:minValueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minValueUnsignedInt">
               <xsl:value-of select="f:minValueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minValueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueUnsignedInt">
               <xsl:apply-templates select="f:minValueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:minValuePositiveInt">
         <xsl:if test="f:minValuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minValuePositiveInt">
               <xsl:value-of select="f:minValuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minValuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValuePositiveInt">
               <xsl:apply-templates select="f:minValuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:minValueMarkdown">
         <xsl:if test="f:minValueMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueMarkdown">
               <xsl:value-of select="f:minValueMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueMarkdown">
               <xsl:apply-templates select="f:minValueMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--minValueAnnotation 1..1 Annotation--><xsl:if test="f:minValueAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueAnnotation">
            <xsl:apply-templates select="f:minValueAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
                        <!--minValueAttachment 1..1 Attachment--><xsl:if test="f:minValueAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueAttachment">
            <xsl:apply-templates select="f:minValueAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--minValueIdentifier 1..1 Identifier--><xsl:if test="f:minValueIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueIdentifier">
            <xsl:apply-templates select="f:minValueIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                        <!--minValueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:minValueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="minValueCodeableConcept">
            <xsl:apply-templates select="f:minValueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--minValueCoding 1..1 Coding--><xsl:if test="f:minValueCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueCoding">
            <xsl:apply-templates select="f:minValueCoding" mode="Coding"/>
         </map>
      </xsl:if>
                        <!--minValueQuantity 1..1 Quantity--><xsl:if test="f:minValueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueQuantity">
            <xsl:apply-templates select="f:minValueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
                        <!--minValueRange 1..1 Range--><xsl:if test="f:minValueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueRange">
            <xsl:apply-templates select="f:minValueRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--minValuePeriod 1..1 Period--><xsl:if test="f:minValuePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValuePeriod">
            <xsl:apply-templates select="f:minValuePeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--minValueRatio 1..1 Ratio--><xsl:if test="f:minValueRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueRatio">
            <xsl:apply-templates select="f:minValueRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--minValueReference 1..1 Reference--><xsl:if test="f:minValueReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueReference">
            <xsl:apply-templates select="f:minValueReference" mode="Reference"/>
         </map>
      </xsl:if>
                        <!--minValueSampledData 1..1 SampledData--><xsl:if test="f:minValueSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueSampledData">
            <xsl:apply-templates select="f:minValueSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
                        <!--minValueSignature 1..1 Signature--><xsl:if test="f:minValueSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueSignature">
            <xsl:apply-templates select="f:minValueSignature" mode="Signature"/>
         </map>
      </xsl:if>
                        <!--minValueHumanName 1..1 HumanName--><xsl:if test="f:minValueHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueHumanName">
            <xsl:apply-templates select="f:minValueHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
                        <!--minValueAddress 1..1 Address--><xsl:if test="f:minValueAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueAddress">
            <xsl:apply-templates select="f:minValueAddress" mode="Address"/>
         </map>
      </xsl:if>
                        <!--minValueContactPoint 1..1 ContactPoint--><xsl:if test="f:minValueContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueContactPoint">
            <xsl:apply-templates select="f:minValueContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
                        <!--minValueTiming 1..1 Timing--><xsl:if test="f:minValueTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueTiming">
            <xsl:apply-templates select="f:minValueTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--minValueMeta 1..1 Meta--><xsl:if test="f:minValueMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueMeta">
            <xsl:apply-templates select="f:minValueMeta" mode="Meta"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--maxValueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:maxValueBoolean">
         <xsl:if test="f:maxValueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueBoolean">
               <xsl:value-of select="f:maxValueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:maxValueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueBoolean">
               <xsl:apply-templates select="f:maxValueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueInteger 1..1 integer (json type: number)--><xsl:if test="f:maxValueInteger">
         <xsl:if test="f:maxValueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueInteger">
               <xsl:value-of select="f:maxValueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxValueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueInteger">
               <xsl:apply-templates select="f:maxValueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:maxValueDecimal">
         <xsl:if test="f:maxValueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDecimal">
               <xsl:value-of select="f:maxValueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxValueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueDecimal">
               <xsl:apply-templates select="f:maxValueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:maxValueBase64Binary">
         <xsl:if test="f:maxValueBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueBase64Binary">
               <xsl:value-of select="f:maxValueBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueBase64Binary">
               <xsl:apply-templates select="f:maxValueBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueInstant 1..1 instant (json type: string)--><xsl:if test="f:maxValueInstant">
         <xsl:if test="f:maxValueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueInstant">
               <xsl:value-of select="f:maxValueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueInstant">
               <xsl:apply-templates select="f:maxValueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueString 1..1 string (json type: string)--><xsl:if test="f:maxValueString">
         <xsl:if test="f:maxValueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueString">
               <xsl:value-of select="f:maxValueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueString">
               <xsl:apply-templates select="f:maxValueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueUri 1..1 uri (json type: string)--><xsl:if test="f:maxValueUri">
         <xsl:if test="f:maxValueUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueUri">
               <xsl:value-of select="f:maxValueUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueUri">
               <xsl:apply-templates select="f:maxValueUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueDate 1..1 date (json type: string)--><xsl:if test="f:maxValueDate">
         <xsl:if test="f:maxValueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDate">
               <xsl:value-of select="f:maxValueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueDate">
               <xsl:apply-templates select="f:maxValueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:maxValueDateTime">
         <xsl:if test="f:maxValueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDateTime">
               <xsl:value-of select="f:maxValueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueDateTime">
               <xsl:apply-templates select="f:maxValueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueTime 1..1 time (json type: string)--><xsl:if test="f:maxValueTime">
         <xsl:if test="f:maxValueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueTime">
               <xsl:value-of select="f:maxValueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueTime">
               <xsl:apply-templates select="f:maxValueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueCode 1..1 code (json type: string)--><xsl:if test="f:maxValueCode">
         <xsl:if test="f:maxValueCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueCode">
               <xsl:value-of select="f:maxValueCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueCode">
               <xsl:apply-templates select="f:maxValueCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueOid 1..1 oid (json type: string)--><xsl:if test="f:maxValueOid">
         <xsl:if test="f:maxValueOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueOid">
               <xsl:value-of select="f:maxValueOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueOid">
               <xsl:apply-templates select="f:maxValueOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueUuid 1..1 uuid (json type: string)--><xsl:if test="f:maxValueUuid">
         <xsl:if test="f:maxValueUuid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueUuid">
               <xsl:value-of select="f:maxValueUuid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueUuid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueUuid">
               <xsl:apply-templates select="f:maxValueUuid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueId 1..1 id (json type: string)--><xsl:if test="f:maxValueId">
         <xsl:if test="f:maxValueId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueId">
               <xsl:value-of select="f:maxValueId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueId">
               <xsl:apply-templates select="f:maxValueId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:maxValueUnsignedInt">
         <xsl:if test="f:maxValueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueUnsignedInt">
               <xsl:value-of select="f:maxValueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxValueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueUnsignedInt">
               <xsl:apply-templates select="f:maxValueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:maxValuePositiveInt">
         <xsl:if test="f:maxValuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxValuePositiveInt">
               <xsl:value-of select="f:maxValuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxValuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValuePositiveInt">
               <xsl:apply-templates select="f:maxValuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:maxValueMarkdown">
         <xsl:if test="f:maxValueMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueMarkdown">
               <xsl:value-of select="f:maxValueMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueMarkdown">
               <xsl:apply-templates select="f:maxValueMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--maxValueAnnotation 1..1 Annotation--><xsl:if test="f:maxValueAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueAnnotation">
            <xsl:apply-templates select="f:maxValueAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
                        <!--maxValueAttachment 1..1 Attachment--><xsl:if test="f:maxValueAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueAttachment">
            <xsl:apply-templates select="f:maxValueAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--maxValueIdentifier 1..1 Identifier--><xsl:if test="f:maxValueIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueIdentifier">
            <xsl:apply-templates select="f:maxValueIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                        <!--maxValueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:maxValueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="maxValueCodeableConcept">
            <xsl:apply-templates select="f:maxValueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--maxValueCoding 1..1 Coding--><xsl:if test="f:maxValueCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueCoding">
            <xsl:apply-templates select="f:maxValueCoding" mode="Coding"/>
         </map>
      </xsl:if>
                        <!--maxValueQuantity 1..1 Quantity--><xsl:if test="f:maxValueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueQuantity">
            <xsl:apply-templates select="f:maxValueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
                        <!--maxValueRange 1..1 Range--><xsl:if test="f:maxValueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueRange">
            <xsl:apply-templates select="f:maxValueRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--maxValuePeriod 1..1 Period--><xsl:if test="f:maxValuePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValuePeriod">
            <xsl:apply-templates select="f:maxValuePeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--maxValueRatio 1..1 Ratio--><xsl:if test="f:maxValueRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueRatio">
            <xsl:apply-templates select="f:maxValueRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--maxValueReference 1..1 Reference--><xsl:if test="f:maxValueReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueReference">
            <xsl:apply-templates select="f:maxValueReference" mode="Reference"/>
         </map>
      </xsl:if>
                        <!--maxValueSampledData 1..1 SampledData--><xsl:if test="f:maxValueSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueSampledData">
            <xsl:apply-templates select="f:maxValueSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
                        <!--maxValueSignature 1..1 Signature--><xsl:if test="f:maxValueSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueSignature">
            <xsl:apply-templates select="f:maxValueSignature" mode="Signature"/>
         </map>
      </xsl:if>
                        <!--maxValueHumanName 1..1 HumanName--><xsl:if test="f:maxValueHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueHumanName">
            <xsl:apply-templates select="f:maxValueHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
                        <!--maxValueAddress 1..1 Address--><xsl:if test="f:maxValueAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueAddress">
            <xsl:apply-templates select="f:maxValueAddress" mode="Address"/>
         </map>
      </xsl:if>
                        <!--maxValueContactPoint 1..1 ContactPoint--><xsl:if test="f:maxValueContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueContactPoint">
            <xsl:apply-templates select="f:maxValueContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
                        <!--maxValueTiming 1..1 Timing--><xsl:if test="f:maxValueTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueTiming">
            <xsl:apply-templates select="f:maxValueTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--maxValueMeta 1..1 Meta--><xsl:if test="f:maxValueMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueMeta">
            <xsl:apply-templates select="f:maxValueMeta" mode="Meta"/>
         </map>
      </xsl:if>
                    
                    <!--maxLength 0..1 integer (json type: number)--><xsl:if test="f:maxLength">
         <xsl:if test="f:maxLength/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxLength">
               <xsl:value-of select="f:maxLength/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxLength[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxLength">
               <xsl:apply-templates select="f:maxLength" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--condition 0..* id (json type: string)--><xsl:if test="f:condition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="condition">
            <xsl:for-each select="f:condition">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:condition[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_condition">
               <xsl:for-each select="f:condition">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--constraint 0..* ElementDefinition.Constraint--><xsl:if test="f:constraint">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="constraint">
            <xsl:for-each select="f:constraint">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition.Constraint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--mustSupport 0..1 boolean (json type: boolean)--><xsl:if test="f:mustSupport">
         <xsl:if test="f:mustSupport/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="mustSupport">
               <xsl:value-of select="f:mustSupport/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:mustSupport[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mustSupport">
               <xsl:apply-templates select="f:mustSupport" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--isModifier 0..1 boolean (json type: boolean)--><xsl:if test="f:isModifier">
         <xsl:if test="f:isModifier/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="isModifier">
               <xsl:value-of select="f:isModifier/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:isModifier[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_isModifier">
               <xsl:apply-templates select="f:isModifier" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--isSummary 0..1 boolean (json type: boolean)--><xsl:if test="f:isSummary">
         <xsl:if test="f:isSummary/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="isSummary">
               <xsl:value-of select="f:isSummary/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:isSummary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_isSummary">
               <xsl:apply-templates select="f:isSummary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--binding 0..1 ElementDefinition.Binding--><xsl:if test="f:binding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="binding">
            <xsl:apply-templates select="f:binding" mode="ElementDefinition.Binding"/>
         </map>
      </xsl:if>
                    <!--mapping 0..* ElementDefinition.Mapping--><xsl:if test="f:mapping">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mapping">
            <xsl:for-each select="f:mapping">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition.Mapping"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Mapping">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--identity 1..1 id (json type: string)--><xsl:if test="f:identity">
         <xsl:if test="f:identity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="identity">
               <xsl:value-of select="f:identity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:identity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_identity">
               <xsl:apply-templates select="f:identity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--map 1..1 string (json type: string)--><xsl:if test="f:map">
         <xsl:if test="f:map/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="map">
               <xsl:value-of select="f:map/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:map[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_map">
               <xsl:apply-templates select="f:map" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Slicing">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--discriminator 0..* string (json type: string)--><xsl:if test="f:discriminator">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="discriminator">
            <xsl:for-each select="f:discriminator">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:discriminator[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_discriminator">
               <xsl:for-each select="f:discriminator">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--ordered 0..1 boolean (json type: boolean)--><xsl:if test="f:ordered">
         <xsl:if test="f:ordered/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="ordered">
               <xsl:value-of select="f:ordered/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:ordered[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ordered">
               <xsl:apply-templates select="f:ordered" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--rules 1..1 SlicingRules (json type: string)--><xsl:if test="f:rules">
         <xsl:if test="f:rules/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="rules">
               <xsl:value-of select="f:rules/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:rules[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_rules">
               <xsl:apply-templates select="f:rules" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Binding">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--strength 1..1 BindingStrength (json type: string)--><xsl:if test="f:strength">
         <xsl:if test="f:strength/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="strength">
               <xsl:value-of select="f:strength/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:strength[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_strength">
               <xsl:apply-templates select="f:strength" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--valueSetUri 1..1 uri (json type: string)--><xsl:if test="f:valueSetUri">
         <xsl:if test="f:valueSetUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetUri">
               <xsl:value-of select="f:valueSetUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueSetUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueSetUri">
               <xsl:apply-templates select="f:valueSetUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueSetReference 1..1 Reference--><xsl:if test="f:valueSetReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetReference">
            <xsl:apply-templates select="f:valueSetReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Type">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--code 1..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--profile 0..* uri (json type: string)--><xsl:if test="f:profile">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:for-each select="f:profile">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:profile[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_profile">
               <xsl:for-each select="f:profile">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--aggregation 0..* AggregationMode (json type: string)--><xsl:if test="f:aggregation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="aggregation">
            <xsl:for-each select="f:aggregation">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:aggregation[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_aggregation">
               <xsl:for-each select="f:aggregation">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Base">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--path 1..1 string (json type: string)--><xsl:if test="f:path">
         <xsl:if test="f:path/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="path">
               <xsl:value-of select="f:path/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:path[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_path">
               <xsl:apply-templates select="f:path" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--min 1..1 integer (json type: number)--><xsl:if test="f:min">
         <xsl:if test="f:min/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="min">
               <xsl:value-of select="f:min/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:min[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_min">
               <xsl:apply-templates select="f:min" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--max 1..1 string (json type: string)--><xsl:if test="f:max">
         <xsl:if test="f:max/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="max">
               <xsl:value-of select="f:max/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:max[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_max">
               <xsl:apply-templates select="f:max" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Constraint">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--key 1..1 id (json type: string)--><xsl:if test="f:key">
         <xsl:if test="f:key/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="key">
               <xsl:value-of select="f:key/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:key[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_key">
               <xsl:apply-templates select="f:key" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--requirements 0..1 string (json type: string)--><xsl:if test="f:requirements">
         <xsl:if test="f:requirements/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements">
               <xsl:value-of select="f:requirements/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:requirements[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requirements">
               <xsl:apply-templates select="f:requirements" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--severity 1..1 ConstraintSeverity (json type: string)--><xsl:if test="f:severity">
         <xsl:if test="f:severity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity">
               <xsl:value-of select="f:severity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:severity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_severity">
               <xsl:apply-templates select="f:severity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--human 1..1 string (json type: string)--><xsl:if test="f:human">
         <xsl:if test="f:human/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="human">
               <xsl:value-of select="f:human/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:human[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_human">
               <xsl:apply-templates select="f:human" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--xpath 1..1 string (json type: string)--><xsl:if test="f:xpath">
         <xsl:if test="f:xpath/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="xpath">
               <xsl:value-of select="f:xpath/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:xpath[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_xpath">
               <xsl:apply-templates select="f:xpath" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a property is represented on the wire.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="PropertyRepresentation">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How slices are interpreted when evaluating an instance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SlicingRules">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indication of the degree of conformance expectations associated with a binding.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="BindingStrength">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How resource references can be aggregated.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AggregationMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>SHALL applications comply with this constraint?</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConstraintSeverity">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies an event that may occur multiple times. Timing schedules are used to record when things are expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Timing">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--event 0..* dateTime (json type: string)--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:event[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_event">
               <xsl:for-each select="f:event">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--repeat 0..1 Timing.Repeat--><xsl:if test="f:repeat">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="repeat">
            <xsl:apply-templates select="f:repeat" mode="Timing.Repeat"/>
         </map>
      </xsl:if>
                    <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies an event that may occur multiple times. Timing schedules are used to record when things are expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Timing.Repeat">
      <xsl:apply-templates select="." mode="Element"/>
                    
                        
                        <!--boundsQuantity 1..1 Duration--><xsl:if test="f:boundsQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="boundsQuantity">
            <xsl:apply-templates select="f:boundsQuantity" mode="Duration"/>
         </map>
      </xsl:if>
                        <!--boundsRange 1..1 Range--><xsl:if test="f:boundsRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="boundsRange">
            <xsl:apply-templates select="f:boundsRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--boundsPeriod 1..1 Period--><xsl:if test="f:boundsPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="boundsPeriod">
            <xsl:apply-templates select="f:boundsPeriod" mode="Period"/>
         </map>
      </xsl:if>
                    
                    <!--count 0..1 integer (json type: number)--><xsl:if test="f:count">
         <xsl:if test="f:count/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="count">
               <xsl:value-of select="f:count/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:count[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_count">
               <xsl:apply-templates select="f:count" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--duration 0..1 decimal (json type: number)--><xsl:if test="f:duration">
         <xsl:if test="f:duration/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="duration">
               <xsl:value-of select="f:duration/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:duration[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_duration">
               <xsl:apply-templates select="f:duration" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--durationMax 0..1 decimal (json type: number)--><xsl:if test="f:durationMax">
         <xsl:if test="f:durationMax/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="durationMax">
               <xsl:value-of select="f:durationMax/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:durationMax[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_durationMax">
               <xsl:apply-templates select="f:durationMax" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--durationUnits 0..1 UnitsOfTime (json type: string)--><xsl:if test="f:durationUnits">
         <xsl:if test="f:durationUnits/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="durationUnits">
               <xsl:value-of select="f:durationUnits/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:durationUnits[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_durationUnits">
               <xsl:apply-templates select="f:durationUnits" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--frequency 0..1 integer (json type: number)--><xsl:if test="f:frequency">
         <xsl:if test="f:frequency/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="frequency">
               <xsl:value-of select="f:frequency/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:frequency[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_frequency">
               <xsl:apply-templates select="f:frequency" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--frequencyMax 0..1 integer (json type: number)--><xsl:if test="f:frequencyMax">
         <xsl:if test="f:frequencyMax/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="frequencyMax">
               <xsl:value-of select="f:frequencyMax/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:frequencyMax[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_frequencyMax">
               <xsl:apply-templates select="f:frequencyMax" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 0..1 decimal (json type: number)--><xsl:if test="f:period">
         <xsl:if test="f:period/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="period">
               <xsl:value-of select="f:period/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:period[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_period">
               <xsl:apply-templates select="f:period" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--periodMax 0..1 decimal (json type: number)--><xsl:if test="f:periodMax">
         <xsl:if test="f:periodMax/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="periodMax">
               <xsl:value-of select="f:periodMax/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:periodMax[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_periodMax">
               <xsl:apply-templates select="f:periodMax" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--periodUnits 0..1 UnitsOfTime (json type: string)--><xsl:if test="f:periodUnits">
         <xsl:if test="f:periodUnits/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="periodUnits">
               <xsl:value-of select="f:periodUnits/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:periodUnits[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_periodUnits">
               <xsl:apply-templates select="f:periodUnits" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--when 0..1 EventTiming (json type: string)--><xsl:if test="f:when">
         <xsl:if test="f:when/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="when">
               <xsl:value-of select="f:when/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:when[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_when">
               <xsl:apply-templates select="f:when" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A unit of time (units from UCUM).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="UnitsOfTime">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Real world event that the relating to the schedule.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EventTiming">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>There is a variety of postal address formats defined around the world. This format defines a superset that is the basis for all addresses around the world.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Address">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--use 0..1 AddressUse (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 AddressType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--line 0..* string (json type: string)--><xsl:if test="f:line">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="line">
            <xsl:for-each select="f:line">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:line[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_line">
               <xsl:for-each select="f:line">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--city 0..1 string (json type: string)--><xsl:if test="f:city">
         <xsl:if test="f:city/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="city">
               <xsl:value-of select="f:city/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:city[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_city">
               <xsl:apply-templates select="f:city" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--district 0..1 string (json type: string)--><xsl:if test="f:district">
         <xsl:if test="f:district/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="district">
               <xsl:value-of select="f:district/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:district[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_district">
               <xsl:apply-templates select="f:district" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--state 0..1 string (json type: string)--><xsl:if test="f:state">
         <xsl:if test="f:state/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="state">
               <xsl:value-of select="f:state/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:state[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_state">
               <xsl:apply-templates select="f:state" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--postalCode 0..1 string (json type: string)--><xsl:if test="f:postalCode">
         <xsl:if test="f:postalCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="postalCode">
               <xsl:value-of select="f:postalCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:postalCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_postalCode">
               <xsl:apply-templates select="f:postalCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--country 0..1 string (json type: string)--><xsl:if test="f:country">
         <xsl:if test="f:country/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="country">
               <xsl:value-of select="f:country/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:country[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_country">
               <xsl:apply-templates select="f:country" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The use of an address</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AddressUse">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of an address (physical / postal)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AddressType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A human's name with the ability to identify parts and usage.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="HumanName">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--use 0..1 NameUse (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--family 0..* string (json type: string)--><xsl:if test="f:family">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="family">
            <xsl:for-each select="f:family">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:family[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_family">
               <xsl:for-each select="f:family">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--given 0..* string (json type: string)--><xsl:if test="f:given">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="given">
            <xsl:for-each select="f:given">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:given[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_given">
               <xsl:for-each select="f:given">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--prefix 0..* string (json type: string)--><xsl:if test="f:prefix">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="prefix">
            <xsl:for-each select="f:prefix">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:prefix[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_prefix">
               <xsl:for-each select="f:prefix">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--suffix 0..* string (json type: string)--><xsl:if test="f:suffix">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="suffix">
            <xsl:for-each select="f:suffix">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:suffix[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_suffix">
               <xsl:for-each select="f:suffix">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The use of a human name</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="NameUse">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The metadata about a resource. This is content in the resource that is maintained by the infrastructure. Changes to the content may not always be associated with version changes to the resource.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Meta">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--versionId 0..1 id (json type: string)--><xsl:if test="f:versionId">
         <xsl:if test="f:versionId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="versionId">
               <xsl:value-of select="f:versionId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:versionId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_versionId">
               <xsl:apply-templates select="f:versionId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--lastUpdated 0..1 instant (json type: string)--><xsl:if test="f:lastUpdated">
         <xsl:if test="f:lastUpdated/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastUpdated">
               <xsl:value-of select="f:lastUpdated/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastUpdated[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastUpdated">
               <xsl:apply-templates select="f:lastUpdated" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--profile 0..* uri (json type: string)--><xsl:if test="f:profile">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:for-each select="f:profile">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:profile[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_profile">
               <xsl:for-each select="f:profile">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--security 0..* Coding--><xsl:if test="f:security">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="security">
            <xsl:for-each select="f:security">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--tag 0..* Coding--><xsl:if test="f:tag">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="tag">
            <xsl:for-each select="f:tag">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Details for all kinds of technology mediated contact points for a person or organization, including telephone, email, etc.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContactPoint">
      <xsl:apply-templates select="." mode="Element"/>
                    <!--system 0..1 ContactPointSystem (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--value 0..1 string (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--use 0..1 ContactPointUse (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--rank 0..1 positiveInt (json type: number)--><xsl:if test="f:rank">
         <xsl:if test="f:rank/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="rank">
               <xsl:value-of select="f:rank/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:rank[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_rank">
               <xsl:apply-templates select="f:rank" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Telecommunications form for contact point</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContactPointSystem">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use of contact point</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContactPointUse">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This is the base resource type for everything.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Resource">
            <!--id 0..1 id (json type: string)--><xsl:if test="f:id">
         <xsl:if test="f:id/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
               <xsl:value-of select="f:id/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:id[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_id">
               <xsl:apply-templates select="f:id" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--meta 0..1 Meta--><xsl:if test="f:meta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="meta">
            <xsl:apply-templates select="f:meta" mode="Meta"/>
         </map>
      </xsl:if>
            <!--implicitRules 0..1 uri (json type: string)--><xsl:if test="f:implicitRules">
         <xsl:if test="f:implicitRules/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="implicitRules">
               <xsl:value-of select="f:implicitRules/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:implicitRules[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_implicitRules">
               <xsl:apply-templates select="f:implicitRules" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A resource that includes narrative, extensions, and contained resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DomainResource">
      <xsl:apply-templates select="." mode="Resource"/>
                    <!--text 0..1 Narrative--><xsl:if test="f:text">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="text">
            <xsl:apply-templates select="f:text" mode="Narrative"/>
         </map>
      </xsl:if>
                    <!--contained 0..* ResourceContainer--><xsl:if test="f:contained">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contained">
            <xsl:for-each select="f:contained">
               <map>
                  <xsl:apply-templates select="." mode="ResourceContainer"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--modifierExtension 0..* Extension--><xsl:if test="f:modifierExtension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifierExtension">
            <xsl:for-each select="f:modifierExtension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="NoteType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReferenceStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMapEquivalence">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="RemittanceOutcome">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConformanceResourceStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AdministrativeGender">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SearchParamType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centres, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Account">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Account</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--status 0..1 AccountStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--activePeriod 0..1 Period--><xsl:if test="f:activePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="activePeriod">
            <xsl:apply-templates select="f:activePeriod" mode="Period"/>
         </map>
      </xsl:if>
                    <!--currency 0..1 Coding--><xsl:if test="f:currency">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="currency">
            <xsl:apply-templates select="f:currency" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--balance 0..1 Money--><xsl:if test="f:balance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="balance">
            <xsl:apply-templates select="f:balance" mode="Money"/>
         </map>
      </xsl:if>
                    <!--coveragePeriod 0..1 Period--><xsl:if test="f:coveragePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coveragePeriod">
            <xsl:apply-templates select="f:coveragePeriod" mode="Period"/>
         </map>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--owner 0..1 Reference--><xsl:if test="f:owner">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="owner">
            <xsl:apply-templates select="f:owner" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the account is available to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AccountStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntolerance">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">AllergyIntolerance</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--onset 0..1 dateTime (json type: string)--><xsl:if test="f:onset">
         <xsl:if test="f:onset/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onset">
               <xsl:value-of select="f:onset/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onset[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onset">
               <xsl:apply-templates select="f:onset" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--recordedDate 0..1 dateTime (json type: string)--><xsl:if test="f:recordedDate">
         <xsl:if test="f:recordedDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="recordedDate">
               <xsl:value-of select="f:recordedDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:recordedDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_recordedDate">
               <xsl:apply-templates select="f:recordedDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--recorder 0..1 Reference--><xsl:if test="f:recorder">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="recorder">
            <xsl:apply-templates select="f:recorder" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--reporter 0..1 Reference--><xsl:if test="f:reporter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reporter">
            <xsl:apply-templates select="f:reporter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--substance 1..1 CodeableConcept--><xsl:if test="f:substance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="substance">
            <xsl:apply-templates select="f:substance" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--status 0..1 AllergyIntoleranceStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--criticality 0..1 AllergyIntoleranceCriticality (json type: string)--><xsl:if test="f:criticality">
         <xsl:if test="f:criticality/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="criticality">
               <xsl:value-of select="f:criticality/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:criticality[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_criticality">
               <xsl:apply-templates select="f:criticality" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 AllergyIntoleranceType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--category 0..1 AllergyIntoleranceCategory (json type: string)--><xsl:if test="f:category">
         <xsl:if test="f:category/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="category">
               <xsl:value-of select="f:category/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:category[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_category">
               <xsl:apply-templates select="f:category" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--lastOccurence 0..1 dateTime (json type: string)--><xsl:if test="f:lastOccurence">
         <xsl:if test="f:lastOccurence/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastOccurence">
               <xsl:value-of select="f:lastOccurence/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastOccurence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastOccurence">
               <xsl:apply-templates select="f:lastOccurence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--note 0..1 Annotation--><xsl:if test="f:note">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:apply-templates select="f:note" mode="Annotation"/>
         </map>
      </xsl:if>
                    <!--reaction 0..* AllergyIntolerance.Reaction--><xsl:if test="f:reaction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reaction">
            <xsl:for-each select="f:reaction">
               <map>
                  <xsl:apply-templates select="." mode="AllergyIntolerance.Reaction"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntolerance.Reaction">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--substance 0..1 CodeableConcept--><xsl:if test="f:substance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="substance">
            <xsl:apply-templates select="f:substance" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--certainty 0..1 AllergyIntoleranceCertainty (json type: string)--><xsl:if test="f:certainty">
         <xsl:if test="f:certainty/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="certainty">
               <xsl:value-of select="f:certainty/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:certainty[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_certainty">
               <xsl:apply-templates select="f:certainty" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--manifestation 1..* CodeableConcept--><xsl:if test="f:manifestation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="manifestation">
            <xsl:for-each select="f:manifestation">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--onset 0..1 dateTime (json type: string)--><xsl:if test="f:onset">
         <xsl:if test="f:onset/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onset">
               <xsl:value-of select="f:onset/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onset[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onset">
               <xsl:apply-templates select="f:onset" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--severity 0..1 AllergyIntoleranceSeverity (json type: string)--><xsl:if test="f:severity">
         <xsl:if test="f:severity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity">
               <xsl:value-of select="f:severity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:severity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_severity">
               <xsl:apply-templates select="f:severity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--exposureRoute 0..1 CodeableConcept--><xsl:if test="f:exposureRoute">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exposureRoute">
            <xsl:apply-templates select="f:exposureRoute" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--note 0..1 Annotation--><xsl:if test="f:note">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:apply-templates select="f:note" mode="Annotation"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Statement about the degree of clinical certainty that a Specific Substance was the cause of the Manifestation in an reaction event.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCertainty">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Identification of the underlying physiological mechanism for a Reaction Risk.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Clinical assessment of the severity of a reaction event as a whole, potentially considering multiple different manifestations.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceSeverity">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Estimate of the potential clinical harm, or seriousness, of a reaction to an identified Substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCriticality">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Category of an identified Substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCategory">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Assertion about certainty associated with a propensity, or potential risk, of a reaction to the identified Substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Appointment">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Appointment</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 1..1 AppointmentStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--reason 0..1 CodeableConcept--><xsl:if test="f:reason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:apply-templates select="f:reason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--priority 0..1 unsignedInt (json type: number)--><xsl:if test="f:priority">
         <xsl:if test="f:priority/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
               <xsl:value-of select="f:priority/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:priority[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_priority">
               <xsl:apply-templates select="f:priority" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--start 0..1 instant (json type: string)--><xsl:if test="f:start">
         <xsl:if test="f:start/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="start">
               <xsl:value-of select="f:start/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:start[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_start">
               <xsl:apply-templates select="f:start" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--end 0..1 instant (json type: string)--><xsl:if test="f:end">
         <xsl:if test="f:end/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="end">
               <xsl:value-of select="f:end/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:end[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_end">
               <xsl:apply-templates select="f:end" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--minutesDuration 0..1 positiveInt (json type: number)--><xsl:if test="f:minutesDuration">
         <xsl:if test="f:minutesDuration/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minutesDuration">
               <xsl:value-of select="f:minutesDuration/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minutesDuration[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minutesDuration">
               <xsl:apply-templates select="f:minutesDuration" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--slot 0..* Reference--><xsl:if test="f:slot">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="slot">
            <xsl:for-each select="f:slot">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--participant 1..* Appointment.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="Appointment.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Appointment.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--actor 0..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--required 0..1 ParticipantRequired (json type: string)--><xsl:if test="f:required">
         <xsl:if test="f:required/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="required">
               <xsl:value-of select="f:required/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:required[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_required">
               <xsl:apply-templates select="f:required" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 ParticipationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Is the Participant required to attend the appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ParticipantRequired">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The free/busy status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AppointmentStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Participation status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ParticipationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AppointmentResponse">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">AppointmentResponse</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--appointment 1..1 Reference--><xsl:if test="f:appointment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="appointment">
            <xsl:apply-templates select="f:appointment" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--start 0..1 instant (json type: string)--><xsl:if test="f:start">
         <xsl:if test="f:start/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="start">
               <xsl:value-of select="f:start/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:start[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_start">
               <xsl:apply-templates select="f:start" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--end 0..1 instant (json type: string)--><xsl:if test="f:end">
         <xsl:if test="f:end/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="end">
               <xsl:value-of select="f:end/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:end[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_end">
               <xsl:apply-templates select="f:end" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--participantType 0..* CodeableConcept--><xsl:if test="f:participantType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participantType">
            <xsl:for-each select="f:participantType">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--actor 0..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--participantStatus 1..1 ParticipantStatus (json type: string)--><xsl:if test="f:participantStatus">
         <xsl:if test="f:participantStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="participantStatus">
               <xsl:value-of select="f:participantStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:participantStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_participantStatus">
               <xsl:apply-templates select="f:participantStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Participation status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ParticipantStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">AuditEvent</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--event 1..1 AuditEvent.Event--><xsl:if test="f:event">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:apply-templates select="f:event" mode="AuditEvent.Event"/>
         </map>
      </xsl:if>
                    <!--participant 1..* AuditEvent.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="AuditEvent.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--source 1..1 AuditEvent.Source--><xsl:if test="f:source">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="source">
            <xsl:apply-templates select="f:source" mode="AuditEvent.Source"/>
         </map>
      </xsl:if>
                    <!--object 0..* AuditEvent.Object--><xsl:if test="f:object">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="object">
            <xsl:for-each select="f:object">
               <map>
                  <xsl:apply-templates select="." mode="AuditEvent.Object"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Event">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--subtype 0..* Coding--><xsl:if test="f:subtype">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subtype">
            <xsl:for-each select="f:subtype">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--action 0..1 AuditEventAction (json type: string)--><xsl:if test="f:action">
         <xsl:if test="f:action/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="action">
               <xsl:value-of select="f:action/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:action[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_action">
               <xsl:apply-templates select="f:action" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--dateTime 1..1 instant (json type: string)--><xsl:if test="f:dateTime">
         <xsl:if test="f:dateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateTime">
               <xsl:value-of select="f:dateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:dateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dateTime">
               <xsl:apply-templates select="f:dateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--outcome 0..1 AuditEventOutcome (json type: string)--><xsl:if test="f:outcome">
         <xsl:if test="f:outcome/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
               <xsl:value-of select="f:outcome/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:outcome[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_outcome">
               <xsl:apply-templates select="f:outcome" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--outcomeDesc 0..1 string (json type: string)--><xsl:if test="f:outcomeDesc">
         <xsl:if test="f:outcomeDesc/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcomeDesc">
               <xsl:value-of select="f:outcomeDesc/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:outcomeDesc[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_outcomeDesc">
               <xsl:apply-templates select="f:outcomeDesc" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--purposeOfEvent 0..* Coding--><xsl:if test="f:purposeOfEvent">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="purposeOfEvent">
            <xsl:for-each select="f:purposeOfEvent">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--role 0..* CodeableConcept--><xsl:if test="f:role">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:for-each select="f:role">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--reference 0..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--userId 0..1 Identifier--><xsl:if test="f:userId">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="userId">
            <xsl:apply-templates select="f:userId" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--altId 0..1 string (json type: string)--><xsl:if test="f:altId">
         <xsl:if test="f:altId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="altId">
               <xsl:value-of select="f:altId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:altId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_altId">
               <xsl:apply-templates select="f:altId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--requestor 1..1 boolean (json type: boolean)--><xsl:if test="f:requestor">
         <xsl:if test="f:requestor/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="requestor">
               <xsl:value-of select="f:requestor/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:requestor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requestor">
               <xsl:apply-templates select="f:requestor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--policy 0..* uri (json type: string)--><xsl:if test="f:policy">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="policy">
            <xsl:for-each select="f:policy">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:policy[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_policy">
               <xsl:for-each select="f:policy">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--media 0..1 Coding--><xsl:if test="f:media">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="media">
            <xsl:apply-templates select="f:media" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--network 0..1 AuditEvent.Network--><xsl:if test="f:network">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="network">
            <xsl:apply-templates select="f:network" mode="AuditEvent.Network"/>
         </map>
      </xsl:if>
                    <!--purposeOfUse 0..* Coding--><xsl:if test="f:purposeOfUse">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="purposeOfUse">
            <xsl:for-each select="f:purposeOfUse">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Network">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--address 0..1 string (json type: string)--><xsl:if test="f:address">
         <xsl:if test="f:address/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="address">
               <xsl:value-of select="f:address/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:address[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_address">
               <xsl:apply-templates select="f:address" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 AuditEventParticipantNetworkType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Source">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--site 0..1 string (json type: string)--><xsl:if test="f:site">
         <xsl:if test="f:site/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="site">
               <xsl:value-of select="f:site/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:site[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_site">
               <xsl:apply-templates select="f:site" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--identifier 1..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--type 0..* Coding--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Object">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--reference 0..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--type 0..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--role 0..1 Coding--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--lifecycle 0..1 Coding--><xsl:if test="f:lifecycle">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="lifecycle">
            <xsl:apply-templates select="f:lifecycle" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--securityLabel 0..* Coding--><xsl:if test="f:securityLabel">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="securityLabel">
            <xsl:for-each select="f:securityLabel">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--query 0..1 base64Binary (json type: string)--><xsl:if test="f:query">
         <xsl:if test="f:query/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="query">
               <xsl:value-of select="f:query/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:query[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_query">
               <xsl:apply-templates select="f:query" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--detail 0..* AuditEvent.Detail--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="AuditEvent.Detail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Detail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 string (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--value 1..1 base64Binary (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicator for type of action performed during the event that generated the audit.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventAction">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the event succeeded or failed</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventOutcome">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of network access point of this participant in the audit event</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventParticipantNetworkType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Basic">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Basic</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--created 0..1 date (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A binary resource can contain any content, whether text, image, pdf, zip archive, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Binary">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Binary</string>
      <xsl:apply-templates select="." mode="Resource"/>
                    <!--contentType 1..1 code (json type: string)--><xsl:if test="f:contentType">
         <xsl:if test="f:contentType/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType">
               <xsl:value-of select="f:contentType/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentType[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentType">
               <xsl:apply-templates select="f:contentType" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--content 1..1 base64Binary (json type: string)--><xsl:if test="f:content">
         <xsl:if test="f:content/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="content">
               <xsl:value-of select="f:content/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:content[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_content">
               <xsl:apply-templates select="f:content" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Record details about the anatomical location of a specimen or body part.  This resource may be used when a coded concept does not provide the necessary detail needed for the use case.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="BodySite">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">BodySite</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--modifier 0..* CodeableConcept--><xsl:if test="f:modifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifier">
            <xsl:for-each select="f:modifier">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--image 0..* Attachment--><xsl:if test="f:image">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="image">
            <xsl:for-each select="f:image">
               <map>
                  <xsl:apply-templates select="." mode="Attachment"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Bundle</string>
      <xsl:apply-templates select="." mode="Resource"/>
                    <!--type 1..1 BundleType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--total 0..1 unsignedInt (json type: number)--><xsl:if test="f:total">
         <xsl:if test="f:total/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="total">
               <xsl:value-of select="f:total/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:total[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_total">
               <xsl:apply-templates select="f:total" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--link 0..* Bundle.Link--><xsl:if test="f:link">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="link">
            <xsl:for-each select="f:link">
               <map>
                  <xsl:apply-templates select="." mode="Bundle.Link"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--entry 0..* Bundle.Entry--><xsl:if test="f:entry">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="entry">
            <xsl:for-each select="f:entry">
               <map>
                  <xsl:apply-templates select="." mode="Bundle.Entry"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--signature 0..1 Signature--><xsl:if test="f:signature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="signature">
            <xsl:apply-templates select="f:signature" mode="Signature"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Link">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--relation 1..1 string (json type: string)--><xsl:if test="f:relation">
         <xsl:if test="f:relation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="relation">
               <xsl:value-of select="f:relation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:relation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_relation">
               <xsl:apply-templates select="f:relation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 1..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Entry">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--link 0..* Bundle.Link--><xsl:if test="f:link">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="link">
            <xsl:for-each select="f:link">
               <map>
                  <xsl:apply-templates select="." mode="Bundle.Link"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--fullUrl 0..1 uri (json type: string)--><xsl:if test="f:fullUrl">
         <xsl:if test="f:fullUrl/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fullUrl">
               <xsl:value-of select="f:fullUrl/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fullUrl[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fullUrl">
               <xsl:apply-templates select="f:fullUrl" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--resource 0..1 ResourceContainer--><xsl:if test="f:resource">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="resource">
            <xsl:apply-templates select="f:resource" mode="ResourceContainer"/>
         </map>
      </xsl:if>
                    <!--search 0..1 Bundle.Search--><xsl:if test="f:search">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="search">
            <xsl:apply-templates select="f:search" mode="Bundle.Search"/>
         </map>
      </xsl:if>
                    <!--request 0..1 Bundle.Request--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Bundle.Request"/>
         </map>
      </xsl:if>
                    <!--response 0..1 Bundle.Response--><xsl:if test="f:response">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="response">
            <xsl:apply-templates select="f:response" mode="Bundle.Response"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Search">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--mode 0..1 SearchEntryMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--score 0..1 decimal (json type: number)--><xsl:if test="f:score">
         <xsl:if test="f:score/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="score">
               <xsl:value-of select="f:score/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:score[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_score">
               <xsl:apply-templates select="f:score" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Request">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--method 1..1 HTTPVerb (json type: string)--><xsl:if test="f:method">
         <xsl:if test="f:method/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="method">
               <xsl:value-of select="f:method/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:method[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_method">
               <xsl:apply-templates select="f:method" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 1..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--ifNoneMatch 0..1 string (json type: string)--><xsl:if test="f:ifNoneMatch">
         <xsl:if test="f:ifNoneMatch/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifNoneMatch">
               <xsl:value-of select="f:ifNoneMatch/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ifNoneMatch[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ifNoneMatch">
               <xsl:apply-templates select="f:ifNoneMatch" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--ifModifiedSince 0..1 instant (json type: string)--><xsl:if test="f:ifModifiedSince">
         <xsl:if test="f:ifModifiedSince/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifModifiedSince">
               <xsl:value-of select="f:ifModifiedSince/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ifModifiedSince[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ifModifiedSince">
               <xsl:apply-templates select="f:ifModifiedSince" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--ifMatch 0..1 string (json type: string)--><xsl:if test="f:ifMatch">
         <xsl:if test="f:ifMatch/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifMatch">
               <xsl:value-of select="f:ifMatch/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ifMatch[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ifMatch">
               <xsl:apply-templates select="f:ifMatch" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--ifNoneExist 0..1 string (json type: string)--><xsl:if test="f:ifNoneExist">
         <xsl:if test="f:ifNoneExist/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifNoneExist">
               <xsl:value-of select="f:ifNoneExist/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ifNoneExist[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ifNoneExist">
               <xsl:apply-templates select="f:ifNoneExist" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Response">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--status 1..1 string (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--location 0..1 uri (json type: string)--><xsl:if test="f:location">
         <xsl:if test="f:location/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="location">
               <xsl:value-of select="f:location/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:location[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_location">
               <xsl:apply-templates select="f:location" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--etag 0..1 string (json type: string)--><xsl:if test="f:etag">
         <xsl:if test="f:etag/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="etag">
               <xsl:value-of select="f:etag/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:etag[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_etag">
               <xsl:apply-templates select="f:etag" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--lastModified 0..1 instant (json type: string)--><xsl:if test="f:lastModified">
         <xsl:if test="f:lastModified/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastModified">
               <xsl:value-of select="f:lastModified/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastModified[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastModified">
               <xsl:apply-templates select="f:lastModified" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>HTTP verbs (in the HTTP command line).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="HTTPVerb">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Why an entry is in the result set - whether it's included as a match or because of an _include requirement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SearchEntryMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the purpose of a bundle - how it was intended to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="BundleType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">CarePlan</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--status 1..1 CarePlanStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--author 0..* Reference--><xsl:if test="f:author">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:for-each select="f:author">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--modified 0..1 dateTime (json type: string)--><xsl:if test="f:modified">
         <xsl:if test="f:modified/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="modified">
               <xsl:value-of select="f:modified/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:modified[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_modified">
               <xsl:apply-templates select="f:modified" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--category 0..* CodeableConcept--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--addresses 0..* Reference--><xsl:if test="f:addresses">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="addresses">
            <xsl:for-each select="f:addresses">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--support 0..* Reference--><xsl:if test="f:support">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="support">
            <xsl:for-each select="f:support">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--relatedPlan 0..* CarePlan.RelatedPlan--><xsl:if test="f:relatedPlan">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="relatedPlan">
            <xsl:for-each select="f:relatedPlan">
               <map>
                  <xsl:apply-templates select="." mode="CarePlan.RelatedPlan"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--participant 0..* CarePlan.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="CarePlan.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--goal 0..* Reference--><xsl:if test="f:goal">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="goal">
            <xsl:for-each select="f:goal">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--activity 0..* CarePlan.Activity--><xsl:if test="f:activity">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="activity">
            <xsl:for-each select="f:activity">
               <map>
                  <xsl:apply-templates select="." mode="CarePlan.Activity"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--note 0..1 Annotation--><xsl:if test="f:note">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:apply-templates select="f:note" mode="Annotation"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.RelatedPlan">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 0..1 CarePlanRelationship (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--plan 1..1 Reference--><xsl:if test="f:plan">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="plan">
            <xsl:apply-templates select="f:plan" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--role 0..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--member 0..1 Reference--><xsl:if test="f:member">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="member">
            <xsl:apply-templates select="f:member" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Activity">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--actionResulting 0..* Reference--><xsl:if test="f:actionResulting">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actionResulting">
            <xsl:for-each select="f:actionResulting">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--progress 0..* Annotation--><xsl:if test="f:progress">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="progress">
            <xsl:for-each select="f:progress">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--reference 0..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--detail 0..1 CarePlan.Detail--><xsl:if test="f:detail">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:apply-templates select="f:detail" mode="CarePlan.Detail"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Detail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--reasonCode 0..* CodeableConcept--><xsl:if test="f:reasonCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonCode">
            <xsl:for-each select="f:reasonCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--reasonReference 0..* Reference--><xsl:if test="f:reasonReference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonReference">
            <xsl:for-each select="f:reasonReference">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--goal 0..* Reference--><xsl:if test="f:goal">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="goal">
            <xsl:for-each select="f:goal">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 0..1 CarePlanActivityStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--statusReason 0..1 CodeableConcept--><xsl:if test="f:statusReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="statusReason">
            <xsl:apply-templates select="f:statusReason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--prohibited 1..1 boolean (json type: boolean)--><xsl:if test="f:prohibited">
         <xsl:if test="f:prohibited/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="prohibited">
               <xsl:value-of select="f:prohibited/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:prohibited[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_prohibited">
               <xsl:apply-templates select="f:prohibited" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--scheduledTiming 1..1 Timing--><xsl:if test="f:scheduledTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledTiming">
            <xsl:apply-templates select="f:scheduledTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--scheduledPeriod 1..1 Period--><xsl:if test="f:scheduledPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledPeriod">
            <xsl:apply-templates select="f:scheduledPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--scheduledString 1..1 string (json type: string)--><xsl:if test="f:scheduledString">
         <xsl:if test="f:scheduledString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledString">
               <xsl:value-of select="f:scheduledString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:scheduledString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_scheduledString">
               <xsl:apply-templates select="f:scheduledString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--performer 0..* Reference--><xsl:if test="f:performer">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="performer">
            <xsl:for-each select="f:performer">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    
                        
                        <!--productCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:productCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="productCodeableConcept">
            <xsl:apply-templates select="f:productCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--productReference 1..1 Reference--><xsl:if test="f:productReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="productReference">
            <xsl:apply-templates select="f:productReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--dailyAmount 0..1 SimpleQuantity--><xsl:if test="f:dailyAmount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dailyAmount">
            <xsl:apply-templates select="f:dailyAmount" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes identifying the types of relationships between two plans.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanRelationship">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates where the activity is at in its overall life cycle.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanActivityStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Claim</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--type 1..1 ClaimType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--ruleset 0..1 Coding--><xsl:if test="f:ruleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ruleset">
            <xsl:apply-templates select="f:ruleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--target 0..1 Reference--><xsl:if test="f:target">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="target">
            <xsl:apply-templates select="f:target" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--use 0..1 Use (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--priority 0..1 Coding--><xsl:if test="f:priority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
            <xsl:apply-templates select="f:priority" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--fundsReserve 0..1 Coding--><xsl:if test="f:fundsReserve">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fundsReserve">
            <xsl:apply-templates select="f:fundsReserve" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--enterer 0..1 Reference--><xsl:if test="f:enterer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="enterer">
            <xsl:apply-templates select="f:enterer" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--facility 0..1 Reference--><xsl:if test="f:facility">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="facility">
            <xsl:apply-templates select="f:facility" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--prescription 0..1 Reference--><xsl:if test="f:prescription">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="prescription">
            <xsl:apply-templates select="f:prescription" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--originalPrescription 0..1 Reference--><xsl:if test="f:originalPrescription">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalPrescription">
            <xsl:apply-templates select="f:originalPrescription" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--payee 0..1 Claim.Payee--><xsl:if test="f:payee">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="payee">
            <xsl:apply-templates select="f:payee" mode="Claim.Payee"/>
         </map>
      </xsl:if>
                    <!--referral 0..1 Reference--><xsl:if test="f:referral">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="referral">
            <xsl:apply-templates select="f:referral" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--diagnosis 0..* Claim.Diagnosis--><xsl:if test="f:diagnosis">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosis">
            <xsl:for-each select="f:diagnosis">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Diagnosis"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--condition 0..* Coding--><xsl:if test="f:condition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="condition">
            <xsl:for-each select="f:condition">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--coverage 0..* Claim.Coverage--><xsl:if test="f:coverage">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:for-each select="f:coverage">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Coverage"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--exception 0..* Coding--><xsl:if test="f:exception">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="exception">
            <xsl:for-each select="f:exception">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--school 0..1 string (json type: string)--><xsl:if test="f:school">
         <xsl:if test="f:school/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="school">
               <xsl:value-of select="f:school/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:school[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_school">
               <xsl:apply-templates select="f:school" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--accident 0..1 date (json type: string)--><xsl:if test="f:accident">
         <xsl:if test="f:accident/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="accident">
               <xsl:value-of select="f:accident/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:accident[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_accident">
               <xsl:apply-templates select="f:accident" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--accidentType 0..1 Coding--><xsl:if test="f:accidentType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="accidentType">
            <xsl:apply-templates select="f:accidentType" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--interventionException 0..* Coding--><xsl:if test="f:interventionException">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="interventionException">
            <xsl:for-each select="f:interventionException">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--item 0..* Claim.Item--><xsl:if test="f:item">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:for-each select="f:item">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Item"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--additionalMaterials 0..* Coding--><xsl:if test="f:additionalMaterials">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="additionalMaterials">
            <xsl:for-each select="f:additionalMaterials">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--missingTeeth 0..* Claim.MissingTeeth--><xsl:if test="f:missingTeeth">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="missingTeeth">
            <xsl:for-each select="f:missingTeeth">
               <map>
                  <xsl:apply-templates select="." mode="Claim.MissingTeeth"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Payee">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--person 0..1 Reference--><xsl:if test="f:person">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="person">
            <xsl:apply-templates select="f:person" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Diagnosis">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--diagnosis 1..1 Coding--><xsl:if test="f:diagnosis">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosis">
            <xsl:apply-templates select="f:diagnosis" mode="Coding"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Coverage">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--focal 1..1 boolean (json type: boolean)--><xsl:if test="f:focal">
         <xsl:if test="f:focal/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="focal">
               <xsl:value-of select="f:focal/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:focal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_focal">
               <xsl:apply-templates select="f:focal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--coverage 1..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--businessArrangement 0..1 string (json type: string)--><xsl:if test="f:businessArrangement">
         <xsl:if test="f:businessArrangement/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement">
               <xsl:value-of select="f:businessArrangement/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:businessArrangement[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_businessArrangement">
               <xsl:apply-templates select="f:businessArrangement" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--relationship 1..1 Coding--><xsl:if test="f:relationship">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="relationship">
            <xsl:apply-templates select="f:relationship" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--preAuthRef 0..* string (json type: string)--><xsl:if test="f:preAuthRef">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="preAuthRef">
            <xsl:for-each select="f:preAuthRef">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:preAuthRef[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_preAuthRef">
               <xsl:for-each select="f:preAuthRef">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--claimResponse 0..1 Reference--><xsl:if test="f:claimResponse">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="claimResponse">
            <xsl:apply-templates select="f:claimResponse" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Item">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 1..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--diagnosisLinkId 0..* positiveInt (json type: number)--><xsl:if test="f:diagnosisLinkId">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosisLinkId">
            <xsl:for-each select="f:diagnosisLinkId">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:diagnosisLinkId[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_diagnosisLinkId">
               <xsl:for-each select="f:diagnosisLinkId">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--service 1..1 Coding--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--serviceDate 0..1 date (json type: string)--><xsl:if test="f:serviceDate">
         <xsl:if test="f:serviceDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="serviceDate">
               <xsl:value-of select="f:serviceDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:serviceDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_serviceDate">
               <xsl:apply-templates select="f:serviceDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
                    <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--points 0..1 decimal (json type: number)--><xsl:if test="f:points">
         <xsl:if test="f:points/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="points">
               <xsl:value-of select="f:points/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:points[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_points">
               <xsl:apply-templates select="f:points" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
                    <!--udi 0..1 Coding--><xsl:if test="f:udi">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="udi">
            <xsl:apply-templates select="f:udi" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--bodySite 0..1 Coding--><xsl:if test="f:bodySite">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bodySite">
            <xsl:apply-templates select="f:bodySite" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--subSite 0..* Coding--><xsl:if test="f:subSite">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subSite">
            <xsl:for-each select="f:subSite">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--modifier 0..* Coding--><xsl:if test="f:modifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifier">
            <xsl:for-each select="f:modifier">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--detail 0..* Claim.Detail--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Detail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--prosthesis 0..1 Claim.Prosthesis--><xsl:if test="f:prosthesis">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="prosthesis">
            <xsl:apply-templates select="f:prosthesis" mode="Claim.Prosthesis"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Detail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 1..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--service 1..1 Coding--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
                    <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--points 0..1 decimal (json type: number)--><xsl:if test="f:points">
         <xsl:if test="f:points/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="points">
               <xsl:value-of select="f:points/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:points[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_points">
               <xsl:apply-templates select="f:points" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
                    <!--udi 0..1 Coding--><xsl:if test="f:udi">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="udi">
            <xsl:apply-templates select="f:udi" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--subDetail 0..* Claim.SubDetail--><xsl:if test="f:subDetail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subDetail">
            <xsl:for-each select="f:subDetail">
               <map>
                  <xsl:apply-templates select="." mode="Claim.SubDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.SubDetail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 1..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--service 1..1 Coding--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
                    <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--points 0..1 decimal (json type: number)--><xsl:if test="f:points">
         <xsl:if test="f:points/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="points">
               <xsl:value-of select="f:points/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:points[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_points">
               <xsl:apply-templates select="f:points" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
                    <!--udi 0..1 Coding--><xsl:if test="f:udi">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="udi">
            <xsl:apply-templates select="f:udi" mode="Coding"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Prosthesis">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--initial 0..1 boolean (json type: boolean)--><xsl:if test="f:initial">
         <xsl:if test="f:initial/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="initial">
               <xsl:value-of select="f:initial/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:initial[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_initial">
               <xsl:apply-templates select="f:initial" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--priorDate 0..1 date (json type: string)--><xsl:if test="f:priorDate">
         <xsl:if test="f:priorDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="priorDate">
               <xsl:value-of select="f:priorDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:priorDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_priorDate">
               <xsl:apply-templates select="f:priorDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--priorMaterial 0..1 Coding--><xsl:if test="f:priorMaterial">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priorMaterial">
            <xsl:apply-templates select="f:priorMaterial" mode="Coding"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.MissingTeeth">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--tooth 1..1 Coding--><xsl:if test="f:tooth">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="tooth">
            <xsl:apply-templates select="f:tooth" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--reason 0..1 Coding--><xsl:if test="f:reason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:apply-templates select="f:reason" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--extractionDate 0..1 date (json type: string)--><xsl:if test="f:extractionDate">
         <xsl:if test="f:extractionDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="extractionDate">
               <xsl:value-of select="f:extractionDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:extractionDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_extractionDate">
               <xsl:apply-templates select="f:extractionDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type or discipline-style of the claim.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Complete, proposed, exploratory, other.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Use">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ClaimResponse</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--request 0..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--ruleset 0..1 Coding--><xsl:if test="f:ruleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ruleset">
            <xsl:apply-templates select="f:ruleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestProvider 0..1 Reference--><xsl:if test="f:requestProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestProvider">
            <xsl:apply-templates select="f:requestProvider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestOrganization 0..1 Reference--><xsl:if test="f:requestOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestOrganization">
            <xsl:apply-templates select="f:requestOrganization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--outcome 0..1 code (json type: string)--><xsl:if test="f:outcome">
         <xsl:if test="f:outcome/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
               <xsl:value-of select="f:outcome/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:outcome[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_outcome">
               <xsl:apply-templates select="f:outcome" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--disposition 0..1 string (json type: string)--><xsl:if test="f:disposition">
         <xsl:if test="f:disposition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition">
               <xsl:value-of select="f:disposition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:disposition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_disposition">
               <xsl:apply-templates select="f:disposition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--payeeType 0..1 Coding--><xsl:if test="f:payeeType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="payeeType">
            <xsl:apply-templates select="f:payeeType" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--item 0..* ClaimResponse.Item--><xsl:if test="f:item">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:for-each select="f:item">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Item"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--addItem 0..* ClaimResponse.AddItem--><xsl:if test="f:addItem">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="addItem">
            <xsl:for-each select="f:addItem">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.AddItem"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--error 0..* ClaimResponse.Error--><xsl:if test="f:error">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="error">
            <xsl:for-each select="f:error">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Error"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--totalCost 0..1 Money--><xsl:if test="f:totalCost">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="totalCost">
            <xsl:apply-templates select="f:totalCost" mode="Money"/>
         </map>
      </xsl:if>
                    <!--unallocDeductable 0..1 Money--><xsl:if test="f:unallocDeductable">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unallocDeductable">
            <xsl:apply-templates select="f:unallocDeductable" mode="Money"/>
         </map>
      </xsl:if>
                    <!--totalBenefit 0..1 Money--><xsl:if test="f:totalBenefit">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="totalBenefit">
            <xsl:apply-templates select="f:totalBenefit" mode="Money"/>
         </map>
      </xsl:if>
                    <!--paymentAdjustment 0..1 Money--><xsl:if test="f:paymentAdjustment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="paymentAdjustment">
            <xsl:apply-templates select="f:paymentAdjustment" mode="Money"/>
         </map>
      </xsl:if>
                    <!--paymentAdjustmentReason 0..1 Coding--><xsl:if test="f:paymentAdjustmentReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="paymentAdjustmentReason">
            <xsl:apply-templates select="f:paymentAdjustmentReason" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--paymentDate 0..1 date (json type: string)--><xsl:if test="f:paymentDate">
         <xsl:if test="f:paymentDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="paymentDate">
               <xsl:value-of select="f:paymentDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:paymentDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_paymentDate">
               <xsl:apply-templates select="f:paymentDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--paymentAmount 0..1 Money--><xsl:if test="f:paymentAmount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="paymentAmount">
            <xsl:apply-templates select="f:paymentAmount" mode="Money"/>
         </map>
      </xsl:if>
                    <!--paymentRef 0..1 Identifier--><xsl:if test="f:paymentRef">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="paymentRef">
            <xsl:apply-templates select="f:paymentRef" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--reserved 0..1 Coding--><xsl:if test="f:reserved">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reserved">
            <xsl:apply-templates select="f:reserved" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--form 0..1 Coding--><xsl:if test="f:form">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="form">
            <xsl:apply-templates select="f:form" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--note 0..* ClaimResponse.Note--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Note"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--coverage 0..* ClaimResponse.Coverage--><xsl:if test="f:coverage">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:for-each select="f:coverage">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Coverage"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Item">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 1..1 positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <xsl:if test="f:sequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
               <xsl:value-of select="f:sequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:apply-templates select="f:sequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--noteNumber 0..* positiveInt (json type: number)--><xsl:if test="f:noteNumber">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber">
            <xsl:for-each select="f:noteNumber">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:noteNumber[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_noteNumber">
               <xsl:for-each select="f:noteNumber">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--detail 0..* ClaimResponse.Detail--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Detail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--amount 0..1 Money--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="Money"/>
         </map>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Detail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 1..1 positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <xsl:if test="f:sequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
               <xsl:value-of select="f:sequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:apply-templates select="f:sequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication1--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--subDetail 0..* ClaimResponse.SubDetail--><xsl:if test="f:subDetail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subDetail">
            <xsl:for-each select="f:subDetail">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.SubDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--amount 0..1 Money--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="Money"/>
         </map>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.SubDetail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 1..1 positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <xsl:if test="f:sequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
               <xsl:value-of select="f:sequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:apply-templates select="f:sequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication2--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication2"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication2">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--amount 0..1 Money--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="Money"/>
         </map>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.AddItem">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 0..* positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
            <xsl:for-each select="f:sequenceLinkId">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:for-each select="f:sequenceLinkId">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--service 1..1 Coding--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--fee 0..1 Money--><xsl:if test="f:fee">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fee">
            <xsl:apply-templates select="f:fee" mode="Money"/>
         </map>
      </xsl:if>
                    <!--noteNumberLinkId 0..* positiveInt (json type: number)--><xsl:if test="f:noteNumberLinkId">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumberLinkId">
            <xsl:for-each select="f:noteNumberLinkId">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:noteNumberLinkId[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_noteNumberLinkId">
               <xsl:for-each select="f:noteNumberLinkId">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication3--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication3"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--detail 0..* ClaimResponse.Detail1--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Detail1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication3">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--amount 0..1 Money--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="Money"/>
         </map>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Detail1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--service 1..1 Coding--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--fee 0..1 Money--><xsl:if test="f:fee">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fee">
            <xsl:apply-templates select="f:fee" mode="Money"/>
         </map>
      </xsl:if>
                    <!--adjudication 0..* ClaimResponse.Adjudication4--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication4"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication4">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--amount 0..1 Money--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="Money"/>
         </map>
      </xsl:if>
                    <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Error">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequenceLinkId 0..1 positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <xsl:if test="f:sequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
               <xsl:value-of select="f:sequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:apply-templates select="f:sequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--detailSequenceLinkId 0..1 positiveInt (json type: number)--><xsl:if test="f:detailSequenceLinkId">
         <xsl:if test="f:detailSequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="detailSequenceLinkId">
               <xsl:value-of select="f:detailSequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:detailSequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_detailSequenceLinkId">
               <xsl:apply-templates select="f:detailSequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--subdetailSequenceLinkId 0..1 positiveInt (json type: number)--><xsl:if test="f:subdetailSequenceLinkId">
         <xsl:if test="f:subdetailSequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions"
                    key="subdetailSequenceLinkId">
               <xsl:value-of select="f:subdetailSequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:subdetailSequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_subdetailSequenceLinkId">
               <xsl:apply-templates select="f:subdetailSequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Note">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--number 0..1 positiveInt (json type: number)--><xsl:if test="f:number">
         <xsl:if test="f:number/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="number">
               <xsl:value-of select="f:number/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:number[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_number">
               <xsl:apply-templates select="f:number" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Coverage">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--focal 1..1 boolean (json type: boolean)--><xsl:if test="f:focal">
         <xsl:if test="f:focal/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="focal">
               <xsl:value-of select="f:focal/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:focal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_focal">
               <xsl:apply-templates select="f:focal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--coverage 1..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--businessArrangement 0..1 string (json type: string)--><xsl:if test="f:businessArrangement">
         <xsl:if test="f:businessArrangement/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement">
               <xsl:value-of select="f:businessArrangement/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:businessArrangement[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_businessArrangement">
               <xsl:apply-templates select="f:businessArrangement" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--relationship 1..1 Coding--><xsl:if test="f:relationship">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="relationship">
            <xsl:apply-templates select="f:relationship" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--preAuthRef 0..* string (json type: string)--><xsl:if test="f:preAuthRef">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="preAuthRef">
            <xsl:for-each select="f:preAuthRef">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:preAuthRef[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_preAuthRef">
               <xsl:for-each select="f:preAuthRef">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--claimResponse 0..1 Reference--><xsl:if test="f:claimResponse">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="claimResponse">
            <xsl:apply-templates select="f:claimResponse" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ClinicalImpression</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--assessor 0..1 Reference--><xsl:if test="f:assessor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="assessor">
            <xsl:apply-templates select="f:assessor" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--status 1..1 ClinicalImpressionStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--previous 0..1 Reference--><xsl:if test="f:previous">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="previous">
            <xsl:apply-templates select="f:previous" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--problem 0..* Reference--><xsl:if test="f:problem">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="problem">
            <xsl:for-each select="f:problem">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    
                        
                        <!--triggerCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:triggerCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="triggerCodeableConcept">
            <xsl:apply-templates select="f:triggerCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--triggerReference 1..1 Reference--><xsl:if test="f:triggerReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="triggerReference">
            <xsl:apply-templates select="f:triggerReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--investigations 0..* ClinicalImpression.Investigations--><xsl:if test="f:investigations">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="investigations">
            <xsl:for-each select="f:investigations">
               <map>
                  <xsl:apply-templates select="." mode="ClinicalImpression.Investigations"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--protocol 0..1 uri (json type: string)--><xsl:if test="f:protocol">
         <xsl:if test="f:protocol/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="protocol">
               <xsl:value-of select="f:protocol/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:protocol[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_protocol">
               <xsl:apply-templates select="f:protocol" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--summary 0..1 string (json type: string)--><xsl:if test="f:summary">
         <xsl:if test="f:summary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="summary">
               <xsl:value-of select="f:summary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:summary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_summary">
               <xsl:apply-templates select="f:summary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--finding 0..* ClinicalImpression.Finding--><xsl:if test="f:finding">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="finding">
            <xsl:for-each select="f:finding">
               <map>
                  <xsl:apply-templates select="." mode="ClinicalImpression.Finding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--resolved 0..* CodeableConcept--><xsl:if test="f:resolved">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="resolved">
            <xsl:for-each select="f:resolved">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--ruledOut 0..* ClinicalImpression.RuledOut--><xsl:if test="f:ruledOut">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="ruledOut">
            <xsl:for-each select="f:ruledOut">
               <map>
                  <xsl:apply-templates select="." mode="ClinicalImpression.RuledOut"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--prognosis 0..1 string (json type: string)--><xsl:if test="f:prognosis">
         <xsl:if test="f:prognosis/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="prognosis">
               <xsl:value-of select="f:prognosis/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:prognosis[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_prognosis">
               <xsl:apply-templates select="f:prognosis" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--plan 0..* Reference--><xsl:if test="f:plan">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="plan">
            <xsl:for-each select="f:plan">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--action 0..* Reference--><xsl:if test="f:action">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:for-each select="f:action">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.Investigations">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--item 0..* Reference--><xsl:if test="f:item">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:for-each select="f:item">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.Finding">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--item 1..1 CodeableConcept--><xsl:if test="f:item">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:apply-templates select="f:item" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--cause 0..1 string (json type: string)--><xsl:if test="f:cause">
         <xsl:if test="f:cause/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="cause">
               <xsl:value-of select="f:cause/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:cause[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_cause">
               <xsl:apply-templates select="f:cause" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.RuledOut">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--item 1..1 CodeableConcept--><xsl:if test="f:item">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:apply-templates select="f:item" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--reason 0..1 string (json type: string)--><xsl:if test="f:reason">
         <xsl:if test="f:reason/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
               <xsl:value-of select="f:reason/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:reason[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reason">
               <xsl:apply-templates select="f:reason" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The workflow state of a clinical impression.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpressionStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Communication">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Communication</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--sender 0..1 Reference--><xsl:if test="f:sender">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sender">
            <xsl:apply-templates select="f:sender" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--recipient 0..* Reference--><xsl:if test="f:recipient">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="recipient">
            <xsl:for-each select="f:recipient">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--payload 0..* Communication.Payload--><xsl:if test="f:payload">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="payload">
            <xsl:for-each select="f:payload">
               <map>
                  <xsl:apply-templates select="." mode="Communication.Payload"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--medium 0..* CodeableConcept--><xsl:if test="f:medium">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="medium">
            <xsl:for-each select="f:medium">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 0..1 CommunicationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--sent 0..1 dateTime (json type: string)--><xsl:if test="f:sent">
         <xsl:if test="f:sent/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sent">
               <xsl:value-of select="f:sent/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sent[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sent">
               <xsl:apply-templates select="f:sent" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--received 0..1 dateTime (json type: string)--><xsl:if test="f:received">
         <xsl:if test="f:received/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="received">
               <xsl:value-of select="f:received/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:received[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_received">
               <xsl:apply-templates select="f:received" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestDetail 0..1 Reference--><xsl:if test="f:requestDetail">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestDetail">
            <xsl:apply-templates select="f:requestDetail" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Communication.Payload">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentString 1..1 string (json type: string)--><xsl:if test="f:contentString">
         <xsl:if test="f:contentString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentString">
               <xsl:value-of select="f:contentString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentString">
               <xsl:apply-templates select="f:contentString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the communication.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">CommunicationRequest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--sender 0..1 Reference--><xsl:if test="f:sender">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sender">
            <xsl:apply-templates select="f:sender" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--recipient 0..* Reference--><xsl:if test="f:recipient">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="recipient">
            <xsl:for-each select="f:recipient">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--payload 0..* CommunicationRequest.Payload--><xsl:if test="f:payload">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="payload">
            <xsl:for-each select="f:payload">
               <map>
                  <xsl:apply-templates select="." mode="CommunicationRequest.Payload"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--medium 0..* CodeableConcept--><xsl:if test="f:medium">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="medium">
            <xsl:for-each select="f:medium">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--requester 0..1 Reference--><xsl:if test="f:requester">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requester">
            <xsl:apply-templates select="f:requester" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--status 0..1 CommunicationRequestStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    
                        
                        <!--scheduledDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:scheduledDateTime">
         <xsl:if test="f:scheduledDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledDateTime">
               <xsl:value-of select="f:scheduledDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:scheduledDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_scheduledDateTime">
               <xsl:apply-templates select="f:scheduledDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--scheduledPeriod 1..1 Period--><xsl:if test="f:scheduledPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledPeriod">
            <xsl:apply-templates select="f:scheduledPeriod" mode="Period"/>
         </map>
      </xsl:if>
                    
                    <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--requestedOn 0..1 dateTime (json type: string)--><xsl:if test="f:requestedOn">
         <xsl:if test="f:requestedOn/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="requestedOn">
               <xsl:value-of select="f:requestedOn/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:requestedOn[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requestedOn">
               <xsl:apply-templates select="f:requestedOn" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--priority 0..1 CodeableConcept--><xsl:if test="f:priority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
            <xsl:apply-templates select="f:priority" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest.Payload">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentString 1..1 string (json type: string)--><xsl:if test="f:contentString">
         <xsl:if test="f:contentString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentString">
               <xsl:value-of select="f:contentString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentString">
               <xsl:apply-templates select="f:contentString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the communication.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequestStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Composition</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--date 1..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--class 0..1 CodeableConcept--><xsl:if test="f:class">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="class">
            <xsl:apply-templates select="f:class" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--title 1..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 CompositionStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--confidentiality 0..1 code (json type: string)--><xsl:if test="f:confidentiality">
         <xsl:if test="f:confidentiality/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="confidentiality">
               <xsl:value-of select="f:confidentiality/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:confidentiality[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_confidentiality">
               <xsl:apply-templates select="f:confidentiality" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--author 1..* Reference--><xsl:if test="f:author">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:for-each select="f:author">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--attester 0..* Composition.Attester--><xsl:if test="f:attester">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="attester">
            <xsl:for-each select="f:attester">
               <map>
                  <xsl:apply-templates select="." mode="Composition.Attester"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--custodian 0..1 Reference--><xsl:if test="f:custodian">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="custodian">
            <xsl:apply-templates select="f:custodian" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--event 0..* Composition.Event--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <map>
                  <xsl:apply-templates select="." mode="Composition.Event"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--section 0..* Composition.Section--><xsl:if test="f:section">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="section">
            <xsl:for-each select="f:section">
               <map>
                  <xsl:apply-templates select="." mode="Composition.Section"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Attester">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--mode 1..* CompositionAttestationMode (json type: string)--><xsl:if test="f:mode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
            <xsl:for-each select="f:mode">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:mode[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:for-each select="f:mode">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--time 0..1 dateTime (json type: string)--><xsl:if test="f:time">
         <xsl:if test="f:time/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="time">
               <xsl:value-of select="f:time/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:time[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_time">
               <xsl:apply-templates select="f:time" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--party 0..1 Reference--><xsl:if test="f:party">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="party">
            <xsl:apply-templates select="f:party" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Event">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 0..* CodeableConcept--><xsl:if test="f:code">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:for-each select="f:code">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--detail 0..* Reference--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Section">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--text 0..1 Narrative--><xsl:if test="f:text">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="text">
            <xsl:apply-templates select="f:text" mode="Narrative"/>
         </map>
      </xsl:if>
                    <!--mode 0..1 code (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--orderedBy 0..1 CodeableConcept--><xsl:if test="f:orderedBy">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="orderedBy">
            <xsl:apply-templates select="f:orderedBy" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--entry 0..* Reference--><xsl:if test="f:entry">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="entry">
            <xsl:for-each select="f:entry">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--emptyReason 0..1 CodeableConcept--><xsl:if test="f:emptyReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="emptyReason">
            <xsl:apply-templates select="f:emptyReason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--section 0..* Composition.Section--><xsl:if test="f:section">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="section">
            <xsl:for-each select="f:section">
               <map>
                  <xsl:apply-templates select="." mode="Composition.Section"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The workflow/clinical status of the composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CompositionStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The way in which a person authenticated a composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CompositionAttestationMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ConceptMap</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 code (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--contact 0..* ConceptMap.Contact--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.Contact"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--useContext 0..* CodeableConcept--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--requirements 0..1 string (json type: string)--><xsl:if test="f:requirements">
         <xsl:if test="f:requirements/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements">
               <xsl:value-of select="f:requirements/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:requirements[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requirements">
               <xsl:apply-templates select="f:requirements" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--copyright 0..1 string (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--sourceUri 1..1 uri (json type: string)--><xsl:if test="f:sourceUri">
         <xsl:if test="f:sourceUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sourceUri">
               <xsl:value-of select="f:sourceUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sourceUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sourceUri">
               <xsl:apply-templates select="f:sourceUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--sourceReference 1..1 Reference--><xsl:if test="f:sourceReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sourceReference">
            <xsl:apply-templates select="f:sourceReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--targetUri 1..1 uri (json type: string)--><xsl:if test="f:targetUri">
         <xsl:if test="f:targetUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetUri">
               <xsl:value-of select="f:targetUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:targetUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_targetUri">
               <xsl:apply-templates select="f:targetUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--targetReference 1..1 Reference--><xsl:if test="f:targetReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="targetReference">
            <xsl:apply-templates select="f:targetReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--element 0..* ConceptMap.Element--><xsl:if test="f:element">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="element">
            <xsl:for-each select="f:element">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.Element"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Contact">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:if test="f:telecom">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="telecom">
            <xsl:for-each select="f:telecom">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Element">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--codeSystem 0..1 uri (json type: string)--><xsl:if test="f:codeSystem">
         <xsl:if test="f:codeSystem/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="codeSystem">
               <xsl:value-of select="f:codeSystem/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:codeSystem[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_codeSystem">
               <xsl:apply-templates select="f:codeSystem" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--target 0..* ConceptMap.Target--><xsl:if test="f:target">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="target">
            <xsl:for-each select="f:target">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.Target"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Target">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--codeSystem 0..1 uri (json type: string)--><xsl:if test="f:codeSystem">
         <xsl:if test="f:codeSystem/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="codeSystem">
               <xsl:value-of select="f:codeSystem/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:codeSystem[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_codeSystem">
               <xsl:apply-templates select="f:codeSystem" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--equivalence 1..1 code (json type: string)--><xsl:if test="f:equivalence">
         <xsl:if test="f:equivalence/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="equivalence">
               <xsl:value-of select="f:equivalence/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:equivalence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_equivalence">
               <xsl:apply-templates select="f:equivalence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comments 0..1 string (json type: string)--><xsl:if test="f:comments">
         <xsl:if test="f:comments/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comments">
               <xsl:value-of select="f:comments/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comments[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comments">
               <xsl:apply-templates select="f:comments" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--dependsOn 0..* ConceptMap.DependsOn--><xsl:if test="f:dependsOn">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dependsOn">
            <xsl:for-each select="f:dependsOn">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.DependsOn"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--product 0..* ConceptMap.DependsOn--><xsl:if test="f:product">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="product">
            <xsl:for-each select="f:product">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.DependsOn"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.DependsOn">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--element 1..1 uri (json type: string)--><xsl:if test="f:element">
         <xsl:if test="f:element/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="element">
               <xsl:value-of select="f:element/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:element[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_element">
               <xsl:apply-templates select="f:element" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--codeSystem 1..1 uri (json type: string)--><xsl:if test="f:codeSystem">
         <xsl:if test="f:codeSystem/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="codeSystem">
               <xsl:value-of select="f:codeSystem/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:codeSystem[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_codeSystem">
               <xsl:apply-templates select="f:codeSystem" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 1..1 string (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use to record detailed information about conditions, problems or diagnoses recognized by a clinician. There are many uses including: recording a diagnosis during an encounter; populating a problem list or a summary statement, such as a discharge summary.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Condition">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Condition</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--asserter 0..1 Reference--><xsl:if test="f:asserter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="asserter">
            <xsl:apply-templates select="f:asserter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--dateRecorded 0..1 date (json type: string)--><xsl:if test="f:dateRecorded">
         <xsl:if test="f:dateRecorded/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateRecorded">
               <xsl:value-of select="f:dateRecorded/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:dateRecorded[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dateRecorded">
               <xsl:apply-templates select="f:dateRecorded" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--clinicalStatus 0..1 code (json type: string)--><xsl:if test="f:clinicalStatus">
         <xsl:if test="f:clinicalStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="clinicalStatus">
               <xsl:value-of select="f:clinicalStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:clinicalStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_clinicalStatus">
               <xsl:apply-templates select="f:clinicalStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--verificationStatus 1..1 ConditionVerificationStatus (json type: string)--><xsl:if test="f:verificationStatus">
         <xsl:if test="f:verificationStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="verificationStatus">
               <xsl:value-of select="f:verificationStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:verificationStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_verificationStatus">
               <xsl:apply-templates select="f:verificationStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--severity 0..1 CodeableConcept--><xsl:if test="f:severity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="severity">
            <xsl:apply-templates select="f:severity" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    
                        
                        <!--onsetDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:onsetDateTime">
         <xsl:if test="f:onsetDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetDateTime">
               <xsl:value-of select="f:onsetDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onsetDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onsetDateTime">
               <xsl:apply-templates select="f:onsetDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--onsetQuantity 1..1 Age--><xsl:if test="f:onsetQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetQuantity">
            <xsl:apply-templates select="f:onsetQuantity" mode="Age"/>
         </map>
      </xsl:if>
                        <!--onsetPeriod 1..1 Period--><xsl:if test="f:onsetPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetPeriod">
            <xsl:apply-templates select="f:onsetPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--onsetRange 1..1 Range--><xsl:if test="f:onsetRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetRange">
            <xsl:apply-templates select="f:onsetRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--onsetString 1..1 string (json type: string)--><xsl:if test="f:onsetString">
         <xsl:if test="f:onsetString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetString">
               <xsl:value-of select="f:onsetString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onsetString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onsetString">
               <xsl:apply-templates select="f:onsetString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    
                        
                        <!--abatementDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:abatementDateTime">
         <xsl:if test="f:abatementDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="abatementDateTime">
               <xsl:value-of select="f:abatementDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:abatementDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_abatementDateTime">
               <xsl:apply-templates select="f:abatementDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--abatementQuantity 1..1 Age--><xsl:if test="f:abatementQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="abatementQuantity">
            <xsl:apply-templates select="f:abatementQuantity" mode="Age"/>
         </map>
      </xsl:if>
                        <!--abatementBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:abatementBoolean">
         <xsl:if test="f:abatementBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="abatementBoolean">
               <xsl:value-of select="f:abatementBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:abatementBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_abatementBoolean">
               <xsl:apply-templates select="f:abatementBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--abatementPeriod 1..1 Period--><xsl:if test="f:abatementPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="abatementPeriod">
            <xsl:apply-templates select="f:abatementPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--abatementRange 1..1 Range--><xsl:if test="f:abatementRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="abatementRange">
            <xsl:apply-templates select="f:abatementRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--abatementString 1..1 string (json type: string)--><xsl:if test="f:abatementString">
         <xsl:if test="f:abatementString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="abatementString">
               <xsl:value-of select="f:abatementString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:abatementString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_abatementString">
               <xsl:apply-templates select="f:abatementString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    <!--stage 0..1 Condition.Stage--><xsl:if test="f:stage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="stage">
            <xsl:apply-templates select="f:stage" mode="Condition.Stage"/>
         </map>
      </xsl:if>
                    <!--evidence 0..* Condition.Evidence--><xsl:if test="f:evidence">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="evidence">
            <xsl:for-each select="f:evidence">
               <map>
                  <xsl:apply-templates select="." mode="Condition.Evidence"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--bodySite 0..* CodeableConcept--><xsl:if test="f:bodySite">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="bodySite">
            <xsl:for-each select="f:bodySite">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--notes 0..1 string (json type: string)--><xsl:if test="f:notes">
         <xsl:if test="f:notes/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="notes">
               <xsl:value-of select="f:notes/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:notes[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_notes">
               <xsl:apply-templates select="f:notes" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use to record detailed information about conditions, problems or diagnoses recognized by a clinician. There are many uses including: recording a diagnosis during an encounter; populating a problem list or a summary statement, such as a discharge summary.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Condition.Stage">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--summary 0..1 CodeableConcept--><xsl:if test="f:summary">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="summary">
            <xsl:apply-templates select="f:summary" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--assessment 0..* Reference--><xsl:if test="f:assessment">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="assessment">
            <xsl:for-each select="f:assessment">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use to record detailed information about conditions, problems or diagnoses recognized by a clinician. There are many uses including: recording a diagnosis during an encounter; populating a problem list or a summary statement, such as a discharge summary.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Condition.Evidence">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--detail 0..* Reference--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The verification status to support or decline the clinical status of the condition or diagnosis.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConditionVerificationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Conformance</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 0..1 code (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--contact 0..* Conformance.Contact--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Contact"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--date 1..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--requirements 0..1 string (json type: string)--><xsl:if test="f:requirements">
         <xsl:if test="f:requirements/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements">
               <xsl:value-of select="f:requirements/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:requirements[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requirements">
               <xsl:apply-templates select="f:requirements" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--copyright 0..1 string (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--kind 1..1 ConformanceStatementKind (json type: string)--><xsl:if test="f:kind">
         <xsl:if test="f:kind/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="kind">
               <xsl:value-of select="f:kind/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:kind[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_kind">
               <xsl:apply-templates select="f:kind" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--software 0..1 Conformance.Software--><xsl:if test="f:software">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="software">
            <xsl:apply-templates select="f:software" mode="Conformance.Software"/>
         </map>
      </xsl:if>
                    <!--implementation 0..1 Conformance.Implementation--><xsl:if test="f:implementation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="implementation">
            <xsl:apply-templates select="f:implementation" mode="Conformance.Implementation"/>
         </map>
      </xsl:if>
                    <!--fhirVersion 1..1 id (json type: string)--><xsl:if test="f:fhirVersion">
         <xsl:if test="f:fhirVersion/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fhirVersion">
               <xsl:value-of select="f:fhirVersion/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fhirVersion[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fhirVersion">
               <xsl:apply-templates select="f:fhirVersion" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--acceptUnknown 1..1 UnknownContentCode (json type: string)--><xsl:if test="f:acceptUnknown">
         <xsl:if test="f:acceptUnknown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="acceptUnknown">
               <xsl:value-of select="f:acceptUnknown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:acceptUnknown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_acceptUnknown">
               <xsl:apply-templates select="f:acceptUnknown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--format 1..* code (json type: string)--><xsl:if test="f:format">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="format">
            <xsl:for-each select="f:format">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:format[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_format">
               <xsl:for-each select="f:format">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--profile 0..* Reference--><xsl:if test="f:profile">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:for-each select="f:profile">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--rest 0..* Conformance.Rest--><xsl:if test="f:rest">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="rest">
            <xsl:for-each select="f:rest">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Rest"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--messaging 0..* Conformance.Messaging--><xsl:if test="f:messaging">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="messaging">
            <xsl:for-each select="f:messaging">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Messaging"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--document 0..* Conformance.Document--><xsl:if test="f:document">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="document">
            <xsl:for-each select="f:document">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Document"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Contact">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:if test="f:telecom">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="telecom">
            <xsl:for-each select="f:telecom">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Software">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--releaseDate 0..1 dateTime (json type: string)--><xsl:if test="f:releaseDate">
         <xsl:if test="f:releaseDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="releaseDate">
               <xsl:value-of select="f:releaseDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:releaseDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_releaseDate">
               <xsl:apply-templates select="f:releaseDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Implementation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--description 1..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Rest">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--mode 1..1 RestfulConformanceMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--security 0..1 Conformance.Security--><xsl:if test="f:security">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="security">
            <xsl:apply-templates select="f:security" mode="Conformance.Security"/>
         </map>
      </xsl:if>
                    <!--resource 1..* Conformance.Resource--><xsl:if test="f:resource">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="resource">
            <xsl:for-each select="f:resource">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Resource"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--interaction 0..* Conformance.Interaction1--><xsl:if test="f:interaction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="interaction">
            <xsl:for-each select="f:interaction">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Interaction1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--transactionMode 0..1 TransactionMode (json type: string)--><xsl:if test="f:transactionMode">
         <xsl:if test="f:transactionMode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="transactionMode">
               <xsl:value-of select="f:transactionMode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:transactionMode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_transactionMode">
               <xsl:apply-templates select="f:transactionMode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--searchParam 0..* Conformance.SearchParam--><xsl:if test="f:searchParam">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="searchParam">
            <xsl:for-each select="f:searchParam">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.SearchParam"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--operation 0..* Conformance.Operation--><xsl:if test="f:operation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="operation">
            <xsl:for-each select="f:operation">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Operation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--compartment 0..* uri (json type: string)--><xsl:if test="f:compartment">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="compartment">
            <xsl:for-each select="f:compartment">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:compartment[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_compartment">
               <xsl:for-each select="f:compartment">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Security">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--cors 0..1 boolean (json type: boolean)--><xsl:if test="f:cors">
         <xsl:if test="f:cors/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="cors">
               <xsl:value-of select="f:cors/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:cors[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_cors">
               <xsl:apply-templates select="f:cors" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--service 0..* CodeableConcept--><xsl:if test="f:service">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:for-each select="f:service">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--certificate 0..* Conformance.Certificate--><xsl:if test="f:certificate">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="certificate">
            <xsl:for-each select="f:certificate">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Certificate"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Certificate">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..1 code (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--blob 0..1 base64Binary (json type: string)--><xsl:if test="f:blob">
         <xsl:if test="f:blob/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="blob">
               <xsl:value-of select="f:blob/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:blob[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_blob">
               <xsl:apply-templates select="f:blob" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Resource">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 code (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--profile 0..1 Reference--><xsl:if test="f:profile">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:apply-templates select="f:profile" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--interaction 1..* Conformance.Interaction--><xsl:if test="f:interaction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="interaction">
            <xsl:for-each select="f:interaction">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Interaction"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--versioning 0..1 ResourceVersionPolicy (json type: string)--><xsl:if test="f:versioning">
         <xsl:if test="f:versioning/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="versioning">
               <xsl:value-of select="f:versioning/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:versioning[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_versioning">
               <xsl:apply-templates select="f:versioning" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--readHistory 0..1 boolean (json type: boolean)--><xsl:if test="f:readHistory">
         <xsl:if test="f:readHistory/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="readHistory">
               <xsl:value-of select="f:readHistory/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:readHistory[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_readHistory">
               <xsl:apply-templates select="f:readHistory" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--updateCreate 0..1 boolean (json type: boolean)--><xsl:if test="f:updateCreate">
         <xsl:if test="f:updateCreate/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="updateCreate">
               <xsl:value-of select="f:updateCreate/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:updateCreate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_updateCreate">
               <xsl:apply-templates select="f:updateCreate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--conditionalCreate 0..1 boolean (json type: boolean)--><xsl:if test="f:conditionalCreate">
         <xsl:if test="f:conditionalCreate/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalCreate">
               <xsl:value-of select="f:conditionalCreate/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:conditionalCreate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conditionalCreate">
               <xsl:apply-templates select="f:conditionalCreate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--conditionalUpdate 0..1 boolean (json type: boolean)--><xsl:if test="f:conditionalUpdate">
         <xsl:if test="f:conditionalUpdate/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalUpdate">
               <xsl:value-of select="f:conditionalUpdate/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:conditionalUpdate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conditionalUpdate">
               <xsl:apply-templates select="f:conditionalUpdate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--conditionalDelete 0..1 ConditionalDeleteStatus (json type: string)--><xsl:if test="f:conditionalDelete">
         <xsl:if test="f:conditionalDelete/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalDelete">
               <xsl:value-of select="f:conditionalDelete/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:conditionalDelete[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conditionalDelete">
               <xsl:apply-templates select="f:conditionalDelete" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--searchInclude 0..* string (json type: string)--><xsl:if test="f:searchInclude">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="searchInclude">
            <xsl:for-each select="f:searchInclude">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:searchInclude[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_searchInclude">
               <xsl:for-each select="f:searchInclude">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--searchRevInclude 0..* string (json type: string)--><xsl:if test="f:searchRevInclude">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="searchRevInclude">
            <xsl:for-each select="f:searchRevInclude">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:searchRevInclude[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_searchRevInclude">
               <xsl:for-each select="f:searchRevInclude">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--searchParam 0..* Conformance.SearchParam--><xsl:if test="f:searchParam">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="searchParam">
            <xsl:for-each select="f:searchParam">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.SearchParam"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Interaction">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 TypeRestfulInteraction (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.SearchParam">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--definition 0..1 uri (json type: string)--><xsl:if test="f:definition">
         <xsl:if test="f:definition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
               <xsl:value-of select="f:definition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:definition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_definition">
               <xsl:apply-templates select="f:definition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 1..1 code (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--target 0..* code (json type: string)--><xsl:if test="f:target">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="target">
            <xsl:for-each select="f:target">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:target[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_target">
               <xsl:for-each select="f:target">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--modifier 0..* SearchModifierCode (json type: string)--><xsl:if test="f:modifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifier">
            <xsl:for-each select="f:modifier">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:modifier[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_modifier">
               <xsl:for-each select="f:modifier">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--chain 0..* string (json type: string)--><xsl:if test="f:chain">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="chain">
            <xsl:for-each select="f:chain">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:chain[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_chain">
               <xsl:for-each select="f:chain">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Interaction1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 SystemRestfulInteraction (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Operation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--definition 1..1 Reference--><xsl:if test="f:definition">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
            <xsl:apply-templates select="f:definition" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Messaging">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--endpoint 0..* Conformance.Endpoint--><xsl:if test="f:endpoint">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="endpoint">
            <xsl:for-each select="f:endpoint">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Endpoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--reliableCache 0..1 unsignedInt (json type: number)--><xsl:if test="f:reliableCache">
         <xsl:if test="f:reliableCache/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="reliableCache">
               <xsl:value-of select="f:reliableCache/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:reliableCache[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reliableCache">
               <xsl:apply-templates select="f:reliableCache" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--event 1..* Conformance.Event--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <map>
                  <xsl:apply-templates select="." mode="Conformance.Event"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Endpoint">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--protocol 1..1 Coding--><xsl:if test="f:protocol">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="protocol">
            <xsl:apply-templates select="f:protocol" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--address 1..1 uri (json type: string)--><xsl:if test="f:address">
         <xsl:if test="f:address/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="address">
               <xsl:value-of select="f:address/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:address[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_address">
               <xsl:apply-templates select="f:address" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Event">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--category 0..1 MessageSignificanceCategory (json type: string)--><xsl:if test="f:category">
         <xsl:if test="f:category/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="category">
               <xsl:value-of select="f:category/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:category[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_category">
               <xsl:apply-templates select="f:category" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--mode 1..1 ConformanceEventMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--focus 1..1 code (json type: string)--><xsl:if test="f:focus">
         <xsl:if test="f:focus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="focus">
               <xsl:value-of select="f:focus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:focus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_focus">
               <xsl:apply-templates select="f:focus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--request 1..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--response 1..1 Reference--><xsl:if test="f:response">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="response">
            <xsl:apply-templates select="f:response" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A conformance statement is a set of capabilities of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Conformance.Document">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--mode 1..1 DocumentMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--profile 1..1 Reference--><xsl:if test="f:profile">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:apply-templates select="f:profile" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Whether the application produces or consumes documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Operations supported by REST at the system level.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SystemRestfulInteraction">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How the system supports versioning for a resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ResourceVersionPolicy">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The mode of a RESTful conformance statement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="RestfulConformanceMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Operations supported by REST at the type or instance level.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="TypeRestfulInteraction">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates how the server supports conditional delete.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConditionalDeleteStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a conformance statement is intended to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConformanceStatementKind">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A supported modifier for a search parameter.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SearchModifierCode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The mode of a message conformance statement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConformanceEventMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The impact of the content of a message.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MessageSignificanceCategory">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates whether an application accepts unknown elements or extensions when reading resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="UnknownContentCode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates how transactions are supported.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="TransactionMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Contract</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--issued 0..1 dateTime (json type: string)--><xsl:if test="f:issued">
         <xsl:if test="f:issued/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued">
               <xsl:value-of select="f:issued/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:issued[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_issued">
               <xsl:apply-templates select="f:issued" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--applies 0..1 Period--><xsl:if test="f:applies">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="applies">
            <xsl:apply-templates select="f:applies" mode="Period"/>
         </map>
      </xsl:if>
                    <!--subject 0..* Reference--><xsl:if test="f:subject">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:for-each select="f:subject">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--authority 0..* Reference--><xsl:if test="f:authority">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="authority">
            <xsl:for-each select="f:authority">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--domain 0..* Reference--><xsl:if test="f:domain">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="domain">
            <xsl:for-each select="f:domain">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--subType 0..* CodeableConcept--><xsl:if test="f:subType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subType">
            <xsl:for-each select="f:subType">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--action 0..* CodeableConcept--><xsl:if test="f:action">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:for-each select="f:action">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--actionReason 0..* CodeableConcept--><xsl:if test="f:actionReason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actionReason">
            <xsl:for-each select="f:actionReason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--actor 0..* Contract.Actor--><xsl:if test="f:actor">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:for-each select="f:actor">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Actor"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--valuedItem 0..* Contract.ValuedItem--><xsl:if test="f:valuedItem">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="valuedItem">
            <xsl:for-each select="f:valuedItem">
               <map>
                  <xsl:apply-templates select="." mode="Contract.ValuedItem"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--signer 0..* Contract.Signer--><xsl:if test="f:signer">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="signer">
            <xsl:for-each select="f:signer">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Signer"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--term 0..* Contract.Term--><xsl:if test="f:term">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="term">
            <xsl:for-each select="f:term">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Term"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    
                        
                        <!--bindingAttachment 1..1 Attachment--><xsl:if test="f:bindingAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bindingAttachment">
            <xsl:apply-templates select="f:bindingAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--bindingReference 1..1 Reference--><xsl:if test="f:bindingReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bindingReference">
            <xsl:apply-templates select="f:bindingReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--friendly 0..* Contract.Friendly--><xsl:if test="f:friendly">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="friendly">
            <xsl:for-each select="f:friendly">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Friendly"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--legal 0..* Contract.Legal--><xsl:if test="f:legal">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="legal">
            <xsl:for-each select="f:legal">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Legal"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--rule 0..* Contract.Rule--><xsl:if test="f:rule">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="rule">
            <xsl:for-each select="f:rule">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Rule"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Actor">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--entity 1..1 Reference--><xsl:if test="f:entity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entity">
            <xsl:apply-templates select="f:entity" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--role 0..* CodeableConcept--><xsl:if test="f:role">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:for-each select="f:role">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.ValuedItem">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--entityCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:entityCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entityCodeableConcept">
            <xsl:apply-templates select="f:entityCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--entityReference 1..1 Reference--><xsl:if test="f:entityReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entityReference">
            <xsl:apply-templates select="f:entityReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--effectiveTime 0..1 dateTime (json type: string)--><xsl:if test="f:effectiveTime">
         <xsl:if test="f:effectiveTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveTime">
               <xsl:value-of select="f:effectiveTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:effectiveTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_effectiveTime">
               <xsl:apply-templates select="f:effectiveTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
                    <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--points 0..1 decimal (json type: number)--><xsl:if test="f:points">
         <xsl:if test="f:points/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="points">
               <xsl:value-of select="f:points/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:points[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_points">
               <xsl:apply-templates select="f:points" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Signer">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--party 1..1 Reference--><xsl:if test="f:party">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="party">
            <xsl:apply-templates select="f:party" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--signature 1..1 string (json type: string)--><xsl:if test="f:signature">
         <xsl:if test="f:signature/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="signature">
               <xsl:value-of select="f:signature/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:signature[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_signature">
               <xsl:apply-templates select="f:signature" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Term">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--issued 0..1 dateTime (json type: string)--><xsl:if test="f:issued">
         <xsl:if test="f:issued/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued">
               <xsl:value-of select="f:issued/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:issued[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_issued">
               <xsl:apply-templates select="f:issued" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--applies 0..1 Period--><xsl:if test="f:applies">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="applies">
            <xsl:apply-templates select="f:applies" mode="Period"/>
         </map>
      </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--subType 0..1 CodeableConcept--><xsl:if test="f:subType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subType">
            <xsl:apply-templates select="f:subType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--action 0..* CodeableConcept--><xsl:if test="f:action">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:for-each select="f:action">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--actionReason 0..* CodeableConcept--><xsl:if test="f:actionReason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actionReason">
            <xsl:for-each select="f:actionReason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--actor 0..* Contract.Actor1--><xsl:if test="f:actor">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:for-each select="f:actor">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Actor1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--valuedItem 0..* Contract.ValuedItem1--><xsl:if test="f:valuedItem">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="valuedItem">
            <xsl:for-each select="f:valuedItem">
               <map>
                  <xsl:apply-templates select="." mode="Contract.ValuedItem1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--group 0..* Contract.Term--><xsl:if test="f:group">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="group">
            <xsl:for-each select="f:group">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Term"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Actor1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--entity 1..1 Reference--><xsl:if test="f:entity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entity">
            <xsl:apply-templates select="f:entity" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--role 0..* CodeableConcept--><xsl:if test="f:role">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:for-each select="f:role">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.ValuedItem1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--entityCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:entityCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entityCodeableConcept">
            <xsl:apply-templates select="f:entityCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--entityReference 1..1 Reference--><xsl:if test="f:entityReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entityReference">
            <xsl:apply-templates select="f:entityReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--effectiveTime 0..1 dateTime (json type: string)--><xsl:if test="f:effectiveTime">
         <xsl:if test="f:effectiveTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveTime">
               <xsl:value-of select="f:effectiveTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:effectiveTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_effectiveTime">
               <xsl:apply-templates select="f:effectiveTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
                    <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--points 0..1 decimal (json type: number)--><xsl:if test="f:points">
         <xsl:if test="f:points/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="points">
               <xsl:value-of select="f:points/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:points[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_points">
               <xsl:apply-templates select="f:points" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Friendly">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Legal">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Rule">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Financial instrument which may be used to pay for or reimburse health care products and services.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Coverage">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Coverage</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--issuer 0..1 Reference--><xsl:if test="f:issuer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="issuer">
            <xsl:apply-templates select="f:issuer" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--bin 0..1 Identifier--><xsl:if test="f:bin">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bin">
            <xsl:apply-templates select="f:bin" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--type 0..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--subscriberId 0..1 Identifier--><xsl:if test="f:subscriberId">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subscriberId">
            <xsl:apply-templates select="f:subscriberId" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--group 0..1 string (json type: string)--><xsl:if test="f:group">
         <xsl:if test="f:group/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="group">
               <xsl:value-of select="f:group/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:group[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_group">
               <xsl:apply-templates select="f:group" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--plan 0..1 string (json type: string)--><xsl:if test="f:plan">
         <xsl:if test="f:plan/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="plan">
               <xsl:value-of select="f:plan/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:plan[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_plan">
               <xsl:apply-templates select="f:plan" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--subPlan 0..1 string (json type: string)--><xsl:if test="f:subPlan">
         <xsl:if test="f:subPlan/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="subPlan">
               <xsl:value-of select="f:subPlan/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:subPlan[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_subPlan">
               <xsl:apply-templates select="f:subPlan" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--dependent 0..1 positiveInt (json type: number)--><xsl:if test="f:dependent">
         <xsl:if test="f:dependent/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="dependent">
               <xsl:value-of select="f:dependent/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:dependent[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dependent">
               <xsl:apply-templates select="f:dependent" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--sequence 0..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--subscriber 0..1 Reference--><xsl:if test="f:subscriber">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subscriber">
            <xsl:apply-templates select="f:subscriber" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--network 0..1 Identifier--><xsl:if test="f:network">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="network">
            <xsl:apply-templates select="f:network" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--contract 0..* Reference--><xsl:if test="f:contract">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contract">
            <xsl:for-each select="f:contract">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The formal description of a single piece of information that can be gathered and reported.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataElement">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DataElement</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 code (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--contact 0..* DataElement.Contact--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="DataElement.Contact"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--useContext 0..* CodeableConcept--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--copyright 0..1 string (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--stringency 0..1 DataElementStringency (json type: string)--><xsl:if test="f:stringency">
         <xsl:if test="f:stringency/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="stringency">
               <xsl:value-of select="f:stringency/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:stringency[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_stringency">
               <xsl:apply-templates select="f:stringency" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--mapping 0..* DataElement.Mapping--><xsl:if test="f:mapping">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mapping">
            <xsl:for-each select="f:mapping">
               <map>
                  <xsl:apply-templates select="." mode="DataElement.Mapping"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--element 1..* ElementDefinition--><xsl:if test="f:element">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="element">
            <xsl:for-each select="f:element">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The formal description of a single piece of information that can be gathered and reported.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataElement.Contact">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:if test="f:telecom">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="telecom">
            <xsl:for-each select="f:telecom">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The formal description of a single piece of information that can be gathered and reported.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataElement.Mapping">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identity 1..1 id (json type: string)--><xsl:if test="f:identity">
         <xsl:if test="f:identity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="identity">
               <xsl:value-of select="f:identity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:identity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_identity">
               <xsl:apply-templates select="f:identity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--uri 0..1 uri (json type: string)--><xsl:if test="f:uri">
         <xsl:if test="f:uri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uri">
               <xsl:value-of select="f:uri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uri">
               <xsl:apply-templates select="f:uri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comments 0..1 string (json type: string)--><xsl:if test="f:comments">
         <xsl:if test="f:comments/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comments">
               <xsl:value-of select="f:comments/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comments[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comments">
               <xsl:apply-templates select="f:comments" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the degree of precision of the data element definition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataElementStringency">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssue">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DetectedIssue</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--severity 0..1 DetectedIssueSeverity (json type: string)--><xsl:if test="f:severity">
         <xsl:if test="f:severity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity">
               <xsl:value-of select="f:severity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:severity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_severity">
               <xsl:apply-templates select="f:severity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--implicated 0..* Reference--><xsl:if test="f:implicated">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="implicated">
            <xsl:for-each select="f:implicated">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--detail 0..1 string (json type: string)--><xsl:if test="f:detail">
         <xsl:if test="f:detail/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
               <xsl:value-of select="f:detail/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:detail[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_detail">
               <xsl:apply-templates select="f:detail" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--reference 0..1 uri (json type: string)--><xsl:if test="f:reference">
         <xsl:if test="f:reference/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
               <xsl:value-of select="f:reference/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:reference[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reference">
               <xsl:apply-templates select="f:reference" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--mitigation 0..* DetectedIssue.Mitigation--><xsl:if test="f:mitigation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mitigation">
            <xsl:for-each select="f:mitigation">
               <map>
                  <xsl:apply-templates select="." mode="DetectedIssue.Mitigation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssue.Mitigation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--action 1..1 CodeableConcept--><xsl:if test="f:action">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:apply-templates select="f:action" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the potential degree of impact of the identified issue on the patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssueSeverity">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource identifies an instance of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.  Medical devices includes durable (reusable) medical equipment, implantable devices, as well as disposable equipment used for diagnostic, treatment, and research for healthcare and public health.  Non-medical devices may include items such as a machine, cellphone, computer, application, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Device">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Device</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 0..1 DeviceStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--manufacturer 0..1 string (json type: string)--><xsl:if test="f:manufacturer">
         <xsl:if test="f:manufacturer/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="manufacturer">
               <xsl:value-of select="f:manufacturer/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:manufacturer[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_manufacturer">
               <xsl:apply-templates select="f:manufacturer" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--model 0..1 string (json type: string)--><xsl:if test="f:model">
         <xsl:if test="f:model/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="model">
               <xsl:value-of select="f:model/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:model[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_model">
               <xsl:apply-templates select="f:model" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--manufactureDate 0..1 dateTime (json type: string)--><xsl:if test="f:manufactureDate">
         <xsl:if test="f:manufactureDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="manufactureDate">
               <xsl:value-of select="f:manufactureDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:manufactureDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_manufactureDate">
               <xsl:apply-templates select="f:manufactureDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--expiry 0..1 dateTime (json type: string)--><xsl:if test="f:expiry">
         <xsl:if test="f:expiry/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="expiry">
               <xsl:value-of select="f:expiry/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:expiry[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_expiry">
               <xsl:apply-templates select="f:expiry" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--udi 0..1 string (json type: string)--><xsl:if test="f:udi">
         <xsl:if test="f:udi/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="udi">
               <xsl:value-of select="f:udi/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:udi[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_udi">
               <xsl:apply-templates select="f:udi" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--lotNumber 0..1 string (json type: string)--><xsl:if test="f:lotNumber">
         <xsl:if test="f:lotNumber/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lotNumber">
               <xsl:value-of select="f:lotNumber/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lotNumber[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lotNumber">
               <xsl:apply-templates select="f:lotNumber" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--owner 0..1 Reference--><xsl:if test="f:owner">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="owner">
            <xsl:apply-templates select="f:owner" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--contact 0..* ContactPoint--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The availability status of the device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the characteristics, operational status and capabilities of a medical-related component of a medical device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceComponent">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DeviceComponent</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--identifier 1..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--lastSystemChange 1..1 instant (json type: string)--><xsl:if test="f:lastSystemChange">
         <xsl:if test="f:lastSystemChange/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastSystemChange">
               <xsl:value-of select="f:lastSystemChange/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastSystemChange[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastSystemChange">
               <xsl:apply-templates select="f:lastSystemChange" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--source 0..1 Reference--><xsl:if test="f:source">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="source">
            <xsl:apply-templates select="f:source" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--parent 0..1 Reference--><xsl:if test="f:parent">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="parent">
            <xsl:apply-templates select="f:parent" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--operationalStatus 0..* CodeableConcept--><xsl:if test="f:operationalStatus">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="operationalStatus">
            <xsl:for-each select="f:operationalStatus">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--parameterGroup 0..1 CodeableConcept--><xsl:if test="f:parameterGroup">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="parameterGroup">
            <xsl:apply-templates select="f:parameterGroup" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--measurementPrinciple 0..1 Measmnt-Principle (json type: string)--><xsl:if test="f:measurementPrinciple">
         <xsl:if test="f:measurementPrinciple/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="measurementPrinciple">
               <xsl:value-of select="f:measurementPrinciple/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:measurementPrinciple[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_measurementPrinciple">
               <xsl:apply-templates select="f:measurementPrinciple" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--productionSpecification 0..* DeviceComponent.ProductionSpecification--><xsl:if test="f:productionSpecification">
         <array xmlns="http://www.w3.org/2005/xpath-functions"
                key="productionSpecification">
            <xsl:for-each select="f:productionSpecification">
               <map>
                  <xsl:apply-templates select="." mode="DeviceComponent.ProductionSpecification"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--languageCode 0..1 CodeableConcept--><xsl:if test="f:languageCode">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="languageCode">
            <xsl:apply-templates select="f:languageCode" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the characteristics, operational status and capabilities of a medical-related component of a medical device.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceComponent.ProductionSpecification">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--specType 0..1 CodeableConcept--><xsl:if test="f:specType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="specType">
            <xsl:apply-templates select="f:specType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--componentId 0..1 Identifier--><xsl:if test="f:componentId">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="componentId">
            <xsl:apply-templates select="f:componentId" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--productionSpec 0..1 string (json type: string)--><xsl:if test="f:productionSpec">
         <xsl:if test="f:productionSpec/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="productionSpec">
               <xsl:value-of select="f:productionSpec/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:productionSpec[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_productionSpec">
               <xsl:apply-templates select="f:productionSpec" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Different measurement principle supported by the device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Measmnt-Principle">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a measurement, calculation or setting capability of a medical device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetric">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DeviceMetric</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--identifier 1..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--unit 0..1 CodeableConcept--><xsl:if test="f:unit">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
            <xsl:apply-templates select="f:unit" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--source 0..1 Reference--><xsl:if test="f:source">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="source">
            <xsl:apply-templates select="f:source" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--parent 0..1 Reference--><xsl:if test="f:parent">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="parent">
            <xsl:apply-templates select="f:parent" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--operationalStatus 0..1 DeviceMetricOperationalStatus (json type: string)--><xsl:if test="f:operationalStatus">
         <xsl:if test="f:operationalStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="operationalStatus">
               <xsl:value-of select="f:operationalStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:operationalStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_operationalStatus">
               <xsl:apply-templates select="f:operationalStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--color 0..1 DeviceMetricColor (json type: string)--><xsl:if test="f:color">
         <xsl:if test="f:color/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="color">
               <xsl:value-of select="f:color/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:color[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_color">
               <xsl:apply-templates select="f:color" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--category 1..1 DeviceMetricCategory (json type: string)--><xsl:if test="f:category">
         <xsl:if test="f:category/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="category">
               <xsl:value-of select="f:category/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:category[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_category">
               <xsl:apply-templates select="f:category" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--measurementPeriod 0..1 Timing--><xsl:if test="f:measurementPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="measurementPeriod">
            <xsl:apply-templates select="f:measurementPeriod" mode="Timing"/>
         </map>
      </xsl:if>
                    <!--calibration 0..* DeviceMetric.Calibration--><xsl:if test="f:calibration">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="calibration">
            <xsl:for-each select="f:calibration">
               <map>
                  <xsl:apply-templates select="." mode="DeviceMetric.Calibration"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a measurement, calculation or setting capability of a medical device.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetric.Calibration">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..1 DeviceMetricCalibrationType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--state 0..1 DeviceMetricCalibrationState (json type: string)--><xsl:if test="f:state">
         <xsl:if test="f:state/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="state">
               <xsl:value-of select="f:state/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:state[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_state">
               <xsl:apply-templates select="f:state" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--time 0..1 instant (json type: string)--><xsl:if test="f:time">
         <xsl:if test="f:time/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="time">
               <xsl:value-of select="f:time/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:time[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_time">
               <xsl:apply-templates select="f:time" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the typical color of representation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricColor">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the state of a metric calibration.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCalibrationState">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the type of a metric calibration.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCalibrationType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the category of the metric.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCategory">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the operational status of the DeviceMetric.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricOperationalStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseRequest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DeviceUseRequest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    
                        
                        <!--bodySiteCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:bodySiteCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="bodySiteCodeableConcept">
            <xsl:apply-templates select="f:bodySiteCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--bodySiteReference 1..1 Reference--><xsl:if test="f:bodySiteReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bodySiteReference">
            <xsl:apply-templates select="f:bodySiteReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--status 0..1 DeviceUseRequestStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--device 1..1 Reference--><xsl:if test="f:device">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="device">
            <xsl:apply-templates select="f:device" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--indication 0..* CodeableConcept--><xsl:if test="f:indication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="indication">
            <xsl:for-each select="f:indication">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--notes 0..* string (json type: string)--><xsl:if test="f:notes">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="notes">
            <xsl:for-each select="f:notes">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:notes[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_notes">
               <xsl:for-each select="f:notes">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--prnReason 0..* CodeableConcept--><xsl:if test="f:prnReason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="prnReason">
            <xsl:for-each select="f:prnReason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--orderedOn 0..1 dateTime (json type: string)--><xsl:if test="f:orderedOn">
         <xsl:if test="f:orderedOn/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="orderedOn">
               <xsl:value-of select="f:orderedOn/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:orderedOn[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_orderedOn">
               <xsl:apply-templates select="f:orderedOn" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--recordedOn 0..1 dateTime (json type: string)--><xsl:if test="f:recordedOn">
         <xsl:if test="f:recordedOn/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="recordedOn">
               <xsl:value-of select="f:recordedOn/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:recordedOn[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_recordedOn">
               <xsl:apply-templates select="f:recordedOn" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    
                        
                        <!--timingTiming 1..1 Timing--><xsl:if test="f:timingTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingTiming">
            <xsl:apply-templates select="f:timingTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--timingPeriod 1..1 Period--><xsl:if test="f:timingPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingPeriod">
            <xsl:apply-templates select="f:timingPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--timingDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:timingDateTime">
         <xsl:if test="f:timingDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDateTime">
               <xsl:value-of select="f:timingDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:timingDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_timingDateTime">
               <xsl:apply-templates select="f:timingDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    <!--priority 0..1 DeviceUseRequestPriority (json type: string)--><xsl:if test="f:priority">
         <xsl:if test="f:priority/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
               <xsl:value-of select="f:priority/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:priority[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_priority">
               <xsl:apply-templates select="f:priority" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes representing the status of the request.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseRequestStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes representing the priority of the request.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseRequestPriority">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseStatement">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DeviceUseStatement</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    
                        
                        <!--bodySiteCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:bodySiteCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="bodySiteCodeableConcept">
            <xsl:apply-templates select="f:bodySiteCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--bodySiteReference 1..1 Reference--><xsl:if test="f:bodySiteReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bodySiteReference">
            <xsl:apply-templates select="f:bodySiteReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--whenUsed 0..1 Period--><xsl:if test="f:whenUsed">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="whenUsed">
            <xsl:apply-templates select="f:whenUsed" mode="Period"/>
         </map>
      </xsl:if>
                    <!--device 1..1 Reference--><xsl:if test="f:device">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="device">
            <xsl:apply-templates select="f:device" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--indication 0..* CodeableConcept--><xsl:if test="f:indication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="indication">
            <xsl:for-each select="f:indication">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--notes 0..* string (json type: string)--><xsl:if test="f:notes">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="notes">
            <xsl:for-each select="f:notes">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:notes[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_notes">
               <xsl:for-each select="f:notes">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--recordedOn 0..1 dateTime (json type: string)--><xsl:if test="f:recordedOn">
         <xsl:if test="f:recordedOn/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="recordedOn">
               <xsl:value-of select="f:recordedOn/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:recordedOn[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_recordedOn">
               <xsl:apply-templates select="f:recordedOn" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    
                        
                        <!--timingTiming 1..1 Timing--><xsl:if test="f:timingTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingTiming">
            <xsl:apply-templates select="f:timingTiming" mode="Timing"/>
         </map>
      </xsl:if>
                        <!--timingPeriod 1..1 Period--><xsl:if test="f:timingPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingPeriod">
            <xsl:apply-templates select="f:timingPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--timingDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:timingDateTime">
         <xsl:if test="f:timingDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDateTime">
               <xsl:value-of select="f:timingDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:timingDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_timingDateTime">
               <xsl:apply-templates select="f:timingDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a request for a diagnostic investigation service to be performed.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrder">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DiagnosticOrder</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--orderer 0..1 Reference--><xsl:if test="f:orderer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="orderer">
            <xsl:apply-templates select="f:orderer" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--supportingInformation 0..* Reference--><xsl:if test="f:supportingInformation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="supportingInformation">
            <xsl:for-each select="f:supportingInformation">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--specimen 0..* Reference--><xsl:if test="f:specimen">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specimen">
            <xsl:for-each select="f:specimen">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 0..1 DiagnosticOrderStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--priority 0..1 DiagnosticOrderPriority (json type: string)--><xsl:if test="f:priority">
         <xsl:if test="f:priority/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
               <xsl:value-of select="f:priority/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:priority[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_priority">
               <xsl:apply-templates select="f:priority" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--event 0..* DiagnosticOrder.Event--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <map>
                  <xsl:apply-templates select="." mode="DiagnosticOrder.Event"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--item 0..* DiagnosticOrder.Item--><xsl:if test="f:item">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:for-each select="f:item">
               <map>
                  <xsl:apply-templates select="." mode="DiagnosticOrder.Item"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a request for a diagnostic investigation service to be performed.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrder.Event">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--status 1..1 DiagnosticOrderStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 CodeableConcept--><xsl:if test="f:description">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="description">
            <xsl:apply-templates select="f:description" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--dateTime 1..1 dateTime (json type: string)--><xsl:if test="f:dateTime">
         <xsl:if test="f:dateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateTime">
               <xsl:value-of select="f:dateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:dateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dateTime">
               <xsl:apply-templates select="f:dateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--actor 0..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a request for a diagnostic investigation service to be performed.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrder.Item">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--specimen 0..* Reference--><xsl:if test="f:specimen">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specimen">
            <xsl:for-each select="f:specimen">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--bodySite 0..1 CodeableConcept--><xsl:if test="f:bodySite">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bodySite">
            <xsl:apply-templates select="f:bodySite" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--status 0..1 DiagnosticOrderStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--event 0..* DiagnosticOrder.Event--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <map>
                  <xsl:apply-templates select="." mode="DiagnosticOrder.Event"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of a diagnostic order.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrderStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The clinical priority of a diagnostic order.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticOrderPriority">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReport">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DiagnosticReport</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 1..1 DiagnosticReportStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    
                        
                        <!--effectiveDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:effectiveDateTime">
         <xsl:if test="f:effectiveDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveDateTime">
               <xsl:value-of select="f:effectiveDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:effectiveDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_effectiveDateTime">
               <xsl:apply-templates select="f:effectiveDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--effectivePeriod 1..1 Period--><xsl:if test="f:effectivePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="effectivePeriod">
            <xsl:apply-templates select="f:effectivePeriod" mode="Period"/>
         </map>
      </xsl:if>
                    
                    <!--issued 1..1 instant (json type: string)--><xsl:if test="f:issued">
         <xsl:if test="f:issued/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued">
               <xsl:value-of select="f:issued/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:issued[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_issued">
               <xsl:apply-templates select="f:issued" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--performer 1..1 Reference--><xsl:if test="f:performer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="performer">
            <xsl:apply-templates select="f:performer" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--request 0..* Reference--><xsl:if test="f:request">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:for-each select="f:request">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--specimen 0..* Reference--><xsl:if test="f:specimen">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specimen">
            <xsl:for-each select="f:specimen">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--result 0..* Reference--><xsl:if test="f:result">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="result">
            <xsl:for-each select="f:result">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--imagingStudy 0..* Reference--><xsl:if test="f:imagingStudy">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="imagingStudy">
            <xsl:for-each select="f:imagingStudy">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--image 0..* DiagnosticReport.Image--><xsl:if test="f:image">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="image">
            <xsl:for-each select="f:image">
               <map>
                  <xsl:apply-templates select="." mode="DiagnosticReport.Image"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--conclusion 0..1 string (json type: string)--><xsl:if test="f:conclusion">
         <xsl:if test="f:conclusion/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="conclusion">
               <xsl:value-of select="f:conclusion/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:conclusion[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conclusion">
               <xsl:apply-templates select="f:conclusion" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--codedDiagnosis 0..* CodeableConcept--><xsl:if test="f:codedDiagnosis">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="codedDiagnosis">
            <xsl:for-each select="f:codedDiagnosis">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--presentedForm 0..* Attachment--><xsl:if test="f:presentedForm">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="presentedForm">
            <xsl:for-each select="f:presentedForm">
               <map>
                  <xsl:apply-templates select="." mode="Attachment"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReport.Image">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--link 1..1 Reference--><xsl:if test="f:link">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="link">
            <xsl:apply-templates select="f:link" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the diagnostic report as a whole.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReportStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest that defines a set of documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DocumentManifest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--masterIdentifier 0..1 Identifier--><xsl:if test="f:masterIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="masterIdentifier">
            <xsl:apply-templates select="f:masterIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--recipient 0..* Reference--><xsl:if test="f:recipient">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="recipient">
            <xsl:for-each select="f:recipient">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--author 0..* Reference--><xsl:if test="f:author">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:for-each select="f:author">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--source 0..1 uri (json type: string)--><xsl:if test="f:source">
         <xsl:if test="f:source/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="source">
               <xsl:value-of select="f:source/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:source[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_source">
               <xsl:apply-templates select="f:source" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 code (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--content 1..* DocumentManifest.Content--><xsl:if test="f:content">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="content">
            <xsl:for-each select="f:content">
               <map>
                  <xsl:apply-templates select="." mode="DocumentManifest.Content"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--related 0..* DocumentManifest.Related--><xsl:if test="f:related">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="related">
            <xsl:for-each select="f:related">
               <map>
                  <xsl:apply-templates select="." mode="DocumentManifest.Related"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest that defines a set of documents.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest.Content">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--pAttachment 1..1 Attachment--><xsl:if test="f:pAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="pAttachment">
            <xsl:apply-templates select="f:pAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
                        <!--pReference 1..1 Reference--><xsl:if test="f:pReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="pReference">
            <xsl:apply-templates select="f:pReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest that defines a set of documents.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest.Related">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--ref 0..1 Reference--><xsl:if test="f:ref">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ref">
            <xsl:apply-templates select="f:ref" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DocumentReference</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--masterIdentifier 0..1 Identifier--><xsl:if test="f:masterIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="masterIdentifier">
            <xsl:apply-templates select="f:masterIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--class 0..1 CodeableConcept--><xsl:if test="f:class">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="class">
            <xsl:apply-templates select="f:class" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--author 0..* Reference--><xsl:if test="f:author">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:for-each select="f:author">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--custodian 0..1 Reference--><xsl:if test="f:custodian">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="custodian">
            <xsl:apply-templates select="f:custodian" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--authenticator 0..1 Reference--><xsl:if test="f:authenticator">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="authenticator">
            <xsl:apply-templates select="f:authenticator" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--indexed 1..1 instant (json type: string)--><xsl:if test="f:indexed">
         <xsl:if test="f:indexed/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="indexed">
               <xsl:value-of select="f:indexed/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:indexed[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_indexed">
               <xsl:apply-templates select="f:indexed" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 code (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--docStatus 0..1 CodeableConcept--><xsl:if test="f:docStatus">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="docStatus">
            <xsl:apply-templates select="f:docStatus" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--relatesTo 0..* DocumentReference.RelatesTo--><xsl:if test="f:relatesTo">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="relatesTo">
            <xsl:for-each select="f:relatesTo">
               <map>
                  <xsl:apply-templates select="." mode="DocumentReference.RelatesTo"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--securityLabel 0..* CodeableConcept--><xsl:if test="f:securityLabel">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="securityLabel">
            <xsl:for-each select="f:securityLabel">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--content 1..* DocumentReference.Content--><xsl:if test="f:content">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="content">
            <xsl:for-each select="f:content">
               <map>
                  <xsl:apply-templates select="." mode="DocumentReference.Content"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--context 0..1 DocumentReference.Context--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="DocumentReference.Context"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.RelatesTo">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 DocumentRelationshipType (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--target 1..1 Reference--><xsl:if test="f:target">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="target">
            <xsl:apply-templates select="f:target" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Content">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--attachment 1..1 Attachment--><xsl:if test="f:attachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="attachment">
            <xsl:apply-templates select="f:attachment" mode="Attachment"/>
         </map>
      </xsl:if>
                    <!--format 0..* Coding--><xsl:if test="f:format">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="format">
            <xsl:for-each select="f:format">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Context">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--event 0..* CodeableConcept--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--facilityType 0..1 CodeableConcept--><xsl:if test="f:facilityType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="facilityType">
            <xsl:apply-templates select="f:facilityType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--practiceSetting 0..1 CodeableConcept--><xsl:if test="f:practiceSetting">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="practiceSetting">
            <xsl:apply-templates select="f:practiceSetting" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--sourcePatientInfo 0..1 Reference--><xsl:if test="f:sourcePatientInfo">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sourcePatientInfo">
            <xsl:apply-templates select="f:sourcePatientInfo" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--related 0..* DocumentReference.Related--><xsl:if test="f:related">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="related">
            <xsl:for-each select="f:related">
               <map>
                  <xsl:apply-templates select="." mode="DocumentReference.Related"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document .</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Related">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--ref 0..1 Reference--><xsl:if test="f:ref">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ref">
            <xsl:apply-templates select="f:ref" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of relationship between documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentRelationshipType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the insurance eligibility details from the insurer regarding a specified coverage and optionally some class of service.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityRequest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EligibilityRequest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--ruleset 0..1 Coding--><xsl:if test="f:ruleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ruleset">
            <xsl:apply-templates select="f:ruleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--target 0..1 Reference--><xsl:if test="f:target">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="target">
            <xsl:apply-templates select="f:target" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides eligibility and plan details from the processing of an Eligibility resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityResponse">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EligibilityResponse</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--request 0..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--outcome 0..1 code (json type: string)--><xsl:if test="f:outcome">
         <xsl:if test="f:outcome/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
               <xsl:value-of select="f:outcome/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:outcome[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_outcome">
               <xsl:apply-templates select="f:outcome" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--disposition 0..1 string (json type: string)--><xsl:if test="f:disposition">
         <xsl:if test="f:disposition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition">
               <xsl:value-of select="f:disposition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:disposition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_disposition">
               <xsl:apply-templates select="f:disposition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--ruleset 0..1 Coding--><xsl:if test="f:ruleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ruleset">
            <xsl:apply-templates select="f:ruleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestProvider 0..1 Reference--><xsl:if test="f:requestProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestProvider">
            <xsl:apply-templates select="f:requestProvider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestOrganization 0..1 Reference--><xsl:if test="f:requestOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestOrganization">
            <xsl:apply-templates select="f:requestOrganization" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Encounter</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 1..1 EncounterState (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--statusHistory 0..* Encounter.StatusHistory--><xsl:if test="f:statusHistory">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="statusHistory">
            <xsl:for-each select="f:statusHistory">
               <map>
                  <xsl:apply-templates select="." mode="Encounter.StatusHistory"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--class 0..1 EncounterClass (json type: string)--><xsl:if test="f:class">
         <xsl:if test="f:class/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="class">
               <xsl:value-of select="f:class/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:class[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_class">
               <xsl:apply-templates select="f:class" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--priority 0..1 CodeableConcept--><xsl:if test="f:priority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
            <xsl:apply-templates select="f:priority" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--episodeOfCare 0..* Reference--><xsl:if test="f:episodeOfCare">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="episodeOfCare">
            <xsl:for-each select="f:episodeOfCare">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--incomingReferral 0..* Reference--><xsl:if test="f:incomingReferral">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="incomingReferral">
            <xsl:for-each select="f:incomingReferral">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--participant 0..* Encounter.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="Encounter.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--appointment 0..1 Reference--><xsl:if test="f:appointment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="appointment">
            <xsl:apply-templates select="f:appointment" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--length 0..1 Duration--><xsl:if test="f:length">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="length">
            <xsl:apply-templates select="f:length" mode="Duration"/>
         </map>
      </xsl:if>
                    <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--indication 0..* Reference--><xsl:if test="f:indication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="indication">
            <xsl:for-each select="f:indication">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--hospitalization 0..1 Encounter.Hospitalization--><xsl:if test="f:hospitalization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="hospitalization">
            <xsl:apply-templates select="f:hospitalization" mode="Encounter.Hospitalization"/>
         </map>
      </xsl:if>
                    <!--location 0..* Encounter.Location--><xsl:if test="f:location">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:for-each select="f:location">
               <map>
                  <xsl:apply-templates select="." mode="Encounter.Location"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--serviceProvider 0..1 Reference--><xsl:if test="f:serviceProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="serviceProvider">
            <xsl:apply-templates select="f:serviceProvider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--partOf 0..1 Reference--><xsl:if test="f:partOf">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="partOf">
            <xsl:apply-templates select="f:partOf" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.StatusHistory">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--status 1..1 EncounterState (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 1..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--individual 0..1 Reference--><xsl:if test="f:individual">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="individual">
            <xsl:apply-templates select="f:individual" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.Hospitalization">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--preAdmissionIdentifier 0..1 Identifier--><xsl:if test="f:preAdmissionIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="preAdmissionIdentifier">
            <xsl:apply-templates select="f:preAdmissionIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--origin 0..1 Reference--><xsl:if test="f:origin">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="origin">
            <xsl:apply-templates select="f:origin" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--admitSource 0..1 CodeableConcept--><xsl:if test="f:admitSource">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="admitSource">
            <xsl:apply-templates select="f:admitSource" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--admittingDiagnosis 0..* Reference--><xsl:if test="f:admittingDiagnosis">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="admittingDiagnosis">
            <xsl:for-each select="f:admittingDiagnosis">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--reAdmission 0..1 CodeableConcept--><xsl:if test="f:reAdmission">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reAdmission">
            <xsl:apply-templates select="f:reAdmission" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--dietPreference 0..* CodeableConcept--><xsl:if test="f:dietPreference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dietPreference">
            <xsl:for-each select="f:dietPreference">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--specialCourtesy 0..* CodeableConcept--><xsl:if test="f:specialCourtesy">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specialCourtesy">
            <xsl:for-each select="f:specialCourtesy">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--specialArrangement 0..* CodeableConcept--><xsl:if test="f:specialArrangement">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specialArrangement">
            <xsl:for-each select="f:specialArrangement">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--destination 0..1 Reference--><xsl:if test="f:destination">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="destination">
            <xsl:apply-templates select="f:destination" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--dischargeDisposition 0..1 CodeableConcept--><xsl:if test="f:dischargeDisposition">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dischargeDisposition">
            <xsl:apply-templates select="f:dischargeDisposition" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--dischargeDiagnosis 0..* Reference--><xsl:if test="f:dischargeDiagnosis">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dischargeDiagnosis">
            <xsl:for-each select="f:dischargeDiagnosis">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.Location">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--location 1..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--status 0..1 EncounterLocationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the location.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EncounterLocationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Classification of the encounter</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EncounterClass">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Current state of the encounter</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EncounterState">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the insurance enrollment details to the insurer regarding a specified coverage.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EnrollmentRequest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EnrollmentRequest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--ruleset 0..1 Coding--><xsl:if test="f:ruleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ruleset">
            <xsl:apply-templates select="f:ruleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--target 0..1 Reference--><xsl:if test="f:target">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="target">
            <xsl:apply-templates select="f:target" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--coverage 1..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--relationship 1..1 Coding--><xsl:if test="f:relationship">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="relationship">
            <xsl:apply-templates select="f:relationship" mode="Coding"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides enrollment and plan details from the processing of an Enrollment resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EnrollmentResponse">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EnrollmentResponse</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--request 0..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--outcome 0..1 code (json type: string)--><xsl:if test="f:outcome">
         <xsl:if test="f:outcome/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
               <xsl:value-of select="f:outcome/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:outcome[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_outcome">
               <xsl:apply-templates select="f:outcome" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--disposition 0..1 string (json type: string)--><xsl:if test="f:disposition">
         <xsl:if test="f:disposition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition">
               <xsl:value-of select="f:disposition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:disposition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_disposition">
               <xsl:apply-templates select="f:disposition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--ruleset 0..1 Coding--><xsl:if test="f:ruleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ruleset">
            <xsl:apply-templates select="f:ruleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestProvider 0..1 Reference--><xsl:if test="f:requestProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestProvider">
            <xsl:apply-templates select="f:requestProvider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestOrganization 0..1 Reference--><xsl:if test="f:requestOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestOrganization">
            <xsl:apply-templates select="f:requestOrganization" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EpisodeOfCare">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EpisodeOfCare</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 1..1 EpisodeOfCareStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--statusHistory 0..* EpisodeOfCare.StatusHistory--><xsl:if test="f:statusHistory">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="statusHistory">
            <xsl:for-each select="f:statusHistory">
               <map>
                  <xsl:apply-templates select="." mode="EpisodeOfCare.StatusHistory"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--condition 0..* Reference--><xsl:if test="f:condition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="condition">
            <xsl:for-each select="f:condition">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--managingOrganization 0..1 Reference--><xsl:if test="f:managingOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="managingOrganization">
            <xsl:apply-templates select="f:managingOrganization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--referralRequest 0..* Reference--><xsl:if test="f:referralRequest">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="referralRequest">
            <xsl:for-each select="f:referralRequest">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--careManager 0..1 Reference--><xsl:if test="f:careManager">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="careManager">
            <xsl:apply-templates select="f:careManager" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--careTeam 0..* EpisodeOfCare.CareTeam--><xsl:if test="f:careTeam">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="careTeam">
            <xsl:for-each select="f:careTeam">
               <map>
                  <xsl:apply-templates select="." mode="EpisodeOfCare.CareTeam"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EpisodeOfCare.StatusHistory">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--status 1..1 EpisodeOfCareStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 1..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EpisodeOfCare.CareTeam">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--role 0..* CodeableConcept--><xsl:if test="f:role">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:for-each select="f:role">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--member 0..1 Reference--><xsl:if test="f:member">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="member">
            <xsl:apply-templates select="f:member" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the encounter.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EpisodeOfCareStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides: the claim details; adjudication details from the processing of a Claim; and optionally account balance information, for informing the subscriber of the benefits provided.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExplanationOfBenefit">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ExplanationOfBenefit</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--request 0..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--outcome 0..1 code (json type: string)--><xsl:if test="f:outcome">
         <xsl:if test="f:outcome/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
               <xsl:value-of select="f:outcome/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:outcome[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_outcome">
               <xsl:apply-templates select="f:outcome" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--disposition 0..1 string (json type: string)--><xsl:if test="f:disposition">
         <xsl:if test="f:disposition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition">
               <xsl:value-of select="f:disposition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:disposition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_disposition">
               <xsl:apply-templates select="f:disposition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--ruleset 0..1 Coding--><xsl:if test="f:ruleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ruleset">
            <xsl:apply-templates select="f:ruleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--originalRuleset 0..1 Coding--><xsl:if test="f:originalRuleset">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalRuleset">
            <xsl:apply-templates select="f:originalRuleset" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestProvider 0..1 Reference--><xsl:if test="f:requestProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestProvider">
            <xsl:apply-templates select="f:requestProvider" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requestOrganization 0..1 Reference--><xsl:if test="f:requestOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestOrganization">
            <xsl:apply-templates select="f:requestOrganization" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Significant health events and conditions for a person related to the patient relevant in the context of care for the patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="FamilyMemberHistory">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">FamilyMemberHistory</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 FamilyHistoryStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--relationship 1..1 CodeableConcept--><xsl:if test="f:relationship">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="relationship">
            <xsl:apply-templates select="f:relationship" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--gender 0..1 code (json type: string)--><xsl:if test="f:gender">
         <xsl:if test="f:gender/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="gender">
               <xsl:value-of select="f:gender/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:gender[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_gender">
               <xsl:apply-templates select="f:gender" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--bornPeriod 1..1 Period--><xsl:if test="f:bornPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bornPeriod">
            <xsl:apply-templates select="f:bornPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--bornDate 1..1 date (json type: string)--><xsl:if test="f:bornDate">
         <xsl:if test="f:bornDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="bornDate">
               <xsl:value-of select="f:bornDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:bornDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_bornDate">
               <xsl:apply-templates select="f:bornDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--bornString 1..1 string (json type: string)--><xsl:if test="f:bornString">
         <xsl:if test="f:bornString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="bornString">
               <xsl:value-of select="f:bornString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:bornString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_bornString">
               <xsl:apply-templates select="f:bornString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    
                        
                        <!--ageQuantity 1..1 Age--><xsl:if test="f:ageQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ageQuantity">
            <xsl:apply-templates select="f:ageQuantity" mode="Age"/>
         </map>
      </xsl:if>
                        <!--ageRange 1..1 Range--><xsl:if test="f:ageRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ageRange">
            <xsl:apply-templates select="f:ageRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--ageString 1..1 string (json type: string)--><xsl:if test="f:ageString">
         <xsl:if test="f:ageString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ageString">
               <xsl:value-of select="f:ageString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ageString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ageString">
               <xsl:apply-templates select="f:ageString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    
                        
                        <!--deceasedBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:deceasedBoolean">
         <xsl:if test="f:deceasedBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="deceasedBoolean">
               <xsl:value-of select="f:deceasedBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:deceasedBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_deceasedBoolean">
               <xsl:apply-templates select="f:deceasedBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--deceasedQuantity 1..1 Age--><xsl:if test="f:deceasedQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="deceasedQuantity">
            <xsl:apply-templates select="f:deceasedQuantity" mode="Age"/>
         </map>
      </xsl:if>
                        <!--deceasedRange 1..1 Range--><xsl:if test="f:deceasedRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="deceasedRange">
            <xsl:apply-templates select="f:deceasedRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--deceasedDate 1..1 date (json type: string)--><xsl:if test="f:deceasedDate">
         <xsl:if test="f:deceasedDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="deceasedDate">
               <xsl:value-of select="f:deceasedDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:deceasedDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_deceasedDate">
               <xsl:apply-templates select="f:deceasedDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--deceasedString 1..1 string (json type: string)--><xsl:if test="f:deceasedString">
         <xsl:if test="f:deceasedString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="deceasedString">
               <xsl:value-of select="f:deceasedString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:deceasedString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_deceasedString">
               <xsl:apply-templates select="f:deceasedString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    <!--note 0..1 Annotation--><xsl:if test="f:note">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:apply-templates select="f:note" mode="Annotation"/>
         </map>
      </xsl:if>
                    <!--condition 0..* FamilyMemberHistory.Condition--><xsl:if test="f:condition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="condition">
            <xsl:for-each select="f:condition">
               <map>
                  <xsl:apply-templates select="." mode="FamilyMemberHistory.Condition"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Significant health events and conditions for a person related to the patient relevant in the context of care for the patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="FamilyMemberHistory.Condition">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--outcome 0..1 CodeableConcept--><xsl:if test="f:outcome">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
            <xsl:apply-templates select="f:outcome" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    
                        
                        <!--onsetQuantity 1..1 Age--><xsl:if test="f:onsetQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetQuantity">
            <xsl:apply-templates select="f:onsetQuantity" mode="Age"/>
         </map>
      </xsl:if>
                        <!--onsetRange 1..1 Range--><xsl:if test="f:onsetRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetRange">
            <xsl:apply-templates select="f:onsetRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--onsetPeriod 1..1 Period--><xsl:if test="f:onsetPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetPeriod">
            <xsl:apply-templates select="f:onsetPeriod" mode="Period"/>
         </map>
      </xsl:if>
                        <!--onsetString 1..1 string (json type: string)--><xsl:if test="f:onsetString">
         <xsl:if test="f:onsetString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetString">
               <xsl:value-of select="f:onsetString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onsetString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onsetString">
               <xsl:apply-templates select="f:onsetString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                    <!--note 0..1 Annotation--><xsl:if test="f:note">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:apply-templates select="f:note" mode="Annotation"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that identifies the status of the family history record.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="FamilyHistoryStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Prospective warnings of potential issues when providing care to the patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Flag">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Flag</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--status 1..1 FlagStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether this flag is active and needs to be displayed to a user, or whether it is no longer needed or entered in error.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="FlagStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intended objective(s) for a patient, group or organization care, for example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Goal">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Goal</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    
                        
                        <!--startDate 1..1 date (json type: string)--><xsl:if test="f:startDate">
         <xsl:if test="f:startDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="startDate">
               <xsl:value-of select="f:startDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:startDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_startDate">
               <xsl:apply-templates select="f:startDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--startCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:startCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="startCodeableConcept">
            <xsl:apply-templates select="f:startCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--targetDate 1..1 date (json type: string)--><xsl:if test="f:targetDate">
         <xsl:if test="f:targetDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetDate">
               <xsl:value-of select="f:targetDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:targetDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_targetDate">
               <xsl:apply-templates select="f:targetDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--targetQuantity 1..1 Duration--><xsl:if test="f:targetQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="targetQuantity">
            <xsl:apply-templates select="f:targetQuantity" mode="Duration"/>
         </map>
      </xsl:if>
                    
                    <!--category 0..* CodeableConcept--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--description 1..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 GoalStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--statusDate 0..1 date (json type: string)--><xsl:if test="f:statusDate">
         <xsl:if test="f:statusDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="statusDate">
               <xsl:value-of select="f:statusDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:statusDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_statusDate">
               <xsl:apply-templates select="f:statusDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--statusReason 0..1 CodeableConcept--><xsl:if test="f:statusReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="statusReason">
            <xsl:apply-templates select="f:statusReason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--priority 0..1 CodeableConcept--><xsl:if test="f:priority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
            <xsl:apply-templates select="f:priority" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--addresses 0..* Reference--><xsl:if test="f:addresses">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="addresses">
            <xsl:for-each select="f:addresses">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--outcome 0..* Goal.Outcome--><xsl:if test="f:outcome">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
            <xsl:for-each select="f:outcome">
               <map>
                  <xsl:apply-templates select="." mode="Goal.Outcome"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intended objective(s) for a patient, group or organization care, for example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Goal.Outcome">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--resultCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:resultCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="resultCodeableConcept">
            <xsl:apply-templates select="f:resultCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--resultReference 1..1 Reference--><xsl:if test="f:resultReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="resultReference">
            <xsl:apply-templates select="f:resultReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the goal has been met and is still being targeted</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="GoalStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Represents a defined collection of entities that may be discussed or acted upon collectively but which are not expected to act collectively and are not formally or legally recognized; i.e. a collection of entities that isn't an Organization.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Group">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Group</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--type 1..1 GroupType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--actual 1..1 boolean (json type: boolean)--><xsl:if test="f:actual">
         <xsl:if test="f:actual/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="actual">
               <xsl:value-of select="f:actual/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:actual[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_actual">
               <xsl:apply-templates select="f:actual" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--quantity 0..1 unsignedInt (json type: number)--><xsl:if test="f:quantity">
         <xsl:if test="f:quantity/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
               <xsl:value-of select="f:quantity/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:quantity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_quantity">
               <xsl:apply-templates select="f:quantity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--characteristic 0..* Group.Characteristic--><xsl:if test="f:characteristic">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="characteristic">
            <xsl:for-each select="f:characteristic">
               <map>
                  <xsl:apply-templates select="." mode="Group.Characteristic"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--member 0..* Group.Member--><xsl:if test="f:member">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="member">
            <xsl:for-each select="f:member">
               <map>
                  <xsl:apply-templates select="." mode="Group.Member"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Represents a defined collection of entities that may be discussed or acted upon collectively but which are not expected to act collectively and are not formally or legally recognized; i.e. a collection of entities that isn't an Organization.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Group.Characteristic">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    
                        
                        <!--valueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:valueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCodeableConcept">
            <xsl:apply-templates select="f:valueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--valueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:valueBoolean">
         <xsl:if test="f:valueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean">
               <xsl:value-of select="f:valueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:valueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueBoolean">
               <xsl:apply-templates select="f:valueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--valueQuantity 1..1 Quantity--><xsl:if test="f:valueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueQuantity">
            <xsl:apply-templates select="f:valueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
                        <!--valueRange 1..1 Range--><xsl:if test="f:valueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueRange">
            <xsl:apply-templates select="f:valueRange" mode="Range"/>
         </map>
      </xsl:if>
                    
                    <!--exclude 1..1 boolean (json type: boolean)--><xsl:if test="f:exclude">
         <xsl:if test="f:exclude/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="exclude">
               <xsl:value-of select="f:exclude/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:exclude[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_exclude">
               <xsl:apply-templates select="f:exclude" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Represents a defined collection of entities that may be discussed or acted upon collectively but which are not expected to act collectively and are not formally or legally recognized; i.e. a collection of entities that isn't an Organization.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Group.Member">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--entity 1..1 Reference--><xsl:if test="f:entity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entity">
            <xsl:apply-templates select="f:entity" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
                    <!--inactive 0..1 boolean (json type: boolean)--><xsl:if test="f:inactive">
         <xsl:if test="f:inactive/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="inactive">
               <xsl:value-of select="f:inactive/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:inactive[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_inactive">
               <xsl:apply-templates select="f:inactive" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Types of resources that are part of group</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="GroupType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The details of a healthcare service available at a location.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="HealthcareService">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">HealthcareService</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--providedBy 0..1 Reference--><xsl:if test="f:providedBy">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="providedBy">
            <xsl:apply-templates select="f:providedBy" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--serviceCategory 0..1 CodeableConcept--><xsl:if test="f:serviceCategory">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="serviceCategory">
            <xsl:apply-templates select="f:serviceCategory" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--serviceType 0..* HealthcareService.ServiceType--><xsl:if test="f:serviceType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="serviceType">
            <xsl:for-each select="f:serviceType">
               <map>
                  <xsl:apply-templates select="." mode="HealthcareService.ServiceType"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--location 1..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--serviceName 0..1 string (json type: string)--><xsl:if test="f:serviceName">
         <xsl:if test="f:serviceName/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="serviceName">
               <xsl:value-of select="f:serviceName/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:serviceName[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_serviceName">
               <xsl:apply-templates select="f:serviceName" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--extraDetails 0..1 string (json type: string)--><xsl:if test="f:extraDetails">
         <xsl:if test="f:extraDetails/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="extraDetails">
               <xsl:value-of select="f:extraDetails/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:extraDetails[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_extraDetails">
               <xsl:apply-templates select="f:extraDetails" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--photo 0..1 Attachment--><xsl:if test="f:photo">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="photo">
            <xsl:apply-templates select="f:photo" mode="Attachment"/>
         </map>
      </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:if test="f:telecom">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="telecom">
            <xsl:for-each select="f:telecom">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--coverageArea 0..* Reference--><xsl:if test="f:coverageArea">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="coverageArea">
            <xsl:for-each select="f:coverageArea">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--serviceProvisionCode 0..* CodeableConcept--><xsl:if test="f:serviceProvisionCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="serviceProvisionCode">
            <xsl:for-each select="f:serviceProvisionCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--eligibility 0..1 CodeableConcept--><xsl:if test="f:eligibility">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="eligibility">
            <xsl:apply-templates select="f:eligibility" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--eligibilityNote 0..1 string (json type: string)--><xsl:if test="f:eligibilityNote">
         <xsl:if test="f:eligibilityNote/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="eligibilityNote">
               <xsl:value-of select="f:eligibilityNote/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:eligibilityNote[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_eligibilityNote">
               <xsl:apply-templates select="f:eligibilityNote" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--programName 0..* string (json type: string)--><xsl:if test="f:programName">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="programName">
            <xsl:for-each select="f:programName">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:programName[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_programName">
               <xsl:for-each select="f:programName">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--characteristic 0..* CodeableConcept--><xsl:if test="f:characteristic">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="characteristic">
            <xsl:for-each select="f:characteristic">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--referralMethod 0..* CodeableConcept--><xsl:if test="f:referralMethod">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="referralMethod">
            <xsl:for-each select="f:referralMethod">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--publicKey 0..1 string (json type: string)--><xsl:if test="f:publicKey">
         <xsl:if test="f:publicKey/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publicKey">
               <xsl:value-of select="f:publicKey/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publicKey[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publicKey">
               <xsl:apply-templates select="f:publicKey" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--appointmentRequired 0..1 boolean (json type: boolean)--><xsl:if test="f:appointmentRequired">
         <xsl:if test="f:appointmentRequired/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="appointmentRequired">
               <xsl:value-of select="f:appointmentRequired/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:appointmentRequired[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_appointmentRequired">
               <xsl:apply-templates select="f:appointmentRequired" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--availableTime 0..* HealthcareService.AvailableTime--><xsl:if test="f:availableTime">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="availableTime">
            <xsl:for-each select="f:availableTime">
               <map>
                  <xsl:apply-templates select="." mode="HealthcareService.AvailableTime"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--notAvailable 0..* HealthcareService.NotAvailable--><xsl:if test="f:notAvailable">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="notAvailable">
            <xsl:for-each select="f:notAvailable">
               <map>
                  <xsl:apply-templates select="." mode="HealthcareService.NotAvailable"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--availabilityExceptions 0..1 string (json type: string)--><xsl:if test="f:availabilityExceptions">
         <xsl:if test="f:availabilityExceptions/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="availabilityExceptions">
               <xsl:value-of select="f:availabilityExceptions/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:availabilityExceptions[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_availabilityExceptions">
               <xsl:apply-templates select="f:availabilityExceptions" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The details of a healthcare service available at a location.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="HealthcareService.ServiceType">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--specialty 0..* CodeableConcept--><xsl:if test="f:specialty">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specialty">
            <xsl:for-each select="f:specialty">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The details of a healthcare service available at a location.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="HealthcareService.AvailableTime">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--daysOfWeek 0..* DaysOfWeek (json type: string)--><xsl:if test="f:daysOfWeek">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="daysOfWeek">
            <xsl:for-each select="f:daysOfWeek">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:daysOfWeek[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_daysOfWeek">
               <xsl:for-each select="f:daysOfWeek">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--allDay 0..1 boolean (json type: boolean)--><xsl:if test="f:allDay">
         <xsl:if test="f:allDay/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="allDay">
               <xsl:value-of select="f:allDay/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:allDay[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_allDay">
               <xsl:apply-templates select="f:allDay" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--availableStartTime 0..1 time (json type: string)--><xsl:if test="f:availableStartTime">
         <xsl:if test="f:availableStartTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="availableStartTime">
               <xsl:value-of select="f:availableStartTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:availableStartTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_availableStartTime">
               <xsl:apply-templates select="f:availableStartTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--availableEndTime 0..1 time (json type: string)--><xsl:if test="f:availableEndTime">
         <xsl:if test="f:availableEndTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="availableEndTime">
               <xsl:value-of select="f:availableEndTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:availableEndTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_availableEndTime">
               <xsl:apply-templates select="f:availableEndTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The details of a healthcare service available at a location.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="HealthcareService.NotAvailable">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--description 1..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--during 0..1 Period--><xsl:if test="f:during">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="during">
            <xsl:apply-templates select="f:during" mode="Period"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The days of the week.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DaysOfWeek">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest of a set of DICOM Service-Object Pair Instances (SOP Instances).  The referenced SOP Instances (images or other content) are for a single patient, and may be from one or more studies. The referenced SOP Instances have been selected for a purpose, such as quality assurance, conference, or consult. Reflecting that range of purposes, typical ImagingObjectSelection resources may include all SOP Instances in a study (perhaps for sharing through a Health Information Exchange); key images from multiple studies (for reference by a referring or treating physician); a multi-frame ultrasound instance ("cine" video clip) and a set of measurements taken from that instance (for inclusion in a teaching file); and so on.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImagingObjectSelection">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ImagingObjectSelection</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--uid 1..1 oid (json type: string)--><xsl:if test="f:uid">
         <xsl:if test="f:uid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uid">
               <xsl:value-of select="f:uid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uid">
               <xsl:apply-templates select="f:uid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--title 1..1 CodeableConcept--><xsl:if test="f:title">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="title">
            <xsl:apply-templates select="f:title" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--authoringTime 0..1 dateTime (json type: string)--><xsl:if test="f:authoringTime">
         <xsl:if test="f:authoringTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="authoringTime">
               <xsl:value-of select="f:authoringTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:authoringTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_authoringTime">
               <xsl:apply-templates select="f:authoringTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--study 1..* ImagingObjectSelection.Study--><xsl:if test="f:study">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="study">
            <xsl:for-each select="f:study">
               <map>
                  <xsl:apply-templates select="." mode="ImagingObjectSelection.Study"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest of a set of DICOM Service-Object Pair Instances (SOP Instances).  The referenced SOP Instances (images or other content) are for a single patient, and may be from one or more studies. The referenced SOP Instances have been selected for a purpose, such as quality assurance, conference, or consult. Reflecting that range of purposes, typical ImagingObjectSelection resources may include all SOP Instances in a study (perhaps for sharing through a Health Information Exchange); key images from multiple studies (for reference by a referring or treating physician); a multi-frame ultrasound instance ("cine" video clip) and a set of measurements taken from that instance (for inclusion in a teaching file); and so on.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImagingObjectSelection.Study">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--uid 1..1 oid (json type: string)--><xsl:if test="f:uid">
         <xsl:if test="f:uid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uid">
               <xsl:value-of select="f:uid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uid">
               <xsl:apply-templates select="f:uid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--imagingStudy 0..1 Reference--><xsl:if test="f:imagingStudy">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="imagingStudy">
            <xsl:apply-templates select="f:imagingStudy" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--series 1..* ImagingObjectSelection.Series--><xsl:if test="f:series">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="series">
            <xsl:for-each select="f:series">
               <map>
                  <xsl:apply-templates select="." mode="ImagingObjectSelection.Series"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest of a set of DICOM Service-Object Pair Instances (SOP Instances).  The referenced SOP Instances (images or other content) are for a single patient, and may be from one or more studies. The referenced SOP Instances have been selected for a purpose, such as quality assurance, conference, or consult. Reflecting that range of purposes, typical ImagingObjectSelection resources may include all SOP Instances in a study (perhaps for sharing through a Health Information Exchange); key images from multiple studies (for reference by a referring or treating physician); a multi-frame ultrasound instance ("cine" video clip) and a set of measurements taken from that instance (for inclusion in a teaching file); and so on.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImagingObjectSelection.Series">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--uid 0..1 oid (json type: string)--><xsl:if test="f:uid">
         <xsl:if test="f:uid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uid">
               <xsl:value-of select="f:uid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uid">
               <xsl:apply-templates select="f:uid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--instance 1..* ImagingObjectSelection.Instance--><xsl:if test="f:instance">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="instance">
            <xsl:for-each select="f:instance">
               <map>
                  <xsl:apply-templates select="." mode="ImagingObjectSelection.Instance"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest of a set of DICOM Service-Object Pair Instances (SOP Instances).  The referenced SOP Instances (images or other content) are for a single patient, and may be from one or more studies. The referenced SOP Instances have been selected for a purpose, such as quality assurance, conference, or consult. Reflecting that range of purposes, typical ImagingObjectSelection resources may include all SOP Instances in a study (perhaps for sharing through a Health Information Exchange); key images from multiple studies (for reference by a referring or treating physician); a multi-frame ultrasound instance ("cine" video clip) and a set of measurements taken from that instance (for inclusion in a teaching file); and so on.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImagingObjectSelection.Instance">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--sopClass 1..1 oid (json type: string)--><xsl:if test="f:sopClass">
         <xsl:if test="f:sopClass/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sopClass">
               <xsl:value-of select="f:sopClass/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sopClass[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sopClass">
               <xsl:apply-templates select="f:sopClass" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--uid 1..1 oid (json type: string)--><xsl:if test="f:uid">
         <xsl:if test="f:uid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uid">
               <xsl:value-of select="f:uid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uid">
               <xsl:apply-templates select="f:uid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 1..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--frames 0..* ImagingObjectSelection.Frames--><xsl:if test="f:frames">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="frames">
            <xsl:for-each select="f:frames">
               <map>
                  <xsl:apply-templates select="." mode="ImagingObjectSelection.Frames"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A manifest of a set of DICOM Service-Object Pair Instances (SOP Instances).  The referenced SOP Instances (images or other content) are for a single patient, and may be from one or more studies. The referenced SOP Instances have been selected for a purpose, such as quality assurance, conference, or consult. Reflecting that range of purposes, typical ImagingObjectSelection resources may include all SOP Instances in a study (perhaps for sharing through a Health Information Exchange); key images from multiple studies (for reference by a referring or treating physician); a multi-frame ultrasound instance ("cine" video clip) and a set of measurements taken from that instance (for inclusion in a teaching file); and so on.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImagingObjectSelection.Frames">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--frameNumbers 1..* unsignedInt (json type: number)--><xsl:if test="f:frameNumbers">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="frameNumbers">
            <xsl:for-each select="f:frameNumbers">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:frameNumbers[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_frameNumbers">
               <xsl:for-each select="f:frameNumbers">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--url 1..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context.  A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImagingStudy">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ImagingStudy</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--started 0..1 dateTime (json type: string)--><xsl:if test="f:started">
         <xsl:if test="f:started/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="started">
               <xsl:value-of select="f:started/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:started[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_started">
               <xsl:apply-templates select="f:started" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--uid 1..1 oid (json type: string)--><xsl:if test="f:uid">
         <xsl:if test="f:uid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uid">
               <xsl:value-of select="f:uid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uid">
               <xsl:apply-templates select="f:uid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--accession 0..1 Identifier--><xsl:if test="f:accession">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="accession">
            <xsl:apply-templates select="f:accession" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--order 0..* Reference--><xsl:if test="f:order">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="order">
            <xsl:for-each select="f:order">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--modalityList 0..* Coding--><xsl:if test="f:modalityList">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modalityList">
            <xsl:for-each select="f:modalityList">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--referrer 0..1 Reference--><xsl:if test="f:referrer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="referrer">
            <xsl:apply-templates select="f:referrer" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--availability 0..1 InstanceAvailability (json type: string)--><xsl:if test="f:availability">
         <xsl:if test="f:availability/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="availability">
               <xsl:value-of select="f:availability/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:availability[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_availability">
               <xsl:apply-templates select="f:availability" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--numberOfSeries 1..1 unsignedInt (json type: number)--><xsl:if test="f:numberOfSeries">
         <xsl:if test="f:numberOfSeries/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="numberOfSeries">
               <xsl:value-of select="f:numberOfSeries/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:numberOfSeries[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_numberOfSeries">
               <xsl:apply-templates select="f:numberOfSeries" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--numberOfInstances 1..1 unsignedInt (json type: number)--><xsl:if test="f:numberOfInstances">
         <xsl:if test="f:numberOfInstances/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="numberOfInstances">
               <xsl:value-of select="f:numberOfInstances/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:numberOfInstances[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_numberOfInstances">
               <xsl:apply-templates select="f:numberOfInstances" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--procedure 0..* Reference--><xsl:if test="f:procedure">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="procedure">
            <xsl:for-each select="f:procedure">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--interpreter 0..1 Reference--><xsl:if test="f:interpreter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="interpreter">
            <xsl:apply-templates select="f:interpreter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--series 0..* ImagingStudy.Series--><xsl:if test="f:series">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="series">
            <xsl:for-each select="f:series">
               <map>
                  <xsl:apply-templates select="." mode="ImagingStudy.Series"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context.  A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImagingStudy.Series">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--number 0..1 unsignedInt (json type: number)--><xsl:if test="f:number">
         <xsl:if test="f:number/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="number">
               <xsl:value-of select="f:number/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:number[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_number">
               <xsl:apply-templates select="f:number" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--modality 1..1 Coding--><xsl:if test="f:modality">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="modality">
            <xsl:apply-templates select="f:modality" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--uid 1..1 oid (json type: string)--><xsl:if test="f:uid">
         <xsl:if test="f:uid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uid">
               <xsl:value-of select="f:uid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uid">
               <xsl:apply-templates select="f:uid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--numberOfInstances 1..1 unsignedInt (json type: number)--><xsl:if test="f:numberOfInstances">
         <xsl:if test="f:numberOfInstances/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="numberOfInstances">
               <xsl:value-of select="f:numberOfInstances/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:numberOfInstances[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_numberOfInstances">
               <xsl:apply-templates select="f:numberOfInstances" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--availability 0..1 InstanceAvailability (json type: string)--><xsl:if test="f:availability">
         <xsl:if test="f:availability/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="availability">
               <xsl:value-of select="f:availability/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:availability[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_availability">
               <xsl:apply-templates select="f:availability" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--bodySite 0..1 Coding--><xsl:if test="f:bodySite">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bodySite">
            <xsl:apply-templates select="f:bodySite" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--laterality 0..1 Coding--><xsl:if test="f:laterality">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="laterality">
            <xsl:apply-templates select="f:laterality" mode="Coding"/>
         </map>
      </xsl:if>
                    <!--started 0..1 dateTime (json type: string)--><xsl:if test="f:started">
         <xsl:if test="f:started/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="started">
               <xsl:value-of select="f:started/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:started[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_started">
               <xsl:apply-templates select="f:started" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--instance 0..* ImagingStudy.Instance--><xsl:if test="f:instance">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="instance">
            <xsl:for-each select="f:instance">
               <map>
                  <xsl:apply-templates select="." mode="ImagingStudy.Instance"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context.  A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImagingStudy.Instance">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--number 0..1 unsignedInt (json type: number)--><xsl:if test="f:number">
         <xsl:if test="f:number/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="number">
               <xsl:value-of select="f:number/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:number[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_number">
               <xsl:apply-templates select="f:number" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--uid 1..1 oid (json type: string)--><xsl:if test="f:uid">
         <xsl:if test="f:uid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uid">
               <xsl:value-of select="f:uid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uid">
               <xsl:apply-templates select="f:uid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--sopClass 1..1 oid (json type: string)--><xsl:if test="f:sopClass">
         <xsl:if test="f:sopClass/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sopClass">
               <xsl:value-of select="f:sopClass/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sopClass[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sopClass">
               <xsl:apply-templates select="f:sopClass" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 string (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--content 0..* Attachment--><xsl:if test="f:content">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="content">
            <xsl:for-each select="f:content">
               <map>
                  <xsl:apply-templates select="." mode="Attachment"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Availability of the resource</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="InstanceAvailability">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the event of a patient being administered a vaccination or a record of a vaccination as reported by a patient, a clinician or another party and may include vaccine reaction information and what vaccination protocol was followed.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Immunization">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Immunization</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 1..1 code (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--vaccineCode 1..1 CodeableConcept--><xsl:if test="f:vaccineCode">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="vaccineCode">
            <xsl:apply-templates select="f:vaccineCode" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--wasNotGiven 1..1 boolean (json type: boolean)--><xsl:if test="f:wasNotGiven">
         <xsl:if test="f:wasNotGiven/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="wasNotGiven">
               <xsl:value-of select="f:wasNotGiven/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:wasNotGiven[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_wasNotGiven">
               <xsl:apply-templates select="f:wasNotGiven" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--reported 1..1 boolean (json type: boolean)--><xsl:if test="f:reported">
         <xsl:if test="f:reported/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="reported">
               <xsl:value-of select="f:reported/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:reported[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reported">
               <xsl:apply-templates select="f:reported" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--performer 0..1 Reference--><xsl:if test="f:performer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="performer">
            <xsl:apply-templates select="f:performer" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--requester 0..1 Reference--><xsl:if test="f:requester">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requester">
            <xsl:apply-templates select="f:requester" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--manufacturer 0..1 Reference--><xsl:if test="f:manufacturer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="manufacturer">
            <xsl:apply-templates select="f:manufacturer" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--lotNumber 0..1 string (json type: string)--><xsl:if test="f:lotNumber">
         <xsl:if test="f:lotNumber/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lotNumber">
               <xsl:value-of select="f:lotNumber/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lotNumber[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lotNumber">
               <xsl:apply-templates select="f:lotNumber" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--expirationDate 0..1 date (json type: string)--><xsl:if test="f:expirationDate">
         <xsl:if test="f:expirationDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="expirationDate">
               <xsl:value-of select="f:expirationDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:expirationDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_expirationDate">
               <xsl:apply-templates select="f:expirationDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--site 0..1 CodeableConcept--><xsl:if test="f:site">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="site">
            <xsl:apply-templates select="f:site" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--route 0..1 CodeableConcept--><xsl:if test="f:route">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="route">
            <xsl:apply-templates select="f:route" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--doseQuantity 0..1 SimpleQuantity--><xsl:if test="f:doseQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseQuantity">
            <xsl:apply-templates select="f:doseQuantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--explanation 0..1 Immunization.Explanation--><xsl:if test="f:explanation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="explanation">
            <xsl:apply-templates select="f:explanation" mode="Immunization.Explanation"/>
         </map>
      </xsl:if>
                    <!--reaction 0..* Immunization.Reaction--><xsl:if test="f:reaction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reaction">
            <xsl:for-each select="f:reaction">
               <map>
                  <xsl:apply-templates select="." mode="Immunization.Reaction"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--vaccinationProtocol 0..* Immunization.VaccinationProtocol--><xsl:if test="f:vaccinationProtocol">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="vaccinationProtocol">
            <xsl:for-each select="f:vaccinationProtocol">
               <map>
                  <xsl:apply-templates select="." mode="Immunization.VaccinationProtocol"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the event of a patient being administered a vaccination or a record of a vaccination as reported by a patient, a clinician or another party and may include vaccine reaction information and what vaccination protocol was followed.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Immunization.Explanation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--reasonNotGiven 0..* CodeableConcept--><xsl:if test="f:reasonNotGiven">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonNotGiven">
            <xsl:for-each select="f:reasonNotGiven">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the event of a patient being administered a vaccination or a record of a vaccination as reported by a patient, a clinician or another party and may include vaccine reaction information and what vaccination protocol was followed.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Immunization.Reaction">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--detail 0..1 Reference--><xsl:if test="f:detail">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:apply-templates select="f:detail" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--reported 0..1 boolean (json type: boolean)--><xsl:if test="f:reported">
         <xsl:if test="f:reported/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="reported">
               <xsl:value-of select="f:reported/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:reported[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reported">
               <xsl:apply-templates select="f:reported" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the event of a patient being administered a vaccination or a record of a vaccination as reported by a patient, a clinician or another party and may include vaccine reaction information and what vaccination protocol was followed.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Immunization.VaccinationProtocol">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--doseSequence 1..1 positiveInt (json type: number)--><xsl:if test="f:doseSequence">
         <xsl:if test="f:doseSequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="doseSequence">
               <xsl:value-of select="f:doseSequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:doseSequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_doseSequence">
               <xsl:apply-templates select="f:doseSequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--authority 0..1 Reference--><xsl:if test="f:authority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="authority">
            <xsl:apply-templates select="f:authority" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--series 0..1 string (json type: string)--><xsl:if test="f:series">
         <xsl:if test="f:series/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="series">
               <xsl:value-of select="f:series/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:series[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_series">
               <xsl:apply-templates select="f:series" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--seriesDoses 0..1 positiveInt (json type: number)--><xsl:if test="f:seriesDoses">
         <xsl:if test="f:seriesDoses/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="seriesDoses">
               <xsl:value-of select="f:seriesDoses/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:seriesDoses[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_seriesDoses">
               <xsl:apply-templates select="f:seriesDoses" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--targetDisease 1..* CodeableConcept--><xsl:if test="f:targetDisease">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="targetDisease">
            <xsl:for-each select="f:targetDisease">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--doseStatus 1..1 CodeableConcept--><xsl:if test="f:doseStatus">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseStatus">
            <xsl:apply-templates select="f:doseStatus" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--doseStatusReason 0..1 CodeableConcept--><xsl:if test="f:doseStatusReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseStatusReason">
            <xsl:apply-templates select="f:doseStatusReason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A patient's point-in-time immunization and recommendation (i.e. forecasting a patient's immunization eligibility according to a published schedule) with optional supporting justification.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImmunizationRecommendation">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ImmunizationRecommendation</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--recommendation 1..* ImmunizationRecommendation.Recommendation--><xsl:if test="f:recommendation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="recommendation">
            <xsl:for-each select="f:recommendation">
               <map>
                  <xsl:apply-templates select="." mode="ImmunizationRecommendation.Recommendation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A patient's point-in-time immunization and recommendation (i.e. forecasting a patient's immunization eligibility according to a published schedule) with optional supporting justification.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImmunizationRecommendation.Recommendation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--date 1..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--vaccineCode 1..1 CodeableConcept--><xsl:if test="f:vaccineCode">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="vaccineCode">
            <xsl:apply-templates select="f:vaccineCode" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--doseNumber 0..1 positiveInt (json type: number)--><xsl:if test="f:doseNumber">
         <xsl:if test="f:doseNumber/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="doseNumber">
               <xsl:value-of select="f:doseNumber/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:doseNumber[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_doseNumber">
               <xsl:apply-templates select="f:doseNumber" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--forecastStatus 1..1 CodeableConcept--><xsl:if test="f:forecastStatus">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="forecastStatus">
            <xsl:apply-templates select="f:forecastStatus" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--dateCriterion 0..* ImmunizationRecommendation.DateCriterion--><xsl:if test="f:dateCriterion">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dateCriterion">
            <xsl:for-each select="f:dateCriterion">
               <map>
                  <xsl:apply-templates select="." mode="ImmunizationRecommendation.DateCriterion"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--protocol 0..1 ImmunizationRecommendation.Protocol--><xsl:if test="f:protocol">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="protocol">
            <xsl:apply-templates select="f:protocol" mode="ImmunizationRecommendation.Protocol"/>
         </map>
      </xsl:if>
                    <!--supportingImmunization 0..* Reference--><xsl:if test="f:supportingImmunization">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="supportingImmunization">
            <xsl:for-each select="f:supportingImmunization">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--supportingPatientInformation 0..* Reference--><xsl:if test="f:supportingPatientInformation">
         <array xmlns="http://www.w3.org/2005/xpath-functions"
                key="supportingPatientInformation">
            <xsl:for-each select="f:supportingPatientInformation">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A patient's point-in-time immunization and recommendation (i.e. forecasting a patient's immunization eligibility according to a published schedule) with optional supporting justification.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImmunizationRecommendation.DateCriterion">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--value 1..1 dateTime (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A patient's point-in-time immunization and recommendation (i.e. forecasting a patient's immunization eligibility according to a published schedule) with optional supporting justification.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImmunizationRecommendation.Protocol">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--doseSequence 0..1 integer (json type: number)--><xsl:if test="f:doseSequence">
         <xsl:if test="f:doseSequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="doseSequence">
               <xsl:value-of select="f:doseSequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:doseSequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_doseSequence">
               <xsl:apply-templates select="f:doseSequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--authority 0..1 Reference--><xsl:if test="f:authority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="authority">
            <xsl:apply-templates select="f:authority" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--series 0..1 string (json type: string)--><xsl:if test="f:series">
         <xsl:if test="f:series/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="series">
               <xsl:value-of select="f:series/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:series[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_series">
               <xsl:apply-templates select="f:series" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of rules or how FHIR is used to solve a particular problem. This resource is used to gather all the parts of an implementation guide into a logical whole, and to publish a computable definition of all the parts.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImplementationGuide">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ImplementationGuide</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--url 1..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 code (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--contact 0..* ImplementationGuide.Contact--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ImplementationGuide.Contact"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--useContext 0..* CodeableConcept--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--copyright 0..1 string (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--fhirVersion 0..1 id (json type: string)--><xsl:if test="f:fhirVersion">
         <xsl:if test="f:fhirVersion/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fhirVersion">
               <xsl:value-of select="f:fhirVersion/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fhirVersion[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fhirVersion">
               <xsl:apply-templates select="f:fhirVersion" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--dependency 0..* ImplementationGuide.Dependency--><xsl:if test="f:dependency">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dependency">
            <xsl:for-each select="f:dependency">
               <map>
                  <xsl:apply-templates select="." mode="ImplementationGuide.Dependency"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--package 1..* ImplementationGuide.Package--><xsl:if test="f:package">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="package">
            <xsl:for-each select="f:package">
               <map>
                  <xsl:apply-templates select="." mode="ImplementationGuide.Package"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--global 0..* ImplementationGuide.Global--><xsl:if test="f:global">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="global">
            <xsl:for-each select="f:global">
               <map>
                  <xsl:apply-templates select="." mode="ImplementationGuide.Global"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--binary 0..* uri (json type: string)--><xsl:if test="f:binary">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="binary">
            <xsl:for-each select="f:binary">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:binary[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_binary">
               <xsl:for-each select="f:binary">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--page 1..1 ImplementationGuide.Page--><xsl:if test="f:page">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="page">
            <xsl:apply-templates select="f:page" mode="ImplementationGuide.Page"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of rules or how FHIR is used to solve a particular problem. This resource is used to gather all the parts of an implementation guide into a logical whole, and to publish a computable definition of all the parts.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImplementationGuide.Contact">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:if test="f:telecom">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="telecom">
            <xsl:for-each select="f:telecom">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of rules or how FHIR is used to solve a particular problem. This resource is used to gather all the parts of an implementation guide into a logical whole, and to publish a computable definition of all the parts.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImplementationGuide.Dependency">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 GuideDependencyType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--uri 1..1 uri (json type: string)--><xsl:if test="f:uri">
         <xsl:if test="f:uri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uri">
               <xsl:value-of select="f:uri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uri">
               <xsl:apply-templates select="f:uri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of rules or how FHIR is used to solve a particular problem. This resource is used to gather all the parts of an implementation guide into a logical whole, and to publish a computable definition of all the parts.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImplementationGuide.Package">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--resource 1..* ImplementationGuide.Resource--><xsl:if test="f:resource">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="resource">
            <xsl:for-each select="f:resource">
               <map>
                  <xsl:apply-templates select="." mode="ImplementationGuide.Resource"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of rules or how FHIR is used to solve a particular problem. This resource is used to gather all the parts of an implementation guide into a logical whole, and to publish a computable definition of all the parts.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImplementationGuide.Resource">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--purpose 1..1 GuideResourcePurpose (json type: string)--><xsl:if test="f:purpose">
         <xsl:if test="f:purpose/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose">
               <xsl:value-of select="f:purpose/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:purpose[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_purpose">
               <xsl:apply-templates select="f:purpose" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--acronym 0..1 string (json type: string)--><xsl:if test="f:acronym">
         <xsl:if test="f:acronym/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="acronym">
               <xsl:value-of select="f:acronym/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:acronym[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_acronym">
               <xsl:apply-templates select="f:acronym" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--sourceUri 1..1 uri (json type: string)--><xsl:if test="f:sourceUri">
         <xsl:if test="f:sourceUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sourceUri">
               <xsl:value-of select="f:sourceUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sourceUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sourceUri">
               <xsl:apply-templates select="f:sourceUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--sourceReference 1..1 Reference--><xsl:if test="f:sourceReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sourceReference">
            <xsl:apply-templates select="f:sourceReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--exampleFor 0..1 Reference--><xsl:if test="f:exampleFor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exampleFor">
            <xsl:apply-templates select="f:exampleFor" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of rules or how FHIR is used to solve a particular problem. This resource is used to gather all the parts of an implementation guide into a logical whole, and to publish a computable definition of all the parts.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImplementationGuide.Global">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 code (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--profile 1..1 Reference--><xsl:if test="f:profile">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:apply-templates select="f:profile" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of rules or how FHIR is used to solve a particular problem. This resource is used to gather all the parts of an implementation guide into a logical whole, and to publish a computable definition of all the parts.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ImplementationGuide.Page">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--source 1..1 uri (json type: string)--><xsl:if test="f:source">
         <xsl:if test="f:source/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="source">
               <xsl:value-of select="f:source/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:source[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_source">
               <xsl:apply-templates select="f:source" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--kind 1..1 GuidePageKind (json type: string)--><xsl:if test="f:kind">
         <xsl:if test="f:kind/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="kind">
               <xsl:value-of select="f:kind/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:kind[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_kind">
               <xsl:apply-templates select="f:kind" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..* code (json type: string)--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:type[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:for-each select="f:type">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--package 0..* string (json type: string)--><xsl:if test="f:package">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="package">
            <xsl:for-each select="f:package">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:package[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_package">
               <xsl:for-each select="f:package">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
                    <!--format 0..1 code (json type: string)--><xsl:if test="f:format">
         <xsl:if test="f:format/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="format">
               <xsl:value-of select="f:format/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:format[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_format">
               <xsl:apply-templates select="f:format" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--page 0..* ImplementationGuide.Page--><xsl:if test="f:page">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="page">
            <xsl:for-each select="f:page">
               <map>
                  <xsl:apply-templates select="." mode="ImplementationGuide.Page"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a dependency is represented when the guide is published.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="GuideDependencyType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Why a resource is included in the guide.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="GuideResourcePurpose">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The kind of an included page.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="GuidePageKind">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of information summarized from a list of other resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="List">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">List</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--source 0..1 Reference--><xsl:if test="f:source">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="source">
            <xsl:apply-templates select="f:source" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--status 1..1 ListStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--orderedBy 0..1 CodeableConcept--><xsl:if test="f:orderedBy">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="orderedBy">
            <xsl:apply-templates select="f:orderedBy" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--mode 1..1 ListMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--note 0..1 string (json type: string)--><xsl:if test="f:note">
         <xsl:if test="f:note/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="note">
               <xsl:value-of select="f:note/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:note[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_note">
               <xsl:apply-templates select="f:note" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--entry 0..* List.Entry--><xsl:if test="f:entry">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="entry">
            <xsl:for-each select="f:entry">
               <map>
                  <xsl:apply-templates select="." mode="List.Entry"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--emptyReason 0..1 CodeableConcept--><xsl:if test="f:emptyReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="emptyReason">
            <xsl:apply-templates select="f:emptyReason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of information summarized from a list of other resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="List.Entry">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--flag 0..1 CodeableConcept--><xsl:if test="f:flag">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="flag">
            <xsl:apply-templates select="f:flag" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--deleted 0..1 boolean (json type: boolean)--><xsl:if test="f:deleted">
         <xsl:if test="f:deleted/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="deleted">
               <xsl:value-of select="f:deleted/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:deleted[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_deleted">
               <xsl:apply-templates select="f:deleted" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--item 1..1 Reference--><xsl:if test="f:item">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:apply-templates select="f:item" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The current state of the list</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ListStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The processing mode that applies to this list</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ListMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Details and position information for a physical place where services are provided  and resources and participants may be stored, found, contained or accommodated.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Location">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Location</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 0..1 LocationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--mode 0..1 LocationMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--telecom 0..* ContactPoint--><xsl:if test="f:telecom">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="telecom">
            <xsl:for-each select="f:telecom">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--address 0..1 Address--><xsl:if test="f:address">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="address">
            <xsl:apply-templates select="f:address" mode="Address"/>
         </map>
      </xsl:if>
                    <!--physicalType 0..1 CodeableConcept--><xsl:if test="f:physicalType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="physicalType">
            <xsl:apply-templates select="f:physicalType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--position 0..1 Location.Position--><xsl:if test="f:position">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="position">
            <xsl:apply-templates select="f:position" mode="Location.Position"/>
         </map>
      </xsl:if>
                    <!--managingOrganization 0..1 Reference--><xsl:if test="f:managingOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="managingOrganization">
            <xsl:apply-templates select="f:managingOrganization" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--partOf 0..1 Reference--><xsl:if test="f:partOf">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="partOf">
            <xsl:apply-templates select="f:partOf" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Details and position information for a physical place where services are provided  and resources and participants may be stored, found, contained or accommodated.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Location.Position">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--longitude 1..1 decimal (json type: number)--><xsl:if test="f:longitude">
         <xsl:if test="f:longitude/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="longitude">
               <xsl:value-of select="f:longitude/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:longitude[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_longitude">
               <xsl:apply-templates select="f:longitude" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--latitude 1..1 decimal (json type: number)--><xsl:if test="f:latitude">
         <xsl:if test="f:latitude/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="latitude">
               <xsl:value-of select="f:latitude/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:latitude[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_latitude">
               <xsl:apply-templates select="f:latitude" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--altitude 0..1 decimal (json type: number)--><xsl:if test="f:altitude">
         <xsl:if test="f:altitude/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="altitude">
               <xsl:value-of select="f:altitude/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:altitude[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_altitude">
               <xsl:apply-templates select="f:altitude" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the location is still in use.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="LocationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether a resource instance represents a specific location or a class of locations.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="LocationMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A photo, video, or audio recording acquired or used in healthcare. The actual content may be inline or provided by direct reference.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Media">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Media</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--type 1..1 DigitalMediaType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--subtype 0..1 CodeableConcept--><xsl:if test="f:subtype">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subtype">
            <xsl:apply-templates select="f:subtype" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--operator 0..1 Reference--><xsl:if test="f:operator">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="operator">
            <xsl:apply-templates select="f:operator" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--view 0..1 CodeableConcept--><xsl:if test="f:view">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="view">
            <xsl:apply-templates select="f:view" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--deviceName 0..1 string (json type: string)--><xsl:if test="f:deviceName">
         <xsl:if test="f:deviceName/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="deviceName">
               <xsl:value-of select="f:deviceName/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:deviceName[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_deviceName">
               <xsl:apply-templates select="f:deviceName" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--height 0..1 positiveInt (json type: number)--><xsl:if test="f:height">
         <xsl:if test="f:height/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="height">
               <xsl:value-of select="f:height/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:height[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_height">
               <xsl:apply-templates select="f:height" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--width 0..1 positiveInt (json type: number)--><xsl:if test="f:width">
         <xsl:if test="f:width/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="width">
               <xsl:value-of select="f:width/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:width[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_width">
               <xsl:apply-templates select="f:width" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--frames 0..1 positiveInt (json type: number)--><xsl:if test="f:frames">
         <xsl:if test="f:frames/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="frames">
               <xsl:value-of select="f:frames/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:frames[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_frames">
               <xsl:apply-templates select="f:frames" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--duration 0..1 unsignedInt (json type: number)--><xsl:if test="f:duration">
         <xsl:if test="f:duration/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="duration">
               <xsl:value-of select="f:duration/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:duration[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_duration">
               <xsl:apply-templates select="f:duration" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--content 1..1 Attachment--><xsl:if test="f:content">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="content">
            <xsl:apply-templates select="f:content" mode="Attachment"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Whether the Media is a photo, video, or audio</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DigitalMediaType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource is primarily used for the identification and definition of a medication. It covers the ingredients and the packaging for a medication.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Medication">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Medication</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--isBrand 0..1 boolean (json type: boolean)--><xsl:if test="f:isBrand">
         <xsl:if test="f:isBrand/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="isBrand">
               <xsl:value-of select="f:isBrand/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:isBrand[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_isBrand">
               <xsl:apply-templates select="f:isBrand" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--manufacturer 0..1 Reference--><xsl:if test="f:manufacturer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="manufacturer">
            <xsl:apply-templates select="f:manufacturer" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--product 0..1 Medication.Product--><xsl:if test="f:product">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="product">
            <xsl:apply-templates select="f:product" mode="Medication.Product"/>
         </map>
      </xsl:if>
                    <!--package 0..1 Medication.Package--><xsl:if test="f:package">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="package">
            <xsl:apply-templates select="f:package" mode="Medication.Package"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource is primarily used for the identification and definition of a medication. It covers the ingredients and the packaging for a medication.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Medication.Product">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--form 0..1 CodeableConcept--><xsl:if test="f:form">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="form">
            <xsl:apply-templates select="f:form" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--ingredient 0..* Medication.Ingredient--><xsl:if test="f:ingredient">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="ingredient">
            <xsl:for-each select="f:ingredient">
               <map>
                  <xsl:apply-templates select="." mode="Medication.Ingredient"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--batch 0..* Medication.Batch--><xsl:if test="f:batch">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="batch">
            <xsl:for-each select="f:batch">
               <map>
                  <xsl:apply-templates select="." mode="Medication.Batch"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource is primarily used for the identification and definition of a medication. It covers the ingredients and the packaging for a medication.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Medication.Ingredient">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--item 1..1 Reference--><xsl:if test="f:item">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:apply-templates select="f:item" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--amount 0..1 Ratio--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="Ratio"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource is primarily used for the identification and definition of a medication. It covers the ingredients and the packaging for a medication.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Medication.Batch">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--lotNumber 0..1 string (json type: string)--><xsl:if test="f:lotNumber">
         <xsl:if test="f:lotNumber/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lotNumber">
               <xsl:value-of select="f:lotNumber/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lotNumber[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lotNumber">
               <xsl:apply-templates select="f:lotNumber" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--expirationDate 0..1 dateTime (json type: string)--><xsl:if test="f:expirationDate">
         <xsl:if test="f:expirationDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="expirationDate">
               <xsl:value-of select="f:expirationDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:expirationDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_expirationDate">
               <xsl:apply-templates select="f:expirationDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource is primarily used for the identification and definition of a medication. It covers the ingredients and the packaging for a medication.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Medication.Package">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--container 0..1 CodeableConcept--><xsl:if test="f:container">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="container">
            <xsl:apply-templates select="f:container" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--content 0..* Medication.Content--><xsl:if test="f:content">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="content">
            <xsl:for-each select="f:content">
               <map>
                  <xsl:apply-templates select="." mode="Medication.Content"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource is primarily used for the identification and definition of a medication. It covers the ingredients and the packaging for a medication.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Medication.Content">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--item 1..1 Reference--><xsl:if test="f:item">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:apply-templates select="f:item" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--amount 0..1 SimpleQuantity--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the event of a patient consuming or otherwise being administered a medication.  This may be as simple as swallowing a tablet or it may be a long running infusion.  Related resources tie this event to the authorizing prescription, and the specific encounter between patient and health care practitioner.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationAdministration">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">MedicationAdministration</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--status 1..1 MedicationAdministrationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--practitioner 0..1 Reference--><xsl:if test="f:practitioner">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="practitioner">
            <xsl:apply-templates select="f:practitioner" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--prescription 0..1 Reference--><xsl:if test="f:prescription">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="prescription">
            <xsl:apply-templates select="f:prescription" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--wasNotGiven 0..1 boolean (json type: boolean)--><xsl:if test="f:wasNotGiven">
         <xsl:if test="f:wasNotGiven/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="wasNotGiven">
               <xsl:value-of select="f:wasNotGiven/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:wasNotGiven[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_wasNotGiven">
               <xsl:apply-templates select="f:wasNotGiven" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--reasonNotGiven 0..* CodeableConcept--><xsl:if test="f:reasonNotGiven">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonNotGiven">
            <xsl:for-each select="f:reasonNotGiven">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--reasonGiven 0..* CodeableConcept--><xsl:if test="f:reasonGiven">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonGiven">
            <xsl:for-each select="f:reasonGiven">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    
                        
                        <!--effectiveTimeDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:effectiveTimeDateTime">
         <xsl:if test="f:effectiveTimeDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveTimeDateTime">
               <xsl:value-of select="f:effectiveTimeDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:effectiveTimeDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_effectiveTimeDateTime">
               <xsl:apply-templates select="f:effectiveTimeDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--effectiveTimePeriod 1..1 Period--><xsl:if test="f:effectiveTimePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveTimePeriod">
            <xsl:apply-templates select="f:effectiveTimePeriod" mode="Period"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--medicationCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:medicationCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="medicationCodeableConcept">
            <xsl:apply-templates select="f:medicationCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--medicationReference 1..1 Reference--><xsl:if test="f:medicationReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="medicationReference">
            <xsl:apply-templates select="f:medicationReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--device 0..* Reference--><xsl:if test="f:device">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="device">
            <xsl:for-each select="f:device">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--note 0..1 string (json type: string)--><xsl:if test="f:note">
         <xsl:if test="f:note/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="note">
               <xsl:value-of select="f:note/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:note[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_note">
               <xsl:apply-templates select="f:note" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--dosage 0..1 MedicationAdministration.Dosage--><xsl:if test="f:dosage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dosage">
            <xsl:apply-templates select="f:dosage" mode="MedicationAdministration.Dosage"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the event of a patient consuming or otherwise being administered a medication.  This may be as simple as swallowing a tablet or it may be a long running infusion.  Related resources tie this event to the authorizing prescription, and the specific encounter between patient and health care practitioner.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationAdministration.Dosage">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--siteCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:siteCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="siteCodeableConcept">
            <xsl:apply-templates select="f:siteCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--siteReference 1..1 Reference--><xsl:if test="f:siteReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="siteReference">
            <xsl:apply-templates select="f:siteReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--route 0..1 CodeableConcept--><xsl:if test="f:route">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="route">
            <xsl:apply-templates select="f:route" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--method 0..1 CodeableConcept--><xsl:if test="f:method">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="method">
            <xsl:apply-templates select="f:method" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    
                        
                        <!--rateRatio 1..1 Ratio--><xsl:if test="f:rateRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateRatio">
            <xsl:apply-templates select="f:rateRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--rateRange 1..1 Range--><xsl:if test="f:rateRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateRange">
            <xsl:apply-templates select="f:rateRange" mode="Range"/>
         </map>
      </xsl:if>
                    
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of codes indicating the current status of a MedicationAdministration.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationAdministrationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates that a medication product is to be or has been dispensed for a named person/patient.  This includes a description of the medication product (supply) provided and the instructions for administering the medication.  The medication dispense is the result of a pharmacy system responding to a medication order.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationDispense">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">MedicationDispense</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
                    <!--status 0..1 MedicationDispenseStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--dispenser 0..1 Reference--><xsl:if test="f:dispenser">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dispenser">
            <xsl:apply-templates select="f:dispenser" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--authorizingPrescription 0..* Reference--><xsl:if test="f:authorizingPrescription">
         <array xmlns="http://www.w3.org/2005/xpath-functions"
                key="authorizingPrescription">
            <xsl:for-each select="f:authorizingPrescription">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--daysSupply 0..1 SimpleQuantity--><xsl:if test="f:daysSupply">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="daysSupply">
            <xsl:apply-templates select="f:daysSupply" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    
                        
                        <!--medicationCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:medicationCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="medicationCodeableConcept">
            <xsl:apply-templates select="f:medicationCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--medicationReference 1..1 Reference--><xsl:if test="f:medicationReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="medicationReference">
            <xsl:apply-templates select="f:medicationReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--whenPrepared 0..1 dateTime (json type: string)--><xsl:if test="f:whenPrepared">
         <xsl:if test="f:whenPrepared/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="whenPrepared">
               <xsl:value-of select="f:whenPrepared/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:whenPrepared[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_whenPrepared">
               <xsl:apply-templates select="f:whenPrepared" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--whenHandedOver 0..1 dateTime (json type: string)--><xsl:if test="f:whenHandedOver">
         <xsl:if test="f:whenHandedOver/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="whenHandedOver">
               <xsl:value-of select="f:whenHandedOver/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:whenHandedOver[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_whenHandedOver">
               <xsl:apply-templates select="f:whenHandedOver" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--destination 0..1 Reference--><xsl:if test="f:destination">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="destination">
            <xsl:apply-templates select="f:destination" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--receiver 0..* Reference--><xsl:if test="f:receiver">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="receiver">
            <xsl:for-each select="f:receiver">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--note 0..1 string (json type: string)--><xsl:if test="f:note">
         <xsl:if test="f:note/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="note">
               <xsl:value-of select="f:note/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:note[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_note">
               <xsl:apply-templates select="f:note" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--dosageInstruction 0..* MedicationDispense.DosageInstruction--><xsl:if test="f:dosageInstruction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dosageInstruction">
            <xsl:for-each select="f:dosageInstruction">
               <map>
                  <xsl:apply-templates select="." mode="MedicationDispense.DosageInstruction"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--substitution 0..1 MedicationDispense.Substitution--><xsl:if test="f:substitution">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="substitution">
            <xsl:apply-templates select="f:substitution" mode="MedicationDispense.Substitution"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates that a medication product is to be or has been dispensed for a named person/patient.  This includes a description of the medication product (supply) provided and the instructions for administering the medication.  The medication dispense is the result of a pharmacy system responding to a medication order.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationDispense.DosageInstruction">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--additionalInstructions 0..1 CodeableConcept--><xsl:if test="f:additionalInstructions">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="additionalInstructions">
            <xsl:apply-templates select="f:additionalInstructions" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--timing 0..1 Timing--><xsl:if test="f:timing">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timing">
            <xsl:apply-templates select="f:timing" mode="Timing"/>
         </map>
      </xsl:if>
                    
                        
                        <!--asNeededBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:asNeededBoolean">
         <xsl:if test="f:asNeededBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="asNeededBoolean">
               <xsl:value-of select="f:asNeededBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:asNeededBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_asNeededBoolean">
               <xsl:apply-templates select="f:asNeededBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--asNeededCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:asNeededCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="asNeededCodeableConcept">
            <xsl:apply-templates select="f:asNeededCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--siteCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:siteCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="siteCodeableConcept">
            <xsl:apply-templates select="f:siteCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--siteReference 1..1 Reference--><xsl:if test="f:siteReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="siteReference">
            <xsl:apply-templates select="f:siteReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--route 0..1 CodeableConcept--><xsl:if test="f:route">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="route">
            <xsl:apply-templates select="f:route" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--method 0..1 CodeableConcept--><xsl:if test="f:method">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="method">
            <xsl:apply-templates select="f:method" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    
                        
                        <!--doseRange 1..1 Range--><xsl:if test="f:doseRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseRange">
            <xsl:apply-templates select="f:doseRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--doseQuantity 1..1 SimpleQuantity--><xsl:if test="f:doseQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseQuantity">
            <xsl:apply-templates select="f:doseQuantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--rateRatio 1..1 Ratio--><xsl:if test="f:rateRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateRatio">
            <xsl:apply-templates select="f:rateRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--rateRange 1..1 Range--><xsl:if test="f:rateRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateRange">
            <xsl:apply-templates select="f:rateRange" mode="Range"/>
         </map>
      </xsl:if>
                    
                    <!--maxDosePerPeriod 0..1 Ratio--><xsl:if test="f:maxDosePerPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxDosePerPeriod">
            <xsl:apply-templates select="f:maxDosePerPeriod" mode="Ratio"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates that a medication product is to be or has been dispensed for a named person/patient.  This includes a description of the medication product (supply) provided and the instructions for administering the medication.  The medication dispense is the result of a pharmacy system responding to a medication order.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationDispense.Substitution">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--responsibleParty 0..* Reference--><xsl:if test="f:responsibleParty">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="responsibleParty">
            <xsl:for-each select="f:responsibleParty">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code specifying the state of the dispense event.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationDispenseStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An order for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called "MedicationOrder" rather than "MedicationPrescription" to generalize the use across inpatient and outpatient settings as well as for care plans, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationOrder">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">MedicationOrder</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--dateWritten 0..1 dateTime (json type: string)--><xsl:if test="f:dateWritten">
         <xsl:if test="f:dateWritten/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateWritten">
               <xsl:value-of select="f:dateWritten/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:dateWritten[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dateWritten">
               <xsl:apply-templates select="f:dateWritten" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 0..1 MedicationOrderStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--dateEnded 0..1 dateTime (json type: string)--><xsl:if test="f:dateEnded">
         <xsl:if test="f:dateEnded/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateEnded">
               <xsl:value-of select="f:dateEnded/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:dateEnded[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dateEnded">
               <xsl:apply-templates select="f:dateEnded" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--reasonEnded 0..1 CodeableConcept--><xsl:if test="f:reasonEnded">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reasonEnded">
            <xsl:apply-templates select="f:reasonEnded" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--prescriber 0..1 Reference--><xsl:if test="f:prescriber">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="prescriber">
            <xsl:apply-templates select="f:prescriber" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
                    
                        
                        <!--reasonCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:reasonCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reasonCodeableConcept">
            <xsl:apply-templates select="f:reasonCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--reasonReference 1..1 Reference--><xsl:if test="f:reasonReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reasonReference">
            <xsl:apply-templates select="f:reasonReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--note 0..1 string (json type: string)--><xsl:if test="f:note">
         <xsl:if test="f:note/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="note">
               <xsl:value-of select="f:note/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:note[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_note">
               <xsl:apply-templates select="f:note" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    
                        
                        <!--medicationCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:medicationCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="medicationCodeableConcept">
            <xsl:apply-templates select="f:medicationCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--medicationReference 1..1 Reference--><xsl:if test="f:medicationReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="medicationReference">
            <xsl:apply-templates select="f:medicationReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--dosageInstruction 0..* MedicationOrder.DosageInstruction--><xsl:if test="f:dosageInstruction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dosageInstruction">
            <xsl:for-each select="f:dosageInstruction">
               <map>
                  <xsl:apply-templates select="." mode="MedicationOrder.DosageInstruction"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--dispenseRequest 0..1 MedicationOrder.DispenseRequest--><xsl:if test="f:dispenseRequest">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dispenseRequest">
            <xsl:apply-templates select="f:dispenseRequest" mode="MedicationOrder.DispenseRequest"/>
         </map>
      </xsl:if>
                    <!--substitution 0..1 MedicationOrder.Substitution--><xsl:if test="f:substitution">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="substitution">
            <xsl:apply-templates select="f:substitution" mode="MedicationOrder.Substitution"/>
         </map>
      </xsl:if>
                    <!--priorPrescription 0..1 Reference--><xsl:if test="f:priorPrescription">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priorPrescription">
            <xsl:apply-templates select="f:priorPrescription" mode="Reference"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An order for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called "MedicationOrder" rather than "MedicationPrescription" to generalize the use across inpatient and outpatient settings as well as for care plans, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationOrder.DosageInstruction">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--additionalInstructions 0..1 CodeableConcept--><xsl:if test="f:additionalInstructions">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="additionalInstructions">
            <xsl:apply-templates select="f:additionalInstructions" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--timing 0..1 Timing--><xsl:if test="f:timing">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timing">
            <xsl:apply-templates select="f:timing" mode="Timing"/>
         </map>
      </xsl:if>
                    
                        
                        <!--asNeededBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:asNeededBoolean">
         <xsl:if test="f:asNeededBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="asNeededBoolean">
               <xsl:value-of select="f:asNeededBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:asNeededBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_asNeededBoolean">
               <xsl:apply-templates select="f:asNeededBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                        <!--asNeededCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:asNeededCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="asNeededCodeableConcept">
            <xsl:apply-templates select="f:asNeededCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--siteCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:siteCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="siteCodeableConcept">
            <xsl:apply-templates select="f:siteCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--siteReference 1..1 Reference--><xsl:if test="f:siteReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="siteReference">
            <xsl:apply-templates select="f:siteReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--route 0..1 CodeableConcept--><xsl:if test="f:route">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="route">
            <xsl:apply-templates select="f:route" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--method 0..1 CodeableConcept--><xsl:if test="f:method">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="method">
            <xsl:apply-templates select="f:method" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    
                        
                        <!--doseRange 1..1 Range--><xsl:if test="f:doseRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseRange">
            <xsl:apply-templates select="f:doseRange" mode="Range"/>
         </map>
      </xsl:if>
                        <!--doseQuantity 1..1 SimpleQuantity--><xsl:if test="f:doseQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseQuantity">
            <xsl:apply-templates select="f:doseQuantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    
                    
                        
                        <!--rateRatio 1..1 Ratio--><xsl:if test="f:rateRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateRatio">
            <xsl:apply-templates select="f:rateRatio" mode="Ratio"/>
         </map>
      </xsl:if>
                        <!--rateRange 1..1 Range--><xsl:if test="f:rateRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateRange">
            <xsl:apply-templates select="f:rateRange" mode="Range"/>
         </map>
      </xsl:if>
                    
                    <!--maxDosePerPeriod 0..1 Ratio--><xsl:if test="f:maxDosePerPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxDosePerPeriod">
            <xsl:apply-templates select="f:maxDosePerPeriod" mode="Ratio"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An order for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called "MedicationOrder" rather than "MedicationPrescription" to generalize the use across inpatient and outpatient settings as well as for care plans, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationOrder.DispenseRequest">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    
                        
                        <!--medicationCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:medicationCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="medicationCodeableConcept">
            <xsl:apply-templates select="f:medicationCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--medicationReference 1..1 Reference--><xsl:if test="f:medicationReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="medicationReference">
            <xsl:apply-templates select="f:medicationReference" mode="Reference"/>
         </map>
      </xsl:if>
                    
                    <!--validityPeriod 0..1 Period--><xsl:if test="f:validityPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="validityPeriod">
            <xsl:apply-templates select="f:validityPeriod" mode="Period"/>
         </map>
      </xsl:if>
                    <!--numberOfRepeatsAllowed 0..1 positiveInt (json type: number)--><xsl:if test="f:numberOfRepeatsAllowed">
         <xsl:if test="f:numberOfRepeatsAllowed/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="numberOfRepeatsAllowed">
               <xsl:value-of select="f:numberOfRepeatsAllowed/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:numberOfRepeatsAllowed[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_numberOfRepeatsAllowed">
               <xsl:apply-templates select="f:numberOfRepeatsAllowed" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--quantity 0..1 SimpleQuantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="SimpleQuantity"/>
         </map>
      </xsl:if>
                    <!--expectedSupplyDuration 0..1 Duration--><xsl:if test="f:expectedSupplyDuration">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="expectedSupplyDuration">
            <xsl:apply-templates select="f:expectedSupplyDuration" mode="Duration"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An order for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called "MedicationOrder" rather than "MedicationPrescription" to generalize the use across inpatient and outpatient settings as well as for care plans, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationOrder.Substitution">
      <xsl:apply-templates select="." mode="BackboneElement"/>
                    <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                    <!--reason 0..1 CodeableConcept--><xsl:if test="f:reason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:apply-templates select="f:reason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code specifying the state of the prescribing event. Describes the lifecycle of the prescription.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationOrderStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a medication that is being consumed by a patient.   A MedicationStatement may indicate that the patient may be taking the medication now, or has taken the medication in the past or will be taking the medication in the future.  The source of this information can be the patient, significant other (such as a family member or spouse), or a clinician.  A common scenario where this information is captured is during the history taking process during a patient visit or stay.   The medication information may come from e.g. the patient's memory, from a prescription bottle,  or from a list of medications the patient, clinician or other party maintains 

The primary difference between a medication statement and a medication administration is that the medication administration has complete administration information and is based on actual administration information from the person who administered the medication.  A medication statement is often, if not always, less specific.  There is no required date/time when the medication was administered, in fact we only know that a source has reported the patient is taking this medication, where details such as time, quantity, or rate or even medication product may be incomplete or missing or less precise.  As stated earlier, the medication statement information may come from the patient's memory, from a prescription bottle or from a list of medications the patient, clinician or other party maintains.  Medication administration is more formal and is not missing detailed information.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MedicationStatement">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">MedicationStatement</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
                    <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--informationSource 0..1 Reference--><xsl:if test="f:informationSource">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="informationSource">
            <xsl:apply-templates select="f:informationSource" mode="Reference"/>
         </map>
      </xsl:if>
                    <!--dateAsserted 0..1 dateTime (json type: string)--><xsl:if test="f:dateAsserted">
         <xsl:if test="f:dateAsserted/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateAsserted">
               <xsl:value-of select="f:dateAsserted/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:dateAsserted[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dateAsserted">
               <xsl:apply-templates select="f:dateAsserted" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--status 1..1 MedicationStatementStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--wasNotTaken 0..1 boolean (json type: boolean)--><xsl:if test="f:wasNotTaken">
         <xsl:if test="f:wasNotTaken/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="wasNotTaken">
               <xsl:value-of select="f:wasNotTaken/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:wasNotTaken[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_wasNotTaken">
               <xsl:apply-templates select="f:wasNotTaken" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
                    <!--reasonNotTaken 0..* CodeableConcept--><xsl:if test="f:reasonNotTaken">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonNotTaken">
            <xsl:for-each select="f:reasonNotTaken">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
                    
                        
                        <!--reasonForUseCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:reasonForUseCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="reasonForUseCodeableConcept">
            <xsl:apply-templates select="f:reasonForUseCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
                        <!--reasonForUseReference 1..1 Reference--><xsl:if test="f:reasonFor