<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
                xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://hl7.org/fhir"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all"
                version="3.0">
   <xd:doc scope="stylesheet">
      <xd:desc>
         <xd:p>
            <xd:b>Generated:</xd:b> 2022-04-03T07:39:54.832+02:00</xd:p>
         <xd:p>
            <xd:b>By:</xd:b> schema2xmlxsl.xsl version 1.0.0</xd:p>
         <xd:p>Takes in an expath map (http://www.w3.org/2005/xpath-functions) as constructed by json-to-xml() and convert that to FHIR XML</xd:p>
         <xd:p>Known 'issue': does not handle array of fhir_comments as xml comment(), and basically ignores them</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:output indent="yes"
               method="xml"
               media-type="application/xml"
               omit-xml-declaration="yes"/>
   <xsl:variable name="theJSON"
                 select="if (/fn:map) then . else fn:json-to-xml(.)"
                 as="document-node()"/>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="/">
      <xsl:apply-templates select="$theJSON/fn:map"/>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="/fn:map">
      <xsl:variable name="theName" select="fn:string[@key = 'resourceType']"/>
      <xsl:choose>
         <xsl:when test="$theName = 'Account'">
            <xsl:apply-templates select="." mode="Account">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ActivityDefinition'">
            <xsl:apply-templates select="." mode="ActivityDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'AdverseEvent'">
            <xsl:apply-templates select="." mode="AdverseEvent">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'AllergyIntolerance'">
            <xsl:apply-templates select="." mode="AllergyIntolerance">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Appointment'">
            <xsl:apply-templates select="." mode="Appointment">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'AppointmentResponse'">
            <xsl:apply-templates select="." mode="AppointmentResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'AuditEvent'">
            <xsl:apply-templates select="." mode="AuditEvent">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Basic'">
            <xsl:apply-templates select="." mode="Basic">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Binary'">
            <xsl:apply-templates select="." mode="Binary">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'BodySite'">
            <xsl:apply-templates select="." mode="BodySite">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Bundle'">
            <xsl:apply-templates select="." mode="Bundle">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'CapabilityStatement'">
            <xsl:apply-templates select="." mode="CapabilityStatement">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'CarePlan'">
            <xsl:apply-templates select="." mode="CarePlan">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'CareTeam'">
            <xsl:apply-templates select="." mode="CareTeam">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ChargeItem'">
            <xsl:apply-templates select="." mode="ChargeItem">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Claim'">
            <xsl:apply-templates select="." mode="Claim">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ClaimResponse'">
            <xsl:apply-templates select="." mode="ClaimResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ClinicalImpression'">
            <xsl:apply-templates select="." mode="ClinicalImpression">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'CodeSystem'">
            <xsl:apply-templates select="." mode="CodeSystem">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Communication'">
            <xsl:apply-templates select="." mode="Communication">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'CommunicationRequest'">
            <xsl:apply-templates select="." mode="CommunicationRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'CompartmentDefinition'">
            <xsl:apply-templates select="." mode="CompartmentDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Composition'">
            <xsl:apply-templates select="." mode="Composition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ConceptMap'">
            <xsl:apply-templates select="." mode="ConceptMap">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Condition'">
            <xsl:apply-templates select="." mode="Condition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Consent'">
            <xsl:apply-templates select="." mode="Consent">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Contract'">
            <xsl:apply-templates select="." mode="Contract">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Coverage'">
            <xsl:apply-templates select="." mode="Coverage">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DataElement'">
            <xsl:apply-templates select="." mode="DataElement">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DetectedIssue'">
            <xsl:apply-templates select="." mode="DetectedIssue">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Device'">
            <xsl:apply-templates select="." mode="Device">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DeviceComponent'">
            <xsl:apply-templates select="." mode="DeviceComponent">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DeviceMetric'">
            <xsl:apply-templates select="." mode="DeviceMetric">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DeviceRequest'">
            <xsl:apply-templates select="." mode="DeviceRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DeviceUseStatement'">
            <xsl:apply-templates select="." mode="DeviceUseStatement">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DiagnosticReport'">
            <xsl:apply-templates select="." mode="DiagnosticReport">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DocumentManifest'">
            <xsl:apply-templates select="." mode="DocumentManifest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'DocumentReference'">
            <xsl:apply-templates select="." mode="DocumentReference">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EligibilityRequest'">
            <xsl:apply-templates select="." mode="EligibilityRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EligibilityResponse'">
            <xsl:apply-templates select="." mode="EligibilityResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Encounter'">
            <xsl:apply-templates select="." mode="Encounter">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Endpoint'">
            <xsl:apply-templates select="." mode="Endpoint">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EnrollmentRequest'">
            <xsl:apply-templates select="." mode="EnrollmentRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EnrollmentResponse'">
            <xsl:apply-templates select="." mode="EnrollmentResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'EpisodeOfCare'">
            <xsl:apply-templates select="." mode="EpisodeOfCare">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ExpansionProfile'">
            <xsl:apply-templates select="." mode="ExpansionProfile">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ExplanationOfBenefit'">
            <xsl:apply-templates select="." mode="ExplanationOfBenefit">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'FamilyMemberHistory'">
            <xsl:apply-templates select="." mode="FamilyMemberHistory">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Flag'">
            <xsl:apply-templates select="." mode="Flag">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Goal'">
            <xsl:apply-templates select="." mode="Goal">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'GraphDefinition'">
            <xsl:apply-templates select="." mode="GraphDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Group'">
            <xsl:apply-templates select="." mode="Group">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'GuidanceResponse'">
            <xsl:apply-templates select="." mode="GuidanceResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'HealthcareService'">
            <xsl:apply-templates select="." mode="HealthcareService">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ImagingManifest'">
            <xsl:apply-templates select="." mode="ImagingManifest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ImagingStudy'">
            <xsl:apply-templates select="." mode="ImagingStudy">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Immunization'">
            <xsl:apply-templates select="." mode="Immunization">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ImmunizationRecommendation'">
            <xsl:apply-templates select="." mode="ImmunizationRecommendation">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ImplementationGuide'">
            <xsl:apply-templates select="." mode="ImplementationGuide">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Library'">
            <xsl:apply-templates select="." mode="Library">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Linkage'">
            <xsl:apply-templates select="." mode="Linkage">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'List'">
            <xsl:apply-templates select="." mode="List">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Location'">
            <xsl:apply-templates select="." mode="Location">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Measure'">
            <xsl:apply-templates select="." mode="Measure">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MeasureReport'">
            <xsl:apply-templates select="." mode="MeasureReport">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Media'">
            <xsl:apply-templates select="." mode="Media">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Medication'">
            <xsl:apply-templates select="." mode="Medication">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MedicationAdministration'">
            <xsl:apply-templates select="." mode="MedicationAdministration">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MedicationDispense'">
            <xsl:apply-templates select="." mode="MedicationDispense">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MedicationRequest'">
            <xsl:apply-templates select="." mode="MedicationRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MedicationStatement'">
            <xsl:apply-templates select="." mode="MedicationStatement">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MessageDefinition'">
            <xsl:apply-templates select="." mode="MessageDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'MessageHeader'">
            <xsl:apply-templates select="." mode="MessageHeader">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'NamingSystem'">
            <xsl:apply-templates select="." mode="NamingSystem">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'NutritionOrder'">
            <xsl:apply-templates select="." mode="NutritionOrder">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Observation'">
            <xsl:apply-templates select="." mode="Observation">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'OperationDefinition'">
            <xsl:apply-templates select="." mode="OperationDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'OperationOutcome'">
            <xsl:apply-templates select="." mode="OperationOutcome">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Organization'">
            <xsl:apply-templates select="." mode="Organization">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Patient'">
            <xsl:apply-templates select="." mode="Patient">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'PaymentNotice'">
            <xsl:apply-templates select="." mode="PaymentNotice">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'PaymentReconciliation'">
            <xsl:apply-templates select="." mode="PaymentReconciliation">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Person'">
            <xsl:apply-templates select="." mode="Person">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'PlanDefinition'">
            <xsl:apply-templates select="." mode="PlanDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Practitioner'">
            <xsl:apply-templates select="." mode="Practitioner">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'PractitionerRole'">
            <xsl:apply-templates select="." mode="PractitionerRole">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Procedure'">
            <xsl:apply-templates select="." mode="Procedure">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ProcedureRequest'">
            <xsl:apply-templates select="." mode="ProcedureRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ProcessRequest'">
            <xsl:apply-templates select="." mode="ProcessRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ProcessResponse'">
            <xsl:apply-templates select="." mode="ProcessResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Provenance'">
            <xsl:apply-templates select="." mode="Provenance">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Questionnaire'">
            <xsl:apply-templates select="." mode="Questionnaire">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'QuestionnaireResponse'">
            <xsl:apply-templates select="." mode="QuestionnaireResponse">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ReferralRequest'">
            <xsl:apply-templates select="." mode="ReferralRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'RelatedPerson'">
            <xsl:apply-templates select="." mode="RelatedPerson">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'RequestGroup'">
            <xsl:apply-templates select="." mode="RequestGroup">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ResearchStudy'">
            <xsl:apply-templates select="." mode="ResearchStudy">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ResearchSubject'">
            <xsl:apply-templates select="." mode="ResearchSubject">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'RiskAssessment'">
            <xsl:apply-templates select="." mode="RiskAssessment">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Schedule'">
            <xsl:apply-templates select="." mode="Schedule">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'SearchParameter'">
            <xsl:apply-templates select="." mode="SearchParameter">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Sequence'">
            <xsl:apply-templates select="." mode="Sequence">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ServiceDefinition'">
            <xsl:apply-templates select="." mode="ServiceDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Slot'">
            <xsl:apply-templates select="." mode="Slot">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Specimen'">
            <xsl:apply-templates select="." mode="Specimen">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'StructureDefinition'">
            <xsl:apply-templates select="." mode="StructureDefinition">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'StructureMap'">
            <xsl:apply-templates select="." mode="StructureMap">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Subscription'">
            <xsl:apply-templates select="." mode="Subscription">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Substance'">
            <xsl:apply-templates select="." mode="Substance">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'SupplyDelivery'">
            <xsl:apply-templates select="." mode="SupplyDelivery">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'SupplyRequest'">
            <xsl:apply-templates select="." mode="SupplyRequest">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Task'">
            <xsl:apply-templates select="." mode="Task">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'TestReport'">
            <xsl:apply-templates select="." mode="TestReport">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'TestScript'">
            <xsl:apply-templates select="." mode="TestScript">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'ValueSet'">
            <xsl:apply-templates select="." mode="ValueSet">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'VisionPrescription'">
            <xsl:apply-templates select="." mode="VisionPrescription">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:when test="$theName = 'Parameters'">
            <xsl:apply-templates select="." mode="Parameters">
               <xsl:with-param name="key" select="$theName"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:message terminate="yes">Unknown resourceType <xsl:value-of select="fn:string[@key = 'resourceType']"/>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A date or partial date (e.g. just year or year + month). There is no time zone. The format is a union of the schema types gYear, gYearMonth and date.  Dates SHALL be valid dates.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="date">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A date, date-time or partial date (e.g. just year or year + month).  If hours and minutes are specified, a time zone SHALL be populated. The format is a union of the schema types gYear, gYearMonth, date and dateTime. Seconds must be provided due to schema type constraints but may be zero-filled and may be ignored.                 Dates SHALL be valid dates.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="dateTime">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A string which has at least one character and no leading or trailing whitespace and where there is no whitespace other than single spaces in the contents</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="code">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A sequence of Unicode characters</xd:p>
         <xd:p>Note that FHIR strings may not exceed 1MB in size</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="string">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A whole number</xd:p>
         <xd:p>32 bit number; for values larger than this, use decimal</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="integer">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An OID represented as a URI</xd:p>
         <xd:p>RFC 3001. See also ISO/IEC 8824:1990 €</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="oid">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>String of characters used to identify a name or a resource</xd:p>
         <xd:p>see http://en.wikipedia.org/wiki/Uniform_resource_identifier</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="uri">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A UUID, represented as a URI</xd:p>
         <xd:p>See The Open Group, CDE 1.1 Remote Procedure Call specification, Appendix A.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="uuid">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An instant in time - known at least to the second</xd:p>
         <xd:p>Note: This is intended for precisely observed times, typically system logs etc., and not human-reported times - for them, see date and dateTime below. Time zone is always required</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="instant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Value of "true" or "false"</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="boolean">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A stream of bytes</xd:p>
         <xd:p>A stream of bytes, base64 encoded</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="base64Binary">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An integer with a value that is not negative (e.g. &gt;= 0)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="unsignedInt">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A string that may contain markdown syntax for optional processing by a mark down presentation engine</xd:p>
         <xd:p>Systems are not required to have markdown support, and there is considerable variation in markdown syntax, so the text should be readable without markdown processing. The preferred markdown syntax is described here: http://daringfireball.net/projects/markdown/syntax (and tests here: http://daringfireball.net/projects/downloads/MarkdownTest_1.0.zip)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="markdown">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A time during the day, with no date specified</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="time">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Any combination of letters, numerals, "-" and ".", with a length limit of 64 characters.  (This might be an integer, an unprefixed OID, UUID or any other identifier pattern that meets these constraints.)  Ids are case-insensitive.</xd:p>
         <xd:p>RFC 4122</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="id">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An integer with a value that is positive (e.g. &gt;0)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="positiveInt">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A rational number with implicit precision</xd:p>
         <xd:p>Do not use a IEEE type floating point type, instead use something that works like a true decimal, with inbuilt precision (e.g. Java BigInteger)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="decimal">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ResourceContainer">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
      <!--Account 1..1 Account-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Account']]" mode="Account">
                  <xsl:with-param name="key" select="'Account'"/>
               </xsl:apply-templates>
               <!--ActivityDefinition 1..1 ActivityDefinition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ActivityDefinition']]"
                                    mode="ActivityDefinition">
                  <xsl:with-param name="key" select="'ActivityDefinition'"/>
               </xsl:apply-templates>
               <!--AdverseEvent 1..1 AdverseEvent-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'AdverseEvent']]"
                                    mode="AdverseEvent">
                  <xsl:with-param name="key" select="'AdverseEvent'"/>
               </xsl:apply-templates>
               <!--AllergyIntolerance 1..1 AllergyIntolerance-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'AllergyIntolerance']]"
                                    mode="AllergyIntolerance">
                  <xsl:with-param name="key" select="'AllergyIntolerance'"/>
               </xsl:apply-templates>
               <!--Appointment 1..1 Appointment-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Appointment']]"
                                    mode="Appointment">
                  <xsl:with-param name="key" select="'Appointment'"/>
               </xsl:apply-templates>
               <!--AppointmentResponse 1..1 AppointmentResponse-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'AppointmentResponse']]"
                                    mode="AppointmentResponse">
                  <xsl:with-param name="key" select="'AppointmentResponse'"/>
               </xsl:apply-templates>
               <!--AuditEvent 1..1 AuditEvent-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'AuditEvent']]"
                                    mode="AuditEvent">
                  <xsl:with-param name="key" select="'AuditEvent'"/>
               </xsl:apply-templates>
               <!--Basic 1..1 Basic-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Basic']]" mode="Basic">
                  <xsl:with-param name="key" select="'Basic'"/>
               </xsl:apply-templates>
               <!--Binary 1..1 Binary-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Binary']]" mode="Binary">
                  <xsl:with-param name="key" select="'Binary'"/>
               </xsl:apply-templates>
               <!--BodySite 1..1 BodySite-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'BodySite']]" mode="BodySite">
                  <xsl:with-param name="key" select="'BodySite'"/>
               </xsl:apply-templates>
               <!--Bundle 1..1 Bundle-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Bundle']]" mode="Bundle">
                  <xsl:with-param name="key" select="'Bundle'"/>
               </xsl:apply-templates>
               <!--CapabilityStatement 1..1 CapabilityStatement-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'CapabilityStatement']]"
                                    mode="CapabilityStatement">
                  <xsl:with-param name="key" select="'CapabilityStatement'"/>
               </xsl:apply-templates>
               <!--CarePlan 1..1 CarePlan-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'CarePlan']]" mode="CarePlan">
                  <xsl:with-param name="key" select="'CarePlan'"/>
               </xsl:apply-templates>
               <!--CareTeam 1..1 CareTeam-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'CareTeam']]" mode="CareTeam">
                  <xsl:with-param name="key" select="'CareTeam'"/>
               </xsl:apply-templates>
               <!--ChargeItem 1..1 ChargeItem-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ChargeItem']]"
                                    mode="ChargeItem">
                  <xsl:with-param name="key" select="'ChargeItem'"/>
               </xsl:apply-templates>
               <!--Claim 1..1 Claim-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Claim']]" mode="Claim">
                  <xsl:with-param name="key" select="'Claim'"/>
               </xsl:apply-templates>
               <!--ClaimResponse 1..1 ClaimResponse-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ClaimResponse']]"
                                    mode="ClaimResponse">
                  <xsl:with-param name="key" select="'ClaimResponse'"/>
               </xsl:apply-templates>
               <!--ClinicalImpression 1..1 ClinicalImpression-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ClinicalImpression']]"
                                    mode="ClinicalImpression">
                  <xsl:with-param name="key" select="'ClinicalImpression'"/>
               </xsl:apply-templates>
               <!--CodeSystem 1..1 CodeSystem-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'CodeSystem']]"
                                    mode="CodeSystem">
                  <xsl:with-param name="key" select="'CodeSystem'"/>
               </xsl:apply-templates>
               <!--Communication 1..1 Communication-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Communication']]"
                                    mode="Communication">
                  <xsl:with-param name="key" select="'Communication'"/>
               </xsl:apply-templates>
               <!--CommunicationRequest 1..1 CommunicationRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'CommunicationRequest']]"
                                    mode="CommunicationRequest">
                  <xsl:with-param name="key" select="'CommunicationRequest'"/>
               </xsl:apply-templates>
               <!--CompartmentDefinition 1..1 CompartmentDefinition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'CompartmentDefinition']]"
                                    mode="CompartmentDefinition">
                  <xsl:with-param name="key" select="'CompartmentDefinition'"/>
               </xsl:apply-templates>
               <!--Composition 1..1 Composition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Composition']]"
                                    mode="Composition">
                  <xsl:with-param name="key" select="'Composition'"/>
               </xsl:apply-templates>
               <!--ConceptMap 1..1 ConceptMap-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ConceptMap']]"
                                    mode="ConceptMap">
                  <xsl:with-param name="key" select="'ConceptMap'"/>
               </xsl:apply-templates>
               <!--Condition 1..1 Condition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Condition']]" mode="Condition">
                  <xsl:with-param name="key" select="'Condition'"/>
               </xsl:apply-templates>
               <!--Consent 1..1 Consent-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Consent']]" mode="Consent">
                  <xsl:with-param name="key" select="'Consent'"/>
               </xsl:apply-templates>
               <!--Contract 1..1 Contract-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Contract']]" mode="Contract">
                  <xsl:with-param name="key" select="'Contract'"/>
               </xsl:apply-templates>
               <!--Coverage 1..1 Coverage-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Coverage']]" mode="Coverage">
                  <xsl:with-param name="key" select="'Coverage'"/>
               </xsl:apply-templates>
               <!--DataElement 1..1 DataElement-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DataElement']]"
                                    mode="DataElement">
                  <xsl:with-param name="key" select="'DataElement'"/>
               </xsl:apply-templates>
               <!--DetectedIssue 1..1 DetectedIssue-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DetectedIssue']]"
                                    mode="DetectedIssue">
                  <xsl:with-param name="key" select="'DetectedIssue'"/>
               </xsl:apply-templates>
               <!--Device 1..1 Device-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Device']]" mode="Device">
                  <xsl:with-param name="key" select="'Device'"/>
               </xsl:apply-templates>
               <!--DeviceComponent 1..1 DeviceComponent-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DeviceComponent']]"
                                    mode="DeviceComponent">
                  <xsl:with-param name="key" select="'DeviceComponent'"/>
               </xsl:apply-templates>
               <!--DeviceMetric 1..1 DeviceMetric-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DeviceMetric']]"
                                    mode="DeviceMetric">
                  <xsl:with-param name="key" select="'DeviceMetric'"/>
               </xsl:apply-templates>
               <!--DeviceRequest 1..1 DeviceRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DeviceRequest']]"
                                    mode="DeviceRequest">
                  <xsl:with-param name="key" select="'DeviceRequest'"/>
               </xsl:apply-templates>
               <!--DeviceUseStatement 1..1 DeviceUseStatement-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DeviceUseStatement']]"
                                    mode="DeviceUseStatement">
                  <xsl:with-param name="key" select="'DeviceUseStatement'"/>
               </xsl:apply-templates>
               <!--DiagnosticReport 1..1 DiagnosticReport-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DiagnosticReport']]"
                                    mode="DiagnosticReport">
                  <xsl:with-param name="key" select="'DiagnosticReport'"/>
               </xsl:apply-templates>
               <!--DocumentManifest 1..1 DocumentManifest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DocumentManifest']]"
                                    mode="DocumentManifest">
                  <xsl:with-param name="key" select="'DocumentManifest'"/>
               </xsl:apply-templates>
               <!--DocumentReference 1..1 DocumentReference-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'DocumentReference']]"
                                    mode="DocumentReference">
                  <xsl:with-param name="key" select="'DocumentReference'"/>
               </xsl:apply-templates>
               <!--EligibilityRequest 1..1 EligibilityRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EligibilityRequest']]"
                                    mode="EligibilityRequest">
                  <xsl:with-param name="key" select="'EligibilityRequest'"/>
               </xsl:apply-templates>
               <!--EligibilityResponse 1..1 EligibilityResponse-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EligibilityResponse']]"
                                    mode="EligibilityResponse">
                  <xsl:with-param name="key" select="'EligibilityResponse'"/>
               </xsl:apply-templates>
               <!--Encounter 1..1 Encounter-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Encounter']]" mode="Encounter">
                  <xsl:with-param name="key" select="'Encounter'"/>
               </xsl:apply-templates>
               <!--Endpoint 1..1 Endpoint-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Endpoint']]" mode="Endpoint">
                  <xsl:with-param name="key" select="'Endpoint'"/>
               </xsl:apply-templates>
               <!--EnrollmentRequest 1..1 EnrollmentRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EnrollmentRequest']]"
                                    mode="EnrollmentRequest">
                  <xsl:with-param name="key" select="'EnrollmentRequest'"/>
               </xsl:apply-templates>
               <!--EnrollmentResponse 1..1 EnrollmentResponse-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EnrollmentResponse']]"
                                    mode="EnrollmentResponse">
                  <xsl:with-param name="key" select="'EnrollmentResponse'"/>
               </xsl:apply-templates>
               <!--EpisodeOfCare 1..1 EpisodeOfCare-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'EpisodeOfCare']]"
                                    mode="EpisodeOfCare">
                  <xsl:with-param name="key" select="'EpisodeOfCare'"/>
               </xsl:apply-templates>
               <!--ExpansionProfile 1..1 ExpansionProfile-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ExpansionProfile']]"
                                    mode="ExpansionProfile">
                  <xsl:with-param name="key" select="'ExpansionProfile'"/>
               </xsl:apply-templates>
               <!--ExplanationOfBenefit 1..1 ExplanationOfBenefit-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ExplanationOfBenefit']]"
                                    mode="ExplanationOfBenefit">
                  <xsl:with-param name="key" select="'ExplanationOfBenefit'"/>
               </xsl:apply-templates>
               <!--FamilyMemberHistory 1..1 FamilyMemberHistory-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'FamilyMemberHistory']]"
                                    mode="FamilyMemberHistory">
                  <xsl:with-param name="key" select="'FamilyMemberHistory'"/>
               </xsl:apply-templates>
               <!--Flag 1..1 Flag-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Flag']]" mode="Flag">
                  <xsl:with-param name="key" select="'Flag'"/>
               </xsl:apply-templates>
               <!--Goal 1..1 Goal-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Goal']]" mode="Goal">
                  <xsl:with-param name="key" select="'Goal'"/>
               </xsl:apply-templates>
               <!--GraphDefinition 1..1 GraphDefinition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'GraphDefinition']]"
                                    mode="GraphDefinition">
                  <xsl:with-param name="key" select="'GraphDefinition'"/>
               </xsl:apply-templates>
               <!--Group 1..1 Group-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Group']]" mode="Group">
                  <xsl:with-param name="key" select="'Group'"/>
               </xsl:apply-templates>
               <!--GuidanceResponse 1..1 GuidanceResponse-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'GuidanceResponse']]"
                                    mode="GuidanceResponse">
                  <xsl:with-param name="key" select="'GuidanceResponse'"/>
               </xsl:apply-templates>
               <!--HealthcareService 1..1 HealthcareService-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'HealthcareService']]"
                                    mode="HealthcareService">
                  <xsl:with-param name="key" select="'HealthcareService'"/>
               </xsl:apply-templates>
               <!--ImagingManifest 1..1 ImagingManifest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ImagingManifest']]"
                                    mode="ImagingManifest">
                  <xsl:with-param name="key" select="'ImagingManifest'"/>
               </xsl:apply-templates>
               <!--ImagingStudy 1..1 ImagingStudy-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ImagingStudy']]"
                                    mode="ImagingStudy">
                  <xsl:with-param name="key" select="'ImagingStudy'"/>
               </xsl:apply-templates>
               <!--Immunization 1..1 Immunization-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Immunization']]"
                                    mode="Immunization">
                  <xsl:with-param name="key" select="'Immunization'"/>
               </xsl:apply-templates>
               <!--ImmunizationRecommendation 1..1 ImmunizationRecommendation-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ImmunizationRecommendation']]"
                                    mode="ImmunizationRecommendation">
                  <xsl:with-param name="key" select="'ImmunizationRecommendation'"/>
               </xsl:apply-templates>
               <!--ImplementationGuide 1..1 ImplementationGuide-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ImplementationGuide']]"
                                    mode="ImplementationGuide">
                  <xsl:with-param name="key" select="'ImplementationGuide'"/>
               </xsl:apply-templates>
               <!--Library 1..1 Library-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Library']]" mode="Library">
                  <xsl:with-param name="key" select="'Library'"/>
               </xsl:apply-templates>
               <!--Linkage 1..1 Linkage-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Linkage']]" mode="Linkage">
                  <xsl:with-param name="key" select="'Linkage'"/>
               </xsl:apply-templates>
               <!--List 1..1 List-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'List']]" mode="List">
                  <xsl:with-param name="key" select="'List'"/>
               </xsl:apply-templates>
               <!--Location 1..1 Location-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Location']]" mode="Location">
                  <xsl:with-param name="key" select="'Location'"/>
               </xsl:apply-templates>
               <!--Measure 1..1 Measure-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Measure']]" mode="Measure">
                  <xsl:with-param name="key" select="'Measure'"/>
               </xsl:apply-templates>
               <!--MeasureReport 1..1 MeasureReport-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MeasureReport']]"
                                    mode="MeasureReport">
                  <xsl:with-param name="key" select="'MeasureReport'"/>
               </xsl:apply-templates>
               <!--Media 1..1 Media-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Media']]" mode="Media">
                  <xsl:with-param name="key" select="'Media'"/>
               </xsl:apply-templates>
               <!--Medication 1..1 Medication-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Medication']]"
                                    mode="Medication">
                  <xsl:with-param name="key" select="'Medication'"/>
               </xsl:apply-templates>
               <!--MedicationAdministration 1..1 MedicationAdministration-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MedicationAdministration']]"
                                    mode="MedicationAdministration">
                  <xsl:with-param name="key" select="'MedicationAdministration'"/>
               </xsl:apply-templates>
               <!--MedicationDispense 1..1 MedicationDispense-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MedicationDispense']]"
                                    mode="MedicationDispense">
                  <xsl:with-param name="key" select="'MedicationDispense'"/>
               </xsl:apply-templates>
               <!--MedicationRequest 1..1 MedicationRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MedicationRequest']]"
                                    mode="MedicationRequest">
                  <xsl:with-param name="key" select="'MedicationRequest'"/>
               </xsl:apply-templates>
               <!--MedicationStatement 1..1 MedicationStatement-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MedicationStatement']]"
                                    mode="MedicationStatement">
                  <xsl:with-param name="key" select="'MedicationStatement'"/>
               </xsl:apply-templates>
               <!--MessageDefinition 1..1 MessageDefinition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MessageDefinition']]"
                                    mode="MessageDefinition">
                  <xsl:with-param name="key" select="'MessageDefinition'"/>
               </xsl:apply-templates>
               <!--MessageHeader 1..1 MessageHeader-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'MessageHeader']]"
                                    mode="MessageHeader">
                  <xsl:with-param name="key" select="'MessageHeader'"/>
               </xsl:apply-templates>
               <!--NamingSystem 1..1 NamingSystem-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'NamingSystem']]"
                                    mode="NamingSystem">
                  <xsl:with-param name="key" select="'NamingSystem'"/>
               </xsl:apply-templates>
               <!--NutritionOrder 1..1 NutritionOrder-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'NutritionOrder']]"
                                    mode="NutritionOrder">
                  <xsl:with-param name="key" select="'NutritionOrder'"/>
               </xsl:apply-templates>
               <!--Observation 1..1 Observation-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Observation']]"
                                    mode="Observation">
                  <xsl:with-param name="key" select="'Observation'"/>
               </xsl:apply-templates>
               <!--OperationDefinition 1..1 OperationDefinition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'OperationDefinition']]"
                                    mode="OperationDefinition">
                  <xsl:with-param name="key" select="'OperationDefinition'"/>
               </xsl:apply-templates>
               <!--OperationOutcome 1..1 OperationOutcome-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'OperationOutcome']]"
                                    mode="OperationOutcome">
                  <xsl:with-param name="key" select="'OperationOutcome'"/>
               </xsl:apply-templates>
               <!--Organization 1..1 Organization-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Organization']]"
                                    mode="Organization">
                  <xsl:with-param name="key" select="'Organization'"/>
               </xsl:apply-templates>
               <!--Patient 1..1 Patient-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Patient']]" mode="Patient">
                  <xsl:with-param name="key" select="'Patient'"/>
               </xsl:apply-templates>
               <!--PaymentNotice 1..1 PaymentNotice-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'PaymentNotice']]"
                                    mode="PaymentNotice">
                  <xsl:with-param name="key" select="'PaymentNotice'"/>
               </xsl:apply-templates>
               <!--PaymentReconciliation 1..1 PaymentReconciliation-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'PaymentReconciliation']]"
                                    mode="PaymentReconciliation">
                  <xsl:with-param name="key" select="'PaymentReconciliation'"/>
               </xsl:apply-templates>
               <!--Person 1..1 Person-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Person']]" mode="Person">
                  <xsl:with-param name="key" select="'Person'"/>
               </xsl:apply-templates>
               <!--PlanDefinition 1..1 PlanDefinition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'PlanDefinition']]"
                                    mode="PlanDefinition">
                  <xsl:with-param name="key" select="'PlanDefinition'"/>
               </xsl:apply-templates>
               <!--Practitioner 1..1 Practitioner-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Practitioner']]"
                                    mode="Practitioner">
                  <xsl:with-param name="key" select="'Practitioner'"/>
               </xsl:apply-templates>
               <!--PractitionerRole 1..1 PractitionerRole-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'PractitionerRole']]"
                                    mode="PractitionerRole">
                  <xsl:with-param name="key" select="'PractitionerRole'"/>
               </xsl:apply-templates>
               <!--Procedure 1..1 Procedure-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Procedure']]" mode="Procedure">
                  <xsl:with-param name="key" select="'Procedure'"/>
               </xsl:apply-templates>
               <!--ProcedureRequest 1..1 ProcedureRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ProcedureRequest']]"
                                    mode="ProcedureRequest">
                  <xsl:with-param name="key" select="'ProcedureRequest'"/>
               </xsl:apply-templates>
               <!--ProcessRequest 1..1 ProcessRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ProcessRequest']]"
                                    mode="ProcessRequest">
                  <xsl:with-param name="key" select="'ProcessRequest'"/>
               </xsl:apply-templates>
               <!--ProcessResponse 1..1 ProcessResponse-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ProcessResponse']]"
                                    mode="ProcessResponse">
                  <xsl:with-param name="key" select="'ProcessResponse'"/>
               </xsl:apply-templates>
               <!--Provenance 1..1 Provenance-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Provenance']]"
                                    mode="Provenance">
                  <xsl:with-param name="key" select="'Provenance'"/>
               </xsl:apply-templates>
               <!--Questionnaire 1..1 Questionnaire-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Questionnaire']]"
                                    mode="Questionnaire">
                  <xsl:with-param name="key" select="'Questionnaire'"/>
               </xsl:apply-templates>
               <!--QuestionnaireResponse 1..1 QuestionnaireResponse-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'QuestionnaireResponse']]"
                                    mode="QuestionnaireResponse">
                  <xsl:with-param name="key" select="'QuestionnaireResponse'"/>
               </xsl:apply-templates>
               <!--ReferralRequest 1..1 ReferralRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ReferralRequest']]"
                                    mode="ReferralRequest">
                  <xsl:with-param name="key" select="'ReferralRequest'"/>
               </xsl:apply-templates>
               <!--RelatedPerson 1..1 RelatedPerson-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'RelatedPerson']]"
                                    mode="RelatedPerson">
                  <xsl:with-param name="key" select="'RelatedPerson'"/>
               </xsl:apply-templates>
               <!--RequestGroup 1..1 RequestGroup-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'RequestGroup']]"
                                    mode="RequestGroup">
                  <xsl:with-param name="key" select="'RequestGroup'"/>
               </xsl:apply-templates>
               <!--ResearchStudy 1..1 ResearchStudy-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ResearchStudy']]"
                                    mode="ResearchStudy">
                  <xsl:with-param name="key" select="'ResearchStudy'"/>
               </xsl:apply-templates>
               <!--ResearchSubject 1..1 ResearchSubject-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ResearchSubject']]"
                                    mode="ResearchSubject">
                  <xsl:with-param name="key" select="'ResearchSubject'"/>
               </xsl:apply-templates>
               <!--RiskAssessment 1..1 RiskAssessment-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'RiskAssessment']]"
                                    mode="RiskAssessment">
                  <xsl:with-param name="key" select="'RiskAssessment'"/>
               </xsl:apply-templates>
               <!--Schedule 1..1 Schedule-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Schedule']]" mode="Schedule">
                  <xsl:with-param name="key" select="'Schedule'"/>
               </xsl:apply-templates>
               <!--SearchParameter 1..1 SearchParameter-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'SearchParameter']]"
                                    mode="SearchParameter">
                  <xsl:with-param name="key" select="'SearchParameter'"/>
               </xsl:apply-templates>
               <!--Sequence 1..1 Sequence-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Sequence']]" mode="Sequence">
                  <xsl:with-param name="key" select="'Sequence'"/>
               </xsl:apply-templates>
               <!--ServiceDefinition 1..1 ServiceDefinition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ServiceDefinition']]"
                                    mode="ServiceDefinition">
                  <xsl:with-param name="key" select="'ServiceDefinition'"/>
               </xsl:apply-templates>
               <!--Slot 1..1 Slot-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Slot']]" mode="Slot">
                  <xsl:with-param name="key" select="'Slot'"/>
               </xsl:apply-templates>
               <!--Specimen 1..1 Specimen-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Specimen']]" mode="Specimen">
                  <xsl:with-param name="key" select="'Specimen'"/>
               </xsl:apply-templates>
               <!--StructureDefinition 1..1 StructureDefinition-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'StructureDefinition']]"
                                    mode="StructureDefinition">
                  <xsl:with-param name="key" select="'StructureDefinition'"/>
               </xsl:apply-templates>
               <!--StructureMap 1..1 StructureMap-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'StructureMap']]"
                                    mode="StructureMap">
                  <xsl:with-param name="key" select="'StructureMap'"/>
               </xsl:apply-templates>
               <!--Subscription 1..1 Subscription-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Subscription']]"
                                    mode="Subscription">
                  <xsl:with-param name="key" select="'Subscription'"/>
               </xsl:apply-templates>
               <!--Substance 1..1 Substance-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Substance']]" mode="Substance">
                  <xsl:with-param name="key" select="'Substance'"/>
               </xsl:apply-templates>
               <!--SupplyDelivery 1..1 SupplyDelivery-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'SupplyDelivery']]"
                                    mode="SupplyDelivery">
                  <xsl:with-param name="key" select="'SupplyDelivery'"/>
               </xsl:apply-templates>
               <!--SupplyRequest 1..1 SupplyRequest-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'SupplyRequest']]"
                                    mode="SupplyRequest">
                  <xsl:with-param name="key" select="'SupplyRequest'"/>
               </xsl:apply-templates>
               <!--Task 1..1 Task-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Task']]" mode="Task">
                  <xsl:with-param name="key" select="'Task'"/>
               </xsl:apply-templates>
               <!--TestReport 1..1 TestReport-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'TestReport']]"
                                    mode="TestReport">
                  <xsl:with-param name="key" select="'TestReport'"/>
               </xsl:apply-templates>
               <!--TestScript 1..1 TestScript-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'TestScript']]"
                                    mode="TestScript">
                  <xsl:with-param name="key" select="'TestScript'"/>
               </xsl:apply-templates>
               <!--ValueSet 1..1 ValueSet-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'ValueSet']]" mode="ValueSet">
                  <xsl:with-param name="key" select="'ValueSet'"/>
               </xsl:apply-templates>
               <!--VisionPrescription 1..1 VisionPrescription-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'VisionPrescription']]"
                                    mode="VisionPrescription">
                  <xsl:with-param name="key" select="'VisionPrescription'"/>
               </xsl:apply-templates>
               <!--Parameters 1..1 Parameters-->         <xsl:apply-templates select=".[*[@key = 'resourceType'][. = 'Parameters']]"
                                    mode="Parameters">
                  <xsl:with-param name="key" select="'Parameters'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Optional Extension Element - found in all resources.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Extension">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
        
           
               <!--valueBase64Binary 1..1 base64Binary-->    <xsl:apply-templates select="*[@key = 'valueBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'valueBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueBase64Binary'])][*[@key = '_valueBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_valueBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'valueBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueBoolean 1..1 boolean-->    <xsl:apply-templates select="*[@key = 'valueBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'valueBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueBoolean'])][*[@key = '_valueBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_valueBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'valueBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueCode 1..1 code-->    <xsl:apply-templates select="*[@key = 'valueCode']" mode="code">
                  <xsl:with-param name="key" select="'valueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueCode'])][*[@key = '_valueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_valueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'valueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueDate 1..1 date-->    <xsl:apply-templates select="*[@key = 'valueDate']" mode="date">
                  <xsl:with-param name="key" select="'valueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDate'])][*[@key = '_valueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'valueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'valueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'valueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDateTime'])][*[@key = '_valueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'valueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueDecimal 1..1 decimal-->    <xsl:apply-templates select="*[@key = 'valueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'valueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDecimal'])][*[@key = '_valueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'valueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueId 1..1 id-->    <xsl:apply-templates select="*[@key = 'valueId']" mode="id">
                  <xsl:with-param name="key" select="'valueId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueId'])][*[@key = '_valueId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueId"/>
                        <xsl:copy-of select="fn:map[@key = '_valueId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'valueId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueInstant 1..1 instant-->    <xsl:apply-templates select="*[@key = 'valueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'valueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueInstant'])][*[@key = '_valueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_valueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'valueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueInteger 1..1 integer-->    <xsl:apply-templates select="*[@key = 'valueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'valueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueInteger'])][*[@key = '_valueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_valueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'valueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueMarkdown 1..1 markdown-->    <xsl:apply-templates select="*[@key = 'valueMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'valueMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueMarkdown'])][*[@key = '_valueMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_valueMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'valueMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueOid 1..1 oid-->    <xsl:apply-templates select="*[@key = 'valueOid']" mode="oid">
                  <xsl:with-param name="key" select="'valueOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueOid'])][*[@key = '_valueOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueOid"/>
                        <xsl:copy-of select="fn:map[@key = '_valueOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'valueOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valuePositiveInt 1..1 positiveInt-->    <xsl:apply-templates select="*[@key = 'valuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'valuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valuePositiveInt'])][*[@key = '_valuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_valuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'valuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueString 1..1 string-->    <xsl:apply-templates select="*[@key = 'valueString']" mode="string">
                  <xsl:with-param name="key" select="'valueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueString'])][*[@key = '_valueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString"/>
                        <xsl:copy-of select="fn:map[@key = '_valueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'valueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueTime 1..1 time-->    <xsl:apply-templates select="*[@key = 'valueTime']" mode="time">
                  <xsl:with-param name="key" select="'valueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueTime'])][*[@key = '_valueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_valueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'valueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueUnsignedInt 1..1 unsignedInt-->    <xsl:apply-templates select="*[@key = 'valueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'valueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueUnsignedInt'])][*[@key = '_valueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_valueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'valueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueUri 1..1 uri-->    <xsl:apply-templates select="*[@key = 'valueUri']" mode="uri">
                  <xsl:with-param name="key" select="'valueUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueUri'])][*[@key = '_valueUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUri"/>
                        <xsl:copy-of select="fn:map[@key = '_valueUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'valueUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueAddress 1..1 Address-->    <xsl:apply-templates select="*[@key = 'valueAddress']" mode="Address">
                  <xsl:with-param name="key" select="'valueAddress'"/>
               </xsl:apply-templates>
               <!--valueAge 1..1 Age-->    <xsl:apply-templates select="*[@key = 'valueAge']" mode="Age">
                  <xsl:with-param name="key" select="'valueAge'"/>
               </xsl:apply-templates>
               <!--valueAnnotation 1..1 Annotation-->    <xsl:apply-templates select="*[@key = 'valueAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'valueAnnotation'"/>
               </xsl:apply-templates>
               <!--valueAttachment 1..1 Attachment-->    <xsl:apply-templates select="*[@key = 'valueAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'valueAttachment'"/>
               </xsl:apply-templates>
               <!--valueCodeableConcept 1..1 CodeableConcept-->    <xsl:apply-templates select="*[@key = 'valueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'valueCodeableConcept'"/>
               </xsl:apply-templates>
               <!--valueCoding 1..1 Coding-->    <xsl:apply-templates select="*[@key = 'valueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'valueCoding'"/>
               </xsl:apply-templates>
               <!--valueContactPoint 1..1 ContactPoint-->    <xsl:apply-templates select="*[@key = 'valueContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'valueContactPoint'"/>
               </xsl:apply-templates>
               <!--valueCount 1..1 Count-->    <xsl:apply-templates select="*[@key = 'valueCount']" mode="Count">
                  <xsl:with-param name="key" select="'valueCount'"/>
               </xsl:apply-templates>
               <!--valueDistance 1..1 Distance-->    <xsl:apply-templates select="*[@key = 'valueDistance']" mode="Distance">
                  <xsl:with-param name="key" select="'valueDistance'"/>
               </xsl:apply-templates>
               <!--valueDuration 1..1 Duration-->    <xsl:apply-templates select="*[@key = 'valueDuration']" mode="Duration">
                  <xsl:with-param name="key" select="'valueDuration'"/>
               </xsl:apply-templates>
               <!--valueHumanName 1..1 HumanName-->    <xsl:apply-templates select="*[@key = 'valueHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'valueHumanName'"/>
               </xsl:apply-templates>
               <!--valueIdentifier 1..1 Identifier-->    <xsl:apply-templates select="*[@key = 'valueIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'valueIdentifier'"/>
               </xsl:apply-templates>
               <!--valueMoney 1..1 Money-->    <xsl:apply-templates select="*[@key = 'valueMoney']" mode="Money">
                  <xsl:with-param name="key" select="'valueMoney'"/>
               </xsl:apply-templates>
               <!--valuePeriod 1..1 Period-->    <xsl:apply-templates select="*[@key = 'valuePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'valuePeriod'"/>
               </xsl:apply-templates>
               <!--valueQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'valueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'valueQuantity'"/>
               </xsl:apply-templates>
               <!--valueRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'valueRange']" mode="Range">
                  <xsl:with-param name="key" select="'valueRange'"/>
               </xsl:apply-templates>
               <!--valueRatio 1..1 Ratio-->    <xsl:apply-templates select="*[@key = 'valueRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'valueRatio'"/>
               </xsl:apply-templates>
               <!--valueReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'valueReference']" mode="Reference">
                  <xsl:with-param name="key" select="'valueReference'"/>
               </xsl:apply-templates>
               <!--valueSampledData 1..1 SampledData-->    <xsl:apply-templates select="*[@key = 'valueSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'valueSampledData'"/>
               </xsl:apply-templates>
               <!--valueSignature 1..1 Signature-->    <xsl:apply-templates select="*[@key = 'valueSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'valueSignature'"/>
               </xsl:apply-templates>
               <!--valueTiming 1..1 Timing-->    <xsl:apply-templates select="*[@key = 'valueTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'valueTiming'"/>
               </xsl:apply-templates>
               <!--valueMeta 1..1 Meta-->    <xsl:apply-templates select="*[@key = 'valueMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'valueMeta'"/>
               </xsl:apply-templates>
         
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'url']">
                        <xsl:attribute name="url" select="*[@key = 'url']"/>
                     </xsl:if>
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Base definition for all elements that are defined inside a resource - but not those in a data type.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="BackboneElement">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--modifierExtension 0..* Extension-->     <xsl:apply-templates select="*[@key = 'modifierExtension']" mode="Extension">
                  <xsl:with-param name="key" select="'modifierExtension'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A human-readable formatted text, including images.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Narrative">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--status 1..1 NarrativeStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="NarrativeStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="NarrativeStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--xhtml:div 1..1 -->     <xsl:for-each select="*[@key = 'div']">
                  <xsl:variable name="div" select="fn:parse-xml(.)/*" as="element()?"/>
                  <xsl:if test="$div">
                     <xsl:element name="{local-name($div)}" namespace="{fn:namespace-uri($div)}">
                        <xsl:copy-of select="$div/node()"/>
                     </xsl:element>
                  </xsl:if>
               </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of a resource narrative</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="NarrativeStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Base definition for all elements in a resource.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Element">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
          <!--extension 0..* Extension-->     <xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference from one resource to another.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Reference">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--reference 0..1 string-->     <xsl:apply-templates select="*[@key = 'reference']" mode="string">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'reference'])][*[@key = '_reference']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="reference"/>
                        <xsl:copy-of select="fn:map[@key = '_reference']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'reference'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--display 0..1 string-->     <xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A measured amount (or an amount that can potentially be measured). Note that measured amounts include amounts that are not precisely quantified, including amounts involving arbitrary units and floating currencies.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Quantity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--value 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--comparator 0..1 QuantityComparator-->     <xsl:apply-templates select="*[@key = 'comparator']" mode="QuantityComparator">
                  <xsl:with-param name="key" select="'comparator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comparator'])][*[@key = '_comparator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator"/>
                        <xsl:copy-of select="fn:map[@key = '_comparator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="QuantityComparator">
                     <xsl:with-param name="key" select="'comparator'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--unit 0..1 string-->     <xsl:apply-templates select="*[@key = 'unit']" mode="string">
                  <xsl:with-param name="key" select="'unit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'unit'])][*[@key = '_unit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit"/>
                        <xsl:copy-of select="fn:map[@key = '_unit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'unit'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--system 0..1 uri-->     <xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How the Quantity should be understood and represented.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="QuantityComparator">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A time period defined by a start and end date and optionally time.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Period">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--start 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'start']" mode="dateTime">
                  <xsl:with-param name="key" select="'start'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'start'])][*[@key = '_start']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="start"/>
                        <xsl:copy-of select="fn:map[@key = '_start']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'start'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--end 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'end']" mode="dateTime">
                  <xsl:with-param name="key" select="'end'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'end'])][*[@key = '_end']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="end"/>
                        <xsl:copy-of select="fn:map[@key = '_end']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'end'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>For referring to data content defined in other formats.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Attachment">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--contentType 0..1 code-->     <xsl:apply-templates select="*[@key = 'contentType']" mode="code">
                  <xsl:with-param name="key" select="'contentType'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentType'])][*[@key = '_contentType']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType"/>
                        <xsl:copy-of select="fn:map[@key = '_contentType']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'contentType'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--language 0..1 code-->     <xsl:apply-templates select="*[@key = 'language']" mode="code">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'language'])][*[@key = '_language']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="language"/>
                        <xsl:copy-of select="fn:map[@key = '_language']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'language'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--data 0..1 base64Binary-->     <xsl:apply-templates select="*[@key = 'data']" mode="base64Binary">
                  <xsl:with-param name="key" select="'data'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'data'])][*[@key = '_data']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="data"/>
                        <xsl:copy-of select="fn:map[@key = '_data']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'data'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--url 0..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--size 0..1 unsignedInt-->     <xsl:apply-templates select="*[@key = 'size']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'size'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'size'])][*[@key = '_size']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="size"/>
                        <xsl:copy-of select="fn:map[@key = '_size']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'size'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--hash 0..1 base64Binary-->     <xsl:apply-templates select="*[@key = 'hash']" mode="base64Binary">
                  <xsl:with-param name="key" select="'hash'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'hash'])][*[@key = '_hash']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="hash"/>
                        <xsl:copy-of select="fn:map[@key = '_hash']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'hash'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--title 0..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--creation 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'creation']" mode="dateTime">
                  <xsl:with-param name="key" select="'creation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'creation'])][*[@key = '_creation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="creation"/>
                        <xsl:copy-of select="fn:map[@key = '_creation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'creation'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A length of time.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Duration">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select="." mode="Quantity">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A measured amount (or an amount that can potentially be measured). Note that measured amounts include amounts that are not precisely quantified, including amounts involving arbitrary units and floating currencies.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Count">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select="." mode="Quantity">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of ordered Quantities defined by a low and high limit.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Range">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--low 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'low']" mode="Quantity">
                  <xsl:with-param name="key" select="'low'"/>
               </xsl:apply-templates>
               <!--high 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'high']" mode="Quantity">
                  <xsl:with-param name="key" select="'high'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A  text note which also  contains information about who made the statement and when.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Annotation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
          
            
               <!--authorReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'authorReference']" mode="Reference">
                  <xsl:with-param name="key" select="'authorReference'"/>
               </xsl:apply-templates>
               <!--authorString 1..1 string-->    <xsl:apply-templates select="*[@key = 'authorString']" mode="string">
                  <xsl:with-param name="key" select="'authorString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'authorString'])][*[@key = '_authorString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="authorString"/>
                        <xsl:copy-of select="fn:map[@key = '_authorString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'authorString'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
               <!--time 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'time']" mode="dateTime">
                  <xsl:with-param name="key" select="'time'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'time'])][*[@key = '_time']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="time"/>
                        <xsl:copy-of select="fn:map[@key = '_time']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'time'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--text 1..1 string-->     <xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An amount of economic utility in some recognized currency.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Money">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select="." mode="Quantity">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A technical identifier - identifies some entity uniquely and unambiguously.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Identifier">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--use 0..1 IdentifierUse-->     <xsl:apply-templates select="*[@key = 'use']" mode="IdentifierUse">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="IdentifierUse">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--system 0..1 uri-->     <xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--value 0..1 string-->     <xsl:apply-templates select="*[@key = 'value']" mode="string">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <!--assigner 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'assigner']" mode="Reference">
                  <xsl:with-param name="key" select="'assigner'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Identifies the purpose for this identifier, if known .</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="IdentifierUse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a code defined by a terminology system.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Coding">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--system 0..1 uri-->     <xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--version 0..1 string-->     <xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--display 0..1 string-->     <xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--userSelected 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'userSelected']" mode="boolean">
                  <xsl:with-param name="key" select="'userSelected'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'userSelected'])][*[@key = '_userSelected']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="userSelected"/>
                        <xsl:copy-of select="fn:map[@key = '_userSelected']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'userSelected'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A digital signature along with supporting context. The signature may be electronic/cryptographic in nature, or a graphical image representing a hand-written signature, or a signature process. Different signature approaches have different utilities.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Signature">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--type 1..* Coding-->     <xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--when 1..1 instant-->     <xsl:apply-templates select="*[@key = 'when']" mode="instant">
                  <xsl:with-param name="key" select="'when'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'when'])][*[@key = '_when']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="when"/>
                        <xsl:copy-of select="fn:map[@key = '_when']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'when'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--whoUri 1..1 uri-->    <xsl:apply-templates select="*[@key = 'whoUri']" mode="uri">
                  <xsl:with-param name="key" select="'whoUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'whoUri'])][*[@key = '_whoUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="whoUri"/>
                        <xsl:copy-of select="fn:map[@key = '_whoUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'whoUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--whoReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'whoReference']" mode="Reference">
                  <xsl:with-param name="key" select="'whoReference'"/>
               </xsl:apply-templates>
          
          
            
               <!--onBehalfOfUri 1..1 uri-->    <xsl:apply-templates select="*[@key = 'onBehalfOfUri']" mode="uri">
                  <xsl:with-param name="key" select="'onBehalfOfUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onBehalfOfUri'])][*[@key = '_onBehalfOfUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onBehalfOfUri"/>
                        <xsl:copy-of select="fn:map[@key = '_onBehalfOfUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'onBehalfOfUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--onBehalfOfReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'onBehalfOfReference']" mode="Reference">
                  <xsl:with-param name="key" select="'onBehalfOfReference'"/>
               </xsl:apply-templates>
          
               <!--contentType 0..1 code-->     <xsl:apply-templates select="*[@key = 'contentType']" mode="code">
                  <xsl:with-param name="key" select="'contentType'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentType'])][*[@key = '_contentType']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType"/>
                        <xsl:copy-of select="fn:map[@key = '_contentType']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'contentType'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--blob 0..1 base64Binary-->     <xsl:apply-templates select="*[@key = 'blob']" mode="base64Binary">
                  <xsl:with-param name="key" select="'blob'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'blob'])][*[@key = '_blob']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="blob"/>
                        <xsl:copy-of select="fn:map[@key = '_blob']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'blob'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A series of measurements taken by a device, with upper and lower limits. There may be more than one dimension in the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SampledData">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--origin 1..1 Quantity-->     <xsl:apply-templates select="*[@key = 'origin']" mode="Quantity">
                  <xsl:with-param name="key" select="'origin'"/>
               </xsl:apply-templates>
               <!--period 1..1 decimal-->     <xsl:apply-templates select="*[@key = 'period']" mode="decimal">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'period'])][*[@key = '_period']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="period"/>
                        <xsl:copy-of select="fn:map[@key = '_period']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'period'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--factor 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--lowerLimit 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'lowerLimit']" mode="decimal">
                  <xsl:with-param name="key" select="'lowerLimit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lowerLimit'])][*[@key = '_lowerLimit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lowerLimit"/>
                        <xsl:copy-of select="fn:map[@key = '_lowerLimit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'lowerLimit'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--upperLimit 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'upperLimit']" mode="decimal">
                  <xsl:with-param name="key" select="'upperLimit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'upperLimit'])][*[@key = '_upperLimit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="upperLimit"/>
                        <xsl:copy-of select="fn:map[@key = '_upperLimit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'upperLimit'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--dimensions 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'dimensions']" mode="positiveInt">
                  <xsl:with-param name="key" select="'dimensions'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'dimensions'])][*[@key = '_dimensions']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="dimensions"/>
                        <xsl:copy-of select="fn:map[@key = '_dimensions']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'dimensions'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--data 1..1 SampledDataDataType-->     <xsl:apply-templates select="*[@key = 'data']" mode="SampledDataDataType">
                  <xsl:with-param name="key" select="'data'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'data'])][*[@key = '_data']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="data"/>
                        <xsl:copy-of select="fn:map[@key = '_data']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SampledDataDataType">
                     <xsl:with-param name="key" select="'data'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SampledDataDataType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A relationship of two Quantity values - expressed as a numerator and a denominator.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Ratio">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--numerator 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'numerator']" mode="Quantity">
                  <xsl:with-param name="key" select="'numerator'"/>
               </xsl:apply-templates>
               <!--denominator 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'denominator']" mode="Quantity">
                  <xsl:with-param name="key" select="'denominator'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A length - a value with a unit that is a physical distance.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Distance">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select="." mode="Quantity">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A duration of time during which an organism (or a process) has existed.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Age">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select="." mode="Quantity">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A concept that may be defined by a formal reference to a terminology or ontology or may be provided by text.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeableConcept">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--coding 0..* Coding-->     <xsl:apply-templates select="*[@key = 'coding']" mode="Coding">
                  <xsl:with-param name="key" select="'coding'"/>
               </xsl:apply-templates>
               <!--text 0..1 string-->     <xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The metadata about a resource. This is content in the resource that is maintained by the infrastructure. Changes to the content may not always be associated with version changes to the resource.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Meta">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--versionId 0..1 id-->     <xsl:apply-templates select="*[@key = 'versionId']" mode="id">
                  <xsl:with-param name="key" select="'versionId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'versionId'])][*[@key = '_versionId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="versionId"/>
                        <xsl:copy-of select="fn:map[@key = '_versionId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'versionId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--lastUpdated 0..1 instant-->     <xsl:apply-templates select="*[@key = 'lastUpdated']" mode="instant">
                  <xsl:with-param name="key" select="'lastUpdated'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lastUpdated'])][*[@key = '_lastUpdated']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastUpdated"/>
                        <xsl:copy-of select="fn:map[@key = '_lastUpdated']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'lastUpdated'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--profile 0..* uri-->     <xsl:apply-templates select="*[@key = 'profile']" mode="uri">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'profile'])][*[@key = '_profile']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="profile"/>
                        <xsl:copy-of select="fn:map[@key = '_profile']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'profile'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--security 0..* Coding-->     <xsl:apply-templates select="*[@key = 'security']" mode="Coding">
                  <xsl:with-param name="key" select="'security'"/>
               </xsl:apply-templates>
               <!--tag 0..* Coding-->     <xsl:apply-templates select="*[@key = 'tag']" mode="Coding">
                  <xsl:with-param name="key" select="'tag'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An address expressed using postal conventions (as opposed to GPS or other location definition formats).  This data type may be used to convey addresses for use in delivering mail as well as for visiting locations which might not be valid for mail delivery.  There are a variety of postal address formats defined around the world.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Address">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--use 0..1 AddressUse-->     <xsl:apply-templates select="*[@key = 'use']" mode="AddressUse">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AddressUse">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 AddressType-->     <xsl:apply-templates select="*[@key = 'type']" mode="AddressType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AddressType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--text 0..1 string-->     <xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--line 0..* string-->     <xsl:apply-templates select="*[@key = 'line']" mode="string">
                  <xsl:with-param name="key" select="'line'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'line'])][*[@key = '_line']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="line"/>
                        <xsl:copy-of select="fn:map[@key = '_line']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'line'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--city 0..1 string-->     <xsl:apply-templates select="*[@key = 'city']" mode="string">
                  <xsl:with-param name="key" select="'city'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'city'])][*[@key = '_city']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="city"/>
                        <xsl:copy-of select="fn:map[@key = '_city']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'city'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--district 0..1 string-->     <xsl:apply-templates select="*[@key = 'district']" mode="string">
                  <xsl:with-param name="key" select="'district'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'district'])][*[@key = '_district']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="district"/>
                        <xsl:copy-of select="fn:map[@key = '_district']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'district'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--state 0..1 string-->     <xsl:apply-templates select="*[@key = 'state']" mode="string">
                  <xsl:with-param name="key" select="'state'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'state'])][*[@key = '_state']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="state"/>
                        <xsl:copy-of select="fn:map[@key = '_state']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'state'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--postalCode 0..1 string-->     <xsl:apply-templates select="*[@key = 'postalCode']" mode="string">
                  <xsl:with-param name="key" select="'postalCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'postalCode'])][*[@key = '_postalCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="postalCode"/>
                        <xsl:copy-of select="fn:map[@key = '_postalCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'postalCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--country 0..1 string-->     <xsl:apply-templates select="*[@key = 'country']" mode="string">
                  <xsl:with-param name="key" select="'country'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'country'])][*[@key = '_country']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="country"/>
                        <xsl:copy-of select="fn:map[@key = '_country']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'country'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The use of an address</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AddressUse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of an address (physical / postal)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AddressType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A description of a triggering event.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="TriggerDefinition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--type 1..1 TriggerType-->     <xsl:apply-templates select="*[@key = 'type']" mode="TriggerType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="TriggerType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--eventName 0..1 string-->     <xsl:apply-templates select="*[@key = 'eventName']" mode="string">
                  <xsl:with-param name="key" select="'eventName'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'eventName'])][*[@key = '_eventName']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="eventName"/>
                        <xsl:copy-of select="fn:map[@key = '_eventName']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'eventName'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--eventTimingTiming 1..1 Timing-->    <xsl:apply-templates select="*[@key = 'eventTimingTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'eventTimingTiming'"/>
               </xsl:apply-templates>
               <!--eventTimingReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'eventTimingReference']" mode="Reference">
                  <xsl:with-param name="key" select="'eventTimingReference'"/>
               </xsl:apply-templates>
               <!--eventTimingDate 1..1 date-->    <xsl:apply-templates select="*[@key = 'eventTimingDate']" mode="date">
                  <xsl:with-param name="key" select="'eventTimingDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'eventTimingDate'])][*[@key = '_eventTimingDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="eventTimingDate"/>
                        <xsl:copy-of select="fn:map[@key = '_eventTimingDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'eventTimingDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--eventTimingDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'eventTimingDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'eventTimingDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'eventTimingDateTime'])][*[@key = '_eventTimingDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="eventTimingDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_eventTimingDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'eventTimingDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
               <!--eventData 0..1 DataRequirement-->     <xsl:apply-templates select="*[@key = 'eventData']" mode="DataRequirement">
                  <xsl:with-param name="key" select="'eventData'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of trigger</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="TriggerType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A contributor to the content of a knowledge asset, including authors, editors, reviewers, and endorsers.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Contributor">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--type 1..1 ContributorType-->     <xsl:apply-templates select="*[@key = 'type']" mode="ContributorType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ContributorType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--name 1..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--contact 0..* ContactDetail-->     <xsl:apply-templates select="*[@key = 'contact']" mode="ContactDetail">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of contributor</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ContributorType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a required data item for evaluation in terms of the type of data, and optional code or date-based filters of the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DataRequirement">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--type 1..1 code-->     <xsl:apply-templates select="*[@key = 'type']" mode="code">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--profile 0..* uri-->     <xsl:apply-templates select="*[@key = 'profile']" mode="uri">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'profile'])][*[@key = '_profile']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="profile"/>
                        <xsl:copy-of select="fn:map[@key = '_profile']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'profile'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--mustSupport 0..* string-->     <xsl:apply-templates select="*[@key = 'mustSupport']" mode="string">
                  <xsl:with-param name="key" select="'mustSupport'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mustSupport'])][*[@key = '_mustSupport']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mustSupport"/>
                        <xsl:copy-of select="fn:map[@key = '_mustSupport']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'mustSupport'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--codeFilter 0..* DataRequirement.CodeFilter-->     <xsl:apply-templates select="*[@key = 'codeFilter']" mode="DataRequirement.CodeFilter">
                  <xsl:with-param name="key" select="'codeFilter'"/>
               </xsl:apply-templates>
               <!--dateFilter 0..* DataRequirement.DateFilter-->     <xsl:apply-templates select="*[@key = 'dateFilter']" mode="DataRequirement.DateFilter">
                  <xsl:with-param name="key" select="'dateFilter'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a required data item for evaluation in terms of the type of data, and optional code or date-based filters of the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DataRequirement.CodeFilter">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--path 1..1 string-->     <xsl:apply-templates select="*[@key = 'path']" mode="string">
                  <xsl:with-param name="key" select="'path'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'path'])][*[@key = '_path']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="path"/>
                        <xsl:copy-of select="fn:map[@key = '_path']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'path'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--valueSetString 1..1 string-->    <xsl:apply-templates select="*[@key = 'valueSetString']" mode="string">
                  <xsl:with-param name="key" select="'valueSetString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueSetString'])][*[@key = '_valueSetString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetString"/>
                        <xsl:copy-of select="fn:map[@key = '_valueSetString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'valueSetString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueSetReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'valueSetReference']" mode="Reference">
                  <xsl:with-param name="key" select="'valueSetReference'"/>
               </xsl:apply-templates>
          
               <!--valueCode 0..* code-->     <xsl:apply-templates select="*[@key = 'valueCode']" mode="code">
                  <xsl:with-param name="key" select="'valueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueCode'])][*[@key = '_valueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_valueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'valueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueCoding 0..* Coding-->     <xsl:apply-templates select="*[@key = 'valueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'valueCoding'"/>
               </xsl:apply-templates>
               <!--valueCodeableConcept 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'valueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'valueCodeableConcept'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a required data item for evaluation in terms of the type of data, and optional code or date-based filters of the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DataRequirement.DateFilter">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--path 1..1 string-->     <xsl:apply-templates select="*[@key = 'path']" mode="string">
                  <xsl:with-param name="key" select="'path'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'path'])][*[@key = '_path']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="path"/>
                        <xsl:copy-of select="fn:map[@key = '_path']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'path'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--valueDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'valueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'valueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDateTime'])][*[@key = '_valueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'valueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valuePeriod 1..1 Period-->    <xsl:apply-templates select="*[@key = 'valuePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'valuePeriod'"/>
               </xsl:apply-templates>
               <!--valueDuration 1..1 Duration-->    <xsl:apply-templates select="*[@key = 'valueDuration']" mode="Duration">
                  <xsl:with-param name="key" select="'valueDuration'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates how the medication is/was taken or should be taken by the patient.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Dosage">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--sequence 0..1 integer-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="integer">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--text 0..1 string-->     <xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--additionalInstruction 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'additionalInstruction']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'additionalInstruction'"/>
               </xsl:apply-templates>
               <!--patientInstruction 0..1 string-->     <xsl:apply-templates select="*[@key = 'patientInstruction']" mode="string">
                  <xsl:with-param name="key" select="'patientInstruction'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patientInstruction'])][*[@key = '_patientInstruction']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patientInstruction"/>
                        <xsl:copy-of select="fn:map[@key = '_patientInstruction']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'patientInstruction'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--timing 0..1 Timing-->     <xsl:apply-templates select="*[@key = 'timing']" mode="Timing">
                  <xsl:with-param name="key" select="'timing'"/>
               </xsl:apply-templates>
          
            
               <!--asNeededBoolean 1..1 boolean-->    <xsl:apply-templates select="*[@key = 'asNeededBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'asNeededBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'asNeededBoolean'])][*[@key = '_asNeededBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="asNeededBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_asNeededBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'asNeededBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--asNeededCodeableConcept 1..1 CodeableConcept-->    <xsl:apply-templates select="*[@key = 'asNeededCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'asNeededCodeableConcept'"/>
               </xsl:apply-templates>
          
               <!--site 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'site']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'site'"/>
               </xsl:apply-templates>
               <!--route 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'route']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'route'"/>
               </xsl:apply-templates>
               <!--method 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'method']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'method'"/>
               </xsl:apply-templates>
          
            
               <!--doseRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'doseRange']" mode="Range">
                  <xsl:with-param name="key" select="'doseRange'"/>
               </xsl:apply-templates>
               <!--doseQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'doseQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'doseQuantity'"/>
               </xsl:apply-templates>
          
               <!--maxDosePerPeriod 0..1 Ratio-->     <xsl:apply-templates select="*[@key = 'maxDosePerPeriod']" mode="Ratio">
                  <xsl:with-param name="key" select="'maxDosePerPeriod'"/>
               </xsl:apply-templates>
               <!--maxDosePerAdministration 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'maxDosePerAdministration']" mode="Quantity">
                  <xsl:with-param name="key" select="'maxDosePerAdministration'"/>
               </xsl:apply-templates>
               <!--maxDosePerLifetime 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'maxDosePerLifetime']" mode="Quantity">
                  <xsl:with-param name="key" select="'maxDosePerLifetime'"/>
               </xsl:apply-templates>
          
            
               <!--rateRatio 1..1 Ratio-->    <xsl:apply-templates select="*[@key = 'rateRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'rateRatio'"/>
               </xsl:apply-templates>
               <!--rateRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'rateRange']" mode="Range">
                  <xsl:with-param name="key" select="'rateRange'"/>
               </xsl:apply-templates>
               <!--rateQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'rateQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'rateQuantity'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Related artifacts such as additional documentation, justification, or bibliographic references.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="RelatedArtifact">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--type 1..1 RelatedArtifactType-->     <xsl:apply-templates select="*[@key = 'type']" mode="RelatedArtifactType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="RelatedArtifactType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--display 0..1 string-->     <xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--citation 0..1 string-->     <xsl:apply-templates select="*[@key = 'citation']" mode="string">
                  <xsl:with-param name="key" select="'citation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'citation'])][*[@key = '_citation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="citation"/>
                        <xsl:copy-of select="fn:map[@key = '_citation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'citation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--url 0..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--document 0..1 Attachment-->     <xsl:apply-templates select="*[@key = 'document']" mode="Attachment">
                  <xsl:with-param name="key" select="'document'"/>
               </xsl:apply-templates>
               <!--resource 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'resource']" mode="Reference">
                  <xsl:with-param name="key" select="'resource'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of relationship to the related artifact</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="RelatedArtifactType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies contact information for a person or organization.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ContactDetail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--telecom 0..* ContactPoint-->     <xsl:apply-templates select="*[@key = 'telecom']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'telecom'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A human's name with the ability to identify parts and usage.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="HumanName">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--use 0..1 NameUse-->     <xsl:apply-templates select="*[@key = 'use']" mode="NameUse">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="NameUse">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--text 0..1 string-->     <xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--family 0..1 string-->     <xsl:apply-templates select="*[@key = 'family']" mode="string">
                  <xsl:with-param name="key" select="'family'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'family'])][*[@key = '_family']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="family"/>
                        <xsl:copy-of select="fn:map[@key = '_family']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'family'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--given 0..* string-->     <xsl:apply-templates select="*[@key = 'given']" mode="string">
                  <xsl:with-param name="key" select="'given'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'given'])][*[@key = '_given']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="given"/>
                        <xsl:copy-of select="fn:map[@key = '_given']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'given'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--prefix 0..* string-->     <xsl:apply-templates select="*[@key = 'prefix']" mode="string">
                  <xsl:with-param name="key" select="'prefix'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'prefix'])][*[@key = '_prefix']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="prefix"/>
                        <xsl:copy-of select="fn:map[@key = '_prefix']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'prefix'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--suffix 0..* string-->     <xsl:apply-templates select="*[@key = 'suffix']" mode="string">
                  <xsl:with-param name="key" select="'suffix'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'suffix'])][*[@key = '_suffix']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="suffix"/>
                        <xsl:copy-of select="fn:map[@key = '_suffix']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'suffix'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The use of a human name</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="NameUse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Details for all kinds of technology mediated contact points for a person or organization, including telephone, email, etc.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ContactPoint">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--system 0..1 ContactPointSystem-->     <xsl:apply-templates select="*[@key = 'system']" mode="ContactPointSystem">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ContactPointSystem">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--value 0..1 string-->     <xsl:apply-templates select="*[@key = 'value']" mode="string">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--use 0..1 ContactPointUse-->     <xsl:apply-templates select="*[@key = 'use']" mode="ContactPointUse">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ContactPointUse">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--rank 0..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'rank']" mode="positiveInt">
                  <xsl:with-param name="key" select="'rank'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'rank'])][*[@key = '_rank']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="rank"/>
                        <xsl:copy-of select="fn:map[@key = '_rank']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'rank'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Telecommunications form for contact point</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ContactPointSystem">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use of contact point</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ContactPointUse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies clinical/business/etc metadata that can be used to retrieve, index and/or categorize an artifact. This metadata can either be specific to the applicable population (e.g., age category, DRG) or the specific context of care (e.g., venue, care setting, provider of care).</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="UsageContext">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--code 1..1 Coding-->     <xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
          
            
               <!--valueCodeableConcept 1..1 CodeableConcept-->    <xsl:apply-templates select="*[@key = 'valueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'valueCodeableConcept'"/>
               </xsl:apply-templates>
               <!--valueQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'valueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'valueQuantity'"/>
               </xsl:apply-templates>
               <!--valueRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'valueRange']" mode="Range">
                  <xsl:with-param name="key" select="'valueRange'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies an event that may occur multiple times. Timing schedules are used to record when things are planned, expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds, and may be used for reporting the schedule to which past regular activities were carried out.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Timing">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--event 0..* dateTime-->     <xsl:apply-templates select="*[@key = 'event']" mode="dateTime">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'event'])][*[@key = '_event']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="event"/>
                        <xsl:copy-of select="fn:map[@key = '_event']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'event'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--repeat 0..1 Timing.Repeat-->     <xsl:apply-templates select="*[@key = 'repeat']" mode="Timing.Repeat">
                  <xsl:with-param name="key" select="'repeat'"/>
               </xsl:apply-templates>
               <!--code 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies an event that may occur multiple times. Timing schedules are used to record when things are planned, expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds, and may be used for reporting the schedule to which past regular activities were carried out.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Timing.Repeat">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
          
            
               <!--boundsDuration 1..1 Duration-->    <xsl:apply-templates select="*[@key = 'boundsDuration']" mode="Duration">
                  <xsl:with-param name="key" select="'boundsDuration'"/>
               </xsl:apply-templates>
               <!--boundsRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'boundsRange']" mode="Range">
                  <xsl:with-param name="key" select="'boundsRange'"/>
               </xsl:apply-templates>
               <!--boundsPeriod 1..1 Period-->    <xsl:apply-templates select="*[@key = 'boundsPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'boundsPeriod'"/>
               </xsl:apply-templates>
          
               <!--count 0..1 integer-->     <xsl:apply-templates select="*[@key = 'count']" mode="integer">
                  <xsl:with-param name="key" select="'count'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'count'])][*[@key = '_count']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="count"/>
                        <xsl:copy-of select="fn:map[@key = '_count']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'count'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--countMax 0..1 integer-->     <xsl:apply-templates select="*[@key = 'countMax']" mode="integer">
                  <xsl:with-param name="key" select="'countMax'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'countMax'])][*[@key = '_countMax']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="countMax"/>
                        <xsl:copy-of select="fn:map[@key = '_countMax']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'countMax'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--duration 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'duration']" mode="decimal">
                  <xsl:with-param name="key" select="'duration'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'duration'])][*[@key = '_duration']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="duration"/>
                        <xsl:copy-of select="fn:map[@key = '_duration']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'duration'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--durationMax 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'durationMax']" mode="decimal">
                  <xsl:with-param name="key" select="'durationMax'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'durationMax'])][*[@key = '_durationMax']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="durationMax"/>
                        <xsl:copy-of select="fn:map[@key = '_durationMax']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'durationMax'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--durationUnit 0..1 UnitsOfTime-->     <xsl:apply-templates select="*[@key = 'durationUnit']" mode="UnitsOfTime">
                  <xsl:with-param name="key" select="'durationUnit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'durationUnit'])][*[@key = '_durationUnit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="durationUnit"/>
                        <xsl:copy-of select="fn:map[@key = '_durationUnit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="UnitsOfTime">
                     <xsl:with-param name="key" select="'durationUnit'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--frequency 0..1 integer-->     <xsl:apply-templates select="*[@key = 'frequency']" mode="integer">
                  <xsl:with-param name="key" select="'frequency'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'frequency'])][*[@key = '_frequency']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="frequency"/>
                        <xsl:copy-of select="fn:map[@key = '_frequency']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'frequency'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--frequencyMax 0..1 integer-->     <xsl:apply-templates select="*[@key = 'frequencyMax']" mode="integer">
                  <xsl:with-param name="key" select="'frequencyMax'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'frequencyMax'])][*[@key = '_frequencyMax']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="frequencyMax"/>
                        <xsl:copy-of select="fn:map[@key = '_frequencyMax']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'frequencyMax'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--period 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'period']" mode="decimal">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'period'])][*[@key = '_period']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="period"/>
                        <xsl:copy-of select="fn:map[@key = '_period']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'period'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--periodMax 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'periodMax']" mode="decimal">
                  <xsl:with-param name="key" select="'periodMax'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'periodMax'])][*[@key = '_periodMax']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="periodMax"/>
                        <xsl:copy-of select="fn:map[@key = '_periodMax']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'periodMax'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--periodUnit 0..1 UnitsOfTime-->     <xsl:apply-templates select="*[@key = 'periodUnit']" mode="UnitsOfTime">
                  <xsl:with-param name="key" select="'periodUnit'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'periodUnit'])][*[@key = '_periodUnit']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="periodUnit"/>
                        <xsl:copy-of select="fn:map[@key = '_periodUnit']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="UnitsOfTime">
                     <xsl:with-param name="key" select="'periodUnit'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--dayOfWeek 0..* code-->     <xsl:apply-templates select="*[@key = 'dayOfWeek']" mode="code">
                  <xsl:with-param name="key" select="'dayOfWeek'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'dayOfWeek'])][*[@key = '_dayOfWeek']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="dayOfWeek"/>
                        <xsl:copy-of select="fn:map[@key = '_dayOfWeek']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'dayOfWeek'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--timeOfDay 0..* time-->     <xsl:apply-templates select="*[@key = 'timeOfDay']" mode="time">
                  <xsl:with-param name="key" select="'timeOfDay'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'timeOfDay'])][*[@key = '_timeOfDay']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="timeOfDay"/>
                        <xsl:copy-of select="fn:map[@key = '_timeOfDay']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'timeOfDay'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--when 0..* EventTiming-->     <xsl:apply-templates select="*[@key = 'when']" mode="EventTiming">
                  <xsl:with-param name="key" select="'when'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'when'])][*[@key = '_when']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="when"/>
                        <xsl:copy-of select="fn:map[@key = '_when']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="EventTiming">
                     <xsl:with-param name="key" select="'when'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--offset 0..1 unsignedInt-->     <xsl:apply-templates select="*[@key = 'offset']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'offset'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'offset'])][*[@key = '_offset']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="offset"/>
                        <xsl:copy-of select="fn:map[@key = '_offset']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'offset'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A unit of time (units from UCUM).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="UnitsOfTime">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Real world event relating to the schedule.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="EventTiming">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--path 1..1 string-->     <xsl:apply-templates select="*[@key = 'path']" mode="string">
                  <xsl:with-param name="key" select="'path'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'path'])][*[@key = '_path']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="path"/>
                        <xsl:copy-of select="fn:map[@key = '_path']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'path'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--representation 0..* PropertyRepresentation-->     <xsl:apply-templates select="*[@key = 'representation']" mode="PropertyRepresentation">
                  <xsl:with-param name="key" select="'representation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'representation'])][*[@key = '_representation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="representation"/>
                        <xsl:copy-of select="fn:map[@key = '_representation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="PropertyRepresentation">
                     <xsl:with-param name="key" select="'representation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--sliceName 0..1 string-->     <xsl:apply-templates select="*[@key = 'sliceName']" mode="string">
                  <xsl:with-param name="key" select="'sliceName'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sliceName'])][*[@key = '_sliceName']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sliceName"/>
                        <xsl:copy-of select="fn:map[@key = '_sliceName']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'sliceName'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--label 0..1 string-->     <xsl:apply-templates select="*[@key = 'label']" mode="string">
                  <xsl:with-param name="key" select="'label'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'label'])][*[@key = '_label']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="label"/>
                        <xsl:copy-of select="fn:map[@key = '_label']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'label'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..* Coding-->     <xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--slicing 0..1 ElementDefinition.Slicing-->     <xsl:apply-templates select="*[@key = 'slicing']" mode="ElementDefinition.Slicing">
                  <xsl:with-param name="key" select="'slicing'"/>
               </xsl:apply-templates>
               <!--short 0..1 string-->     <xsl:apply-templates select="*[@key = 'short']" mode="string">
                  <xsl:with-param name="key" select="'short'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'short'])][*[@key = '_short']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="short"/>
                        <xsl:copy-of select="fn:map[@key = '_short']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'short'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--definition 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'definition']" mode="markdown">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'definition'])][*[@key = '_definition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition"/>
                        <xsl:copy-of select="fn:map[@key = '_definition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'definition'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--comment 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'comment']" mode="markdown">
                  <xsl:with-param name="key" select="'comment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comment'])][*[@key = '_comment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment"/>
                        <xsl:copy-of select="fn:map[@key = '_comment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'comment'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--requirements 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'requirements']" mode="markdown">
                  <xsl:with-param name="key" select="'requirements'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requirements'])][*[@key = '_requirements']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements"/>
                        <xsl:copy-of select="fn:map[@key = '_requirements']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'requirements'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--alias 0..* string-->     <xsl:apply-templates select="*[@key = 'alias']" mode="string">
                  <xsl:with-param name="key" select="'alias'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'alias'])][*[@key = '_alias']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="alias"/>
                        <xsl:copy-of select="fn:map[@key = '_alias']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'alias'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--min 0..1 unsignedInt-->     <xsl:apply-templates select="*[@key = 'min']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'min'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'min'])][*[@key = '_min']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="min"/>
                        <xsl:copy-of select="fn:map[@key = '_min']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'min'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--max 0..1 string-->     <xsl:apply-templates select="*[@key = 'max']" mode="string">
                  <xsl:with-param name="key" select="'max'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'max'])][*[@key = '_max']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="max"/>
                        <xsl:copy-of select="fn:map[@key = '_max']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'max'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--base 0..1 ElementDefinition.Base-->     <xsl:apply-templates select="*[@key = 'base']" mode="ElementDefinition.Base">
                  <xsl:with-param name="key" select="'base'"/>
               </xsl:apply-templates>
               <!--contentReference 0..1 uri-->     <xsl:apply-templates select="*[@key = 'contentReference']" mode="uri">
                  <xsl:with-param name="key" select="'contentReference'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentReference'])][*[@key = '_contentReference']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference"/>
                        <xsl:copy-of select="fn:map[@key = '_contentReference']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'contentReference'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..* ElementDefinition.Type-->     <xsl:apply-templates select="*[@key = 'type']" mode="ElementDefinition.Type">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
        
           
               <!--defaultValueBase64Binary 1..1 base64Binary-->    <xsl:apply-templates select="*[@key = 'defaultValueBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'defaultValueBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueBase64Binary'])][*[@key = '_defaultValueBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="defaultValueBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'defaultValueBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueBoolean 1..1 boolean-->    <xsl:apply-templates select="*[@key = 'defaultValueBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'defaultValueBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueBoolean'])][*[@key = '_defaultValueBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'defaultValueBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueCode 1..1 code-->    <xsl:apply-templates select="*[@key = 'defaultValueCode']" mode="code">
                  <xsl:with-param name="key" select="'defaultValueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueCode'])][*[@key = '_defaultValueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'defaultValueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueDate 1..1 date-->    <xsl:apply-templates select="*[@key = 'defaultValueDate']" mode="date">
                  <xsl:with-param name="key" select="'defaultValueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueDate'])][*[@key = '_defaultValueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'defaultValueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'defaultValueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'defaultValueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueDateTime'])][*[@key = '_defaultValueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'defaultValueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueDecimal 1..1 decimal-->    <xsl:apply-templates select="*[@key = 'defaultValueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'defaultValueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueDecimal'])][*[@key = '_defaultValueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'defaultValueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueId 1..1 id-->    <xsl:apply-templates select="*[@key = 'defaultValueId']" mode="id">
                  <xsl:with-param name="key" select="'defaultValueId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueId'])][*[@key = '_defaultValueId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueId"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'defaultValueId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueInstant 1..1 instant-->    <xsl:apply-templates select="*[@key = 'defaultValueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'defaultValueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueInstant'])][*[@key = '_defaultValueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'defaultValueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueInteger 1..1 integer-->    <xsl:apply-templates select="*[@key = 'defaultValueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'defaultValueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueInteger'])][*[@key = '_defaultValueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'defaultValueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueMarkdown 1..1 markdown-->    <xsl:apply-templates select="*[@key = 'defaultValueMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'defaultValueMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueMarkdown'])][*[@key = '_defaultValueMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'defaultValueMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueOid 1..1 oid-->    <xsl:apply-templates select="*[@key = 'defaultValueOid']" mode="oid">
                  <xsl:with-param name="key" select="'defaultValueOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueOid'])][*[@key = '_defaultValueOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueOid"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'defaultValueOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValuePositiveInt 1..1 positiveInt-->    <xsl:apply-templates select="*[@key = 'defaultValuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'defaultValuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValuePositiveInt'])][*[@key = '_defaultValuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="defaultValuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'defaultValuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueString 1..1 string-->    <xsl:apply-templates select="*[@key = 'defaultValueString']" mode="string">
                  <xsl:with-param name="key" select="'defaultValueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueString'])][*[@key = '_defaultValueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueString"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'defaultValueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueTime 1..1 time-->    <xsl:apply-templates select="*[@key = 'defaultValueTime']" mode="time">
                  <xsl:with-param name="key" select="'defaultValueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueTime'])][*[@key = '_defaultValueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'defaultValueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueUnsignedInt 1..1 unsignedInt-->    <xsl:apply-templates select="*[@key = 'defaultValueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'defaultValueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueUnsignedInt'])][*[@key = '_defaultValueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="defaultValueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'defaultValueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueUri 1..1 uri-->    <xsl:apply-templates select="*[@key = 'defaultValueUri']" mode="uri">
                  <xsl:with-param name="key" select="'defaultValueUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'defaultValueUri'])][*[@key = '_defaultValueUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueUri"/>
                        <xsl:copy-of select="fn:map[@key = '_defaultValueUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'defaultValueUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--defaultValueAddress 1..1 Address-->    <xsl:apply-templates select="*[@key = 'defaultValueAddress']" mode="Address">
                  <xsl:with-param name="key" select="'defaultValueAddress'"/>
               </xsl:apply-templates>
               <!--defaultValueAge 1..1 Age-->    <xsl:apply-templates select="*[@key = 'defaultValueAge']" mode="Age">
                  <xsl:with-param name="key" select="'defaultValueAge'"/>
               </xsl:apply-templates>
               <!--defaultValueAnnotation 1..1 Annotation-->    <xsl:apply-templates select="*[@key = 'defaultValueAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'defaultValueAnnotation'"/>
               </xsl:apply-templates>
               <!--defaultValueAttachment 1..1 Attachment-->    <xsl:apply-templates select="*[@key = 'defaultValueAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'defaultValueAttachment'"/>
               </xsl:apply-templates>
               <!--defaultValueCodeableConcept 1..1 CodeableConcept-->    <xsl:apply-templates select="*[@key = 'defaultValueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'defaultValueCodeableConcept'"/>
               </xsl:apply-templates>
               <!--defaultValueCoding 1..1 Coding-->    <xsl:apply-templates select="*[@key = 'defaultValueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'defaultValueCoding'"/>
               </xsl:apply-templates>
               <!--defaultValueContactPoint 1..1 ContactPoint-->    <xsl:apply-templates select="*[@key = 'defaultValueContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'defaultValueContactPoint'"/>
               </xsl:apply-templates>
               <!--defaultValueCount 1..1 Count-->    <xsl:apply-templates select="*[@key = 'defaultValueCount']" mode="Count">
                  <xsl:with-param name="key" select="'defaultValueCount'"/>
               </xsl:apply-templates>
               <!--defaultValueDistance 1..1 Distance-->    <xsl:apply-templates select="*[@key = 'defaultValueDistance']" mode="Distance">
                  <xsl:with-param name="key" select="'defaultValueDistance'"/>
               </xsl:apply-templates>
               <!--defaultValueDuration 1..1 Duration-->    <xsl:apply-templates select="*[@key = 'defaultValueDuration']" mode="Duration">
                  <xsl:with-param name="key" select="'defaultValueDuration'"/>
               </xsl:apply-templates>
               <!--defaultValueHumanName 1..1 HumanName-->    <xsl:apply-templates select="*[@key = 'defaultValueHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'defaultValueHumanName'"/>
               </xsl:apply-templates>
               <!--defaultValueIdentifier 1..1 Identifier-->    <xsl:apply-templates select="*[@key = 'defaultValueIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'defaultValueIdentifier'"/>
               </xsl:apply-templates>
               <!--defaultValueMoney 1..1 Money-->    <xsl:apply-templates select="*[@key = 'defaultValueMoney']" mode="Money">
                  <xsl:with-param name="key" select="'defaultValueMoney'"/>
               </xsl:apply-templates>
               <!--defaultValuePeriod 1..1 Period-->    <xsl:apply-templates select="*[@key = 'defaultValuePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'defaultValuePeriod'"/>
               </xsl:apply-templates>
               <!--defaultValueQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'defaultValueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'defaultValueQuantity'"/>
               </xsl:apply-templates>
               <!--defaultValueRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'defaultValueRange']" mode="Range">
                  <xsl:with-param name="key" select="'defaultValueRange'"/>
               </xsl:apply-templates>
               <!--defaultValueRatio 1..1 Ratio-->    <xsl:apply-templates select="*[@key = 'defaultValueRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'defaultValueRatio'"/>
               </xsl:apply-templates>
               <!--defaultValueReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'defaultValueReference']" mode="Reference">
                  <xsl:with-param name="key" select="'defaultValueReference'"/>
               </xsl:apply-templates>
               <!--defaultValueSampledData 1..1 SampledData-->    <xsl:apply-templates select="*[@key = 'defaultValueSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'defaultValueSampledData'"/>
               </xsl:apply-templates>
               <!--defaultValueSignature 1..1 Signature-->    <xsl:apply-templates select="*[@key = 'defaultValueSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'defaultValueSignature'"/>
               </xsl:apply-templates>
               <!--defaultValueTiming 1..1 Timing-->    <xsl:apply-templates select="*[@key = 'defaultValueTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'defaultValueTiming'"/>
               </xsl:apply-templates>
               <!--defaultValueMeta 1..1 Meta-->    <xsl:apply-templates select="*[@key = 'defaultValueMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'defaultValueMeta'"/>
               </xsl:apply-templates>
         
               <!--meaningWhenMissing 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'meaningWhenMissing']" mode="markdown">
                  <xsl:with-param name="key" select="'meaningWhenMissing'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'meaningWhenMissing'])][*[@key = '_meaningWhenMissing']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="meaningWhenMissing"/>
                        <xsl:copy-of select="fn:map[@key = '_meaningWhenMissing']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'meaningWhenMissing'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--orderMeaning 0..1 string-->     <xsl:apply-templates select="*[@key = 'orderMeaning']" mode="string">
                  <xsl:with-param name="key" select="'orderMeaning'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'orderMeaning'])][*[@key = '_orderMeaning']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="orderMeaning"/>
                        <xsl:copy-of select="fn:map[@key = '_orderMeaning']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'orderMeaning'"/>
                  </xsl:apply-templates>
               </xsl:if>
        
           
               <!--fixedBase64Binary 1..1 base64Binary-->    <xsl:apply-templates select="*[@key = 'fixedBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'fixedBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedBase64Binary'])][*[@key = '_fixedBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'fixedBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedBoolean 1..1 boolean-->    <xsl:apply-templates select="*[@key = 'fixedBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'fixedBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedBoolean'])][*[@key = '_fixedBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'fixedBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedCode 1..1 code-->    <xsl:apply-templates select="*[@key = 'fixedCode']" mode="code">
                  <xsl:with-param name="key" select="'fixedCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedCode'])][*[@key = '_fixedCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCode"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'fixedCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedDate 1..1 date-->    <xsl:apply-templates select="*[@key = 'fixedDate']" mode="date">
                  <xsl:with-param name="key" select="'fixedDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedDate'])][*[@key = '_fixedDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDate"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'fixedDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'fixedDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'fixedDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedDateTime'])][*[@key = '_fixedDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'fixedDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedDecimal 1..1 decimal-->    <xsl:apply-templates select="*[@key = 'fixedDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'fixedDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedDecimal'])][*[@key = '_fixedDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'fixedDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedId 1..1 id-->    <xsl:apply-templates select="*[@key = 'fixedId']" mode="id">
                  <xsl:with-param name="key" select="'fixedId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedId'])][*[@key = '_fixedId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedId"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'fixedId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedInstant 1..1 instant-->    <xsl:apply-templates select="*[@key = 'fixedInstant']" mode="instant">
                  <xsl:with-param name="key" select="'fixedInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedInstant'])][*[@key = '_fixedInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'fixedInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedInteger 1..1 integer-->    <xsl:apply-templates select="*[@key = 'fixedInteger']" mode="integer">
                  <xsl:with-param name="key" select="'fixedInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedInteger'])][*[@key = '_fixedInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'fixedInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedMarkdown 1..1 markdown-->    <xsl:apply-templates select="*[@key = 'fixedMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'fixedMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedMarkdown'])][*[@key = '_fixedMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'fixedMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedOid 1..1 oid-->    <xsl:apply-templates select="*[@key = 'fixedOid']" mode="oid">
                  <xsl:with-param name="key" select="'fixedOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedOid'])][*[@key = '_fixedOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedOid"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'fixedOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedPositiveInt 1..1 positiveInt-->    <xsl:apply-templates select="*[@key = 'fixedPositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'fixedPositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedPositiveInt'])][*[@key = '_fixedPositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedPositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedPositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'fixedPositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedString 1..1 string-->    <xsl:apply-templates select="*[@key = 'fixedString']" mode="string">
                  <xsl:with-param name="key" select="'fixedString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedString'])][*[@key = '_fixedString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedString"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'fixedString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedTime 1..1 time-->    <xsl:apply-templates select="*[@key = 'fixedTime']" mode="time">
                  <xsl:with-param name="key" select="'fixedTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedTime'])][*[@key = '_fixedTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedTime"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'fixedTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedUnsignedInt 1..1 unsignedInt-->    <xsl:apply-templates select="*[@key = 'fixedUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'fixedUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedUnsignedInt'])][*[@key = '_fixedUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'fixedUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedUri 1..1 uri-->    <xsl:apply-templates select="*[@key = 'fixedUri']" mode="uri">
                  <xsl:with-param name="key" select="'fixedUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fixedUri'])][*[@key = '_fixedUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUri"/>
                        <xsl:copy-of select="fn:map[@key = '_fixedUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'fixedUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--fixedAddress 1..1 Address-->    <xsl:apply-templates select="*[@key = 'fixedAddress']" mode="Address">
                  <xsl:with-param name="key" select="'fixedAddress'"/>
               </xsl:apply-templates>
               <!--fixedAge 1..1 Age-->    <xsl:apply-templates select="*[@key = 'fixedAge']" mode="Age">
                  <xsl:with-param name="key" select="'fixedAge'"/>
               </xsl:apply-templates>
               <!--fixedAnnotation 1..1 Annotation-->    <xsl:apply-templates select="*[@key = 'fixedAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'fixedAnnotation'"/>
               </xsl:apply-templates>
               <!--fixedAttachment 1..1 Attachment-->    <xsl:apply-templates select="*[@key = 'fixedAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'fixedAttachment'"/>
               </xsl:apply-templates>
               <!--fixedCodeableConcept 1..1 CodeableConcept-->    <xsl:apply-templates select="*[@key = 'fixedCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'fixedCodeableConcept'"/>
               </xsl:apply-templates>
               <!--fixedCoding 1..1 Coding-->    <xsl:apply-templates select="*[@key = 'fixedCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'fixedCoding'"/>
               </xsl:apply-templates>
               <!--fixedContactPoint 1..1 ContactPoint-->    <xsl:apply-templates select="*[@key = 'fixedContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'fixedContactPoint'"/>
               </xsl:apply-templates>
               <!--fixedCount 1..1 Count-->    <xsl:apply-templates select="*[@key = 'fixedCount']" mode="Count">
                  <xsl:with-param name="key" select="'fixedCount'"/>
               </xsl:apply-templates>
               <!--fixedDistance 1..1 Distance-->    <xsl:apply-templates select="*[@key = 'fixedDistance']" mode="Distance">
                  <xsl:with-param name="key" select="'fixedDistance'"/>
               </xsl:apply-templates>
               <!--fixedDuration 1..1 Duration-->    <xsl:apply-templates select="*[@key = 'fixedDuration']" mode="Duration">
                  <xsl:with-param name="key" select="'fixedDuration'"/>
               </xsl:apply-templates>
               <!--fixedHumanName 1..1 HumanName-->    <xsl:apply-templates select="*[@key = 'fixedHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'fixedHumanName'"/>
               </xsl:apply-templates>
               <!--fixedIdentifier 1..1 Identifier-->    <xsl:apply-templates select="*[@key = 'fixedIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'fixedIdentifier'"/>
               </xsl:apply-templates>
               <!--fixedMoney 1..1 Money-->    <xsl:apply-templates select="*[@key = 'fixedMoney']" mode="Money">
                  <xsl:with-param name="key" select="'fixedMoney'"/>
               </xsl:apply-templates>
               <!--fixedPeriod 1..1 Period-->    <xsl:apply-templates select="*[@key = 'fixedPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'fixedPeriod'"/>
               </xsl:apply-templates>
               <!--fixedQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'fixedQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'fixedQuantity'"/>
               </xsl:apply-templates>
               <!--fixedRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'fixedRange']" mode="Range">
                  <xsl:with-param name="key" select="'fixedRange'"/>
               </xsl:apply-templates>
               <!--fixedRatio 1..1 Ratio-->    <xsl:apply-templates select="*[@key = 'fixedRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'fixedRatio'"/>
               </xsl:apply-templates>
               <!--fixedReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'fixedReference']" mode="Reference">
                  <xsl:with-param name="key" select="'fixedReference'"/>
               </xsl:apply-templates>
               <!--fixedSampledData 1..1 SampledData-->    <xsl:apply-templates select="*[@key = 'fixedSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'fixedSampledData'"/>
               </xsl:apply-templates>
               <!--fixedSignature 1..1 Signature-->    <xsl:apply-templates select="*[@key = 'fixedSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'fixedSignature'"/>
               </xsl:apply-templates>
               <!--fixedTiming 1..1 Timing-->    <xsl:apply-templates select="*[@key = 'fixedTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'fixedTiming'"/>
               </xsl:apply-templates>
               <!--fixedMeta 1..1 Meta-->    <xsl:apply-templates select="*[@key = 'fixedMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'fixedMeta'"/>
               </xsl:apply-templates>
         
        
           
               <!--patternBase64Binary 1..1 base64Binary-->    <xsl:apply-templates select="*[@key = 'patternBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'patternBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternBase64Binary'])][*[@key = '_patternBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_patternBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'patternBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternBoolean 1..1 boolean-->    <xsl:apply-templates select="*[@key = 'patternBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'patternBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternBoolean'])][*[@key = '_patternBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_patternBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'patternBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternCode 1..1 code-->    <xsl:apply-templates select="*[@key = 'patternCode']" mode="code">
                  <xsl:with-param name="key" select="'patternCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternCode'])][*[@key = '_patternCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternCode"/>
                        <xsl:copy-of select="fn:map[@key = '_patternCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'patternCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternDate 1..1 date-->    <xsl:apply-templates select="*[@key = 'patternDate']" mode="date">
                  <xsl:with-param name="key" select="'patternDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternDate'])][*[@key = '_patternDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDate"/>
                        <xsl:copy-of select="fn:map[@key = '_patternDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'patternDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'patternDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'patternDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternDateTime'])][*[@key = '_patternDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_patternDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'patternDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternDecimal 1..1 decimal-->    <xsl:apply-templates select="*[@key = 'patternDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'patternDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternDecimal'])][*[@key = '_patternDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_patternDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'patternDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternId 1..1 id-->    <xsl:apply-templates select="*[@key = 'patternId']" mode="id">
                  <xsl:with-param name="key" select="'patternId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternId'])][*[@key = '_patternId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternId"/>
                        <xsl:copy-of select="fn:map[@key = '_patternId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'patternId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternInstant 1..1 instant-->    <xsl:apply-templates select="*[@key = 'patternInstant']" mode="instant">
                  <xsl:with-param name="key" select="'patternInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternInstant'])][*[@key = '_patternInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_patternInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'patternInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternInteger 1..1 integer-->    <xsl:apply-templates select="*[@key = 'patternInteger']" mode="integer">
                  <xsl:with-param name="key" select="'patternInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternInteger'])][*[@key = '_patternInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_patternInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'patternInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternMarkdown 1..1 markdown-->    <xsl:apply-templates select="*[@key = 'patternMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'patternMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternMarkdown'])][*[@key = '_patternMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_patternMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'patternMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternOid 1..1 oid-->    <xsl:apply-templates select="*[@key = 'patternOid']" mode="oid">
                  <xsl:with-param name="key" select="'patternOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternOid'])][*[@key = '_patternOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternOid"/>
                        <xsl:copy-of select="fn:map[@key = '_patternOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'patternOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternPositiveInt 1..1 positiveInt-->    <xsl:apply-templates select="*[@key = 'patternPositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'patternPositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternPositiveInt'])][*[@key = '_patternPositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternPositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_patternPositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'patternPositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternString 1..1 string-->    <xsl:apply-templates select="*[@key = 'patternString']" mode="string">
                  <xsl:with-param name="key" select="'patternString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternString'])][*[@key = '_patternString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternString"/>
                        <xsl:copy-of select="fn:map[@key = '_patternString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'patternString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternTime 1..1 time-->    <xsl:apply-templates select="*[@key = 'patternTime']" mode="time">
                  <xsl:with-param name="key" select="'patternTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternTime'])][*[@key = '_patternTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternTime"/>
                        <xsl:copy-of select="fn:map[@key = '_patternTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'patternTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternUnsignedInt 1..1 unsignedInt-->    <xsl:apply-templates select="*[@key = 'patternUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'patternUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternUnsignedInt'])][*[@key = '_patternUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_patternUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'patternUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternUri 1..1 uri-->    <xsl:apply-templates select="*[@key = 'patternUri']" mode="uri">
                  <xsl:with-param name="key" select="'patternUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patternUri'])][*[@key = '_patternUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternUri"/>
                        <xsl:copy-of select="fn:map[@key = '_patternUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'patternUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patternAddress 1..1 Address-->    <xsl:apply-templates select="*[@key = 'patternAddress']" mode="Address">
                  <xsl:with-param name="key" select="'patternAddress'"/>
               </xsl:apply-templates>
               <!--patternAge 1..1 Age-->    <xsl:apply-templates select="*[@key = 'patternAge']" mode="Age">
                  <xsl:with-param name="key" select="'patternAge'"/>
               </xsl:apply-templates>
               <!--patternAnnotation 1..1 Annotation-->    <xsl:apply-templates select="*[@key = 'patternAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'patternAnnotation'"/>
               </xsl:apply-templates>
               <!--patternAttachment 1..1 Attachment-->    <xsl:apply-templates select="*[@key = 'patternAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'patternAttachment'"/>
               </xsl:apply-templates>
               <!--patternCodeableConcept 1..1 CodeableConcept-->    <xsl:apply-templates select="*[@key = 'patternCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'patternCodeableConcept'"/>
               </xsl:apply-templates>
               <!--patternCoding 1..1 Coding-->    <xsl:apply-templates select="*[@key = 'patternCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'patternCoding'"/>
               </xsl:apply-templates>
               <!--patternContactPoint 1..1 ContactPoint-->    <xsl:apply-templates select="*[@key = 'patternContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'patternContactPoint'"/>
               </xsl:apply-templates>
               <!--patternCount 1..1 Count-->    <xsl:apply-templates select="*[@key = 'patternCount']" mode="Count">
                  <xsl:with-param name="key" select="'patternCount'"/>
               </xsl:apply-templates>
               <!--patternDistance 1..1 Distance-->    <xsl:apply-templates select="*[@key = 'patternDistance']" mode="Distance">
                  <xsl:with-param name="key" select="'patternDistance'"/>
               </xsl:apply-templates>
               <!--patternDuration 1..1 Duration-->    <xsl:apply-templates select="*[@key = 'patternDuration']" mode="Duration">
                  <xsl:with-param name="key" select="'patternDuration'"/>
               </xsl:apply-templates>
               <!--patternHumanName 1..1 HumanName-->    <xsl:apply-templates select="*[@key = 'patternHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'patternHumanName'"/>
               </xsl:apply-templates>
               <!--patternIdentifier 1..1 Identifier-->    <xsl:apply-templates select="*[@key = 'patternIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'patternIdentifier'"/>
               </xsl:apply-templates>
               <!--patternMoney 1..1 Money-->    <xsl:apply-templates select="*[@key = 'patternMoney']" mode="Money">
                  <xsl:with-param name="key" select="'patternMoney'"/>
               </xsl:apply-templates>
               <!--patternPeriod 1..1 Period-->    <xsl:apply-templates select="*[@key = 'patternPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'patternPeriod'"/>
               </xsl:apply-templates>
               <!--patternQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'patternQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'patternQuantity'"/>
               </xsl:apply-templates>
               <!--patternRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'patternRange']" mode="Range">
                  <xsl:with-param name="key" select="'patternRange'"/>
               </xsl:apply-templates>
               <!--patternRatio 1..1 Ratio-->    <xsl:apply-templates select="*[@key = 'patternRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'patternRatio'"/>
               </xsl:apply-templates>
               <!--patternReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'patternReference']" mode="Reference">
                  <xsl:with-param name="key" select="'patternReference'"/>
               </xsl:apply-templates>
               <!--patternSampledData 1..1 SampledData-->    <xsl:apply-templates select="*[@key = 'patternSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'patternSampledData'"/>
               </xsl:apply-templates>
               <!--patternSignature 1..1 Signature-->    <xsl:apply-templates select="*[@key = 'patternSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'patternSignature'"/>
               </xsl:apply-templates>
               <!--patternTiming 1..1 Timing-->    <xsl:apply-templates select="*[@key = 'patternTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'patternTiming'"/>
               </xsl:apply-templates>
               <!--patternMeta 1..1 Meta-->    <xsl:apply-templates select="*[@key = 'patternMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'patternMeta'"/>
               </xsl:apply-templates>
         
               <!--example 0..* ElementDefinition.Example-->     <xsl:apply-templates select="*[@key = 'example']" mode="ElementDefinition.Example">
                  <xsl:with-param name="key" select="'example'"/>
               </xsl:apply-templates>
          
            
               <!--minValueDate 1..1 date-->    <xsl:apply-templates select="*[@key = 'minValueDate']" mode="date">
                  <xsl:with-param name="key" select="'minValueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueDate'])][*[@key = '_minValueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'minValueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minValueDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'minValueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'minValueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueDateTime'])][*[@key = '_minValueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'minValueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minValueInstant 1..1 instant-->    <xsl:apply-templates select="*[@key = 'minValueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'minValueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueInstant'])][*[@key = '_minValueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'minValueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minValueTime 1..1 time-->    <xsl:apply-templates select="*[@key = 'minValueTime']" mode="time">
                  <xsl:with-param name="key" select="'minValueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueTime'])][*[@key = '_minValueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'minValueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minValueDecimal 1..1 decimal-->    <xsl:apply-templates select="*[@key = 'minValueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'minValueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueDecimal'])][*[@key = '_minValueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'minValueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minValueInteger 1..1 integer-->    <xsl:apply-templates select="*[@key = 'minValueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'minValueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueInteger'])][*[@key = '_minValueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'minValueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minValuePositiveInt 1..1 positiveInt-->    <xsl:apply-templates select="*[@key = 'minValuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'minValuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValuePositiveInt'])][*[@key = '_minValuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_minValuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'minValuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minValueUnsignedInt 1..1 unsignedInt-->    <xsl:apply-templates select="*[@key = 'minValueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'minValueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minValueUnsignedInt'])][*[@key = '_minValueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_minValueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'minValueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minValueQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'minValueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'minValueQuantity'"/>
               </xsl:apply-templates>
          
          
            
               <!--maxValueDate 1..1 date-->    <xsl:apply-templates select="*[@key = 'maxValueDate']" mode="date">
                  <xsl:with-param name="key" select="'maxValueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueDate'])][*[@key = '_maxValueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'maxValueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--maxValueDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'maxValueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'maxValueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueDateTime'])][*[@key = '_maxValueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'maxValueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--maxValueInstant 1..1 instant-->    <xsl:apply-templates select="*[@key = 'maxValueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'maxValueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueInstant'])][*[@key = '_maxValueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'maxValueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--maxValueTime 1..1 time-->    <xsl:apply-templates select="*[@key = 'maxValueTime']" mode="time">
                  <xsl:with-param name="key" select="'maxValueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueTime'])][*[@key = '_maxValueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'maxValueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--maxValueDecimal 1..1 decimal-->    <xsl:apply-templates select="*[@key = 'maxValueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'maxValueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueDecimal'])][*[@key = '_maxValueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'maxValueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--maxValueInteger 1..1 integer-->    <xsl:apply-templates select="*[@key = 'maxValueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'maxValueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueInteger'])][*[@key = '_maxValueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'maxValueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--maxValuePositiveInt 1..1 positiveInt-->    <xsl:apply-templates select="*[@key = 'maxValuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'maxValuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValuePositiveInt'])][*[@key = '_maxValuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'maxValuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--maxValueUnsignedInt 1..1 unsignedInt-->    <xsl:apply-templates select="*[@key = 'maxValueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'maxValueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxValueUnsignedInt'])][*[@key = '_maxValueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_maxValueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'maxValueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--maxValueQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'maxValueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'maxValueQuantity'"/>
               </xsl:apply-templates>
          
               <!--maxLength 0..1 integer-->     <xsl:apply-templates select="*[@key = 'maxLength']" mode="integer">
                  <xsl:with-param name="key" select="'maxLength'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'maxLength'])][*[@key = '_maxLength']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxLength"/>
                        <xsl:copy-of select="fn:map[@key = '_maxLength']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'maxLength'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--condition 0..* id-->     <xsl:apply-templates select="*[@key = 'condition']" mode="id">
                  <xsl:with-param name="key" select="'condition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'condition'])][*[@key = '_condition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="condition"/>
                        <xsl:copy-of select="fn:map[@key = '_condition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'condition'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--constraint 0..* ElementDefinition.Constraint-->     <xsl:apply-templates select="*[@key = 'constraint']" mode="ElementDefinition.Constraint">
                  <xsl:with-param name="key" select="'constraint'"/>
               </xsl:apply-templates>
               <!--mustSupport 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'mustSupport']" mode="boolean">
                  <xsl:with-param name="key" select="'mustSupport'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mustSupport'])][*[@key = '_mustSupport']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mustSupport"/>
                        <xsl:copy-of select="fn:map[@key = '_mustSupport']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'mustSupport'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--isModifier 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'isModifier']" mode="boolean">
                  <xsl:with-param name="key" select="'isModifier'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'isModifier'])][*[@key = '_isModifier']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="isModifier"/>
                        <xsl:copy-of select="fn:map[@key = '_isModifier']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'isModifier'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--isSummary 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'isSummary']" mode="boolean">
                  <xsl:with-param name="key" select="'isSummary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'isSummary'])][*[@key = '_isSummary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="isSummary"/>
                        <xsl:copy-of select="fn:map[@key = '_isSummary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'isSummary'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--binding 0..1 ElementDefinition.Binding-->     <xsl:apply-templates select="*[@key = 'binding']" mode="ElementDefinition.Binding">
                  <xsl:with-param name="key" select="'binding'"/>
               </xsl:apply-templates>
               <!--mapping 0..* ElementDefinition.Mapping-->     <xsl:apply-templates select="*[@key = 'mapping']" mode="ElementDefinition.Mapping">
                  <xsl:with-param name="key" select="'mapping'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Constraint">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--key 1..1 id-->     <xsl:apply-templates select="*[@key = 'key']" mode="id">
                  <xsl:with-param name="key" select="'key'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'key'])][*[@key = '_key']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="key"/>
                        <xsl:copy-of select="fn:map[@key = '_key']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'key'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--requirements 0..1 string-->     <xsl:apply-templates select="*[@key = 'requirements']" mode="string">
                  <xsl:with-param name="key" select="'requirements'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requirements'])][*[@key = '_requirements']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements"/>
                        <xsl:copy-of select="fn:map[@key = '_requirements']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'requirements'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--severity 1..1 ConstraintSeverity-->     <xsl:apply-templates select="*[@key = 'severity']" mode="ConstraintSeverity">
                  <xsl:with-param name="key" select="'severity'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'severity'])][*[@key = '_severity']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity"/>
                        <xsl:copy-of select="fn:map[@key = '_severity']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConstraintSeverity">
                     <xsl:with-param name="key" select="'severity'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--human 1..1 string-->     <xsl:apply-templates select="*[@key = 'human']" mode="string">
                  <xsl:with-param name="key" select="'human'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'human'])][*[@key = '_human']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="human"/>
                        <xsl:copy-of select="fn:map[@key = '_human']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'human'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--expression 1..1 string-->     <xsl:apply-templates select="*[@key = 'expression']" mode="string">
                  <xsl:with-param name="key" select="'expression'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'expression'])][*[@key = '_expression']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="expression"/>
                        <xsl:copy-of select="fn:map[@key = '_expression']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'expression'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--xpath 0..1 string-->     <xsl:apply-templates select="*[@key = 'xpath']" mode="string">
                  <xsl:with-param name="key" select="'xpath'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'xpath'])][*[@key = '_xpath']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="xpath"/>
                        <xsl:copy-of select="fn:map[@key = '_xpath']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'xpath'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--source 0..1 uri-->     <xsl:apply-templates select="*[@key = 'source']" mode="uri">
                  <xsl:with-param name="key" select="'source'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'source'])][*[@key = '_source']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="source"/>
                        <xsl:copy-of select="fn:map[@key = '_source']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'source'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Mapping">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--identity 1..1 id-->     <xsl:apply-templates select="*[@key = 'identity']" mode="id">
                  <xsl:with-param name="key" select="'identity'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'identity'])][*[@key = '_identity']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="identity"/>
                        <xsl:copy-of select="fn:map[@key = '_identity']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'identity'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--language 0..1 code-->     <xsl:apply-templates select="*[@key = 'language']" mode="code">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'language'])][*[@key = '_language']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="language"/>
                        <xsl:copy-of select="fn:map[@key = '_language']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'language'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--map 1..1 string-->     <xsl:apply-templates select="*[@key = 'map']" mode="string">
                  <xsl:with-param name="key" select="'map'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'map'])][*[@key = '_map']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="map"/>
                        <xsl:copy-of select="fn:map[@key = '_map']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'map'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--comment 0..1 string-->     <xsl:apply-templates select="*[@key = 'comment']" mode="string">
                  <xsl:with-param name="key" select="'comment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comment'])][*[@key = '_comment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment"/>
                        <xsl:copy-of select="fn:map[@key = '_comment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comment'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Base">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--path 1..1 string-->     <xsl:apply-templates select="*[@key = 'path']" mode="string">
                  <xsl:with-param name="key" select="'path'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'path'])][*[@key = '_path']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="path"/>
                        <xsl:copy-of select="fn:map[@key = '_path']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'path'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--min 1..1 unsignedInt-->     <xsl:apply-templates select="*[@key = 'min']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'min'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'min'])][*[@key = '_min']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="min"/>
                        <xsl:copy-of select="fn:map[@key = '_min']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'min'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--max 1..1 string-->     <xsl:apply-templates select="*[@key = 'max']" mode="string">
                  <xsl:with-param name="key" select="'max'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'max'])][*[@key = '_max']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="max"/>
                        <xsl:copy-of select="fn:map[@key = '_max']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'max'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Type">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--code 1..1 uri-->     <xsl:apply-templates select="*[@key = 'code']" mode="uri">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--profile 0..1 uri-->     <xsl:apply-templates select="*[@key = 'profile']" mode="uri">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'profile'])][*[@key = '_profile']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="profile"/>
                        <xsl:copy-of select="fn:map[@key = '_profile']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'profile'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--targetProfile 0..1 uri-->     <xsl:apply-templates select="*[@key = 'targetProfile']" mode="uri">
                  <xsl:with-param name="key" select="'targetProfile'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'targetProfile'])][*[@key = '_targetProfile']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetProfile"/>
                        <xsl:copy-of select="fn:map[@key = '_targetProfile']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'targetProfile'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--aggregation 0..* AggregationMode-->     <xsl:apply-templates select="*[@key = 'aggregation']" mode="AggregationMode">
                  <xsl:with-param name="key" select="'aggregation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'aggregation'])][*[@key = '_aggregation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="aggregation"/>
                        <xsl:copy-of select="fn:map[@key = '_aggregation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AggregationMode">
                     <xsl:with-param name="key" select="'aggregation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--versioning 0..1 ReferenceVersionRules-->     <xsl:apply-templates select="*[@key = 'versioning']" mode="ReferenceVersionRules">
                  <xsl:with-param name="key" select="'versioning'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'versioning'])][*[@key = '_versioning']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="versioning"/>
                        <xsl:copy-of select="fn:map[@key = '_versioning']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ReferenceVersionRules">
                     <xsl:with-param name="key" select="'versioning'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Example">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--label 1..1 string-->     <xsl:apply-templates select="*[@key = 'label']" mode="string">
                  <xsl:with-param name="key" select="'label'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'label'])][*[@key = '_label']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="label"/>
                        <xsl:copy-of select="fn:map[@key = '_label']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'label'"/>
                  </xsl:apply-templates>
               </xsl:if>
        
           
               <!--valueBase64Binary 1..1 base64Binary-->    <xsl:apply-templates select="*[@key = 'valueBase64Binary']" mode="base64Binary">
                  <xsl:with-param name="key" select="'valueBase64Binary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueBase64Binary'])][*[@key = '_valueBase64Binary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBase64Binary"/>
                        <xsl:copy-of select="fn:map[@key = '_valueBase64Binary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'valueBase64Binary'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueBoolean 1..1 boolean-->    <xsl:apply-templates select="*[@key = 'valueBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'valueBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueBoolean'])][*[@key = '_valueBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_valueBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'valueBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueCode 1..1 code-->    <xsl:apply-templates select="*[@key = 'valueCode']" mode="code">
                  <xsl:with-param name="key" select="'valueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueCode'])][*[@key = '_valueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_valueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'valueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueDate 1..1 date-->    <xsl:apply-templates select="*[@key = 'valueDate']" mode="date">
                  <xsl:with-param name="key" select="'valueDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDate'])][*[@key = '_valueDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDate"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'valueDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueDateTime 1..1 dateTime-->    <xsl:apply-templates select="*[@key = 'valueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'valueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDateTime'])][*[@key = '_valueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'valueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueDecimal 1..1 decimal-->    <xsl:apply-templates select="*[@key = 'valueDecimal']" mode="decimal">
                  <xsl:with-param name="key" select="'valueDecimal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDecimal'])][*[@key = '_valueDecimal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDecimal"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDecimal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'valueDecimal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueId 1..1 id-->    <xsl:apply-templates select="*[@key = 'valueId']" mode="id">
                  <xsl:with-param name="key" select="'valueId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueId'])][*[@key = '_valueId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueId"/>
                        <xsl:copy-of select="fn:map[@key = '_valueId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'valueId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueInstant 1..1 instant-->    <xsl:apply-templates select="*[@key = 'valueInstant']" mode="instant">
                  <xsl:with-param name="key" select="'valueInstant'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueInstant'])][*[@key = '_valueInstant']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInstant"/>
                        <xsl:copy-of select="fn:map[@key = '_valueInstant']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'valueInstant'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueInteger 1..1 integer-->    <xsl:apply-templates select="*[@key = 'valueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'valueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueInteger'])][*[@key = '_valueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_valueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'valueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueMarkdown 1..1 markdown-->    <xsl:apply-templates select="*[@key = 'valueMarkdown']" mode="markdown">
                  <xsl:with-param name="key" select="'valueMarkdown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueMarkdown'])][*[@key = '_valueMarkdown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueMarkdown"/>
                        <xsl:copy-of select="fn:map[@key = '_valueMarkdown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'valueMarkdown'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueOid 1..1 oid-->    <xsl:apply-templates select="*[@key = 'valueOid']" mode="oid">
                  <xsl:with-param name="key" select="'valueOid'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueOid'])][*[@key = '_valueOid']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueOid"/>
                        <xsl:copy-of select="fn:map[@key = '_valueOid']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="oid">
                     <xsl:with-param name="key" select="'valueOid'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valuePositiveInt 1..1 positiveInt-->    <xsl:apply-templates select="*[@key = 'valuePositiveInt']" mode="positiveInt">
                  <xsl:with-param name="key" select="'valuePositiveInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valuePositiveInt'])][*[@key = '_valuePositiveInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valuePositiveInt"/>
                        <xsl:copy-of select="fn:map[@key = '_valuePositiveInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'valuePositiveInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueString 1..1 string-->    <xsl:apply-templates select="*[@key = 'valueString']" mode="string">
                  <xsl:with-param name="key" select="'valueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueString'])][*[@key = '_valueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString"/>
                        <xsl:copy-of select="fn:map[@key = '_valueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'valueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueTime 1..1 time-->    <xsl:apply-templates select="*[@key = 'valueTime']" mode="time">
                  <xsl:with-param name="key" select="'valueTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueTime'])][*[@key = '_valueTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueTime"/>
                        <xsl:copy-of select="fn:map[@key = '_valueTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="time">
                     <xsl:with-param name="key" select="'valueTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueUnsignedInt 1..1 unsignedInt-->    <xsl:apply-templates select="*[@key = 'valueUnsignedInt']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'valueUnsignedInt'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueUnsignedInt'])][*[@key = '_valueUnsignedInt']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUnsignedInt"/>
                        <xsl:copy-of select="fn:map[@key = '_valueUnsignedInt']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'valueUnsignedInt'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueUri 1..1 uri-->    <xsl:apply-templates select="*[@key = 'valueUri']" mode="uri">
                  <xsl:with-param name="key" select="'valueUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueUri'])][*[@key = '_valueUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUri"/>
                        <xsl:copy-of select="fn:map[@key = '_valueUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'valueUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueAddress 1..1 Address-->    <xsl:apply-templates select="*[@key = 'valueAddress']" mode="Address">
                  <xsl:with-param name="key" select="'valueAddress'"/>
               </xsl:apply-templates>
               <!--valueAge 1..1 Age-->    <xsl:apply-templates select="*[@key = 'valueAge']" mode="Age">
                  <xsl:with-param name="key" select="'valueAge'"/>
               </xsl:apply-templates>
               <!--valueAnnotation 1..1 Annotation-->    <xsl:apply-templates select="*[@key = 'valueAnnotation']" mode="Annotation">
                  <xsl:with-param name="key" select="'valueAnnotation'"/>
               </xsl:apply-templates>
               <!--valueAttachment 1..1 Attachment-->    <xsl:apply-templates select="*[@key = 'valueAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'valueAttachment'"/>
               </xsl:apply-templates>
               <!--valueCodeableConcept 1..1 CodeableConcept-->    <xsl:apply-templates select="*[@key = 'valueCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'valueCodeableConcept'"/>
               </xsl:apply-templates>
               <!--valueCoding 1..1 Coding-->    <xsl:apply-templates select="*[@key = 'valueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'valueCoding'"/>
               </xsl:apply-templates>
               <!--valueContactPoint 1..1 ContactPoint-->    <xsl:apply-templates select="*[@key = 'valueContactPoint']" mode="ContactPoint">
                  <xsl:with-param name="key" select="'valueContactPoint'"/>
               </xsl:apply-templates>
               <!--valueCount 1..1 Count-->    <xsl:apply-templates select="*[@key = 'valueCount']" mode="Count">
                  <xsl:with-param name="key" select="'valueCount'"/>
               </xsl:apply-templates>
               <!--valueDistance 1..1 Distance-->    <xsl:apply-templates select="*[@key = 'valueDistance']" mode="Distance">
                  <xsl:with-param name="key" select="'valueDistance'"/>
               </xsl:apply-templates>
               <!--valueDuration 1..1 Duration-->    <xsl:apply-templates select="*[@key = 'valueDuration']" mode="Duration">
                  <xsl:with-param name="key" select="'valueDuration'"/>
               </xsl:apply-templates>
               <!--valueHumanName 1..1 HumanName-->    <xsl:apply-templates select="*[@key = 'valueHumanName']" mode="HumanName">
                  <xsl:with-param name="key" select="'valueHumanName'"/>
               </xsl:apply-templates>
               <!--valueIdentifier 1..1 Identifier-->    <xsl:apply-templates select="*[@key = 'valueIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'valueIdentifier'"/>
               </xsl:apply-templates>
               <!--valueMoney 1..1 Money-->    <xsl:apply-templates select="*[@key = 'valueMoney']" mode="Money">
                  <xsl:with-param name="key" select="'valueMoney'"/>
               </xsl:apply-templates>
               <!--valuePeriod 1..1 Period-->    <xsl:apply-templates select="*[@key = 'valuePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'valuePeriod'"/>
               </xsl:apply-templates>
               <!--valueQuantity 1..1 Quantity-->    <xsl:apply-templates select="*[@key = 'valueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'valueQuantity'"/>
               </xsl:apply-templates>
               <!--valueRange 1..1 Range-->    <xsl:apply-templates select="*[@key = 'valueRange']" mode="Range">
                  <xsl:with-param name="key" select="'valueRange'"/>
               </xsl:apply-templates>
               <!--valueRatio 1..1 Ratio-->    <xsl:apply-templates select="*[@key = 'valueRatio']" mode="Ratio">
                  <xsl:with-param name="key" select="'valueRatio'"/>
               </xsl:apply-templates>
               <!--valueReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'valueReference']" mode="Reference">
                  <xsl:with-param name="key" select="'valueReference'"/>
               </xsl:apply-templates>
               <!--valueSampledData 1..1 SampledData-->    <xsl:apply-templates select="*[@key = 'valueSampledData']" mode="SampledData">
                  <xsl:with-param name="key" select="'valueSampledData'"/>
               </xsl:apply-templates>
               <!--valueSignature 1..1 Signature-->    <xsl:apply-templates select="*[@key = 'valueSignature']" mode="Signature">
                  <xsl:with-param name="key" select="'valueSignature'"/>
               </xsl:apply-templates>
               <!--valueTiming 1..1 Timing-->    <xsl:apply-templates select="*[@key = 'valueTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'valueTiming'"/>
               </xsl:apply-templates>
               <!--valueMeta 1..1 Meta-->    <xsl:apply-templates select="*[@key = 'valueMeta']" mode="Meta">
                  <xsl:with-param name="key" select="'valueMeta'"/>
               </xsl:apply-templates>
         
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Slicing">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--discriminator 0..* ElementDefinition.Discriminator-->     <xsl:apply-templates select="*[@key = 'discriminator']"
                                    mode="ElementDefinition.Discriminator">
                  <xsl:with-param name="key" select="'discriminator'"/>
               </xsl:apply-templates>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--ordered 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'ordered']" mode="boolean">
                  <xsl:with-param name="key" select="'ordered'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ordered'])][*[@key = '_ordered']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ordered"/>
                        <xsl:copy-of select="fn:map[@key = '_ordered']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'ordered'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--rules 1..1 SlicingRules-->     <xsl:apply-templates select="*[@key = 'rules']" mode="SlicingRules">
                  <xsl:with-param name="key" select="'rules'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'rules'])][*[@key = '_rules']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="rules"/>
                        <xsl:copy-of select="fn:map[@key = '_rules']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SlicingRules">
                     <xsl:with-param name="key" select="'rules'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Binding">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--strength 1..1 BindingStrength-->     <xsl:apply-templates select="*[@key = 'strength']" mode="BindingStrength">
                  <xsl:with-param name="key" select="'strength'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'strength'])][*[@key = '_strength']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="strength"/>
                        <xsl:copy-of select="fn:map[@key = '_strength']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="BindingStrength">
                     <xsl:with-param name="key" select="'strength'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--valueSetUri 1..1 uri-->    <xsl:apply-templates select="*[@key = 'valueSetUri']" mode="uri">
                  <xsl:with-param name="key" select="'valueSetUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueSetUri'])][*[@key = '_valueSetUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetUri"/>
                        <xsl:copy-of select="fn:map[@key = '_valueSetUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'valueSetUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueSetReference 1..1 Reference-->    <xsl:apply-templates select="*[@key = 'valueSetReference']" mode="Reference">
                  <xsl:with-param name="key" select="'valueSetReference'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Discriminator">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--type 1..1 DiscriminatorType-->     <xsl:apply-templates select="*[@key = 'type']" mode="DiscriminatorType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DiscriminatorType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--path 1..1 string-->     <xsl:apply-templates select="*[@key = 'path']" mode="string">
                  <xsl:with-param name="key" select="'path'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'path'])][*[@key = '_path']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="path"/>
                        <xsl:copy-of select="fn:map[@key = '_path']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'path'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a property is represented when serialized.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="PropertyRepresentation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>SHALL applications comply with this constraint?</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConstraintSeverity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How resource references can be aggregated.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AggregationMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Whether a reference needs to be version specific or version independent, or whether either can be used</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ReferenceVersionRules">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How slices are interpreted when evaluating an instance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SlicingRules">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indication of the degree of conformance expectations associated with a binding.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="BindingStrength">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How an element value is interpreted when discrimination is evaluated</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DiscriminatorType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The parameters to the module. This collection specifies both the input and output parameters. Input parameters are provided by the caller as part of the $evaluate operation. Output parameters are included in the GuidanceResponse.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ParameterDefinition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Element"/>
               <!--name 0..1 code-->     <xsl:apply-templates select="*[@key = 'name']" mode="code">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--use 1..1 code-->     <xsl:apply-templates select="*[@key = 'use']" mode="code">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--min 0..1 integer-->     <xsl:apply-templates select="*[@key = 'min']" mode="integer">
                  <xsl:with-param name="key" select="'min'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'min'])][*[@key = '_min']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="min"/>
                        <xsl:copy-of select="fn:map[@key = '_min']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'min'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--max 0..1 string-->     <xsl:apply-templates select="*[@key = 'max']" mode="string">
                  <xsl:with-param name="key" select="'max'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'max'])][*[@key = '_max']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="max"/>
                        <xsl:copy-of select="fn:map[@key = '_max']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'max'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 1..1 code-->     <xsl:apply-templates select="*[@key = 'type']" mode="code">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--profile 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'profile']" mode="Reference">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A resource that includes narrative, extensions, and contained resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DomainResource">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Resource"/>
               <!--text 0..1 Narrative-->     <xsl:apply-templates select="*[@key = 'text']" mode="Narrative">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <!--contained 0..* ResourceContainer-->     <xsl:apply-templates select="*[@key = 'contained']" mode="ResourceContainer">
                  <xsl:with-param name="key" select="'contained'"/>
               </xsl:apply-templates>
               <!--extension 0..* Extension-->     <xsl:apply-templates select="*[@key = 'extension']" mode="Extension">
                  <xsl:with-param name="key" select="'extension'"/>
               </xsl:apply-templates>
               <!--modifierExtension 0..* Extension-->     <xsl:apply-templates select="*[@key = 'modifierExtension']" mode="Extension">
                  <xsl:with-param name="key" select="'modifierExtension'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This is the base resource type for everything.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Resource">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
          <!--id 0..1 id-->     <xsl:apply-templates select="*[@key = 'id']" mode="id">
                  <xsl:with-param name="key" select="'id'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'id'])][*[@key = '_id']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="id"/>
                        <xsl:copy-of select="fn:map[@key = '_id']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'id'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--meta 0..1 Meta-->     <xsl:apply-templates select="*[@key = 'meta']" mode="Meta">
                  <xsl:with-param name="key" select="'meta'"/>
               </xsl:apply-templates>
               <!--implicitRules 0..1 uri-->     <xsl:apply-templates select="*[@key = 'implicitRules']" mode="uri">
                  <xsl:with-param name="key" select="'implicitRules'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'implicitRules'])][*[@key = '_implicitRules']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="implicitRules"/>
                        <xsl:copy-of select="fn:map[@key = '_implicitRules']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'implicitRules'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--language 0..1 code-->     <xsl:apply-templates select="*[@key = 'language']" mode="code">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'language'])][*[@key = '_language']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="language"/>
                        <xsl:copy-of select="fn:map[@key = '_language']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'language'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="PublicationStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SearchParamType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AdministrativeGender">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="RemittanceOutcome">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="NoteType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMapEquivalence">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReferenceStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Account">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--status 0..1 AccountStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="AccountStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AccountStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--subject 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <!--active 0..1 Period-->     <xsl:apply-templates select="*[@key = 'active']" mode="Period">
                  <xsl:with-param name="key" select="'active'"/>
               </xsl:apply-templates>
               <!--balance 0..1 Money-->     <xsl:apply-templates select="*[@key = 'balance']" mode="Money">
                  <xsl:with-param name="key" select="'balance'"/>
               </xsl:apply-templates>
               <!--coverage 0..* Account.Coverage-->     <xsl:apply-templates select="*[@key = 'coverage']" mode="Account.Coverage">
                  <xsl:with-param name="key" select="'coverage'"/>
               </xsl:apply-templates>
               <!--owner 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'owner']" mode="Reference">
                  <xsl:with-param name="key" select="'owner'"/>
               </xsl:apply-templates>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--guarantor 0..* Account.Guarantor-->     <xsl:apply-templates select="*[@key = 'guarantor']" mode="Account.Guarantor">
                  <xsl:with-param name="key" select="'guarantor'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Account.Coverage">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--coverage 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'coverage']" mode="Reference">
                  <xsl:with-param name="key" select="'coverage'"/>
               </xsl:apply-templates>
               <!--priority 0..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'priority']" mode="positiveInt">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'priority'])][*[@key = '_priority']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority"/>
                        <xsl:copy-of select="fn:map[@key = '_priority']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'priority'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Account.Guarantor">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--party 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'party']" mode="Reference">
                  <xsl:with-param name="key" select="'party'"/>
               </xsl:apply-templates>
               <!--onHold 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'onHold']" mode="boolean">
                  <xsl:with-param name="key" select="'onHold'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onHold'])][*[@key = '_onHold']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onHold"/>
                        <xsl:copy-of select="fn:map[@key = '_onHold']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'onHold'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the account is available to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AccountStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ActivityDefinition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--url 0..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--version 0..1 string-->     <xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--title 0..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--status 1..1 PublicationStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="PublicationStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="PublicationStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--experimental 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'experimental']" mode="boolean">
                  <xsl:with-param name="key" select="'experimental'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'experimental'])][*[@key = '_experimental']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="experimental"/>
                        <xsl:copy-of select="fn:map[@key = '_experimental']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'experimental'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--date 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--publisher 0..1 string-->     <xsl:apply-templates select="*[@key = 'publisher']" mode="string">
                  <xsl:with-param name="key" select="'publisher'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'publisher'])][*[@key = '_publisher']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher"/>
                        <xsl:copy-of select="fn:map[@key = '_publisher']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'publisher'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--description 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'description']" mode="markdown">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--purpose 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'purpose']" mode="markdown">
                  <xsl:with-param name="key" select="'purpose'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'purpose'])][*[@key = '_purpose']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose"/>
                        <xsl:copy-of select="fn:map[@key = '_purpose']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'purpose'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--usage 0..1 string-->     <xsl:apply-templates select="*[@key = 'usage']" mode="string">
                  <xsl:with-param name="key" select="'usage'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'usage'])][*[@key = '_usage']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="usage"/>
                        <xsl:copy-of select="fn:map[@key = '_usage']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'usage'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--approvalDate 0..1 date-->     <xsl:apply-templates select="*[@key = 'approvalDate']" mode="date">
                  <xsl:with-param name="key" select="'approvalDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'approvalDate'])][*[@key = '_approvalDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="approvalDate"/>
                        <xsl:copy-of select="fn:map[@key = '_approvalDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'approvalDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--lastReviewDate 0..1 date-->     <xsl:apply-templates select="*[@key = 'lastReviewDate']" mode="date">
                  <xsl:with-param name="key" select="'lastReviewDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lastReviewDate'])][*[@key = '_lastReviewDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastReviewDate"/>
                        <xsl:copy-of select="fn:map[@key = '_lastReviewDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'lastReviewDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--effectivePeriod 0..1 Period-->     <xsl:apply-templates select="*[@key = 'effectivePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'effectivePeriod'"/>
               </xsl:apply-templates>
               <!--useContext 0..* UsageContext-->     <xsl:apply-templates select="*[@key = 'useContext']" mode="UsageContext">
                  <xsl:with-param name="key" select="'useContext'"/>
               </xsl:apply-templates>
               <!--jurisdiction 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'jurisdiction']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'jurisdiction'"/>
               </xsl:apply-templates>
               <!--topic 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'topic']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'topic'"/>
               </xsl:apply-templates>
               <!--contributor 0..* Contributor-->     <xsl:apply-templates select="*[@key = 'contributor']" mode="Contributor">
                  <xsl:with-param name="key" select="'contributor'"/>
               </xsl:apply-templates>
               <!--contact 0..* ContactDetail-->     <xsl:apply-templates select="*[@key = 'contact']" mode="ContactDetail">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
               <!--copyright 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'copyright']" mode="markdown">
                  <xsl:with-param name="key" select="'copyright'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'copyright'])][*[@key = '_copyright']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright"/>
                        <xsl:copy-of select="fn:map[@key = '_copyright']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'copyright'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--relatedArtifact 0..* RelatedArtifact-->     <xsl:apply-templates select="*[@key = 'relatedArtifact']" mode="RelatedArtifact">
                  <xsl:with-param name="key" select="'relatedArtifact'"/>
               </xsl:apply-templates>
               <!--library 0..* Reference-->     <xsl:apply-templates select="*[@key = 'library']" mode="Reference">
                  <xsl:with-param name="key" select="'library'"/>
               </xsl:apply-templates>
               <!--kind 0..1 ResourceType-->     <xsl:apply-templates select="*[@key = 'kind']" mode="ResourceType">
                  <xsl:with-param name="key" select="'kind'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'kind'])][*[@key = '_kind']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="kind"/>
                        <xsl:copy-of select="fn:map[@key = '_kind']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ResourceType">
                     <xsl:with-param name="key" select="'kind'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
          
            
               <!--timingTiming 1..1 Timing-->   <xsl:apply-templates select="*[@key = 'timingTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'timingTiming'"/>
               </xsl:apply-templates>
               <!--timingDateTime 1..1 dateTime-->   <xsl:apply-templates select="*[@key = 'timingDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'timingDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'timingDateTime'])][*[@key = '_timingDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_timingDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'timingDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--timingPeriod 1..1 Period-->   <xsl:apply-templates select="*[@key = 'timingPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'timingPeriod'"/>
               </xsl:apply-templates>
               <!--timingRange 1..1 Range-->   <xsl:apply-templates select="*[@key = 'timingRange']" mode="Range">
                  <xsl:with-param name="key" select="'timingRange'"/>
               </xsl:apply-templates>
          
               <!--location 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'location']" mode="Reference">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
               <!--participant 0..* ActivityDefinition.Participant-->     <xsl:apply-templates select="*[@key = 'participant']" mode="ActivityDefinition.Participant">
                  <xsl:with-param name="key" select="'participant'"/>
               </xsl:apply-templates>
          
            
               <!--productReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'productReference']" mode="Reference">
                  <xsl:with-param name="key" select="'productReference'"/>
               </xsl:apply-templates>
               <!--productCodeableConcept 1..1 CodeableConcept-->   <xsl:apply-templates select="*[@key = 'productCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'productCodeableConcept'"/>
               </xsl:apply-templates>
          
               <!--quantity 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'quantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
               <!--dosage 0..* Dosage-->     <xsl:apply-templates select="*[@key = 'dosage']" mode="Dosage">
                  <xsl:with-param name="key" select="'dosage'"/>
               </xsl:apply-templates>
               <!--bodySite 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'bodySite']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'bodySite'"/>
               </xsl:apply-templates>
               <!--transform 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'transform']" mode="Reference">
                  <xsl:with-param name="key" select="'transform'"/>
               </xsl:apply-templates>
               <!--dynamicValue 0..* ActivityDefinition.DynamicValue-->     <xsl:apply-templates select="*[@key = 'dynamicValue']"
                                    mode="ActivityDefinition.DynamicValue">
                  <xsl:with-param name="key" select="'dynamicValue'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ActivityDefinition.Participant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--type 1..1 ActionParticipantType-->     <xsl:apply-templates select="*[@key = 'type']" mode="ActionParticipantType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ActionParticipantType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--role 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ActivityDefinition.DynamicValue">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--path 0..1 string-->     <xsl:apply-templates select="*[@key = 'path']" mode="string">
                  <xsl:with-param name="key" select="'path'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'path'])][*[@key = '_path']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="path"/>
                        <xsl:copy-of select="fn:map[@key = '_path']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'path'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--language 0..1 string-->     <xsl:apply-templates select="*[@key = 'language']" mode="string">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'language'])][*[@key = '_language']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="language"/>
                        <xsl:copy-of select="fn:map[@key = '_language']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'language'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--expression 0..1 string-->     <xsl:apply-templates select="*[@key = 'expression']" mode="string">
                  <xsl:with-param name="key" select="'expression'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'expression'])][*[@key = '_expression']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="expression"/>
                        <xsl:copy-of select="fn:map[@key = '_expression']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'expression'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of participant in the activity</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ActionParticipantType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The kind of activity the definition is describing</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ResourceType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>Actual or  potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AdverseEvent">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--category 0..1 AdverseEventCategory-->     <xsl:apply-templates select="*[@key = 'category']" mode="AdverseEventCategory">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'category'])][*[@key = '_category']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="category"/>
                        <xsl:copy-of select="fn:map[@key = '_category']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AdverseEventCategory">
                     <xsl:with-param name="key" select="'category'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--subject 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--date 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--reaction 0..* Reference-->     <xsl:apply-templates select="*[@key = 'reaction']" mode="Reference">
                  <xsl:with-param name="key" select="'reaction'"/>
               </xsl:apply-templates>
               <!--location 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'location']" mode="Reference">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
               <!--seriousness 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'seriousness']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'seriousness'"/>
               </xsl:apply-templates>
               <!--outcome 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'outcome']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'outcome'"/>
               </xsl:apply-templates>
               <!--recorder 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'recorder']" mode="Reference">
                  <xsl:with-param name="key" select="'recorder'"/>
               </xsl:apply-templates>
               <!--eventParticipant 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'eventParticipant']" mode="Reference">
                  <xsl:with-param name="key" select="'eventParticipant'"/>
               </xsl:apply-templates>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--suspectEntity 0..* AdverseEvent.SuspectEntity-->     <xsl:apply-templates select="*[@key = 'suspectEntity']" mode="AdverseEvent.SuspectEntity">
                  <xsl:with-param name="key" select="'suspectEntity'"/>
               </xsl:apply-templates>
               <!--subjectMedicalHistory 0..* Reference-->     <xsl:apply-templates select="*[@key = 'subjectMedicalHistory']" mode="Reference">
                  <xsl:with-param name="key" select="'subjectMedicalHistory'"/>
               </xsl:apply-templates>
               <!--referenceDocument 0..* Reference-->     <xsl:apply-templates select="*[@key = 'referenceDocument']" mode="Reference">
                  <xsl:with-param name="key" select="'referenceDocument'"/>
               </xsl:apply-templates>
               <!--study 0..* Reference-->     <xsl:apply-templates select="*[@key = 'study']" mode="Reference">
                  <xsl:with-param name="key" select="'study'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Actual or  potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AdverseEvent.SuspectEntity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--instance 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'instance']" mode="Reference">
                  <xsl:with-param name="key" select="'instance'"/>
               </xsl:apply-templates>
               <!--causality 0..1 AdverseEventCausality-->     <xsl:apply-templates select="*[@key = 'causality']" mode="AdverseEventCausality">
                  <xsl:with-param name="key" select="'causality'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'causality'])][*[@key = '_causality']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="causality"/>
                        <xsl:copy-of select="fn:map[@key = '_causality']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AdverseEventCausality">
                     <xsl:with-param name="key" select="'causality'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--causalityAssessment 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'causalityAssessment']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'causalityAssessment'"/>
               </xsl:apply-templates>
               <!--causalityProductRelatedness 0..1 string-->     <xsl:apply-templates select="*[@key = 'causalityProductRelatedness']" mode="string">
                  <xsl:with-param name="key" select="'causalityProductRelatedness'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'causalityProductRelatedness'])][*[@key = '_causalityProductRelatedness']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="causalityProductRelatedness"/>
                        <xsl:copy-of select="fn:map[@key = '_causalityProductRelatedness']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'causalityProductRelatedness'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--causalityMethod 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'causalityMethod']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'causalityMethod'"/>
               </xsl:apply-templates>
               <!--causalityAuthor 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'causalityAuthor']" mode="Reference">
                  <xsl:with-param name="key" select="'causalityAuthor'"/>
               </xsl:apply-templates>
               <!--causalityResult 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'causalityResult']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'causalityResult'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>TODO</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AdverseEventCausality">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Overall categorization of the event, e.g. real or potential</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AdverseEventCategory">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntolerance">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--clinicalStatus 0..1 AllergyIntoleranceClinicalStatus-->     <xsl:apply-templates select="*[@key = 'clinicalStatus']"
                                    mode="AllergyIntoleranceClinicalStatus">
                  <xsl:with-param name="key" select="'clinicalStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'clinicalStatus'])][*[@key = '_clinicalStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="clinicalStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_clinicalStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceClinicalStatus">
                     <xsl:with-param name="key" select="'clinicalStatus'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--verificationStatus 1..1 AllergyIntoleranceVerificationStatus-->     <xsl:apply-templates select="*[@key = 'verificationStatus']"
                                    mode="AllergyIntoleranceVerificationStatus">
                  <xsl:with-param name="key" select="'verificationStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'verificationStatus'])][*[@key = '_verificationStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="verificationStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_verificationStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string"
                                       mode="AllergyIntoleranceVerificationStatus">
                     <xsl:with-param name="key" select="'verificationStatus'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 AllergyIntoleranceType-->     <xsl:apply-templates select="*[@key = 'type']" mode="AllergyIntoleranceType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--category 0..* AllergyIntoleranceCategory-->     <xsl:apply-templates select="*[@key = 'category']" mode="AllergyIntoleranceCategory">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'category'])][*[@key = '_category']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="category"/>
                        <xsl:copy-of select="fn:map[@key = '_category']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceCategory">
                     <xsl:with-param name="key" select="'category'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--criticality 0..1 AllergyIntoleranceCriticality-->     <xsl:apply-templates select="*[@key = 'criticality']" mode="AllergyIntoleranceCriticality">
                  <xsl:with-param name="key" select="'criticality'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'criticality'])][*[@key = '_criticality']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="criticality"/>
                        <xsl:copy-of select="fn:map[@key = '_criticality']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceCriticality">
                     <xsl:with-param name="key" select="'criticality'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--patient 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
          
            
               <!--onsetDateTime 1..1 dateTime-->   <xsl:apply-templates select="*[@key = 'onsetDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'onsetDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onsetDateTime'])][*[@key = '_onsetDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_onsetDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'onsetDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--onsetAge 1..1 Age-->   <xsl:apply-templates select="*[@key = 'onsetAge']" mode="Age">
                  <xsl:with-param name="key" select="'onsetAge'"/>
               </xsl:apply-templates>
               <!--onsetPeriod 1..1 Period-->   <xsl:apply-templates select="*[@key = 'onsetPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'onsetPeriod'"/>
               </xsl:apply-templates>
               <!--onsetRange 1..1 Range-->   <xsl:apply-templates select="*[@key = 'onsetRange']" mode="Range">
                  <xsl:with-param name="key" select="'onsetRange'"/>
               </xsl:apply-templates>
               <!--onsetString 1..1 string-->   <xsl:apply-templates select="*[@key = 'onsetString']" mode="string">
                  <xsl:with-param name="key" select="'onsetString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onsetString'])][*[@key = '_onsetString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetString"/>
                        <xsl:copy-of select="fn:map[@key = '_onsetString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'onsetString'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
               <!--assertedDate 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'assertedDate']" mode="dateTime">
                  <xsl:with-param name="key" select="'assertedDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'assertedDate'])][*[@key = '_assertedDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="assertedDate"/>
                        <xsl:copy-of select="fn:map[@key = '_assertedDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'assertedDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--recorder 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'recorder']" mode="Reference">
                  <xsl:with-param name="key" select="'recorder'"/>
               </xsl:apply-templates>
               <!--asserter 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'asserter']" mode="Reference">
                  <xsl:with-param name="key" select="'asserter'"/>
               </xsl:apply-templates>
               <!--lastOccurrence 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'lastOccurrence']" mode="dateTime">
                  <xsl:with-param name="key" select="'lastOccurrence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lastOccurrence'])][*[@key = '_lastOccurrence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastOccurrence"/>
                        <xsl:copy-of select="fn:map[@key = '_lastOccurrence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'lastOccurrence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--note 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
               <!--reaction 0..* AllergyIntolerance.Reaction-->     <xsl:apply-templates select="*[@key = 'reaction']" mode="AllergyIntolerance.Reaction">
                  <xsl:with-param name="key" select="'reaction'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntolerance.Reaction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--substance 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'substance']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'substance'"/>
               </xsl:apply-templates>
               <!--manifestation 1..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'manifestation']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'manifestation'"/>
               </xsl:apply-templates>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--onset 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'onset']" mode="dateTime">
                  <xsl:with-param name="key" select="'onset'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'onset'])][*[@key = '_onset']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="onset"/>
                        <xsl:copy-of select="fn:map[@key = '_onset']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'onset'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--severity 0..1 AllergyIntoleranceSeverity-->     <xsl:apply-templates select="*[@key = 'severity']" mode="AllergyIntoleranceSeverity">
                  <xsl:with-param name="key" select="'severity'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'severity'])][*[@key = '_severity']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity"/>
                        <xsl:copy-of select="fn:map[@key = '_severity']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AllergyIntoleranceSeverity">
                     <xsl:with-param name="key" select="'severity'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--exposureRoute 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'exposureRoute']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'exposureRoute'"/>
               </xsl:apply-templates>
               <!--note 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Estimate of the potential clinical harm, or seriousness, of a reaction to an identified substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCriticality">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Identification of the underlying physiological mechanism for a Reaction Risk.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Category of an identified substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCategory">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Assertion about certainty associated with a propensity, or potential risk, of a reaction to the identified substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceVerificationStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Clinical assessment of the severity of a reaction event as a whole, potentially considering multiple different manifestations.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceSeverity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The clinical status of the allergy or intolerance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceClinicalStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Appointment">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--status 1..1 AppointmentStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="AppointmentStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AppointmentStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--serviceCategory 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'serviceCategory']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'serviceCategory'"/>
               </xsl:apply-templates>
               <!--serviceType 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'serviceType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'serviceType'"/>
               </xsl:apply-templates>
               <!--specialty 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'specialty']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'specialty'"/>
               </xsl:apply-templates>
               <!--appointmentType 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'appointmentType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'appointmentType'"/>
               </xsl:apply-templates>
               <!--reason 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'reason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
               <!--indication 0..* Reference-->     <xsl:apply-templates select="*[@key = 'indication']" mode="Reference">
                  <xsl:with-param name="key" select="'indication'"/>
               </xsl:apply-templates>
               <!--priority 0..1 unsignedInt-->     <xsl:apply-templates select="*[@key = 'priority']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'priority'])][*[@key = '_priority']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority"/>
                        <xsl:copy-of select="fn:map[@key = '_priority']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'priority'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--supportingInformation 0..* Reference-->     <xsl:apply-templates select="*[@key = 'supportingInformation']" mode="Reference">
                  <xsl:with-param name="key" select="'supportingInformation'"/>
               </xsl:apply-templates>
               <!--start 0..1 instant-->     <xsl:apply-templates select="*[@key = 'start']" mode="instant">
                  <xsl:with-param name="key" select="'start'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'start'])][*[@key = '_start']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="start"/>
                        <xsl:copy-of select="fn:map[@key = '_start']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'start'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--end 0..1 instant-->     <xsl:apply-templates select="*[@key = 'end']" mode="instant">
                  <xsl:with-param name="key" select="'end'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'end'])][*[@key = '_end']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="end"/>
                        <xsl:copy-of select="fn:map[@key = '_end']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'end'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--minutesDuration 0..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'minutesDuration']" mode="positiveInt">
                  <xsl:with-param name="key" select="'minutesDuration'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'minutesDuration'])][*[@key = '_minutesDuration']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="minutesDuration"/>
                        <xsl:copy-of select="fn:map[@key = '_minutesDuration']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'minutesDuration'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--slot 0..* Reference-->     <xsl:apply-templates select="*[@key = 'slot']" mode="Reference">
                  <xsl:with-param name="key" select="'slot'"/>
               </xsl:apply-templates>
               <!--created 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'created']" mode="dateTime">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--comment 0..1 string-->     <xsl:apply-templates select="*[@key = 'comment']" mode="string">
                  <xsl:with-param name="key" select="'comment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comment'])][*[@key = '_comment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment"/>
                        <xsl:copy-of select="fn:map[@key = '_comment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comment'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--incomingReferral 0..* Reference-->     <xsl:apply-templates select="*[@key = 'incomingReferral']" mode="Reference">
                  <xsl:with-param name="key" select="'incomingReferral'"/>
               </xsl:apply-templates>
               <!--participant 1..* Appointment.Participant-->     <xsl:apply-templates select="*[@key = 'participant']" mode="Appointment.Participant">
                  <xsl:with-param name="key" select="'participant'"/>
               </xsl:apply-templates>
               <!--requestedPeriod 0..* Period-->     <xsl:apply-templates select="*[@key = 'requestedPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'requestedPeriod'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Appointment.Participant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--type 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--actor 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'actor']" mode="Reference">
                  <xsl:with-param name="key" select="'actor'"/>
               </xsl:apply-templates>
               <!--required 0..1 ParticipantRequired-->     <xsl:apply-templates select="*[@key = 'required']" mode="ParticipantRequired">
                  <xsl:with-param name="key" select="'required'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'required'])][*[@key = '_required']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="required"/>
                        <xsl:copy-of select="fn:map[@key = '_required']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ParticipantRequired">
                     <xsl:with-param name="key" select="'required'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--status 1..1 ParticipationStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="ParticipationStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ParticipationStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Is the Participant required to attend the appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ParticipantRequired">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The free/busy status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AppointmentStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Participation status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ParticipationStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AppointmentResponse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--appointment 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'appointment']" mode="Reference">
                  <xsl:with-param name="key" select="'appointment'"/>
               </xsl:apply-templates>
               <!--start 0..1 instant-->     <xsl:apply-templates select="*[@key = 'start']" mode="instant">
                  <xsl:with-param name="key" select="'start'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'start'])][*[@key = '_start']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="start"/>
                        <xsl:copy-of select="fn:map[@key = '_start']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'start'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--end 0..1 instant-->     <xsl:apply-templates select="*[@key = 'end']" mode="instant">
                  <xsl:with-param name="key" select="'end'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'end'])][*[@key = '_end']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="end"/>
                        <xsl:copy-of select="fn:map[@key = '_end']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'end'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--participantType 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'participantType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'participantType'"/>
               </xsl:apply-templates>
               <!--actor 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'actor']" mode="Reference">
                  <xsl:with-param name="key" select="'actor'"/>
               </xsl:apply-templates>
               <!--participantStatus 1..1 ParticipationStatus-->     <xsl:apply-templates select="*[@key = 'participantStatus']" mode="ParticipationStatus">
                  <xsl:with-param name="key" select="'participantStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'participantStatus'])][*[@key = '_participantStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="participantStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_participantStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ParticipationStatus">
                     <xsl:with-param name="key" select="'participantStatus'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--comment 0..1 string-->     <xsl:apply-templates select="*[@key = 'comment']" mode="string">
                  <xsl:with-param name="key" select="'comment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comment'])][*[@key = '_comment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment"/>
                        <xsl:copy-of select="fn:map[@key = '_comment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comment'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--type 1..1 Coding-->     <xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--subtype 0..* Coding-->     <xsl:apply-templates select="*[@key = 'subtype']" mode="Coding">
                  <xsl:with-param name="key" select="'subtype'"/>
               </xsl:apply-templates>
               <!--action 0..1 AuditEventAction-->     <xsl:apply-templates select="*[@key = 'action']" mode="AuditEventAction">
                  <xsl:with-param name="key" select="'action'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'action'])][*[@key = '_action']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="action"/>
                        <xsl:copy-of select="fn:map[@key = '_action']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AuditEventAction">
                     <xsl:with-param name="key" select="'action'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--recorded 1..1 instant-->     <xsl:apply-templates select="*[@key = 'recorded']" mode="instant">
                  <xsl:with-param name="key" select="'recorded'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'recorded'])][*[@key = '_recorded']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="recorded"/>
                        <xsl:copy-of select="fn:map[@key = '_recorded']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'recorded'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--outcome 0..1 AuditEventOutcome-->     <xsl:apply-templates select="*[@key = 'outcome']" mode="AuditEventOutcome">
                  <xsl:with-param name="key" select="'outcome'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'outcome'])][*[@key = '_outcome']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome"/>
                        <xsl:copy-of select="fn:map[@key = '_outcome']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AuditEventOutcome">
                     <xsl:with-param name="key" select="'outcome'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--outcomeDesc 0..1 string-->     <xsl:apply-templates select="*[@key = 'outcomeDesc']" mode="string">
                  <xsl:with-param name="key" select="'outcomeDesc'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'outcomeDesc'])][*[@key = '_outcomeDesc']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcomeDesc"/>
                        <xsl:copy-of select="fn:map[@key = '_outcomeDesc']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'outcomeDesc'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--purposeOfEvent 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'purposeOfEvent']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'purposeOfEvent'"/>
               </xsl:apply-templates>
               <!--agent 1..* AuditEvent.Agent-->     <xsl:apply-templates select="*[@key = 'agent']" mode="AuditEvent.Agent">
                  <xsl:with-param name="key" select="'agent'"/>
               </xsl:apply-templates>
               <!--source 1..1 AuditEvent.Source-->     <xsl:apply-templates select="*[@key = 'source']" mode="AuditEvent.Source">
                  <xsl:with-param name="key" select="'source'"/>
               </xsl:apply-templates>
               <!--entity 0..* AuditEvent.Entity-->     <xsl:apply-templates select="*[@key = 'entity']" mode="AuditEvent.Entity">
                  <xsl:with-param name="key" select="'entity'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Agent">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--role 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
               <!--reference 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'reference']" mode="Reference">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
               <!--userId 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'userId']" mode="Identifier">
                  <xsl:with-param name="key" select="'userId'"/>
               </xsl:apply-templates>
               <!--altId 0..1 string-->     <xsl:apply-templates select="*[@key = 'altId']" mode="string">
                  <xsl:with-param name="key" select="'altId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'altId'])][*[@key = '_altId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="altId"/>
                        <xsl:copy-of select="fn:map[@key = '_altId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'altId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--requestor 1..1 boolean-->     <xsl:apply-templates select="*[@key = 'requestor']" mode="boolean">
                  <xsl:with-param name="key" select="'requestor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'requestor'])][*[@key = '_requestor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="requestor"/>
                        <xsl:copy-of select="fn:map[@key = '_requestor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'requestor'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--location 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'location']" mode="Reference">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
               <!--policy 0..* uri-->     <xsl:apply-templates select="*[@key = 'policy']" mode="uri">
                  <xsl:with-param name="key" select="'policy'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'policy'])][*[@key = '_policy']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="policy"/>
                        <xsl:copy-of select="fn:map[@key = '_policy']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'policy'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--media 0..1 Coding-->     <xsl:apply-templates select="*[@key = 'media']" mode="Coding">
                  <xsl:with-param name="key" select="'media'"/>
               </xsl:apply-templates>
               <!--network 0..1 AuditEvent.Network-->     <xsl:apply-templates select="*[@key = 'network']" mode="AuditEvent.Network">
                  <xsl:with-param name="key" select="'network'"/>
               </xsl:apply-templates>
               <!--purposeOfUse 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'purposeOfUse']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'purposeOfUse'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Network">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--address 0..1 string-->     <xsl:apply-templates select="*[@key = 'address']" mode="string">
                  <xsl:with-param name="key" select="'address'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'address'])][*[@key = '_address']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="address"/>
                        <xsl:copy-of select="fn:map[@key = '_address']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'address'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 AuditEventAgentNetworkType-->     <xsl:apply-templates select="*[@key = 'type']" mode="AuditEventAgentNetworkType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="AuditEventAgentNetworkType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Source">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--site 0..1 string-->     <xsl:apply-templates select="*[@key = 'site']" mode="string">
                  <xsl:with-param name="key" select="'site'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'site'])][*[@key = '_site']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="site"/>
                        <xsl:copy-of select="fn:map[@key = '_site']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'site'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--identifier 1..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--type 0..* Coding-->     <xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Entity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--reference 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'reference']" mode="Reference">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
               <!--type 0..1 Coding-->     <xsl:apply-templates select="*[@key = 'type']" mode="Coding">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--role 0..1 Coding-->     <xsl:apply-templates select="*[@key = 'role']" mode="Coding">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
               <!--lifecycle 0..1 Coding-->     <xsl:apply-templates select="*[@key = 'lifecycle']" mode="Coding">
                  <xsl:with-param name="key" select="'lifecycle'"/>
               </xsl:apply-templates>
               <!--securityLabel 0..* Coding-->     <xsl:apply-templates select="*[@key = 'securityLabel']" mode="Coding">
                  <xsl:with-param name="key" select="'securityLabel'"/>
               </xsl:apply-templates>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--query 0..1 base64Binary-->     <xsl:apply-templates select="*[@key = 'query']" mode="base64Binary">
                  <xsl:with-param name="key" select="'query'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'query'])][*[@key = '_query']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="query"/>
                        <xsl:copy-of select="fn:map[@key = '_query']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'query'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--detail 0..* AuditEvent.Detail-->     <xsl:apply-templates select="*[@key = 'detail']" mode="AuditEvent.Detail">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Detail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--type 1..1 string-->     <xsl:apply-templates select="*[@key = 'type']" mode="string">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--value 1..1 base64Binary-->     <xsl:apply-templates select="*[@key = 'value']" mode="base64Binary">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the event succeeded or failed</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventOutcome">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicator for type of action performed during the event that generated the event</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventAction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of network access point of this agent in the audit event</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventAgentNetworkType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Basic">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--code 1..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--subject 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--created 0..1 date-->     <xsl:apply-templates select="*[@key = 'created']" mode="date">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--author 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A binary resource can contain any content, whether text, image, pdf, zip archive, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Binary">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Resource"/>
               <!--contentType 1..1 code-->     <xsl:apply-templates select="*[@key = 'contentType']" mode="code">
                  <xsl:with-param name="key" select="'contentType'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentType'])][*[@key = '_contentType']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType"/>
                        <xsl:copy-of select="fn:map[@key = '_contentType']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'contentType'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--securityContext 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'securityContext']" mode="Reference">
                  <xsl:with-param name="key" select="'securityContext'"/>
               </xsl:apply-templates>
               <!--content 1..1 base64Binary-->     <xsl:apply-templates select="*[@key = 'content']" mode="base64Binary">
                  <xsl:with-param name="key" select="'content'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'content'])][*[@key = '_content']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="content"/>
                        <xsl:copy-of select="fn:map[@key = '_content']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'content'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>Record details about the anatomical location of a specimen or body part.  This resource may be used when a coded concept does not provide the necessary detail needed for the use case.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="BodySite">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--active 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'active']" mode="boolean">
                  <xsl:with-param name="key" select="'active'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'active'])][*[@key = '_active']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="active"/>
                        <xsl:copy-of select="fn:map[@key = '_active']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'active'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--qualifier 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'qualifier']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'qualifier'"/>
               </xsl:apply-templates>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--image 0..* Attachment-->     <xsl:apply-templates select="*[@key = 'image']" mode="Attachment">
                  <xsl:with-param name="key" select="'image'"/>
               </xsl:apply-templates>
               <!--patient 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="Resource"/>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--type 1..1 BundleType-->     <xsl:apply-templates select="*[@key = 'type']" mode="BundleType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="BundleType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--total 0..1 unsignedInt-->     <xsl:apply-templates select="*[@key = 'total']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'total'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'total'])][*[@key = '_total']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="total"/>
                        <xsl:copy-of select="fn:map[@key = '_total']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'total'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--link 0..* Bundle.Link-->     <xsl:apply-templates select="*[@key = 'link']" mode="Bundle.Link">
                  <xsl:with-param name="key" select="'link'"/>
               </xsl:apply-templates>
               <!--entry 0..* Bundle.Entry-->     <xsl:apply-templates select="*[@key = 'entry']" mode="Bundle.Entry">
                  <xsl:with-param name="key" select="'entry'"/>
               </xsl:apply-templates>
               <!--signature 0..1 Signature-->     <xsl:apply-templates select="*[@key = 'signature']" mode="Signature">
                  <xsl:with-param name="key" select="'signature'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Link">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--relation 1..1 string-->     <xsl:apply-templates select="*[@key = 'relation']" mode="string">
                  <xsl:with-param name="key" select="'relation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'relation'])][*[@key = '_relation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="relation"/>
                        <xsl:copy-of select="fn:map[@key = '_relation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'relation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--url 1..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Entry">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--link 0..* Bundle.Link-->     <xsl:apply-templates select="*[@key = 'link']" mode="Bundle.Link">
                  <xsl:with-param name="key" select="'link'"/>
               </xsl:apply-templates>
               <!--fullUrl 0..1 uri-->     <xsl:apply-templates select="*[@key = 'fullUrl']" mode="uri">
                  <xsl:with-param name="key" select="'fullUrl'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fullUrl'])][*[@key = '_fullUrl']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fullUrl"/>
                        <xsl:copy-of select="fn:map[@key = '_fullUrl']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'fullUrl'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--resource 0..1 ResourceContainer-->     <xsl:apply-templates select="*[@key = 'resource']" mode="ResourceContainer">
                  <xsl:with-param name="key" select="'resource'"/>
               </xsl:apply-templates>
               <!--search 0..1 Bundle.Search-->     <xsl:apply-templates select="*[@key = 'search']" mode="Bundle.Search">
                  <xsl:with-param name="key" select="'search'"/>
               </xsl:apply-templates>
               <!--request 0..1 Bundle.Request-->     <xsl:apply-templates select="*[@key = 'request']" mode="Bundle.Request">
                  <xsl:with-param name="key" select="'request'"/>
               </xsl:apply-templates>
               <!--response 0..1 Bundle.Response-->     <xsl:apply-templates select="*[@key = 'response']" mode="Bundle.Response">
                  <xsl:with-param name="key" select="'response'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Search">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--mode 0..1 SearchEntryMode-->     <xsl:apply-templates select="*[@key = 'mode']" mode="SearchEntryMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SearchEntryMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--score 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'score']" mode="decimal">
                  <xsl:with-param name="key" select="'score'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'score'])][*[@key = '_score']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="score"/>
                        <xsl:copy-of select="fn:map[@key = '_score']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'score'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Request">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--method 1..1 HTTPVerb-->     <xsl:apply-templates select="*[@key = 'method']" mode="HTTPVerb">
                  <xsl:with-param name="key" select="'method'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'method'])][*[@key = '_method']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="method"/>
                        <xsl:copy-of select="fn:map[@key = '_method']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="HTTPVerb">
                     <xsl:with-param name="key" select="'method'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--url 1..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--ifNoneMatch 0..1 string-->     <xsl:apply-templates select="*[@key = 'ifNoneMatch']" mode="string">
                  <xsl:with-param name="key" select="'ifNoneMatch'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ifNoneMatch'])][*[@key = '_ifNoneMatch']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifNoneMatch"/>
                        <xsl:copy-of select="fn:map[@key = '_ifNoneMatch']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'ifNoneMatch'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--ifModifiedSince 0..1 instant-->     <xsl:apply-templates select="*[@key = 'ifModifiedSince']" mode="instant">
                  <xsl:with-param name="key" select="'ifModifiedSince'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ifModifiedSince'])][*[@key = '_ifModifiedSince']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifModifiedSince"/>
                        <xsl:copy-of select="fn:map[@key = '_ifModifiedSince']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'ifModifiedSince'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--ifMatch 0..1 string-->     <xsl:apply-templates select="*[@key = 'ifMatch']" mode="string">
                  <xsl:with-param name="key" select="'ifMatch'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ifMatch'])][*[@key = '_ifMatch']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifMatch"/>
                        <xsl:copy-of select="fn:map[@key = '_ifMatch']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'ifMatch'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--ifNoneExist 0..1 string-->     <xsl:apply-templates select="*[@key = 'ifNoneExist']" mode="string">
                  <xsl:with-param name="key" select="'ifNoneExist'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'ifNoneExist'])][*[@key = '_ifNoneExist']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifNoneExist"/>
                        <xsl:copy-of select="fn:map[@key = '_ifNoneExist']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'ifNoneExist'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Response">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--status 1..1 string-->     <xsl:apply-templates select="*[@key = 'status']" mode="string">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--location 0..1 uri-->     <xsl:apply-templates select="*[@key = 'location']" mode="uri">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'location'])][*[@key = '_location']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="location"/>
                        <xsl:copy-of select="fn:map[@key = '_location']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'location'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--etag 0..1 string-->     <xsl:apply-templates select="*[@key = 'etag']" mode="string">
                  <xsl:with-param name="key" select="'etag'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'etag'])][*[@key = '_etag']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="etag"/>
                        <xsl:copy-of select="fn:map[@key = '_etag']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'etag'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--lastModified 0..1 instant-->     <xsl:apply-templates select="*[@key = 'lastModified']" mode="instant">
                  <xsl:with-param name="key" select="'lastModified'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'lastModified'])][*[@key = '_lastModified']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastModified"/>
                        <xsl:copy-of select="fn:map[@key = '_lastModified']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="instant">
                     <xsl:with-param name="key" select="'lastModified'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--outcome 0..1 ResourceContainer-->     <xsl:apply-templates select="*[@key = 'outcome']" mode="ResourceContainer">
                  <xsl:with-param name="key" select="'outcome'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>HTTP verbs (in the HTTP command line).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="HTTPVerb">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the purpose of a bundle - how it was intended to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="BundleType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Why an entry is in the result set - whether it's included as a match or because of an _include requirement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SearchEntryMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--url 0..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--version 0..1 string-->     <xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--title 0..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--status 1..1 PublicationStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="PublicationStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="PublicationStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--experimental 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'experimental']" mode="boolean">
                  <xsl:with-param name="key" select="'experimental'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'experimental'])][*[@key = '_experimental']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="experimental"/>
                        <xsl:copy-of select="fn:map[@key = '_experimental']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'experimental'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--date 1..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--publisher 0..1 string-->     <xsl:apply-templates select="*[@key = 'publisher']" mode="string">
                  <xsl:with-param name="key" select="'publisher'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'publisher'])][*[@key = '_publisher']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher"/>
                        <xsl:copy-of select="fn:map[@key = '_publisher']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'publisher'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--contact 0..* ContactDetail-->     <xsl:apply-templates select="*[@key = 'contact']" mode="ContactDetail">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
               <!--description 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'description']" mode="markdown">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--useContext 0..* UsageContext-->     <xsl:apply-templates select="*[@key = 'useContext']" mode="UsageContext">
                  <xsl:with-param name="key" select="'useContext'"/>
               </xsl:apply-templates>
               <!--jurisdiction 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'jurisdiction']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'jurisdiction'"/>
               </xsl:apply-templates>
               <!--purpose 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'purpose']" mode="markdown">
                  <xsl:with-param name="key" select="'purpose'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'purpose'])][*[@key = '_purpose']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose"/>
                        <xsl:copy-of select="fn:map[@key = '_purpose']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'purpose'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--copyright 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'copyright']" mode="markdown">
                  <xsl:with-param name="key" select="'copyright'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'copyright'])][*[@key = '_copyright']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright"/>
                        <xsl:copy-of select="fn:map[@key = '_copyright']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'copyright'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--kind 1..1 CapabilityStatementKind-->     <xsl:apply-templates select="*[@key = 'kind']" mode="CapabilityStatementKind">
                  <xsl:with-param name="key" select="'kind'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'kind'])][*[@key = '_kind']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="kind"/>
                        <xsl:copy-of select="fn:map[@key = '_kind']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CapabilityStatementKind">
                     <xsl:with-param name="key" select="'kind'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--instantiates 0..* uri-->     <xsl:apply-templates select="*[@key = 'instantiates']" mode="uri">
                  <xsl:with-param name="key" select="'instantiates'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'instantiates'])][*[@key = '_instantiates']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="instantiates"/>
                        <xsl:copy-of select="fn:map[@key = '_instantiates']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'instantiates'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--software 0..1 CapabilityStatement.Software-->     <xsl:apply-templates select="*[@key = 'software']" mode="CapabilityStatement.Software">
                  <xsl:with-param name="key" select="'software'"/>
               </xsl:apply-templates>
               <!--implementation 0..1 CapabilityStatement.Implementation-->     <xsl:apply-templates select="*[@key = 'implementation']"
                                    mode="CapabilityStatement.Implementation">
                  <xsl:with-param name="key" select="'implementation'"/>
               </xsl:apply-templates>
               <!--fhirVersion 1..1 id-->     <xsl:apply-templates select="*[@key = 'fhirVersion']" mode="id">
                  <xsl:with-param name="key" select="'fhirVersion'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'fhirVersion'])][*[@key = '_fhirVersion']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="fhirVersion"/>
                        <xsl:copy-of select="fn:map[@key = '_fhirVersion']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="id">
                     <xsl:with-param name="key" select="'fhirVersion'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--acceptUnknown 1..1 UnknownContentCode-->     <xsl:apply-templates select="*[@key = 'acceptUnknown']" mode="UnknownContentCode">
                  <xsl:with-param name="key" select="'acceptUnknown'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'acceptUnknown'])][*[@key = '_acceptUnknown']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="acceptUnknown"/>
                        <xsl:copy-of select="fn:map[@key = '_acceptUnknown']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="UnknownContentCode">
                     <xsl:with-param name="key" select="'acceptUnknown'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--format 1..* code-->     <xsl:apply-templates select="*[@key = 'format']" mode="code">
                  <xsl:with-param name="key" select="'format'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'format'])][*[@key = '_format']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="format"/>
                        <xsl:copy-of select="fn:map[@key = '_format']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'format'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patchFormat 0..* code-->     <xsl:apply-templates select="*[@key = 'patchFormat']" mode="code">
                  <xsl:with-param name="key" select="'patchFormat'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'patchFormat'])][*[@key = '_patchFormat']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="patchFormat"/>
                        <xsl:copy-of select="fn:map[@key = '_patchFormat']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'patchFormat'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--implementationGuide 0..* uri-->     <xsl:apply-templates select="*[@key = 'implementationGuide']" mode="uri">
                  <xsl:with-param name="key" select="'implementationGuide'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'implementationGuide'])][*[@key = '_implementationGuide']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="implementationGuide"/>
                        <xsl:copy-of select="fn:map[@key = '_implementationGuide']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'implementationGuide'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--profile 0..* Reference-->     <xsl:apply-templates select="*[@key = 'profile']" mode="Reference">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
               <!--rest 0..* CapabilityStatement.Rest-->     <xsl:apply-templates select="*[@key = 'rest']" mode="CapabilityStatement.Rest">
                  <xsl:with-param name="key" select="'rest'"/>
               </xsl:apply-templates>
               <!--messaging 0..* CapabilityStatement.Messaging-->     <xsl:apply-templates select="*[@key = 'messaging']" mode="CapabilityStatement.Messaging">
                  <xsl:with-param name="key" select="'messaging'"/>
               </xsl:apply-templates>
               <!--document 0..* CapabilityStatement.Document-->     <xsl:apply-templates select="*[@key = 'document']" mode="CapabilityStatement.Document">
                  <xsl:with-param name="key" select="'document'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Software">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--name 1..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--version 0..1 string-->     <xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--releaseDate 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'releaseDate']" mode="dateTime">
                  <xsl:with-param name="key" select="'releaseDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'releaseDate'])][*[@key = '_releaseDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="releaseDate"/>
                        <xsl:copy-of select="fn:map[@key = '_releaseDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'releaseDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Implementation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--description 1..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--url 0..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Rest">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--mode 1..1 RestfulCapabilityMode-->     <xsl:apply-templates select="*[@key = 'mode']" mode="RestfulCapabilityMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="RestfulCapabilityMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--security 0..1 CapabilityStatement.Security-->     <xsl:apply-templates select="*[@key = 'security']" mode="CapabilityStatement.Security">
                  <xsl:with-param name="key" select="'security'"/>
               </xsl:apply-templates>
               <!--resource 0..* CapabilityStatement.Resource-->     <xsl:apply-templates select="*[@key = 'resource']" mode="CapabilityStatement.Resource">
                  <xsl:with-param name="key" select="'resource'"/>
               </xsl:apply-templates>
               <!--interaction 0..* CapabilityStatement.Interaction1-->     <xsl:apply-templates select="*[@key = 'interaction']"
                                    mode="CapabilityStatement.Interaction1">
                  <xsl:with-param name="key" select="'interaction'"/>
               </xsl:apply-templates>
               <!--searchParam 0..* CapabilityStatement.SearchParam-->     <xsl:apply-templates select="*[@key = 'searchParam']" mode="CapabilityStatement.SearchParam">
                  <xsl:with-param name="key" select="'searchParam'"/>
               </xsl:apply-templates>
               <!--operation 0..* CapabilityStatement.Operation-->     <xsl:apply-templates select="*[@key = 'operation']" mode="CapabilityStatement.Operation">
                  <xsl:with-param name="key" select="'operation'"/>
               </xsl:apply-templates>
               <!--compartment 0..* uri-->     <xsl:apply-templates select="*[@key = 'compartment']" mode="uri">
                  <xsl:with-param name="key" select="'compartment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'compartment'])][*[@key = '_compartment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="compartment"/>
                        <xsl:copy-of select="fn:map[@key = '_compartment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'compartment'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Security">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--cors 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'cors']" mode="boolean">
                  <xsl:with-param name="key" select="'cors'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'cors'])][*[@key = '_cors']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="cors"/>
                        <xsl:copy-of select="fn:map[@key = '_cors']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'cors'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--service 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'service']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--certificate 0..* CapabilityStatement.Certificate-->     <xsl:apply-templates select="*[@key = 'certificate']" mode="CapabilityStatement.Certificate">
                  <xsl:with-param name="key" select="'certificate'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Certificate">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--type 0..1 code-->     <xsl:apply-templates select="*[@key = 'type']" mode="code">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--blob 0..1 base64Binary-->     <xsl:apply-templates select="*[@key = 'blob']" mode="base64Binary">
                  <xsl:with-param name="key" select="'blob'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'blob'])][*[@key = '_blob']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="blob"/>
                        <xsl:copy-of select="fn:map[@key = '_blob']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="base64Binary">
                     <xsl:with-param name="key" select="'blob'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Resource">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--type 1..1 ResourceType-->     <xsl:apply-templates select="*[@key = 'type']" mode="ResourceType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ResourceType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--profile 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'profile']" mode="Reference">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
               <!--documentation 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="markdown">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--interaction 1..* CapabilityStatement.Interaction-->     <xsl:apply-templates select="*[@key = 'interaction']" mode="CapabilityStatement.Interaction">
                  <xsl:with-param name="key" select="'interaction'"/>
               </xsl:apply-templates>
               <!--versioning 0..1 ResourceVersionPolicy-->     <xsl:apply-templates select="*[@key = 'versioning']" mode="ResourceVersionPolicy">
                  <xsl:with-param name="key" select="'versioning'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'versioning'])][*[@key = '_versioning']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="versioning"/>
                        <xsl:copy-of select="fn:map[@key = '_versioning']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ResourceVersionPolicy">
                     <xsl:with-param name="key" select="'versioning'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--readHistory 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'readHistory']" mode="boolean">
                  <xsl:with-param name="key" select="'readHistory'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'readHistory'])][*[@key = '_readHistory']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="readHistory"/>
                        <xsl:copy-of select="fn:map[@key = '_readHistory']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'readHistory'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--updateCreate 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'updateCreate']" mode="boolean">
                  <xsl:with-param name="key" select="'updateCreate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'updateCreate'])][*[@key = '_updateCreate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="updateCreate"/>
                        <xsl:copy-of select="fn:map[@key = '_updateCreate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'updateCreate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--conditionalCreate 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'conditionalCreate']" mode="boolean">
                  <xsl:with-param name="key" select="'conditionalCreate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'conditionalCreate'])][*[@key = '_conditionalCreate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalCreate"/>
                        <xsl:copy-of select="fn:map[@key = '_conditionalCreate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'conditionalCreate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--conditionalRead 0..1 ConditionalReadStatus-->     <xsl:apply-templates select="*[@key = 'conditionalRead']" mode="ConditionalReadStatus">
                  <xsl:with-param name="key" select="'conditionalRead'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'conditionalRead'])][*[@key = '_conditionalRead']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalRead"/>
                        <xsl:copy-of select="fn:map[@key = '_conditionalRead']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConditionalReadStatus">
                     <xsl:with-param name="key" select="'conditionalRead'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--conditionalUpdate 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'conditionalUpdate']" mode="boolean">
                  <xsl:with-param name="key" select="'conditionalUpdate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'conditionalUpdate'])][*[@key = '_conditionalUpdate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalUpdate"/>
                        <xsl:copy-of select="fn:map[@key = '_conditionalUpdate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'conditionalUpdate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--conditionalDelete 0..1 ConditionalDeleteStatus-->     <xsl:apply-templates select="*[@key = 'conditionalDelete']" mode="ConditionalDeleteStatus">
                  <xsl:with-param name="key" select="'conditionalDelete'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'conditionalDelete'])][*[@key = '_conditionalDelete']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalDelete"/>
                        <xsl:copy-of select="fn:map[@key = '_conditionalDelete']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConditionalDeleteStatus">
                     <xsl:with-param name="key" select="'conditionalDelete'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--referencePolicy 0..* ReferenceHandlingPolicy-->     <xsl:apply-templates select="*[@key = 'referencePolicy']" mode="ReferenceHandlingPolicy">
                  <xsl:with-param name="key" select="'referencePolicy'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'referencePolicy'])][*[@key = '_referencePolicy']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="referencePolicy"/>
                        <xsl:copy-of select="fn:map[@key = '_referencePolicy']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ReferenceHandlingPolicy">
                     <xsl:with-param name="key" select="'referencePolicy'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--searchInclude 0..* string-->     <xsl:apply-templates select="*[@key = 'searchInclude']" mode="string">
                  <xsl:with-param name="key" select="'searchInclude'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'searchInclude'])][*[@key = '_searchInclude']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="searchInclude"/>
                        <xsl:copy-of select="fn:map[@key = '_searchInclude']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'searchInclude'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--searchRevInclude 0..* string-->     <xsl:apply-templates select="*[@key = 'searchRevInclude']" mode="string">
                  <xsl:with-param name="key" select="'searchRevInclude'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'searchRevInclude'])][*[@key = '_searchRevInclude']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="searchRevInclude"/>
                        <xsl:copy-of select="fn:map[@key = '_searchRevInclude']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'searchRevInclude'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--searchParam 0..* CapabilityStatement.SearchParam-->     <xsl:apply-templates select="*[@key = 'searchParam']" mode="CapabilityStatement.SearchParam">
                  <xsl:with-param name="key" select="'searchParam'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Interaction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 TypeRestfulInteraction-->     <xsl:apply-templates select="*[@key = 'code']" mode="TypeRestfulInteraction">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="TypeRestfulInteraction">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.SearchParam">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--name 1..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--definition 0..1 uri-->     <xsl:apply-templates select="*[@key = 'definition']" mode="uri">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'definition'])][*[@key = '_definition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition"/>
                        <xsl:copy-of select="fn:map[@key = '_definition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'definition'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 1..1 SearchParamType-->     <xsl:apply-templates select="*[@key = 'type']" mode="SearchParamType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SearchParamType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Interaction1">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 SystemRestfulInteraction-->     <xsl:apply-templates select="*[@key = 'code']" mode="SystemRestfulInteraction">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="SystemRestfulInteraction">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Operation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--name 1..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--definition 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'definition']" mode="Reference">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Messaging">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--endpoint 0..* CapabilityStatement.Endpoint-->     <xsl:apply-templates select="*[@key = 'endpoint']" mode="CapabilityStatement.Endpoint">
                  <xsl:with-param name="key" select="'endpoint'"/>
               </xsl:apply-templates>
               <!--reliableCache 0..1 unsignedInt-->     <xsl:apply-templates select="*[@key = 'reliableCache']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'reliableCache'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'reliableCache'])][*[@key = '_reliableCache']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="reliableCache"/>
                        <xsl:copy-of select="fn:map[@key = '_reliableCache']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'reliableCache'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--supportedMessage 0..* CapabilityStatement.SupportedMessage-->     <xsl:apply-templates select="*[@key = 'supportedMessage']"
                                    mode="CapabilityStatement.SupportedMessage">
                  <xsl:with-param name="key" select="'supportedMessage'"/>
               </xsl:apply-templates>
               <!--event 0..* CapabilityStatement.Event-->     <xsl:apply-templates select="*[@key = 'event']" mode="CapabilityStatement.Event">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Endpoint">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--protocol 1..1 Coding-->     <xsl:apply-templates select="*[@key = 'protocol']" mode="Coding">
                  <xsl:with-param name="key" select="'protocol'"/>
               </xsl:apply-templates>
               <!--address 1..1 uri-->     <xsl:apply-templates select="*[@key = 'address']" mode="uri">
                  <xsl:with-param name="key" select="'address'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'address'])][*[@key = '_address']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="address"/>
                        <xsl:copy-of select="fn:map[@key = '_address']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'address'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.SupportedMessage">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--mode 1..1 EventCapabilityMode-->     <xsl:apply-templates select="*[@key = 'mode']" mode="EventCapabilityMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="EventCapabilityMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--definition 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'definition']" mode="Reference">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Event">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 Coding-->     <xsl:apply-templates select="*[@key = 'code']" mode="Coding">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--category 0..1 MessageSignificanceCategory-->     <xsl:apply-templates select="*[@key = 'category']" mode="MessageSignificanceCategory">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'category'])][*[@key = '_category']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="category"/>
                        <xsl:copy-of select="fn:map[@key = '_category']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="MessageSignificanceCategory">
                     <xsl:with-param name="key" select="'category'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--mode 1..1 EventCapabilityMode-->     <xsl:apply-templates select="*[@key = 'mode']" mode="EventCapabilityMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="EventCapabilityMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--focus 1..1 ResourceType-->     <xsl:apply-templates select="*[@key = 'focus']" mode="ResourceType">
                  <xsl:with-param name="key" select="'focus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'focus'])][*[@key = '_focus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="focus"/>
                        <xsl:copy-of select="fn:map[@key = '_focus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ResourceType">
                     <xsl:with-param name="key" select="'focus'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--request 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'request']" mode="Reference">
                  <xsl:with-param name="key" select="'request'"/>
               </xsl:apply-templates>
               <!--response 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'response']" mode="Reference">
                  <xsl:with-param name="key" select="'response'"/>
               </xsl:apply-templates>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Document">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--mode 1..1 DocumentMode-->     <xsl:apply-templates select="*[@key = 'mode']" mode="DocumentMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DocumentMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--profile 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'profile']" mode="Reference">
                  <xsl:with-param name="key" select="'profile'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a capability statement is intended to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatementKind">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The mode of a message capability statement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="EventCapabilityMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How the system supports versioning for a resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ResourceVersionPolicy">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The impact of the content of a message.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="MessageSignificanceCategory">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Whether the application produces or consumes documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The mode of a RESTful capability statement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="RestfulCapabilityMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates whether an application accepts unknown elements or extensions when reading resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="UnknownContentCode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Operations supported by REST at the type or instance level.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="TypeRestfulInteraction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Operations supported by REST at the system level.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="SystemRestfulInteraction">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates how the server supports conditional read.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConditionalReadStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of flags that defines how references are supported.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ReferenceHandlingPolicy">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates how the server supports conditional delete.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConditionalDeleteStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--definition 0..* Reference-->     <xsl:apply-templates select="*[@key = 'definition']" mode="Reference">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <!--basedOn 0..* Reference-->     <xsl:apply-templates select="*[@key = 'basedOn']" mode="Reference">
                  <xsl:with-param name="key" select="'basedOn'"/>
               </xsl:apply-templates>
               <!--replaces 0..* Reference-->     <xsl:apply-templates select="*[@key = 'replaces']" mode="Reference">
                  <xsl:with-param name="key" select="'replaces'"/>
               </xsl:apply-templates>
               <!--partOf 0..* Reference-->     <xsl:apply-templates select="*[@key = 'partOf']" mode="Reference">
                  <xsl:with-param name="key" select="'partOf'"/>
               </xsl:apply-templates>
               <!--status 1..1 CarePlanStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="CarePlanStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CarePlanStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--intent 1..1 CarePlanIntent-->     <xsl:apply-templates select="*[@key = 'intent']" mode="CarePlanIntent">
                  <xsl:with-param name="key" select="'intent'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'intent'])][*[@key = '_intent']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="intent"/>
                        <xsl:copy-of select="fn:map[@key = '_intent']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CarePlanIntent">
                     <xsl:with-param name="key" select="'intent'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--category 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--title 0..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--subject 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--context 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'context']" mode="Reference">
                  <xsl:with-param name="key" select="'context'"/>
               </xsl:apply-templates>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <!--author 0..* Reference-->     <xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
               <!--careTeam 0..* Reference-->     <xsl:apply-templates select="*[@key = 'careTeam']" mode="Reference">
                  <xsl:with-param name="key" select="'careTeam'"/>
               </xsl:apply-templates>
               <!--addresses 0..* Reference-->     <xsl:apply-templates select="*[@key = 'addresses']" mode="Reference">
                  <xsl:with-param name="key" select="'addresses'"/>
               </xsl:apply-templates>
               <!--supportingInfo 0..* Reference-->     <xsl:apply-templates select="*[@key = 'supportingInfo']" mode="Reference">
                  <xsl:with-param name="key" select="'supportingInfo'"/>
               </xsl:apply-templates>
               <!--goal 0..* Reference-->     <xsl:apply-templates select="*[@key = 'goal']" mode="Reference">
                  <xsl:with-param name="key" select="'goal'"/>
               </xsl:apply-templates>
               <!--activity 0..* CarePlan.Activity-->     <xsl:apply-templates select="*[@key = 'activity']" mode="CarePlan.Activity">
                  <xsl:with-param name="key" select="'activity'"/>
               </xsl:apply-templates>
               <!--note 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Activity">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--outcomeCodeableConcept 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'outcomeCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'outcomeCodeableConcept'"/>
               </xsl:apply-templates>
               <!--outcomeReference 0..* Reference-->     <xsl:apply-templates select="*[@key = 'outcomeReference']" mode="Reference">
                  <xsl:with-param name="key" select="'outcomeReference'"/>
               </xsl:apply-templates>
               <!--progress 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'progress']" mode="Annotation">
                  <xsl:with-param name="key" select="'progress'"/>
               </xsl:apply-templates>
               <!--reference 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'reference']" mode="Reference">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
               <!--detail 0..1 CarePlan.Detail-->     <xsl:apply-templates select="*[@key = 'detail']" mode="CarePlan.Detail">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Detail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--category 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--definition 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'definition']" mode="Reference">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <!--code 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--reasonCode 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'reasonCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reasonCode'"/>
               </xsl:apply-templates>
               <!--reasonReference 0..* Reference-->     <xsl:apply-templates select="*[@key = 'reasonReference']" mode="Reference">
                  <xsl:with-param name="key" select="'reasonReference'"/>
               </xsl:apply-templates>
               <!--goal 0..* Reference-->     <xsl:apply-templates select="*[@key = 'goal']" mode="Reference">
                  <xsl:with-param name="key" select="'goal'"/>
               </xsl:apply-templates>
               <!--status 1..1 CarePlanActivityStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="CarePlanActivityStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CarePlanActivityStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--statusReason 0..1 string-->     <xsl:apply-templates select="*[@key = 'statusReason']" mode="string">
                  <xsl:with-param name="key" select="'statusReason'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'statusReason'])][*[@key = '_statusReason']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="statusReason"/>
                        <xsl:copy-of select="fn:map[@key = '_statusReason']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'statusReason'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--prohibited 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'prohibited']" mode="boolean">
                  <xsl:with-param name="key" select="'prohibited'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'prohibited'])][*[@key = '_prohibited']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="prohibited"/>
                        <xsl:copy-of select="fn:map[@key = '_prohibited']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'prohibited'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--scheduledTiming 1..1 Timing-->   <xsl:apply-templates select="*[@key = 'scheduledTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'scheduledTiming'"/>
               </xsl:apply-templates>
               <!--scheduledPeriod 1..1 Period-->   <xsl:apply-templates select="*[@key = 'scheduledPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'scheduledPeriod'"/>
               </xsl:apply-templates>
               <!--scheduledString 1..1 string-->   <xsl:apply-templates select="*[@key = 'scheduledString']" mode="string">
                  <xsl:with-param name="key" select="'scheduledString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'scheduledString'])][*[@key = '_scheduledString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledString"/>
                        <xsl:copy-of select="fn:map[@key = '_scheduledString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'scheduledString'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
               <!--location 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'location']" mode="Reference">
                  <xsl:with-param name="key" select="'location'"/>
               </xsl:apply-templates>
               <!--performer 0..* Reference-->     <xsl:apply-templates select="*[@key = 'performer']" mode="Reference">
                  <xsl:with-param name="key" select="'performer'"/>
               </xsl:apply-templates>
          
            
               <!--productCodeableConcept 1..1 CodeableConcept-->   <xsl:apply-templates select="*[@key = 'productCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'productCodeableConcept'"/>
               </xsl:apply-templates>
               <!--productReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'productReference']" mode="Reference">
                  <xsl:with-param name="key" select="'productReference'"/>
               </xsl:apply-templates>
          
               <!--dailyAmount 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'dailyAmount']" mode="Quantity">
                  <xsl:with-param name="key" select="'dailyAmount'"/>
               </xsl:apply-templates>
               <!--quantity 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'quantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates where the activity is at in its overall life cycle.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanActivityStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes indicating the degree of authority/intentionality associated with a care plan</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanIntent">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CareTeam">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--status 0..1 CareTeamStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="CareTeamStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CareTeamStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--category 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--subject 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--context 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'context']" mode="Reference">
                  <xsl:with-param name="key" select="'context'"/>
               </xsl:apply-templates>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <!--participant 0..* CareTeam.Participant-->     <xsl:apply-templates select="*[@key = 'participant']" mode="CareTeam.Participant">
                  <xsl:with-param name="key" select="'participant'"/>
               </xsl:apply-templates>
               <!--reasonCode 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'reasonCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reasonCode'"/>
               </xsl:apply-templates>
               <!--reasonReference 0..* Reference-->     <xsl:apply-templates select="*[@key = 'reasonReference']" mode="Reference">
                  <xsl:with-param name="key" select="'reasonReference'"/>
               </xsl:apply-templates>
               <!--managingOrganization 0..* Reference-->     <xsl:apply-templates select="*[@key = 'managingOrganization']" mode="Reference">
                  <xsl:with-param name="key" select="'managingOrganization'"/>
               </xsl:apply-templates>
               <!--note 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CareTeam.Participant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--role 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
               <!--member 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'member']" mode="Reference">
                  <xsl:with-param name="key" select="'member'"/>
               </xsl:apply-templates>
               <!--onBehalfOf 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'onBehalfOf']" mode="Reference">
                  <xsl:with-param name="key" select="'onBehalfOf'"/>
               </xsl:apply-templates>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the status of the care team.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CareTeamStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ChargeItem">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--definition 0..* uri-->     <xsl:apply-templates select="*[@key = 'definition']" mode="uri">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'definition'])][*[@key = '_definition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition"/>
                        <xsl:copy-of select="fn:map[@key = '_definition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'definition'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--status 1..1 ChargeItemStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="ChargeItemStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ChargeItemStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--partOf 0..* Reference-->     <xsl:apply-templates select="*[@key = 'partOf']" mode="Reference">
                  <xsl:with-param name="key" select="'partOf'"/>
               </xsl:apply-templates>
               <!--code 1..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--subject 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--context 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'context']" mode="Reference">
                  <xsl:with-param name="key" select="'context'"/>
               </xsl:apply-templates>
          
            
               <!--occurrenceDateTime 1..1 dateTime-->   <xsl:apply-templates select="*[@key = 'occurrenceDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'occurrenceDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'occurrenceDateTime'])][*[@key = '_occurrenceDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="occurrenceDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_occurrenceDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'occurrenceDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--occurrencePeriod 1..1 Period-->   <xsl:apply-templates select="*[@key = 'occurrencePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'occurrencePeriod'"/>
               </xsl:apply-templates>
               <!--occurrenceTiming 1..1 Timing-->   <xsl:apply-templates select="*[@key = 'occurrenceTiming']" mode="Timing">
                  <xsl:with-param name="key" select="'occurrenceTiming'"/>
               </xsl:apply-templates>
          
               <!--participant 0..* ChargeItem.Participant-->     <xsl:apply-templates select="*[@key = 'participant']" mode="ChargeItem.Participant">
                  <xsl:with-param name="key" select="'participant'"/>
               </xsl:apply-templates>
               <!--performingOrganization 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'performingOrganization']" mode="Reference">
                  <xsl:with-param name="key" select="'performingOrganization'"/>
               </xsl:apply-templates>
               <!--requestingOrganization 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'requestingOrganization']" mode="Reference">
                  <xsl:with-param name="key" select="'requestingOrganization'"/>
               </xsl:apply-templates>
               <!--quantity 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'quantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
               <!--bodysite 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'bodysite']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'bodysite'"/>
               </xsl:apply-templates>
               <!--factorOverride 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'factorOverride']" mode="decimal">
                  <xsl:with-param name="key" select="'factorOverride'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factorOverride'])][*[@key = '_factorOverride']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factorOverride"/>
                        <xsl:copy-of select="fn:map[@key = '_factorOverride']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factorOverride'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--priceOverride 0..1 Money-->     <xsl:apply-templates select="*[@key = 'priceOverride']" mode="Money">
                  <xsl:with-param name="key" select="'priceOverride'"/>
               </xsl:apply-templates>
               <!--overrideReason 0..1 string-->     <xsl:apply-templates select="*[@key = 'overrideReason']" mode="string">
                  <xsl:with-param name="key" select="'overrideReason'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'overrideReason'])][*[@key = '_overrideReason']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="overrideReason"/>
                        <xsl:copy-of select="fn:map[@key = '_overrideReason']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'overrideReason'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--enterer 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'enterer']" mode="Reference">
                  <xsl:with-param name="key" select="'enterer'"/>
               </xsl:apply-templates>
               <!--enteredDate 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'enteredDate']" mode="dateTime">
                  <xsl:with-param name="key" select="'enteredDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'enteredDate'])][*[@key = '_enteredDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="enteredDate"/>
                        <xsl:copy-of select="fn:map[@key = '_enteredDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'enteredDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--reason 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'reason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
               <!--service 0..* Reference-->     <xsl:apply-templates select="*[@key = 'service']" mode="Reference">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
               <!--account 0..* Reference-->     <xsl:apply-templates select="*[@key = 'account']" mode="Reference">
                  <xsl:with-param name="key" select="'account'"/>
               </xsl:apply-templates>
               <!--note 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
               <!--supportingInformation 0..* Reference-->     <xsl:apply-templates select="*[@key = 'supportingInformation']" mode="Reference">
                  <xsl:with-param name="key" select="'supportingInformation'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ChargeItem.Participant">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--role 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
               <!--actor 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'actor']" mode="Reference">
                  <xsl:with-param name="key" select="'actor'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes identifying the stage lifecycle stage of a ChargeItem</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ChargeItemStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--status 0..1 FinancialResourceStatusCodes-->     <xsl:apply-templates select="*[@key = 'status']" mode="FinancialResourceStatusCodes">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="FinancialResourceStatusCodes">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--subType 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'subType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'subType'"/>
               </xsl:apply-templates>
               <!--use 0..1 Use-->     <xsl:apply-templates select="*[@key = 'use']" mode="Use">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'use'])][*[@key = '_use']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="use"/>
                        <xsl:copy-of select="fn:map[@key = '_use']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="Use">
                     <xsl:with-param name="key" select="'use'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patient 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
               <!--billablePeriod 0..1 Period-->     <xsl:apply-templates select="*[@key = 'billablePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'billablePeriod'"/>
               </xsl:apply-templates>
               <!--created 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'created']" mode="dateTime">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--enterer 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'enterer']" mode="Reference">
                  <xsl:with-param name="key" select="'enterer'"/>
               </xsl:apply-templates>
               <!--insurer 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'insurer']" mode="Reference">
                  <xsl:with-param name="key" select="'insurer'"/>
               </xsl:apply-templates>
               <!--provider 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'provider']" mode="Reference">
                  <xsl:with-param name="key" select="'provider'"/>
               </xsl:apply-templates>
               <!--organization 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'organization']" mode="Reference">
                  <xsl:with-param name="key" select="'organization'"/>
               </xsl:apply-templates>
               <!--priority 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'priority']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
               <!--fundsReserve 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'fundsReserve']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'fundsReserve'"/>
               </xsl:apply-templates>
               <!--related 0..* Claim.Related-->     <xsl:apply-templates select="*[@key = 'related']" mode="Claim.Related">
                  <xsl:with-param name="key" select="'related'"/>
               </xsl:apply-templates>
               <!--prescription 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'prescription']" mode="Reference">
                  <xsl:with-param name="key" select="'prescription'"/>
               </xsl:apply-templates>
               <!--originalPrescription 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'originalPrescription']" mode="Reference">
                  <xsl:with-param name="key" select="'originalPrescription'"/>
               </xsl:apply-templates>
               <!--payee 0..1 Claim.Payee-->     <xsl:apply-templates select="*[@key = 'payee']" mode="Claim.Payee">
                  <xsl:with-param name="key" select="'payee'"/>
               </xsl:apply-templates>
               <!--referral 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'referral']" mode="Reference">
                  <xsl:with-param name="key" select="'referral'"/>
               </xsl:apply-templates>
               <!--facility 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'facility']" mode="Reference">
                  <xsl:with-param name="key" select="'facility'"/>
               </xsl:apply-templates>
               <!--careTeam 0..* Claim.CareTeam-->     <xsl:apply-templates select="*[@key = 'careTeam']" mode="Claim.CareTeam">
                  <xsl:with-param name="key" select="'careTeam'"/>
               </xsl:apply-templates>
               <!--information 0..* Claim.Information-->     <xsl:apply-templates select="*[@key = 'information']" mode="Claim.Information">
                  <xsl:with-param name="key" select="'information'"/>
               </xsl:apply-templates>
               <!--diagnosis 0..* Claim.Diagnosis-->     <xsl:apply-templates select="*[@key = 'diagnosis']" mode="Claim.Diagnosis">
                  <xsl:with-param name="key" select="'diagnosis'"/>
               </xsl:apply-templates>
               <!--procedure 0..* Claim.Procedure-->     <xsl:apply-templates select="*[@key = 'procedure']" mode="Claim.Procedure">
                  <xsl:with-param name="key" select="'procedure'"/>
               </xsl:apply-templates>
               <!--insurance 0..* Claim.Insurance-->     <xsl:apply-templates select="*[@key = 'insurance']" mode="Claim.Insurance">
                  <xsl:with-param name="key" select="'insurance'"/>
               </xsl:apply-templates>
               <!--accident 0..1 Claim.Accident-->     <xsl:apply-templates select="*[@key = 'accident']" mode="Claim.Accident">
                  <xsl:with-param name="key" select="'accident'"/>
               </xsl:apply-templates>
               <!--employmentImpacted 0..1 Period-->     <xsl:apply-templates select="*[@key = 'employmentImpacted']" mode="Period">
                  <xsl:with-param name="key" select="'employmentImpacted'"/>
               </xsl:apply-templates>
               <!--hospitalization 0..1 Period-->     <xsl:apply-templates select="*[@key = 'hospitalization']" mode="Period">
                  <xsl:with-param name="key" select="'hospitalization'"/>
               </xsl:apply-templates>
               <!--item 0..* Claim.Item-->     <xsl:apply-templates select="*[@key = 'item']" mode="Claim.Item">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
               <!--total 0..1 Money-->     <xsl:apply-templates select="*[@key = 'total']" mode="Money">
                  <xsl:with-param name="key" select="'total'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Related">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--claim 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'claim']" mode="Reference">
                  <xsl:with-param name="key" select="'claim'"/>
               </xsl:apply-templates>
               <!--relationship 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'relationship']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'relationship'"/>
               </xsl:apply-templates>
               <!--reference 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'reference']" mode="Identifier">
                  <xsl:with-param name="key" select="'reference'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Payee">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--type 1..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--resourceType 0..1 Coding-->     <xsl:apply-templates select="*[@key = 'resourceType']" mode="Coding">
                  <xsl:with-param name="key" select="'resourceType'"/>
               </xsl:apply-templates>
               <!--party 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'party']" mode="Reference">
                  <xsl:with-param name="key" select="'party'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.CareTeam">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--provider 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'provider']" mode="Reference">
                  <xsl:with-param name="key" select="'provider'"/>
               </xsl:apply-templates>
               <!--responsible 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'responsible']" mode="boolean">
                  <xsl:with-param name="key" select="'responsible'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'responsible'])][*[@key = '_responsible']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="responsible"/>
                        <xsl:copy-of select="fn:map[@key = '_responsible']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'responsible'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--role 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'role']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'role'"/>
               </xsl:apply-templates>
               <!--qualification 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'qualification']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'qualification'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Information">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--category 1..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--code 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
          
            
               <!--timingDate 1..1 date-->   <xsl:apply-templates select="*[@key = 'timingDate']" mode="date">
                  <xsl:with-param name="key" select="'timingDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'timingDate'])][*[@key = '_timingDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDate"/>
                        <xsl:copy-of select="fn:map[@key = '_timingDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'timingDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--timingPeriod 1..1 Period-->   <xsl:apply-templates select="*[@key = 'timingPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'timingPeriod'"/>
               </xsl:apply-templates>
          
          
            
               <!--valueString 1..1 string-->   <xsl:apply-templates select="*[@key = 'valueString']" mode="string">
                  <xsl:with-param name="key" select="'valueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueString'])][*[@key = '_valueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString"/>
                        <xsl:copy-of select="fn:map[@key = '_valueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'valueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueQuantity 1..1 Quantity-->   <xsl:apply-templates select="*[@key = 'valueQuantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'valueQuantity'"/>
               </xsl:apply-templates>
               <!--valueAttachment 1..1 Attachment-->   <xsl:apply-templates select="*[@key = 'valueAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'valueAttachment'"/>
               </xsl:apply-templates>
               <!--valueReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'valueReference']" mode="Reference">
                  <xsl:with-param name="key" select="'valueReference'"/>
               </xsl:apply-templates>
          
               <!--reason 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'reason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Diagnosis">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--diagnosisCodeableConcept 1..1 CodeableConcept-->   <xsl:apply-templates select="*[@key = 'diagnosisCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'diagnosisCodeableConcept'"/>
               </xsl:apply-templates>
               <!--diagnosisReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'diagnosisReference']" mode="Reference">
                  <xsl:with-param name="key" select="'diagnosisReference'"/>
               </xsl:apply-templates>
          
               <!--type 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--packageCode 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'packageCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'packageCode'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Procedure">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--date 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--procedureCodeableConcept 1..1 CodeableConcept-->   <xsl:apply-templates select="*[@key = 'procedureCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'procedureCodeableConcept'"/>
               </xsl:apply-templates>
               <!--procedureReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'procedureReference']" mode="Reference">
                  <xsl:with-param name="key" select="'procedureReference'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Insurance">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--focal 1..1 boolean-->     <xsl:apply-templates select="*[@key = 'focal']" mode="boolean">
                  <xsl:with-param name="key" select="'focal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'focal'])][*[@key = '_focal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="focal"/>
                        <xsl:copy-of select="fn:map[@key = '_focal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'focal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--coverage 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'coverage']" mode="Reference">
                  <xsl:with-param name="key" select="'coverage'"/>
               </xsl:apply-templates>
               <!--businessArrangement 0..1 string-->     <xsl:apply-templates select="*[@key = 'businessArrangement']" mode="string">
                  <xsl:with-param name="key" select="'businessArrangement'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'businessArrangement'])][*[@key = '_businessArrangement']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement"/>
                        <xsl:copy-of select="fn:map[@key = '_businessArrangement']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'businessArrangement'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--preAuthRef 0..* string-->     <xsl:apply-templates select="*[@key = 'preAuthRef']" mode="string">
                  <xsl:with-param name="key" select="'preAuthRef'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'preAuthRef'])][*[@key = '_preAuthRef']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="preAuthRef"/>
                        <xsl:copy-of select="fn:map[@key = '_preAuthRef']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'preAuthRef'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--claimResponse 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'claimResponse']" mode="Reference">
                  <xsl:with-param name="key" select="'claimResponse'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Accident">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--date 1..1 date-->     <xsl:apply-templates select="*[@key = 'date']" mode="date">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
          
            
               <!--locationAddress 1..1 Address-->   <xsl:apply-templates select="*[@key = 'locationAddress']" mode="Address">
                  <xsl:with-param name="key" select="'locationAddress'"/>
               </xsl:apply-templates>
               <!--locationReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'locationReference']" mode="Reference">
                  <xsl:with-param name="key" select="'locationReference'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Item">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--careTeamLinkId 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'careTeamLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'careTeamLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'careTeamLinkId'])][*[@key = '_careTeamLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="careTeamLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_careTeamLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'careTeamLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--diagnosisLinkId 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'diagnosisLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'diagnosisLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'diagnosisLinkId'])][*[@key = '_diagnosisLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosisLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_diagnosisLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'diagnosisLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--procedureLinkId 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'procedureLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'procedureLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'procedureLinkId'])][*[@key = '_procedureLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="procedureLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_procedureLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'procedureLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--informationLinkId 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'informationLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'informationLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'informationLinkId'])][*[@key = '_informationLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="informationLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_informationLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'informationLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--revenue 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'revenue']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'revenue'"/>
               </xsl:apply-templates>
               <!--category 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--service 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'service']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
               <!--modifier 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'modifier']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'modifier'"/>
               </xsl:apply-templates>
               <!--programCode 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'programCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'programCode'"/>
               </xsl:apply-templates>
          
            
               <!--servicedDate 1..1 date-->   <xsl:apply-templates select="*[@key = 'servicedDate']" mode="date">
                  <xsl:with-param name="key" select="'servicedDate'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'servicedDate'])][*[@key = '_servicedDate']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="servicedDate"/>
                        <xsl:copy-of select="fn:map[@key = '_servicedDate']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'servicedDate'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--servicedPeriod 1..1 Period-->   <xsl:apply-templates select="*[@key = 'servicedPeriod']" mode="Period">
                  <xsl:with-param name="key" select="'servicedPeriod'"/>
               </xsl:apply-templates>
          
          
            
               <!--locationCodeableConcept 1..1 CodeableConcept-->   <xsl:apply-templates select="*[@key = 'locationCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'locationCodeableConcept'"/>
               </xsl:apply-templates>
               <!--locationAddress 1..1 Address-->   <xsl:apply-templates select="*[@key = 'locationAddress']" mode="Address">
                  <xsl:with-param name="key" select="'locationAddress'"/>
               </xsl:apply-templates>
               <!--locationReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'locationReference']" mode="Reference">
                  <xsl:with-param name="key" select="'locationReference'"/>
               </xsl:apply-templates>
          
               <!--quantity 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'quantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
               <!--unitPrice 0..1 Money-->     <xsl:apply-templates select="*[@key = 'unitPrice']" mode="Money">
                  <xsl:with-param name="key" select="'unitPrice'"/>
               </xsl:apply-templates>
               <!--factor 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--net 0..1 Money-->     <xsl:apply-templates select="*[@key = 'net']" mode="Money">
                  <xsl:with-param name="key" select="'net'"/>
               </xsl:apply-templates>
               <!--udi 0..* Reference-->     <xsl:apply-templates select="*[@key = 'udi']" mode="Reference">
                  <xsl:with-param name="key" select="'udi'"/>
               </xsl:apply-templates>
               <!--bodySite 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'bodySite']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'bodySite'"/>
               </xsl:apply-templates>
               <!--subSite 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'subSite']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'subSite'"/>
               </xsl:apply-templates>
               <!--encounter 0..* Reference-->     <xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
               <!--detail 0..* Claim.Detail-->     <xsl:apply-templates select="*[@key = 'detail']" mode="Claim.Detail">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Detail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--revenue 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'revenue']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'revenue'"/>
               </xsl:apply-templates>
               <!--category 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--service 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'service']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
               <!--modifier 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'modifier']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'modifier'"/>
               </xsl:apply-templates>
               <!--programCode 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'programCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'programCode'"/>
               </xsl:apply-templates>
               <!--quantity 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'quantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
               <!--unitPrice 0..1 Money-->     <xsl:apply-templates select="*[@key = 'unitPrice']" mode="Money">
                  <xsl:with-param name="key" select="'unitPrice'"/>
               </xsl:apply-templates>
               <!--factor 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--net 0..1 Money-->     <xsl:apply-templates select="*[@key = 'net']" mode="Money">
                  <xsl:with-param name="key" select="'net'"/>
               </xsl:apply-templates>
               <!--udi 0..* Reference-->     <xsl:apply-templates select="*[@key = 'udi']" mode="Reference">
                  <xsl:with-param name="key" select="'udi'"/>
               </xsl:apply-templates>
               <!--subDetail 0..* Claim.SubDetail-->     <xsl:apply-templates select="*[@key = 'subDetail']" mode="Claim.SubDetail">
                  <xsl:with-param name="key" select="'subDetail'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Claim.SubDetail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--revenue 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'revenue']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'revenue'"/>
               </xsl:apply-templates>
               <!--category 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--service 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'service']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
               <!--modifier 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'modifier']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'modifier'"/>
               </xsl:apply-templates>
               <!--programCode 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'programCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'programCode'"/>
               </xsl:apply-templates>
               <!--quantity 0..1 Quantity-->     <xsl:apply-templates select="*[@key = 'quantity']" mode="Quantity">
                  <xsl:with-param name="key" select="'quantity'"/>
               </xsl:apply-templates>
               <!--unitPrice 0..1 Money-->     <xsl:apply-templates select="*[@key = 'unitPrice']" mode="Money">
                  <xsl:with-param name="key" select="'unitPrice'"/>
               </xsl:apply-templates>
               <!--factor 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'factor']" mode="decimal">
                  <xsl:with-param name="key" select="'factor'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'factor'])][*[@key = '_factor']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="factor"/>
                        <xsl:copy-of select="fn:map[@key = '_factor']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'factor'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--net 0..1 Money-->     <xsl:apply-templates select="*[@key = 'net']" mode="Money">
                  <xsl:with-param name="key" select="'net'"/>
               </xsl:apply-templates>
               <!--udi 0..* Reference-->     <xsl:apply-templates select="*[@key = 'udi']" mode="Reference">
                  <xsl:with-param name="key" select="'udi'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Complete, proposed, exploratory, other</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Use">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code specifying the state of the resource instance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="FinancialResourceStatusCodes">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--status 0..1 FinancialResourceStatusCodes-->     <xsl:apply-templates select="*[@key = 'status']" mode="FinancialResourceStatusCodes">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="FinancialResourceStatusCodes">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--patient 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'patient']" mode="Reference">
                  <xsl:with-param name="key" select="'patient'"/>
               </xsl:apply-templates>
               <!--created 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'created']" mode="dateTime">
                  <xsl:with-param name="key" select="'created'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'created'])][*[@key = '_created']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="created"/>
                        <xsl:copy-of select="fn:map[@key = '_created']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'created'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--insurer 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'insurer']" mode="Reference">
                  <xsl:with-param name="key" select="'insurer'"/>
               </xsl:apply-templates>
               <!--requestProvider 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'requestProvider']" mode="Reference">
                  <xsl:with-param name="key" select="'requestProvider'"/>
               </xsl:apply-templates>
               <!--requestOrganization 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'requestOrganization']" mode="Reference">
                  <xsl:with-param name="key" select="'requestOrganization'"/>
               </xsl:apply-templates>
               <!--request 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'request']" mode="Reference">
                  <xsl:with-param name="key" select="'request'"/>
               </xsl:apply-templates>
               <!--outcome 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'outcome']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'outcome'"/>
               </xsl:apply-templates>
               <!--disposition 0..1 string-->     <xsl:apply-templates select="*[@key = 'disposition']" mode="string">
                  <xsl:with-param name="key" select="'disposition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'disposition'])][*[@key = '_disposition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition"/>
                        <xsl:copy-of select="fn:map[@key = '_disposition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'disposition'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--payeeType 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'payeeType']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'payeeType'"/>
               </xsl:apply-templates>
               <!--item 0..* ClaimResponse.Item-->     <xsl:apply-templates select="*[@key = 'item']" mode="ClaimResponse.Item">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
               <!--addItem 0..* ClaimResponse.AddItem-->     <xsl:apply-templates select="*[@key = 'addItem']" mode="ClaimResponse.AddItem">
                  <xsl:with-param name="key" select="'addItem'"/>
               </xsl:apply-templates>
               <!--error 0..* ClaimResponse.Error-->     <xsl:apply-templates select="*[@key = 'error']" mode="ClaimResponse.Error">
                  <xsl:with-param name="key" select="'error'"/>
               </xsl:apply-templates>
               <!--totalCost 0..1 Money-->     <xsl:apply-templates select="*[@key = 'totalCost']" mode="Money">
                  <xsl:with-param name="key" select="'totalCost'"/>
               </xsl:apply-templates>
               <!--unallocDeductable 0..1 Money-->     <xsl:apply-templates select="*[@key = 'unallocDeductable']" mode="Money">
                  <xsl:with-param name="key" select="'unallocDeductable'"/>
               </xsl:apply-templates>
               <!--totalBenefit 0..1 Money-->     <xsl:apply-templates select="*[@key = 'totalBenefit']" mode="Money">
                  <xsl:with-param name="key" select="'totalBenefit'"/>
               </xsl:apply-templates>
               <!--payment 0..1 ClaimResponse.Payment-->     <xsl:apply-templates select="*[@key = 'payment']" mode="ClaimResponse.Payment">
                  <xsl:with-param name="key" select="'payment'"/>
               </xsl:apply-templates>
               <!--reserved 0..1 Coding-->     <xsl:apply-templates select="*[@key = 'reserved']" mode="Coding">
                  <xsl:with-param name="key" select="'reserved'"/>
               </xsl:apply-templates>
               <!--form 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'form']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'form'"/>
               </xsl:apply-templates>
               <!--processNote 0..* ClaimResponse.ProcessNote-->     <xsl:apply-templates select="*[@key = 'processNote']" mode="ClaimResponse.ProcessNote">
                  <xsl:with-param name="key" select="'processNote'"/>
               </xsl:apply-templates>
               <!--communicationRequest 0..* Reference-->     <xsl:apply-templates select="*[@key = 'communicationRequest']" mode="Reference">
                  <xsl:with-param name="key" select="'communicationRequest'"/>
               </xsl:apply-templates>
               <!--insurance 0..* ClaimResponse.Insurance-->     <xsl:apply-templates select="*[@key = 'insurance']" mode="ClaimResponse.Insurance">
                  <xsl:with-param name="key" select="'insurance'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Item">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequenceLinkId 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--noteNumber 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'noteNumber']" mode="positiveInt">
                  <xsl:with-param name="key" select="'noteNumber'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'noteNumber'])][*[@key = '_noteNumber']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber"/>
                        <xsl:copy-of select="fn:map[@key = '_noteNumber']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'noteNumber'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--adjudication 0..* ClaimResponse.Adjudication-->     <xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
               <!--detail 0..* ClaimResponse.Detail-->     <xsl:apply-templates select="*[@key = 'detail']" mode="ClaimResponse.Detail">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--category 1..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--reason 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'reason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reason'"/>
               </xsl:apply-templates>
               <!--amount 0..1 Money-->     <xsl:apply-templates select="*[@key = 'amount']" mode="Money">
                  <xsl:with-param name="key" select="'amount'"/>
               </xsl:apply-templates>
               <!--value 0..1 decimal-->     <xsl:apply-templates select="*[@key = 'value']" mode="decimal">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="decimal">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Detail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequenceLinkId 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--noteNumber 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'noteNumber']" mode="positiveInt">
                  <xsl:with-param name="key" select="'noteNumber'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'noteNumber'])][*[@key = '_noteNumber']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber"/>
                        <xsl:copy-of select="fn:map[@key = '_noteNumber']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'noteNumber'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--adjudication 0..* ClaimResponse.Adjudication-->     <xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
               <!--subDetail 0..* ClaimResponse.SubDetail-->     <xsl:apply-templates select="*[@key = 'subDetail']" mode="ClaimResponse.SubDetail">
                  <xsl:with-param name="key" select="'subDetail'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.SubDetail">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequenceLinkId 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--noteNumber 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'noteNumber']" mode="positiveInt">
                  <xsl:with-param name="key" select="'noteNumber'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'noteNumber'])][*[@key = '_noteNumber']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber"/>
                        <xsl:copy-of select="fn:map[@key = '_noteNumber']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'noteNumber'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--adjudication 0..* ClaimResponse.Adjudication-->     <xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.AddItem">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequenceLinkId 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--revenue 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'revenue']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'revenue'"/>
               </xsl:apply-templates>
               <!--category 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--service 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'service']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
               <!--modifier 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'modifier']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'modifier'"/>
               </xsl:apply-templates>
               <!--fee 0..1 Money-->     <xsl:apply-templates select="*[@key = 'fee']" mode="Money">
                  <xsl:with-param name="key" select="'fee'"/>
               </xsl:apply-templates>
               <!--noteNumber 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'noteNumber']" mode="positiveInt">
                  <xsl:with-param name="key" select="'noteNumber'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'noteNumber'])][*[@key = '_noteNumber']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber"/>
                        <xsl:copy-of select="fn:map[@key = '_noteNumber']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'noteNumber'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--adjudication 0..* ClaimResponse.Adjudication-->     <xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
               <!--detail 0..* ClaimResponse.Detail1-->     <xsl:apply-templates select="*[@key = 'detail']" mode="ClaimResponse.Detail1">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Detail1">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--revenue 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'revenue']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'revenue'"/>
               </xsl:apply-templates>
               <!--category 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--service 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'service']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'service'"/>
               </xsl:apply-templates>
               <!--modifier 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'modifier']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'modifier'"/>
               </xsl:apply-templates>
               <!--fee 0..1 Money-->     <xsl:apply-templates select="*[@key = 'fee']" mode="Money">
                  <xsl:with-param name="key" select="'fee'"/>
               </xsl:apply-templates>
               <!--noteNumber 0..* positiveInt-->     <xsl:apply-templates select="*[@key = 'noteNumber']" mode="positiveInt">
                  <xsl:with-param name="key" select="'noteNumber'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'noteNumber'])][*[@key = '_noteNumber']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber"/>
                        <xsl:copy-of select="fn:map[@key = '_noteNumber']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'noteNumber'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--adjudication 0..* ClaimResponse.Adjudication-->     <xsl:apply-templates select="*[@key = 'adjudication']" mode="ClaimResponse.Adjudication">
                  <xsl:with-param name="key" select="'adjudication'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Error">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequenceLinkId 0..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequenceLinkId'])][*[@key = '_sequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_sequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--detailSequenceLinkId 0..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'detailSequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'detailSequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'detailSequenceLinkId'])][*[@key = '_detailSequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="detailSequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_detailSequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'detailSequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--subdetailSequenceLinkId 0..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'subdetailSequenceLinkId']" mode="positiveInt">
                  <xsl:with-param name="key" select="'subdetailSequenceLinkId'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'subdetailSequenceLinkId'])][*[@key = '_subdetailSequenceLinkId']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions"
                                key="subdetailSequenceLinkId"/>
                        <xsl:copy-of select="fn:map[@key = '_subdetailSequenceLinkId']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'subdetailSequenceLinkId'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 1..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Payment">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--type 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--adjustment 0..1 Money-->     <xsl:apply-templates select="*[@key = 'adjustment']" mode="Money">
                  <xsl:with-param name="key" select="'adjustment'"/>
               </xsl:apply-templates>
               <!--adjustmentReason 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'adjustmentReason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'adjustmentReason'"/>
               </xsl:apply-templates>
               <!--date 0..1 date-->     <xsl:apply-templates select="*[@key = 'date']" mode="date">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="date">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--amount 0..1 Money-->     <xsl:apply-templates select="*[@key = 'amount']" mode="Money">
                  <xsl:with-param name="key" select="'amount'"/>
               </xsl:apply-templates>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.ProcessNote">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--number 0..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'number']" mode="positiveInt">
                  <xsl:with-param name="key" select="'number'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'number'])][*[@key = '_number']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="number"/>
                        <xsl:copy-of select="fn:map[@key = '_number']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'number'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--text 0..1 string-->     <xsl:apply-templates select="*[@key = 'text']" mode="string">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'text'])][*[@key = '_text']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="text"/>
                        <xsl:copy-of select="fn:map[@key = '_text']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'text'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--language 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'language']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Insurance">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--sequence 1..1 positiveInt-->     <xsl:apply-templates select="*[@key = 'sequence']" mode="positiveInt">
                  <xsl:with-param name="key" select="'sequence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sequence'])][*[@key = '_sequence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence"/>
                        <xsl:copy-of select="fn:map[@key = '_sequence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="positiveInt">
                     <xsl:with-param name="key" select="'sequence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--focal 1..1 boolean-->     <xsl:apply-templates select="*[@key = 'focal']" mode="boolean">
                  <xsl:with-param name="key" select="'focal'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'focal'])][*[@key = '_focal']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="focal"/>
                        <xsl:copy-of select="fn:map[@key = '_focal']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'focal'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--coverage 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'coverage']" mode="Reference">
                  <xsl:with-param name="key" select="'coverage'"/>
               </xsl:apply-templates>
               <!--businessArrangement 0..1 string-->     <xsl:apply-templates select="*[@key = 'businessArrangement']" mode="string">
                  <xsl:with-param name="key" select="'businessArrangement'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'businessArrangement'])][*[@key = '_businessArrangement']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement"/>
                        <xsl:copy-of select="fn:map[@key = '_businessArrangement']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'businessArrangement'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--preAuthRef 0..* string-->     <xsl:apply-templates select="*[@key = 'preAuthRef']" mode="string">
                  <xsl:with-param name="key" select="'preAuthRef'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'preAuthRef'])][*[@key = '_preAuthRef']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="preAuthRef"/>
                        <xsl:copy-of select="fn:map[@key = '_preAuthRef']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'preAuthRef'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--claimResponse 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'claimResponse']" mode="Reference">
                  <xsl:with-param name="key" select="'claimResponse'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--status 1..1 ClinicalImpressionStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="ClinicalImpressionStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ClinicalImpressionStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--subject 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--context 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'context']" mode="Reference">
                  <xsl:with-param name="key" select="'context'"/>
               </xsl:apply-templates>
          
            
               <!--effectiveDateTime 1..1 dateTime-->   <xsl:apply-templates select="*[@key = 'effectiveDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'effectiveDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'effectiveDateTime'])][*[@key = '_effectiveDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_effectiveDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'effectiveDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--effectivePeriod 1..1 Period-->   <xsl:apply-templates select="*[@key = 'effectivePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'effectivePeriod'"/>
               </xsl:apply-templates>
          
               <!--date 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--assessor 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'assessor']" mode="Reference">
                  <xsl:with-param name="key" select="'assessor'"/>
               </xsl:apply-templates>
               <!--previous 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'previous']" mode="Reference">
                  <xsl:with-param name="key" select="'previous'"/>
               </xsl:apply-templates>
               <!--problem 0..* Reference-->     <xsl:apply-templates select="*[@key = 'problem']" mode="Reference">
                  <xsl:with-param name="key" select="'problem'"/>
               </xsl:apply-templates>
               <!--investigation 0..* ClinicalImpression.Investigation-->     <xsl:apply-templates select="*[@key = 'investigation']"
                                    mode="ClinicalImpression.Investigation">
                  <xsl:with-param name="key" select="'investigation'"/>
               </xsl:apply-templates>
               <!--protocol 0..* uri-->     <xsl:apply-templates select="*[@key = 'protocol']" mode="uri">
                  <xsl:with-param name="key" select="'protocol'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'protocol'])][*[@key = '_protocol']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="protocol"/>
                        <xsl:copy-of select="fn:map[@key = '_protocol']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'protocol'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--summary 0..1 string-->     <xsl:apply-templates select="*[@key = 'summary']" mode="string">
                  <xsl:with-param name="key" select="'summary'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'summary'])][*[@key = '_summary']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="summary"/>
                        <xsl:copy-of select="fn:map[@key = '_summary']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'summary'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--finding 0..* ClinicalImpression.Finding-->     <xsl:apply-templates select="*[@key = 'finding']" mode="ClinicalImpression.Finding">
                  <xsl:with-param name="key" select="'finding'"/>
               </xsl:apply-templates>
               <!--prognosisCodeableConcept 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'prognosisCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'prognosisCodeableConcept'"/>
               </xsl:apply-templates>
               <!--prognosisReference 0..* Reference-->     <xsl:apply-templates select="*[@key = 'prognosisReference']" mode="Reference">
                  <xsl:with-param name="key" select="'prognosisReference'"/>
               </xsl:apply-templates>
               <!--action 0..* Reference-->     <xsl:apply-templates select="*[@key = 'action']" mode="Reference">
                  <xsl:with-param name="key" select="'action'"/>
               </xsl:apply-templates>
               <!--note 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.Investigation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--item 0..* Reference-->     <xsl:apply-templates select="*[@key = 'item']" mode="Reference">
                  <xsl:with-param name="key" select="'item'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.Finding">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
               <!--itemCodeableConcept 1..1 CodeableConcept-->   <xsl:apply-templates select="*[@key = 'itemCodeableConcept']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'itemCodeableConcept'"/>
               </xsl:apply-templates>
               <!--itemReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'itemReference']" mode="Reference">
                  <xsl:with-param name="key" select="'itemReference'"/>
               </xsl:apply-templates>
          
               <!--basis 0..1 string-->     <xsl:apply-templates select="*[@key = 'basis']" mode="string">
                  <xsl:with-param name="key" select="'basis'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'basis'])][*[@key = '_basis']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="basis"/>
                        <xsl:copy-of select="fn:map[@key = '_basis']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'basis'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The workflow state of a clinical impression.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpressionStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--url 0..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--version 0..1 string-->     <xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--title 0..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--status 1..1 PublicationStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="PublicationStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="PublicationStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--experimental 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'experimental']" mode="boolean">
                  <xsl:with-param name="key" select="'experimental'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'experimental'])][*[@key = '_experimental']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="experimental"/>
                        <xsl:copy-of select="fn:map[@key = '_experimental']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'experimental'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--date 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--publisher 0..1 string-->     <xsl:apply-templates select="*[@key = 'publisher']" mode="string">
                  <xsl:with-param name="key" select="'publisher'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'publisher'])][*[@key = '_publisher']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher"/>
                        <xsl:copy-of select="fn:map[@key = '_publisher']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'publisher'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--contact 0..* ContactDetail-->     <xsl:apply-templates select="*[@key = 'contact']" mode="ContactDetail">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
               <!--description 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'description']" mode="markdown">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--useContext 0..* UsageContext-->     <xsl:apply-templates select="*[@key = 'useContext']" mode="UsageContext">
                  <xsl:with-param name="key" select="'useContext'"/>
               </xsl:apply-templates>
               <!--jurisdiction 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'jurisdiction']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'jurisdiction'"/>
               </xsl:apply-templates>
               <!--purpose 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'purpose']" mode="markdown">
                  <xsl:with-param name="key" select="'purpose'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'purpose'])][*[@key = '_purpose']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose"/>
                        <xsl:copy-of select="fn:map[@key = '_purpose']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'purpose'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--copyright 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'copyright']" mode="markdown">
                  <xsl:with-param name="key" select="'copyright'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'copyright'])][*[@key = '_copyright']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright"/>
                        <xsl:copy-of select="fn:map[@key = '_copyright']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'copyright'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--caseSensitive 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'caseSensitive']" mode="boolean">
                  <xsl:with-param name="key" select="'caseSensitive'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'caseSensitive'])][*[@key = '_caseSensitive']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="caseSensitive"/>
                        <xsl:copy-of select="fn:map[@key = '_caseSensitive']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'caseSensitive'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueSet 0..1 uri-->     <xsl:apply-templates select="*[@key = 'valueSet']" mode="uri">
                  <xsl:with-param name="key" select="'valueSet'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueSet'])][*[@key = '_valueSet']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueSet"/>
                        <xsl:copy-of select="fn:map[@key = '_valueSet']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'valueSet'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--hierarchyMeaning 0..1 CodeSystemHierarchyMeaning-->     <xsl:apply-templates select="*[@key = 'hierarchyMeaning']" mode="CodeSystemHierarchyMeaning">
                  <xsl:with-param name="key" select="'hierarchyMeaning'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'hierarchyMeaning'])][*[@key = '_hierarchyMeaning']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="hierarchyMeaning"/>
                        <xsl:copy-of select="fn:map[@key = '_hierarchyMeaning']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CodeSystemHierarchyMeaning">
                     <xsl:with-param name="key" select="'hierarchyMeaning'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--compositional 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'compositional']" mode="boolean">
                  <xsl:with-param name="key" select="'compositional'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'compositional'])][*[@key = '_compositional']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="compositional"/>
                        <xsl:copy-of select="fn:map[@key = '_compositional']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'compositional'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--versionNeeded 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'versionNeeded']" mode="boolean">
                  <xsl:with-param name="key" select="'versionNeeded'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'versionNeeded'])][*[@key = '_versionNeeded']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="versionNeeded"/>
                        <xsl:copy-of select="fn:map[@key = '_versionNeeded']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'versionNeeded'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--content 1..1 CodeSystemContentMode-->     <xsl:apply-templates select="*[@key = 'content']" mode="CodeSystemContentMode">
                  <xsl:with-param name="key" select="'content'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'content'])][*[@key = '_content']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="content"/>
                        <xsl:copy-of select="fn:map[@key = '_content']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CodeSystemContentMode">
                     <xsl:with-param name="key" select="'content'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--count 0..1 unsignedInt-->     <xsl:apply-templates select="*[@key = 'count']" mode="unsignedInt">
                  <xsl:with-param name="key" select="'count'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'count'])][*[@key = '_count']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="count"/>
                        <xsl:copy-of select="fn:map[@key = '_count']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="unsignedInt">
                     <xsl:with-param name="key" select="'count'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--filter 0..* CodeSystem.Filter-->     <xsl:apply-templates select="*[@key = 'filter']" mode="CodeSystem.Filter">
                  <xsl:with-param name="key" select="'filter'"/>
               </xsl:apply-templates>
               <!--property 0..* CodeSystem.Property-->     <xsl:apply-templates select="*[@key = 'property']" mode="CodeSystem.Property">
                  <xsl:with-param name="key" select="'property'"/>
               </xsl:apply-templates>
               <!--concept 0..* CodeSystem.Concept-->     <xsl:apply-templates select="*[@key = 'concept']" mode="CodeSystem.Concept">
                  <xsl:with-param name="key" select="'concept'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Filter">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--operator 1..* FilterOperator-->     <xsl:apply-templates select="*[@key = 'operator']" mode="FilterOperator">
                  <xsl:with-param name="key" select="'operator'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'operator'])][*[@key = '_operator']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="operator"/>
                        <xsl:copy-of select="fn:map[@key = '_operator']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="FilterOperator">
                     <xsl:with-param name="key" select="'operator'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--value 1..1 string-->     <xsl:apply-templates select="*[@key = 'value']" mode="string">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Property">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--uri 0..1 uri-->     <xsl:apply-templates select="*[@key = 'uri']" mode="uri">
                  <xsl:with-param name="key" select="'uri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'uri'])][*[@key = '_uri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="uri"/>
                        <xsl:copy-of select="fn:map[@key = '_uri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'uri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--description 0..1 string-->     <xsl:apply-templates select="*[@key = 'description']" mode="string">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 1..1 PropertyType-->     <xsl:apply-templates select="*[@key = 'type']" mode="PropertyType">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'type'])][*[@key = '_type']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="type"/>
                        <xsl:copy-of select="fn:map[@key = '_type']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="PropertyType">
                     <xsl:with-param name="key" select="'type'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Concept">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--display 0..1 string-->     <xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--definition 0..1 string-->     <xsl:apply-templates select="*[@key = 'definition']" mode="string">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'definition'])][*[@key = '_definition']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition"/>
                        <xsl:copy-of select="fn:map[@key = '_definition']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'definition'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--designation 0..* CodeSystem.Designation-->     <xsl:apply-templates select="*[@key = 'designation']" mode="CodeSystem.Designation">
                  <xsl:with-param name="key" select="'designation'"/>
               </xsl:apply-templates>
               <!--property 0..* CodeSystem.Property1-->     <xsl:apply-templates select="*[@key = 'property']" mode="CodeSystem.Property1">
                  <xsl:with-param name="key" select="'property'"/>
               </xsl:apply-templates>
               <!--concept 0..* CodeSystem.Concept-->     <xsl:apply-templates select="*[@key = 'concept']" mode="CodeSystem.Concept">
                  <xsl:with-param name="key" select="'concept'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Designation">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--language 0..1 code-->     <xsl:apply-templates select="*[@key = 'language']" mode="code">
                  <xsl:with-param name="key" select="'language'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'language'])][*[@key = '_language']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="language"/>
                        <xsl:copy-of select="fn:map[@key = '_language']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'language'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--use 0..1 Coding-->     <xsl:apply-templates select="*[@key = 'use']" mode="Coding">
                  <xsl:with-param name="key" select="'use'"/>
               </xsl:apply-templates>
               <!--value 1..1 string-->     <xsl:apply-templates select="*[@key = 'value']" mode="string">
                  <xsl:with-param name="key" select="'value'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'value'])][*[@key = '_value']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="value"/>
                        <xsl:copy-of select="fn:map[@key = '_value']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'value'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Property1">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--valueCode 1..1 code-->   <xsl:apply-templates select="*[@key = 'valueCode']" mode="code">
                  <xsl:with-param name="key" select="'valueCode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueCode'])][*[@key = '_valueCode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode"/>
                        <xsl:copy-of select="fn:map[@key = '_valueCode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'valueCode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueCoding 1..1 Coding-->   <xsl:apply-templates select="*[@key = 'valueCoding']" mode="Coding">
                  <xsl:with-param name="key" select="'valueCoding'"/>
               </xsl:apply-templates>
               <!--valueString 1..1 string-->   <xsl:apply-templates select="*[@key = 'valueString']" mode="string">
                  <xsl:with-param name="key" select="'valueString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueString'])][*[@key = '_valueString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString"/>
                        <xsl:copy-of select="fn:map[@key = '_valueString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'valueString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueInteger 1..1 integer-->   <xsl:apply-templates select="*[@key = 'valueInteger']" mode="integer">
                  <xsl:with-param name="key" select="'valueInteger'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueInteger'])][*[@key = '_valueInteger']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInteger"/>
                        <xsl:copy-of select="fn:map[@key = '_valueInteger']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="integer">
                     <xsl:with-param name="key" select="'valueInteger'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueBoolean 1..1 boolean-->   <xsl:apply-templates select="*[@key = 'valueBoolean']" mode="boolean">
                  <xsl:with-param name="key" select="'valueBoolean'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueBoolean'])][*[@key = '_valueBoolean']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean"/>
                        <xsl:copy-of select="fn:map[@key = '_valueBoolean']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'valueBoolean'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--valueDateTime 1..1 dateTime-->   <xsl:apply-templates select="*[@key = 'valueDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'valueDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'valueDateTime'])][*[@key = '_valueDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_valueDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'valueDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The kind of operation to perform as a part of a property based filter.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="FilterOperator">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of a property value</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="PropertyType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The meaning of the hierarchy of concepts in a code system</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystemHierarchyMeaning">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How much of the content of the code system - the concepts and codes it defines - are represented in a code system resource</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystemContentMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Communication">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--definition 0..* Reference-->     <xsl:apply-templates select="*[@key = 'definition']" mode="Reference">
                  <xsl:with-param name="key" select="'definition'"/>
               </xsl:apply-templates>
               <!--basedOn 0..* Reference-->     <xsl:apply-templates select="*[@key = 'basedOn']" mode="Reference">
                  <xsl:with-param name="key" select="'basedOn'"/>
               </xsl:apply-templates>
               <!--partOf 0..* Reference-->     <xsl:apply-templates select="*[@key = 'partOf']" mode="Reference">
                  <xsl:with-param name="key" select="'partOf'"/>
               </xsl:apply-templates>
               <!--status 1..1 EventStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="EventStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="EventStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--notDone 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'notDone']" mode="boolean">
                  <xsl:with-param name="key" select="'notDone'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'notDone'])][*[@key = '_notDone']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="notDone"/>
                        <xsl:copy-of select="fn:map[@key = '_notDone']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'notDone'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--notDoneReason 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'notDoneReason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'notDoneReason'"/>
               </xsl:apply-templates>
               <!--category 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--medium 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'medium']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'medium'"/>
               </xsl:apply-templates>
               <!--subject 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--recipient 0..* Reference-->     <xsl:apply-templates select="*[@key = 'recipient']" mode="Reference">
                  <xsl:with-param name="key" select="'recipient'"/>
               </xsl:apply-templates>
               <!--topic 0..* Reference-->     <xsl:apply-templates select="*[@key = 'topic']" mode="Reference">
                  <xsl:with-param name="key" select="'topic'"/>
               </xsl:apply-templates>
               <!--context 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'context']" mode="Reference">
                  <xsl:with-param name="key" select="'context'"/>
               </xsl:apply-templates>
               <!--sent 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'sent']" mode="dateTime">
                  <xsl:with-param name="key" select="'sent'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sent'])][*[@key = '_sent']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sent"/>
                        <xsl:copy-of select="fn:map[@key = '_sent']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'sent'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--received 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'received']" mode="dateTime">
                  <xsl:with-param name="key" select="'received'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'received'])][*[@key = '_received']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="received"/>
                        <xsl:copy-of select="fn:map[@key = '_received']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'received'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--sender 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'sender']" mode="Reference">
                  <xsl:with-param name="key" select="'sender'"/>
               </xsl:apply-templates>
               <!--reasonCode 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'reasonCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reasonCode'"/>
               </xsl:apply-templates>
               <!--reasonReference 0..* Reference-->     <xsl:apply-templates select="*[@key = 'reasonReference']" mode="Reference">
                  <xsl:with-param name="key" select="'reasonReference'"/>
               </xsl:apply-templates>
               <!--payload 0..* Communication.Payload-->     <xsl:apply-templates select="*[@key = 'payload']" mode="Communication.Payload">
                  <xsl:with-param name="key" select="'payload'"/>
               </xsl:apply-templates>
               <!--note 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Communication.Payload">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
               <!--contentString 1..1 string-->   <xsl:apply-templates select="*[@key = 'contentString']" mode="string">
                  <xsl:with-param name="key" select="'contentString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentString'])][*[@key = '_contentString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentString"/>
                        <xsl:copy-of select="fn:map[@key = '_contentString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'contentString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--contentAttachment 1..1 Attachment-->   <xsl:apply-templates select="*[@key = 'contentAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'contentAttachment'"/>
               </xsl:apply-templates>
               <!--contentReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'contentReference']" mode="Reference">
                  <xsl:with-param name="key" select="'contentReference'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the communication.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="EventStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--basedOn 0..* Reference-->     <xsl:apply-templates select="*[@key = 'basedOn']" mode="Reference">
                  <xsl:with-param name="key" select="'basedOn'"/>
               </xsl:apply-templates>
               <!--replaces 0..* Reference-->     <xsl:apply-templates select="*[@key = 'replaces']" mode="Reference">
                  <xsl:with-param name="key" select="'replaces'"/>
               </xsl:apply-templates>
               <!--groupIdentifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'groupIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'groupIdentifier'"/>
               </xsl:apply-templates>
               <!--status 1..1 RequestStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="RequestStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="RequestStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--category 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'category']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'category'"/>
               </xsl:apply-templates>
               <!--priority 0..1 RequestPriority-->     <xsl:apply-templates select="*[@key = 'priority']" mode="RequestPriority">
                  <xsl:with-param name="key" select="'priority'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'priority'])][*[@key = '_priority']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority"/>
                        <xsl:copy-of select="fn:map[@key = '_priority']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="RequestPriority">
                     <xsl:with-param name="key" select="'priority'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--medium 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'medium']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'medium'"/>
               </xsl:apply-templates>
               <!--subject 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--recipient 0..* Reference-->     <xsl:apply-templates select="*[@key = 'recipient']" mode="Reference">
                  <xsl:with-param name="key" select="'recipient'"/>
               </xsl:apply-templates>
               <!--topic 0..* Reference-->     <xsl:apply-templates select="*[@key = 'topic']" mode="Reference">
                  <xsl:with-param name="key" select="'topic'"/>
               </xsl:apply-templates>
               <!--context 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'context']" mode="Reference">
                  <xsl:with-param name="key" select="'context'"/>
               </xsl:apply-templates>
               <!--payload 0..* CommunicationRequest.Payload-->     <xsl:apply-templates select="*[@key = 'payload']" mode="CommunicationRequest.Payload">
                  <xsl:with-param name="key" select="'payload'"/>
               </xsl:apply-templates>
          
            
               <!--occurrenceDateTime 1..1 dateTime-->   <xsl:apply-templates select="*[@key = 'occurrenceDateTime']" mode="dateTime">
                  <xsl:with-param name="key" select="'occurrenceDateTime'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'occurrenceDateTime'])][*[@key = '_occurrenceDateTime']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="occurrenceDateTime"/>
                        <xsl:copy-of select="fn:map[@key = '_occurrenceDateTime']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'occurrenceDateTime'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--occurrencePeriod 1..1 Period-->   <xsl:apply-templates select="*[@key = 'occurrencePeriod']" mode="Period">
                  <xsl:with-param name="key" select="'occurrencePeriod'"/>
               </xsl:apply-templates>
          
               <!--authoredOn 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'authoredOn']" mode="dateTime">
                  <xsl:with-param name="key" select="'authoredOn'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'authoredOn'])][*[@key = '_authoredOn']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="authoredOn"/>
                        <xsl:copy-of select="fn:map[@key = '_authoredOn']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'authoredOn'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--sender 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'sender']" mode="Reference">
                  <xsl:with-param name="key" select="'sender'"/>
               </xsl:apply-templates>
               <!--requester 0..1 CommunicationRequest.Requester-->     <xsl:apply-templates select="*[@key = 'requester']" mode="CommunicationRequest.Requester">
                  <xsl:with-param name="key" select="'requester'"/>
               </xsl:apply-templates>
               <!--reasonCode 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'reasonCode']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'reasonCode'"/>
               </xsl:apply-templates>
               <!--reasonReference 0..* Reference-->     <xsl:apply-templates select="*[@key = 'reasonReference']" mode="Reference">
                  <xsl:with-param name="key" select="'reasonReference'"/>
               </xsl:apply-templates>
               <!--note 0..* Annotation-->     <xsl:apply-templates select="*[@key = 'note']" mode="Annotation">
                  <xsl:with-param name="key" select="'note'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest.Payload">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
               <!--contentString 1..1 string-->   <xsl:apply-templates select="*[@key = 'contentString']" mode="string">
                  <xsl:with-param name="key" select="'contentString'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'contentString'])][*[@key = '_contentString']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentString"/>
                        <xsl:copy-of select="fn:map[@key = '_contentString']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'contentString'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--contentAttachment 1..1 Attachment-->   <xsl:apply-templates select="*[@key = 'contentAttachment']" mode="Attachment">
                  <xsl:with-param name="key" select="'contentAttachment'"/>
               </xsl:apply-templates>
               <!--contentReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'contentReference']" mode="Reference">
                  <xsl:with-param name="key" select="'contentReference'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest.Requester">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--agent 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'agent']" mode="Reference">
                  <xsl:with-param name="key" select="'agent'"/>
               </xsl:apply-templates>
               <!--onBehalfOf 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'onBehalfOf']" mode="Reference">
                  <xsl:with-param name="key" select="'onBehalfOf'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the communication request.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="RequestStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes indicating the relative importance of a communication request.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="RequestPriority">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A compartment definition that defines how resources are accessed on a server.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CompartmentDefinition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--url 1..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--name 1..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--title 0..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--status 1..1 PublicationStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="PublicationStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="PublicationStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--experimental 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'experimental']" mode="boolean">
                  <xsl:with-param name="key" select="'experimental'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'experimental'])][*[@key = '_experimental']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="experimental"/>
                        <xsl:copy-of select="fn:map[@key = '_experimental']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'experimental'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--date 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--publisher 0..1 string-->     <xsl:apply-templates select="*[@key = 'publisher']" mode="string">
                  <xsl:with-param name="key" select="'publisher'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'publisher'])][*[@key = '_publisher']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher"/>
                        <xsl:copy-of select="fn:map[@key = '_publisher']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'publisher'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--contact 0..* ContactDetail-->     <xsl:apply-templates select="*[@key = 'contact']" mode="ContactDetail">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
               <!--description 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'description']" mode="markdown">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--purpose 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'purpose']" mode="markdown">
                  <xsl:with-param name="key" select="'purpose'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'purpose'])][*[@key = '_purpose']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose"/>
                        <xsl:copy-of select="fn:map[@key = '_purpose']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'purpose'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--useContext 0..* UsageContext-->     <xsl:apply-templates select="*[@key = 'useContext']" mode="UsageContext">
                  <xsl:with-param name="key" select="'useContext'"/>
               </xsl:apply-templates>
               <!--jurisdiction 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'jurisdiction']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'jurisdiction'"/>
               </xsl:apply-templates>
               <!--code 1..1 CompartmentType-->     <xsl:apply-templates select="*[@key = 'code']" mode="CompartmentType">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CompartmentType">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--search 1..1 boolean-->     <xsl:apply-templates select="*[@key = 'search']" mode="boolean">
                  <xsl:with-param name="key" select="'search'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'search'])][*[@key = '_search']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="search"/>
                        <xsl:copy-of select="fn:map[@key = '_search']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'search'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--resource 0..* CompartmentDefinition.Resource-->     <xsl:apply-templates select="*[@key = 'resource']" mode="CompartmentDefinition.Resource">
                  <xsl:with-param name="key" select="'resource'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A compartment definition that defines how resources are accessed on a server.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CompartmentDefinition.Resource">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 ResourceType-->     <xsl:apply-templates select="*[@key = 'code']" mode="ResourceType">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ResourceType">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--param 0..* string-->     <xsl:apply-templates select="*[@key = 'param']" mode="string">
                  <xsl:with-param name="key" select="'param'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'param'])][*[@key = '_param']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="param"/>
                        <xsl:copy-of select="fn:map[@key = '_param']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'param'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--documentation 0..1 string-->     <xsl:apply-templates select="*[@key = 'documentation']" mode="string">
                  <xsl:with-param name="key" select="'documentation'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'documentation'])][*[@key = '_documentation']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation"/>
                        <xsl:copy-of select="fn:map[@key = '_documentation']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'documentation'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Which compartment a compartment definition describes</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CompartmentType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--status 1..1 CompositionStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="CompositionStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CompositionStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--type 1..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'type']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'type'"/>
               </xsl:apply-templates>
               <!--class 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'class']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'class'"/>
               </xsl:apply-templates>
               <!--subject 1..1 Reference-->     <xsl:apply-templates select="*[@key = 'subject']" mode="Reference">
                  <xsl:with-param name="key" select="'subject'"/>
               </xsl:apply-templates>
               <!--encounter 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'encounter']" mode="Reference">
                  <xsl:with-param name="key" select="'encounter'"/>
               </xsl:apply-templates>
               <!--date 1..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--author 1..* Reference-->     <xsl:apply-templates select="*[@key = 'author']" mode="Reference">
                  <xsl:with-param name="key" select="'author'"/>
               </xsl:apply-templates>
               <!--title 1..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--confidentiality 0..1 ConfidentialityClassification-->     <xsl:apply-templates select="*[@key = 'confidentiality']"
                                    mode="ConfidentialityClassification">
                  <xsl:with-param name="key" select="'confidentiality'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'confidentiality'])][*[@key = '_confidentiality']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="confidentiality"/>
                        <xsl:copy-of select="fn:map[@key = '_confidentiality']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConfidentialityClassification">
                     <xsl:with-param name="key" select="'confidentiality'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--attester 0..* Composition.Attester-->     <xsl:apply-templates select="*[@key = 'attester']" mode="Composition.Attester">
                  <xsl:with-param name="key" select="'attester'"/>
               </xsl:apply-templates>
               <!--custodian 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'custodian']" mode="Reference">
                  <xsl:with-param name="key" select="'custodian'"/>
               </xsl:apply-templates>
               <!--relatesTo 0..* Composition.RelatesTo-->     <xsl:apply-templates select="*[@key = 'relatesTo']" mode="Composition.RelatesTo">
                  <xsl:with-param name="key" select="'relatesTo'"/>
               </xsl:apply-templates>
               <!--event 0..* Composition.Event-->     <xsl:apply-templates select="*[@key = 'event']" mode="Composition.Event">
                  <xsl:with-param name="key" select="'event'"/>
               </xsl:apply-templates>
               <!--section 0..* Composition.Section-->     <xsl:apply-templates select="*[@key = 'section']" mode="Composition.Section">
                  <xsl:with-param name="key" select="'section'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Attester">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--mode 1..* CompositionAttestationMode-->     <xsl:apply-templates select="*[@key = 'mode']" mode="CompositionAttestationMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="CompositionAttestationMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--time 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'time']" mode="dateTime">
                  <xsl:with-param name="key" select="'time'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'time'])][*[@key = '_time']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="time"/>
                        <xsl:copy-of select="fn:map[@key = '_time']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'time'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--party 0..1 Reference-->     <xsl:apply-templates select="*[@key = 'party']" mode="Reference">
                  <xsl:with-param name="key" select="'party'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition.RelatesTo">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 1..1 DocumentRelationshipType-->     <xsl:apply-templates select="*[@key = 'code']" mode="DocumentRelationshipType">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="DocumentRelationshipType">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--targetIdentifier 1..1 Identifier-->   <xsl:apply-templates select="*[@key = 'targetIdentifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'targetIdentifier'"/>
               </xsl:apply-templates>
               <!--targetReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'targetReference']" mode="Reference">
                  <xsl:with-param name="key" select="'targetReference'"/>
               </xsl:apply-templates>
          
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Event">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--period 0..1 Period-->     <xsl:apply-templates select="*[@key = 'period']" mode="Period">
                  <xsl:with-param name="key" select="'period'"/>
               </xsl:apply-templates>
               <!--detail 0..* Reference-->     <xsl:apply-templates select="*[@key = 'detail']" mode="Reference">
                  <xsl:with-param name="key" select="'detail'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Section">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--title 0..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'code']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <!--text 0..1 Narrative-->     <xsl:apply-templates select="*[@key = 'text']" mode="Narrative">
                  <xsl:with-param name="key" select="'text'"/>
               </xsl:apply-templates>
               <!--mode 0..1 ListMode-->     <xsl:apply-templates select="*[@key = 'mode']" mode="ListMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ListMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--orderedBy 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'orderedBy']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'orderedBy'"/>
               </xsl:apply-templates>
               <!--entry 0..* Reference-->     <xsl:apply-templates select="*[@key = 'entry']" mode="Reference">
                  <xsl:with-param name="key" select="'entry'"/>
               </xsl:apply-templates>
               <!--emptyReason 0..1 CodeableConcept-->     <xsl:apply-templates select="*[@key = 'emptyReason']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'emptyReason'"/>
               </xsl:apply-templates>
               <!--section 0..* Composition.Section-->     <xsl:apply-templates select="*[@key = 'section']" mode="Composition.Section">
                  <xsl:with-param name="key" select="'section'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The workflow/clinical status of the composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CompositionStatus">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes specifying the level of confidentiality of the composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConfidentialityClassification">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of relationship between documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="DocumentRelationshipType">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The way in which a person authenticated a composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="CompositionAttestationMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The processing mode that applies to this section.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ListMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--url 0..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--identifier 0..1 Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--version 0..1 string-->     <xsl:apply-templates select="*[@key = 'version']" mode="string">
                  <xsl:with-param name="key" select="'version'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'version'])][*[@key = '_version']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="version"/>
                        <xsl:copy-of select="fn:map[@key = '_version']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'version'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--name 0..1 string-->     <xsl:apply-templates select="*[@key = 'name']" mode="string">
                  <xsl:with-param name="key" select="'name'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'name'])][*[@key = '_name']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="name"/>
                        <xsl:copy-of select="fn:map[@key = '_name']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'name'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--title 0..1 string-->     <xsl:apply-templates select="*[@key = 'title']" mode="string">
                  <xsl:with-param name="key" select="'title'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'title'])][*[@key = '_title']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="title"/>
                        <xsl:copy-of select="fn:map[@key = '_title']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'title'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--status 1..1 PublicationStatus-->     <xsl:apply-templates select="*[@key = 'status']" mode="PublicationStatus">
                  <xsl:with-param name="key" select="'status'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'status'])][*[@key = '_status']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="status"/>
                        <xsl:copy-of select="fn:map[@key = '_status']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="PublicationStatus">
                     <xsl:with-param name="key" select="'status'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--experimental 0..1 boolean-->     <xsl:apply-templates select="*[@key = 'experimental']" mode="boolean">
                  <xsl:with-param name="key" select="'experimental'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'experimental'])][*[@key = '_experimental']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="experimental"/>
                        <xsl:copy-of select="fn:map[@key = '_experimental']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="boolean">
                     <xsl:with-param name="key" select="'experimental'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--date 0..1 dateTime-->     <xsl:apply-templates select="*[@key = 'date']" mode="dateTime">
                  <xsl:with-param name="key" select="'date'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'date'])][*[@key = '_date']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="date"/>
                        <xsl:copy-of select="fn:map[@key = '_date']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="dateTime">
                     <xsl:with-param name="key" select="'date'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--publisher 0..1 string-->     <xsl:apply-templates select="*[@key = 'publisher']" mode="string">
                  <xsl:with-param name="key" select="'publisher'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'publisher'])][*[@key = '_publisher']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher"/>
                        <xsl:copy-of select="fn:map[@key = '_publisher']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'publisher'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--contact 0..* ContactDetail-->     <xsl:apply-templates select="*[@key = 'contact']" mode="ContactDetail">
                  <xsl:with-param name="key" select="'contact'"/>
               </xsl:apply-templates>
               <!--description 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'description']" mode="markdown">
                  <xsl:with-param name="key" select="'description'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'description'])][*[@key = '_description']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="description"/>
                        <xsl:copy-of select="fn:map[@key = '_description']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'description'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--useContext 0..* UsageContext-->     <xsl:apply-templates select="*[@key = 'useContext']" mode="UsageContext">
                  <xsl:with-param name="key" select="'useContext'"/>
               </xsl:apply-templates>
               <!--jurisdiction 0..* CodeableConcept-->     <xsl:apply-templates select="*[@key = 'jurisdiction']" mode="CodeableConcept">
                  <xsl:with-param name="key" select="'jurisdiction'"/>
               </xsl:apply-templates>
               <!--purpose 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'purpose']" mode="markdown">
                  <xsl:with-param name="key" select="'purpose'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'purpose'])][*[@key = '_purpose']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose"/>
                        <xsl:copy-of select="fn:map[@key = '_purpose']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'purpose'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--copyright 0..1 markdown-->     <xsl:apply-templates select="*[@key = 'copyright']" mode="markdown">
                  <xsl:with-param name="key" select="'copyright'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'copyright'])][*[@key = '_copyright']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright"/>
                        <xsl:copy-of select="fn:map[@key = '_copyright']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="markdown">
                     <xsl:with-param name="key" select="'copyright'"/>
                  </xsl:apply-templates>
               </xsl:if>
          
            
               <!--sourceUri 1..1 uri-->   <xsl:apply-templates select="*[@key = 'sourceUri']" mode="uri">
                  <xsl:with-param name="key" select="'sourceUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sourceUri'])][*[@key = '_sourceUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sourceUri"/>
                        <xsl:copy-of select="fn:map[@key = '_sourceUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'sourceUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--sourceReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'sourceReference']" mode="Reference">
                  <xsl:with-param name="key" select="'sourceReference'"/>
               </xsl:apply-templates>
          
          
            
               <!--targetUri 1..1 uri-->   <xsl:apply-templates select="*[@key = 'targetUri']" mode="uri">
                  <xsl:with-param name="key" select="'targetUri'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'targetUri'])][*[@key = '_targetUri']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetUri"/>
                        <xsl:copy-of select="fn:map[@key = '_targetUri']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'targetUri'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--targetReference 1..1 Reference-->   <xsl:apply-templates select="*[@key = 'targetReference']" mode="Reference">
                  <xsl:with-param name="key" select="'targetReference'"/>
               </xsl:apply-templates>
          
               <!--group 0..* ConceptMap.Group-->     <xsl:apply-templates select="*[@key = 'group']" mode="ConceptMap.Group">
                  <xsl:with-param name="key" select="'group'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Group">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--source 0..1 uri-->     <xsl:apply-templates select="*[@key = 'source']" mode="uri">
                  <xsl:with-param name="key" select="'source'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'source'])][*[@key = '_source']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="source"/>
                        <xsl:copy-of select="fn:map[@key = '_source']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'source'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--sourceVersion 0..1 string-->     <xsl:apply-templates select="*[@key = 'sourceVersion']" mode="string">
                  <xsl:with-param name="key" select="'sourceVersion'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'sourceVersion'])][*[@key = '_sourceVersion']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="sourceVersion"/>
                        <xsl:copy-of select="fn:map[@key = '_sourceVersion']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'sourceVersion'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--target 0..1 uri-->     <xsl:apply-templates select="*[@key = 'target']" mode="uri">
                  <xsl:with-param name="key" select="'target'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'target'])][*[@key = '_target']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="target"/>
                        <xsl:copy-of select="fn:map[@key = '_target']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'target'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--targetVersion 0..1 string-->     <xsl:apply-templates select="*[@key = 'targetVersion']" mode="string">
                  <xsl:with-param name="key" select="'targetVersion'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'targetVersion'])][*[@key = '_targetVersion']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetVersion"/>
                        <xsl:copy-of select="fn:map[@key = '_targetVersion']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'targetVersion'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--element 1..* ConceptMap.Element-->     <xsl:apply-templates select="*[@key = 'element']" mode="ConceptMap.Element">
                  <xsl:with-param name="key" select="'element'"/>
               </xsl:apply-templates>
               <!--unmapped 0..1 ConceptMap.Unmapped-->     <xsl:apply-templates select="*[@key = 'unmapped']" mode="ConceptMap.Unmapped">
                  <xsl:with-param name="key" select="'unmapped'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Element">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 0..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--display 0..1 string-->     <xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--target 0..* ConceptMap.Target-->     <xsl:apply-templates select="*[@key = 'target']" mode="ConceptMap.Target">
                  <xsl:with-param name="key" select="'target'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Target">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--code 0..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--display 0..1 string-->     <xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--equivalence 0..1 ConceptMapEquivalence-->     <xsl:apply-templates select="*[@key = 'equivalence']" mode="ConceptMapEquivalence">
                  <xsl:with-param name="key" select="'equivalence'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'equivalence'])][*[@key = '_equivalence']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="equivalence"/>
                        <xsl:copy-of select="fn:map[@key = '_equivalence']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConceptMapEquivalence">
                     <xsl:with-param name="key" select="'equivalence'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--comment 0..1 string-->     <xsl:apply-templates select="*[@key = 'comment']" mode="string">
                  <xsl:with-param name="key" select="'comment'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'comment'])][*[@key = '_comment']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment"/>
                        <xsl:copy-of select="fn:map[@key = '_comment']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'comment'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--dependsOn 0..* ConceptMap.DependsOn-->     <xsl:apply-templates select="*[@key = 'dependsOn']" mode="ConceptMap.DependsOn">
                  <xsl:with-param name="key" select="'dependsOn'"/>
               </xsl:apply-templates>
               <!--product 0..* ConceptMap.DependsOn-->     <xsl:apply-templates select="*[@key = 'product']" mode="ConceptMap.DependsOn">
                  <xsl:with-param name="key" select="'product'"/>
               </xsl:apply-templates>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.DependsOn">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--property 1..1 uri-->     <xsl:apply-templates select="*[@key = 'property']" mode="uri">
                  <xsl:with-param name="key" select="'property'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'property'])][*[@key = '_property']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="property"/>
                        <xsl:copy-of select="fn:map[@key = '_property']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'property'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--system 0..1 uri-->     <xsl:apply-templates select="*[@key = 'system']" mode="uri">
                  <xsl:with-param name="key" select="'system'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'system'])][*[@key = '_system']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="system"/>
                        <xsl:copy-of select="fn:map[@key = '_system']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'system'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 1..1 string-->     <xsl:apply-templates select="*[@key = 'code']" mode="string">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--display 0..1 string-->     <xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Unmapped">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="BackboneElement"/>
               <!--mode 1..1 ConceptMapGroupUnmappedMode-->     <xsl:apply-templates select="*[@key = 'mode']" mode="ConceptMapGroupUnmappedMode">
                  <xsl:with-param name="key" select="'mode'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'mode'])][*[@key = '_mode']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode"/>
                        <xsl:copy-of select="fn:map[@key = '_mode']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConceptMapGroupUnmappedMode">
                     <xsl:with-param name="key" select="'mode'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--code 0..1 code-->     <xsl:apply-templates select="*[@key = 'code']" mode="code">
                  <xsl:with-param name="key" select="'code'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'code'])][*[@key = '_code']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="code"/>
                        <xsl:copy-of select="fn:map[@key = '_code']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="code">
                     <xsl:with-param name="key" select="'code'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--display 0..1 string-->     <xsl:apply-templates select="*[@key = 'display']" mode="string">
                  <xsl:with-param name="key" select="'display'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'display'])][*[@key = '_display']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="display"/>
                        <xsl:copy-of select="fn:map[@key = '_display']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="string">
                     <xsl:with-param name="key" select="'display'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--url 0..1 uri-->     <xsl:apply-templates select="*[@key = 'url']" mode="uri">
                  <xsl:with-param name="key" select="'url'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'url'])][*[@key = '_url']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="url"/>
                        <xsl:copy-of select="fn:map[@key = '_url']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="uri">
                     <xsl:with-param name="key" select="'url'"/>
                  </xsl:apply-templates>
               </xsl:if>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="$key">
                  <xsl:element name="{$key}" namespace="http://hl7.org/fhir">
                     <xsl:if test="*[@key = 'id']">
                        <xsl:attribute name="id" select="*[@key = 'id']"/>
                     </xsl:if>
                     <xsl:copy-of select="$nodes"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:copy-of select="$nodes"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Defines which action to take if there is no match in the group.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMapGroupUnmappedMode">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:apply-templates select=".">
         <xsl:with-param name="key" select="$key"/>
      </xsl:apply-templates>
   </xsl:template>
    
  <xd:doc>
      <xd:desc>
         <xd:p>A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
      <xd:param name="key">Optional string value for the @key attribute</xd:param>
   </xd:doc>
   <xsl:template match="*" mode="Condition">
      <xsl:param name="key" as="xs:string?"/>
      <xsl:choose>
         <xsl:when test="self::fn:array">
            <xsl:apply-templates select="*" mode="#current">
               <xsl:with-param name="key" select="@key"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="nodes">
               <xsl:apply-templates select="." mode="DomainResource"/>
               <!--identifier 0..* Identifier-->     <xsl:apply-templates select="*[@key = 'identifier']" mode="Identifier">
                  <xsl:with-param name="key" select="'identifier'"/>
               </xsl:apply-templates>
               <!--clinicalStatus 0..1 ConditionClinicalStatusCodes-->     <xsl:apply-templates select="*[@key = 'clinicalStatus']" mode="ConditionClinicalStatusCodes">
                  <xsl:with-param name="key" select="'clinicalStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'clinicalStatus'])][*[@key = '_clinicalStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="clinicalStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_clinicalStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConditionClinicalStatusCodes">
                     <xsl:with-param name="key" select="'clinicalStatus'"/>
                  </xsl:apply-templates>
               </xsl:if>
               <!--verificationStatus 0..1 ConditionVerificationStatus-->     <xsl:apply-templates select="*[@key = 'verificationStatus']"
                                    mode="ConditionVerificationStatus">
                  <xsl:with-param name="key" select="'verificationStatus'"/>
               </xsl:apply-templates>
               <xsl:if test=".[empty(*[@key = 'verificationStatus'])][*[@key = '_verificationStatus']]">
                  <xsl:variable name="theElement" as="element()">
                     <x>
                        <string xmlns="http://www.w3.org/2005/xpath-functions" key="verificationStatus"/>
                        <xsl:copy-of select="fn:map[@key = '_verificationStatus']"/>
                     </x>
                  </xsl:variable>
                  <xsl:apply-templates select="$theElement/fn:string" mode="ConditionV