<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
                xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://hl7.org/fhir"
                xmlns:xh="http://www.w3.org/1999/xhtml"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all"
                version="3.0">
   <xd:doc scope="stylesheet">
      <xd:desc>
         <xd:p>
            <xd:b>Generated:</xd:b> 2022-04-03T07:39:51.714+02:00</xd:p>
         <xd:p>
            <xd:b>By:</xd:b> schema2mapxsl.xsl version 1.0.0</xd:p>
         <xd:p>Takes in FHIR XSD fhir-single.xsd and constructs a stylesheet that will take in a FHIR XML instance and produce an expath map (http://www.w3.org/2005/xpath-functions) that may be converted into a valid FHIR JSON instance</xd:p>
         <xd:p>Known 'issue': does not handle xml comment() as array of fhir_comments, and basically ignores xml comment()</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:output indent="yes"
               method="xml"
               media-type="application/xml"
               omit-xml-declaration="yes"/>
   <xd:doc>
      <xd:desc>Process FHIR instances and error on anything else</xd:desc>
   </xd:doc>
   <xsl:template match="/">
      <xsl:choose>
         <xsl:when test="f:Account">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Account"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ActivityDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ActivityDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:AdverseEvent">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="AdverseEvent"/>
            </map>
         </xsl:when>
         <xsl:when test="f:AllergyIntolerance">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="AllergyIntolerance"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Appointment">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Appointment"/>
            </map>
         </xsl:when>
         <xsl:when test="f:AppointmentResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="AppointmentResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:AuditEvent">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="AuditEvent"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Basic">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Basic"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Binary">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Binary"/>
            </map>
         </xsl:when>
         <xsl:when test="f:BodySite">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="BodySite"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Bundle">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Bundle"/>
            </map>
         </xsl:when>
         <xsl:when test="f:CapabilityStatement">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="CapabilityStatement"/>
            </map>
         </xsl:when>
         <xsl:when test="f:CarePlan">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="CarePlan"/>
            </map>
         </xsl:when>
         <xsl:when test="f:CareTeam">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="CareTeam"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ChargeItem">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ChargeItem"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Claim">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Claim"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ClaimResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ClaimResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ClinicalImpression">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ClinicalImpression"/>
            </map>
         </xsl:when>
         <xsl:when test="f:CodeSystem">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="CodeSystem"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Communication">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Communication"/>
            </map>
         </xsl:when>
         <xsl:when test="f:CommunicationRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="CommunicationRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:CompartmentDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="CompartmentDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Composition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Composition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ConceptMap">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ConceptMap"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Condition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Condition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Consent">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Consent"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Contract">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Contract"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Coverage">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Coverage"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DataElement">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DataElement"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DetectedIssue">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DetectedIssue"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Device">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Device"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DeviceComponent">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DeviceComponent"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DeviceMetric">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DeviceMetric"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DeviceRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DeviceRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DeviceUseStatement">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DeviceUseStatement"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DiagnosticReport">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DiagnosticReport"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DocumentManifest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DocumentManifest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:DocumentReference">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="DocumentReference"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EligibilityRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EligibilityRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EligibilityResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EligibilityResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Encounter">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Encounter"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Endpoint">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Endpoint"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EnrollmentRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EnrollmentRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EnrollmentResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EnrollmentResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:EpisodeOfCare">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="EpisodeOfCare"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ExpansionProfile">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ExpansionProfile"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ExplanationOfBenefit">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ExplanationOfBenefit"/>
            </map>
         </xsl:when>
         <xsl:when test="f:FamilyMemberHistory">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="FamilyMemberHistory"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Flag">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Flag"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Goal">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Goal"/>
            </map>
         </xsl:when>
         <xsl:when test="f:GraphDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="GraphDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Group">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Group"/>
            </map>
         </xsl:when>
         <xsl:when test="f:GuidanceResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="GuidanceResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:HealthcareService">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="HealthcareService"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ImagingManifest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ImagingManifest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ImagingStudy">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ImagingStudy"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Immunization">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Immunization"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ImmunizationRecommendation">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ImmunizationRecommendation"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ImplementationGuide">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ImplementationGuide"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Library">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Library"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Linkage">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Linkage"/>
            </map>
         </xsl:when>
         <xsl:when test="f:List">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="List"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Location">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Location"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Measure">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Measure"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MeasureReport">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MeasureReport"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Media">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Media"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Medication">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Medication"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MedicationAdministration">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MedicationAdministration"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MedicationDispense">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MedicationDispense"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MedicationRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MedicationRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MedicationStatement">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MedicationStatement"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MessageDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MessageDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:MessageHeader">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="MessageHeader"/>
            </map>
         </xsl:when>
         <xsl:when test="f:NamingSystem">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="NamingSystem"/>
            </map>
         </xsl:when>
         <xsl:when test="f:NutritionOrder">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="NutritionOrder"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Observation">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Observation"/>
            </map>
         </xsl:when>
         <xsl:when test="f:OperationDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="OperationDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:OperationOutcome">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="OperationOutcome"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Organization">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Organization"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Patient">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Patient"/>
            </map>
         </xsl:when>
         <xsl:when test="f:PaymentNotice">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="PaymentNotice"/>
            </map>
         </xsl:when>
         <xsl:when test="f:PaymentReconciliation">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="PaymentReconciliation"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Person">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Person"/>
            </map>
         </xsl:when>
         <xsl:when test="f:PlanDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="PlanDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Practitioner">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Practitioner"/>
            </map>
         </xsl:when>
         <xsl:when test="f:PractitionerRole">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="PractitionerRole"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Procedure">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Procedure"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ProcedureRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ProcedureRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ProcessRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ProcessRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ProcessResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ProcessResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Provenance">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Provenance"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Questionnaire">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Questionnaire"/>
            </map>
         </xsl:when>
         <xsl:when test="f:QuestionnaireResponse">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="QuestionnaireResponse"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ReferralRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ReferralRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:RelatedPerson">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="RelatedPerson"/>
            </map>
         </xsl:when>
         <xsl:when test="f:RequestGroup">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="RequestGroup"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ResearchStudy">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ResearchStudy"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ResearchSubject">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ResearchSubject"/>
            </map>
         </xsl:when>
         <xsl:when test="f:RiskAssessment">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="RiskAssessment"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Schedule">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Schedule"/>
            </map>
         </xsl:when>
         <xsl:when test="f:SearchParameter">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="SearchParameter"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Sequence">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Sequence"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ServiceDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ServiceDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Slot">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Slot"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Specimen">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Specimen"/>
            </map>
         </xsl:when>
         <xsl:when test="f:StructureDefinition">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="StructureDefinition"/>
            </map>
         </xsl:when>
         <xsl:when test="f:StructureMap">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="StructureMap"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Subscription">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Subscription"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Substance">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Substance"/>
            </map>
         </xsl:when>
         <xsl:when test="f:SupplyDelivery">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="SupplyDelivery"/>
            </map>
         </xsl:when>
         <xsl:when test="f:SupplyRequest">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="SupplyRequest"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Task">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Task"/>
            </map>
         </xsl:when>
         <xsl:when test="f:TestReport">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="TestReport"/>
            </map>
         </xsl:when>
         <xsl:when test="f:TestScript">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="TestScript"/>
            </map>
         </xsl:when>
         <xsl:when test="f:ValueSet">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="ValueSet"/>
            </map>
         </xsl:when>
         <xsl:when test="f:VisionPrescription">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="VisionPrescription"/>
            </map>
         </xsl:when>
         <xsl:when test="f:Parameters">
            <map xmlns="http://www.w3.org/2005/xpath-functions">
               <xsl:apply-templates mode="Parameters"/>
            </map>
         </xsl:when>
         <xsl:otherwise>
            <xsl:message terminate="yes">Unknown resourceType or not in FHIR namespace: {<xsl:value-of select="*[1]/namespace-uri()"/>}:<xsl:value-of select="*[1]/local-name()"/>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A date or partial date (e.g. just year or year + month). There is no time zone. The format is a union of the schema types gYear, gYearMonth and date.  Dates SHALL be valid dates.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="date">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A date, date-time or partial date (e.g. just year or year + month).  If hours and minutes are specified, a time zone SHALL be populated. The format is a union of the schema types gYear, gYearMonth, date and dateTime. Seconds must be provided due to schema type constraints but may be zero-filled and may be ignored.                 Dates SHALL be valid dates.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="dateTime">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A string which has at least one character and no leading or trailing whitespace and where there is no whitespace other than single spaces in the contents</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="code">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A sequence of Unicode characters</xd:p>
         <xd:p>Note that FHIR strings may not exceed 1MB in size</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="string">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A whole number</xd:p>
         <xd:p>32 bit number; for values larger than this, use decimal</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="integer">
      <xsl:if test="@value">
         <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </number>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An OID represented as a URI</xd:p>
         <xd:p>RFC 3001. See also ISO/IEC 8824:1990 €</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="oid">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>String of characters used to identify a name or a resource</xd:p>
         <xd:p>see http://en.wikipedia.org/wiki/Uniform_resource_identifier</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="uri">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A UUID, represented as a URI</xd:p>
         <xd:p>See The Open Group, CDE 1.1 Remote Procedure Call specification, Appendix A.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="uuid">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An instant in time - known at least to the second</xd:p>
         <xd:p>Note: This is intended for precisely observed times, typically system logs etc., and not human-reported times - for them, see date and dateTime below. Time zone is always required</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="instant">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Value of "true" or "false"</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="boolean">
      <xsl:if test="@value">
         <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </boolean>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A stream of bytes</xd:p>
         <xd:p>A stream of bytes, base64 encoded</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="base64Binary">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An integer with a value that is not negative (e.g. &gt;= 0)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="unsignedInt">
      <xsl:if test="@value">
         <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </number>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A string that may contain markdown syntax for optional processing by a mark down presentation engine</xd:p>
         <xd:p>Systems are not required to have markdown support, and there is considerable variation in markdown syntax, so the text should be readable without markdown processing. The preferred markdown syntax is described here: http://daringfireball.net/projects/markdown/syntax (and tests here: http://daringfireball.net/projects/downloads/MarkdownTest_1.0.zip)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="markdown">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A time during the day, with no date specified</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="time">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Any combination of letters, numerals, "-" and ".", with a length limit of 64 characters.  (This might be an integer, an unprefixed OID, UUID or any other identifier pattern that meets these constraints.)  Ids are case-insensitive.</xd:p>
         <xd:p>RFC 4122</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="id">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An integer with a value that is positive (e.g. &gt;0)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="positiveInt">
      <xsl:if test="@value">
         <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </number>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A rational number with implicit precision</xd:p>
         <xd:p>Do not use a IEEE type floating point type, instead use something that works like a true decimal, with inbuilt precision (e.g. Java BigInteger)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="decimal">
      <xsl:if test="@value">
         <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </number>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="ResourceContainer">
      <!--Account 1..1 Account--><xsl:if test="f:Account">
         <xsl:apply-templates select="f:Account" mode="Account"/>
      </xsl:if>
      <!--ActivityDefinition 1..1 ActivityDefinition--><xsl:if test="f:ActivityDefinition">
         <xsl:apply-templates select="f:ActivityDefinition" mode="ActivityDefinition"/>
      </xsl:if>
      <!--AdverseEvent 1..1 AdverseEvent--><xsl:if test="f:AdverseEvent">
         <xsl:apply-templates select="f:AdverseEvent" mode="AdverseEvent"/>
      </xsl:if>
      <!--AllergyIntolerance 1..1 AllergyIntolerance--><xsl:if test="f:AllergyIntolerance">
         <xsl:apply-templates select="f:AllergyIntolerance" mode="AllergyIntolerance"/>
      </xsl:if>
      <!--Appointment 1..1 Appointment--><xsl:if test="f:Appointment">
         <xsl:apply-templates select="f:Appointment" mode="Appointment"/>
      </xsl:if>
      <!--AppointmentResponse 1..1 AppointmentResponse--><xsl:if test="f:AppointmentResponse">
         <xsl:apply-templates select="f:AppointmentResponse" mode="AppointmentResponse"/>
      </xsl:if>
      <!--AuditEvent 1..1 AuditEvent--><xsl:if test="f:AuditEvent">
         <xsl:apply-templates select="f:AuditEvent" mode="AuditEvent"/>
      </xsl:if>
      <!--Basic 1..1 Basic--><xsl:if test="f:Basic">
         <xsl:apply-templates select="f:Basic" mode="Basic"/>
      </xsl:if>
      <!--Binary 1..1 Binary--><xsl:if test="f:Binary">
         <xsl:apply-templates select="f:Binary" mode="Binary"/>
      </xsl:if>
      <!--BodySite 1..1 BodySite--><xsl:if test="f:BodySite">
         <xsl:apply-templates select="f:BodySite" mode="BodySite"/>
      </xsl:if>
      <!--Bundle 1..1 Bundle--><xsl:if test="f:Bundle">
         <xsl:apply-templates select="f:Bundle" mode="Bundle"/>
      </xsl:if>
      <!--CapabilityStatement 1..1 CapabilityStatement--><xsl:if test="f:CapabilityStatement">
         <xsl:apply-templates select="f:CapabilityStatement" mode="CapabilityStatement"/>
      </xsl:if>
      <!--CarePlan 1..1 CarePlan--><xsl:if test="f:CarePlan">
         <xsl:apply-templates select="f:CarePlan" mode="CarePlan"/>
      </xsl:if>
      <!--CareTeam 1..1 CareTeam--><xsl:if test="f:CareTeam">
         <xsl:apply-templates select="f:CareTeam" mode="CareTeam"/>
      </xsl:if>
      <!--ChargeItem 1..1 ChargeItem--><xsl:if test="f:ChargeItem">
         <xsl:apply-templates select="f:ChargeItem" mode="ChargeItem"/>
      </xsl:if>
      <!--Claim 1..1 Claim--><xsl:if test="f:Claim">
         <xsl:apply-templates select="f:Claim" mode="Claim"/>
      </xsl:if>
      <!--ClaimResponse 1..1 ClaimResponse--><xsl:if test="f:ClaimResponse">
         <xsl:apply-templates select="f:ClaimResponse" mode="ClaimResponse"/>
      </xsl:if>
      <!--ClinicalImpression 1..1 ClinicalImpression--><xsl:if test="f:ClinicalImpression">
         <xsl:apply-templates select="f:ClinicalImpression" mode="ClinicalImpression"/>
      </xsl:if>
      <!--CodeSystem 1..1 CodeSystem--><xsl:if test="f:CodeSystem">
         <xsl:apply-templates select="f:CodeSystem" mode="CodeSystem"/>
      </xsl:if>
      <!--Communication 1..1 Communication--><xsl:if test="f:Communication">
         <xsl:apply-templates select="f:Communication" mode="Communication"/>
      </xsl:if>
      <!--CommunicationRequest 1..1 CommunicationRequest--><xsl:if test="f:CommunicationRequest">
         <xsl:apply-templates select="f:CommunicationRequest" mode="CommunicationRequest"/>
      </xsl:if>
      <!--CompartmentDefinition 1..1 CompartmentDefinition--><xsl:if test="f:CompartmentDefinition">
         <xsl:apply-templates select="f:CompartmentDefinition" mode="CompartmentDefinition"/>
      </xsl:if>
      <!--Composition 1..1 Composition--><xsl:if test="f:Composition">
         <xsl:apply-templates select="f:Composition" mode="Composition"/>
      </xsl:if>
      <!--ConceptMap 1..1 ConceptMap--><xsl:if test="f:ConceptMap">
         <xsl:apply-templates select="f:ConceptMap" mode="ConceptMap"/>
      </xsl:if>
      <!--Condition 1..1 Condition--><xsl:if test="f:Condition">
         <xsl:apply-templates select="f:Condition" mode="Condition"/>
      </xsl:if>
      <!--Consent 1..1 Consent--><xsl:if test="f:Consent">
         <xsl:apply-templates select="f:Consent" mode="Consent"/>
      </xsl:if>
      <!--Contract 1..1 Contract--><xsl:if test="f:Contract">
         <xsl:apply-templates select="f:Contract" mode="Contract"/>
      </xsl:if>
      <!--Coverage 1..1 Coverage--><xsl:if test="f:Coverage">
         <xsl:apply-templates select="f:Coverage" mode="Coverage"/>
      </xsl:if>
      <!--DataElement 1..1 DataElement--><xsl:if test="f:DataElement">
         <xsl:apply-templates select="f:DataElement" mode="DataElement"/>
      </xsl:if>
      <!--DetectedIssue 1..1 DetectedIssue--><xsl:if test="f:DetectedIssue">
         <xsl:apply-templates select="f:DetectedIssue" mode="DetectedIssue"/>
      </xsl:if>
      <!--Device 1..1 Device--><xsl:if test="f:Device">
         <xsl:apply-templates select="f:Device" mode="Device"/>
      </xsl:if>
      <!--DeviceComponent 1..1 DeviceComponent--><xsl:if test="f:DeviceComponent">
         <xsl:apply-templates select="f:DeviceComponent" mode="DeviceComponent"/>
      </xsl:if>
      <!--DeviceMetric 1..1 DeviceMetric--><xsl:if test="f:DeviceMetric">
         <xsl:apply-templates select="f:DeviceMetric" mode="DeviceMetric"/>
      </xsl:if>
      <!--DeviceRequest 1..1 DeviceRequest--><xsl:if test="f:DeviceRequest">
         <xsl:apply-templates select="f:DeviceRequest" mode="DeviceRequest"/>
      </xsl:if>
      <!--DeviceUseStatement 1..1 DeviceUseStatement--><xsl:if test="f:DeviceUseStatement">
         <xsl:apply-templates select="f:DeviceUseStatement" mode="DeviceUseStatement"/>
      </xsl:if>
      <!--DiagnosticReport 1..1 DiagnosticReport--><xsl:if test="f:DiagnosticReport">
         <xsl:apply-templates select="f:DiagnosticReport" mode="DiagnosticReport"/>
      </xsl:if>
      <!--DocumentManifest 1..1 DocumentManifest--><xsl:if test="f:DocumentManifest">
         <xsl:apply-templates select="f:DocumentManifest" mode="DocumentManifest"/>
      </xsl:if>
      <!--DocumentReference 1..1 DocumentReference--><xsl:if test="f:DocumentReference">
         <xsl:apply-templates select="f:DocumentReference" mode="DocumentReference"/>
      </xsl:if>
      <!--EligibilityRequest 1..1 EligibilityRequest--><xsl:if test="f:EligibilityRequest">
         <xsl:apply-templates select="f:EligibilityRequest" mode="EligibilityRequest"/>
      </xsl:if>
      <!--EligibilityResponse 1..1 EligibilityResponse--><xsl:if test="f:EligibilityResponse">
         <xsl:apply-templates select="f:EligibilityResponse" mode="EligibilityResponse"/>
      </xsl:if>
      <!--Encounter 1..1 Encounter--><xsl:if test="f:Encounter">
         <xsl:apply-templates select="f:Encounter" mode="Encounter"/>
      </xsl:if>
      <!--Endpoint 1..1 Endpoint--><xsl:if test="f:Endpoint">
         <xsl:apply-templates select="f:Endpoint" mode="Endpoint"/>
      </xsl:if>
      <!--EnrollmentRequest 1..1 EnrollmentRequest--><xsl:if test="f:EnrollmentRequest">
         <xsl:apply-templates select="f:EnrollmentRequest" mode="EnrollmentRequest"/>
      </xsl:if>
      <!--EnrollmentResponse 1..1 EnrollmentResponse--><xsl:if test="f:EnrollmentResponse">
         <xsl:apply-templates select="f:EnrollmentResponse" mode="EnrollmentResponse"/>
      </xsl:if>
      <!--EpisodeOfCare 1..1 EpisodeOfCare--><xsl:if test="f:EpisodeOfCare">
         <xsl:apply-templates select="f:EpisodeOfCare" mode="EpisodeOfCare"/>
      </xsl:if>
      <!--ExpansionProfile 1..1 ExpansionProfile--><xsl:if test="f:ExpansionProfile">
         <xsl:apply-templates select="f:ExpansionProfile" mode="ExpansionProfile"/>
      </xsl:if>
      <!--ExplanationOfBenefit 1..1 ExplanationOfBenefit--><xsl:if test="f:ExplanationOfBenefit">
         <xsl:apply-templates select="f:ExplanationOfBenefit" mode="ExplanationOfBenefit"/>
      </xsl:if>
      <!--FamilyMemberHistory 1..1 FamilyMemberHistory--><xsl:if test="f:FamilyMemberHistory">
         <xsl:apply-templates select="f:FamilyMemberHistory" mode="FamilyMemberHistory"/>
      </xsl:if>
      <!--Flag 1..1 Flag--><xsl:if test="f:Flag">
         <xsl:apply-templates select="f:Flag" mode="Flag"/>
      </xsl:if>
      <!--Goal 1..1 Goal--><xsl:if test="f:Goal">
         <xsl:apply-templates select="f:Goal" mode="Goal"/>
      </xsl:if>
      <!--GraphDefinition 1..1 GraphDefinition--><xsl:if test="f:GraphDefinition">
         <xsl:apply-templates select="f:GraphDefinition" mode="GraphDefinition"/>
      </xsl:if>
      <!--Group 1..1 Group--><xsl:if test="f:Group">
         <xsl:apply-templates select="f:Group" mode="Group"/>
      </xsl:if>
      <!--GuidanceResponse 1..1 GuidanceResponse--><xsl:if test="f:GuidanceResponse">
         <xsl:apply-templates select="f:GuidanceResponse" mode="GuidanceResponse"/>
      </xsl:if>
      <!--HealthcareService 1..1 HealthcareService--><xsl:if test="f:HealthcareService">
         <xsl:apply-templates select="f:HealthcareService" mode="HealthcareService"/>
      </xsl:if>
      <!--ImagingManifest 1..1 ImagingManifest--><xsl:if test="f:ImagingManifest">
         <xsl:apply-templates select="f:ImagingManifest" mode="ImagingManifest"/>
      </xsl:if>
      <!--ImagingStudy 1..1 ImagingStudy--><xsl:if test="f:ImagingStudy">
         <xsl:apply-templates select="f:ImagingStudy" mode="ImagingStudy"/>
      </xsl:if>
      <!--Immunization 1..1 Immunization--><xsl:if test="f:Immunization">
         <xsl:apply-templates select="f:Immunization" mode="Immunization"/>
      </xsl:if>
      <!--ImmunizationRecommendation 1..1 ImmunizationRecommendation--><xsl:if test="f:ImmunizationRecommendation">
         <xsl:apply-templates select="f:ImmunizationRecommendation" mode="ImmunizationRecommendation"/>
      </xsl:if>
      <!--ImplementationGuide 1..1 ImplementationGuide--><xsl:if test="f:ImplementationGuide">
         <xsl:apply-templates select="f:ImplementationGuide" mode="ImplementationGuide"/>
      </xsl:if>
      <!--Library 1..1 Library--><xsl:if test="f:Library">
         <xsl:apply-templates select="f:Library" mode="Library"/>
      </xsl:if>
      <!--Linkage 1..1 Linkage--><xsl:if test="f:Linkage">
         <xsl:apply-templates select="f:Linkage" mode="Linkage"/>
      </xsl:if>
      <!--List 1..1 List--><xsl:if test="f:List">
         <xsl:apply-templates select="f:List" mode="List"/>
      </xsl:if>
      <!--Location 1..1 Location--><xsl:if test="f:Location">
         <xsl:apply-templates select="f:Location" mode="Location"/>
      </xsl:if>
      <!--Measure 1..1 Measure--><xsl:if test="f:Measure">
         <xsl:apply-templates select="f:Measure" mode="Measure"/>
      </xsl:if>
      <!--MeasureReport 1..1 MeasureReport--><xsl:if test="f:MeasureReport">
         <xsl:apply-templates select="f:MeasureReport" mode="MeasureReport"/>
      </xsl:if>
      <!--Media 1..1 Media--><xsl:if test="f:Media">
         <xsl:apply-templates select="f:Media" mode="Media"/>
      </xsl:if>
      <!--Medication 1..1 Medication--><xsl:if test="f:Medication">
         <xsl:apply-templates select="f:Medication" mode="Medication"/>
      </xsl:if>
      <!--MedicationAdministration 1..1 MedicationAdministration--><xsl:if test="f:MedicationAdministration">
         <xsl:apply-templates select="f:MedicationAdministration" mode="MedicationAdministration"/>
      </xsl:if>
      <!--MedicationDispense 1..1 MedicationDispense--><xsl:if test="f:MedicationDispense">
         <xsl:apply-templates select="f:MedicationDispense" mode="MedicationDispense"/>
      </xsl:if>
      <!--MedicationRequest 1..1 MedicationRequest--><xsl:if test="f:MedicationRequest">
         <xsl:apply-templates select="f:MedicationRequest" mode="MedicationRequest"/>
      </xsl:if>
      <!--MedicationStatement 1..1 MedicationStatement--><xsl:if test="f:MedicationStatement">
         <xsl:apply-templates select="f:MedicationStatement" mode="MedicationStatement"/>
      </xsl:if>
      <!--MessageDefinition 1..1 MessageDefinition--><xsl:if test="f:MessageDefinition">
         <xsl:apply-templates select="f:MessageDefinition" mode="MessageDefinition"/>
      </xsl:if>
      <!--MessageHeader 1..1 MessageHeader--><xsl:if test="f:MessageHeader">
         <xsl:apply-templates select="f:MessageHeader" mode="MessageHeader"/>
      </xsl:if>
      <!--NamingSystem 1..1 NamingSystem--><xsl:if test="f:NamingSystem">
         <xsl:apply-templates select="f:NamingSystem" mode="NamingSystem"/>
      </xsl:if>
      <!--NutritionOrder 1..1 NutritionOrder--><xsl:if test="f:NutritionOrder">
         <xsl:apply-templates select="f:NutritionOrder" mode="NutritionOrder"/>
      </xsl:if>
      <!--Observation 1..1 Observation--><xsl:if test="f:Observation">
         <xsl:apply-templates select="f:Observation" mode="Observation"/>
      </xsl:if>
      <!--OperationDefinition 1..1 OperationDefinition--><xsl:if test="f:OperationDefinition">
         <xsl:apply-templates select="f:OperationDefinition" mode="OperationDefinition"/>
      </xsl:if>
      <!--OperationOutcome 1..1 OperationOutcome--><xsl:if test="f:OperationOutcome">
         <xsl:apply-templates select="f:OperationOutcome" mode="OperationOutcome"/>
      </xsl:if>
      <!--Organization 1..1 Organization--><xsl:if test="f:Organization">
         <xsl:apply-templates select="f:Organization" mode="Organization"/>
      </xsl:if>
      <!--Patient 1..1 Patient--><xsl:if test="f:Patient">
         <xsl:apply-templates select="f:Patient" mode="Patient"/>
      </xsl:if>
      <!--PaymentNotice 1..1 PaymentNotice--><xsl:if test="f:PaymentNotice">
         <xsl:apply-templates select="f:PaymentNotice" mode="PaymentNotice"/>
      </xsl:if>
      <!--PaymentReconciliation 1..1 PaymentReconciliation--><xsl:if test="f:PaymentReconciliation">
         <xsl:apply-templates select="f:PaymentReconciliation" mode="PaymentReconciliation"/>
      </xsl:if>
      <!--Person 1..1 Person--><xsl:if test="f:Person">
         <xsl:apply-templates select="f:Person" mode="Person"/>
      </xsl:if>
      <!--PlanDefinition 1..1 PlanDefinition--><xsl:if test="f:PlanDefinition">
         <xsl:apply-templates select="f:PlanDefinition" mode="PlanDefinition"/>
      </xsl:if>
      <!--Practitioner 1..1 Practitioner--><xsl:if test="f:Practitioner">
         <xsl:apply-templates select="f:Practitioner" mode="Practitioner"/>
      </xsl:if>
      <!--PractitionerRole 1..1 PractitionerRole--><xsl:if test="f:PractitionerRole">
         <xsl:apply-templates select="f:PractitionerRole" mode="PractitionerRole"/>
      </xsl:if>
      <!--Procedure 1..1 Procedure--><xsl:if test="f:Procedure">
         <xsl:apply-templates select="f:Procedure" mode="Procedure"/>
      </xsl:if>
      <!--ProcedureRequest 1..1 ProcedureRequest--><xsl:if test="f:ProcedureRequest">
         <xsl:apply-templates select="f:ProcedureRequest" mode="ProcedureRequest"/>
      </xsl:if>
      <!--ProcessRequest 1..1 ProcessRequest--><xsl:if test="f:ProcessRequest">
         <xsl:apply-templates select="f:ProcessRequest" mode="ProcessRequest"/>
      </xsl:if>
      <!--ProcessResponse 1..1 ProcessResponse--><xsl:if test="f:ProcessResponse">
         <xsl:apply-templates select="f:ProcessResponse" mode="ProcessResponse"/>
      </xsl:if>
      <!--Provenance 1..1 Provenance--><xsl:if test="f:Provenance">
         <xsl:apply-templates select="f:Provenance" mode="Provenance"/>
      </xsl:if>
      <!--Questionnaire 1..1 Questionnaire--><xsl:if test="f:Questionnaire">
         <xsl:apply-templates select="f:Questionnaire" mode="Questionnaire"/>
      </xsl:if>
      <!--QuestionnaireResponse 1..1 QuestionnaireResponse--><xsl:if test="f:QuestionnaireResponse">
         <xsl:apply-templates select="f:QuestionnaireResponse" mode="QuestionnaireResponse"/>
      </xsl:if>
      <!--ReferralRequest 1..1 ReferralRequest--><xsl:if test="f:ReferralRequest">
         <xsl:apply-templates select="f:ReferralRequest" mode="ReferralRequest"/>
      </xsl:if>
      <!--RelatedPerson 1..1 RelatedPerson--><xsl:if test="f:RelatedPerson">
         <xsl:apply-templates select="f:RelatedPerson" mode="RelatedPerson"/>
      </xsl:if>
      <!--RequestGroup 1..1 RequestGroup--><xsl:if test="f:RequestGroup">
         <xsl:apply-templates select="f:RequestGroup" mode="RequestGroup"/>
      </xsl:if>
      <!--ResearchStudy 1..1 ResearchStudy--><xsl:if test="f:ResearchStudy">
         <xsl:apply-templates select="f:ResearchStudy" mode="ResearchStudy"/>
      </xsl:if>
      <!--ResearchSubject 1..1 ResearchSubject--><xsl:if test="f:ResearchSubject">
         <xsl:apply-templates select="f:ResearchSubject" mode="ResearchSubject"/>
      </xsl:if>
      <!--RiskAssessment 1..1 RiskAssessment--><xsl:if test="f:RiskAssessment">
         <xsl:apply-templates select="f:RiskAssessment" mode="RiskAssessment"/>
      </xsl:if>
      <!--Schedule 1..1 Schedule--><xsl:if test="f:Schedule">
         <xsl:apply-templates select="f:Schedule" mode="Schedule"/>
      </xsl:if>
      <!--SearchParameter 1..1 SearchParameter--><xsl:if test="f:SearchParameter">
         <xsl:apply-templates select="f:SearchParameter" mode="SearchParameter"/>
      </xsl:if>
      <!--Sequence 1..1 Sequence--><xsl:if test="f:Sequence">
         <xsl:apply-templates select="f:Sequence" mode="Sequence"/>
      </xsl:if>
      <!--ServiceDefinition 1..1 ServiceDefinition--><xsl:if test="f:ServiceDefinition">
         <xsl:apply-templates select="f:ServiceDefinition" mode="ServiceDefinition"/>
      </xsl:if>
      <!--Slot 1..1 Slot--><xsl:if test="f:Slot">
         <xsl:apply-templates select="f:Slot" mode="Slot"/>
      </xsl:if>
      <!--Specimen 1..1 Specimen--><xsl:if test="f:Specimen">
         <xsl:apply-templates select="f:Specimen" mode="Specimen"/>
      </xsl:if>
      <!--StructureDefinition 1..1 StructureDefinition--><xsl:if test="f:StructureDefinition">
         <xsl:apply-templates select="f:StructureDefinition" mode="StructureDefinition"/>
      </xsl:if>
      <!--StructureMap 1..1 StructureMap--><xsl:if test="f:StructureMap">
         <xsl:apply-templates select="f:StructureMap" mode="StructureMap"/>
      </xsl:if>
      <!--Subscription 1..1 Subscription--><xsl:if test="f:Subscription">
         <xsl:apply-templates select="f:Subscription" mode="Subscription"/>
      </xsl:if>
      <!--Substance 1..1 Substance--><xsl:if test="f:Substance">
         <xsl:apply-templates select="f:Substance" mode="Substance"/>
      </xsl:if>
      <!--SupplyDelivery 1..1 SupplyDelivery--><xsl:if test="f:SupplyDelivery">
         <xsl:apply-templates select="f:SupplyDelivery" mode="SupplyDelivery"/>
      </xsl:if>
      <!--SupplyRequest 1..1 SupplyRequest--><xsl:if test="f:SupplyRequest">
         <xsl:apply-templates select="f:SupplyRequest" mode="SupplyRequest"/>
      </xsl:if>
      <!--Task 1..1 Task--><xsl:if test="f:Task">
         <xsl:apply-templates select="f:Task" mode="Task"/>
      </xsl:if>
      <!--TestReport 1..1 TestReport--><xsl:if test="f:TestReport">
         <xsl:apply-templates select="f:TestReport" mode="TestReport"/>
      </xsl:if>
      <!--TestScript 1..1 TestScript--><xsl:if test="f:TestScript">
         <xsl:apply-templates select="f:TestScript" mode="TestScript"/>
      </xsl:if>
      <!--ValueSet 1..1 ValueSet--><xsl:if test="f:ValueSet">
         <xsl:apply-templates select="f:ValueSet" mode="ValueSet"/>
      </xsl:if>
      <!--VisionPrescription 1..1 VisionPrescription--><xsl:if test="f:VisionPrescription">
         <xsl:apply-templates select="f:VisionPrescription" mode="VisionPrescription"/>
      </xsl:if>
      <!--Parameters 1..1 Parameters--><xsl:if test="f:Parameters">
         <xsl:apply-templates select="f:Parameters" mode="Parameters"/>
      </xsl:if>
    </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Optional Extension Element - found in all resources.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Extension">
      <xsl:if test="@url">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
            <xsl:value-of select="@url"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
        
           
           <!--valueBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:valueBase64Binary">
         <xsl:if test="f:valueBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBase64Binary">
               <xsl:value-of select="f:valueBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueBase64Binary">
               <xsl:apply-templates select="f:valueBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:valueBoolean">
         <xsl:if test="f:valueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean">
               <xsl:value-of select="f:valueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:valueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueBoolean">
               <xsl:apply-templates select="f:valueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueCode 1..1 code (json type: string)--><xsl:if test="f:valueCode">
         <xsl:if test="f:valueCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode">
               <xsl:value-of select="f:valueCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueCode">
               <xsl:apply-templates select="f:valueCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueDate 1..1 date (json type: string)--><xsl:if test="f:valueDate">
         <xsl:if test="f:valueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDate">
               <xsl:value-of select="f:valueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDate">
               <xsl:apply-templates select="f:valueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:valueDateTime">
         <xsl:if test="f:valueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime">
               <xsl:value-of select="f:valueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDateTime">
               <xsl:apply-templates select="f:valueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:valueDecimal">
         <xsl:if test="f:valueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueDecimal">
               <xsl:value-of select="f:valueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDecimal">
               <xsl:apply-templates select="f:valueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueId 1..1 id (json type: string)--><xsl:if test="f:valueId">
         <xsl:if test="f:valueId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueId">
               <xsl:value-of select="f:valueId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueId">
               <xsl:apply-templates select="f:valueId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueInstant 1..1 instant (json type: string)--><xsl:if test="f:valueInstant">
         <xsl:if test="f:valueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInstant">
               <xsl:value-of select="f:valueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueInstant">
               <xsl:apply-templates select="f:valueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueInteger 1..1 integer (json type: number)--><xsl:if test="f:valueInteger">
         <xsl:if test="f:valueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueInteger">
               <xsl:value-of select="f:valueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueInteger">
               <xsl:apply-templates select="f:valueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:valueMarkdown">
         <xsl:if test="f:valueMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueMarkdown">
               <xsl:value-of select="f:valueMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueMarkdown">
               <xsl:apply-templates select="f:valueMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueOid 1..1 oid (json type: string)--><xsl:if test="f:valueOid">
         <xsl:if test="f:valueOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueOid">
               <xsl:value-of select="f:valueOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueOid">
               <xsl:apply-templates select="f:valueOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:valuePositiveInt">
         <xsl:if test="f:valuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valuePositiveInt">
               <xsl:value-of select="f:valuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valuePositiveInt">
               <xsl:apply-templates select="f:valuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueString 1..1 string (json type: string)--><xsl:if test="f:valueString">
         <xsl:if test="f:valueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString">
               <xsl:value-of select="f:valueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueString">
               <xsl:apply-templates select="f:valueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueTime 1..1 time (json type: string)--><xsl:if test="f:valueTime">
         <xsl:if test="f:valueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueTime">
               <xsl:value-of select="f:valueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueTime">
               <xsl:apply-templates select="f:valueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:valueUnsignedInt">
         <xsl:if test="f:valueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueUnsignedInt">
               <xsl:value-of select="f:valueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueUnsignedInt">
               <xsl:apply-templates select="f:valueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueUri 1..1 uri (json type: string)--><xsl:if test="f:valueUri">
         <xsl:if test="f:valueUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUri">
               <xsl:value-of select="f:valueUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueUri">
               <xsl:apply-templates select="f:valueUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueAddress 1..1 Address--><xsl:if test="f:valueAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAddress">
            <xsl:apply-templates select="f:valueAddress" mode="Address"/>
         </map>
      </xsl:if>
           <!--valueAge 1..1 Age--><xsl:if test="f:valueAge">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAge">
            <xsl:apply-templates select="f:valueAge" mode="Age"/>
         </map>
      </xsl:if>
           <!--valueAnnotation 1..1 Annotation--><xsl:if test="f:valueAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAnnotation">
            <xsl:apply-templates select="f:valueAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
           <!--valueAttachment 1..1 Attachment--><xsl:if test="f:valueAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAttachment">
            <xsl:apply-templates select="f:valueAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
           <!--valueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:valueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCodeableConcept">
            <xsl:apply-templates select="f:valueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
           <!--valueCoding 1..1 Coding--><xsl:if test="f:valueCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCoding">
            <xsl:apply-templates select="f:valueCoding" mode="Coding"/>
         </map>
      </xsl:if>
           <!--valueContactPoint 1..1 ContactPoint--><xsl:if test="f:valueContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueContactPoint">
            <xsl:apply-templates select="f:valueContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
           <!--valueCount 1..1 Count--><xsl:if test="f:valueCount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCount">
            <xsl:apply-templates select="f:valueCount" mode="Count"/>
         </map>
      </xsl:if>
           <!--valueDistance 1..1 Distance--><xsl:if test="f:valueDistance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueDistance">
            <xsl:apply-templates select="f:valueDistance" mode="Distance"/>
         </map>
      </xsl:if>
           <!--valueDuration 1..1 Duration--><xsl:if test="f:valueDuration">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueDuration">
            <xsl:apply-templates select="f:valueDuration" mode="Duration"/>
         </map>
      </xsl:if>
           <!--valueHumanName 1..1 HumanName--><xsl:if test="f:valueHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueHumanName">
            <xsl:apply-templates select="f:valueHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
           <!--valueIdentifier 1..1 Identifier--><xsl:if test="f:valueIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueIdentifier">
            <xsl:apply-templates select="f:valueIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
           <!--valueMoney 1..1 Money--><xsl:if test="f:valueMoney">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueMoney">
            <xsl:apply-templates select="f:valueMoney" mode="Money"/>
         </map>
      </xsl:if>
           <!--valuePeriod 1..1 Period--><xsl:if test="f:valuePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valuePeriod">
            <xsl:apply-templates select="f:valuePeriod" mode="Period"/>
         </map>
      </xsl:if>
           <!--valueQuantity 1..1 Quantity--><xsl:if test="f:valueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueQuantity">
            <xsl:apply-templates select="f:valueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
           <!--valueRange 1..1 Range--><xsl:if test="f:valueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueRange">
            <xsl:apply-templates select="f:valueRange" mode="Range"/>
         </map>
      </xsl:if>
           <!--valueRatio 1..1 Ratio--><xsl:if test="f:valueRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueRatio">
            <xsl:apply-templates select="f:valueRatio" mode="Ratio"/>
         </map>
      </xsl:if>
           <!--valueReference 1..1 Reference--><xsl:if test="f:valueReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueReference">
            <xsl:apply-templates select="f:valueReference" mode="Reference"/>
         </map>
      </xsl:if>
           <!--valueSampledData 1..1 SampledData--><xsl:if test="f:valueSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSampledData">
            <xsl:apply-templates select="f:valueSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
           <!--valueSignature 1..1 Signature--><xsl:if test="f:valueSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSignature">
            <xsl:apply-templates select="f:valueSignature" mode="Signature"/>
         </map>
      </xsl:if>
           <!--valueTiming 1..1 Timing--><xsl:if test="f:valueTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueTiming">
            <xsl:apply-templates select="f:valueTiming" mode="Timing"/>
         </map>
      </xsl:if>
           <!--valueMeta 1..1 Meta--><xsl:if test="f:valueMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueMeta">
            <xsl:apply-templates select="f:valueMeta" mode="Meta"/>
         </map>
      </xsl:if>
         
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Base definition for all elements that are defined inside a resource - but not those in a data type.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="BackboneElement">
      <xsl:apply-templates select="." mode="Element"/>
          <!--modifierExtension 0..* Extension--><xsl:if test="f:modifierExtension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifierExtension">
            <xsl:for-each select="f:modifierExtension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A human-readable formatted text, including images.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Narrative">
      <xsl:apply-templates select="." mode="Element"/>
          <!--status 1..1 NarrativeStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--xhtml:div 1..1 --><xsl:if test="xhtml:div">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="div">
            <xsl:value-of select="fn:serialize(xhtml:div)"/>
         </string>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of a resource narrative</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="NarrativeStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Base definition for all elements in a resource.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Element">
      <xsl:if test="@id">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
            <xsl:value-of select="@id"/>
         </string>
      </xsl:if>
          <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference from one resource to another.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Reference">
      <xsl:apply-templates select="." mode="Element"/>
          <!--reference 0..1 string (json type: string)--><xsl:if test="f:reference">
         <xsl:if test="f:reference/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
               <xsl:value-of select="f:reference/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:reference[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reference">
               <xsl:apply-templates select="f:reference" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A measured amount (or an amount that can potentially be measured). Note that measured amounts include amounts that are not precisely quantified, including amounts involving arbitrary units and floating currencies.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Quantity">
      <xsl:apply-templates select="." mode="Element"/>
          <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--comparator 0..1 QuantityComparator (json type: string)--><xsl:if test="f:comparator">
         <xsl:if test="f:comparator/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comparator">
               <xsl:value-of select="f:comparator/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comparator[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comparator">
               <xsl:apply-templates select="f:comparator" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--unit 0..1 string (json type: string)--><xsl:if test="f:unit">
         <xsl:if test="f:unit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
               <xsl:value-of select="f:unit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:unit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_unit">
               <xsl:apply-templates select="f:unit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How the Quantity should be understood and represented.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="QuantityComparator">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A time period defined by a start and end date and optionally time.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Period">
      <xsl:apply-templates select="." mode="Element"/>
          <!--start 0..1 dateTime (json type: string)--><xsl:if test="f:start">
         <xsl:if test="f:start/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="start">
               <xsl:value-of select="f:start/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:start[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_start">
               <xsl:apply-templates select="f:start" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--end 0..1 dateTime (json type: string)--><xsl:if test="f:end">
         <xsl:if test="f:end/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="end">
               <xsl:value-of select="f:end/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:end[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_end">
               <xsl:apply-templates select="f:end" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>For referring to data content defined in other formats.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Attachment">
      <xsl:apply-templates select="." mode="Element"/>
          <!--contentType 0..1 code (json type: string)--><xsl:if test="f:contentType">
         <xsl:if test="f:contentType/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType">
               <xsl:value-of select="f:contentType/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentType[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentType">
               <xsl:apply-templates select="f:contentType" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--data 0..1 base64Binary (json type: string)--><xsl:if test="f:data">
         <xsl:if test="f:data/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="data">
               <xsl:value-of select="f:data/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:data[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_data">
               <xsl:apply-templates select="f:data" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--size 0..1 unsignedInt (json type: number)--><xsl:if test="f:size">
         <xsl:if test="f:size/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="size">
               <xsl:value-of select="f:size/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:size[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_size">
               <xsl:apply-templates select="f:size" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--hash 0..1 base64Binary (json type: string)--><xsl:if test="f:hash">
         <xsl:if test="f:hash/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="hash">
               <xsl:value-of select="f:hash/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:hash[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_hash">
               <xsl:apply-templates select="f:hash" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--creation 0..1 dateTime (json type: string)--><xsl:if test="f:creation">
         <xsl:if test="f:creation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="creation">
               <xsl:value-of select="f:creation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:creation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_creation">
               <xsl:apply-templates select="f:creation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A length of time.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Duration">
      <xsl:apply-templates select="." mode="Quantity"/>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A measured amount (or an amount that can potentially be measured). Note that measured amounts include amounts that are not precisely quantified, including amounts involving arbitrary units and floating currencies.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Count">
      <xsl:apply-templates select="." mode="Quantity"/>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of ordered Quantities defined by a low and high limit.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Range">
      <xsl:apply-templates select="." mode="Element"/>
          <!--low 0..1 Quantity--><xsl:if test="f:low">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="low">
            <xsl:apply-templates select="f:low" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--high 0..1 Quantity--><xsl:if test="f:high">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="high">
            <xsl:apply-templates select="f:high" mode="Quantity"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A  text note which also  contains information about who made the statement and when.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Annotation">
      <xsl:apply-templates select="." mode="Element"/>
          
            
           <!--authorReference 1..1 Reference--><xsl:if test="f:authorReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="authorReference">
            <xsl:apply-templates select="f:authorReference" mode="Reference"/>
         </map>
      </xsl:if>
           <!--authorString 1..1 string (json type: string)--><xsl:if test="f:authorString">
         <xsl:if test="f:authorString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="authorString">
               <xsl:value-of select="f:authorString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:authorString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_authorString">
               <xsl:apply-templates select="f:authorString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
          <!--time 0..1 dateTime (json type: string)--><xsl:if test="f:time">
         <xsl:if test="f:time/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="time">
               <xsl:value-of select="f:time/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:time[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_time">
               <xsl:apply-templates select="f:time" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--text 1..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An amount of economic utility in some recognized currency.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Money">
      <xsl:apply-templates select="." mode="Quantity"/>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A technical identifier - identifies some entity uniquely and unambiguously.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Identifier">
      <xsl:apply-templates select="." mode="Element"/>
          <!--use 0..1 IdentifierUse (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--value 0..1 string (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--assigner 0..1 Reference--><xsl:if test="f:assigner">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="assigner">
            <xsl:apply-templates select="f:assigner" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Identifies the purpose for this identifier, if known .</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="IdentifierUse">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a code defined by a terminology system.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Coding">
      <xsl:apply-templates select="." mode="Element"/>
          <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--userSelected 0..1 boolean (json type: boolean)--><xsl:if test="f:userSelected">
         <xsl:if test="f:userSelected/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="userSelected">
               <xsl:value-of select="f:userSelected/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:userSelected[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_userSelected">
               <xsl:apply-templates select="f:userSelected" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A digital signature along with supporting context. The signature may be electronic/cryptographic in nature, or a graphical image representing a hand-written signature, or a signature process. Different signature approaches have different utilities.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Signature">
      <xsl:apply-templates select="." mode="Element"/>
          <!--type 1..* Coding--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--when 1..1 instant (json type: string)--><xsl:if test="f:when">
         <xsl:if test="f:when/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="when">
               <xsl:value-of select="f:when/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:when[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_when">
               <xsl:apply-templates select="f:when" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
           <!--whoUri 1..1 uri (json type: string)--><xsl:if test="f:whoUri">
         <xsl:if test="f:whoUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="whoUri">
               <xsl:value-of select="f:whoUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:whoUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_whoUri">
               <xsl:apply-templates select="f:whoUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--whoReference 1..1 Reference--><xsl:if test="f:whoReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="whoReference">
            <xsl:apply-templates select="f:whoReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          
            
           <!--onBehalfOfUri 1..1 uri (json type: string)--><xsl:if test="f:onBehalfOfUri">
         <xsl:if test="f:onBehalfOfUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onBehalfOfUri">
               <xsl:value-of select="f:onBehalfOfUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onBehalfOfUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onBehalfOfUri">
               <xsl:apply-templates select="f:onBehalfOfUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--onBehalfOfReference 1..1 Reference--><xsl:if test="f:onBehalfOfReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onBehalfOfReference">
            <xsl:apply-templates select="f:onBehalfOfReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--contentType 0..1 code (json type: string)--><xsl:if test="f:contentType">
         <xsl:if test="f:contentType/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType">
               <xsl:value-of select="f:contentType/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentType[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentType">
               <xsl:apply-templates select="f:contentType" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--blob 0..1 base64Binary (json type: string)--><xsl:if test="f:blob">
         <xsl:if test="f:blob/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="blob">
               <xsl:value-of select="f:blob/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:blob[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_blob">
               <xsl:apply-templates select="f:blob" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A series of measurements taken by a device, with upper and lower limits. There may be more than one dimension in the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SampledData">
      <xsl:apply-templates select="." mode="Element"/>
          <!--origin 1..1 Quantity--><xsl:if test="f:origin">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="origin">
            <xsl:apply-templates select="f:origin" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--period 1..1 decimal (json type: number)--><xsl:if test="f:period">
         <xsl:if test="f:period/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="period">
               <xsl:value-of select="f:period/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:period[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_period">
               <xsl:apply-templates select="f:period" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--lowerLimit 0..1 decimal (json type: number)--><xsl:if test="f:lowerLimit">
         <xsl:if test="f:lowerLimit/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="lowerLimit">
               <xsl:value-of select="f:lowerLimit/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:lowerLimit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lowerLimit">
               <xsl:apply-templates select="f:lowerLimit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--upperLimit 0..1 decimal (json type: number)--><xsl:if test="f:upperLimit">
         <xsl:if test="f:upperLimit/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="upperLimit">
               <xsl:value-of select="f:upperLimit/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:upperLimit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_upperLimit">
               <xsl:apply-templates select="f:upperLimit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--dimensions 1..1 positiveInt (json type: number)--><xsl:if test="f:dimensions">
         <xsl:if test="f:dimensions/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="dimensions">
               <xsl:value-of select="f:dimensions/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:dimensions[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dimensions">
               <xsl:apply-templates select="f:dimensions" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--data 1..1 SampledDataDataType (json type: string)--><xsl:if test="f:data">
         <xsl:if test="f:data/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="data">
               <xsl:value-of select="f:data/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:data[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_data">
               <xsl:apply-templates select="f:data" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc/>
   </xd:doc>
   <xsl:template match="*" mode="SampledDataDataType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A relationship of two Quantity values - expressed as a numerator and a denominator.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Ratio">
      <xsl:apply-templates select="." mode="Element"/>
          <!--numerator 0..1 Quantity--><xsl:if test="f:numerator">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="numerator">
            <xsl:apply-templates select="f:numerator" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--denominator 0..1 Quantity--><xsl:if test="f:denominator">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="denominator">
            <xsl:apply-templates select="f:denominator" mode="Quantity"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A length - a value with a unit that is a physical distance.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Distance">
      <xsl:apply-templates select="." mode="Quantity"/>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A duration of time during which an organism (or a process) has existed.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Age">
      <xsl:apply-templates select="." mode="Quantity"/>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A concept that may be defined by a formal reference to a terminology or ontology or may be provided by text.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeableConcept">
      <xsl:apply-templates select="." mode="Element"/>
          <!--coding 0..* Coding--><xsl:if test="f:coding">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="coding">
            <xsl:for-each select="f:coding">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The metadata about a resource. This is content in the resource that is maintained by the infrastructure. Changes to the content may not always be associated with version changes to the resource.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Meta">
      <xsl:apply-templates select="." mode="Element"/>
          <!--versionId 0..1 id (json type: string)--><xsl:if test="f:versionId">
         <xsl:if test="f:versionId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="versionId">
               <xsl:value-of select="f:versionId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:versionId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_versionId">
               <xsl:apply-templates select="f:versionId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--lastUpdated 0..1 instant (json type: string)--><xsl:if test="f:lastUpdated">
         <xsl:if test="f:lastUpdated/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastUpdated">
               <xsl:value-of select="f:lastUpdated/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastUpdated[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastUpdated">
               <xsl:apply-templates select="f:lastUpdated" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--profile 0..* uri (json type: string)--><xsl:if test="f:profile">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:for-each select="f:profile">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:profile[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_profile">
               <xsl:for-each select="f:profile">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--security 0..* Coding--><xsl:if test="f:security">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="security">
            <xsl:for-each select="f:security">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--tag 0..* Coding--><xsl:if test="f:tag">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="tag">
            <xsl:for-each select="f:tag">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An address expressed using postal conventions (as opposed to GPS or other location definition formats).  This data type may be used to convey addresses for use in delivering mail as well as for visiting locations which might not be valid for mail delivery.  There are a variety of postal address formats defined around the world.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Address">
      <xsl:apply-templates select="." mode="Element"/>
          <!--use 0..1 AddressUse (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 AddressType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--line 0..* string (json type: string)--><xsl:if test="f:line">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="line">
            <xsl:for-each select="f:line">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:line[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_line">
               <xsl:for-each select="f:line">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--city 0..1 string (json type: string)--><xsl:if test="f:city">
         <xsl:if test="f:city/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="city">
               <xsl:value-of select="f:city/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:city[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_city">
               <xsl:apply-templates select="f:city" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--district 0..1 string (json type: string)--><xsl:if test="f:district">
         <xsl:if test="f:district/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="district">
               <xsl:value-of select="f:district/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:district[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_district">
               <xsl:apply-templates select="f:district" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--state 0..1 string (json type: string)--><xsl:if test="f:state">
         <xsl:if test="f:state/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="state">
               <xsl:value-of select="f:state/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:state[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_state">
               <xsl:apply-templates select="f:state" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--postalCode 0..1 string (json type: string)--><xsl:if test="f:postalCode">
         <xsl:if test="f:postalCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="postalCode">
               <xsl:value-of select="f:postalCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:postalCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_postalCode">
               <xsl:apply-templates select="f:postalCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--country 0..1 string (json type: string)--><xsl:if test="f:country">
         <xsl:if test="f:country/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="country">
               <xsl:value-of select="f:country/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:country[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_country">
               <xsl:apply-templates select="f:country" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The use of an address</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AddressUse">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of an address (physical / postal)</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AddressType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A description of a triggering event.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="TriggerDefinition">
      <xsl:apply-templates select="." mode="Element"/>
          <!--type 1..1 TriggerType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--eventName 0..1 string (json type: string)--><xsl:if test="f:eventName">
         <xsl:if test="f:eventName/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="eventName">
               <xsl:value-of select="f:eventName/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:eventName[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_eventName">
               <xsl:apply-templates select="f:eventName" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
           <!--eventTimingTiming 1..1 Timing--><xsl:if test="f:eventTimingTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="eventTimingTiming">
            <xsl:apply-templates select="f:eventTimingTiming" mode="Timing"/>
         </map>
      </xsl:if>
           <!--eventTimingReference 1..1 Reference--><xsl:if test="f:eventTimingReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="eventTimingReference">
            <xsl:apply-templates select="f:eventTimingReference" mode="Reference"/>
         </map>
      </xsl:if>
           <!--eventTimingDate 1..1 date (json type: string)--><xsl:if test="f:eventTimingDate">
         <xsl:if test="f:eventTimingDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="eventTimingDate">
               <xsl:value-of select="f:eventTimingDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:eventTimingDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_eventTimingDate">
               <xsl:apply-templates select="f:eventTimingDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--eventTimingDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:eventTimingDateTime">
         <xsl:if test="f:eventTimingDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="eventTimingDateTime">
               <xsl:value-of select="f:eventTimingDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:eventTimingDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_eventTimingDateTime">
               <xsl:apply-templates select="f:eventTimingDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
          <!--eventData 0..1 DataRequirement--><xsl:if test="f:eventData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="eventData">
            <xsl:apply-templates select="f:eventData" mode="DataRequirement"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of trigger</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="TriggerType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A contributor to the content of a knowledge asset, including authors, editors, reviewers, and endorsers.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contributor">
      <xsl:apply-templates select="." mode="Element"/>
          <!--type 1..1 ContributorType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--contact 0..* ContactDetail--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of contributor</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContributorType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a required data item for evaluation in terms of the type of data, and optional code or date-based filters of the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataRequirement">
      <xsl:apply-templates select="." mode="Element"/>
          <!--type 1..1 code (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--profile 0..* uri (json type: string)--><xsl:if test="f:profile">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:for-each select="f:profile">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:profile[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_profile">
               <xsl:for-each select="f:profile">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--mustSupport 0..* string (json type: string)--><xsl:if test="f:mustSupport">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mustSupport">
            <xsl:for-each select="f:mustSupport">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:mustSupport[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_mustSupport">
               <xsl:for-each select="f:mustSupport">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--codeFilter 0..* DataRequirement.CodeFilter--><xsl:if test="f:codeFilter">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="codeFilter">
            <xsl:for-each select="f:codeFilter">
               <map>
                  <xsl:apply-templates select="." mode="DataRequirement.CodeFilter"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--dateFilter 0..* DataRequirement.DateFilter--><xsl:if test="f:dateFilter">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dateFilter">
            <xsl:for-each select="f:dateFilter">
               <map>
                  <xsl:apply-templates select="." mode="DataRequirement.DateFilter"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a required data item for evaluation in terms of the type of data, and optional code or date-based filters of the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataRequirement.CodeFilter">
      <xsl:apply-templates select="." mode="Element"/>
          <!--path 1..1 string (json type: string)--><xsl:if test="f:path">
         <xsl:if test="f:path/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="path">
               <xsl:value-of select="f:path/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:path[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_path">
               <xsl:apply-templates select="f:path" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
           <!--valueSetString 1..1 string (json type: string)--><xsl:if test="f:valueSetString">
         <xsl:if test="f:valueSetString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetString">
               <xsl:value-of select="f:valueSetString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueSetString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueSetString">
               <xsl:apply-templates select="f:valueSetString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueSetReference 1..1 Reference--><xsl:if test="f:valueSetReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetReference">
            <xsl:apply-templates select="f:valueSetReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--valueCode 0..* code (json type: string)--><xsl:if test="f:valueCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode">
            <xsl:for-each select="f:valueCode">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:valueCode[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_valueCode">
               <xsl:for-each select="f:valueCode">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--valueCoding 0..* Coding--><xsl:if test="f:valueCoding">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="valueCoding">
            <xsl:for-each select="f:valueCoding">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--valueCodeableConcept 0..* CodeableConcept--><xsl:if test="f:valueCodeableConcept">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="valueCodeableConcept">
            <xsl:for-each select="f:valueCodeableConcept">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a required data item for evaluation in terms of the type of data, and optional code or date-based filters of the data.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataRequirement.DateFilter">
      <xsl:apply-templates select="." mode="Element"/>
          <!--path 1..1 string (json type: string)--><xsl:if test="f:path">
         <xsl:if test="f:path/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="path">
               <xsl:value-of select="f:path/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:path[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_path">
               <xsl:apply-templates select="f:path" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
           <!--valueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:valueDateTime">
         <xsl:if test="f:valueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime">
               <xsl:value-of select="f:valueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDateTime">
               <xsl:apply-templates select="f:valueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valuePeriod 1..1 Period--><xsl:if test="f:valuePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valuePeriod">
            <xsl:apply-templates select="f:valuePeriod" mode="Period"/>
         </map>
      </xsl:if>
           <!--valueDuration 1..1 Duration--><xsl:if test="f:valueDuration">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueDuration">
            <xsl:apply-templates select="f:valueDuration" mode="Duration"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates how the medication is/was taken or should be taken by the patient.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Dosage">
      <xsl:apply-templates select="." mode="Element"/>
          <!--sequence 0..1 integer (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--additionalInstruction 0..* CodeableConcept--><xsl:if test="f:additionalInstruction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="additionalInstruction">
            <xsl:for-each select="f:additionalInstruction">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--patientInstruction 0..1 string (json type: string)--><xsl:if test="f:patientInstruction">
         <xsl:if test="f:patientInstruction/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patientInstruction">
               <xsl:value-of select="f:patientInstruction/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patientInstruction[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patientInstruction">
               <xsl:apply-templates select="f:patientInstruction" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--timing 0..1 Timing--><xsl:if test="f:timing">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timing">
            <xsl:apply-templates select="f:timing" mode="Timing"/>
         </map>
      </xsl:if>
          
            
           <!--asNeededBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:asNeededBoolean">
         <xsl:if test="f:asNeededBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="asNeededBoolean">
               <xsl:value-of select="f:asNeededBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:asNeededBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_asNeededBoolean">
               <xsl:apply-templates select="f:asNeededBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--asNeededCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:asNeededCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="asNeededCodeableConcept">
            <xsl:apply-templates select="f:asNeededCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          
          <!--site 0..1 CodeableConcept--><xsl:if test="f:site">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="site">
            <xsl:apply-templates select="f:site" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--route 0..1 CodeableConcept--><xsl:if test="f:route">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="route">
            <xsl:apply-templates select="f:route" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--method 0..1 CodeableConcept--><xsl:if test="f:method">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="method">
            <xsl:apply-templates select="f:method" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          
            
           <!--doseRange 1..1 Range--><xsl:if test="f:doseRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseRange">
            <xsl:apply-templates select="f:doseRange" mode="Range"/>
         </map>
      </xsl:if>
           <!--doseQuantity 1..1 Quantity--><xsl:if test="f:doseQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="doseQuantity">
            <xsl:apply-templates select="f:doseQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
          
          <!--maxDosePerPeriod 0..1 Ratio--><xsl:if test="f:maxDosePerPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxDosePerPeriod">
            <xsl:apply-templates select="f:maxDosePerPeriod" mode="Ratio"/>
         </map>
      </xsl:if>
          <!--maxDosePerAdministration 0..1 Quantity--><xsl:if test="f:maxDosePerAdministration">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="maxDosePerAdministration">
            <xsl:apply-templates select="f:maxDosePerAdministration" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--maxDosePerLifetime 0..1 Quantity--><xsl:if test="f:maxDosePerLifetime">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxDosePerLifetime">
            <xsl:apply-templates select="f:maxDosePerLifetime" mode="Quantity"/>
         </map>
      </xsl:if>
          
            
           <!--rateRatio 1..1 Ratio--><xsl:if test="f:rateRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateRatio">
            <xsl:apply-templates select="f:rateRatio" mode="Ratio"/>
         </map>
      </xsl:if>
           <!--rateRange 1..1 Range--><xsl:if test="f:rateRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateRange">
            <xsl:apply-templates select="f:rateRange" mode="Range"/>
         </map>
      </xsl:if>
           <!--rateQuantity 1..1 Quantity--><xsl:if test="f:rateQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="rateQuantity">
            <xsl:apply-templates select="f:rateQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Related artifacts such as additional documentation, justification, or bibliographic references.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="RelatedArtifact">
      <xsl:apply-templates select="." mode="Element"/>
          <!--type 1..1 RelatedArtifactType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--citation 0..1 string (json type: string)--><xsl:if test="f:citation">
         <xsl:if test="f:citation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="citation">
               <xsl:value-of select="f:citation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:citation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_citation">
               <xsl:apply-templates select="f:citation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--document 0..1 Attachment--><xsl:if test="f:document">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="document">
            <xsl:apply-templates select="f:document" mode="Attachment"/>
         </map>
      </xsl:if>
          <!--resource 0..1 Reference--><xsl:if test="f:resource">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="resource">
            <xsl:apply-templates select="f:resource" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of relationship to the related artifact</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="RelatedArtifactType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies contact information for a person or organization.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContactDetail">
      <xsl:apply-templates select="." mode="Element"/>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--telecom 0..* ContactPoint--><xsl:if test="f:telecom">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="telecom">
            <xsl:for-each select="f:telecom">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A human's name with the ability to identify parts and usage.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="HumanName">
      <xsl:apply-templates select="." mode="Element"/>
          <!--use 0..1 NameUse (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--family 0..1 string (json type: string)--><xsl:if test="f:family">
         <xsl:if test="f:family/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="family">
               <xsl:value-of select="f:family/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:family[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_family">
               <xsl:apply-templates select="f:family" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--given 0..* string (json type: string)--><xsl:if test="f:given">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="given">
            <xsl:for-each select="f:given">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:given[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_given">
               <xsl:for-each select="f:given">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--prefix 0..* string (json type: string)--><xsl:if test="f:prefix">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="prefix">
            <xsl:for-each select="f:prefix">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:prefix[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_prefix">
               <xsl:for-each select="f:prefix">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--suffix 0..* string (json type: string)--><xsl:if test="f:suffix">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="suffix">
            <xsl:for-each select="f:suffix">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:suffix[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_suffix">
               <xsl:for-each select="f:suffix">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The use of a human name</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="NameUse">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Details for all kinds of technology mediated contact points for a person or organization, including telephone, email, etc.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContactPoint">
      <xsl:apply-templates select="." mode="Element"/>
          <!--system 0..1 ContactPointSystem (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--value 0..1 string (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--use 0..1 ContactPointUse (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--rank 0..1 positiveInt (json type: number)--><xsl:if test="f:rank">
         <xsl:if test="f:rank/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="rank">
               <xsl:value-of select="f:rank/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:rank[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_rank">
               <xsl:apply-templates select="f:rank" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Telecommunications form for contact point</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContactPointSystem">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Use of contact point</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContactPointUse">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies clinical/business/etc metadata that can be used to retrieve, index and/or categorize an artifact. This metadata can either be specific to the applicable population (e.g., age category, DRG) or the specific context of care (e.g., venue, care setting, provider of care).</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="UsageContext">
      <xsl:apply-templates select="." mode="Element"/>
          <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
          
            
           <!--valueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:valueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCodeableConcept">
            <xsl:apply-templates select="f:valueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
           <!--valueQuantity 1..1 Quantity--><xsl:if test="f:valueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueQuantity">
            <xsl:apply-templates select="f:valueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
           <!--valueRange 1..1 Range--><xsl:if test="f:valueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueRange">
            <xsl:apply-templates select="f:valueRange" mode="Range"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies an event that may occur multiple times. Timing schedules are used to record when things are planned, expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds, and may be used for reporting the schedule to which past regular activities were carried out.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Timing">
      <xsl:apply-templates select="." mode="Element"/>
          <!--event 0..* dateTime (json type: string)--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:event[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_event">
               <xsl:for-each select="f:event">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--repeat 0..1 Timing.Repeat--><xsl:if test="f:repeat">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="repeat">
            <xsl:apply-templates select="f:repeat" mode="Timing.Repeat"/>
         </map>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Specifies an event that may occur multiple times. Timing schedules are used to record when things are planned, expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds, and may be used for reporting the schedule to which past regular activities were carried out.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Timing.Repeat">
      <xsl:apply-templates select="." mode="Element"/>
          
            
           <!--boundsDuration 1..1 Duration--><xsl:if test="f:boundsDuration">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="boundsDuration">
            <xsl:apply-templates select="f:boundsDuration" mode="Duration"/>
         </map>
      </xsl:if>
           <!--boundsRange 1..1 Range--><xsl:if test="f:boundsRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="boundsRange">
            <xsl:apply-templates select="f:boundsRange" mode="Range"/>
         </map>
      </xsl:if>
           <!--boundsPeriod 1..1 Period--><xsl:if test="f:boundsPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="boundsPeriod">
            <xsl:apply-templates select="f:boundsPeriod" mode="Period"/>
         </map>
      </xsl:if>
          
          <!--count 0..1 integer (json type: number)--><xsl:if test="f:count">
         <xsl:if test="f:count/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="count">
               <xsl:value-of select="f:count/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:count[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_count">
               <xsl:apply-templates select="f:count" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--countMax 0..1 integer (json type: number)--><xsl:if test="f:countMax">
         <xsl:if test="f:countMax/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="countMax">
               <xsl:value-of select="f:countMax/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:countMax[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_countMax">
               <xsl:apply-templates select="f:countMax" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--duration 0..1 decimal (json type: number)--><xsl:if test="f:duration">
         <xsl:if test="f:duration/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="duration">
               <xsl:value-of select="f:duration/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:duration[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_duration">
               <xsl:apply-templates select="f:duration" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--durationMax 0..1 decimal (json type: number)--><xsl:if test="f:durationMax">
         <xsl:if test="f:durationMax/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="durationMax">
               <xsl:value-of select="f:durationMax/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:durationMax[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_durationMax">
               <xsl:apply-templates select="f:durationMax" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--durationUnit 0..1 UnitsOfTime (json type: string)--><xsl:if test="f:durationUnit">
         <xsl:if test="f:durationUnit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="durationUnit">
               <xsl:value-of select="f:durationUnit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:durationUnit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_durationUnit">
               <xsl:apply-templates select="f:durationUnit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--frequency 0..1 integer (json type: number)--><xsl:if test="f:frequency">
         <xsl:if test="f:frequency/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="frequency">
               <xsl:value-of select="f:frequency/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:frequency[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_frequency">
               <xsl:apply-templates select="f:frequency" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--frequencyMax 0..1 integer (json type: number)--><xsl:if test="f:frequencyMax">
         <xsl:if test="f:frequencyMax/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="frequencyMax">
               <xsl:value-of select="f:frequencyMax/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:frequencyMax[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_frequencyMax">
               <xsl:apply-templates select="f:frequencyMax" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 0..1 decimal (json type: number)--><xsl:if test="f:period">
         <xsl:if test="f:period/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="period">
               <xsl:value-of select="f:period/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:period[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_period">
               <xsl:apply-templates select="f:period" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--periodMax 0..1 decimal (json type: number)--><xsl:if test="f:periodMax">
         <xsl:if test="f:periodMax/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="periodMax">
               <xsl:value-of select="f:periodMax/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:periodMax[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_periodMax">
               <xsl:apply-templates select="f:periodMax" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--periodUnit 0..1 UnitsOfTime (json type: string)--><xsl:if test="f:periodUnit">
         <xsl:if test="f:periodUnit/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="periodUnit">
               <xsl:value-of select="f:periodUnit/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:periodUnit[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_periodUnit">
               <xsl:apply-templates select="f:periodUnit" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--dayOfWeek 0..* code (json type: string)--><xsl:if test="f:dayOfWeek">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dayOfWeek">
            <xsl:for-each select="f:dayOfWeek">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:dayOfWeek[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_dayOfWeek">
               <xsl:for-each select="f:dayOfWeek">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--timeOfDay 0..* time (json type: string)--><xsl:if test="f:timeOfDay">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="timeOfDay">
            <xsl:for-each select="f:timeOfDay">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:timeOfDay[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_timeOfDay">
               <xsl:for-each select="f:timeOfDay">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--when 0..* EventTiming (json type: string)--><xsl:if test="f:when">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="when">
            <xsl:for-each select="f:when">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:when[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_when">
               <xsl:for-each select="f:when">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--offset 0..1 unsignedInt (json type: number)--><xsl:if test="f:offset">
         <xsl:if test="f:offset/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="offset">
               <xsl:value-of select="f:offset/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:offset[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_offset">
               <xsl:apply-templates select="f:offset" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A unit of time (units from UCUM).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="UnitsOfTime">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Real world event relating to the schedule.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EventTiming">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition">
      <xsl:apply-templates select="." mode="Element"/>
          <!--path 1..1 string (json type: string)--><xsl:if test="f:path">
         <xsl:if test="f:path/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="path">
               <xsl:value-of select="f:path/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:path[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_path">
               <xsl:apply-templates select="f:path" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--representation 0..* PropertyRepresentation (json type: string)--><xsl:if test="f:representation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="representation">
            <xsl:for-each select="f:representation">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:representation[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_representation">
               <xsl:for-each select="f:representation">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--sliceName 0..1 string (json type: string)--><xsl:if test="f:sliceName">
         <xsl:if test="f:sliceName/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sliceName">
               <xsl:value-of select="f:sliceName/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sliceName[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sliceName">
               <xsl:apply-templates select="f:sliceName" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--label 0..1 string (json type: string)--><xsl:if test="f:label">
         <xsl:if test="f:label/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="label">
               <xsl:value-of select="f:label/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:label[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_label">
               <xsl:apply-templates select="f:label" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..* Coding--><xsl:if test="f:code">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:for-each select="f:code">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--slicing 0..1 ElementDefinition.Slicing--><xsl:if test="f:slicing">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="slicing">
            <xsl:apply-templates select="f:slicing" mode="ElementDefinition.Slicing"/>
         </map>
      </xsl:if>
          <!--short 0..1 string (json type: string)--><xsl:if test="f:short">
         <xsl:if test="f:short/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="short">
               <xsl:value-of select="f:short/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:short[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_short">
               <xsl:apply-templates select="f:short" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--definition 0..1 markdown (json type: string)--><xsl:if test="f:definition">
         <xsl:if test="f:definition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
               <xsl:value-of select="f:definition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:definition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_definition">
               <xsl:apply-templates select="f:definition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--comment 0..1 markdown (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--requirements 0..1 markdown (json type: string)--><xsl:if test="f:requirements">
         <xsl:if test="f:requirements/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements">
               <xsl:value-of select="f:requirements/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:requirements[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requirements">
               <xsl:apply-templates select="f:requirements" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--alias 0..* string (json type: string)--><xsl:if test="f:alias">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="alias">
            <xsl:for-each select="f:alias">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:alias[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_alias">
               <xsl:for-each select="f:alias">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--min 0..1 unsignedInt (json type: number)--><xsl:if test="f:min">
         <xsl:if test="f:min/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="min">
               <xsl:value-of select="f:min/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:min[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_min">
               <xsl:apply-templates select="f:min" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--max 0..1 string (json type: string)--><xsl:if test="f:max">
         <xsl:if test="f:max/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="max">
               <xsl:value-of select="f:max/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:max[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_max">
               <xsl:apply-templates select="f:max" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--base 0..1 ElementDefinition.Base--><xsl:if test="f:base">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="base">
            <xsl:apply-templates select="f:base" mode="ElementDefinition.Base"/>
         </map>
      </xsl:if>
          <!--contentReference 0..1 uri (json type: string)--><xsl:if test="f:contentReference">
         <xsl:if test="f:contentReference/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
               <xsl:value-of select="f:contentReference/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentReference[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentReference">
               <xsl:apply-templates select="f:contentReference" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..* ElementDefinition.Type--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition.Type"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        
           
           <!--defaultValueBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:defaultValueBase64Binary">
         <xsl:if test="f:defaultValueBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions"
                    key="defaultValueBase64Binary">
               <xsl:value-of select="f:defaultValueBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_defaultValueBase64Binary">
               <xsl:apply-templates select="f:defaultValueBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:defaultValueBoolean">
         <xsl:if test="f:defaultValueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueBoolean">
               <xsl:value-of select="f:defaultValueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:defaultValueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueBoolean">
               <xsl:apply-templates select="f:defaultValueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueCode 1..1 code (json type: string)--><xsl:if test="f:defaultValueCode">
         <xsl:if test="f:defaultValueCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueCode">
               <xsl:value-of select="f:defaultValueCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueCode">
               <xsl:apply-templates select="f:defaultValueCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueDate 1..1 date (json type: string)--><xsl:if test="f:defaultValueDate">
         <xsl:if test="f:defaultValueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDate">
               <xsl:value-of select="f:defaultValueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueDate">
               <xsl:apply-templates select="f:defaultValueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:defaultValueDateTime">
         <xsl:if test="f:defaultValueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDateTime">
               <xsl:value-of select="f:defaultValueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueDateTime">
               <xsl:apply-templates select="f:defaultValueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:defaultValueDecimal">
         <xsl:if test="f:defaultValueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDecimal">
               <xsl:value-of select="f:defaultValueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:defaultValueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueDecimal">
               <xsl:apply-templates select="f:defaultValueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueId 1..1 id (json type: string)--><xsl:if test="f:defaultValueId">
         <xsl:if test="f:defaultValueId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueId">
               <xsl:value-of select="f:defaultValueId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueId">
               <xsl:apply-templates select="f:defaultValueId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueInstant 1..1 instant (json type: string)--><xsl:if test="f:defaultValueInstant">
         <xsl:if test="f:defaultValueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueInstant">
               <xsl:value-of select="f:defaultValueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueInstant">
               <xsl:apply-templates select="f:defaultValueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueInteger 1..1 integer (json type: number)--><xsl:if test="f:defaultValueInteger">
         <xsl:if test="f:defaultValueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueInteger">
               <xsl:value-of select="f:defaultValueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:defaultValueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueInteger">
               <xsl:apply-templates select="f:defaultValueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:defaultValueMarkdown">
         <xsl:if test="f:defaultValueMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueMarkdown">
               <xsl:value-of select="f:defaultValueMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueMarkdown">
               <xsl:apply-templates select="f:defaultValueMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueOid 1..1 oid (json type: string)--><xsl:if test="f:defaultValueOid">
         <xsl:if test="f:defaultValueOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueOid">
               <xsl:value-of select="f:defaultValueOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueOid">
               <xsl:apply-templates select="f:defaultValueOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:defaultValuePositiveInt">
         <xsl:if test="f:defaultValuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions"
                    key="defaultValuePositiveInt">
               <xsl:value-of select="f:defaultValuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:defaultValuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_defaultValuePositiveInt">
               <xsl:apply-templates select="f:defaultValuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueString 1..1 string (json type: string)--><xsl:if test="f:defaultValueString">
         <xsl:if test="f:defaultValueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueString">
               <xsl:value-of select="f:defaultValueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueString">
               <xsl:apply-templates select="f:defaultValueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueTime 1..1 time (json type: string)--><xsl:if test="f:defaultValueTime">
         <xsl:if test="f:defaultValueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueTime">
               <xsl:value-of select="f:defaultValueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueTime">
               <xsl:apply-templates select="f:defaultValueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:defaultValueUnsignedInt">
         <xsl:if test="f:defaultValueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions"
                    key="defaultValueUnsignedInt">
               <xsl:value-of select="f:defaultValueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:defaultValueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_defaultValueUnsignedInt">
               <xsl:apply-templates select="f:defaultValueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueUri 1..1 uri (json type: string)--><xsl:if test="f:defaultValueUri">
         <xsl:if test="f:defaultValueUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueUri">
               <xsl:value-of select="f:defaultValueUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:defaultValueUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_defaultValueUri">
               <xsl:apply-templates select="f:defaultValueUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--defaultValueAddress 1..1 Address--><xsl:if test="f:defaultValueAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueAddress">
            <xsl:apply-templates select="f:defaultValueAddress" mode="Address"/>
         </map>
      </xsl:if>
           <!--defaultValueAge 1..1 Age--><xsl:if test="f:defaultValueAge">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueAge">
            <xsl:apply-templates select="f:defaultValueAge" mode="Age"/>
         </map>
      </xsl:if>
           <!--defaultValueAnnotation 1..1 Annotation--><xsl:if test="f:defaultValueAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueAnnotation">
            <xsl:apply-templates select="f:defaultValueAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
           <!--defaultValueAttachment 1..1 Attachment--><xsl:if test="f:defaultValueAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueAttachment">
            <xsl:apply-templates select="f:defaultValueAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
           <!--defaultValueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:defaultValueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="defaultValueCodeableConcept">
            <xsl:apply-templates select="f:defaultValueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
           <!--defaultValueCoding 1..1 Coding--><xsl:if test="f:defaultValueCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueCoding">
            <xsl:apply-templates select="f:defaultValueCoding" mode="Coding"/>
         </map>
      </xsl:if>
           <!--defaultValueContactPoint 1..1 ContactPoint--><xsl:if test="f:defaultValueContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="defaultValueContactPoint">
            <xsl:apply-templates select="f:defaultValueContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
           <!--defaultValueCount 1..1 Count--><xsl:if test="f:defaultValueCount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueCount">
            <xsl:apply-templates select="f:defaultValueCount" mode="Count"/>
         </map>
      </xsl:if>
           <!--defaultValueDistance 1..1 Distance--><xsl:if test="f:defaultValueDistance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDistance">
            <xsl:apply-templates select="f:defaultValueDistance" mode="Distance"/>
         </map>
      </xsl:if>
           <!--defaultValueDuration 1..1 Duration--><xsl:if test="f:defaultValueDuration">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueDuration">
            <xsl:apply-templates select="f:defaultValueDuration" mode="Duration"/>
         </map>
      </xsl:if>
           <!--defaultValueHumanName 1..1 HumanName--><xsl:if test="f:defaultValueHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueHumanName">
            <xsl:apply-templates select="f:defaultValueHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
           <!--defaultValueIdentifier 1..1 Identifier--><xsl:if test="f:defaultValueIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueIdentifier">
            <xsl:apply-templates select="f:defaultValueIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
           <!--defaultValueMoney 1..1 Money--><xsl:if test="f:defaultValueMoney">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueMoney">
            <xsl:apply-templates select="f:defaultValueMoney" mode="Money"/>
         </map>
      </xsl:if>
           <!--defaultValuePeriod 1..1 Period--><xsl:if test="f:defaultValuePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValuePeriod">
            <xsl:apply-templates select="f:defaultValuePeriod" mode="Period"/>
         </map>
      </xsl:if>
           <!--defaultValueQuantity 1..1 Quantity--><xsl:if test="f:defaultValueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueQuantity">
            <xsl:apply-templates select="f:defaultValueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
           <!--defaultValueRange 1..1 Range--><xsl:if test="f:defaultValueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueRange">
            <xsl:apply-templates select="f:defaultValueRange" mode="Range"/>
         </map>
      </xsl:if>
           <!--defaultValueRatio 1..1 Ratio--><xsl:if test="f:defaultValueRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueRatio">
            <xsl:apply-templates select="f:defaultValueRatio" mode="Ratio"/>
         </map>
      </xsl:if>
           <!--defaultValueReference 1..1 Reference--><xsl:if test="f:defaultValueReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueReference">
            <xsl:apply-templates select="f:defaultValueReference" mode="Reference"/>
         </map>
      </xsl:if>
           <!--defaultValueSampledData 1..1 SampledData--><xsl:if test="f:defaultValueSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="defaultValueSampledData">
            <xsl:apply-templates select="f:defaultValueSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
           <!--defaultValueSignature 1..1 Signature--><xsl:if test="f:defaultValueSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueSignature">
            <xsl:apply-templates select="f:defaultValueSignature" mode="Signature"/>
         </map>
      </xsl:if>
           <!--defaultValueTiming 1..1 Timing--><xsl:if test="f:defaultValueTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueTiming">
            <xsl:apply-templates select="f:defaultValueTiming" mode="Timing"/>
         </map>
      </xsl:if>
           <!--defaultValueMeta 1..1 Meta--><xsl:if test="f:defaultValueMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="defaultValueMeta">
            <xsl:apply-templates select="f:defaultValueMeta" mode="Meta"/>
         </map>
      </xsl:if>
         
          <!--meaningWhenMissing 0..1 markdown (json type: string)--><xsl:if test="f:meaningWhenMissing">
         <xsl:if test="f:meaningWhenMissing/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="meaningWhenMissing">
               <xsl:value-of select="f:meaningWhenMissing/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:meaningWhenMissing[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_meaningWhenMissing">
               <xsl:apply-templates select="f:meaningWhenMissing" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--orderMeaning 0..1 string (json type: string)--><xsl:if test="f:orderMeaning">
         <xsl:if test="f:orderMeaning/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="orderMeaning">
               <xsl:value-of select="f:orderMeaning/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:orderMeaning[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_orderMeaning">
               <xsl:apply-templates select="f:orderMeaning" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        
           
           <!--fixedBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:fixedBase64Binary">
         <xsl:if test="f:fixedBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedBase64Binary">
               <xsl:value-of select="f:fixedBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedBase64Binary">
               <xsl:apply-templates select="f:fixedBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:fixedBoolean">
         <xsl:if test="f:fixedBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="fixedBoolean">
               <xsl:value-of select="f:fixedBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:fixedBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedBoolean">
               <xsl:apply-templates select="f:fixedBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedCode 1..1 code (json type: string)--><xsl:if test="f:fixedCode">
         <xsl:if test="f:fixedCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCode">
               <xsl:value-of select="f:fixedCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedCode">
               <xsl:apply-templates select="f:fixedCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedDate 1..1 date (json type: string)--><xsl:if test="f:fixedDate">
         <xsl:if test="f:fixedDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDate">
               <xsl:value-of select="f:fixedDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedDate">
               <xsl:apply-templates select="f:fixedDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:fixedDateTime">
         <xsl:if test="f:fixedDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDateTime">
               <xsl:value-of select="f:fixedDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedDateTime">
               <xsl:apply-templates select="f:fixedDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedDecimal 1..1 decimal (json type: number)--><xsl:if test="f:fixedDecimal">
         <xsl:if test="f:fixedDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDecimal">
               <xsl:value-of select="f:fixedDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:fixedDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedDecimal">
               <xsl:apply-templates select="f:fixedDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedId 1..1 id (json type: string)--><xsl:if test="f:fixedId">
         <xsl:if test="f:fixedId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedId">
               <xsl:value-of select="f:fixedId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedId">
               <xsl:apply-templates select="f:fixedId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedInstant 1..1 instant (json type: string)--><xsl:if test="f:fixedInstant">
         <xsl:if test="f:fixedInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedInstant">
               <xsl:value-of select="f:fixedInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedInstant">
               <xsl:apply-templates select="f:fixedInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedInteger 1..1 integer (json type: number)--><xsl:if test="f:fixedInteger">
         <xsl:if test="f:fixedInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="fixedInteger">
               <xsl:value-of select="f:fixedInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:fixedInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedInteger">
               <xsl:apply-templates select="f:fixedInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:fixedMarkdown">
         <xsl:if test="f:fixedMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedMarkdown">
               <xsl:value-of select="f:fixedMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedMarkdown">
               <xsl:apply-templates select="f:fixedMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedOid 1..1 oid (json type: string)--><xsl:if test="f:fixedOid">
         <xsl:if test="f:fixedOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedOid">
               <xsl:value-of select="f:fixedOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedOid">
               <xsl:apply-templates select="f:fixedOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedPositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:fixedPositiveInt">
         <xsl:if test="f:fixedPositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="fixedPositiveInt">
               <xsl:value-of select="f:fixedPositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:fixedPositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedPositiveInt">
               <xsl:apply-templates select="f:fixedPositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedString 1..1 string (json type: string)--><xsl:if test="f:fixedString">
         <xsl:if test="f:fixedString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedString">
               <xsl:value-of select="f:fixedString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedString">
               <xsl:apply-templates select="f:fixedString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedTime 1..1 time (json type: string)--><xsl:if test="f:fixedTime">
         <xsl:if test="f:fixedTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedTime">
               <xsl:value-of select="f:fixedTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedTime">
               <xsl:apply-templates select="f:fixedTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:fixedUnsignedInt">
         <xsl:if test="f:fixedUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUnsignedInt">
               <xsl:value-of select="f:fixedUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:fixedUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedUnsignedInt">
               <xsl:apply-templates select="f:fixedUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedUri 1..1 uri (json type: string)--><xsl:if test="f:fixedUri">
         <xsl:if test="f:fixedUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fixedUri">
               <xsl:value-of select="f:fixedUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fixedUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fixedUri">
               <xsl:apply-templates select="f:fixedUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--fixedAddress 1..1 Address--><xsl:if test="f:fixedAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedAddress">
            <xsl:apply-templates select="f:fixedAddress" mode="Address"/>
         </map>
      </xsl:if>
           <!--fixedAge 1..1 Age--><xsl:if test="f:fixedAge">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedAge">
            <xsl:apply-templates select="f:fixedAge" mode="Age"/>
         </map>
      </xsl:if>
           <!--fixedAnnotation 1..1 Annotation--><xsl:if test="f:fixedAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedAnnotation">
            <xsl:apply-templates select="f:fixedAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
           <!--fixedAttachment 1..1 Attachment--><xsl:if test="f:fixedAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedAttachment">
            <xsl:apply-templates select="f:fixedAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
           <!--fixedCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:fixedCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCodeableConcept">
            <xsl:apply-templates select="f:fixedCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
           <!--fixedCoding 1..1 Coding--><xsl:if test="f:fixedCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCoding">
            <xsl:apply-templates select="f:fixedCoding" mode="Coding"/>
         </map>
      </xsl:if>
           <!--fixedContactPoint 1..1 ContactPoint--><xsl:if test="f:fixedContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedContactPoint">
            <xsl:apply-templates select="f:fixedContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
           <!--fixedCount 1..1 Count--><xsl:if test="f:fixedCount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedCount">
            <xsl:apply-templates select="f:fixedCount" mode="Count"/>
         </map>
      </xsl:if>
           <!--fixedDistance 1..1 Distance--><xsl:if test="f:fixedDistance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDistance">
            <xsl:apply-templates select="f:fixedDistance" mode="Distance"/>
         </map>
      </xsl:if>
           <!--fixedDuration 1..1 Duration--><xsl:if test="f:fixedDuration">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedDuration">
            <xsl:apply-templates select="f:fixedDuration" mode="Duration"/>
         </map>
      </xsl:if>
           <!--fixedHumanName 1..1 HumanName--><xsl:if test="f:fixedHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedHumanName">
            <xsl:apply-templates select="f:fixedHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
           <!--fixedIdentifier 1..1 Identifier--><xsl:if test="f:fixedIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedIdentifier">
            <xsl:apply-templates select="f:fixedIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
           <!--fixedMoney 1..1 Money--><xsl:if test="f:fixedMoney">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedMoney">
            <xsl:apply-templates select="f:fixedMoney" mode="Money"/>
         </map>
      </xsl:if>
           <!--fixedPeriod 1..1 Period--><xsl:if test="f:fixedPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedPeriod">
            <xsl:apply-templates select="f:fixedPeriod" mode="Period"/>
         </map>
      </xsl:if>
           <!--fixedQuantity 1..1 Quantity--><xsl:if test="f:fixedQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedQuantity">
            <xsl:apply-templates select="f:fixedQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
           <!--fixedRange 1..1 Range--><xsl:if test="f:fixedRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedRange">
            <xsl:apply-templates select="f:fixedRange" mode="Range"/>
         </map>
      </xsl:if>
           <!--fixedRatio 1..1 Ratio--><xsl:if test="f:fixedRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedRatio">
            <xsl:apply-templates select="f:fixedRatio" mode="Ratio"/>
         </map>
      </xsl:if>
           <!--fixedReference 1..1 Reference--><xsl:if test="f:fixedReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedReference">
            <xsl:apply-templates select="f:fixedReference" mode="Reference"/>
         </map>
      </xsl:if>
           <!--fixedSampledData 1..1 SampledData--><xsl:if test="f:fixedSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedSampledData">
            <xsl:apply-templates select="f:fixedSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
           <!--fixedSignature 1..1 Signature--><xsl:if test="f:fixedSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedSignature">
            <xsl:apply-templates select="f:fixedSignature" mode="Signature"/>
         </map>
      </xsl:if>
           <!--fixedTiming 1..1 Timing--><xsl:if test="f:fixedTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedTiming">
            <xsl:apply-templates select="f:fixedTiming" mode="Timing"/>
         </map>
      </xsl:if>
           <!--fixedMeta 1..1 Meta--><xsl:if test="f:fixedMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fixedMeta">
            <xsl:apply-templates select="f:fixedMeta" mode="Meta"/>
         </map>
      </xsl:if>
         
        
           
           <!--patternBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:patternBase64Binary">
         <xsl:if test="f:patternBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternBase64Binary">
               <xsl:value-of select="f:patternBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternBase64Binary">
               <xsl:apply-templates select="f:patternBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:patternBoolean">
         <xsl:if test="f:patternBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="patternBoolean">
               <xsl:value-of select="f:patternBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:patternBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternBoolean">
               <xsl:apply-templates select="f:patternBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternCode 1..1 code (json type: string)--><xsl:if test="f:patternCode">
         <xsl:if test="f:patternCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternCode">
               <xsl:value-of select="f:patternCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternCode">
               <xsl:apply-templates select="f:patternCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternDate 1..1 date (json type: string)--><xsl:if test="f:patternDate">
         <xsl:if test="f:patternDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDate">
               <xsl:value-of select="f:patternDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternDate">
               <xsl:apply-templates select="f:patternDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:patternDateTime">
         <xsl:if test="f:patternDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternDateTime">
               <xsl:value-of select="f:patternDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternDateTime">
               <xsl:apply-templates select="f:patternDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternDecimal 1..1 decimal (json type: number)--><xsl:if test="f:patternDecimal">
         <xsl:if test="f:patternDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="patternDecimal">
               <xsl:value-of select="f:patternDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:patternDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternDecimal">
               <xsl:apply-templates select="f:patternDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternId 1..1 id (json type: string)--><xsl:if test="f:patternId">
         <xsl:if test="f:patternId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternId">
               <xsl:value-of select="f:patternId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternId">
               <xsl:apply-templates select="f:patternId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternInstant 1..1 instant (json type: string)--><xsl:if test="f:patternInstant">
         <xsl:if test="f:patternInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternInstant">
               <xsl:value-of select="f:patternInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternInstant">
               <xsl:apply-templates select="f:patternInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternInteger 1..1 integer (json type: number)--><xsl:if test="f:patternInteger">
         <xsl:if test="f:patternInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="patternInteger">
               <xsl:value-of select="f:patternInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:patternInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternInteger">
               <xsl:apply-templates select="f:patternInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:patternMarkdown">
         <xsl:if test="f:patternMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternMarkdown">
               <xsl:value-of select="f:patternMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternMarkdown">
               <xsl:apply-templates select="f:patternMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternOid 1..1 oid (json type: string)--><xsl:if test="f:patternOid">
         <xsl:if test="f:patternOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternOid">
               <xsl:value-of select="f:patternOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternOid">
               <xsl:apply-templates select="f:patternOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternPositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:patternPositiveInt">
         <xsl:if test="f:patternPositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="patternPositiveInt">
               <xsl:value-of select="f:patternPositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:patternPositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternPositiveInt">
               <xsl:apply-templates select="f:patternPositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternString 1..1 string (json type: string)--><xsl:if test="f:patternString">
         <xsl:if test="f:patternString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternString">
               <xsl:value-of select="f:patternString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternString">
               <xsl:apply-templates select="f:patternString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternTime 1..1 time (json type: string)--><xsl:if test="f:patternTime">
         <xsl:if test="f:patternTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternTime">
               <xsl:value-of select="f:patternTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternTime">
               <xsl:apply-templates select="f:patternTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:patternUnsignedInt">
         <xsl:if test="f:patternUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="patternUnsignedInt">
               <xsl:value-of select="f:patternUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:patternUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternUnsignedInt">
               <xsl:apply-templates select="f:patternUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternUri 1..1 uri (json type: string)--><xsl:if test="f:patternUri">
         <xsl:if test="f:patternUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="patternUri">
               <xsl:value-of select="f:patternUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:patternUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_patternUri">
               <xsl:apply-templates select="f:patternUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--patternAddress 1..1 Address--><xsl:if test="f:patternAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternAddress">
            <xsl:apply-templates select="f:patternAddress" mode="Address"/>
         </map>
      </xsl:if>
           <!--patternAge 1..1 Age--><xsl:if test="f:patternAge">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternAge">
            <xsl:apply-templates select="f:patternAge" mode="Age"/>
         </map>
      </xsl:if>
           <!--patternAnnotation 1..1 Annotation--><xsl:if test="f:patternAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternAnnotation">
            <xsl:apply-templates select="f:patternAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
           <!--patternAttachment 1..1 Attachment--><xsl:if test="f:patternAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternAttachment">
            <xsl:apply-templates select="f:patternAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
           <!--patternCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:patternCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternCodeableConcept">
            <xsl:apply-templates select="f:patternCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
           <!--patternCoding 1..1 Coding--><xsl:if test="f:patternCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternCoding">
            <xsl:apply-templates select="f:patternCoding" mode="Coding"/>
         </map>
      </xsl:if>
           <!--patternContactPoint 1..1 ContactPoint--><xsl:if test="f:patternContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternContactPoint">
            <xsl:apply-templates select="f:patternContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
           <!--patternCount 1..1 Count--><xsl:if test="f:patternCount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternCount">
            <xsl:apply-templates select="f:patternCount" mode="Count"/>
         </map>
      </xsl:if>
           <!--patternDistance 1..1 Distance--><xsl:if test="f:patternDistance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternDistance">
            <xsl:apply-templates select="f:patternDistance" mode="Distance"/>
         </map>
      </xsl:if>
           <!--patternDuration 1..1 Duration--><xsl:if test="f:patternDuration">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternDuration">
            <xsl:apply-templates select="f:patternDuration" mode="Duration"/>
         </map>
      </xsl:if>
           <!--patternHumanName 1..1 HumanName--><xsl:if test="f:patternHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternHumanName">
            <xsl:apply-templates select="f:patternHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
           <!--patternIdentifier 1..1 Identifier--><xsl:if test="f:patternIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternIdentifier">
            <xsl:apply-templates select="f:patternIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
           <!--patternMoney 1..1 Money--><xsl:if test="f:patternMoney">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternMoney">
            <xsl:apply-templates select="f:patternMoney" mode="Money"/>
         </map>
      </xsl:if>
           <!--patternPeriod 1..1 Period--><xsl:if test="f:patternPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternPeriod">
            <xsl:apply-templates select="f:patternPeriod" mode="Period"/>
         </map>
      </xsl:if>
           <!--patternQuantity 1..1 Quantity--><xsl:if test="f:patternQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternQuantity">
            <xsl:apply-templates select="f:patternQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
           <!--patternRange 1..1 Range--><xsl:if test="f:patternRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternRange">
            <xsl:apply-templates select="f:patternRange" mode="Range"/>
         </map>
      </xsl:if>
           <!--patternRatio 1..1 Ratio--><xsl:if test="f:patternRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternRatio">
            <xsl:apply-templates select="f:patternRatio" mode="Ratio"/>
         </map>
      </xsl:if>
           <!--patternReference 1..1 Reference--><xsl:if test="f:patternReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternReference">
            <xsl:apply-templates select="f:patternReference" mode="Reference"/>
         </map>
      </xsl:if>
           <!--patternSampledData 1..1 SampledData--><xsl:if test="f:patternSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternSampledData">
            <xsl:apply-templates select="f:patternSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
           <!--patternSignature 1..1 Signature--><xsl:if test="f:patternSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternSignature">
            <xsl:apply-templates select="f:patternSignature" mode="Signature"/>
         </map>
      </xsl:if>
           <!--patternTiming 1..1 Timing--><xsl:if test="f:patternTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternTiming">
            <xsl:apply-templates select="f:patternTiming" mode="Timing"/>
         </map>
      </xsl:if>
           <!--patternMeta 1..1 Meta--><xsl:if test="f:patternMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patternMeta">
            <xsl:apply-templates select="f:patternMeta" mode="Meta"/>
         </map>
      </xsl:if>
         
          <!--example 0..* ElementDefinition.Example--><xsl:if test="f:example">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="example">
            <xsl:for-each select="f:example">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition.Example"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          
            
           <!--minValueDate 1..1 date (json type: string)--><xsl:if test="f:minValueDate">
         <xsl:if test="f:minValueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDate">
               <xsl:value-of select="f:minValueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueDate">
               <xsl:apply-templates select="f:minValueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--minValueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:minValueDateTime">
         <xsl:if test="f:minValueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDateTime">
               <xsl:value-of select="f:minValueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueDateTime">
               <xsl:apply-templates select="f:minValueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--minValueInstant 1..1 instant (json type: string)--><xsl:if test="f:minValueInstant">
         <xsl:if test="f:minValueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueInstant">
               <xsl:value-of select="f:minValueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueInstant">
               <xsl:apply-templates select="f:minValueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--minValueTime 1..1 time (json type: string)--><xsl:if test="f:minValueTime">
         <xsl:if test="f:minValueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="minValueTime">
               <xsl:value-of select="f:minValueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:minValueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueTime">
               <xsl:apply-templates select="f:minValueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--minValueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:minValueDecimal">
         <xsl:if test="f:minValueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minValueDecimal">
               <xsl:value-of select="f:minValueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minValueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueDecimal">
               <xsl:apply-templates select="f:minValueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--minValueInteger 1..1 integer (json type: number)--><xsl:if test="f:minValueInteger">
         <xsl:if test="f:minValueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minValueInteger">
               <xsl:value-of select="f:minValueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minValueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueInteger">
               <xsl:apply-templates select="f:minValueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--minValuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:minValuePositiveInt">
         <xsl:if test="f:minValuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minValuePositiveInt">
               <xsl:value-of select="f:minValuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minValuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValuePositiveInt">
               <xsl:apply-templates select="f:minValuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--minValueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:minValueUnsignedInt">
         <xsl:if test="f:minValueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minValueUnsignedInt">
               <xsl:value-of select="f:minValueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minValueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minValueUnsignedInt">
               <xsl:apply-templates select="f:minValueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--minValueQuantity 1..1 Quantity--><xsl:if test="f:minValueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="minValueQuantity">
            <xsl:apply-templates select="f:minValueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
          
          
            
           <!--maxValueDate 1..1 date (json type: string)--><xsl:if test="f:maxValueDate">
         <xsl:if test="f:maxValueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDate">
               <xsl:value-of select="f:maxValueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueDate">
               <xsl:apply-templates select="f:maxValueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--maxValueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:maxValueDateTime">
         <xsl:if test="f:maxValueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDateTime">
               <xsl:value-of select="f:maxValueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueDateTime">
               <xsl:apply-templates select="f:maxValueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--maxValueInstant 1..1 instant (json type: string)--><xsl:if test="f:maxValueInstant">
         <xsl:if test="f:maxValueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueInstant">
               <xsl:value-of select="f:maxValueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueInstant">
               <xsl:apply-templates select="f:maxValueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--maxValueTime 1..1 time (json type: string)--><xsl:if test="f:maxValueTime">
         <xsl:if test="f:maxValueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueTime">
               <xsl:value-of select="f:maxValueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:maxValueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueTime">
               <xsl:apply-templates select="f:maxValueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--maxValueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:maxValueDecimal">
         <xsl:if test="f:maxValueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueDecimal">
               <xsl:value-of select="f:maxValueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxValueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueDecimal">
               <xsl:apply-templates select="f:maxValueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--maxValueInteger 1..1 integer (json type: number)--><xsl:if test="f:maxValueInteger">
         <xsl:if test="f:maxValueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueInteger">
               <xsl:value-of select="f:maxValueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxValueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueInteger">
               <xsl:apply-templates select="f:maxValueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--maxValuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:maxValuePositiveInt">
         <xsl:if test="f:maxValuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxValuePositiveInt">
               <xsl:value-of select="f:maxValuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxValuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValuePositiveInt">
               <xsl:apply-templates select="f:maxValuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--maxValueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:maxValueUnsignedInt">
         <xsl:if test="f:maxValueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueUnsignedInt">
               <xsl:value-of select="f:maxValueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxValueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxValueUnsignedInt">
               <xsl:apply-templates select="f:maxValueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--maxValueQuantity 1..1 Quantity--><xsl:if test="f:maxValueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="maxValueQuantity">
            <xsl:apply-templates select="f:maxValueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
          
          <!--maxLength 0..1 integer (json type: number)--><xsl:if test="f:maxLength">
         <xsl:if test="f:maxLength/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="maxLength">
               <xsl:value-of select="f:maxLength/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:maxLength[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_maxLength">
               <xsl:apply-templates select="f:maxLength" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--condition 0..* id (json type: string)--><xsl:if test="f:condition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="condition">
            <xsl:for-each select="f:condition">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:condition[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_condition">
               <xsl:for-each select="f:condition">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--constraint 0..* ElementDefinition.Constraint--><xsl:if test="f:constraint">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="constraint">
            <xsl:for-each select="f:constraint">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition.Constraint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--mustSupport 0..1 boolean (json type: boolean)--><xsl:if test="f:mustSupport">
         <xsl:if test="f:mustSupport/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="mustSupport">
               <xsl:value-of select="f:mustSupport/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:mustSupport[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mustSupport">
               <xsl:apply-templates select="f:mustSupport" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--isModifier 0..1 boolean (json type: boolean)--><xsl:if test="f:isModifier">
         <xsl:if test="f:isModifier/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="isModifier">
               <xsl:value-of select="f:isModifier/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:isModifier[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_isModifier">
               <xsl:apply-templates select="f:isModifier" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--isSummary 0..1 boolean (json type: boolean)--><xsl:if test="f:isSummary">
         <xsl:if test="f:isSummary/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="isSummary">
               <xsl:value-of select="f:isSummary/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:isSummary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_isSummary">
               <xsl:apply-templates select="f:isSummary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--binding 0..1 ElementDefinition.Binding--><xsl:if test="f:binding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="binding">
            <xsl:apply-templates select="f:binding" mode="ElementDefinition.Binding"/>
         </map>
      </xsl:if>
          <!--mapping 0..* ElementDefinition.Mapping--><xsl:if test="f:mapping">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mapping">
            <xsl:for-each select="f:mapping">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition.Mapping"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Constraint">
      <xsl:apply-templates select="." mode="Element"/>
          <!--key 1..1 id (json type: string)--><xsl:if test="f:key">
         <xsl:if test="f:key/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="key">
               <xsl:value-of select="f:key/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:key[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_key">
               <xsl:apply-templates select="f:key" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--requirements 0..1 string (json type: string)--><xsl:if test="f:requirements">
         <xsl:if test="f:requirements/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="requirements">
               <xsl:value-of select="f:requirements/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:requirements[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requirements">
               <xsl:apply-templates select="f:requirements" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--severity 1..1 ConstraintSeverity (json type: string)--><xsl:if test="f:severity">
         <xsl:if test="f:severity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity">
               <xsl:value-of select="f:severity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:severity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_severity">
               <xsl:apply-templates select="f:severity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--human 1..1 string (json type: string)--><xsl:if test="f:human">
         <xsl:if test="f:human/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="human">
               <xsl:value-of select="f:human/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:human[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_human">
               <xsl:apply-templates select="f:human" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--expression 1..1 string (json type: string)--><xsl:if test="f:expression">
         <xsl:if test="f:expression/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="expression">
               <xsl:value-of select="f:expression/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:expression[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_expression">
               <xsl:apply-templates select="f:expression" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--xpath 0..1 string (json type: string)--><xsl:if test="f:xpath">
         <xsl:if test="f:xpath/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="xpath">
               <xsl:value-of select="f:xpath/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:xpath[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_xpath">
               <xsl:apply-templates select="f:xpath" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--source 0..1 uri (json type: string)--><xsl:if test="f:source">
         <xsl:if test="f:source/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="source">
               <xsl:value-of select="f:source/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:source[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_source">
               <xsl:apply-templates select="f:source" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Mapping">
      <xsl:apply-templates select="." mode="Element"/>
          <!--identity 1..1 id (json type: string)--><xsl:if test="f:identity">
         <xsl:if test="f:identity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="identity">
               <xsl:value-of select="f:identity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:identity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_identity">
               <xsl:apply-templates select="f:identity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--map 1..1 string (json type: string)--><xsl:if test="f:map">
         <xsl:if test="f:map/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="map">
               <xsl:value-of select="f:map/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:map[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_map">
               <xsl:apply-templates select="f:map" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Base">
      <xsl:apply-templates select="." mode="Element"/>
          <!--path 1..1 string (json type: string)--><xsl:if test="f:path">
         <xsl:if test="f:path/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="path">
               <xsl:value-of select="f:path/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:path[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_path">
               <xsl:apply-templates select="f:path" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--min 1..1 unsignedInt (json type: number)--><xsl:if test="f:min">
         <xsl:if test="f:min/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="min">
               <xsl:value-of select="f:min/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:min[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_min">
               <xsl:apply-templates select="f:min" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--max 1..1 string (json type: string)--><xsl:if test="f:max">
         <xsl:if test="f:max/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="max">
               <xsl:value-of select="f:max/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:max[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_max">
               <xsl:apply-templates select="f:max" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Type">
      <xsl:apply-templates select="." mode="Element"/>
          <!--code 1..1 uri (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--profile 0..1 uri (json type: string)--><xsl:if test="f:profile">
         <xsl:if test="f:profile/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
               <xsl:value-of select="f:profile/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:profile[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_profile">
               <xsl:apply-templates select="f:profile" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--targetProfile 0..1 uri (json type: string)--><xsl:if test="f:targetProfile">
         <xsl:if test="f:targetProfile/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetProfile">
               <xsl:value-of select="f:targetProfile/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:targetProfile[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_targetProfile">
               <xsl:apply-templates select="f:targetProfile" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--aggregation 0..* AggregationMode (json type: string)--><xsl:if test="f:aggregation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="aggregation">
            <xsl:for-each select="f:aggregation">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:aggregation[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_aggregation">
               <xsl:for-each select="f:aggregation">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--versioning 0..1 ReferenceVersionRules (json type: string)--><xsl:if test="f:versioning">
         <xsl:if test="f:versioning/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="versioning">
               <xsl:value-of select="f:versioning/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:versioning[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_versioning">
               <xsl:apply-templates select="f:versioning" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Example">
      <xsl:apply-templates select="." mode="Element"/>
          <!--label 1..1 string (json type: string)--><xsl:if test="f:label">
         <xsl:if test="f:label/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="label">
               <xsl:value-of select="f:label/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:label[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_label">
               <xsl:apply-templates select="f:label" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        
           
           <!--valueBase64Binary 1..1 base64Binary (json type: string)--><xsl:if test="f:valueBase64Binary">
         <xsl:if test="f:valueBase64Binary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueBase64Binary">
               <xsl:value-of select="f:valueBase64Binary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueBase64Binary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueBase64Binary">
               <xsl:apply-templates select="f:valueBase64Binary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:valueBoolean">
         <xsl:if test="f:valueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean">
               <xsl:value-of select="f:valueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:valueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueBoolean">
               <xsl:apply-templates select="f:valueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueCode 1..1 code (json type: string)--><xsl:if test="f:valueCode">
         <xsl:if test="f:valueCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode">
               <xsl:value-of select="f:valueCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueCode">
               <xsl:apply-templates select="f:valueCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueDate 1..1 date (json type: string)--><xsl:if test="f:valueDate">
         <xsl:if test="f:valueDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDate">
               <xsl:value-of select="f:valueDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDate">
               <xsl:apply-templates select="f:valueDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:valueDateTime">
         <xsl:if test="f:valueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime">
               <xsl:value-of select="f:valueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDateTime">
               <xsl:apply-templates select="f:valueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueDecimal 1..1 decimal (json type: number)--><xsl:if test="f:valueDecimal">
         <xsl:if test="f:valueDecimal/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueDecimal">
               <xsl:value-of select="f:valueDecimal/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueDecimal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDecimal">
               <xsl:apply-templates select="f:valueDecimal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueId 1..1 id (json type: string)--><xsl:if test="f:valueId">
         <xsl:if test="f:valueId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueId">
               <xsl:value-of select="f:valueId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueId">
               <xsl:apply-templates select="f:valueId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueInstant 1..1 instant (json type: string)--><xsl:if test="f:valueInstant">
         <xsl:if test="f:valueInstant/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueInstant">
               <xsl:value-of select="f:valueInstant/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueInstant[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueInstant">
               <xsl:apply-templates select="f:valueInstant" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueInteger 1..1 integer (json type: number)--><xsl:if test="f:valueInteger">
         <xsl:if test="f:valueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueInteger">
               <xsl:value-of select="f:valueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueInteger">
               <xsl:apply-templates select="f:valueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueMarkdown 1..1 markdown (json type: string)--><xsl:if test="f:valueMarkdown">
         <xsl:if test="f:valueMarkdown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueMarkdown">
               <xsl:value-of select="f:valueMarkdown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueMarkdown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueMarkdown">
               <xsl:apply-templates select="f:valueMarkdown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueOid 1..1 oid (json type: string)--><xsl:if test="f:valueOid">
         <xsl:if test="f:valueOid/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueOid">
               <xsl:value-of select="f:valueOid/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueOid[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueOid">
               <xsl:apply-templates select="f:valueOid" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valuePositiveInt 1..1 positiveInt (json type: number)--><xsl:if test="f:valuePositiveInt">
         <xsl:if test="f:valuePositiveInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valuePositiveInt">
               <xsl:value-of select="f:valuePositiveInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valuePositiveInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valuePositiveInt">
               <xsl:apply-templates select="f:valuePositiveInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueString 1..1 string (json type: string)--><xsl:if test="f:valueString">
         <xsl:if test="f:valueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString">
               <xsl:value-of select="f:valueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueString">
               <xsl:apply-templates select="f:valueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueTime 1..1 time (json type: string)--><xsl:if test="f:valueTime">
         <xsl:if test="f:valueTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueTime">
               <xsl:value-of select="f:valueTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueTime">
               <xsl:apply-templates select="f:valueTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:valueUnsignedInt">
         <xsl:if test="f:valueUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueUnsignedInt">
               <xsl:value-of select="f:valueUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueUnsignedInt">
               <xsl:apply-templates select="f:valueUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueUri 1..1 uri (json type: string)--><xsl:if test="f:valueUri">
         <xsl:if test="f:valueUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueUri">
               <xsl:value-of select="f:valueUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueUri">
               <xsl:apply-templates select="f:valueUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueAddress 1..1 Address--><xsl:if test="f:valueAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAddress">
            <xsl:apply-templates select="f:valueAddress" mode="Address"/>
         </map>
      </xsl:if>
           <!--valueAge 1..1 Age--><xsl:if test="f:valueAge">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAge">
            <xsl:apply-templates select="f:valueAge" mode="Age"/>
         </map>
      </xsl:if>
           <!--valueAnnotation 1..1 Annotation--><xsl:if test="f:valueAnnotation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAnnotation">
            <xsl:apply-templates select="f:valueAnnotation" mode="Annotation"/>
         </map>
      </xsl:if>
           <!--valueAttachment 1..1 Attachment--><xsl:if test="f:valueAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAttachment">
            <xsl:apply-templates select="f:valueAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
           <!--valueCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:valueCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCodeableConcept">
            <xsl:apply-templates select="f:valueCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
           <!--valueCoding 1..1 Coding--><xsl:if test="f:valueCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCoding">
            <xsl:apply-templates select="f:valueCoding" mode="Coding"/>
         </map>
      </xsl:if>
           <!--valueContactPoint 1..1 ContactPoint--><xsl:if test="f:valueContactPoint">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueContactPoint">
            <xsl:apply-templates select="f:valueContactPoint" mode="ContactPoint"/>
         </map>
      </xsl:if>
           <!--valueCount 1..1 Count--><xsl:if test="f:valueCount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCount">
            <xsl:apply-templates select="f:valueCount" mode="Count"/>
         </map>
      </xsl:if>
           <!--valueDistance 1..1 Distance--><xsl:if test="f:valueDistance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueDistance">
            <xsl:apply-templates select="f:valueDistance" mode="Distance"/>
         </map>
      </xsl:if>
           <!--valueDuration 1..1 Duration--><xsl:if test="f:valueDuration">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueDuration">
            <xsl:apply-templates select="f:valueDuration" mode="Duration"/>
         </map>
      </xsl:if>
           <!--valueHumanName 1..1 HumanName--><xsl:if test="f:valueHumanName">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueHumanName">
            <xsl:apply-templates select="f:valueHumanName" mode="HumanName"/>
         </map>
      </xsl:if>
           <!--valueIdentifier 1..1 Identifier--><xsl:if test="f:valueIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueIdentifier">
            <xsl:apply-templates select="f:valueIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
           <!--valueMoney 1..1 Money--><xsl:if test="f:valueMoney">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueMoney">
            <xsl:apply-templates select="f:valueMoney" mode="Money"/>
         </map>
      </xsl:if>
           <!--valuePeriod 1..1 Period--><xsl:if test="f:valuePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valuePeriod">
            <xsl:apply-templates select="f:valuePeriod" mode="Period"/>
         </map>
      </xsl:if>
           <!--valueQuantity 1..1 Quantity--><xsl:if test="f:valueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueQuantity">
            <xsl:apply-templates select="f:valueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
           <!--valueRange 1..1 Range--><xsl:if test="f:valueRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueRange">
            <xsl:apply-templates select="f:valueRange" mode="Range"/>
         </map>
      </xsl:if>
           <!--valueRatio 1..1 Ratio--><xsl:if test="f:valueRatio">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueRatio">
            <xsl:apply-templates select="f:valueRatio" mode="Ratio"/>
         </map>
      </xsl:if>
           <!--valueReference 1..1 Reference--><xsl:if test="f:valueReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueReference">
            <xsl:apply-templates select="f:valueReference" mode="Reference"/>
         </map>
      </xsl:if>
           <!--valueSampledData 1..1 SampledData--><xsl:if test="f:valueSampledData">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSampledData">
            <xsl:apply-templates select="f:valueSampledData" mode="SampledData"/>
         </map>
      </xsl:if>
           <!--valueSignature 1..1 Signature--><xsl:if test="f:valueSignature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSignature">
            <xsl:apply-templates select="f:valueSignature" mode="Signature"/>
         </map>
      </xsl:if>
           <!--valueTiming 1..1 Timing--><xsl:if test="f:valueTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueTiming">
            <xsl:apply-templates select="f:valueTiming" mode="Timing"/>
         </map>
      </xsl:if>
           <!--valueMeta 1..1 Meta--><xsl:if test="f:valueMeta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueMeta">
            <xsl:apply-templates select="f:valueMeta" mode="Meta"/>
         </map>
      </xsl:if>
         
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Slicing">
      <xsl:apply-templates select="." mode="Element"/>
          <!--discriminator 0..* ElementDefinition.Discriminator--><xsl:if test="f:discriminator">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="discriminator">
            <xsl:for-each select="f:discriminator">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition.Discriminator"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--ordered 0..1 boolean (json type: boolean)--><xsl:if test="f:ordered">
         <xsl:if test="f:ordered/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="ordered">
               <xsl:value-of select="f:ordered/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:ordered[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ordered">
               <xsl:apply-templates select="f:ordered" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--rules 1..1 SlicingRules (json type: string)--><xsl:if test="f:rules">
         <xsl:if test="f:rules/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="rules">
               <xsl:value-of select="f:rules/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:rules[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_rules">
               <xsl:apply-templates select="f:rules" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Binding">
      <xsl:apply-templates select="." mode="Element"/>
          <!--strength 1..1 BindingStrength (json type: string)--><xsl:if test="f:strength">
         <xsl:if test="f:strength/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="strength">
               <xsl:value-of select="f:strength/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:strength[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_strength">
               <xsl:apply-templates select="f:strength" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
           <!--valueSetUri 1..1 uri (json type: string)--><xsl:if test="f:valueSetUri">
         <xsl:if test="f:valueSetUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetUri">
               <xsl:value-of select="f:valueSetUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueSetUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueSetUri">
               <xsl:apply-templates select="f:valueSetUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
           <!--valueSetReference 1..1 Reference--><xsl:if test="f:valueSetReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueSetReference">
            <xsl:apply-templates select="f:valueSetReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Captures constraints on each element within the resource, profile, or extension.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ElementDefinition.Discriminator">
      <xsl:apply-templates select="." mode="Element"/>
          <!--type 1..1 DiscriminatorType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--path 1..1 string (json type: string)--><xsl:if test="f:path">
         <xsl:if test="f:path/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="path">
               <xsl:value-of select="f:path/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:path[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_path">
               <xsl:apply-templates select="f:path" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a property is represented when serialized.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="PropertyRepresentation">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>SHALL applications comply with this constraint?</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConstraintSeverity">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How resource references can be aggregated.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AggregationMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Whether a reference needs to be version specific or version independent, or whether either can be used</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ReferenceVersionRules">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How slices are interpreted when evaluating an instance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SlicingRules">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indication of the degree of conformance expectations associated with a binding.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="BindingStrength">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How an element value is interpreted when discrimination is evaluated</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiscriminatorType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The parameters to the module. This collection specifies both the input and output parameters. Input parameters are provided by the caller as part of the $evaluate operation. Output parameters are included in the GuidanceResponse.</xd:p>
         <xd:p>If the element is present, it must have a value for at least one of the defined elements, an @id referenced from the Narrative, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ParameterDefinition">
      <xsl:apply-templates select="." mode="Element"/>
          <!--name 0..1 code (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--use 1..1 code (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--min 0..1 integer (json type: number)--><xsl:if test="f:min">
         <xsl:if test="f:min/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="min">
               <xsl:value-of select="f:min/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:min[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_min">
               <xsl:apply-templates select="f:min" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--max 0..1 string (json type: string)--><xsl:if test="f:max">
         <xsl:if test="f:max/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="max">
               <xsl:value-of select="f:max/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:max[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_max">
               <xsl:apply-templates select="f:max" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 1..1 code (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--profile 0..1 Reference--><xsl:if test="f:profile">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:apply-templates select="f:profile" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A resource that includes narrative, extensions, and contained resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DomainResource">
      <xsl:apply-templates select="." mode="Resource"/>
          <!--text 0..1 Narrative--><xsl:if test="f:text">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="text">
            <xsl:apply-templates select="f:text" mode="Narrative"/>
         </map>
      </xsl:if>
          <!--contained 0..* ResourceContainer--><xsl:if test="f:contained">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contained">
            <xsl:for-each select="f:contained">
               <map>
                  <xsl:apply-templates select="." mode="ResourceContainer"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--extension 0..* Extension--><xsl:if test="f:extension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="extension">
            <xsl:for-each select="f:extension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--modifierExtension 0..* Extension--><xsl:if test="f:modifierExtension">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifierExtension">
            <xsl:for-each select="f:modifierExtension">
               <map>
                  <xsl:apply-templates select="." mode="Extension"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This is the base resource type for everything.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Resource">
          <!--id 0..1 id (json type: string)--><xsl:if test="f:id">
         <xsl:if test="f:id/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="id">
               <xsl:value-of select="f:id/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:id[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_id">
               <xsl:apply-templates select="f:id" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--meta 0..1 Meta--><xsl:if test="f:meta">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="meta">
            <xsl:apply-templates select="f:meta" mode="Meta"/>
         </map>
      </xsl:if>
          <!--implicitRules 0..1 uri (json type: string)--><xsl:if test="f:implicitRules">
         <xsl:if test="f:implicitRules/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="implicitRules">
               <xsl:value-of select="f:implicitRules/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:implicitRules[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_implicitRules">
               <xsl:apply-templates select="f:implicitRules" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="PublicationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SearchParamType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AdministrativeGender">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="RemittanceOutcome">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="NoteType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMapEquivalence">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p/>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReferenceStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Account">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Account</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 AccountStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--active 0..1 Period--><xsl:if test="f:active">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="active">
            <xsl:apply-templates select="f:active" mode="Period"/>
         </map>
      </xsl:if>
          <!--balance 0..1 Money--><xsl:if test="f:balance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="balance">
            <xsl:apply-templates select="f:balance" mode="Money"/>
         </map>
      </xsl:if>
          <!--coverage 0..* Account.Coverage--><xsl:if test="f:coverage">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:for-each select="f:coverage">
               <map>
                  <xsl:apply-templates select="." mode="Account.Coverage"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--owner 0..1 Reference--><xsl:if test="f:owner">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="owner">
            <xsl:apply-templates select="f:owner" mode="Reference"/>
         </map>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--guarantor 0..* Account.Guarantor--><xsl:if test="f:guarantor">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="guarantor">
            <xsl:for-each select="f:guarantor">
               <map>
                  <xsl:apply-templates select="." mode="Account.Guarantor"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Account.Coverage">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--coverage 1..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
          <!--priority 0..1 positiveInt (json type: number)--><xsl:if test="f:priority">
         <xsl:if test="f:priority/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
               <xsl:value-of select="f:priority/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:priority[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_priority">
               <xsl:apply-templates select="f:priority" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Account.Guarantor">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--party 1..1 Reference--><xsl:if test="f:party">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="party">
            <xsl:apply-templates select="f:party" mode="Reference"/>
         </map>
      </xsl:if>
          <!--onHold 0..1 boolean (json type: boolean)--><xsl:if test="f:onHold">
         <xsl:if test="f:onHold/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="onHold">
               <xsl:value-of select="f:onHold/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:onHold[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onHold">
               <xsl:apply-templates select="f:onHold" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the account is available to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AccountStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ActivityDefinition">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ActivityDefinition</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 PublicationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 markdown (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--purpose 0..1 markdown (json type: string)--><xsl:if test="f:purpose">
         <xsl:if test="f:purpose/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose">
               <xsl:value-of select="f:purpose/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:purpose[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_purpose">
               <xsl:apply-templates select="f:purpose" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--usage 0..1 string (json type: string)--><xsl:if test="f:usage">
         <xsl:if test="f:usage/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="usage">
               <xsl:value-of select="f:usage/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:usage[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_usage">
               <xsl:apply-templates select="f:usage" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--approvalDate 0..1 date (json type: string)--><xsl:if test="f:approvalDate">
         <xsl:if test="f:approvalDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="approvalDate">
               <xsl:value-of select="f:approvalDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:approvalDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_approvalDate">
               <xsl:apply-templates select="f:approvalDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--lastReviewDate 0..1 date (json type: string)--><xsl:if test="f:lastReviewDate">
         <xsl:if test="f:lastReviewDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastReviewDate">
               <xsl:value-of select="f:lastReviewDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastReviewDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastReviewDate">
               <xsl:apply-templates select="f:lastReviewDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--effectivePeriod 0..1 Period--><xsl:if test="f:effectivePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="effectivePeriod">
            <xsl:apply-templates select="f:effectivePeriod" mode="Period"/>
         </map>
      </xsl:if>
          <!--useContext 0..* UsageContext--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="UsageContext"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--jurisdiction 0..* CodeableConcept--><xsl:if test="f:jurisdiction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="jurisdiction">
            <xsl:for-each select="f:jurisdiction">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--topic 0..* CodeableConcept--><xsl:if test="f:topic">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="topic">
            <xsl:for-each select="f:topic">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--contributor 0..* Contributor--><xsl:if test="f:contributor">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contributor">
            <xsl:for-each select="f:contributor">
               <map>
                  <xsl:apply-templates select="." mode="Contributor"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--contact 0..* ContactDetail--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--copyright 0..1 markdown (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--relatedArtifact 0..* RelatedArtifact--><xsl:if test="f:relatedArtifact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="relatedArtifact">
            <xsl:for-each select="f:relatedArtifact">
               <map>
                  <xsl:apply-templates select="." mode="RelatedArtifact"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--library 0..* Reference--><xsl:if test="f:library">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="library">
            <xsl:for-each select="f:library">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--kind 0..1 ResourceType (json type: string)--><xsl:if test="f:kind">
         <xsl:if test="f:kind/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="kind">
               <xsl:value-of select="f:kind/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:kind[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_kind">
               <xsl:apply-templates select="f:kind" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          
            
            <!--timingTiming 1..1 Timing--><xsl:if test="f:timingTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingTiming">
            <xsl:apply-templates select="f:timingTiming" mode="Timing"/>
         </map>
      </xsl:if>
            <!--timingDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:timingDateTime">
         <xsl:if test="f:timingDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDateTime">
               <xsl:value-of select="f:timingDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:timingDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_timingDateTime">
               <xsl:apply-templates select="f:timingDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--timingPeriod 1..1 Period--><xsl:if test="f:timingPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingPeriod">
            <xsl:apply-templates select="f:timingPeriod" mode="Period"/>
         </map>
      </xsl:if>
            <!--timingRange 1..1 Range--><xsl:if test="f:timingRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingRange">
            <xsl:apply-templates select="f:timingRange" mode="Range"/>
         </map>
      </xsl:if>
          
          <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
          <!--participant 0..* ActivityDefinition.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="ActivityDefinition.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          
            
            <!--productReference 1..1 Reference--><xsl:if test="f:productReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="productReference">
            <xsl:apply-templates select="f:productReference" mode="Reference"/>
         </map>
      </xsl:if>
            <!--productCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:productCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="productCodeableConcept">
            <xsl:apply-templates select="f:productCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          
          <!--quantity 0..1 Quantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--dosage 0..* Dosage--><xsl:if test="f:dosage">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dosage">
            <xsl:for-each select="f:dosage">
               <map>
                  <xsl:apply-templates select="." mode="Dosage"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--bodySite 0..* CodeableConcept--><xsl:if test="f:bodySite">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="bodySite">
            <xsl:for-each select="f:bodySite">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--transform 0..1 Reference--><xsl:if test="f:transform">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="transform">
            <xsl:apply-templates select="f:transform" mode="Reference"/>
         </map>
      </xsl:if>
          <!--dynamicValue 0..* ActivityDefinition.DynamicValue--><xsl:if test="f:dynamicValue">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dynamicValue">
            <xsl:for-each select="f:dynamicValue">
               <map>
                  <xsl:apply-templates select="." mode="ActivityDefinition.DynamicValue"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ActivityDefinition.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 1..1 ActionParticipantType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--role 0..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ActivityDefinition.DynamicValue">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--path 0..1 string (json type: string)--><xsl:if test="f:path">
         <xsl:if test="f:path/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="path">
               <xsl:value-of select="f:path/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:path[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_path">
               <xsl:apply-templates select="f:path" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--language 0..1 string (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--expression 0..1 string (json type: string)--><xsl:if test="f:expression">
         <xsl:if test="f:expression/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="expression">
               <xsl:value-of select="f:expression/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:expression[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_expression">
               <xsl:apply-templates select="f:expression" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of participant in the activity</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ActionParticipantType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The kind of activity the definition is describing</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ResourceType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Actual or  potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AdverseEvent">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">AdverseEvent</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--category 0..1 AdverseEventCategory (json type: string)--><xsl:if test="f:category">
         <xsl:if test="f:category/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="category">
               <xsl:value-of select="f:category/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:category[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_category">
               <xsl:apply-templates select="f:category" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--reaction 0..* Reference--><xsl:if test="f:reaction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reaction">
            <xsl:for-each select="f:reaction">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
          <!--seriousness 0..1 CodeableConcept--><xsl:if test="f:seriousness">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="seriousness">
            <xsl:apply-templates select="f:seriousness" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--outcome 0..1 CodeableConcept--><xsl:if test="f:outcome">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
            <xsl:apply-templates select="f:outcome" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--recorder 0..1 Reference--><xsl:if test="f:recorder">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="recorder">
            <xsl:apply-templates select="f:recorder" mode="Reference"/>
         </map>
      </xsl:if>
          <!--eventParticipant 0..1 Reference--><xsl:if test="f:eventParticipant">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="eventParticipant">
            <xsl:apply-templates select="f:eventParticipant" mode="Reference"/>
         </map>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--suspectEntity 0..* AdverseEvent.SuspectEntity--><xsl:if test="f:suspectEntity">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="suspectEntity">
            <xsl:for-each select="f:suspectEntity">
               <map>
                  <xsl:apply-templates select="." mode="AdverseEvent.SuspectEntity"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--subjectMedicalHistory 0..* Reference--><xsl:if test="f:subjectMedicalHistory">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subjectMedicalHistory">
            <xsl:for-each select="f:subjectMedicalHistory">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--referenceDocument 0..* Reference--><xsl:if test="f:referenceDocument">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="referenceDocument">
            <xsl:for-each select="f:referenceDocument">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--study 0..* Reference--><xsl:if test="f:study">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="study">
            <xsl:for-each select="f:study">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Actual or  potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AdverseEvent.SuspectEntity">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--instance 1..1 Reference--><xsl:if test="f:instance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="instance">
            <xsl:apply-templates select="f:instance" mode="Reference"/>
         </map>
      </xsl:if>
          <!--causality 0..1 AdverseEventCausality (json type: string)--><xsl:if test="f:causality">
         <xsl:if test="f:causality/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="causality">
               <xsl:value-of select="f:causality/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:causality[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_causality">
               <xsl:apply-templates select="f:causality" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--causalityAssessment 0..1 CodeableConcept--><xsl:if test="f:causalityAssessment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="causalityAssessment">
            <xsl:apply-templates select="f:causalityAssessment" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--causalityProductRelatedness 0..1 string (json type: string)--><xsl:if test="f:causalityProductRelatedness">
         <xsl:if test="f:causalityProductRelatedness/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions"
                    key="causalityProductRelatedness">
               <xsl:value-of select="f:causalityProductRelatedness/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:causalityProductRelatedness[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_causalityProductRelatedness">
               <xsl:apply-templates select="f:causalityProductRelatedness" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--causalityMethod 0..1 CodeableConcept--><xsl:if test="f:causalityMethod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="causalityMethod">
            <xsl:apply-templates select="f:causalityMethod" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--causalityAuthor 0..1 Reference--><xsl:if test="f:causalityAuthor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="causalityAuthor">
            <xsl:apply-templates select="f:causalityAuthor" mode="Reference"/>
         </map>
      </xsl:if>
          <!--causalityResult 0..1 CodeableConcept--><xsl:if test="f:causalityResult">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="causalityResult">
            <xsl:apply-templates select="f:causalityResult" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>TODO</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AdverseEventCausality">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Overall categorization of the event, e.g. real or potential</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AdverseEventCategory">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntolerance">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">AllergyIntolerance</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--clinicalStatus 0..1 AllergyIntoleranceClinicalStatus (json type: string)--><xsl:if test="f:clinicalStatus">
         <xsl:if test="f:clinicalStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="clinicalStatus">
               <xsl:value-of select="f:clinicalStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:clinicalStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_clinicalStatus">
               <xsl:apply-templates select="f:clinicalStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--verificationStatus 1..1 AllergyIntoleranceVerificationStatus (json type: string)--><xsl:if test="f:verificationStatus">
         <xsl:if test="f:verificationStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="verificationStatus">
               <xsl:value-of select="f:verificationStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:verificationStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_verificationStatus">
               <xsl:apply-templates select="f:verificationStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 AllergyIntoleranceType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 0..* AllergyIntoleranceCategory (json type: string)--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:category[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_category">
               <xsl:for-each select="f:category">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--criticality 0..1 AllergyIntoleranceCriticality (json type: string)--><xsl:if test="f:criticality">
         <xsl:if test="f:criticality/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="criticality">
               <xsl:value-of select="f:criticality/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:criticality[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_criticality">
               <xsl:apply-templates select="f:criticality" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          
            
            <!--onsetDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:onsetDateTime">
         <xsl:if test="f:onsetDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetDateTime">
               <xsl:value-of select="f:onsetDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onsetDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onsetDateTime">
               <xsl:apply-templates select="f:onsetDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--onsetAge 1..1 Age--><xsl:if test="f:onsetAge">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetAge">
            <xsl:apply-templates select="f:onsetAge" mode="Age"/>
         </map>
      </xsl:if>
            <!--onsetPeriod 1..1 Period--><xsl:if test="f:onsetPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetPeriod">
            <xsl:apply-templates select="f:onsetPeriod" mode="Period"/>
         </map>
      </xsl:if>
            <!--onsetRange 1..1 Range--><xsl:if test="f:onsetRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetRange">
            <xsl:apply-templates select="f:onsetRange" mode="Range"/>
         </map>
      </xsl:if>
            <!--onsetString 1..1 string (json type: string)--><xsl:if test="f:onsetString">
         <xsl:if test="f:onsetString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetString">
               <xsl:value-of select="f:onsetString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onsetString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onsetString">
               <xsl:apply-templates select="f:onsetString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
          <!--assertedDate 0..1 dateTime (json type: string)--><xsl:if test="f:assertedDate">
         <xsl:if test="f:assertedDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="assertedDate">
               <xsl:value-of select="f:assertedDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:assertedDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_assertedDate">
               <xsl:apply-templates select="f:assertedDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--recorder 0..1 Reference--><xsl:if test="f:recorder">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="recorder">
            <xsl:apply-templates select="f:recorder" mode="Reference"/>
         </map>
      </xsl:if>
          <!--asserter 0..1 Reference--><xsl:if test="f:asserter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="asserter">
            <xsl:apply-templates select="f:asserter" mode="Reference"/>
         </map>
      </xsl:if>
          <!--lastOccurrence 0..1 dateTime (json type: string)--><xsl:if test="f:lastOccurrence">
         <xsl:if test="f:lastOccurrence/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastOccurrence">
               <xsl:value-of select="f:lastOccurrence/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastOccurrence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastOccurrence">
               <xsl:apply-templates select="f:lastOccurrence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reaction 0..* AllergyIntolerance.Reaction--><xsl:if test="f:reaction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reaction">
            <xsl:for-each select="f:reaction">
               <map>
                  <xsl:apply-templates select="." mode="AllergyIntolerance.Reaction"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntolerance.Reaction">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--substance 0..1 CodeableConcept--><xsl:if test="f:substance">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="substance">
            <xsl:apply-templates select="f:substance" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--manifestation 1..* CodeableConcept--><xsl:if test="f:manifestation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="manifestation">
            <xsl:for-each select="f:manifestation">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--onset 0..1 dateTime (json type: string)--><xsl:if test="f:onset">
         <xsl:if test="f:onset/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onset">
               <xsl:value-of select="f:onset/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onset[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onset">
               <xsl:apply-templates select="f:onset" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--severity 0..1 AllergyIntoleranceSeverity (json type: string)--><xsl:if test="f:severity">
         <xsl:if test="f:severity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity">
               <xsl:value-of select="f:severity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:severity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_severity">
               <xsl:apply-templates select="f:severity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--exposureRoute 0..1 CodeableConcept--><xsl:if test="f:exposureRoute">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exposureRoute">
            <xsl:apply-templates select="f:exposureRoute" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Estimate of the potential clinical harm, or seriousness, of a reaction to an identified substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCriticality">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Identification of the underlying physiological mechanism for a Reaction Risk.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Category of an identified substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceCategory">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Assertion about certainty associated with a propensity, or potential risk, of a reaction to the identified substance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceVerificationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Clinical assessment of the severity of a reaction event as a whole, potentially considering multiple different manifestations.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceSeverity">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The clinical status of the allergy or intolerance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AllergyIntoleranceClinicalStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Appointment">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Appointment</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 AppointmentStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--serviceCategory 0..1 CodeableConcept--><xsl:if test="f:serviceCategory">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="serviceCategory">
            <xsl:apply-templates select="f:serviceCategory" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--serviceType 0..* CodeableConcept--><xsl:if test="f:serviceType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="serviceType">
            <xsl:for-each select="f:serviceType">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--specialty 0..* CodeableConcept--><xsl:if test="f:specialty">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specialty">
            <xsl:for-each select="f:specialty">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--appointmentType 0..1 CodeableConcept--><xsl:if test="f:appointmentType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="appointmentType">
            <xsl:apply-templates select="f:appointmentType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--indication 0..* Reference--><xsl:if test="f:indication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="indication">
            <xsl:for-each select="f:indication">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--priority 0..1 unsignedInt (json type: number)--><xsl:if test="f:priority">
         <xsl:if test="f:priority/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
               <xsl:value-of select="f:priority/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:priority[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_priority">
               <xsl:apply-templates select="f:priority" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--supportingInformation 0..* Reference--><xsl:if test="f:supportingInformation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="supportingInformation">
            <xsl:for-each select="f:supportingInformation">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--start 0..1 instant (json type: string)--><xsl:if test="f:start">
         <xsl:if test="f:start/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="start">
               <xsl:value-of select="f:start/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:start[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_start">
               <xsl:apply-templates select="f:start" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--end 0..1 instant (json type: string)--><xsl:if test="f:end">
         <xsl:if test="f:end/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="end">
               <xsl:value-of select="f:end/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:end[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_end">
               <xsl:apply-templates select="f:end" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--minutesDuration 0..1 positiveInt (json type: number)--><xsl:if test="f:minutesDuration">
         <xsl:if test="f:minutesDuration/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="minutesDuration">
               <xsl:value-of select="f:minutesDuration/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:minutesDuration[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_minutesDuration">
               <xsl:apply-templates select="f:minutesDuration" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--slot 0..* Reference--><xsl:if test="f:slot">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="slot">
            <xsl:for-each select="f:slot">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--incomingReferral 0..* Reference--><xsl:if test="f:incomingReferral">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="incomingReferral">
            <xsl:for-each select="f:incomingReferral">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--participant 1..* Appointment.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="Appointment.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--requestedPeriod 0..* Period--><xsl:if test="f:requestedPeriod">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="requestedPeriod">
            <xsl:for-each select="f:requestedPeriod">
               <map>
                  <xsl:apply-templates select="." mode="Period"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Appointment.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--actor 0..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
          <!--required 0..1 ParticipantRequired (json type: string)--><xsl:if test="f:required">
         <xsl:if test="f:required/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="required">
               <xsl:value-of select="f:required/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:required[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_required">
               <xsl:apply-templates select="f:required" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 ParticipationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Is the Participant required to attend the appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ParticipantRequired">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The free/busy status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AppointmentStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Participation status of an appointment.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ParticipationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AppointmentResponse">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">AppointmentResponse</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--appointment 1..1 Reference--><xsl:if test="f:appointment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="appointment">
            <xsl:apply-templates select="f:appointment" mode="Reference"/>
         </map>
      </xsl:if>
          <!--start 0..1 instant (json type: string)--><xsl:if test="f:start">
         <xsl:if test="f:start/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="start">
               <xsl:value-of select="f:start/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:start[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_start">
               <xsl:apply-templates select="f:start" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--end 0..1 instant (json type: string)--><xsl:if test="f:end">
         <xsl:if test="f:end/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="end">
               <xsl:value-of select="f:end/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:end[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_end">
               <xsl:apply-templates select="f:end" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--participantType 0..* CodeableConcept--><xsl:if test="f:participantType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participantType">
            <xsl:for-each select="f:participantType">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--actor 0..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
          <!--participantStatus 1..1 ParticipationStatus (json type: string)--><xsl:if test="f:participantStatus">
         <xsl:if test="f:participantStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="participantStatus">
               <xsl:value-of select="f:participantStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:participantStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_participantStatus">
               <xsl:apply-templates select="f:participantStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">AuditEvent</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--type 1..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
          <!--subtype 0..* Coding--><xsl:if test="f:subtype">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subtype">
            <xsl:for-each select="f:subtype">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--action 0..1 AuditEventAction (json type: string)--><xsl:if test="f:action">
         <xsl:if test="f:action/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="action">
               <xsl:value-of select="f:action/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:action[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_action">
               <xsl:apply-templates select="f:action" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--recorded 1..1 instant (json type: string)--><xsl:if test="f:recorded">
         <xsl:if test="f:recorded/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="recorded">
               <xsl:value-of select="f:recorded/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:recorded[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_recorded">
               <xsl:apply-templates select="f:recorded" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--outcome 0..1 AuditEventOutcome (json type: string)--><xsl:if test="f:outcome">
         <xsl:if test="f:outcome/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
               <xsl:value-of select="f:outcome/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:outcome[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_outcome">
               <xsl:apply-templates select="f:outcome" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--outcomeDesc 0..1 string (json type: string)--><xsl:if test="f:outcomeDesc">
         <xsl:if test="f:outcomeDesc/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="outcomeDesc">
               <xsl:value-of select="f:outcomeDesc/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:outcomeDesc[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_outcomeDesc">
               <xsl:apply-templates select="f:outcomeDesc" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--purposeOfEvent 0..* CodeableConcept--><xsl:if test="f:purposeOfEvent">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="purposeOfEvent">
            <xsl:for-each select="f:purposeOfEvent">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--agent 1..* AuditEvent.Agent--><xsl:if test="f:agent">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="agent">
            <xsl:for-each select="f:agent">
               <map>
                  <xsl:apply-templates select="." mode="AuditEvent.Agent"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--source 1..1 AuditEvent.Source--><xsl:if test="f:source">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="source">
            <xsl:apply-templates select="f:source" mode="AuditEvent.Source"/>
         </map>
      </xsl:if>
          <!--entity 0..* AuditEvent.Entity--><xsl:if test="f:entity">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="entity">
            <xsl:for-each select="f:entity">
               <map>
                  <xsl:apply-templates select="." mode="AuditEvent.Entity"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Agent">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--role 0..* CodeableConcept--><xsl:if test="f:role">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:for-each select="f:role">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reference 0..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
          <!--userId 0..1 Identifier--><xsl:if test="f:userId">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="userId">
            <xsl:apply-templates select="f:userId" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--altId 0..1 string (json type: string)--><xsl:if test="f:altId">
         <xsl:if test="f:altId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="altId">
               <xsl:value-of select="f:altId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:altId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_altId">
               <xsl:apply-templates select="f:altId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--requestor 1..1 boolean (json type: boolean)--><xsl:if test="f:requestor">
         <xsl:if test="f:requestor/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="requestor">
               <xsl:value-of select="f:requestor/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:requestor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_requestor">
               <xsl:apply-templates select="f:requestor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
          <!--policy 0..* uri (json type: string)--><xsl:if test="f:policy">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="policy">
            <xsl:for-each select="f:policy">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:policy[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_policy">
               <xsl:for-each select="f:policy">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--media 0..1 Coding--><xsl:if test="f:media">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="media">
            <xsl:apply-templates select="f:media" mode="Coding"/>
         </map>
      </xsl:if>
          <!--network 0..1 AuditEvent.Network--><xsl:if test="f:network">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="network">
            <xsl:apply-templates select="f:network" mode="AuditEvent.Network"/>
         </map>
      </xsl:if>
          <!--purposeOfUse 0..* CodeableConcept--><xsl:if test="f:purposeOfUse">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="purposeOfUse">
            <xsl:for-each select="f:purposeOfUse">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Network">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--address 0..1 string (json type: string)--><xsl:if test="f:address">
         <xsl:if test="f:address/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="address">
               <xsl:value-of select="f:address/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:address[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_address">
               <xsl:apply-templates select="f:address" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 AuditEventAgentNetworkType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Source">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--site 0..1 string (json type: string)--><xsl:if test="f:site">
         <xsl:if test="f:site/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="site">
               <xsl:value-of select="f:site/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:site[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_site">
               <xsl:apply-templates select="f:site" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--identifier 1..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--type 0..* Coding--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Entity">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--reference 0..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
          <!--type 0..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
          <!--role 0..1 Coding--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="Coding"/>
         </map>
      </xsl:if>
          <!--lifecycle 0..1 Coding--><xsl:if test="f:lifecycle">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="lifecycle">
            <xsl:apply-templates select="f:lifecycle" mode="Coding"/>
         </map>
      </xsl:if>
          <!--securityLabel 0..* Coding--><xsl:if test="f:securityLabel">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="securityLabel">
            <xsl:for-each select="f:securityLabel">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--query 0..1 base64Binary (json type: string)--><xsl:if test="f:query">
         <xsl:if test="f:query/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="query">
               <xsl:value-of select="f:query/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:query[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_query">
               <xsl:apply-templates select="f:query" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--detail 0..* AuditEvent.Detail--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="AuditEvent.Detail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEvent.Detail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 1..1 string (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--value 1..1 base64Binary (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the event succeeded or failed</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventOutcome">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicator for type of action performed during the event that generated the event</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventAction">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of network access point of this agent in the audit event</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="AuditEventAgentNetworkType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Basic">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Basic</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--created 0..1 date (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A binary resource can contain any content, whether text, image, pdf, zip archive, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Binary">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Binary</string>
      <xsl:apply-templates select="." mode="Resource"/>
          <!--contentType 1..1 code (json type: string)--><xsl:if test="f:contentType">
         <xsl:if test="f:contentType/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentType">
               <xsl:value-of select="f:contentType/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentType[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentType">
               <xsl:apply-templates select="f:contentType" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--securityContext 0..1 Reference--><xsl:if test="f:securityContext">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="securityContext">
            <xsl:apply-templates select="f:securityContext" mode="Reference"/>
         </map>
      </xsl:if>
          <!--content 1..1 base64Binary (json type: string)--><xsl:if test="f:content">
         <xsl:if test="f:content/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="content">
               <xsl:value-of select="f:content/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:content[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_content">
               <xsl:apply-templates select="f:content" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Record details about the anatomical location of a specimen or body part.  This resource may be used when a coded concept does not provide the necessary detail needed for the use case.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="BodySite">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">BodySite</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--active 0..1 boolean (json type: boolean)--><xsl:if test="f:active">
         <xsl:if test="f:active/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="active">
               <xsl:value-of select="f:active/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:active[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_active">
               <xsl:apply-templates select="f:active" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--qualifier 0..* CodeableConcept--><xsl:if test="f:qualifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="qualifier">
            <xsl:for-each select="f:qualifier">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--image 0..* Attachment--><xsl:if test="f:image">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="image">
            <xsl:for-each select="f:image">
               <map>
                  <xsl:apply-templates select="." mode="Attachment"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Bundle</string>
      <xsl:apply-templates select="." mode="Resource"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--type 1..1 BundleType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--total 0..1 unsignedInt (json type: number)--><xsl:if test="f:total">
         <xsl:if test="f:total/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="total">
               <xsl:value-of select="f:total/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:total[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_total">
               <xsl:apply-templates select="f:total" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--link 0..* Bundle.Link--><xsl:if test="f:link">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="link">
            <xsl:for-each select="f:link">
               <map>
                  <xsl:apply-templates select="." mode="Bundle.Link"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--entry 0..* Bundle.Entry--><xsl:if test="f:entry">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="entry">
            <xsl:for-each select="f:entry">
               <map>
                  <xsl:apply-templates select="." mode="Bundle.Entry"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--signature 0..1 Signature--><xsl:if test="f:signature">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="signature">
            <xsl:apply-templates select="f:signature" mode="Signature"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Link">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--relation 1..1 string (json type: string)--><xsl:if test="f:relation">
         <xsl:if test="f:relation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="relation">
               <xsl:value-of select="f:relation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:relation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_relation">
               <xsl:apply-templates select="f:relation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--url 1..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Entry">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--link 0..* Bundle.Link--><xsl:if test="f:link">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="link">
            <xsl:for-each select="f:link">
               <map>
                  <xsl:apply-templates select="." mode="Bundle.Link"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--fullUrl 0..1 uri (json type: string)--><xsl:if test="f:fullUrl">
         <xsl:if test="f:fullUrl/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fullUrl">
               <xsl:value-of select="f:fullUrl/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fullUrl[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fullUrl">
               <xsl:apply-templates select="f:fullUrl" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--resource 0..1 ResourceContainer--><xsl:if test="f:resource">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="resource">
            <xsl:apply-templates select="f:resource" mode="ResourceContainer"/>
         </map>
      </xsl:if>
          <!--search 0..1 Bundle.Search--><xsl:if test="f:search">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="search">
            <xsl:apply-templates select="f:search" mode="Bundle.Search"/>
         </map>
      </xsl:if>
          <!--request 0..1 Bundle.Request--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Bundle.Request"/>
         </map>
      </xsl:if>
          <!--response 0..1 Bundle.Response--><xsl:if test="f:response">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="response">
            <xsl:apply-templates select="f:response" mode="Bundle.Response"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Search">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--mode 0..1 SearchEntryMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--score 0..1 decimal (json type: number)--><xsl:if test="f:score">
         <xsl:if test="f:score/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="score">
               <xsl:value-of select="f:score/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:score[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_score">
               <xsl:apply-templates select="f:score" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Request">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--method 1..1 HTTPVerb (json type: string)--><xsl:if test="f:method">
         <xsl:if test="f:method/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="method">
               <xsl:value-of select="f:method/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:method[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_method">
               <xsl:apply-templates select="f:method" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--url 1..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--ifNoneMatch 0..1 string (json type: string)--><xsl:if test="f:ifNoneMatch">
         <xsl:if test="f:ifNoneMatch/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifNoneMatch">
               <xsl:value-of select="f:ifNoneMatch/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ifNoneMatch[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ifNoneMatch">
               <xsl:apply-templates select="f:ifNoneMatch" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--ifModifiedSince 0..1 instant (json type: string)--><xsl:if test="f:ifModifiedSince">
         <xsl:if test="f:ifModifiedSince/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifModifiedSince">
               <xsl:value-of select="f:ifModifiedSince/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ifModifiedSince[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ifModifiedSince">
               <xsl:apply-templates select="f:ifModifiedSince" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--ifMatch 0..1 string (json type: string)--><xsl:if test="f:ifMatch">
         <xsl:if test="f:ifMatch/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifMatch">
               <xsl:value-of select="f:ifMatch/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ifMatch[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ifMatch">
               <xsl:apply-templates select="f:ifMatch" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--ifNoneExist 0..1 string (json type: string)--><xsl:if test="f:ifNoneExist">
         <xsl:if test="f:ifNoneExist/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="ifNoneExist">
               <xsl:value-of select="f:ifNoneExist/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:ifNoneExist[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_ifNoneExist">
               <xsl:apply-templates select="f:ifNoneExist" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A container for a collection of resources.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Bundle.Response">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--status 1..1 string (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--location 0..1 uri (json type: string)--><xsl:if test="f:location">
         <xsl:if test="f:location/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="location">
               <xsl:value-of select="f:location/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:location[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_location">
               <xsl:apply-templates select="f:location" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--etag 0..1 string (json type: string)--><xsl:if test="f:etag">
         <xsl:if test="f:etag/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="etag">
               <xsl:value-of select="f:etag/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:etag[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_etag">
               <xsl:apply-templates select="f:etag" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--lastModified 0..1 instant (json type: string)--><xsl:if test="f:lastModified">
         <xsl:if test="f:lastModified/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastModified">
               <xsl:value-of select="f:lastModified/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastModified[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastModified">
               <xsl:apply-templates select="f:lastModified" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--outcome 0..1 ResourceContainer--><xsl:if test="f:outcome">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
            <xsl:apply-templates select="f:outcome" mode="ResourceContainer"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>HTTP verbs (in the HTTP command line).</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="HTTPVerb">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the purpose of a bundle - how it was intended to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="BundleType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Why an entry is in the result set - whether it's included as a match or because of an _include requirement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SearchEntryMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">CapabilityStatement</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 PublicationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--date 1..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--contact 0..* ContactDetail--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 markdown (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--useContext 0..* UsageContext--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="UsageContext"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--jurisdiction 0..* CodeableConcept--><xsl:if test="f:jurisdiction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="jurisdiction">
            <xsl:for-each select="f:jurisdiction">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--purpose 0..1 markdown (json type: string)--><xsl:if test="f:purpose">
         <xsl:if test="f:purpose/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose">
               <xsl:value-of select="f:purpose/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:purpose[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_purpose">
               <xsl:apply-templates select="f:purpose" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--copyright 0..1 markdown (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--kind 1..1 CapabilityStatementKind (json type: string)--><xsl:if test="f:kind">
         <xsl:if test="f:kind/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="kind">
               <xsl:value-of select="f:kind/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:kind[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_kind">
               <xsl:apply-templates select="f:kind" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--instantiates 0..* uri (json type: string)--><xsl:if test="f:instantiates">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="instantiates">
            <xsl:for-each select="f:instantiates">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:instantiates[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_instantiates">
               <xsl:for-each select="f:instantiates">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--software 0..1 CapabilityStatement.Software--><xsl:if test="f:software">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="software">
            <xsl:apply-templates select="f:software" mode="CapabilityStatement.Software"/>
         </map>
      </xsl:if>
          <!--implementation 0..1 CapabilityStatement.Implementation--><xsl:if test="f:implementation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="implementation">
            <xsl:apply-templates select="f:implementation" mode="CapabilityStatement.Implementation"/>
         </map>
      </xsl:if>
          <!--fhirVersion 1..1 id (json type: string)--><xsl:if test="f:fhirVersion">
         <xsl:if test="f:fhirVersion/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="fhirVersion">
               <xsl:value-of select="f:fhirVersion/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:fhirVersion[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_fhirVersion">
               <xsl:apply-templates select="f:fhirVersion" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--acceptUnknown 1..1 UnknownContentCode (json type: string)--><xsl:if test="f:acceptUnknown">
         <xsl:if test="f:acceptUnknown/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="acceptUnknown">
               <xsl:value-of select="f:acceptUnknown/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:acceptUnknown[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_acceptUnknown">
               <xsl:apply-templates select="f:acceptUnknown" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--format 1..* code (json type: string)--><xsl:if test="f:format">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="format">
            <xsl:for-each select="f:format">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:format[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_format">
               <xsl:for-each select="f:format">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--patchFormat 0..* code (json type: string)--><xsl:if test="f:patchFormat">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="patchFormat">
            <xsl:for-each select="f:patchFormat">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:patchFormat[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_patchFormat">
               <xsl:for-each select="f:patchFormat">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--implementationGuide 0..* uri (json type: string)--><xsl:if test="f:implementationGuide">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="implementationGuide">
            <xsl:for-each select="f:implementationGuide">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:implementationGuide[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_implementationGuide">
               <xsl:for-each select="f:implementationGuide">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--profile 0..* Reference--><xsl:if test="f:profile">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:for-each select="f:profile">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--rest 0..* CapabilityStatement.Rest--><xsl:if test="f:rest">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="rest">
            <xsl:for-each select="f:rest">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Rest"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--messaging 0..* CapabilityStatement.Messaging--><xsl:if test="f:messaging">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="messaging">
            <xsl:for-each select="f:messaging">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Messaging"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--document 0..* CapabilityStatement.Document--><xsl:if test="f:document">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="document">
            <xsl:for-each select="f:document">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Document"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Software">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--releaseDate 0..1 dateTime (json type: string)--><xsl:if test="f:releaseDate">
         <xsl:if test="f:releaseDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="releaseDate">
               <xsl:value-of select="f:releaseDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:releaseDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_releaseDate">
               <xsl:apply-templates select="f:releaseDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Implementation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--description 1..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Rest">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--mode 1..1 RestfulCapabilityMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--security 0..1 CapabilityStatement.Security--><xsl:if test="f:security">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="security">
            <xsl:apply-templates select="f:security" mode="CapabilityStatement.Security"/>
         </map>
      </xsl:if>
          <!--resource 0..* CapabilityStatement.Resource--><xsl:if test="f:resource">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="resource">
            <xsl:for-each select="f:resource">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Resource"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--interaction 0..* CapabilityStatement.Interaction1--><xsl:if test="f:interaction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="interaction">
            <xsl:for-each select="f:interaction">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Interaction1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--searchParam 0..* CapabilityStatement.SearchParam--><xsl:if test="f:searchParam">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="searchParam">
            <xsl:for-each select="f:searchParam">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.SearchParam"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--operation 0..* CapabilityStatement.Operation--><xsl:if test="f:operation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="operation">
            <xsl:for-each select="f:operation">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Operation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--compartment 0..* uri (json type: string)--><xsl:if test="f:compartment">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="compartment">
            <xsl:for-each select="f:compartment">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:compartment[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_compartment">
               <xsl:for-each select="f:compartment">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Security">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--cors 0..1 boolean (json type: boolean)--><xsl:if test="f:cors">
         <xsl:if test="f:cors/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="cors">
               <xsl:value-of select="f:cors/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:cors[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_cors">
               <xsl:apply-templates select="f:cors" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--service 0..* CodeableConcept--><xsl:if test="f:service">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:for-each select="f:service">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--certificate 0..* CapabilityStatement.Certificate--><xsl:if test="f:certificate">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="certificate">
            <xsl:for-each select="f:certificate">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Certificate"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Certificate">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 0..1 code (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--blob 0..1 base64Binary (json type: string)--><xsl:if test="f:blob">
         <xsl:if test="f:blob/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="blob">
               <xsl:value-of select="f:blob/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:blob[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_blob">
               <xsl:apply-templates select="f:blob" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Resource">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 1..1 ResourceType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--profile 0..1 Reference--><xsl:if test="f:profile">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:apply-templates select="f:profile" mode="Reference"/>
         </map>
      </xsl:if>
          <!--documentation 0..1 markdown (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--interaction 1..* CapabilityStatement.Interaction--><xsl:if test="f:interaction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="interaction">
            <xsl:for-each select="f:interaction">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Interaction"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--versioning 0..1 ResourceVersionPolicy (json type: string)--><xsl:if test="f:versioning">
         <xsl:if test="f:versioning/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="versioning">
               <xsl:value-of select="f:versioning/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:versioning[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_versioning">
               <xsl:apply-templates select="f:versioning" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--readHistory 0..1 boolean (json type: boolean)--><xsl:if test="f:readHistory">
         <xsl:if test="f:readHistory/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="readHistory">
               <xsl:value-of select="f:readHistory/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:readHistory[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_readHistory">
               <xsl:apply-templates select="f:readHistory" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--updateCreate 0..1 boolean (json type: boolean)--><xsl:if test="f:updateCreate">
         <xsl:if test="f:updateCreate/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="updateCreate">
               <xsl:value-of select="f:updateCreate/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:updateCreate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_updateCreate">
               <xsl:apply-templates select="f:updateCreate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--conditionalCreate 0..1 boolean (json type: boolean)--><xsl:if test="f:conditionalCreate">
         <xsl:if test="f:conditionalCreate/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalCreate">
               <xsl:value-of select="f:conditionalCreate/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:conditionalCreate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conditionalCreate">
               <xsl:apply-templates select="f:conditionalCreate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--conditionalRead 0..1 ConditionalReadStatus (json type: string)--><xsl:if test="f:conditionalRead">
         <xsl:if test="f:conditionalRead/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalRead">
               <xsl:value-of select="f:conditionalRead/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:conditionalRead[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conditionalRead">
               <xsl:apply-templates select="f:conditionalRead" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--conditionalUpdate 0..1 boolean (json type: boolean)--><xsl:if test="f:conditionalUpdate">
         <xsl:if test="f:conditionalUpdate/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalUpdate">
               <xsl:value-of select="f:conditionalUpdate/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:conditionalUpdate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conditionalUpdate">
               <xsl:apply-templates select="f:conditionalUpdate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--conditionalDelete 0..1 ConditionalDeleteStatus (json type: string)--><xsl:if test="f:conditionalDelete">
         <xsl:if test="f:conditionalDelete/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="conditionalDelete">
               <xsl:value-of select="f:conditionalDelete/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:conditionalDelete[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conditionalDelete">
               <xsl:apply-templates select="f:conditionalDelete" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--referencePolicy 0..* ReferenceHandlingPolicy (json type: string)--><xsl:if test="f:referencePolicy">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="referencePolicy">
            <xsl:for-each select="f:referencePolicy">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:referencePolicy[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_referencePolicy">
               <xsl:for-each select="f:referencePolicy">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--searchInclude 0..* string (json type: string)--><xsl:if test="f:searchInclude">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="searchInclude">
            <xsl:for-each select="f:searchInclude">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:searchInclude[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_searchInclude">
               <xsl:for-each select="f:searchInclude">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--searchRevInclude 0..* string (json type: string)--><xsl:if test="f:searchRevInclude">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="searchRevInclude">
            <xsl:for-each select="f:searchRevInclude">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:searchRevInclude[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_searchRevInclude">
               <xsl:for-each select="f:searchRevInclude">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--searchParam 0..* CapabilityStatement.SearchParam--><xsl:if test="f:searchParam">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="searchParam">
            <xsl:for-each select="f:searchParam">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.SearchParam"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Interaction">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 TypeRestfulInteraction (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.SearchParam">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--definition 0..1 uri (json type: string)--><xsl:if test="f:definition">
         <xsl:if test="f:definition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
               <xsl:value-of select="f:definition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:definition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_definition">
               <xsl:apply-templates select="f:definition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 1..1 SearchParamType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Interaction1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 SystemRestfulInteraction (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Operation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--definition 1..1 Reference--><xsl:if test="f:definition">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
            <xsl:apply-templates select="f:definition" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Messaging">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--endpoint 0..* CapabilityStatement.Endpoint--><xsl:if test="f:endpoint">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="endpoint">
            <xsl:for-each select="f:endpoint">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Endpoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reliableCache 0..1 unsignedInt (json type: number)--><xsl:if test="f:reliableCache">
         <xsl:if test="f:reliableCache/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="reliableCache">
               <xsl:value-of select="f:reliableCache/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:reliableCache[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reliableCache">
               <xsl:apply-templates select="f:reliableCache" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--supportedMessage 0..* CapabilityStatement.SupportedMessage--><xsl:if test="f:supportedMessage">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="supportedMessage">
            <xsl:for-each select="f:supportedMessage">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.SupportedMessage"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--event 0..* CapabilityStatement.Event--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <map>
                  <xsl:apply-templates select="." mode="CapabilityStatement.Event"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Endpoint">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--protocol 1..1 Coding--><xsl:if test="f:protocol">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="protocol">
            <xsl:apply-templates select="f:protocol" mode="Coding"/>
         </map>
      </xsl:if>
          <!--address 1..1 uri (json type: string)--><xsl:if test="f:address">
         <xsl:if test="f:address/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="address">
               <xsl:value-of select="f:address/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:address[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_address">
               <xsl:apply-templates select="f:address" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.SupportedMessage">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--mode 1..1 EventCapabilityMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--definition 1..1 Reference--><xsl:if test="f:definition">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
            <xsl:apply-templates select="f:definition" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Event">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 Coding--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="Coding"/>
         </map>
      </xsl:if>
          <!--category 0..1 MessageSignificanceCategory (json type: string)--><xsl:if test="f:category">
         <xsl:if test="f:category/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="category">
               <xsl:value-of select="f:category/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:category[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_category">
               <xsl:apply-templates select="f:category" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--mode 1..1 EventCapabilityMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--focus 1..1 ResourceType (json type: string)--><xsl:if test="f:focus">
         <xsl:if test="f:focus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="focus">
               <xsl:value-of select="f:focus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:focus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_focus">
               <xsl:apply-templates select="f:focus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--request 1..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
          <!--response 1..1 Reference--><xsl:if test="f:response">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="response">
            <xsl:apply-templates select="f:response" mode="Reference"/>
         </map>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatement.Document">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--mode 1..1 DocumentMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--profile 1..1 Reference--><xsl:if test="f:profile">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="profile">
            <xsl:apply-templates select="f:profile" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a capability statement is intended to be used.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CapabilityStatementKind">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The mode of a message capability statement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EventCapabilityMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How the system supports versioning for a resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ResourceVersionPolicy">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The impact of the content of a message.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MessageSignificanceCategory">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Whether the application produces or consumes documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The mode of a RESTful capability statement.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="RestfulCapabilityMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates whether an application accepts unknown elements or extensions when reading resources.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="UnknownContentCode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Operations supported by REST at the type or instance level.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="TypeRestfulInteraction">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Operations supported by REST at the system level.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SystemRestfulInteraction">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates how the server supports conditional read.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConditionalReadStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of flags that defines how references are supported.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ReferenceHandlingPolicy">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code that indicates how the server supports conditional delete.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConditionalDeleteStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">CarePlan</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--definition 0..* Reference--><xsl:if test="f:definition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
            <xsl:for-each select="f:definition">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--basedOn 0..* Reference--><xsl:if test="f:basedOn">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="basedOn">
            <xsl:for-each select="f:basedOn">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--replaces 0..* Reference--><xsl:if test="f:replaces">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="replaces">
            <xsl:for-each select="f:replaces">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--partOf 0..* Reference--><xsl:if test="f:partOf">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="partOf">
            <xsl:for-each select="f:partOf">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 CarePlanStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--intent 1..1 CarePlanIntent (json type: string)--><xsl:if test="f:intent">
         <xsl:if test="f:intent/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="intent">
               <xsl:value-of select="f:intent/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:intent[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_intent">
               <xsl:apply-templates select="f:intent" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 0..* CodeableConcept--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--author 0..* Reference--><xsl:if test="f:author">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:for-each select="f:author">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--careTeam 0..* Reference--><xsl:if test="f:careTeam">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="careTeam">
            <xsl:for-each select="f:careTeam">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--addresses 0..* Reference--><xsl:if test="f:addresses">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="addresses">
            <xsl:for-each select="f:addresses">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--supportingInfo 0..* Reference--><xsl:if test="f:supportingInfo">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="supportingInfo">
            <xsl:for-each select="f:supportingInfo">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--goal 0..* Reference--><xsl:if test="f:goal">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="goal">
            <xsl:for-each select="f:goal">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--activity 0..* CarePlan.Activity--><xsl:if test="f:activity">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="activity">
            <xsl:for-each select="f:activity">
               <map>
                  <xsl:apply-templates select="." mode="CarePlan.Activity"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Activity">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--outcomeCodeableConcept 0..* CodeableConcept--><xsl:if test="f:outcomeCodeableConcept">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="outcomeCodeableConcept">
            <xsl:for-each select="f:outcomeCodeableConcept">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--outcomeReference 0..* Reference--><xsl:if test="f:outcomeReference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="outcomeReference">
            <xsl:for-each select="f:outcomeReference">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--progress 0..* Annotation--><xsl:if test="f:progress">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="progress">
            <xsl:for-each select="f:progress">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reference 0..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
          <!--detail 0..1 CarePlan.Detail--><xsl:if test="f:detail">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:apply-templates select="f:detail" mode="CarePlan.Detail"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlan.Detail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--definition 0..1 Reference--><xsl:if test="f:definition">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
            <xsl:apply-templates select="f:definition" mode="Reference"/>
         </map>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--reasonCode 0..* CodeableConcept--><xsl:if test="f:reasonCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonCode">
            <xsl:for-each select="f:reasonCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reasonReference 0..* Reference--><xsl:if test="f:reasonReference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonReference">
            <xsl:for-each select="f:reasonReference">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--goal 0..* Reference--><xsl:if test="f:goal">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="goal">
            <xsl:for-each select="f:goal">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 CarePlanActivityStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--statusReason 0..1 string (json type: string)--><xsl:if test="f:statusReason">
         <xsl:if test="f:statusReason/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="statusReason">
               <xsl:value-of select="f:statusReason/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:statusReason[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_statusReason">
               <xsl:apply-templates select="f:statusReason" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--prohibited 0..1 boolean (json type: boolean)--><xsl:if test="f:prohibited">
         <xsl:if test="f:prohibited/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="prohibited">
               <xsl:value-of select="f:prohibited/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:prohibited[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_prohibited">
               <xsl:apply-templates select="f:prohibited" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
            <!--scheduledTiming 1..1 Timing--><xsl:if test="f:scheduledTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledTiming">
            <xsl:apply-templates select="f:scheduledTiming" mode="Timing"/>
         </map>
      </xsl:if>
            <!--scheduledPeriod 1..1 Period--><xsl:if test="f:scheduledPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledPeriod">
            <xsl:apply-templates select="f:scheduledPeriod" mode="Period"/>
         </map>
      </xsl:if>
            <!--scheduledString 1..1 string (json type: string)--><xsl:if test="f:scheduledString">
         <xsl:if test="f:scheduledString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="scheduledString">
               <xsl:value-of select="f:scheduledString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:scheduledString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_scheduledString">
               <xsl:apply-templates select="f:scheduledString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
          <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
          <!--performer 0..* Reference--><xsl:if test="f:performer">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="performer">
            <xsl:for-each select="f:performer">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          
            
            <!--productCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:productCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="productCodeableConcept">
            <xsl:apply-templates select="f:productCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
            <!--productReference 1..1 Reference--><xsl:if test="f:productReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="productReference">
            <xsl:apply-templates select="f:productReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--dailyAmount 0..1 Quantity--><xsl:if test="f:dailyAmount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dailyAmount">
            <xsl:apply-templates select="f:dailyAmount" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--quantity 0..1 Quantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates where the activity is at in its overall life cycle.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanActivityStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes indicating the degree of authority/intentionality associated with a care plan</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CarePlanIntent">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CareTeam">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">CareTeam</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 CareTeamStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 0..* CodeableConcept--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--participant 0..* CareTeam.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="CareTeam.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reasonCode 0..* CodeableConcept--><xsl:if test="f:reasonCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonCode">
            <xsl:for-each select="f:reasonCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reasonReference 0..* Reference--><xsl:if test="f:reasonReference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonReference">
            <xsl:for-each select="f:reasonReference">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--managingOrganization 0..* Reference--><xsl:if test="f:managingOrganization">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="managingOrganization">
            <xsl:for-each select="f:managingOrganization">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CareTeam.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--role 0..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--member 0..1 Reference--><xsl:if test="f:member">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="member">
            <xsl:apply-templates select="f:member" mode="Reference"/>
         </map>
      </xsl:if>
          <!--onBehalfOf 0..1 Reference--><xsl:if test="f:onBehalfOf">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onBehalfOf">
            <xsl:apply-templates select="f:onBehalfOf" mode="Reference"/>
         </map>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the status of the care team.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CareTeamStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ChargeItem">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ChargeItem</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--definition 0..* uri (json type: string)--><xsl:if test="f:definition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
            <xsl:for-each select="f:definition">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:definition[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_definition">
               <xsl:for-each select="f:definition">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 ChargeItemStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--partOf 0..* Reference--><xsl:if test="f:partOf">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="partOf">
            <xsl:for-each select="f:partOf">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          
            
            <!--occurrenceDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:occurrenceDateTime">
         <xsl:if test="f:occurrenceDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="occurrenceDateTime">
               <xsl:value-of select="f:occurrenceDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:occurrenceDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_occurrenceDateTime">
               <xsl:apply-templates select="f:occurrenceDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--occurrencePeriod 1..1 Period--><xsl:if test="f:occurrencePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="occurrencePeriod">
            <xsl:apply-templates select="f:occurrencePeriod" mode="Period"/>
         </map>
      </xsl:if>
            <!--occurrenceTiming 1..1 Timing--><xsl:if test="f:occurrenceTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="occurrenceTiming">
            <xsl:apply-templates select="f:occurrenceTiming" mode="Timing"/>
         </map>
      </xsl:if>
          
          <!--participant 0..* ChargeItem.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="ChargeItem.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--performingOrganization 0..1 Reference--><xsl:if test="f:performingOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="performingOrganization">
            <xsl:apply-templates select="f:performingOrganization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--requestingOrganization 0..1 Reference--><xsl:if test="f:requestingOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestingOrganization">
            <xsl:apply-templates select="f:requestingOrganization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--quantity 0..1 Quantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--bodysite 0..* CodeableConcept--><xsl:if test="f:bodysite">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="bodysite">
            <xsl:for-each select="f:bodysite">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--factorOverride 0..1 decimal (json type: number)--><xsl:if test="f:factorOverride">
         <xsl:if test="f:factorOverride/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factorOverride">
               <xsl:value-of select="f:factorOverride/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factorOverride[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factorOverride">
               <xsl:apply-templates select="f:factorOverride" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--priceOverride 0..1 Money--><xsl:if test="f:priceOverride">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priceOverride">
            <xsl:apply-templates select="f:priceOverride" mode="Money"/>
         </map>
      </xsl:if>
          <!--overrideReason 0..1 string (json type: string)--><xsl:if test="f:overrideReason">
         <xsl:if test="f:overrideReason/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="overrideReason">
               <xsl:value-of select="f:overrideReason/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:overrideReason[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_overrideReason">
               <xsl:apply-templates select="f:overrideReason" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--enterer 0..1 Reference--><xsl:if test="f:enterer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="enterer">
            <xsl:apply-templates select="f:enterer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--enteredDate 0..1 dateTime (json type: string)--><xsl:if test="f:enteredDate">
         <xsl:if test="f:enteredDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="enteredDate">
               <xsl:value-of select="f:enteredDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:enteredDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_enteredDate">
               <xsl:apply-templates select="f:enteredDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--service 0..* Reference--><xsl:if test="f:service">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:for-each select="f:service">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--account 0..* Reference--><xsl:if test="f:account">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="account">
            <xsl:for-each select="f:account">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--supportingInformation 0..* Reference--><xsl:if test="f:supportingInformation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="supportingInformation">
            <xsl:for-each select="f:supportingInformation">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ChargeItem.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--role 0..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--actor 1..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes identifying the stage lifecycle stage of a ChargeItem</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ChargeItemStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Claim</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 FinancialResourceStatusCodes (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subType 0..* CodeableConcept--><xsl:if test="f:subType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subType">
            <xsl:for-each select="f:subType">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--use 0..1 Use (json type: string)--><xsl:if test="f:use">
         <xsl:if test="f:use/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="use">
               <xsl:value-of select="f:use/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:use[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_use">
               <xsl:apply-templates select="f:use" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          <!--billablePeriod 0..1 Period--><xsl:if test="f:billablePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="billablePeriod">
            <xsl:apply-templates select="f:billablePeriod" mode="Period"/>
         </map>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--enterer 0..1 Reference--><xsl:if test="f:enterer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="enterer">
            <xsl:apply-templates select="f:enterer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--insurer 0..1 Reference--><xsl:if test="f:insurer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="insurer">
            <xsl:apply-templates select="f:insurer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--priority 0..1 CodeableConcept--><xsl:if test="f:priority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
            <xsl:apply-templates select="f:priority" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--fundsReserve 0..1 CodeableConcept--><xsl:if test="f:fundsReserve">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fundsReserve">
            <xsl:apply-templates select="f:fundsReserve" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--related 0..* Claim.Related--><xsl:if test="f:related">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="related">
            <xsl:for-each select="f:related">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Related"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--prescription 0..1 Reference--><xsl:if test="f:prescription">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="prescription">
            <xsl:apply-templates select="f:prescription" mode="Reference"/>
         </map>
      </xsl:if>
          <!--originalPrescription 0..1 Reference--><xsl:if test="f:originalPrescription">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="originalPrescription">
            <xsl:apply-templates select="f:originalPrescription" mode="Reference"/>
         </map>
      </xsl:if>
          <!--payee 0..1 Claim.Payee--><xsl:if test="f:payee">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="payee">
            <xsl:apply-templates select="f:payee" mode="Claim.Payee"/>
         </map>
      </xsl:if>
          <!--referral 0..1 Reference--><xsl:if test="f:referral">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="referral">
            <xsl:apply-templates select="f:referral" mode="Reference"/>
         </map>
      </xsl:if>
          <!--facility 0..1 Reference--><xsl:if test="f:facility">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="facility">
            <xsl:apply-templates select="f:facility" mode="Reference"/>
         </map>
      </xsl:if>
          <!--careTeam 0..* Claim.CareTeam--><xsl:if test="f:careTeam">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="careTeam">
            <xsl:for-each select="f:careTeam">
               <map>
                  <xsl:apply-templates select="." mode="Claim.CareTeam"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--information 0..* Claim.Information--><xsl:if test="f:information">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="information">
            <xsl:for-each select="f:information">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Information"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--diagnosis 0..* Claim.Diagnosis--><xsl:if test="f:diagnosis">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosis">
            <xsl:for-each select="f:diagnosis">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Diagnosis"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--procedure 0..* Claim.Procedure--><xsl:if test="f:procedure">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="procedure">
            <xsl:for-each select="f:procedure">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Procedure"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--insurance 0..* Claim.Insurance--><xsl:if test="f:insurance">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="insurance">
            <xsl:for-each select="f:insurance">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Insurance"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--accident 0..1 Claim.Accident--><xsl:if test="f:accident">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="accident">
            <xsl:apply-templates select="f:accident" mode="Claim.Accident"/>
         </map>
      </xsl:if>
          <!--employmentImpacted 0..1 Period--><xsl:if test="f:employmentImpacted">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="employmentImpacted">
            <xsl:apply-templates select="f:employmentImpacted" mode="Period"/>
         </map>
      </xsl:if>
          <!--hospitalization 0..1 Period--><xsl:if test="f:hospitalization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="hospitalization">
            <xsl:apply-templates select="f:hospitalization" mode="Period"/>
         </map>
      </xsl:if>
          <!--item 0..* Claim.Item--><xsl:if test="f:item">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:for-each select="f:item">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Item"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--total 0..1 Money--><xsl:if test="f:total">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="total">
            <xsl:apply-templates select="f:total" mode="Money"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Related">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--claim 0..1 Reference--><xsl:if test="f:claim">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="claim">
            <xsl:apply-templates select="f:claim" mode="Reference"/>
         </map>
      </xsl:if>
          <!--relationship 0..1 CodeableConcept--><xsl:if test="f:relationship">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="relationship">
            <xsl:apply-templates select="f:relationship" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--reference 0..1 Identifier--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Identifier"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Payee">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--resourceType 0..1 Coding--><xsl:if test="f:resourceType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">
            <xsl:apply-templates select="f:resourceType" mode="Coding"/>
         </map>
      </xsl:if>
          <!--party 0..1 Reference--><xsl:if test="f:party">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="party">
            <xsl:apply-templates select="f:party" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.CareTeam">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--provider 1..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--responsible 0..1 boolean (json type: boolean)--><xsl:if test="f:responsible">
         <xsl:if test="f:responsible/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="responsible">
               <xsl:value-of select="f:responsible/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:responsible[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_responsible">
               <xsl:apply-templates select="f:responsible" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--role 0..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--qualification 0..1 CodeableConcept--><xsl:if test="f:qualification">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="qualification">
            <xsl:apply-templates select="f:qualification" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Information">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 1..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          
            
            <!--timingDate 1..1 date (json type: string)--><xsl:if test="f:timingDate">
         <xsl:if test="f:timingDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDate">
               <xsl:value-of select="f:timingDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:timingDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_timingDate">
               <xsl:apply-templates select="f:timingDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--timingPeriod 1..1 Period--><xsl:if test="f:timingPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingPeriod">
            <xsl:apply-templates select="f:timingPeriod" mode="Period"/>
         </map>
      </xsl:if>
          
          
            
            <!--valueString 1..1 string (json type: string)--><xsl:if test="f:valueString">
         <xsl:if test="f:valueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString">
               <xsl:value-of select="f:valueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueString">
               <xsl:apply-templates select="f:valueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--valueQuantity 1..1 Quantity--><xsl:if test="f:valueQuantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueQuantity">
            <xsl:apply-templates select="f:valueQuantity" mode="Quantity"/>
         </map>
      </xsl:if>
            <!--valueAttachment 1..1 Attachment--><xsl:if test="f:valueAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueAttachment">
            <xsl:apply-templates select="f:valueAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--valueReference 1..1 Reference--><xsl:if test="f:valueReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueReference">
            <xsl:apply-templates select="f:valueReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--reason 0..1 CodeableConcept--><xsl:if test="f:reason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:apply-templates select="f:reason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Diagnosis">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
            <!--diagnosisCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:diagnosisCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="diagnosisCodeableConcept">
            <xsl:apply-templates select="f:diagnosisCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
            <!--diagnosisReference 1..1 Reference--><xsl:if test="f:diagnosisReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosisReference">
            <xsl:apply-templates select="f:diagnosisReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--packageCode 0..1 CodeableConcept--><xsl:if test="f:packageCode">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="packageCode">
            <xsl:apply-templates select="f:packageCode" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Procedure">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
            <!--procedureCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:procedureCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="procedureCodeableConcept">
            <xsl:apply-templates select="f:procedureCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
            <!--procedureReference 1..1 Reference--><xsl:if test="f:procedureReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="procedureReference">
            <xsl:apply-templates select="f:procedureReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Insurance">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--focal 1..1 boolean (json type: boolean)--><xsl:if test="f:focal">
         <xsl:if test="f:focal/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="focal">
               <xsl:value-of select="f:focal/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:focal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_focal">
               <xsl:apply-templates select="f:focal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--coverage 1..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
          <!--businessArrangement 0..1 string (json type: string)--><xsl:if test="f:businessArrangement">
         <xsl:if test="f:businessArrangement/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement">
               <xsl:value-of select="f:businessArrangement/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:businessArrangement[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_businessArrangement">
               <xsl:apply-templates select="f:businessArrangement" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--preAuthRef 0..* string (json type: string)--><xsl:if test="f:preAuthRef">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="preAuthRef">
            <xsl:for-each select="f:preAuthRef">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:preAuthRef[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_preAuthRef">
               <xsl:for-each select="f:preAuthRef">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--claimResponse 0..1 Reference--><xsl:if test="f:claimResponse">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="claimResponse">
            <xsl:apply-templates select="f:claimResponse" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Accident">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--date 1..1 date (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          
            
            <!--locationAddress 1..1 Address--><xsl:if test="f:locationAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="locationAddress">
            <xsl:apply-templates select="f:locationAddress" mode="Address"/>
         </map>
      </xsl:if>
            <!--locationReference 1..1 Reference--><xsl:if test="f:locationReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="locationReference">
            <xsl:apply-templates select="f:locationReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Item">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--careTeamLinkId 0..* positiveInt (json type: number)--><xsl:if test="f:careTeamLinkId">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="careTeamLinkId">
            <xsl:for-each select="f:careTeamLinkId">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:careTeamLinkId[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_careTeamLinkId">
               <xsl:for-each select="f:careTeamLinkId">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--diagnosisLinkId 0..* positiveInt (json type: number)--><xsl:if test="f:diagnosisLinkId">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosisLinkId">
            <xsl:for-each select="f:diagnosisLinkId">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:diagnosisLinkId[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_diagnosisLinkId">
               <xsl:for-each select="f:diagnosisLinkId">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--procedureLinkId 0..* positiveInt (json type: number)--><xsl:if test="f:procedureLinkId">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="procedureLinkId">
            <xsl:for-each select="f:procedureLinkId">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:procedureLinkId[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_procedureLinkId">
               <xsl:for-each select="f:procedureLinkId">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--informationLinkId 0..* positiveInt (json type: number)--><xsl:if test="f:informationLinkId">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="informationLinkId">
            <xsl:for-each select="f:informationLinkId">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:informationLinkId[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_informationLinkId">
               <xsl:for-each select="f:informationLinkId">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--revenue 0..1 CodeableConcept--><xsl:if test="f:revenue">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="revenue">
            <xsl:apply-templates select="f:revenue" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--service 0..1 CodeableConcept--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--modifier 0..* CodeableConcept--><xsl:if test="f:modifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifier">
            <xsl:for-each select="f:modifier">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--programCode 0..* CodeableConcept--><xsl:if test="f:programCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="programCode">
            <xsl:for-each select="f:programCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          
            
            <!--servicedDate 1..1 date (json type: string)--><xsl:if test="f:servicedDate">
         <xsl:if test="f:servicedDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="servicedDate">
               <xsl:value-of select="f:servicedDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:servicedDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_servicedDate">
               <xsl:apply-templates select="f:servicedDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--servicedPeriod 1..1 Period--><xsl:if test="f:servicedPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="servicedPeriod">
            <xsl:apply-templates select="f:servicedPeriod" mode="Period"/>
         </map>
      </xsl:if>
          
          
            
            <!--locationCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:locationCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions"
              key="locationCodeableConcept">
            <xsl:apply-templates select="f:locationCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
            <!--locationAddress 1..1 Address--><xsl:if test="f:locationAddress">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="locationAddress">
            <xsl:apply-templates select="f:locationAddress" mode="Address"/>
         </map>
      </xsl:if>
            <!--locationReference 1..1 Reference--><xsl:if test="f:locationReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="locationReference">
            <xsl:apply-templates select="f:locationReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--quantity 0..1 Quantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
          <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
          <!--udi 0..* Reference--><xsl:if test="f:udi">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="udi">
            <xsl:for-each select="f:udi">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--bodySite 0..1 CodeableConcept--><xsl:if test="f:bodySite">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bodySite">
            <xsl:apply-templates select="f:bodySite" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subSite 0..* CodeableConcept--><xsl:if test="f:subSite">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subSite">
            <xsl:for-each select="f:subSite">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--encounter 0..* Reference--><xsl:if test="f:encounter">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:for-each select="f:encounter">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--detail 0..* Claim.Detail--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="Claim.Detail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.Detail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--revenue 0..1 CodeableConcept--><xsl:if test="f:revenue">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="revenue">
            <xsl:apply-templates select="f:revenue" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--service 0..1 CodeableConcept--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--modifier 0..* CodeableConcept--><xsl:if test="f:modifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifier">
            <xsl:for-each select="f:modifier">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--programCode 0..* CodeableConcept--><xsl:if test="f:programCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="programCode">
            <xsl:for-each select="f:programCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--quantity 0..1 Quantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
          <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
          <!--udi 0..* Reference--><xsl:if test="f:udi">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="udi">
            <xsl:for-each select="f:udi">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--subDetail 0..* Claim.SubDetail--><xsl:if test="f:subDetail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subDetail">
            <xsl:for-each select="f:subDetail">
               <map>
                  <xsl:apply-templates select="." mode="Claim.SubDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Claim.SubDetail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--revenue 0..1 CodeableConcept--><xsl:if test="f:revenue">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="revenue">
            <xsl:apply-templates select="f:revenue" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--service 0..1 CodeableConcept--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--modifier 0..* CodeableConcept--><xsl:if test="f:modifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifier">
            <xsl:for-each select="f:modifier">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--programCode 0..* CodeableConcept--><xsl:if test="f:programCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="programCode">
            <xsl:for-each select="f:programCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--quantity 0..1 Quantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
          <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
          <!--udi 0..* Reference--><xsl:if test="f:udi">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="udi">
            <xsl:for-each select="f:udi">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Complete, proposed, exploratory, other</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Use">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code specifying the state of the resource instance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="FinancialResourceStatusCodes">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ClaimResponse</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 FinancialResourceStatusCodes (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--insurer 0..1 Reference--><xsl:if test="f:insurer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="insurer">
            <xsl:apply-templates select="f:insurer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--requestProvider 0..1 Reference--><xsl:if test="f:requestProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestProvider">
            <xsl:apply-templates select="f:requestProvider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--requestOrganization 0..1 Reference--><xsl:if test="f:requestOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestOrganization">
            <xsl:apply-templates select="f:requestOrganization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--request 0..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
          <!--outcome 0..1 CodeableConcept--><xsl:if test="f:outcome">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
            <xsl:apply-templates select="f:outcome" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--disposition 0..1 string (json type: string)--><xsl:if test="f:disposition">
         <xsl:if test="f:disposition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition">
               <xsl:value-of select="f:disposition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:disposition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_disposition">
               <xsl:apply-templates select="f:disposition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--payeeType 0..1 CodeableConcept--><xsl:if test="f:payeeType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="payeeType">
            <xsl:apply-templates select="f:payeeType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--item 0..* ClaimResponse.Item--><xsl:if test="f:item">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:for-each select="f:item">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Item"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--addItem 0..* ClaimResponse.AddItem--><xsl:if test="f:addItem">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="addItem">
            <xsl:for-each select="f:addItem">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.AddItem"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--error 0..* ClaimResponse.Error--><xsl:if test="f:error">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="error">
            <xsl:for-each select="f:error">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Error"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--totalCost 0..1 Money--><xsl:if test="f:totalCost">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="totalCost">
            <xsl:apply-templates select="f:totalCost" mode="Money"/>
         </map>
      </xsl:if>
          <!--unallocDeductable 0..1 Money--><xsl:if test="f:unallocDeductable">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unallocDeductable">
            <xsl:apply-templates select="f:unallocDeductable" mode="Money"/>
         </map>
      </xsl:if>
          <!--totalBenefit 0..1 Money--><xsl:if test="f:totalBenefit">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="totalBenefit">
            <xsl:apply-templates select="f:totalBenefit" mode="Money"/>
         </map>
      </xsl:if>
          <!--payment 0..1 ClaimResponse.Payment--><xsl:if test="f:payment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="payment">
            <xsl:apply-templates select="f:payment" mode="ClaimResponse.Payment"/>
         </map>
      </xsl:if>
          <!--reserved 0..1 Coding--><xsl:if test="f:reserved">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reserved">
            <xsl:apply-templates select="f:reserved" mode="Coding"/>
         </map>
      </xsl:if>
          <!--form 0..1 CodeableConcept--><xsl:if test="f:form">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="form">
            <xsl:apply-templates select="f:form" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--processNote 0..* ClaimResponse.ProcessNote--><xsl:if test="f:processNote">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="processNote">
            <xsl:for-each select="f:processNote">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.ProcessNote"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--communicationRequest 0..* Reference--><xsl:if test="f:communicationRequest">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="communicationRequest">
            <xsl:for-each select="f:communicationRequest">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--insurance 0..* ClaimResponse.Insurance--><xsl:if test="f:insurance">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="insurance">
            <xsl:for-each select="f:insurance">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Insurance"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Item">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequenceLinkId 1..1 positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <xsl:if test="f:sequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
               <xsl:value-of select="f:sequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:apply-templates select="f:sequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--noteNumber 0..* positiveInt (json type: number)--><xsl:if test="f:noteNumber">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber">
            <xsl:for-each select="f:noteNumber">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:noteNumber[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_noteNumber">
               <xsl:for-each select="f:noteNumber">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--adjudication 0..* ClaimResponse.Adjudication--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--detail 0..* ClaimResponse.Detail--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Detail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Adjudication">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--category 1..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--reason 0..1 CodeableConcept--><xsl:if test="f:reason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:apply-templates select="f:reason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--amount 0..1 Money--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="Money"/>
         </map>
      </xsl:if>
          <!--value 0..1 decimal (json type: number)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Detail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequenceLinkId 1..1 positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <xsl:if test="f:sequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
               <xsl:value-of select="f:sequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:apply-templates select="f:sequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--noteNumber 0..* positiveInt (json type: number)--><xsl:if test="f:noteNumber">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber">
            <xsl:for-each select="f:noteNumber">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:noteNumber[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_noteNumber">
               <xsl:for-each select="f:noteNumber">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--adjudication 0..* ClaimResponse.Adjudication--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--subDetail 0..* ClaimResponse.SubDetail--><xsl:if test="f:subDetail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subDetail">
            <xsl:for-each select="f:subDetail">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.SubDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.SubDetail">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequenceLinkId 1..1 positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <xsl:if test="f:sequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
               <xsl:value-of select="f:sequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:apply-templates select="f:sequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--noteNumber 0..* positiveInt (json type: number)--><xsl:if test="f:noteNumber">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber">
            <xsl:for-each select="f:noteNumber">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:noteNumber[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_noteNumber">
               <xsl:for-each select="f:noteNumber">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--adjudication 0..* ClaimResponse.Adjudication--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.AddItem">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequenceLinkId 0..* positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
            <xsl:for-each select="f:sequenceLinkId">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:for-each select="f:sequenceLinkId">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--revenue 0..1 CodeableConcept--><xsl:if test="f:revenue">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="revenue">
            <xsl:apply-templates select="f:revenue" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--service 0..1 CodeableConcept--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--modifier 0..* CodeableConcept--><xsl:if test="f:modifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifier">
            <xsl:for-each select="f:modifier">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--fee 0..1 Money--><xsl:if test="f:fee">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fee">
            <xsl:apply-templates select="f:fee" mode="Money"/>
         </map>
      </xsl:if>
          <!--noteNumber 0..* positiveInt (json type: number)--><xsl:if test="f:noteNumber">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber">
            <xsl:for-each select="f:noteNumber">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:noteNumber[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_noteNumber">
               <xsl:for-each select="f:noteNumber">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--adjudication 0..* ClaimResponse.Adjudication--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--detail 0..* ClaimResponse.Detail1--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Detail1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Detail1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--revenue 0..1 CodeableConcept--><xsl:if test="f:revenue">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="revenue">
            <xsl:apply-templates select="f:revenue" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--service 0..1 CodeableConcept--><xsl:if test="f:service">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="service">
            <xsl:apply-templates select="f:service" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--modifier 0..* CodeableConcept--><xsl:if test="f:modifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="modifier">
            <xsl:for-each select="f:modifier">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--fee 0..1 Money--><xsl:if test="f:fee">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="fee">
            <xsl:apply-templates select="f:fee" mode="Money"/>
         </map>
      </xsl:if>
          <!--noteNumber 0..* positiveInt (json type: number)--><xsl:if test="f:noteNumber">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="noteNumber">
            <xsl:for-each select="f:noteNumber">
               <xsl:choose>
                  <xsl:when test="@value">
                     <number>
                        <xsl:value-of select="@value"/>
                     </number>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:noteNumber[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_noteNumber">
               <xsl:for-each select="f:noteNumber">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--adjudication 0..* ClaimResponse.Adjudication--><xsl:if test="f:adjudication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="adjudication">
            <xsl:for-each select="f:adjudication">
               <map>
                  <xsl:apply-templates select="." mode="ClaimResponse.Adjudication"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Error">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequenceLinkId 0..1 positiveInt (json type: number)--><xsl:if test="f:sequenceLinkId">
         <xsl:if test="f:sequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequenceLinkId">
               <xsl:value-of select="f:sequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequenceLinkId">
               <xsl:apply-templates select="f:sequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--detailSequenceLinkId 0..1 positiveInt (json type: number)--><xsl:if test="f:detailSequenceLinkId">
         <xsl:if test="f:detailSequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="detailSequenceLinkId">
               <xsl:value-of select="f:detailSequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:detailSequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_detailSequenceLinkId">
               <xsl:apply-templates select="f:detailSequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subdetailSequenceLinkId 0..1 positiveInt (json type: number)--><xsl:if test="f:subdetailSequenceLinkId">
         <xsl:if test="f:subdetailSequenceLinkId/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions"
                    key="subdetailSequenceLinkId">
               <xsl:value-of select="f:subdetailSequenceLinkId/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:subdetailSequenceLinkId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_subdetailSequenceLinkId">
               <xsl:apply-templates select="f:subdetailSequenceLinkId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Payment">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--adjustment 0..1 Money--><xsl:if test="f:adjustment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="adjustment">
            <xsl:apply-templates select="f:adjustment" mode="Money"/>
         </map>
      </xsl:if>
          <!--adjustmentReason 0..1 CodeableConcept--><xsl:if test="f:adjustmentReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="adjustmentReason">
            <xsl:apply-templates select="f:adjustmentReason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--date 0..1 date (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--amount 0..1 Money--><xsl:if test="f:amount">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="amount">
            <xsl:apply-templates select="f:amount" mode="Money"/>
         </map>
      </xsl:if>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.ProcessNote">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--number 0..1 positiveInt (json type: number)--><xsl:if test="f:number">
         <xsl:if test="f:number/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="number">
               <xsl:value-of select="f:number/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:number[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_number">
               <xsl:apply-templates select="f:number" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--language 0..1 CodeableConcept--><xsl:if test="f:language">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="language">
            <xsl:apply-templates select="f:language" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the adjudication details from the processing of a Claim resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClaimResponse.Insurance">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--sequence 1..1 positiveInt (json type: number)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--focal 1..1 boolean (json type: boolean)--><xsl:if test="f:focal">
         <xsl:if test="f:focal/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="focal">
               <xsl:value-of select="f:focal/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:focal[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_focal">
               <xsl:apply-templates select="f:focal" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--coverage 1..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
          <!--businessArrangement 0..1 string (json type: string)--><xsl:if test="f:businessArrangement">
         <xsl:if test="f:businessArrangement/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement">
               <xsl:value-of select="f:businessArrangement/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:businessArrangement[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_businessArrangement">
               <xsl:apply-templates select="f:businessArrangement" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--preAuthRef 0..* string (json type: string)--><xsl:if test="f:preAuthRef">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="preAuthRef">
            <xsl:for-each select="f:preAuthRef">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:preAuthRef[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_preAuthRef">
               <xsl:for-each select="f:preAuthRef">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--claimResponse 0..1 Reference--><xsl:if test="f:claimResponse">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="claimResponse">
            <xsl:apply-templates select="f:claimResponse" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ClinicalImpression</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 ClinicalImpressionStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          
            
            <!--effectiveDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:effectiveDateTime">
         <xsl:if test="f:effectiveDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveDateTime">
               <xsl:value-of select="f:effectiveDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:effectiveDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_effectiveDateTime">
               <xsl:apply-templates select="f:effectiveDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--effectivePeriod 1..1 Period--><xsl:if test="f:effectivePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="effectivePeriod">
            <xsl:apply-templates select="f:effectivePeriod" mode="Period"/>
         </map>
      </xsl:if>
          
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--assessor 0..1 Reference--><xsl:if test="f:assessor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="assessor">
            <xsl:apply-templates select="f:assessor" mode="Reference"/>
         </map>
      </xsl:if>
          <!--previous 0..1 Reference--><xsl:if test="f:previous">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="previous">
            <xsl:apply-templates select="f:previous" mode="Reference"/>
         </map>
      </xsl:if>
          <!--problem 0..* Reference--><xsl:if test="f:problem">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="problem">
            <xsl:for-each select="f:problem">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--investigation 0..* ClinicalImpression.Investigation--><xsl:if test="f:investigation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="investigation">
            <xsl:for-each select="f:investigation">
               <map>
                  <xsl:apply-templates select="." mode="ClinicalImpression.Investigation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--protocol 0..* uri (json type: string)--><xsl:if test="f:protocol">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="protocol">
            <xsl:for-each select="f:protocol">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:protocol[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_protocol">
               <xsl:for-each select="f:protocol">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--summary 0..1 string (json type: string)--><xsl:if test="f:summary">
         <xsl:if test="f:summary/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="summary">
               <xsl:value-of select="f:summary/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:summary[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_summary">
               <xsl:apply-templates select="f:summary" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--finding 0..* ClinicalImpression.Finding--><xsl:if test="f:finding">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="finding">
            <xsl:for-each select="f:finding">
               <map>
                  <xsl:apply-templates select="." mode="ClinicalImpression.Finding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--prognosisCodeableConcept 0..* CodeableConcept--><xsl:if test="f:prognosisCodeableConcept">
         <array xmlns="http://www.w3.org/2005/xpath-functions"
                key="prognosisCodeableConcept">
            <xsl:for-each select="f:prognosisCodeableConcept">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--prognosisReference 0..* Reference--><xsl:if test="f:prognosisReference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="prognosisReference">
            <xsl:for-each select="f:prognosisReference">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--action 0..* Reference--><xsl:if test="f:action">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:for-each select="f:action">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.Investigation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--item 0..* Reference--><xsl:if test="f:item">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="item">
            <xsl:for-each select="f:item">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpression.Finding">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--itemCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:itemCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="itemCodeableConcept">
            <xsl:apply-templates select="f:itemCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
            <!--itemReference 1..1 Reference--><xsl:if test="f:itemReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="itemReference">
            <xsl:apply-templates select="f:itemReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--basis 0..1 string (json type: string)--><xsl:if test="f:basis">
         <xsl:if test="f:basis/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="basis">
               <xsl:value-of select="f:basis/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:basis[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_basis">
               <xsl:apply-templates select="f:basis" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The workflow state of a clinical impression.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ClinicalImpressionStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">CodeSystem</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 PublicationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--contact 0..* ContactDetail--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 markdown (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--useContext 0..* UsageContext--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="UsageContext"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--jurisdiction 0..* CodeableConcept--><xsl:if test="f:jurisdiction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="jurisdiction">
            <xsl:for-each select="f:jurisdiction">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--purpose 0..1 markdown (json type: string)--><xsl:if test="f:purpose">
         <xsl:if test="f:purpose/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose">
               <xsl:value-of select="f:purpose/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:purpose[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_purpose">
               <xsl:apply-templates select="f:purpose" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--copyright 0..1 markdown (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--caseSensitive 0..1 boolean (json type: boolean)--><xsl:if test="f:caseSensitive">
         <xsl:if test="f:caseSensitive/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="caseSensitive">
               <xsl:value-of select="f:caseSensitive/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:caseSensitive[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_caseSensitive">
               <xsl:apply-templates select="f:caseSensitive" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--valueSet 0..1 uri (json type: string)--><xsl:if test="f:valueSet">
         <xsl:if test="f:valueSet/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueSet">
               <xsl:value-of select="f:valueSet/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueSet[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueSet">
               <xsl:apply-templates select="f:valueSet" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--hierarchyMeaning 0..1 CodeSystemHierarchyMeaning (json type: string)--><xsl:if test="f:hierarchyMeaning">
         <xsl:if test="f:hierarchyMeaning/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="hierarchyMeaning">
               <xsl:value-of select="f:hierarchyMeaning/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:hierarchyMeaning[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_hierarchyMeaning">
               <xsl:apply-templates select="f:hierarchyMeaning" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--compositional 0..1 boolean (json type: boolean)--><xsl:if test="f:compositional">
         <xsl:if test="f:compositional/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="compositional">
               <xsl:value-of select="f:compositional/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:compositional[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_compositional">
               <xsl:apply-templates select="f:compositional" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--versionNeeded 0..1 boolean (json type: boolean)--><xsl:if test="f:versionNeeded">
         <xsl:if test="f:versionNeeded/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="versionNeeded">
               <xsl:value-of select="f:versionNeeded/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:versionNeeded[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_versionNeeded">
               <xsl:apply-templates select="f:versionNeeded" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--content 1..1 CodeSystemContentMode (json type: string)--><xsl:if test="f:content">
         <xsl:if test="f:content/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="content">
               <xsl:value-of select="f:content/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:content[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_content">
               <xsl:apply-templates select="f:content" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--count 0..1 unsignedInt (json type: number)--><xsl:if test="f:count">
         <xsl:if test="f:count/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="count">
               <xsl:value-of select="f:count/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:count[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_count">
               <xsl:apply-templates select="f:count" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--filter 0..* CodeSystem.Filter--><xsl:if test="f:filter">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="filter">
            <xsl:for-each select="f:filter">
               <map>
                  <xsl:apply-templates select="." mode="CodeSystem.Filter"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--property 0..* CodeSystem.Property--><xsl:if test="f:property">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="property">
            <xsl:for-each select="f:property">
               <map>
                  <xsl:apply-templates select="." mode="CodeSystem.Property"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--concept 0..* CodeSystem.Concept--><xsl:if test="f:concept">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="concept">
            <xsl:for-each select="f:concept">
               <map>
                  <xsl:apply-templates select="." mode="CodeSystem.Concept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Filter">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--operator 1..* FilterOperator (json type: string)--><xsl:if test="f:operator">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="operator">
            <xsl:for-each select="f:operator">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:operator[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_operator">
               <xsl:for-each select="f:operator">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--value 1..1 string (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Property">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--uri 0..1 uri (json type: string)--><xsl:if test="f:uri">
         <xsl:if test="f:uri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uri">
               <xsl:value-of select="f:uri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uri">
               <xsl:apply-templates select="f:uri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 1..1 PropertyType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Concept">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--definition 0..1 string (json type: string)--><xsl:if test="f:definition">
         <xsl:if test="f:definition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
               <xsl:value-of select="f:definition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:definition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_definition">
               <xsl:apply-templates select="f:definition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--designation 0..* CodeSystem.Designation--><xsl:if test="f:designation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="designation">
            <xsl:for-each select="f:designation">
               <map>
                  <xsl:apply-templates select="." mode="CodeSystem.Designation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--property 0..* CodeSystem.Property1--><xsl:if test="f:property">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="property">
            <xsl:for-each select="f:property">
               <map>
                  <xsl:apply-templates select="." mode="CodeSystem.Property1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--concept 0..* CodeSystem.Concept--><xsl:if test="f:concept">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="concept">
            <xsl:for-each select="f:concept">
               <map>
                  <xsl:apply-templates select="." mode="CodeSystem.Concept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Designation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--use 0..1 Coding--><xsl:if test="f:use">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="use">
            <xsl:apply-templates select="f:use" mode="Coding"/>
         </map>
      </xsl:if>
          <!--value 1..1 string (json type: string)--><xsl:if test="f:value">
         <xsl:if test="f:value/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
               <xsl:value-of select="f:value/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:value[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_value">
               <xsl:apply-templates select="f:value" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code system resource specifies a set of codes drawn from one or more code systems.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystem.Property1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
            <!--valueCode 1..1 code (json type: string)--><xsl:if test="f:valueCode">
         <xsl:if test="f:valueCode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueCode">
               <xsl:value-of select="f:valueCode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueCode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueCode">
               <xsl:apply-templates select="f:valueCode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--valueCoding 1..1 Coding--><xsl:if test="f:valueCoding">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="valueCoding">
            <xsl:apply-templates select="f:valueCoding" mode="Coding"/>
         </map>
      </xsl:if>
            <!--valueString 1..1 string (json type: string)--><xsl:if test="f:valueString">
         <xsl:if test="f:valueString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueString">
               <xsl:value-of select="f:valueString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueString">
               <xsl:apply-templates select="f:valueString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--valueInteger 1..1 integer (json type: number)--><xsl:if test="f:valueInteger">
         <xsl:if test="f:valueInteger/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="valueInteger">
               <xsl:value-of select="f:valueInteger/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:valueInteger[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueInteger">
               <xsl:apply-templates select="f:valueInteger" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--valueBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:valueBoolean">
         <xsl:if test="f:valueBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="valueBoolean">
               <xsl:value-of select="f:valueBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:valueBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueBoolean">
               <xsl:apply-templates select="f:valueBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--valueDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:valueDateTime">
         <xsl:if test="f:valueDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="valueDateTime">
               <xsl:value-of select="f:valueDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:valueDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_valueDateTime">
               <xsl:apply-templates select="f:valueDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The kind of operation to perform as a part of a property based filter.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="FilterOperator">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of a property value</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="PropertyType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The meaning of the hierarchy of concepts in a code system</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystemHierarchyMeaning">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How much of the content of the code system - the concepts and codes it defines - are represented in a code system resource</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CodeSystemContentMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Communication">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Communication</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--definition 0..* Reference--><xsl:if test="f:definition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
            <xsl:for-each select="f:definition">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--basedOn 0..* Reference--><xsl:if test="f:basedOn">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="basedOn">
            <xsl:for-each select="f:basedOn">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--partOf 0..* Reference--><xsl:if test="f:partOf">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="partOf">
            <xsl:for-each select="f:partOf">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 EventStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--notDone 0..1 boolean (json type: boolean)--><xsl:if test="f:notDone">
         <xsl:if test="f:notDone/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="notDone">
               <xsl:value-of select="f:notDone/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:notDone[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_notDone">
               <xsl:apply-templates select="f:notDone" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--notDoneReason 0..1 CodeableConcept--><xsl:if test="f:notDoneReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="notDoneReason">
            <xsl:apply-templates select="f:notDoneReason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--category 0..* CodeableConcept--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--medium 0..* CodeableConcept--><xsl:if test="f:medium">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="medium">
            <xsl:for-each select="f:medium">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--recipient 0..* Reference--><xsl:if test="f:recipient">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="recipient">
            <xsl:for-each select="f:recipient">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--topic 0..* Reference--><xsl:if test="f:topic">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="topic">
            <xsl:for-each select="f:topic">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          <!--sent 0..1 dateTime (json type: string)--><xsl:if test="f:sent">
         <xsl:if test="f:sent/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sent">
               <xsl:value-of select="f:sent/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sent[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sent">
               <xsl:apply-templates select="f:sent" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--received 0..1 dateTime (json type: string)--><xsl:if test="f:received">
         <xsl:if test="f:received/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="received">
               <xsl:value-of select="f:received/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:received[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_received">
               <xsl:apply-templates select="f:received" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--sender 0..1 Reference--><xsl:if test="f:sender">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sender">
            <xsl:apply-templates select="f:sender" mode="Reference"/>
         </map>
      </xsl:if>
          <!--reasonCode 0..* CodeableConcept--><xsl:if test="f:reasonCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonCode">
            <xsl:for-each select="f:reasonCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reasonReference 0..* Reference--><xsl:if test="f:reasonReference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonReference">
            <xsl:for-each select="f:reasonReference">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--payload 0..* Communication.Payload--><xsl:if test="f:payload">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="payload">
            <xsl:for-each select="f:payload">
               <map>
                  <xsl:apply-templates select="." mode="Communication.Payload"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Communication.Payload">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--contentString 1..1 string (json type: string)--><xsl:if test="f:contentString">
         <xsl:if test="f:contentString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentString">
               <xsl:value-of select="f:contentString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentString">
               <xsl:apply-templates select="f:contentString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the communication.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EventStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">CommunicationRequest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--basedOn 0..* Reference--><xsl:if test="f:basedOn">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="basedOn">
            <xsl:for-each select="f:basedOn">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--replaces 0..* Reference--><xsl:if test="f:replaces">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="replaces">
            <xsl:for-each select="f:replaces">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--groupIdentifier 0..1 Identifier--><xsl:if test="f:groupIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="groupIdentifier">
            <xsl:apply-templates select="f:groupIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--status 1..1 RequestStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 0..* CodeableConcept--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--priority 0..1 RequestPriority (json type: string)--><xsl:if test="f:priority">
         <xsl:if test="f:priority/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
               <xsl:value-of select="f:priority/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:priority[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_priority">
               <xsl:apply-templates select="f:priority" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--medium 0..* CodeableConcept--><xsl:if test="f:medium">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="medium">
            <xsl:for-each select="f:medium">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--recipient 0..* Reference--><xsl:if test="f:recipient">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="recipient">
            <xsl:for-each select="f:recipient">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--topic 0..* Reference--><xsl:if test="f:topic">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="topic">
            <xsl:for-each select="f:topic">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          <!--payload 0..* CommunicationRequest.Payload--><xsl:if test="f:payload">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="payload">
            <xsl:for-each select="f:payload">
               <map>
                  <xsl:apply-templates select="." mode="CommunicationRequest.Payload"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          
            
            <!--occurrenceDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:occurrenceDateTime">
         <xsl:if test="f:occurrenceDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="occurrenceDateTime">
               <xsl:value-of select="f:occurrenceDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:occurrenceDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_occurrenceDateTime">
               <xsl:apply-templates select="f:occurrenceDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--occurrencePeriod 1..1 Period--><xsl:if test="f:occurrencePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="occurrencePeriod">
            <xsl:apply-templates select="f:occurrencePeriod" mode="Period"/>
         </map>
      </xsl:if>
          
          <!--authoredOn 0..1 dateTime (json type: string)--><xsl:if test="f:authoredOn">
         <xsl:if test="f:authoredOn/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="authoredOn">
               <xsl:value-of select="f:authoredOn/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:authoredOn[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_authoredOn">
               <xsl:apply-templates select="f:authoredOn" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--sender 0..1 Reference--><xsl:if test="f:sender">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sender">
            <xsl:apply-templates select="f:sender" mode="Reference"/>
         </map>
      </xsl:if>
          <!--requester 0..1 CommunicationRequest.Requester--><xsl:if test="f:requester">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requester">
            <xsl:apply-templates select="f:requester" mode="CommunicationRequest.Requester"/>
         </map>
      </xsl:if>
          <!--reasonCode 0..* CodeableConcept--><xsl:if test="f:reasonCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonCode">
            <xsl:for-each select="f:reasonCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reasonReference 0..* Reference--><xsl:if test="f:reasonReference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonReference">
            <xsl:for-each select="f:reasonReference">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest.Payload">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--contentString 1..1 string (json type: string)--><xsl:if test="f:contentString">
         <xsl:if test="f:contentString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="contentString">
               <xsl:value-of select="f:contentString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:contentString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_contentString">
               <xsl:apply-templates select="f:contentString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CommunicationRequest.Requester">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--agent 1..1 Reference--><xsl:if test="f:agent">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="agent">
            <xsl:apply-templates select="f:agent" mode="Reference"/>
         </map>
      </xsl:if>
          <!--onBehalfOf 0..1 Reference--><xsl:if test="f:onBehalfOf">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onBehalfOf">
            <xsl:apply-templates select="f:onBehalfOf" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the communication request.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="RequestStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes indicating the relative importance of a communication request.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="RequestPriority">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A compartment definition that defines how resources are accessed on a server.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CompartmentDefinition">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">CompartmentDefinition</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--url 1..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 1..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 PublicationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--contact 0..* ContactDetail--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 markdown (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--purpose 0..1 markdown (json type: string)--><xsl:if test="f:purpose">
         <xsl:if test="f:purpose/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose">
               <xsl:value-of select="f:purpose/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:purpose[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_purpose">
               <xsl:apply-templates select="f:purpose" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--useContext 0..* UsageContext--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="UsageContext"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--jurisdiction 0..* CodeableConcept--><xsl:if test="f:jurisdiction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="jurisdiction">
            <xsl:for-each select="f:jurisdiction">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--code 1..1 CompartmentType (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--search 1..1 boolean (json type: boolean)--><xsl:if test="f:search">
         <xsl:if test="f:search/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="search">
               <xsl:value-of select="f:search/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:search[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_search">
               <xsl:apply-templates select="f:search" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--resource 0..* CompartmentDefinition.Resource--><xsl:if test="f:resource">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="resource">
            <xsl:for-each select="f:resource">
               <map>
                  <xsl:apply-templates select="." mode="CompartmentDefinition.Resource"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A compartment definition that defines how resources are accessed on a server.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CompartmentDefinition.Resource">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 ResourceType (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--param 0..* string (json type: string)--><xsl:if test="f:param">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="param">
            <xsl:for-each select="f:param">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:param[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_param">
               <xsl:for-each select="f:param">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--documentation 0..1 string (json type: string)--><xsl:if test="f:documentation">
         <xsl:if test="f:documentation/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="documentation">
               <xsl:value-of select="f:documentation/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:documentation[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_documentation">
               <xsl:apply-templates select="f:documentation" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Which compartment a compartment definition describes</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CompartmentType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Composition</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--status 1..1 CompositionStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--class 0..1 CodeableConcept--><xsl:if test="f:class">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="class">
            <xsl:apply-templates select="f:class" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
          <!--date 1..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--author 1..* Reference--><xsl:if test="f:author">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:for-each select="f:author">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--title 1..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--confidentiality 0..1 ConfidentialityClassification (json type: string)--><xsl:if test="f:confidentiality">
         <xsl:if test="f:confidentiality/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="confidentiality">
               <xsl:value-of select="f:confidentiality/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:confidentiality[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_confidentiality">
               <xsl:apply-templates select="f:confidentiality" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--attester 0..* Composition.Attester--><xsl:if test="f:attester">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="attester">
            <xsl:for-each select="f:attester">
               <map>
                  <xsl:apply-templates select="." mode="Composition.Attester"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--custodian 0..1 Reference--><xsl:if test="f:custodian">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="custodian">
            <xsl:apply-templates select="f:custodian" mode="Reference"/>
         </map>
      </xsl:if>
          <!--relatesTo 0..* Composition.RelatesTo--><xsl:if test="f:relatesTo">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="relatesTo">
            <xsl:for-each select="f:relatesTo">
               <map>
                  <xsl:apply-templates select="." mode="Composition.RelatesTo"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--event 0..* Composition.Event--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <map>
                  <xsl:apply-templates select="." mode="Composition.Event"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--section 0..* Composition.Section--><xsl:if test="f:section">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="section">
            <xsl:for-each select="f:section">
               <map>
                  <xsl:apply-templates select="." mode="Composition.Section"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Attester">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--mode 1..* CompositionAttestationMode (json type: string)--><xsl:if test="f:mode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
            <xsl:for-each select="f:mode">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:mode[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:for-each select="f:mode">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--time 0..1 dateTime (json type: string)--><xsl:if test="f:time">
         <xsl:if test="f:time/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="time">
               <xsl:value-of select="f:time/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:time[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_time">
               <xsl:apply-templates select="f:time" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--party 0..1 Reference--><xsl:if test="f:party">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="party">
            <xsl:apply-templates select="f:party" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition.RelatesTo">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 DocumentRelationshipType (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
            <!--targetIdentifier 1..1 Identifier--><xsl:if test="f:targetIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="targetIdentifier">
            <xsl:apply-templates select="f:targetIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
            <!--targetReference 1..1 Reference--><xsl:if test="f:targetReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="targetReference">
            <xsl:apply-templates select="f:targetReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Event">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 0..* CodeableConcept--><xsl:if test="f:code">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:for-each select="f:code">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--detail 0..* Reference--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Composition.Section">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--text 0..1 Narrative--><xsl:if test="f:text">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="text">
            <xsl:apply-templates select="f:text" mode="Narrative"/>
         </map>
      </xsl:if>
          <!--mode 0..1 ListMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--orderedBy 0..1 CodeableConcept--><xsl:if test="f:orderedBy">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="orderedBy">
            <xsl:apply-templates select="f:orderedBy" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--entry 0..* Reference--><xsl:if test="f:entry">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="entry">
            <xsl:for-each select="f:entry">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--emptyReason 0..1 CodeableConcept--><xsl:if test="f:emptyReason">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="emptyReason">
            <xsl:apply-templates select="f:emptyReason" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--section 0..* Composition.Section--><xsl:if test="f:section">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="section">
            <xsl:for-each select="f:section">
               <map>
                  <xsl:apply-templates select="." mode="Composition.Section"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The workflow/clinical status of the composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CompositionStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes specifying the level of confidentiality of the composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConfidentialityClassification">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The type of relationship between documents.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentRelationshipType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The way in which a person authenticated a composition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="CompositionAttestationMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The processing mode that applies to this section.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ListMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ConceptMap</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 PublicationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--contact 0..* ContactDetail--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 markdown (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--useContext 0..* UsageContext--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="UsageContext"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--jurisdiction 0..* CodeableConcept--><xsl:if test="f:jurisdiction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="jurisdiction">
            <xsl:for-each select="f:jurisdiction">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--purpose 0..1 markdown (json type: string)--><xsl:if test="f:purpose">
         <xsl:if test="f:purpose/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="purpose">
               <xsl:value-of select="f:purpose/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:purpose[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_purpose">
               <xsl:apply-templates select="f:purpose" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--copyright 0..1 markdown (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
            <!--sourceUri 1..1 uri (json type: string)--><xsl:if test="f:sourceUri">
         <xsl:if test="f:sourceUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sourceUri">
               <xsl:value-of select="f:sourceUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sourceUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sourceUri">
               <xsl:apply-templates select="f:sourceUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--sourceReference 1..1 Reference--><xsl:if test="f:sourceReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sourceReference">
            <xsl:apply-templates select="f:sourceReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          
            
            <!--targetUri 1..1 uri (json type: string)--><xsl:if test="f:targetUri">
         <xsl:if test="f:targetUri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetUri">
               <xsl:value-of select="f:targetUri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:targetUri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_targetUri">
               <xsl:apply-templates select="f:targetUri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--targetReference 1..1 Reference--><xsl:if test="f:targetReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="targetReference">
            <xsl:apply-templates select="f:targetReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--group 0..* ConceptMap.Group--><xsl:if test="f:group">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="group">
            <xsl:for-each select="f:group">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.Group"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Group">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--source 0..1 uri (json type: string)--><xsl:if test="f:source">
         <xsl:if test="f:source/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="source">
               <xsl:value-of select="f:source/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:source[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_source">
               <xsl:apply-templates select="f:source" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--sourceVersion 0..1 string (json type: string)--><xsl:if test="f:sourceVersion">
         <xsl:if test="f:sourceVersion/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sourceVersion">
               <xsl:value-of select="f:sourceVersion/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sourceVersion[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sourceVersion">
               <xsl:apply-templates select="f:sourceVersion" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--target 0..1 uri (json type: string)--><xsl:if test="f:target">
         <xsl:if test="f:target/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="target">
               <xsl:value-of select="f:target/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:target[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_target">
               <xsl:apply-templates select="f:target" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--targetVersion 0..1 string (json type: string)--><xsl:if test="f:targetVersion">
         <xsl:if test="f:targetVersion/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="targetVersion">
               <xsl:value-of select="f:targetVersion/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:targetVersion[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_targetVersion">
               <xsl:apply-templates select="f:targetVersion" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--element 1..* ConceptMap.Element--><xsl:if test="f:element">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="element">
            <xsl:for-each select="f:element">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.Element"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--unmapped 0..1 ConceptMap.Unmapped--><xsl:if test="f:unmapped">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unmapped">
            <xsl:apply-templates select="f:unmapped" mode="ConceptMap.Unmapped"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Element">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--target 0..* ConceptMap.Target--><xsl:if test="f:target">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="target">
            <xsl:for-each select="f:target">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.Target"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Target">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--equivalence 0..1 ConceptMapEquivalence (json type: string)--><xsl:if test="f:equivalence">
         <xsl:if test="f:equivalence/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="equivalence">
               <xsl:value-of select="f:equivalence/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:equivalence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_equivalence">
               <xsl:apply-templates select="f:equivalence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--dependsOn 0..* ConceptMap.DependsOn--><xsl:if test="f:dependsOn">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dependsOn">
            <xsl:for-each select="f:dependsOn">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.DependsOn"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--product 0..* ConceptMap.DependsOn--><xsl:if test="f:product">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="product">
            <xsl:for-each select="f:product">
               <map>
                  <xsl:apply-templates select="." mode="ConceptMap.DependsOn"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.DependsOn">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--property 1..1 uri (json type: string)--><xsl:if test="f:property">
         <xsl:if test="f:property/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="property">
               <xsl:value-of select="f:property/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:property[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_property">
               <xsl:apply-templates select="f:property" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--system 0..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 1..1 string (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMap.Unmapped">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--mode 1..1 ConceptMapGroupUnmappedMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--code 0..1 code (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--display 0..1 string (json type: string)--><xsl:if test="f:display">
         <xsl:if test="f:display/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="display">
               <xsl:value-of select="f:display/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:display[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_display">
               <xsl:apply-templates select="f:display" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Defines which action to take if there is no match in the group.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConceptMapGroupUnmappedMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Condition">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Condition</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--clinicalStatus 0..1 ConditionClinicalStatusCodes (json type: string)--><xsl:if test="f:clinicalStatus">
         <xsl:if test="f:clinicalStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="clinicalStatus">
               <xsl:value-of select="f:clinicalStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:clinicalStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_clinicalStatus">
               <xsl:apply-templates select="f:clinicalStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--verificationStatus 0..1 ConditionVerificationStatus (json type: string)--><xsl:if test="f:verificationStatus">
         <xsl:if test="f:verificationStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="verificationStatus">
               <xsl:value-of select="f:verificationStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:verificationStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_verificationStatus">
               <xsl:apply-templates select="f:verificationStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 0..* CodeableConcept--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--severity 0..1 CodeableConcept--><xsl:if test="f:severity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="severity">
            <xsl:apply-templates select="f:severity" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--code 0..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--bodySite 0..* CodeableConcept--><xsl:if test="f:bodySite">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="bodySite">
            <xsl:for-each select="f:bodySite">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          
            
            <!--onsetDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:onsetDateTime">
         <xsl:if test="f:onsetDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetDateTime">
               <xsl:value-of select="f:onsetDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onsetDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onsetDateTime">
               <xsl:apply-templates select="f:onsetDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--onsetAge 1..1 Age--><xsl:if test="f:onsetAge">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetAge">
            <xsl:apply-templates select="f:onsetAge" mode="Age"/>
         </map>
      </xsl:if>
            <!--onsetPeriod 1..1 Period--><xsl:if test="f:onsetPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetPeriod">
            <xsl:apply-templates select="f:onsetPeriod" mode="Period"/>
         </map>
      </xsl:if>
            <!--onsetRange 1..1 Range--><xsl:if test="f:onsetRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onsetRange">
            <xsl:apply-templates select="f:onsetRange" mode="Range"/>
         </map>
      </xsl:if>
            <!--onsetString 1..1 string (json type: string)--><xsl:if test="f:onsetString">
         <xsl:if test="f:onsetString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="onsetString">
               <xsl:value-of select="f:onsetString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:onsetString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_onsetString">
               <xsl:apply-templates select="f:onsetString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
          
            
            <!--abatementDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:abatementDateTime">
         <xsl:if test="f:abatementDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="abatementDateTime">
               <xsl:value-of select="f:abatementDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:abatementDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_abatementDateTime">
               <xsl:apply-templates select="f:abatementDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--abatementAge 1..1 Age--><xsl:if test="f:abatementAge">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="abatementAge">
            <xsl:apply-templates select="f:abatementAge" mode="Age"/>
         </map>
      </xsl:if>
            <!--abatementBoolean 1..1 boolean (json type: boolean)--><xsl:if test="f:abatementBoolean">
         <xsl:if test="f:abatementBoolean/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="abatementBoolean">
               <xsl:value-of select="f:abatementBoolean/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:abatementBoolean[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_abatementBoolean">
               <xsl:apply-templates select="f:abatementBoolean" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--abatementPeriod 1..1 Period--><xsl:if test="f:abatementPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="abatementPeriod">
            <xsl:apply-templates select="f:abatementPeriod" mode="Period"/>
         </map>
      </xsl:if>
            <!--abatementRange 1..1 Range--><xsl:if test="f:abatementRange">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="abatementRange">
            <xsl:apply-templates select="f:abatementRange" mode="Range"/>
         </map>
      </xsl:if>
            <!--abatementString 1..1 string (json type: string)--><xsl:if test="f:abatementString">
         <xsl:if test="f:abatementString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="abatementString">
               <xsl:value-of select="f:abatementString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:abatementString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_abatementString">
               <xsl:apply-templates select="f:abatementString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
          <!--assertedDate 0..1 dateTime (json type: string)--><xsl:if test="f:assertedDate">
         <xsl:if test="f:assertedDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="assertedDate">
               <xsl:value-of select="f:assertedDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:assertedDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_assertedDate">
               <xsl:apply-templates select="f:assertedDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--asserter 0..1 Reference--><xsl:if test="f:asserter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="asserter">
            <xsl:apply-templates select="f:asserter" mode="Reference"/>
         </map>
      </xsl:if>
          <!--stage 0..1 Condition.Stage--><xsl:if test="f:stage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="stage">
            <xsl:apply-templates select="f:stage" mode="Condition.Stage"/>
         </map>
      </xsl:if>
          <!--evidence 0..* Condition.Evidence--><xsl:if test="f:evidence">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="evidence">
            <xsl:for-each select="f:evidence">
               <map>
                  <xsl:apply-templates select="." mode="Condition.Evidence"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Condition.Stage">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--summary 0..1 CodeableConcept--><xsl:if test="f:summary">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="summary">
            <xsl:apply-templates select="f:summary" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--assessment 0..* Reference--><xsl:if test="f:assessment">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="assessment">
            <xsl:for-each select="f:assessment">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Condition.Evidence">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 0..* CodeableConcept--><xsl:if test="f:code">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:for-each select="f:code">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--detail 0..* Reference--><xsl:if test="f:detail">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
            <xsl:for-each select="f:detail">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The verification status to support or decline the clinical status of the condition or diagnosis.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConditionVerificationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The clinical status of the condition or diagnosis.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConditionClinicalStatusCodes">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a healthcare consumer’s policy choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Consent">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Consent</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--status 1..1 ConsentState (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 0..* CodeableConcept--><xsl:if test="f:category">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:for-each select="f:category">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--dateTime 0..1 dateTime (json type: string)--><xsl:if test="f:dateTime">
         <xsl:if test="f:dateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="dateTime">
               <xsl:value-of select="f:dateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:dateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dateTime">
               <xsl:apply-templates select="f:dateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--consentingParty 0..* Reference--><xsl:if test="f:consentingParty">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="consentingParty">
            <xsl:for-each select="f:consentingParty">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--actor 0..* Consent.Actor--><xsl:if test="f:actor">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:for-each select="f:actor">
               <map>
                  <xsl:apply-templates select="." mode="Consent.Actor"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--action 0..* CodeableConcept--><xsl:if test="f:action">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:for-each select="f:action">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--organization 0..* Reference--><xsl:if test="f:organization">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:for-each select="f:organization">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          
            
            <!--sourceAttachment 1..1 Attachment--><xsl:if test="f:sourceAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sourceAttachment">
            <xsl:apply-templates select="f:sourceAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--sourceIdentifier 1..1 Identifier--><xsl:if test="f:sourceIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sourceIdentifier">
            <xsl:apply-templates select="f:sourceIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
            <!--sourceReference 1..1 Reference--><xsl:if test="f:sourceReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sourceReference">
            <xsl:apply-templates select="f:sourceReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--policy 0..* Consent.Policy--><xsl:if test="f:policy">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="policy">
            <xsl:for-each select="f:policy">
               <map>
                  <xsl:apply-templates select="." mode="Consent.Policy"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--policyRule 0..1 uri (json type: string)--><xsl:if test="f:policyRule">
         <xsl:if test="f:policyRule/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="policyRule">
               <xsl:value-of select="f:policyRule/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:policyRule[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_policyRule">
               <xsl:apply-templates select="f:policyRule" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--securityLabel 0..* Coding--><xsl:if test="f:securityLabel">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="securityLabel">
            <xsl:for-each select="f:securityLabel">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--purpose 0..* Coding--><xsl:if test="f:purpose">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="purpose">
            <xsl:for-each select="f:purpose">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--dataPeriod 0..1 Period--><xsl:if test="f:dataPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dataPeriod">
            <xsl:apply-templates select="f:dataPeriod" mode="Period"/>
         </map>
      </xsl:if>
          <!--data 0..* Consent.Data--><xsl:if test="f:data">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="data">
            <xsl:for-each select="f:data">
               <map>
                  <xsl:apply-templates select="." mode="Consent.Data"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--except 0..* Consent.Except--><xsl:if test="f:except">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="except">
            <xsl:for-each select="f:except">
               <map>
                  <xsl:apply-templates select="." mode="Consent.Except"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a healthcare consumer’s policy choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Consent.Actor">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--role 1..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--reference 1..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a healthcare consumer’s policy choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Consent.Policy">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--authority 0..1 uri (json type: string)--><xsl:if test="f:authority">
         <xsl:if test="f:authority/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="authority">
               <xsl:value-of select="f:authority/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:authority[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_authority">
               <xsl:apply-templates select="f:authority" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--uri 0..1 uri (json type: string)--><xsl:if test="f:uri">
         <xsl:if test="f:uri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uri">
               <xsl:value-of select="f:uri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uri">
               <xsl:apply-templates select="f:uri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a healthcare consumer’s policy choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Consent.Data">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--meaning 1..1 ConsentDataMeaning (json type: string)--><xsl:if test="f:meaning">
         <xsl:if test="f:meaning/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="meaning">
               <xsl:value-of select="f:meaning/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:meaning[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_meaning">
               <xsl:apply-templates select="f:meaning" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--reference 1..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a healthcare consumer’s policy choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Consent.Except">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 1..1 ConsentExceptType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--actor 0..* Consent.Actor1--><xsl:if test="f:actor">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:for-each select="f:actor">
               <map>
                  <xsl:apply-templates select="." mode="Consent.Actor1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--action 0..* CodeableConcept--><xsl:if test="f:action">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:for-each select="f:action">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--securityLabel 0..* Coding--><xsl:if test="f:securityLabel">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="securityLabel">
            <xsl:for-each select="f:securityLabel">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--purpose 0..* Coding--><xsl:if test="f:purpose">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="purpose">
            <xsl:for-each select="f:purpose">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--class 0..* Coding--><xsl:if test="f:class">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="class">
            <xsl:for-each select="f:class">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--code 0..* Coding--><xsl:if test="f:code">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:for-each select="f:code">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--dataPeriod 0..1 Period--><xsl:if test="f:dataPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dataPeriod">
            <xsl:apply-templates select="f:dataPeriod" mode="Period"/>
         </map>
      </xsl:if>
          <!--data 0..* Consent.Data1--><xsl:if test="f:data">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="data">
            <xsl:for-each select="f:data">
               <map>
                  <xsl:apply-templates select="." mode="Consent.Data1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a healthcare consumer’s policy choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Consent.Actor1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--role 1..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--reference 1..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a healthcare consumer’s policy choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Consent.Data1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--meaning 1..1 ConsentDataMeaning (json type: string)--><xsl:if test="f:meaning">
         <xsl:if test="f:meaning/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="meaning">
               <xsl:value-of select="f:meaning/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:meaning[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_meaning">
               <xsl:apply-templates select="f:meaning" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--reference 1..1 Reference--><xsl:if test="f:reference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
            <xsl:apply-templates select="f:reference" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How a resource reference is interpreted when testing consent restrictions</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConsentDataMeaning">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the state of the consent</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConsentState">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How an exception statement is applied, such as adding additional consent or removing consent</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ConsentExceptType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Contract</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--status 0..1 ContractResourceStatusCodes (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--issued 0..1 dateTime (json type: string)--><xsl:if test="f:issued">
         <xsl:if test="f:issued/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued">
               <xsl:value-of select="f:issued/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:issued[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_issued">
               <xsl:apply-templates select="f:issued" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--applies 0..1 Period--><xsl:if test="f:applies">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="applies">
            <xsl:apply-templates select="f:applies" mode="Period"/>
         </map>
      </xsl:if>
          <!--subject 0..* Reference--><xsl:if test="f:subject">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:for-each select="f:subject">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--topic 0..* Reference--><xsl:if test="f:topic">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="topic">
            <xsl:for-each select="f:topic">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--authority 0..* Reference--><xsl:if test="f:authority">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="authority">
            <xsl:for-each select="f:authority">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--domain 0..* Reference--><xsl:if test="f:domain">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="domain">
            <xsl:for-each select="f:domain">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subType 0..* CodeableConcept--><xsl:if test="f:subType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subType">
            <xsl:for-each select="f:subType">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--action 0..* CodeableConcept--><xsl:if test="f:action">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:for-each select="f:action">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--actionReason 0..* CodeableConcept--><xsl:if test="f:actionReason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actionReason">
            <xsl:for-each select="f:actionReason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--decisionType 0..1 CodeableConcept--><xsl:if test="f:decisionType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="decisionType">
            <xsl:apply-templates select="f:decisionType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--contentDerivative 0..1 CodeableConcept--><xsl:if test="f:contentDerivative">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentDerivative">
            <xsl:apply-templates select="f:contentDerivative" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--securityLabel 0..* Coding--><xsl:if test="f:securityLabel">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="securityLabel">
            <xsl:for-each select="f:securityLabel">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--agent 0..* Contract.Agent--><xsl:if test="f:agent">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="agent">
            <xsl:for-each select="f:agent">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Agent"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--signer 0..* Contract.Signer--><xsl:if test="f:signer">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="signer">
            <xsl:for-each select="f:signer">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Signer"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--valuedItem 0..* Contract.ValuedItem--><xsl:if test="f:valuedItem">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="valuedItem">
            <xsl:for-each select="f:valuedItem">
               <map>
                  <xsl:apply-templates select="." mode="Contract.ValuedItem"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--term 0..* Contract.Term--><xsl:if test="f:term">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="term">
            <xsl:for-each select="f:term">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Term"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          
            
            <!--bindingAttachment 1..1 Attachment--><xsl:if test="f:bindingAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bindingAttachment">
            <xsl:apply-templates select="f:bindingAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--bindingReference 1..1 Reference--><xsl:if test="f:bindingReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bindingReference">
            <xsl:apply-templates select="f:bindingReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--friendly 0..* Contract.Friendly--><xsl:if test="f:friendly">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="friendly">
            <xsl:for-each select="f:friendly">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Friendly"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--legal 0..* Contract.Legal--><xsl:if test="f:legal">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="legal">
            <xsl:for-each select="f:legal">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Legal"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--rule 0..* Contract.Rule--><xsl:if test="f:rule">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="rule">
            <xsl:for-each select="f:rule">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Rule"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Agent">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--actor 1..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
          <!--role 0..* CodeableConcept--><xsl:if test="f:role">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:for-each select="f:role">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Signer">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 1..1 Coding--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="Coding"/>
         </map>
      </xsl:if>
          <!--party 1..1 Reference--><xsl:if test="f:party">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="party">
            <xsl:apply-templates select="f:party" mode="Reference"/>
         </map>
      </xsl:if>
          <!--signature 1..* Signature--><xsl:if test="f:signature">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="signature">
            <xsl:for-each select="f:signature">
               <map>
                  <xsl:apply-templates select="." mode="Signature"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.ValuedItem">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--entityCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:entityCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entityCodeableConcept">
            <xsl:apply-templates select="f:entityCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
            <!--entityReference 1..1 Reference--><xsl:if test="f:entityReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entityReference">
            <xsl:apply-templates select="f:entityReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--effectiveTime 0..1 dateTime (json type: string)--><xsl:if test="f:effectiveTime">
         <xsl:if test="f:effectiveTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveTime">
               <xsl:value-of select="f:effectiveTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:effectiveTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_effectiveTime">
               <xsl:apply-templates select="f:effectiveTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--quantity 0..1 Quantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
          <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--points 0..1 decimal (json type: number)--><xsl:if test="f:points">
         <xsl:if test="f:points/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="points">
               <xsl:value-of select="f:points/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:points[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_points">
               <xsl:apply-templates select="f:points" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Term">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--issued 0..1 dateTime (json type: string)--><xsl:if test="f:issued">
         <xsl:if test="f:issued/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued">
               <xsl:value-of select="f:issued/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:issued[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_issued">
               <xsl:apply-templates select="f:issued" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--applies 0..1 Period--><xsl:if test="f:applies">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="applies">
            <xsl:apply-templates select="f:applies" mode="Period"/>
         </map>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subType 0..1 CodeableConcept--><xsl:if test="f:subType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subType">
            <xsl:apply-templates select="f:subType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--topic 0..* Reference--><xsl:if test="f:topic">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="topic">
            <xsl:for-each select="f:topic">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--action 0..* CodeableConcept--><xsl:if test="f:action">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:for-each select="f:action">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--actionReason 0..* CodeableConcept--><xsl:if test="f:actionReason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="actionReason">
            <xsl:for-each select="f:actionReason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--securityLabel 0..* Coding--><xsl:if test="f:securityLabel">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="securityLabel">
            <xsl:for-each select="f:securityLabel">
               <map>
                  <xsl:apply-templates select="." mode="Coding"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--agent 0..* Contract.Agent1--><xsl:if test="f:agent">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="agent">
            <xsl:for-each select="f:agent">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Agent1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--text 0..1 string (json type: string)--><xsl:if test="f:text">
         <xsl:if test="f:text/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="text">
               <xsl:value-of select="f:text/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:text[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_text">
               <xsl:apply-templates select="f:text" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--valuedItem 0..* Contract.ValuedItem1--><xsl:if test="f:valuedItem">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="valuedItem">
            <xsl:for-each select="f:valuedItem">
               <map>
                  <xsl:apply-templates select="." mode="Contract.ValuedItem1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--group 0..* Contract.Term--><xsl:if test="f:group">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="group">
            <xsl:for-each select="f:group">
               <map>
                  <xsl:apply-templates select="." mode="Contract.Term"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Agent1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--actor 1..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
          <!--role 0..* CodeableConcept--><xsl:if test="f:role">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:for-each select="f:role">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.ValuedItem1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--entityCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:entityCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entityCodeableConcept">
            <xsl:apply-templates select="f:entityCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
            <!--entityReference 1..1 Reference--><xsl:if test="f:entityReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="entityReference">
            <xsl:apply-templates select="f:entityReference" mode="Reference"/>
         </map>
      </xsl:if>
          
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--effectiveTime 0..1 dateTime (json type: string)--><xsl:if test="f:effectiveTime">
         <xsl:if test="f:effectiveTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveTime">
               <xsl:value-of select="f:effectiveTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:effectiveTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_effectiveTime">
               <xsl:apply-templates select="f:effectiveTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--quantity 0..1 Quantity--><xsl:if test="f:quantity">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="quantity">
            <xsl:apply-templates select="f:quantity" mode="Quantity"/>
         </map>
      </xsl:if>
          <!--unitPrice 0..1 Money--><xsl:if test="f:unitPrice">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unitPrice">
            <xsl:apply-templates select="f:unitPrice" mode="Money"/>
         </map>
      </xsl:if>
          <!--factor 0..1 decimal (json type: number)--><xsl:if test="f:factor">
         <xsl:if test="f:factor/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="factor">
               <xsl:value-of select="f:factor/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:factor[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_factor">
               <xsl:apply-templates select="f:factor" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--points 0..1 decimal (json type: number)--><xsl:if test="f:points">
         <xsl:if test="f:points/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="points">
               <xsl:value-of select="f:points/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:points[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_points">
               <xsl:apply-templates select="f:points" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--net 0..1 Money--><xsl:if test="f:net">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="net">
            <xsl:apply-templates select="f:net" mode="Money"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Friendly">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Legal">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A formal agreement between parties regarding the conduct of business, exchange of information or other matters.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Contract.Rule">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--contentAttachment 1..1 Attachment--><xsl:if test="f:contentAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentAttachment">
            <xsl:apply-templates select="f:contentAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--contentReference 1..1 Reference--><xsl:if test="f:contentReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contentReference">
            <xsl:apply-templates select="f:contentReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A code specifying the state of the resource instance.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ContractResourceStatusCodes">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Financial instrument which may be used to reimburse or pay for health care products and services.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Coverage">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Coverage</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 FinancialResourceStatusCodes (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--policyHolder 0..1 Reference--><xsl:if test="f:policyHolder">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="policyHolder">
            <xsl:apply-templates select="f:policyHolder" mode="Reference"/>
         </map>
      </xsl:if>
          <!--subscriber 0..1 Reference--><xsl:if test="f:subscriber">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subscriber">
            <xsl:apply-templates select="f:subscriber" mode="Reference"/>
         </map>
      </xsl:if>
          <!--subscriberId 0..1 string (json type: string)--><xsl:if test="f:subscriberId">
         <xsl:if test="f:subscriberId/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="subscriberId">
               <xsl:value-of select="f:subscriberId/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:subscriberId[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_subscriberId">
               <xsl:apply-templates select="f:subscriberId" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--beneficiary 0..1 Reference--><xsl:if test="f:beneficiary">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="beneficiary">
            <xsl:apply-templates select="f:beneficiary" mode="Reference"/>
         </map>
      </xsl:if>
          <!--relationship 0..1 CodeableConcept--><xsl:if test="f:relationship">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="relationship">
            <xsl:apply-templates select="f:relationship" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--payor 0..* Reference--><xsl:if test="f:payor">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="payor">
            <xsl:for-each select="f:payor">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--grouping 0..1 Coverage.Grouping--><xsl:if test="f:grouping">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="grouping">
            <xsl:apply-templates select="f:grouping" mode="Coverage.Grouping"/>
         </map>
      </xsl:if>
          <!--dependent 0..1 string (json type: string)--><xsl:if test="f:dependent">
         <xsl:if test="f:dependent/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="dependent">
               <xsl:value-of select="f:dependent/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:dependent[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_dependent">
               <xsl:apply-templates select="f:dependent" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--sequence 0..1 string (json type: string)--><xsl:if test="f:sequence">
         <xsl:if test="f:sequence/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="sequence">
               <xsl:value-of select="f:sequence/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:sequence[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_sequence">
               <xsl:apply-templates select="f:sequence" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--order 0..1 positiveInt (json type: number)--><xsl:if test="f:order">
         <xsl:if test="f:order/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="order">
               <xsl:value-of select="f:order/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:order[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_order">
               <xsl:apply-templates select="f:order" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--network 0..1 string (json type: string)--><xsl:if test="f:network">
         <xsl:if test="f:network/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="network">
               <xsl:value-of select="f:network/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:network[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_network">
               <xsl:apply-templates select="f:network" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--contract 0..* Reference--><xsl:if test="f:contract">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contract">
            <xsl:for-each select="f:contract">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Financial instrument which may be used to reimburse or pay for health care products and services.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Coverage.Grouping">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--group 0..1 string (json type: string)--><xsl:if test="f:group">
         <xsl:if test="f:group/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="group">
               <xsl:value-of select="f:group/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:group[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_group">
               <xsl:apply-templates select="f:group" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--groupDisplay 0..1 string (json type: string)--><xsl:if test="f:groupDisplay">
         <xsl:if test="f:groupDisplay/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="groupDisplay">
               <xsl:value-of select="f:groupDisplay/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:groupDisplay[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_groupDisplay">
               <xsl:apply-templates select="f:groupDisplay" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subGroup 0..1 string (json type: string)--><xsl:if test="f:subGroup">
         <xsl:if test="f:subGroup/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="subGroup">
               <xsl:value-of select="f:subGroup/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:subGroup[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_subGroup">
               <xsl:apply-templates select="f:subGroup" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subGroupDisplay 0..1 string (json type: string)--><xsl:if test="f:subGroupDisplay">
         <xsl:if test="f:subGroupDisplay/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="subGroupDisplay">
               <xsl:value-of select="f:subGroupDisplay/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:subGroupDisplay[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_subGroupDisplay">
               <xsl:apply-templates select="f:subGroupDisplay" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--plan 0..1 string (json type: string)--><xsl:if test="f:plan">
         <xsl:if test="f:plan/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="plan">
               <xsl:value-of select="f:plan/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:plan[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_plan">
               <xsl:apply-templates select="f:plan" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--planDisplay 0..1 string (json type: string)--><xsl:if test="f:planDisplay">
         <xsl:if test="f:planDisplay/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="planDisplay">
               <xsl:value-of select="f:planDisplay/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:planDisplay[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_planDisplay">
               <xsl:apply-templates select="f:planDisplay" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subPlan 0..1 string (json type: string)--><xsl:if test="f:subPlan">
         <xsl:if test="f:subPlan/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="subPlan">
               <xsl:value-of select="f:subPlan/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:subPlan[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_subPlan">
               <xsl:apply-templates select="f:subPlan" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subPlanDisplay 0..1 string (json type: string)--><xsl:if test="f:subPlanDisplay">
         <xsl:if test="f:subPlanDisplay/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="subPlanDisplay">
               <xsl:value-of select="f:subPlanDisplay/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:subPlanDisplay[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_subPlanDisplay">
               <xsl:apply-templates select="f:subPlanDisplay" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--class 0..1 string (json type: string)--><xsl:if test="f:class">
         <xsl:if test="f:class/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="class">
               <xsl:value-of select="f:class/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:class[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_class">
               <xsl:apply-templates select="f:class" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--classDisplay 0..1 string (json type: string)--><xsl:if test="f:classDisplay">
         <xsl:if test="f:classDisplay/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="classDisplay">
               <xsl:value-of select="f:classDisplay/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:classDisplay[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_classDisplay">
               <xsl:apply-templates select="f:classDisplay" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subClass 0..1 string (json type: string)--><xsl:if test="f:subClass">
         <xsl:if test="f:subClass/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="subClass">
               <xsl:value-of select="f:subClass/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:subClass[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_subClass">
               <xsl:apply-templates select="f:subClass" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subClassDisplay 0..1 string (json type: string)--><xsl:if test="f:subClassDisplay">
         <xsl:if test="f:subClassDisplay/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="subClassDisplay">
               <xsl:value-of select="f:subClassDisplay/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:subClassDisplay[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_subClassDisplay">
               <xsl:apply-templates select="f:subClassDisplay" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The formal description of a single piece of information that can be gathered and reported.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataElement">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DataElement</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 PublicationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--title 0..1 string (json type: string)--><xsl:if test="f:title">
         <xsl:if test="f:title/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="title">
               <xsl:value-of select="f:title/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:title[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_title">
               <xsl:apply-templates select="f:title" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--contact 0..* ContactDetail--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--useContext 0..* UsageContext--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="UsageContext"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--jurisdiction 0..* CodeableConcept--><xsl:if test="f:jurisdiction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="jurisdiction">
            <xsl:for-each select="f:jurisdiction">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--copyright 0..1 markdown (json type: string)--><xsl:if test="f:copyright">
         <xsl:if test="f:copyright/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="copyright">
               <xsl:value-of select="f:copyright/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:copyright[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_copyright">
               <xsl:apply-templates select="f:copyright" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--stringency 0..1 DataElementStringency (json type: string)--><xsl:if test="f:stringency">
         <xsl:if test="f:stringency/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="stringency">
               <xsl:value-of select="f:stringency/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:stringency[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_stringency">
               <xsl:apply-templates select="f:stringency" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--mapping 0..* DataElement.Mapping--><xsl:if test="f:mapping">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mapping">
            <xsl:for-each select="f:mapping">
               <map>
                  <xsl:apply-templates select="." mode="DataElement.Mapping"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--element 1..* ElementDefinition--><xsl:if test="f:element">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="element">
            <xsl:for-each select="f:element">
               <map>
                  <xsl:apply-templates select="." mode="ElementDefinition"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The formal description of a single piece of information that can be gathered and reported.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataElement.Mapping">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--identity 1..1 id (json type: string)--><xsl:if test="f:identity">
         <xsl:if test="f:identity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="identity">
               <xsl:value-of select="f:identity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:identity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_identity">
               <xsl:apply-templates select="f:identity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--uri 0..1 uri (json type: string)--><xsl:if test="f:uri">
         <xsl:if test="f:uri/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="uri">
               <xsl:value-of select="f:uri/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:uri[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_uri">
               <xsl:apply-templates select="f:uri" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the degree of precision of the data element definition.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DataElementStringency">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssue">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DetectedIssue</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--status 1..1 ObservationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--severity 0..1 DetectedIssueSeverity (json type: string)--><xsl:if test="f:severity">
         <xsl:if test="f:severity/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="severity">
               <xsl:value-of select="f:severity/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:severity[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_severity">
               <xsl:apply-templates select="f:severity" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
          <!--implicated 0..* Reference--><xsl:if test="f:implicated">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="implicated">
            <xsl:for-each select="f:implicated">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--detail 0..1 string (json type: string)--><xsl:if test="f:detail">
         <xsl:if test="f:detail/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="detail">
               <xsl:value-of select="f:detail/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:detail[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_detail">
               <xsl:apply-templates select="f:detail" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--reference 0..1 uri (json type: string)--><xsl:if test="f:reference">
         <xsl:if test="f:reference/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="reference">
               <xsl:value-of select="f:reference/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:reference[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_reference">
               <xsl:apply-templates select="f:reference" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--mitigation 0..* DetectedIssue.Mitigation--><xsl:if test="f:mitigation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="mitigation">
            <xsl:for-each select="f:mitigation">
               <map>
                  <xsl:apply-templates select="." mode="DetectedIssue.Mitigation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssue.Mitigation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--action 1..1 CodeableConcept--><xsl:if test="f:action">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="action">
            <xsl:apply-templates select="f:action" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--author 0..1 Reference--><xsl:if test="f:author">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:apply-templates select="f:author" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the status of the identified issue</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ObservationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Indicates the potential degree of impact of the identified issue on the patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DetectedIssueSeverity">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource identifies an instance or a type of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.  Medical devices include durable (reusable) medical equipment, implantable devices, as well as disposable equipment used for diagnostic, treatment, and research for healthcare and public health.  Non-medical devices may include items such as a machine, cellphone, computer, application, etc.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Device">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Device</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--udi 0..1 Device.Udi--><xsl:if test="f:udi">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="udi">
            <xsl:apply-templates select="f:udi" mode="Device.Udi"/>
         </map>
      </xsl:if>
          <!--status 0..1 FHIRDeviceStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--lotNumber 0..1 string (json type: string)--><xsl:if test="f:lotNumber">
         <xsl:if test="f:lotNumber/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lotNumber">
               <xsl:value-of select="f:lotNumber/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lotNumber[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lotNumber">
               <xsl:apply-templates select="f:lotNumber" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--manufacturer 0..1 string (json type: string)--><xsl:if test="f:manufacturer">
         <xsl:if test="f:manufacturer/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="manufacturer">
               <xsl:value-of select="f:manufacturer/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:manufacturer[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_manufacturer">
               <xsl:apply-templates select="f:manufacturer" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--manufactureDate 0..1 dateTime (json type: string)--><xsl:if test="f:manufactureDate">
         <xsl:if test="f:manufactureDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="manufactureDate">
               <xsl:value-of select="f:manufactureDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:manufactureDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_manufactureDate">
               <xsl:apply-templates select="f:manufactureDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--expirationDate 0..1 dateTime (json type: string)--><xsl:if test="f:expirationDate">
         <xsl:if test="f:expirationDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="expirationDate">
               <xsl:value-of select="f:expirationDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:expirationDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_expirationDate">
               <xsl:apply-templates select="f:expirationDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--model 0..1 string (json type: string)--><xsl:if test="f:model">
         <xsl:if test="f:model/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="model">
               <xsl:value-of select="f:model/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:model[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_model">
               <xsl:apply-templates select="f:model" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          <!--owner 0..1 Reference--><xsl:if test="f:owner">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="owner">
            <xsl:apply-templates select="f:owner" mode="Reference"/>
         </map>
      </xsl:if>
          <!--contact 0..* ContactPoint--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--location 0..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--safety 0..* CodeableConcept--><xsl:if test="f:safety">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="safety">
            <xsl:for-each select="f:safety">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource identifies an instance or a type of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.  Medical devices include durable (reusable) medical equipment, implantable devices, as well as disposable equipment used for diagnostic, treatment, and research for healthcare and public health.  Non-medical devices may include items such as a machine, cellphone, computer, application, etc.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Device.Udi">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--deviceIdentifier 0..1 string (json type: string)--><xsl:if test="f:deviceIdentifier">
         <xsl:if test="f:deviceIdentifier/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="deviceIdentifier">
               <xsl:value-of select="f:deviceIdentifier/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:deviceIdentifier[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_deviceIdentifier">
               <xsl:apply-templates select="f:deviceIdentifier" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--jurisdiction 0..1 uri (json type: string)--><xsl:if test="f:jurisdiction">
         <xsl:if test="f:jurisdiction/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="jurisdiction">
               <xsl:value-of select="f:jurisdiction/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:jurisdiction[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_jurisdiction">
               <xsl:apply-templates select="f:jurisdiction" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--carrierHRF 0..1 string (json type: string)--><xsl:if test="f:carrierHRF">
         <xsl:if test="f:carrierHRF/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="carrierHRF">
               <xsl:value-of select="f:carrierHRF/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:carrierHRF[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_carrierHRF">
               <xsl:apply-templates select="f:carrierHRF" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--carrierAIDC 0..1 base64Binary (json type: string)--><xsl:if test="f:carrierAIDC">
         <xsl:if test="f:carrierAIDC/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="carrierAIDC">
               <xsl:value-of select="f:carrierAIDC/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:carrierAIDC[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_carrierAIDC">
               <xsl:apply-templates select="f:carrierAIDC" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--issuer 0..1 uri (json type: string)--><xsl:if test="f:issuer">
         <xsl:if test="f:issuer/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="issuer">
               <xsl:value-of select="f:issuer/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:issuer[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_issuer">
               <xsl:apply-templates select="f:issuer" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--entryType 0..1 UDIEntryType (json type: string)--><xsl:if test="f:entryType">
         <xsl:if test="f:entryType/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="entryType">
               <xsl:value-of select="f:entryType/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:entryType[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_entryType">
               <xsl:apply-templates select="f:entryType" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The availability status of the device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="FHIRDeviceStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Codes to identify how UDI data was entered</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="UDIEntryType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The characteristics, operational status and capabilities of a medical-related component of a medical device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceComponent">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DeviceComponent</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 1..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--lastSystemChange 0..1 instant (json type: string)--><xsl:if test="f:lastSystemChange">
         <xsl:if test="f:lastSystemChange/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="lastSystemChange">
               <xsl:value-of select="f:lastSystemChange/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:lastSystemChange[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_lastSystemChange">
               <xsl:apply-templates select="f:lastSystemChange" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--source 0..1 Reference--><xsl:if test="f:source">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="source">
            <xsl:apply-templates select="f:source" mode="Reference"/>
         </map>
      </xsl:if>
          <!--parent 0..1 Reference--><xsl:if test="f:parent">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="parent">
            <xsl:apply-templates select="f:parent" mode="Reference"/>
         </map>
      </xsl:if>
          <!--operationalStatus 0..* CodeableConcept--><xsl:if test="f:operationalStatus">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="operationalStatus">
            <xsl:for-each select="f:operationalStatus">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--parameterGroup 0..1 CodeableConcept--><xsl:if test="f:parameterGroup">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="parameterGroup">
            <xsl:apply-templates select="f:parameterGroup" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--measurementPrinciple 0..1 MeasmntPrinciple (json type: string)--><xsl:if test="f:measurementPrinciple">
         <xsl:if test="f:measurementPrinciple/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="measurementPrinciple">
               <xsl:value-of select="f:measurementPrinciple/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:measurementPrinciple[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_measurementPrinciple">
               <xsl:apply-templates select="f:measurementPrinciple" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--productionSpecification 0..* DeviceComponent.ProductionSpecification--><xsl:if test="f:productionSpecification">
         <array xmlns="http://www.w3.org/2005/xpath-functions"
                key="productionSpecification">
            <xsl:for-each select="f:productionSpecification">
               <map>
                  <xsl:apply-templates select="." mode="DeviceComponent.ProductionSpecification"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--languageCode 0..1 CodeableConcept--><xsl:if test="f:languageCode">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="languageCode">
            <xsl:apply-templates select="f:languageCode" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The characteristics, operational status and capabilities of a medical-related component of a medical device.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceComponent.ProductionSpecification">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--specType 0..1 CodeableConcept--><xsl:if test="f:specType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="specType">
            <xsl:apply-templates select="f:specType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--componentId 0..1 Identifier--><xsl:if test="f:componentId">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="componentId">
            <xsl:apply-templates select="f:componentId" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--productionSpec 0..1 string (json type: string)--><xsl:if test="f:productionSpec">
         <xsl:if test="f:productionSpec/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="productionSpec">
               <xsl:value-of select="f:productionSpec/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:productionSpec[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_productionSpec">
               <xsl:apply-templates select="f:productionSpec" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Different measurement principle supported by the device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="MeasmntPrinciple">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a measurement, calculation or setting capability of a medical device.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetric">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DeviceMetric</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 1..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--unit 0..1 CodeableConcept--><xsl:if test="f:unit">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
            <xsl:apply-templates select="f:unit" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--source 0..1 Reference--><xsl:if test="f:source">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="source">
            <xsl:apply-templates select="f:source" mode="Reference"/>
         </map>
      </xsl:if>
          <!--parent 0..1 Reference--><xsl:if test="f:parent">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="parent">
            <xsl:apply-templates select="f:parent" mode="Reference"/>
         </map>
      </xsl:if>
          <!--operationalStatus 0..1 DeviceMetricOperationalStatus (json type: string)--><xsl:if test="f:operationalStatus">
         <xsl:if test="f:operationalStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="operationalStatus">
               <xsl:value-of select="f:operationalStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:operationalStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_operationalStatus">
               <xsl:apply-templates select="f:operationalStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--color 0..1 DeviceMetricColor (json type: string)--><xsl:if test="f:color">
         <xsl:if test="f:color/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="color">
               <xsl:value-of select="f:color/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:color[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_color">
               <xsl:apply-templates select="f:color" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 1..1 DeviceMetricCategory (json type: string)--><xsl:if test="f:category">
         <xsl:if test="f:category/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="category">
               <xsl:value-of select="f:category/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:category[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_category">
               <xsl:apply-templates select="f:category" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--measurementPeriod 0..1 Timing--><xsl:if test="f:measurementPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="measurementPeriod">
            <xsl:apply-templates select="f:measurementPeriod" mode="Timing"/>
         </map>
      </xsl:if>
          <!--calibration 0..* DeviceMetric.Calibration--><xsl:if test="f:calibration">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="calibration">
            <xsl:for-each select="f:calibration">
               <map>
                  <xsl:apply-templates select="." mode="DeviceMetric.Calibration"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes a measurement, calculation or setting capability of a medical device.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetric.Calibration">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 0..1 DeviceMetricCalibrationType (json type: string)--><xsl:if test="f:type">
         <xsl:if test="f:type/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="type">
               <xsl:value-of select="f:type/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:type[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_type">
               <xsl:apply-templates select="f:type" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--state 0..1 DeviceMetricCalibrationState (json type: string)--><xsl:if test="f:state">
         <xsl:if test="f:state/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="state">
               <xsl:value-of select="f:state/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:state[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_state">
               <xsl:apply-templates select="f:state" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--time 0..1 instant (json type: string)--><xsl:if test="f:time">
         <xsl:if test="f:time/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="time">
               <xsl:value-of select="f:time/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:time[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_time">
               <xsl:apply-templates select="f:time" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the type of a metric calibration.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCalibrationType">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the typical color of representation.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricColor">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the state of a metric calibration.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCalibrationState">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the operational status of the DeviceMetric.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricOperationalStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Describes the category of the metric.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceMetricCategory">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceRequest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DeviceRequest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--definition 0..* Reference--><xsl:if test="f:definition">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="definition">
            <xsl:for-each select="f:definition">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--basedOn 0..* Reference--><xsl:if test="f:basedOn">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="basedOn">
            <xsl:for-each select="f:basedOn">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--priorRequest 0..* Reference--><xsl:if test="f:priorRequest">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="priorRequest">
            <xsl:for-each select="f:priorRequest">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--groupIdentifier 0..1 Identifier--><xsl:if test="f:groupIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="groupIdentifier">
            <xsl:apply-templates select="f:groupIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--status 0..1 RequestStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--intent 1..1 CodeableConcept--><xsl:if test="f:intent">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="intent">
            <xsl:apply-templates select="f:intent" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--priority 0..1 RequestPriority (json type: string)--><xsl:if test="f:priority">
         <xsl:if test="f:priority/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
               <xsl:value-of select="f:priority/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:priority[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_priority">
               <xsl:apply-templates select="f:priority" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
            
            <!--codeReference 1..1 Reference--><xsl:if test="f:codeReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="codeReference">
            <xsl:apply-templates select="f:codeReference" mode="Reference"/>
         </map>
      </xsl:if>
            <!--codeCodeableConcept 1..1 CodeableConcept--><xsl:if test="f:codeCodeableConcept">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="codeCodeableConcept">
            <xsl:apply-templates select="f:codeCodeableConcept" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          
          <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          
            
            <!--occurrenceDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:occurrenceDateTime">
         <xsl:if test="f:occurrenceDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="occurrenceDateTime">
               <xsl:value-of select="f:occurrenceDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:occurrenceDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_occurrenceDateTime">
               <xsl:apply-templates select="f:occurrenceDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--occurrencePeriod 1..1 Period--><xsl:if test="f:occurrencePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="occurrencePeriod">
            <xsl:apply-templates select="f:occurrencePeriod" mode="Period"/>
         </map>
      </xsl:if>
            <!--occurrenceTiming 1..1 Timing--><xsl:if test="f:occurrenceTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="occurrenceTiming">
            <xsl:apply-templates select="f:occurrenceTiming" mode="Timing"/>
         </map>
      </xsl:if>
          
          <!--authoredOn 0..1 dateTime (json type: string)--><xsl:if test="f:authoredOn">
         <xsl:if test="f:authoredOn/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="authoredOn">
               <xsl:value-of select="f:authoredOn/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:authoredOn[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_authoredOn">
               <xsl:apply-templates select="f:authoredOn" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--requester 0..1 DeviceRequest.Requester--><xsl:if test="f:requester">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requester">
            <xsl:apply-templates select="f:requester" mode="DeviceRequest.Requester"/>
         </map>
      </xsl:if>
          <!--performerType 0..1 CodeableConcept--><xsl:if test="f:performerType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="performerType">
            <xsl:apply-templates select="f:performerType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--performer 0..1 Reference--><xsl:if test="f:performer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="performer">
            <xsl:apply-templates select="f:performer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--reasonCode 0..* CodeableConcept--><xsl:if test="f:reasonCode">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonCode">
            <xsl:for-each select="f:reasonCode">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--reasonReference 0..* Reference--><xsl:if test="f:reasonReference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reasonReference">
            <xsl:for-each select="f:reasonReference">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--supportingInfo 0..* Reference--><xsl:if test="f:supportingInfo">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="supportingInfo">
            <xsl:for-each select="f:supportingInfo">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--relevantHistory 0..* Reference--><xsl:if test="f:relevantHistory">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="relevantHistory">
            <xsl:for-each select="f:relevantHistory">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceRequest.Requester">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--agent 1..1 Reference--><xsl:if test="f:agent">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="agent">
            <xsl:apply-templates select="f:agent" mode="Reference"/>
         </map>
      </xsl:if>
          <!--onBehalfOf 0..1 Reference--><xsl:if test="f:onBehalfOf">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="onBehalfOf">
            <xsl:apply-templates select="f:onBehalfOf" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseStatement">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DeviceUseStatement</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 DeviceUseStatementStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--subject 1..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--whenUsed 0..1 Period--><xsl:if test="f:whenUsed">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="whenUsed">
            <xsl:apply-templates select="f:whenUsed" mode="Period"/>
         </map>
      </xsl:if>
          
            
            <!--timingTiming 1..1 Timing--><xsl:if test="f:timingTiming">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingTiming">
            <xsl:apply-templates select="f:timingTiming" mode="Timing"/>
         </map>
      </xsl:if>
            <!--timingPeriod 1..1 Period--><xsl:if test="f:timingPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="timingPeriod">
            <xsl:apply-templates select="f:timingPeriod" mode="Period"/>
         </map>
      </xsl:if>
            <!--timingDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:timingDateTime">
         <xsl:if test="f:timingDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="timingDateTime">
               <xsl:value-of select="f:timingDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:timingDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_timingDateTime">
               <xsl:apply-templates select="f:timingDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          
          <!--recordedOn 0..1 dateTime (json type: string)--><xsl:if test="f:recordedOn">
         <xsl:if test="f:recordedOn/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="recordedOn">
               <xsl:value-of select="f:recordedOn/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:recordedOn[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_recordedOn">
               <xsl:apply-templates select="f:recordedOn" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--source 0..1 Reference--><xsl:if test="f:source">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="source">
            <xsl:apply-templates select="f:source" mode="Reference"/>
         </map>
      </xsl:if>
          <!--device 1..1 Reference--><xsl:if test="f:device">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="device">
            <xsl:apply-templates select="f:device" mode="Reference"/>
         </map>
      </xsl:if>
          <!--indication 0..* CodeableConcept--><xsl:if test="f:indication">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="indication">
            <xsl:for-each select="f:indication">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--bodySite 0..1 CodeableConcept--><xsl:if test="f:bodySite">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="bodySite">
            <xsl:apply-templates select="f:bodySite" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--note 0..* Annotation--><xsl:if test="f:note">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="note">
            <xsl:for-each select="f:note">
               <map>
                  <xsl:apply-templates select="." mode="Annotation"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A coded concept indicating the current status of a the Device Usage</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DeviceUseStatementStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReport">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DiagnosticReport</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--basedOn 0..* Reference--><xsl:if test="f:basedOn">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="basedOn">
            <xsl:for-each select="f:basedOn">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 DiagnosticReportStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--category 0..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--context 0..1 Reference--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="Reference"/>
         </map>
      </xsl:if>
          
            
            <!--effectiveDateTime 1..1 dateTime (json type: string)--><xsl:if test="f:effectiveDateTime">
         <xsl:if test="f:effectiveDateTime/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="effectiveDateTime">
               <xsl:value-of select="f:effectiveDateTime/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:effectiveDateTime[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_effectiveDateTime">
               <xsl:apply-templates select="f:effectiveDateTime" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--effectivePeriod 1..1 Period--><xsl:if test="f:effectivePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="effectivePeriod">
            <xsl:apply-templates select="f:effectivePeriod" mode="Period"/>
         </map>
      </xsl:if>
          
          <!--issued 0..1 instant (json type: string)--><xsl:if test="f:issued">
         <xsl:if test="f:issued/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="issued">
               <xsl:value-of select="f:issued/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:issued[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_issued">
               <xsl:apply-templates select="f:issued" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--performer 0..* DiagnosticReport.Performer--><xsl:if test="f:performer">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="performer">
            <xsl:for-each select="f:performer">
               <map>
                  <xsl:apply-templates select="." mode="DiagnosticReport.Performer"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--specimen 0..* Reference--><xsl:if test="f:specimen">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specimen">
            <xsl:for-each select="f:specimen">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--result 0..* Reference--><xsl:if test="f:result">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="result">
            <xsl:for-each select="f:result">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--imagingStudy 0..* Reference--><xsl:if test="f:imagingStudy">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="imagingStudy">
            <xsl:for-each select="f:imagingStudy">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--image 0..* DiagnosticReport.Image--><xsl:if test="f:image">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="image">
            <xsl:for-each select="f:image">
               <map>
                  <xsl:apply-templates select="." mode="DiagnosticReport.Image"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--conclusion 0..1 string (json type: string)--><xsl:if test="f:conclusion">
         <xsl:if test="f:conclusion/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="conclusion">
               <xsl:value-of select="f:conclusion/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:conclusion[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_conclusion">
               <xsl:apply-templates select="f:conclusion" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--codedDiagnosis 0..* CodeableConcept--><xsl:if test="f:codedDiagnosis">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="codedDiagnosis">
            <xsl:for-each select="f:codedDiagnosis">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--presentedForm 0..* Attachment--><xsl:if test="f:presentedForm">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="presentedForm">
            <xsl:for-each select="f:presentedForm">
               <map>
                  <xsl:apply-templates select="." mode="Attachment"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReport.Performer">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--role 0..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--actor 1..1 Reference--><xsl:if test="f:actor">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="actor">
            <xsl:apply-templates select="f:actor" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReport.Image">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--comment 0..1 string (json type: string)--><xsl:if test="f:comment">
         <xsl:if test="f:comment/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="comment">
               <xsl:value-of select="f:comment/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:comment[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_comment">
               <xsl:apply-templates select="f:comment" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--link 1..1 Reference--><xsl:if test="f:link">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="link">
            <xsl:apply-templates select="f:link" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the diagnostic report as a whole.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DiagnosticReportStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A collection of documents compiled for a purpose together with metadata that applies to the collection.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DocumentManifest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--masterIdentifier 0..1 Identifier--><xsl:if test="f:masterIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="masterIdentifier">
            <xsl:apply-templates select="f:masterIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 DocumentReferenceStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--author 0..* Reference--><xsl:if test="f:author">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:for-each select="f:author">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--recipient 0..* Reference--><xsl:if test="f:recipient">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="recipient">
            <xsl:for-each select="f:recipient">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--source 0..1 uri (json type: string)--><xsl:if test="f:source">
         <xsl:if test="f:source/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="source">
               <xsl:value-of select="f:source/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:source[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_source">
               <xsl:apply-templates select="f:source" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--content 1..* DocumentManifest.Content--><xsl:if test="f:content">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="content">
            <xsl:for-each select="f:content">
               <map>
                  <xsl:apply-templates select="." mode="DocumentManifest.Content"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--related 0..* DocumentManifest.Related--><xsl:if test="f:related">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="related">
            <xsl:for-each select="f:related">
               <map>
                  <xsl:apply-templates select="." mode="DocumentManifest.Related"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A collection of documents compiled for a purpose together with metadata that applies to the collection.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest.Content">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          
            
            <!--pAttachment 1..1 Attachment--><xsl:if test="f:pAttachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="pAttachment">
            <xsl:apply-templates select="f:pAttachment" mode="Attachment"/>
         </map>
      </xsl:if>
            <!--pReference 1..1 Reference--><xsl:if test="f:pReference">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="pReference">
            <xsl:apply-templates select="f:pReference" mode="Reference"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A collection of documents compiled for a purpose together with metadata that applies to the collection.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentManifest.Related">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--ref 0..1 Reference--><xsl:if test="f:ref">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ref">
            <xsl:apply-templates select="f:ref" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">DocumentReference</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--masterIdentifier 0..1 Identifier--><xsl:if test="f:masterIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="masterIdentifier">
            <xsl:apply-templates select="f:masterIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 DocumentReferenceStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--docStatus 0..1 CompositionStatus (json type: string)--><xsl:if test="f:docStatus">
         <xsl:if test="f:docStatus/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="docStatus">
               <xsl:value-of select="f:docStatus/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:docStatus[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_docStatus">
               <xsl:apply-templates select="f:docStatus" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--class 0..1 CodeableConcept--><xsl:if test="f:class">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="class">
            <xsl:apply-templates select="f:class" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--indexed 1..1 instant (json type: string)--><xsl:if test="f:indexed">
         <xsl:if test="f:indexed/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="indexed">
               <xsl:value-of select="f:indexed/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:indexed[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_indexed">
               <xsl:apply-templates select="f:indexed" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--author 0..* Reference--><xsl:if test="f:author">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="author">
            <xsl:for-each select="f:author">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--authenticator 0..1 Reference--><xsl:if test="f:authenticator">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="authenticator">
            <xsl:apply-templates select="f:authenticator" mode="Reference"/>
         </map>
      </xsl:if>
          <!--custodian 0..1 Reference--><xsl:if test="f:custodian">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="custodian">
            <xsl:apply-templates select="f:custodian" mode="Reference"/>
         </map>
      </xsl:if>
          <!--relatesTo 0..* DocumentReference.RelatesTo--><xsl:if test="f:relatesTo">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="relatesTo">
            <xsl:for-each select="f:relatesTo">
               <map>
                  <xsl:apply-templates select="." mode="DocumentReference.RelatesTo"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--securityLabel 0..* CodeableConcept--><xsl:if test="f:securityLabel">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="securityLabel">
            <xsl:for-each select="f:securityLabel">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--content 1..* DocumentReference.Content--><xsl:if test="f:content">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="content">
            <xsl:for-each select="f:content">
               <map>
                  <xsl:apply-templates select="." mode="DocumentReference.Content"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--context 0..1 DocumentReference.Context--><xsl:if test="f:context">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="context">
            <xsl:apply-templates select="f:context" mode="DocumentReference.Context"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.RelatesTo">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 DocumentRelationshipType (json type: string)--><xsl:if test="f:code">
         <xsl:if test="f:code/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="code">
               <xsl:value-of select="f:code/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:code[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_code">
               <xsl:apply-templates select="f:code" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--target 1..1 Reference--><xsl:if test="f:target">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="target">
            <xsl:apply-templates select="f:target" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Content">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--attachment 1..1 Attachment--><xsl:if test="f:attachment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="attachment">
            <xsl:apply-templates select="f:attachment" mode="Attachment"/>
         </map>
      </xsl:if>
          <!--format 0..1 Coding--><xsl:if test="f:format">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="format">
            <xsl:apply-templates select="f:format" mode="Coding"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Context">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--encounter 0..1 Reference--><xsl:if test="f:encounter">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="encounter">
            <xsl:apply-templates select="f:encounter" mode="Reference"/>
         </map>
      </xsl:if>
          <!--event 0..* CodeableConcept--><xsl:if test="f:event">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="event">
            <xsl:for-each select="f:event">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--facilityType 0..1 CodeableConcept--><xsl:if test="f:facilityType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="facilityType">
            <xsl:apply-templates select="f:facilityType" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--practiceSetting 0..1 CodeableConcept--><xsl:if test="f:practiceSetting">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="practiceSetting">
            <xsl:apply-templates select="f:practiceSetting" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--sourcePatientInfo 0..1 Reference--><xsl:if test="f:sourcePatientInfo">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="sourcePatientInfo">
            <xsl:apply-templates select="f:sourcePatientInfo" mode="Reference"/>
         </map>
      </xsl:if>
          <!--related 0..* DocumentReference.Related--><xsl:if test="f:related">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="related">
            <xsl:for-each select="f:related">
               <map>
                  <xsl:apply-templates select="." mode="DocumentReference.Related"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>A reference to a document.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="DocumentReference.Related">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--ref 0..1 Reference--><xsl:if test="f:ref">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="ref">
            <xsl:apply-templates select="f:ref" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The EligibilityRequest provides patient and insurance coverage information to an insurer for them to respond, in the form of an EligibilityResponse, with information regarding whether the stated coverage is valid and in-force and optionally to provide the insurance details of the policy.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityRequest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EligibilityRequest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 FinancialResourceStatusCodes (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--priority 0..1 CodeableConcept--><xsl:if test="f:priority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
            <xsl:apply-templates select="f:priority" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          
            
            <!--servicedDate 1..1 date (json type: string)--><xsl:if test="f:servicedDate">
         <xsl:if test="f:servicedDate/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="servicedDate">
               <xsl:value-of select="f:servicedDate/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:servicedDate[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_servicedDate">
               <xsl:apply-templates select="f:servicedDate" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--servicedPeriod 1..1 Period--><xsl:if test="f:servicedPeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="servicedPeriod">
            <xsl:apply-templates select="f:servicedPeriod" mode="Period"/>
         </map>
      </xsl:if>
          
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--enterer 0..1 Reference--><xsl:if test="f:enterer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="enterer">
            <xsl:apply-templates select="f:enterer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--insurer 0..1 Reference--><xsl:if test="f:insurer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="insurer">
            <xsl:apply-templates select="f:insurer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--facility 0..1 Reference--><xsl:if test="f:facility">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="facility">
            <xsl:apply-templates select="f:facility" mode="Reference"/>
         </map>
      </xsl:if>
          <!--coverage 0..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
          <!--businessArrangement 0..1 string (json type: string)--><xsl:if test="f:businessArrangement">
         <xsl:if test="f:businessArrangement/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="businessArrangement">
               <xsl:value-of select="f:businessArrangement/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:businessArrangement[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_businessArrangement">
               <xsl:apply-templates select="f:businessArrangement" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--benefitCategory 0..1 CodeableConcept--><xsl:if test="f:benefitCategory">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="benefitCategory">
            <xsl:apply-templates select="f:benefitCategory" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--benefitSubCategory 0..1 CodeableConcept--><xsl:if test="f:benefitSubCategory">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="benefitSubCategory">
            <xsl:apply-templates select="f:benefitSubCategory" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides eligibility and plan details from the processing of an Eligibility resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityResponse">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EligibilityResponse</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 FinancialResourceStatusCodes (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--requestProvider 0..1 Reference--><xsl:if test="f:requestProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestProvider">
            <xsl:apply-templates select="f:requestProvider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--requestOrganization 0..1 Reference--><xsl:if test="f:requestOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestOrganization">
            <xsl:apply-templates select="f:requestOrganization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--request 0..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
          <!--outcome 0..1 CodeableConcept--><xsl:if test="f:outcome">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
            <xsl:apply-templates select="f:outcome" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--disposition 0..1 string (json type: string)--><xsl:if test="f:disposition">
         <xsl:if test="f:disposition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition">
               <xsl:value-of select="f:disposition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:disposition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_disposition">
               <xsl:apply-templates select="f:disposition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--insurer 0..1 Reference--><xsl:if test="f:insurer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="insurer">
            <xsl:apply-templates select="f:insurer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--inforce 0..1 boolean (json type: boolean)--><xsl:if test="f:inforce">
         <xsl:if test="f:inforce/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="inforce">
               <xsl:value-of select="f:inforce/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:inforce[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_inforce">
               <xsl:apply-templates select="f:inforce" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--insurance 0..* EligibilityResponse.Insurance--><xsl:if test="f:insurance">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="insurance">
            <xsl:for-each select="f:insurance">
               <map>
                  <xsl:apply-templates select="." mode="EligibilityResponse.Insurance"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--form 0..1 CodeableConcept--><xsl:if test="f:form">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="form">
            <xsl:apply-templates select="f:form" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--error 0..* EligibilityResponse.Error--><xsl:if test="f:error">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="error">
            <xsl:for-each select="f:error">
               <map>
                  <xsl:apply-templates select="." mode="EligibilityResponse.Error"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides eligibility and plan details from the processing of an Eligibility resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityResponse.Insurance">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--coverage 0..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
          <!--contract 0..1 Reference--><xsl:if test="f:contract">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="contract">
            <xsl:apply-templates select="f:contract" mode="Reference"/>
         </map>
      </xsl:if>
          <!--benefitBalance 0..* EligibilityResponse.BenefitBalance--><xsl:if test="f:benefitBalance">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="benefitBalance">
            <xsl:for-each select="f:benefitBalance">
               <map>
                  <xsl:apply-templates select="." mode="EligibilityResponse.BenefitBalance"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides eligibility and plan details from the processing of an Eligibility resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityResponse.BenefitBalance">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--category 1..1 CodeableConcept--><xsl:if test="f:category">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="category">
            <xsl:apply-templates select="f:category" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subCategory 0..1 CodeableConcept--><xsl:if test="f:subCategory">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subCategory">
            <xsl:apply-templates select="f:subCategory" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--excluded 0..1 boolean (json type: boolean)--><xsl:if test="f:excluded">
         <xsl:if test="f:excluded/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="excluded">
               <xsl:value-of select="f:excluded/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:excluded[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_excluded">
               <xsl:apply-templates select="f:excluded" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--description 0..1 string (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--network 0..1 CodeableConcept--><xsl:if test="f:network">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="network">
            <xsl:apply-templates select="f:network" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--unit 0..1 CodeableConcept--><xsl:if test="f:unit">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="unit">
            <xsl:apply-templates select="f:unit" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--term 0..1 CodeableConcept--><xsl:if test="f:term">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="term">
            <xsl:apply-templates select="f:term" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--financial 0..* EligibilityResponse.Financial--><xsl:if test="f:financial">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="financial">
            <xsl:for-each select="f:financial">
               <map>
                  <xsl:apply-templates select="." mode="EligibilityResponse.Financial"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides eligibility and plan details from the processing of an Eligibility resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityResponse.Financial">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 1..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          
            
            <!--allowedUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:allowedUnsignedInt">
         <xsl:if test="f:allowedUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="allowedUnsignedInt">
               <xsl:value-of select="f:allowedUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:allowedUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_allowedUnsignedInt">
               <xsl:apply-templates select="f:allowedUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--allowedString 1..1 string (json type: string)--><xsl:if test="f:allowedString">
         <xsl:if test="f:allowedString/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="allowedString">
               <xsl:value-of select="f:allowedString/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:allowedString[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_allowedString">
               <xsl:apply-templates select="f:allowedString" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--allowedMoney 1..1 Money--><xsl:if test="f:allowedMoney">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="allowedMoney">
            <xsl:apply-templates select="f:allowedMoney" mode="Money"/>
         </map>
      </xsl:if>
          
          
            
            <!--usedUnsignedInt 1..1 unsignedInt (json type: number)--><xsl:if test="f:usedUnsignedInt">
         <xsl:if test="f:usedUnsignedInt/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="usedUnsignedInt">
               <xsl:value-of select="f:usedUnsignedInt/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:usedUnsignedInt[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_usedUnsignedInt">
               <xsl:apply-templates select="f:usedUnsignedInt" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
            <!--usedMoney 1..1 Money--><xsl:if test="f:usedMoney">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="usedMoney">
            <xsl:apply-templates select="f:usedMoney" mode="Money"/>
         </map>
      </xsl:if>
          
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides eligibility and plan details from the processing of an Eligibility resource.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EligibilityResponse.Error">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--code 1..1 CodeableConcept--><xsl:if test="f:code">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="code">
            <xsl:apply-templates select="f:code" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Encounter</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 EncounterStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--statusHistory 0..* Encounter.StatusHistory--><xsl:if test="f:statusHistory">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="statusHistory">
            <xsl:for-each select="f:statusHistory">
               <map>
                  <xsl:apply-templates select="." mode="Encounter.StatusHistory"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--class 0..1 Coding--><xsl:if test="f:class">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="class">
            <xsl:apply-templates select="f:class" mode="Coding"/>
         </map>
      </xsl:if>
          <!--classHistory 0..* Encounter.ClassHistory--><xsl:if test="f:classHistory">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="classHistory">
            <xsl:for-each select="f:classHistory">
               <map>
                  <xsl:apply-templates select="." mode="Encounter.ClassHistory"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--priority 0..1 CodeableConcept--><xsl:if test="f:priority">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="priority">
            <xsl:apply-templates select="f:priority" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--episodeOfCare 0..* Reference--><xsl:if test="f:episodeOfCare">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="episodeOfCare">
            <xsl:for-each select="f:episodeOfCare">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--incomingReferral 0..* Reference--><xsl:if test="f:incomingReferral">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="incomingReferral">
            <xsl:for-each select="f:incomingReferral">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--participant 0..* Encounter.Participant--><xsl:if test="f:participant">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="participant">
            <xsl:for-each select="f:participant">
               <map>
                  <xsl:apply-templates select="." mode="Encounter.Participant"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--appointment 0..1 Reference--><xsl:if test="f:appointment">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="appointment">
            <xsl:apply-templates select="f:appointment" mode="Reference"/>
         </map>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--length 0..1 Duration--><xsl:if test="f:length">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="length">
            <xsl:apply-templates select="f:length" mode="Duration"/>
         </map>
      </xsl:if>
          <!--reason 0..* CodeableConcept--><xsl:if test="f:reason">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="reason">
            <xsl:for-each select="f:reason">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--diagnosis 0..* Encounter.Diagnosis--><xsl:if test="f:diagnosis">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosis">
            <xsl:for-each select="f:diagnosis">
               <map>
                  <xsl:apply-templates select="." mode="Encounter.Diagnosis"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--account 0..* Reference--><xsl:if test="f:account">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="account">
            <xsl:for-each select="f:account">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--hospitalization 0..1 Encounter.Hospitalization--><xsl:if test="f:hospitalization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="hospitalization">
            <xsl:apply-templates select="f:hospitalization" mode="Encounter.Hospitalization"/>
         </map>
      </xsl:if>
          <!--location 0..* Encounter.Location--><xsl:if test="f:location">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:for-each select="f:location">
               <map>
                  <xsl:apply-templates select="." mode="Encounter.Location"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--serviceProvider 0..1 Reference--><xsl:if test="f:serviceProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="serviceProvider">
            <xsl:apply-templates select="f:serviceProvider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--partOf 0..1 Reference--><xsl:if test="f:partOf">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="partOf">
            <xsl:apply-templates select="f:partOf" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.StatusHistory">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--status 1..1 EncounterStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 1..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.ClassHistory">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--class 1..1 Coding--><xsl:if test="f:class">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="class">
            <xsl:apply-templates select="f:class" mode="Coding"/>
         </map>
      </xsl:if>
          <!--period 1..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.Participant">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--individual 0..1 Reference--><xsl:if test="f:individual">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="individual">
            <xsl:apply-templates select="f:individual" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.Diagnosis">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--condition 1..1 Reference--><xsl:if test="f:condition">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="condition">
            <xsl:apply-templates select="f:condition" mode="Reference"/>
         </map>
      </xsl:if>
          <!--role 0..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--rank 0..1 positiveInt (json type: number)--><xsl:if test="f:rank">
         <xsl:if test="f:rank/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="rank">
               <xsl:value-of select="f:rank/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:rank[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_rank">
               <xsl:apply-templates select="f:rank" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.Hospitalization">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--preAdmissionIdentifier 0..1 Identifier--><xsl:if test="f:preAdmissionIdentifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="preAdmissionIdentifier">
            <xsl:apply-templates select="f:preAdmissionIdentifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--origin 0..1 Reference--><xsl:if test="f:origin">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="origin">
            <xsl:apply-templates select="f:origin" mode="Reference"/>
         </map>
      </xsl:if>
          <!--admitSource 0..1 CodeableConcept--><xsl:if test="f:admitSource">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="admitSource">
            <xsl:apply-templates select="f:admitSource" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--reAdmission 0..1 CodeableConcept--><xsl:if test="f:reAdmission">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="reAdmission">
            <xsl:apply-templates select="f:reAdmission" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--dietPreference 0..* CodeableConcept--><xsl:if test="f:dietPreference">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="dietPreference">
            <xsl:for-each select="f:dietPreference">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--specialCourtesy 0..* CodeableConcept--><xsl:if test="f:specialCourtesy">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specialCourtesy">
            <xsl:for-each select="f:specialCourtesy">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--specialArrangement 0..* CodeableConcept--><xsl:if test="f:specialArrangement">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="specialArrangement">
            <xsl:for-each select="f:specialArrangement">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--destination 0..1 Reference--><xsl:if test="f:destination">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="destination">
            <xsl:apply-templates select="f:destination" mode="Reference"/>
         </map>
      </xsl:if>
          <!--dischargeDisposition 0..1 CodeableConcept--><xsl:if test="f:dischargeDisposition">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="dischargeDisposition">
            <xsl:apply-templates select="f:dischargeDisposition" mode="CodeableConcept"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Encounter.Location">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--location 1..1 Reference--><xsl:if test="f:location">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="location">
            <xsl:apply-templates select="f:location" mode="Reference"/>
         </map>
      </xsl:if>
          <!--status 0..1 EncounterLocationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the location.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EncounterLocationStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Current state of the encounter</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EncounterStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The technical details of an endpoint that can be used for electronic services, such as for web services providing XDS.b or a REST endpoint for another FHIR server. This may include any security context information.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="Endpoint">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">Endpoint</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 EndpointStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--connectionType 1..1 Coding--><xsl:if test="f:connectionType">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="connectionType">
            <xsl:apply-templates select="f:connectionType" mode="Coding"/>
         </map>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--managingOrganization 0..1 Reference--><xsl:if test="f:managingOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="managingOrganization">
            <xsl:apply-templates select="f:managingOrganization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--contact 0..* ContactPoint--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactPoint"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--payloadType 1..* CodeableConcept--><xsl:if test="f:payloadType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="payloadType">
            <xsl:for-each select="f:payloadType">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--payloadMimeType 0..* code (json type: string)--><xsl:if test="f:payloadMimeType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="payloadMimeType">
            <xsl:for-each select="f:payloadMimeType">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:payloadMimeType[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_payloadMimeType">
               <xsl:for-each select="f:payloadMimeType">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
          <!--address 1..1 uri (json type: string)--><xsl:if test="f:address">
         <xsl:if test="f:address/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="address">
               <xsl:value-of select="f:address/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:address[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_address">
               <xsl:apply-templates select="f:address" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--header 0..* string (json type: string)--><xsl:if test="f:header">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="header">
            <xsl:for-each select="f:header">
               <xsl:choose>
                  <xsl:when test="@value">
                     <string>
                        <xsl:value-of select="@value"/>
                     </string>
                  </xsl:when>
                  <xsl:otherwise>
                     <null/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
         </array>
         <xsl:if test="f:header[@id | f:extension]">
            <array xmlns="http://www.w3.org/2005/xpath-functions" key="_header">
               <xsl:for-each select="f:header">
                  <xsl:choose>
                     <xsl:when test=".[@id | f:extension]">
                        <map>
                           <xsl:apply-templates select="." mode="Element"/>
                        </map>
                     </xsl:when>
                     <xsl:otherwise>
                        <null/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:for-each>
            </array>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the endpoint</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EndpointStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides the insurance enrollment details to the insurer regarding a specified coverage.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EnrollmentRequest">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EnrollmentRequest</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 FinancialResourceStatusCodes (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--insurer 0..1 Reference--><xsl:if test="f:insurer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="insurer">
            <xsl:apply-templates select="f:insurer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--subject 0..1 Reference--><xsl:if test="f:subject">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="subject">
            <xsl:apply-templates select="f:subject" mode="Reference"/>
         </map>
      </xsl:if>
          <!--coverage 0..1 Reference--><xsl:if test="f:coverage">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="coverage">
            <xsl:apply-templates select="f:coverage" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides enrollment and plan details from the processing of an Enrollment resource.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EnrollmentResponse">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EnrollmentResponse</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 FinancialResourceStatusCodes (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--request 0..1 Reference--><xsl:if test="f:request">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="request">
            <xsl:apply-templates select="f:request" mode="Reference"/>
         </map>
      </xsl:if>
          <!--outcome 0..1 CodeableConcept--><xsl:if test="f:outcome">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="outcome">
            <xsl:apply-templates select="f:outcome" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--disposition 0..1 string (json type: string)--><xsl:if test="f:disposition">
         <xsl:if test="f:disposition/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="disposition">
               <xsl:value-of select="f:disposition/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:disposition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_disposition">
               <xsl:apply-templates select="f:disposition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--requestProvider 0..1 Reference--><xsl:if test="f:requestProvider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestProvider">
            <xsl:apply-templates select="f:requestProvider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--requestOrganization 0..1 Reference--><xsl:if test="f:requestOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="requestOrganization">
            <xsl:apply-templates select="f:requestOrganization" mode="Reference"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EpisodeOfCare">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">EpisodeOfCare</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 1..1 EpisodeOfCareStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--statusHistory 0..* EpisodeOfCare.StatusHistory--><xsl:if test="f:statusHistory">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="statusHistory">
            <xsl:for-each select="f:statusHistory">
               <map>
                  <xsl:apply-templates select="." mode="EpisodeOfCare.StatusHistory"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--type 0..* CodeableConcept--><xsl:if test="f:type">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:for-each select="f:type">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--diagnosis 0..* EpisodeOfCare.Diagnosis--><xsl:if test="f:diagnosis">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="diagnosis">
            <xsl:for-each select="f:diagnosis">
               <map>
                  <xsl:apply-templates select="." mode="EpisodeOfCare.Diagnosis"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--patient 1..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          <!--managingOrganization 0..1 Reference--><xsl:if test="f:managingOrganization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="managingOrganization">
            <xsl:apply-templates select="f:managingOrganization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--period 0..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
          <!--referralRequest 0..* Reference--><xsl:if test="f:referralRequest">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="referralRequest">
            <xsl:for-each select="f:referralRequest">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--careManager 0..1 Reference--><xsl:if test="f:careManager">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="careManager">
            <xsl:apply-templates select="f:careManager" mode="Reference"/>
         </map>
      </xsl:if>
          <!--team 0..* Reference--><xsl:if test="f:team">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="team">
            <xsl:for-each select="f:team">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--account 0..* Reference--><xsl:if test="f:account">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="account">
            <xsl:for-each select="f:account">
               <map>
                  <xsl:apply-templates select="." mode="Reference"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EpisodeOfCare.StatusHistory">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--status 1..1 EpisodeOfCareStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--period 1..1 Period--><xsl:if test="f:period">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="period">
            <xsl:apply-templates select="f:period" mode="Period"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EpisodeOfCare.Diagnosis">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--condition 1..1 Reference--><xsl:if test="f:condition">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="condition">
            <xsl:apply-templates select="f:condition" mode="Reference"/>
         </map>
      </xsl:if>
          <!--role 0..1 CodeableConcept--><xsl:if test="f:role">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="role">
            <xsl:apply-templates select="f:role" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--rank 0..1 positiveInt (json type: number)--><xsl:if test="f:rank">
         <xsl:if test="f:rank/@value">
            <number xmlns="http://www.w3.org/2005/xpath-functions" key="rank">
               <xsl:value-of select="f:rank/@value"/>
            </number>
         </xsl:if>
         <xsl:if test="f:rank[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_rank">
               <xsl:apply-templates select="f:rank" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>The status of the episode of care.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="EpisodeOfCareStatus">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Resource to define constraints on the Expansion of a FHIR ValueSet.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExpansionProfile">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ExpansionProfile</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--url 0..1 uri (json type: string)--><xsl:if test="f:url">
         <xsl:if test="f:url/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="url">
               <xsl:value-of select="f:url/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:url[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_url">
               <xsl:apply-templates select="f:url" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--identifier 0..1 Identifier--><xsl:if test="f:identifier">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:apply-templates select="f:identifier" mode="Identifier"/>
         </map>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--name 0..1 string (json type: string)--><xsl:if test="f:name">
         <xsl:if test="f:name/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="name">
               <xsl:value-of select="f:name/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:name[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_name">
               <xsl:apply-templates select="f:name" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--status 1..1 PublicationStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--experimental 0..1 boolean (json type: boolean)--><xsl:if test="f:experimental">
         <xsl:if test="f:experimental/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="experimental">
               <xsl:value-of select="f:experimental/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:experimental[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_experimental">
               <xsl:apply-templates select="f:experimental" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--date 0..1 dateTime (json type: string)--><xsl:if test="f:date">
         <xsl:if test="f:date/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="date">
               <xsl:value-of select="f:date/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:date[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_date">
               <xsl:apply-templates select="f:date" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--publisher 0..1 string (json type: string)--><xsl:if test="f:publisher">
         <xsl:if test="f:publisher/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="publisher">
               <xsl:value-of select="f:publisher/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:publisher[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_publisher">
               <xsl:apply-templates select="f:publisher" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--contact 0..* ContactDetail--><xsl:if test="f:contact">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="contact">
            <xsl:for-each select="f:contact">
               <map>
                  <xsl:apply-templates select="." mode="ContactDetail"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--description 0..1 markdown (json type: string)--><xsl:if test="f:description">
         <xsl:if test="f:description/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="description">
               <xsl:value-of select="f:description/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:description[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_description">
               <xsl:apply-templates select="f:description" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--useContext 0..* UsageContext--><xsl:if test="f:useContext">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="useContext">
            <xsl:for-each select="f:useContext">
               <map>
                  <xsl:apply-templates select="." mode="UsageContext"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--jurisdiction 0..* CodeableConcept--><xsl:if test="f:jurisdiction">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="jurisdiction">
            <xsl:for-each select="f:jurisdiction">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--fixedVersion 0..* ExpansionProfile.FixedVersion--><xsl:if test="f:fixedVersion">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="fixedVersion">
            <xsl:for-each select="f:fixedVersion">
               <map>
                  <xsl:apply-templates select="." mode="ExpansionProfile.FixedVersion"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--excludedSystem 0..1 ExpansionProfile.ExcludedSystem--><xsl:if test="f:excludedSystem">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="excludedSystem">
            <xsl:apply-templates select="f:excludedSystem" mode="ExpansionProfile.ExcludedSystem"/>
         </map>
      </xsl:if>
          <!--includeDesignations 0..1 boolean (json type: boolean)--><xsl:if test="f:includeDesignations">
         <xsl:if test="f:includeDesignations/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="includeDesignations">
               <xsl:value-of select="f:includeDesignations/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:includeDesignations[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_includeDesignations">
               <xsl:apply-templates select="f:includeDesignations" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--designation 0..1 ExpansionProfile.Designation--><xsl:if test="f:designation">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="designation">
            <xsl:apply-templates select="f:designation" mode="ExpansionProfile.Designation"/>
         </map>
      </xsl:if>
          <!--includeDefinition 0..1 boolean (json type: boolean)--><xsl:if test="f:includeDefinition">
         <xsl:if test="f:includeDefinition/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="includeDefinition">
               <xsl:value-of select="f:includeDefinition/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:includeDefinition[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_includeDefinition">
               <xsl:apply-templates select="f:includeDefinition" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--activeOnly 0..1 boolean (json type: boolean)--><xsl:if test="f:activeOnly">
         <xsl:if test="f:activeOnly/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="activeOnly">
               <xsl:value-of select="f:activeOnly/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:activeOnly[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_activeOnly">
               <xsl:apply-templates select="f:activeOnly" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--excludeNested 0..1 boolean (json type: boolean)--><xsl:if test="f:excludeNested">
         <xsl:if test="f:excludeNested/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="excludeNested">
               <xsl:value-of select="f:excludeNested/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:excludeNested[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_excludeNested">
               <xsl:apply-templates select="f:excludeNested" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--excludeNotForUI 0..1 boolean (json type: boolean)--><xsl:if test="f:excludeNotForUI">
         <xsl:if test="f:excludeNotForUI/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="excludeNotForUI">
               <xsl:value-of select="f:excludeNotForUI/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:excludeNotForUI[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_excludeNotForUI">
               <xsl:apply-templates select="f:excludeNotForUI" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--excludePostCoordinated 0..1 boolean (json type: boolean)--><xsl:if test="f:excludePostCoordinated">
         <xsl:if test="f:excludePostCoordinated/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="excludePostCoordinated">
               <xsl:value-of select="f:excludePostCoordinated/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:excludePostCoordinated[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions"
                 key="_excludePostCoordinated">
               <xsl:apply-templates select="f:excludePostCoordinated" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--displayLanguage 0..1 code (json type: string)--><xsl:if test="f:displayLanguage">
         <xsl:if test="f:displayLanguage/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="displayLanguage">
               <xsl:value-of select="f:displayLanguage/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:displayLanguage[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_displayLanguage">
               <xsl:apply-templates select="f:displayLanguage" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--limitedExpansion 0..1 boolean (json type: boolean)--><xsl:if test="f:limitedExpansion">
         <xsl:if test="f:limitedExpansion/@value">
            <boolean xmlns="http://www.w3.org/2005/xpath-functions" key="limitedExpansion">
               <xsl:value-of select="f:limitedExpansion/@value"/>
            </boolean>
         </xsl:if>
         <xsl:if test="f:limitedExpansion[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_limitedExpansion">
               <xsl:apply-templates select="f:limitedExpansion" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Resource to define constraints on the Expansion of a FHIR ValueSet.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExpansionProfile.FixedVersion">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--system 1..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--version 1..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--mode 1..1 SystemVersionProcessingMode (json type: string)--><xsl:if test="f:mode">
         <xsl:if test="f:mode/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="mode">
               <xsl:value-of select="f:mode/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:mode[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_mode">
               <xsl:apply-templates select="f:mode" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Resource to define constraints on the Expansion of a FHIR ValueSet.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExpansionProfile.ExcludedSystem">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--system 1..1 uri (json type: string)--><xsl:if test="f:system">
         <xsl:if test="f:system/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="system">
               <xsl:value-of select="f:system/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:system[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_system">
               <xsl:apply-templates select="f:system" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--version 0..1 string (json type: string)--><xsl:if test="f:version">
         <xsl:if test="f:version/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="version">
               <xsl:value-of select="f:version/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:version[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_version">
               <xsl:apply-templates select="f:version" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Resource to define constraints on the Expansion of a FHIR ValueSet.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExpansionProfile.Designation">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--include 0..1 ExpansionProfile.Include--><xsl:if test="f:include">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="include">
            <xsl:apply-templates select="f:include" mode="ExpansionProfile.Include"/>
         </map>
      </xsl:if>
          <!--exclude 0..1 ExpansionProfile.Exclude--><xsl:if test="f:exclude">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="exclude">
            <xsl:apply-templates select="f:exclude" mode="ExpansionProfile.Exclude"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Resource to define constraints on the Expansion of a FHIR ValueSet.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExpansionProfile.Include">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--designation 0..* ExpansionProfile.Designation1--><xsl:if test="f:designation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="designation">
            <xsl:for-each select="f:designation">
               <map>
                  <xsl:apply-templates select="." mode="ExpansionProfile.Designation1"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Resource to define constraints on the Expansion of a FHIR ValueSet.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExpansionProfile.Designation1">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--use 0..1 Coding--><xsl:if test="f:use">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="use">
            <xsl:apply-templates select="f:use" mode="Coding"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Resource to define constraints on the Expansion of a FHIR ValueSet.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExpansionProfile.Exclude">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--designation 0..* ExpansionProfile.Designation2--><xsl:if test="f:designation">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="designation">
            <xsl:for-each select="f:designation">
               <map>
                  <xsl:apply-templates select="." mode="ExpansionProfile.Designation2"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>Resource to define constraints on the Expansion of a FHIR ValueSet.</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExpansionProfile.Designation2">
      <xsl:apply-templates select="." mode="BackboneElement"/>
          <!--language 0..1 code (json type: string)--><xsl:if test="f:language">
         <xsl:if test="f:language/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="language">
               <xsl:value-of select="f:language/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:language[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_language">
               <xsl:apply-templates select="f:language" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--use 0..1 Coding--><xsl:if test="f:use">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="use">
            <xsl:apply-templates select="f:use" mode="Coding"/>
         </map>
      </xsl:if>
        </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>How to manage the intersection between a fixed version in a value set, and a fixed version of the system in the expansion profile</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="SystemVersionProcessingMode">
      <xsl:if test="@value">
         <string xmlns="http://www.w3.org/2005/xpath-functions" key="value">
            <xsl:value-of select="@value"/>
         </string>
      </xsl:if>
      <xsl:apply-templates select="." mode="Element"/>
   </xsl:template>
   <xd:doc>
      <xd:desc>
         <xd:p>This resource provides: the claim details; adjudication details from the processing of a Claim; and optionally account balance information, for informing the subscriber of the benefits provided.</xd:p>
         <xd:p>If the element is present, it must have either a @value, an @id, or extensions</xd:p>
      </xd:desc>
   </xd:doc>
   <xsl:template match="*" mode="ExplanationOfBenefit">
      <string xmlns="http://www.w3.org/2005/xpath-functions" key="resourceType">ExplanationOfBenefit</string>
      <xsl:apply-templates select="." mode="DomainResource"/>
          <!--identifier 0..* Identifier--><xsl:if test="f:identifier">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="identifier">
            <xsl:for-each select="f:identifier">
               <map>
                  <xsl:apply-templates select="." mode="Identifier"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--status 0..1 ExplanationOfBenefitStatus (json type: string)--><xsl:if test="f:status">
         <xsl:if test="f:status/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="status">
               <xsl:value-of select="f:status/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:status[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_status">
               <xsl:apply-templates select="f:status" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--type 0..1 CodeableConcept--><xsl:if test="f:type">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="type">
            <xsl:apply-templates select="f:type" mode="CodeableConcept"/>
         </map>
      </xsl:if>
          <!--subType 0..* CodeableConcept--><xsl:if test="f:subType">
         <array xmlns="http://www.w3.org/2005/xpath-functions" key="subType">
            <xsl:for-each select="f:subType">
               <map>
                  <xsl:apply-templates select="." mode="CodeableConcept"/>
               </map>
            </xsl:for-each>
         </array>
      </xsl:if>
          <!--patient 0..1 Reference--><xsl:if test="f:patient">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="patient">
            <xsl:apply-templates select="f:patient" mode="Reference"/>
         </map>
      </xsl:if>
          <!--billablePeriod 0..1 Period--><xsl:if test="f:billablePeriod">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="billablePeriod">
            <xsl:apply-templates select="f:billablePeriod" mode="Period"/>
         </map>
      </xsl:if>
          <!--created 0..1 dateTime (json type: string)--><xsl:if test="f:created">
         <xsl:if test="f:created/@value">
            <string xmlns="http://www.w3.org/2005/xpath-functions" key="created">
               <xsl:value-of select="f:created/@value"/>
            </string>
         </xsl:if>
         <xsl:if test="f:created[@id | f:extension]">
            <map xmlns="http://www.w3.org/2005/xpath-functions" key="_created">
               <xsl:apply-templates select="f:created" mode="Element"/>
            </map>
         </xsl:if>
      </xsl:if>
          <!--enterer 0..1 Reference--><xsl:if test="f:enterer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="enterer">
            <xsl:apply-templates select="f:enterer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--insurer 0..1 Reference--><xsl:if test="f:insurer">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="insurer">
            <xsl:apply-templates select="f:insurer" mode="Reference"/>
         </map>
      </xsl:if>
          <!--provider 0..1 Reference--><xsl:if test="f:provider">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="provider">
            <xsl:apply-templates select="f:provider" mode="Reference"/>
         </map>
      </xsl:if>
          <!--organization 0..1 Reference--><xsl:if test="f:organization">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="organization">
            <xsl:apply-templates select="f:organization" mode="Reference"/>
         </map>
      </xsl:if>
          <!--referral 0..1 Reference--><xsl:if test="f:referral">
         <map xmlns="http://www.w3.org/2005/xpath-functions" key="referral">
            <xsl:apply-templates select="f:referral" mode="Reference"/>
         </map>
      </xsl:if>
          <!--facility 0..1 Reference--><xsl:if test="f:facility">
         <map