xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace adfhir              = "http://art-decor.org/ns/fhir/4.0" at "../api/api-fhir.xqm";
import module namespace get                 = "http://art-decor.org/ns/fhir-settings" at "../api/fhir-settings.xqm";

let $headers                    := (request:get-attribute('response.headers') |
                                    <header name="Content-Type" value="application/xml+fhir; charset=utf-8"/>)
let $r                          := request:set-attribute('response.headers',$headers)

let $result                     := adfhir:operationOutCome(request:get-attribute('operationoutcome.severity'),(),request:get-attribute('operationoutcome.text'),())

let $r                          := if (empty($result)) then () else request:set-attribute('response.contents', $result)

return 
    $result