<!--
	Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
    
    Conversion of 
       DECOR conceptMap artefatcs
       to
       FHIR ConceptMap artefatcs (FHIR version v4.3.0: R4B)
       
    Note: ConceptMap will have significant changes in R5
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
    
    <xsl:template match="/">
        <ConceptMap xmlns="http://hl7.org/fhir">
            <xsl:apply-templates select="conceptMap/group"/>
        </ConceptMap>
        
    </xsl:template>
    
    <xsl:template match="group">
        <group xmlns="http://hl7.org/fhir">
            <source xmlns="http://hl7.org/fhir">
                <xsl:if test="source/@codeSystem">
                    <xsl:attribute name="value" select="source/@codeSystem"/>
                </xsl:if>
            </source>
            <target xmlns="http://hl7.org/fhir">
                <xsl:if test="target/@codeSystem">
                    <xsl:attribute name="value" select="target/@codeSystem"/>
                </xsl:if>
            </target>
            <xsl:apply-templates select="element"/>
        </group>
    </xsl:template>
    
    <xsl:template match="element">
        
        <element xmlns="http://hl7.org/fhir">
            <code xmlns="http://hl7.org/fhir" value="{@code}"/>
            <xsl:if test="@displayName">
                <display xmlns="http://hl7.org/fhir" value="{@displayName}"/>
            </xsl:if>
            <xsl:if test="@noMap = 'true'">
                <noMap xmlns="http://hl7.org/fhir" value="true"/>
            </xsl:if>
            <xsl:for-each select="target">
                <target xmlns="http://hl7.org/fhir">
                    <xsl:if test="@code">
                        <code xmlns="http://hl7.org/fhir" value="{@code}"/>
                    </xsl:if>
                    <xsl:if test="@displayName">
                        <display xmlns="http://hl7.org/fhir" value="{@displayName}"/>
                    </xsl:if>
                    <xsl:if test="@relationship">
                        <equivalence xmlns="http://hl7.org/fhir" value="{@relationship}"/>
                    </xsl:if>
                    <xsl:if test="comment">
                        <comment xmlns="http://hl7.org/fhir" value="{comment}"/>
                    </xsl:if>
                </target>
            </xsl:for-each>
        </element>
        
    </xsl:template>
    
</xsl:stylesheet>