<!--
	Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
    
    Conversion of 
       FHIR ConceptMap artefatcs (FHIR version v4.3.0: R4B)
       to
       DECOR conceptMap artefatcs

    Note: ConceptMap will have significant changes in R5
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:f="http://hl7.org/fhir" version="2.0">
    
    <xsl:template match="/">
        <conceptMap>
            <!-- missing meta here -->
            <xsl:for-each select="f:ConceptMap/f:sourceScopeCanonical">
                <sourceScope>
                    <xsl:if test="@value">
                        <xsl:attribute name="canonicalUri" select="@value"/>
                    </xsl:if>
                </sourceScope>
            </xsl:for-each>
            <xsl:for-each select="f:ConceptMap/f:targetScopeCanonical">
                <targetScope>
                    <xsl:if test="@value">
                        <xsl:attribute name="canonicalUri" select="@value"/>
                    </xsl:if>
                </targetScope>
            </xsl:for-each>
            <xsl:apply-templates select="f:ConceptMap/f:group"/>            
        </conceptMap>
    </xsl:template>
    
    <xsl:template name="doScope">
        <xsl:param name="elem"/>
        <xsl:param name="s"/>
        <xsl:element name="{$elem}">
            <xsl:if test="$s/@value">
                <xsl:attribute name="canonicalUri" select="$s/@value"/>
            </xsl:if>
        </xsl:element>
    </xsl:template>
        
    <xsl:template match="f:group">
        <group>
            <source>
                <xsl:if test="f:source/@value">
                    <xsl:attribute name="canonicalUri" select="f:source/@value"/>
                </xsl:if>
            </source>
            <target>
                <xsl:if test="f:target/@value">
                    <xsl:attribute name="canonicalUri" select="f:target/@value"/>
                </xsl:if>
            </target>
            <xsl:apply-templates select="f:element"/>
        </group>
    </xsl:template>
    
    <xsl:template match="f:element">
        <element>
            <xsl:if test="f:code/@value">
                <xsl:attribute name="code" select="f:code/@value"/>
            </xsl:if>
            <xsl:if test="f:display/@value">
                <xsl:attribute name="displayName" select="f:display/@value"/>
            </xsl:if>
            <xsl:if test="f:noMap/@value = 'true'">
                <xsl:attribute name="noMap" select="'true'"/>
            </xsl:if>
            <xsl:for-each select="f:target">
                <target>
                    <xsl:if test="f:code/@value">
                        <xsl:attribute name="code" select="f:code/@value"/>
                    </xsl:if>
                    <xsl:if test="f:display/@value">
                        <xsl:attribute name="displayName" select="f:display/@value"/>
                    </xsl:if>
                    <xsl:if test="f:equivalence/@value">
                        <xsl:attribute name="relationship" select="f:equivalence/@value"/>
                    </xsl:if>
                    <xsl:if test="f:comment/@value">
                        <comment language="en-US">
                            <xsl:value-of select="f:comment/@value"/>
                        </comment>
                    </xsl:if>
                </target>
            </xsl:for-each>
        </element>
    </xsl:template>
    
</xsl:stylesheet>