<!--
	Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.

    Conversion of
       DECOR questionnaires artefatcs
       to
       FHIR Questionnaires artefatcs (FHIR version v4.3.0: R4B)
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
    
    <xsl:template match="/">
        <Questionnaire xmlns="http://hl7.org/fhir">
            <xsl:apply-templates select="questionnaire/item"/>
        </Questionnaire>
    </xsl:template>
    
    <xsl:template match="item">
        <item xmlns="http://hl7.org/fhir">
            <xsl:if test="designNote">
                <extension xmlns="http://hl7.org/fhir" url="http://hl7.org/fhir/StructureDefinition/designNote" value="{designNote}"/>
            </xsl:if>
            <xsl:for-each select="terminologyServer">
                <extension xmlns="http://hl7.org/fhir" url="http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-preferredTerminologyServer" value="{@ref}"/>
            </xsl:for-each>
            <xsl:for-each select="unitOption">
                <extension xmlns="http://hl7.org/fhir" url="http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption">
                    <valueCodeableConcept xmlns="http://hl7.org/fhir">
                        <coding xmlns="http://hl7.org/fhir">
                            <xsl:if test="@canonicalUri">
                                <system xmlns="http://hl7.org/fhir" value="{@canonicalUri}"/>
                            </xsl:if>
                            <xsl:if test="@code">
                                <code xmlns="http://hl7.org/fhir" value="{@code}"/>
                            </xsl:if>
                            <xsl:if test="@displayName">
                                <display xmlns="http://hl7.org/fhir" value="{@displayName}"/>
                            </xsl:if>
                        </coding>
                        <text xmlns="http://hl7.org/fhir" value="{@displayName}"/>
                    </valueCodeableConcept>
                </extension>
            </xsl:for-each>
            <xsl:for-each select="itemControl">
                <extension xmlns="http://hl7.org/fhir" url="http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl">
                    <valueCodeableConcept xmlns="http://hl7.org/fhir">
                        <coding xmlns="http://hl7.org/fhir">
                            <xsl:if test="@canonicalUri">
                                <system xmlns="http://hl7.org/fhir" value="{@canonicalUri}"/>
                            </xsl:if>
                            <xsl:if test="@code">
                                <code xmlns="http://hl7.org/fhir" value="{@code}"/>
                            </xsl:if>
                            <xsl:if test="@displayName">
                                <display xmlns="http://hl7.org/fhir" value="{@displayName}"/>
                            </xsl:if>
                        </coding>
                        <text xmlns="http://hl7.org/fhir" value="{@displayName}"/>
                    </valueCodeableConcept>
                </extension>
            </xsl:for-each>
            <xsl:if test="@minValue">
                <extension xmlns="http://hl7.org/fhir" url="http://hl7.org/fhir/StructureDefinition/minValue" value="{@minValue}"/>
            </xsl:if>
            <xsl:if test="@maxValue">
                <extension xmlns="http://hl7.org/fhir" url="http://hl7.org/fhir/StructureDefinition/maxValue" value="{@maxValue}"/>
            </xsl:if>
            <xsl:for-each select="itemExtractionContext">
                <extension xmlns="http://hl7.org/fhir" url="ttp://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext">
                    <xsl:if test="@code">
                        <xsl:attribute name="code" select="@code"/>
                    </xsl:if>
                    <xsl:for-each select="@description|@name|@language|@expression|@reference">
                        <xsl:element name="{name()}" namespace="http://hl7.org/fhir">
                            <xsl:attribute name="value" select="."/>
                        </xsl:element>
                    </xsl:for-each>
                </extension>
            </xsl:for-each>
            <xsl:if test="@linkId">
                <linkId xmlns="http://hl7.org/fhir" value="{@linkId}"/>
            </xsl:if>
            <xsl:if test="@definition">
                <definition xmlns="http://hl7.org/fhir" value="{@definition}"/>
            </xsl:if>
            <xsl:for-each select="code">
                <code xmlns="http://hl7.org/fhir">
                    <xsl:if test="@canonicalUri">
                        <system xmlns="http://hl7.org/fhir" value="{@canonicalUri}"/>
                    </xsl:if>
                    <xsl:if test="@code">
                        <code xmlns="http://hl7.org/fhir" value="{@code}"/>
                    </xsl:if>
                    <xsl:if test="@displayName">
                        <display xmlns="http://hl7.org/fhir" value="{@displayName}"/>
                    </xsl:if>
                </code>
            </xsl:for-each>
            <xsl:if test="@prefix">
                <prefix xmlns="http://hl7.org/fhir" value="{@prefix}"/>
            </xsl:if>
            <xsl:if test="text">
                <text xmlns="http://hl7.org/fhir" value="{text}"/>
            </xsl:if>
            <xsl:if test="@type">
                <type xmlns="http://hl7.org/fhir" value="{@type}"/>
            </xsl:if>
            <xsl:if test="@required">
                <required xmlns="http://hl7.org/fhir" value="{@required}"/>
            </xsl:if>
            <xsl:if test="@repeats">
                <repeats xmlns="http://hl7.org/fhir" value="{@repeats}"/>
            </xsl:if>    
            <xsl:if test="@readOnly">
                <readOnly xmlns="http://hl7.org/fhir" value="{@readOnly}"/>
            </xsl:if>
            <xsl:if test="@maxLength">
                <maxLength xmlns="http://hl7.org/fhir" value="{@maxLength}"/>
            </xsl:if>
            <xsl:if test="answerValueSet">
                <answerValueSet xmlns="http://hl7.org/fhir" value="{answerValueSet/@ref}"/>
            </xsl:if>
            <xsl:for-each select="answerOption">
                <answerOption xmlns="http://hl7.org/fhir">
                    <xsl:choose>
                        <xsl:when test="valueInteger|valueDate|valueTime|valueString">
                            <xsl:element name="{local-name(*[1])}" namespace="http://hl7.org/fhir">
                                <xsl:attribute name="value" select="*[1]/@value"/>
                            </xsl:element>
                        </xsl:when>
                        <xsl:when test="valueCoding">
                            <valueCoding xmlns="http://hl7.org/fhir">
                                <xsl:if test="valueCoding/@canonicalUri">
                                    <system xmlns="http://hl7.org/fhir" value="{valueCoding/@canonicalUri}"/>
                                </xsl:if>
                                <xsl:if test="valueCoding/@code">
                                    <code xmlns="http://hl7.org/fhir" value="{valueCoding/@code}"/>
                                </xsl:if>
                                <xsl:if test="valueCoding/@displayName">
                                    <display xmlns="http://hl7.org/fhir" value="{valueCoding/@displayName}"/>
                                </xsl:if>
                            </valueCoding>
                        </xsl:when>
                    </xsl:choose>
                </answerOption>
            </xsl:for-each>
            <xsl:apply-templates select="item"/>
        </item>
    </xsl:template>
    
</xsl:stylesheet>