<!--
	Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.

    Conversion of
       FHIR Questionnaires artefatcs (FHIR version v4.3.0: R4B)
       to
       DECOR questionnaires artefatcs
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:f="http://hl7.org/fhir" version="2.0">
    
    <xsl:template match="/">
        <questionnaire>
            <!-- missing meta here -->
            <items>
                <xsl:apply-templates select="f:Questionnaire/f:item"/>
            </items>
        </questionnaire>
    </xsl:template>
    
    <xsl:template match="f:item">
        <item>
            <xsl:apply-templates select="f:linkId|f:definition|f:prefix|f:type|f:required|f:repeats|f:readOnly|f:maxLength|f:minValue|f:maxValue" mode="selective">
                <xsl:with-param name="attribute" select="name()"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="f:text" mode="selective"/>
            <xsl:apply-templates select="f:code" mode="selective"/>
            <xsl:apply-templates select="f:designNote" mode="selective"/>
            <xsl:apply-templates select="f:extension[@url='http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl']" mode="selective"/>
            <xsl:apply-templates select="f:extension[@url='http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption']" mode="selective"/>
            <xsl:apply-templates select="f:answerValueSet" mode="selective"/>
            <xsl:apply-templates select="f:answerOption" mode="selective"/>
            <xsl:apply-templates select="f:terminologyServer" mode="selective"/>
            <xsl:apply-templates select="f:itemExtractionContext" mode="selective"/>
            <xsl:apply-templates select="f:item"/>
        </item>
    </xsl:template>
    
    <xsl:template match="f:*" mode="selective">
        <xsl:param name="attribute"/>
        <xsl:choose>
            <xsl:when test="string-length($attribute) > 0">
                <xsl:attribute name="{name()}">
                    <xsl:value-of select="@value"/>
                </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="{name()}">
                    <xsl:value-of select="@value"/>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>    
    </xsl:template>
    
    <xsl:template match="f:text|f:designNote" mode="selective">
        <xsl:element name="{name()}">
            <xsl:attribute name="language" select="'en-US'"/>
            <xsl:choose>
                <xsl:when test="f:extension[@url='http://hl7.org/fhir/StructureDefinition/rendering-markdown']">
                    <xsl:value-of select="f:extension[@url='http://hl7.org/fhir/StructureDefinition/rendering-markdown']/f:valueMarkdown/@value/string()"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@value/string()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="f:answerOption" mode="selective">
        <answerOption>
            <xsl:choose>
                <xsl:when test="f:valueInteger|f:valueDate|f:valueTime|f:valueString">
                    <xsl:element name="{local-name(*[1])}">
                        <xsl:attribute name="value" select="*[1]/@value"/>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="f:valueCoding">
                    <valueCoding>
                        <xsl:if test="f:valueCoding/f:code">
                            <xsl:attribute name="code" select="f:valueCoding/f:code/@value"/>
                        </xsl:if>
                        <xsl:if test="f:valueCoding/f:system">
                            <xsl:attribute name="canonicalUri" select="f:valueCoding/f:system/@value"/>
                        </xsl:if>
                        <xsl:if test="f:valueCoding/f:display">
                            <xsl:attribute name="displayName" select="f:valueCoding/f:display/@value"/>
                        </xsl:if>
                        <xsl:if test="f:valueCoding/f:codeSystem">
                            <xsl:attribute name="codeSystem" select="f:valueCoding/f:codeSystem/@value"/>
                        </xsl:if>
                    </valueCoding>
                </xsl:when>
            </xsl:choose>
        </answerOption>
    </xsl:template>
    
    <xsl:template match="f:itemExtractionContext" mode="selective">
        <itemExtractionContext>
            <xsl:for-each select="f:description|f:name|f:language|f:expression|f:reference">
                <xsl:attribute name="{name()}" select="@value"/>
            </xsl:for-each>
            <xsl:copy-of select="@code"/>
        </itemExtractionContext>
    </xsl:template>
    
    <xsl:template match="f:extension[@url='http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl']" mode="selective">
        <itemControl>
            <xsl:if test="f:valueCodeableConcept/f:coding/f:code">
                <xsl:attribute name="code" select="f:valueCodeableConcept/f:coding/f:code/@value"/>
            </xsl:if>
            <xsl:if test="f:valueCodeableConcept/f:coding/f:system">
                <xsl:attribute name="canonicalUri" select="f:valueCodeableConcept/f:coding/f:system/@value"/>
            </xsl:if>
            <xsl:if test="f:valueCodeableConcept/f:coding/f:display">
                <xsl:attribute name="displayName" select="f:valueCodeableConcept/f:coding/f:display/@value"/>
            </xsl:if>
            <xsl:if test="f:valueCodeableConcept/f:coding/f:codeSystem">
                <xsl:attribute name="codeSystem" select="f:valueCodeableConcept/f:coding/f:codeSystem/@value"/>
            </xsl:if>
        </itemControl>
    </xsl:template>
    
    <xsl:template match="f:extension[@url='http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption']" mode="selective">
        <unitOption>
            <xsl:if test="f:valueCoding/f:code">
                <xsl:attribute name="code" select="f:valueCoding/f:code/@value"/>
            </xsl:if>
            <xsl:if test="f:valueCoding/f:system">
                <xsl:attribute name="canonicalUri" select="f:valueCoding/f:system/@value"/>
            </xsl:if>
            <xsl:if test="f:valueCoding/f:display">
                <xsl:attribute name="displayName" select="f:valueCoding/f:display/@value"/>
            </xsl:if>
            <xsl:if test="f:valueCoding/f:codeSystem">
                <xsl:attribute name="codeSystem" select="f:valueCoding/f:codeSystem/@value"/>
            </xsl:if>
        </unitOption>
    </xsl:template>
    
    <xsl:template match="f:answerValueSet|f:terminologyServer" mode="selective">
        <xsl:element name="{name()}">
            <xsl:attribute name="ref" select="@value"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="f:code|f:itemControl" mode="selective">
        <xsl:element name="{name()}">
            <xsl:if test="f:code">
                <xsl:attribute name="code" select="f:code/@value"/>
            </xsl:if>
            <xsl:if test="f:system">
                <xsl:attribute name="canonicalUri" select="f:system/@value"/>
            </xsl:if>
            <xsl:if test="f:display">
                <xsl:attribute name="displayName" select="f:display/@value"/>
            </xsl:if>
            <xsl:if test="f:codeSystem">
                <xsl:attribute name="codeSystem" select="f:codeSystem/@value"/>
            </xsl:if>
        </xsl:element>
    </xsl:template>
    
</xsl:stylesheet>