xquery version "3.1";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace adfix       = "http://art-decor.org/ns/fhir-permissions" at "../api/api-permissions.xqm";

let $type   := if (request:exists()) then request:get-parameter('type', 'all')[string-length() gt 0][1] else ('capabilitystatement')

return
switch ($type)
case ('capabilitystatement') return adfix:refreshCapabilityStatement(())
case ('conformance') return adfix:refreshCapabilityStatement(())
case ('cleanup') return adfix:cleanupData()
default return adfix:setPermissions()