xquery version "3.1";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace adfhir      = "http://art-decor.org/ns/fhir/4.0" at "../api/api-fhir.xqm";
import module namespace getf        = "http://art-decor.org/ns/fhir-settings" at "api/fhir-settings.xqm";
declare namespace f                 = "http://hl7.org/fhir";

let $resourceName       := request:get-attribute('request.resource')
let $id                 := request:get-attribute('request.id')
let $version            := request:get-attribute('request.version')
let $result             := 
    try {
        let $headers    := <header name="Content-Type" value="application/xml+fhir; charset=utf-8"/>
        let $r          := request:set-attribute('response.headers',$headers)
        
        return
        adfhir:getResourceMeta($resourceName,$id,$version)
    }
    catch * {
        let $desc   := concat('ERROR ',$err:code,'. Could not retrieve meta. ',$err:description,' module: ',$err:module,' (',$err:line-number,' ',$err:column-number,')')
        let $r      := request:set-attribute('response.http-status',500)
        
        return adfhir:operationOutCome('error',(),$desc,())
    }

let $r                  := if (empty($result)) then () else request:set-attribute('response.contents', $result)
(:return single result. either single ValueSet wrapped in an entry/body, or a Bundle we've created:)
return
    $result