(:
Deze query draaien na aanpassen van de loincsystem-to-snomed tabel.
:)
xquery version "3.0";
import module namespace labterm     = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

let $l2s := doc('/db/apps/lab-data/data/loincsystem-to-snomed.xml')
let $materials := doc('/db/apps/lab-data/data/materials.xml')

(: use this to check for mappings wiht missing Snomed material :)
(:return $l2s//concept[not(snomedId=$materials//material/@code)]:)

(: add materials which are missing (which are not in materials.xml but are in the mapping) :)
(:for $map in $l2s//concept[not(snomedId=$materials//material/@code)]
let $log := update insert <event>{$map/snomedId/string()}</event> into doc('/db/log.xml')/events
return 
    try {labterm:addMaterial($map/snomedId/string())}
    catch * {()}:)