xquery version "3.0";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";
import module namespace labterm = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

let $id := if (request:exists()) then request:get-parameter('id','') else ''
let $newStatus := if (request:exists()) then request:get-parameter('status','') else ''
let $labMaterial := $labterm:labMaterials/material[@id = $id]

return 
    if($labMaterial) then
        let $do := update value $labMaterial/@status with $newStatus
        let $logdata := <statusChange object="material" statusCode="{$newStatus}" effectiveTime="{substring(xs:string(current-dateTime()), 1, 19)}" user="{labterm:get-current-user()}" username="" materialId="{$id}"/>
        let $logdata := labterm:appendLog($logdata)
        return true()
    else 
        error(QName('http://art-decor.org/ns/error', 'NoMaterial'), 'No material found.')
