xquery version "3.0";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";
import module namespace labterm = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

let $id := if (request:exists()) then request:get-parameter('id','') else ''
let $newStatus := if (request:exists()) then request:get-parameter('status','') else ''
let $labMethod := $labterm:labMethods/method[@id = $id]

return 
    if($labMethod) then
        let $do := update value $labMethod/@status with $newStatus
        let $logdata := <statusChange object="method" statusCode="{$newStatus}" effectiveTime="{substring(xs:string(current-dateTime()), 1, 19)s}" user="{labterm:get-current-user()}" username="" methodId="{$id}"/>
        let $logdata := labterm:appendLog($logdata)
        return true()
    else 
        error(QName('http://art-decor.org/ns/error', 'NoMethod'), 'No method found.')
