xquery version "3.0";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";
import module namespace labterm            = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

let $data := request:get-data()
let $id := if (request:exists()) then request:get-parameter('id','') else 'inkt'
let $name := if (request:exists()) then request:get-parameter('name','') else ''
let $target := if (request:exists()) then request:get-parameter('target','') else ''
let $labMaterial := doc(concat($labterm:strLabData, '/materials.xml'))/materials/material[@id = $id]

return 
    if($target = 'delete') then
        update replace $labMaterial/@status with 'retired'
    else if ($target = 'edit' and $name) then
        update value $labMaterial/name with $name
        else 
           (error(QName('http://art-decor.org/ns/error', 'NoMaterial'), 'No material found.'))