xquery version "3.0";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";
import module namespace labterm            = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

let $data := request:get-data()
let $id := if (request:exists()) then request:get-parameter('id','') else 'inkt'
let $name := if (request:exists()) then request:get-parameter('name','') else ''
let $target := if (request:exists()) then request:get-parameter('target','') else ''
let $labMethod := doc(concat($labterm:strLabData, '/methods.xml'))/methods/method[@id = $id]

return 
    if($target = 'delete') then
        update delete $labMethod
    else if ($target = 'edit' and $name) then
        update value $labMethod/name with $name
        else 
            (error(QName('http://art-decor.org/ns/error', 'NoMethod'), 'No Method found.'))