xquery version "3.0";

import module namespace labterm            = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

let $id       := if (request:exists()) then request:get-parameter('id','') else '21003-9' 
let $material := if (request:exists()) then request:get-parameter('material','') else '11' 

let $labconcept := $labterm:labConcepts//lab_concept[concept/@loinc_num=$id]
let $do := 
    if ($labconcept/materials/material[@ref=$material] and $labconcept/concept[normalize-space(system) = 'XXX'])
    then update delete $labterm:labConcepts//lab_concept[concept/@loinc_num=$id]/materials/material[@ref=$material]
    else 
        let $newMaterial := $labterm:labMaterials//material[@id=$material]
        return 
            if ($newMaterial) 
            then
                let $do := if ($labterm:labConcepts//lab_concept[concept/@loinc_num=$id]/materials) then () else update insert <materials/> into $labterm:labConcepts//lab_concept[concept/@loinc_num=$id]
                return update insert <material ref="{$material}" status='draft'>{$newMaterial/name/string()}</material> into $labterm:labConcepts//lab_concept[concept/@loinc_num=$id]/materials
            else error(QName('http://art-decor.org/ns/error', 'NoSuchMaterial'), concat('No material with id: ', $material))
let $do := update replace $labconcept/@user with labterm:get-current-user()
let $check := labterm:checkConcept($id, 'nl-NL')
let $labConcept     := labterm:getOnlyLabConceptById($id)
return <result status="OK">{$labConcept/lab_concept}</result>