xquery version "3.0";

import module namespace labterm            = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

let $id       := if (request:exists()) then request:get-parameter('id','') else '21003-9' 
let $method := if (request:exists()) then request:get-parameter('method','') else '94' 

let $labconcept := $labterm:labConcepts//lab_concept[concept/@loinc_num=$id]
let $do := 
    if ($labconcept/methods/method[@ref=$method])
    then update delete $labterm:labConcepts//lab_concept[concept/@loinc_num=$id]/methods/method[@ref=$method]
    else 
        let $newMethod := $labterm:labMethods//method[@id=$method]
        return 
            if ($newMethod) 
            then
                let $do := if ($labterm:labConcepts//lab_concept[concept/@loinc_num=$id]/methods) then () else update insert <methods/> into $labterm:labConcepts//lab_concept[concept/@loinc_num=$id]
                return update insert <method ref="{$method}">{$newMethod/name/string()}</method> into $labterm:labConcepts//lab_concept[concept/@loinc_num=$id]/methods
            else error(QName('http://art-decor.org/ns/error', 'NoSuchMethod'), concat('No method with id: ', $method))
let $do := update replace $labconcept/@user with labterm:get-current-user()
let $check := labterm:checkConcept($id, 'nl-NL')
let $labConcept     := labterm:getOnlyLabConceptById($id)
return <result status="OK">{$labConcept/lab_concept}</result>