xquery version "3.0";

import module namespace labterm            = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

declare variable $tests := doc('tests.xml')/tests;

declare %private function local:success($success as xs:boolean, $name as xs:string, $details as node()?) {
    update insert <test name="{$name}" result="{if ($success) then 'success' else 'error'}">{if ($success) then () else $details}</test> into $tests
};

let $start := for $node in $tests/* return update delete $node 

let $loincId := '56146-4'

let $desc := 'there are 0 lab concepts after removeLabConcept'
let $test := labterm:removeLabConcept($loincId)
let $test := labterm:getOnlyLabConceptById($loincId)
let $result := 
    local:success(if ($test/@count='0') then true() else false(), $desc, $test)

let $desc := 'there is 1 lab concept after addLabConcept'
let $test := labterm:getLabConceptById($loincId, 'nl-NL', true())
let $test := labterm:addLabConcept($test/lab_concept)
let $test := labterm:getOnlyLabConceptById($loincId)
let $result := 
    local:success(if ($test/@count='1') then true() else false(), $desc, $test)

let $desc := 'change status draft to deprecated is not allowed'
let $test := labterm:changeStatus('deprecated', $loincId)
let $test := labterm:getOnlyLabConceptById($loincId)
let $result := 
    local:success(if ($test/lab_concept/@status='draft') then true() else false(), $desc, $test)

let $desc := 'change status draft to final is allowed'
let $test := labterm:changeStatus('final', $loincId)
let $test := labterm:getOnlyLabConceptById($loincId)
let $result := 
    local:success(if ($test/lab_concept/@status='final') then true() else false(), $desc, $test)

let $desc := 'insert local longName'
let $test := labterm:updateLongName($loincId, 'xxx')
let $test := labterm:getOnlyLabConceptById($loincId)
let $result := 
    local:success(if ($test/lab_concept/concept/concept/longName='xxx') then true() else false(), $desc, $test)

let $desc := 'update local longName'
let $test := labterm:updateLongName($loincId, 'yyy')
let $test := labterm:getOnlyLabConceptById($loincId)
let $result := 
    local:success(if ($test/lab_concept/concept/concept/longName='yyy') then true() else false(), $desc, $test)

let $count := update insert attribute success {count($tests/test[@result='success'])} into $tests 
let $count := update insert attribute error {count($tests/test[@result='error'])} into $tests 
let $count := update insert attribute total {count($tests/test)} into $tests 
return $tests