xquery version "3.0";

import module namespace nlLongName  = "http://art-decor.org/ns/nlLongName" at "../api/api-nl-longname.xqm";
import module namespace labterm = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

(:nlLCN:test_all():)

(:
    Just for testing, this takes a loinc_num.
    For all other cases, use generateTranslation, which takes a labconcept.
:)
declare %private function local:testGenerateTranslation($loincId as xs:string) as xs:string? {
    let $lab_concept    := labterm:getLabConceptById($loincId, 'nl-NL', false(), '')
	return $lab_concept/lab_concept/longNameNL/string()
};


let $testcases      := doc('../tests/lcn-testen.xml')
return 
<gens>{
    for $testcase in $testcases/*/*
    let $generated  := local:testGenerateTranslation($testcase/LOINC_x0020_ID/string())
    let $expected   := $testcase/LCN-voorzet/string()
    let $klopt      := $generated = $expected
    
    return 
        <gen>
            <expected>{$expected}</expected>
            <generate>{$generated}</generate>
            <matching>{$generated = $expected}</matching>
        </gen>
}</gens>