xquery version "3.0";

module namespace labsearch = "http://art-decor.org/ns/labsearch";
import module namespace labterm            = "http://art-decor.org/ns/labterm" at "../api/api-labterm.xqm";

declare %private function local:exclude($parts as xs:string*, $results as node()*) as node()*{
    let $part := $parts[last()]
    let $part := if (starts-with($part, '+')) then substring($part, 2) else $part
    let $axis := substring-before($part, ':')
    let $text := substring-after($part, ':')
    (:'pro', 'tim', 'sys', 'sca', 'cla', 'err':)
    let $results:=
        if ($axis = '-pro')
        then $results[not(starts-with(.//property/lower-case(.), $text))]
        else if ($axis = '-tim')
        then $results[not(starts-with(.//timing/lower-case(.), $text))]
        else if ($axis = '-sys')
        then $results[not(starts-with(.//system/lower-case(.), $text))]
        else if ($axis = '-sca')
        then $results[not(starts-with(.//scale/lower-case(.), $text))]
        else if ($axis = '-cla')
        then $results[not(starts-with(.//class/lower-case(.), $text))]
        else if ($axis = '-err')
        then $results[not(starts-with(.//errors/*/lower-case(@code), $text))]
        else $results
    return
        if (count($parts) > 1) 
        then local:exclude($parts[not(position()=last())], $results) 
        else $results
};

declare %private function local:include($parts as xs:string*, $results as node()*) as node()*{
    (:'pro', 'tim', 'sys', 'sca', 'cla', 'err':)
    let $proin := $parts[starts-with(., 'pro')]
    let $timin := $parts[starts-with(., 'tim')]
    let $sysin := $parts[starts-with(., 'sys')]
    let $scain := $parts[starts-with(., 'sca')]
    let $clain := $parts[starts-with(., 'cla')]
    let $errin := $parts[starts-with(., 'err')]
    let $results :=
        if (count($proin) > 0) then
            for $include in $proin
            return $results[starts-with(.//property/lower-case(.), substring-after($include, ':'))]
        else $results
    let $results :=
        if (count($timin) > 0) then
            for $include in $timin
            return $results[starts-with(.//timing/lower-case(.), substring-after($include, ':'))]
        else $results
    let $results :=
        if (count($sysin) > 0) then
            for $include in $sysin
            return $results[starts-with(.//system/lower-case(.), substring-after($include, ':'))]
        else $results
    let $results :=
        if (count($scain) > 0) then
            for $include in $scain
            return $results[starts-with(.//scale/lower-case(.), substring-after($include, ':'))]
        else $results
    let $results :=
        if (count($clain) > 0) then
            for $include in $clain
            return $results[starts-with(.//class/lower-case(.), substring-after($include, ':'))]
        else $results
    let $results :=
        if (count($errin) > 0) then
            for $include in $errin
            return $results[starts-with(.//errors/*/lower-case(@code), substring-after($include, ':'))]
        else $results
    return
        $results
};

declare %private function local:unitQuery($query as xs:string*, $results as node()*) as node()*{
    let $unitq := tokenize($query, ' ')[contains(., 'unit:')]
    let $unitId := $labterm:labUnits//unit[rm=substring-after($unitq, ':')]/@id
    return $results[.//unit/@ref=$unitId]
};

(:~ Normalize to single space, split on space, remove chars which could end statement and cause xquery injection :)
(: Also replace Lucene special characters - I couldn't make escaping work :)
declare %private function local:parse($query as xs:string) as xs:string*{
    tokenize(lower-case(normalize-space(translate($query,  '&amp;|!(){}[]^"~*?\/', '                '))), ' ')
};

(: textQuery discards all axis parts (containing ':') and searches :)
declare %private function local:textQuery($parts as xs:string*) as node()*{
    let $options := 
        <options>
            <filter-rewrite>yes</filter-rewrite>
        </options>
    let $col := $labterm:labConcepts
    let $text := for $part in $parts 
                 where not(contains($part, ':')) 
                 return concat($part, '*')
    let $textquery  := string-join($text, ' AND ')
    let $results := 
        if (not($textquery) or $textquery = '**') then $col else $col//lab_concept[ft:query(., $textquery, $options)]
    return $results
};

(: Text search in prerelease, text only :)
declare function labsearch:prereleaseQuery($query as xs:string*) as node()*{
    let $options := 
        <options>
            <filter-rewrite>yes</filter-rewrite>
        </options>
    let $col := $labterm:loincPrerelease
    let $parts := local:parse($query)
    let $textquery := 
    if ($query = '*') then '**'
        else
        let $text := for $part in $parts 
                 where not(contains($part, ':')) 
                 return concat($part, '*')
    return string-join($text, ' AND ')
    let $results := 
        if (not($textquery) or $textquery = '**') then $col//concept else $col//concept[ft:query(., $textquery, $options)]
    return $results
};

declare %private function local:axisQuery($parts as xs:string*, $results as node()*) as node()*{
    let $qualifiers :=  
        for $part in $parts[contains(., ':')]
        let $axis := substring-before($part, ':')
        let $axis := if (starts-with($axis, '+')) then substring($axis, 2, 5) else substring($axis, 1, 4)
        let $condition := substring-after($part, ':')
        return concat($axis, ':', $condition)
    return if (count($qualifiers) > 0) 
    then 
        let $includes := $qualifiers[not(starts-with(., '-'))] 
        let $excludes := $qualifiers[starts-with(., '-')] 
        let $results := if (count($includes) > 0) then local:include($includes, $results) else $results
        let $results := if (count($excludes) > 0) then local:exclude($excludes, $results) else $results
        return $results
    else $results
};

(: query first searches for text parts (without ':' and then filters for axes :)
declare function labsearch:query($query as xs:string) as node()*{
    let $query := if (contains($query, "uni:")) then fn:replace($query, 'uni:', 'unit:') else $query
    let $subquery := if (contains($query, "unit:")) then string-join(tokenize($query, ' ')[not(contains(., 'unit:'))], ' ') else $query
    let $parts := local:parse($subquery)
    let $results := local:textQuery($parts)
    let $results := local:axisQuery($parts, $results)
    let $results := if (contains($query, "unit:")) then local:unitQuery($query, $results) else $results
    return 
        <results count="{count($results)}" query="{string-join($parts, ' ')}">
            {$results}
        </results>
};

(: textOnlyQuery discards all axis parts (containing ':') and searches :)
declare function labsearch:textOnlyQuery($query as xs:string) as node()*{
    let $parts := local:parse($query)
    let $results := local:textQuery($parts)
    return 
        <results count="{count($results)}" query="{string-join($parts, ' ')}">
            {$results}
        </results>
};