xquery version "3.0";
(:
	Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
	see https://art-decor.org/mediawiki/index.php?title=Copyright
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU Lesser General Public License as published by the Free Software Foundation; either version
	2.1 of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
	without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU Lesser General Public License for more details.
	
	The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace art         = "http://art-decor.org/ns/art" at "../../art/modules/art-decor.xqm";
import module namespace adofix   = "http://art-decor.org/ns/oids/permissions" at "xmldb:exist:///db/apps/tools/oids/modules/../api/api-permissions.xqm";
import module namespace sm          = "http://exist-db.org/xquery/securitymanager";
import module namespace xmldb       = "http://exist-db.org/xquery/xmldb";
import module namespace repo        = "http://exist-db.org/xquery/repo";

(: The following external variables are set by the repo:deploy function :)

(: file path pointing to the exist installation directory :)
declare variable $home external;
(: path to the directory containing the unpacked .xar package :)
declare variable $dir external;
(: the target collection into which the app is deployed :)
declare variable $target external;
declare variable $root := repo:get-root();

declare %private function local:buildLookupFiles() {
let $strOidsData        := concat($root,'tools/oids-data')
let $registryCollection := collection($strOidsData)/myoidregistry

let $handleLookup       :=
    for $registry in $registryCollection
    let $lookupResourceName  := concat($registry/@name/string(), 'oids-lookup.xml')
    let $lookupContent       :=
        <oidList name="{$registry/@name/string()}">
        {
            for $oid in $registry//oid
            return
            <oid oid="{$oid/dotNotation/@value}">
            {
                for $desc in $oid/description
                return (
                    <name language="{$desc/@language}">{
                        if ($desc/thumbnail[@value]) then 
                            $desc/thumbnail/@value/string() 
                        else (
                            substring($desc/@value/string(),1,200),
                            if (string-length($desc/@value/string())>200) then '...' else()
                        )
                    }</name>,
                    <desc language="{$desc/@language}">{$desc/@value/string()}</desc>
                )
            }
            </oid>
        }
        </oidList>
    let $removeCurrentLookup := 
        if (doc-available(concat($strOidsData,'/',$lookupResourceName))) then 
            xmldb:remove($strOidsData,$lookupResourceName)
        else ()
    return
        xmldb:store($strOidsData,$lookupResourceName,$lookupContent)

return ()
};


adofix:setOidsPermissions(),
local:buildLookupFiles(),
try { art:saveFormResources('tools/oids',art:mergeLocalLanguageUpdates('tools/oids')) } catch * {()}