xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
    
    update insert $desc into $concept
    
:)

import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "../../../art/modules/art-decor-settings.xqm";
import module namespace snomed              = "http://art-decor.org/ns/terminology/snomed" at "../../snomed/api/api-snomed.xqm";




let $concepts :=collection(concat($get:strTerminologyData,'/nictiz-demo-data/import'))//concept

for $concept in $concepts
let $descriptions :=collection(concat($get:strTerminologyData,'/nictiz-demo-data/import'))//description[@conceptId=$concept/@conceptId]
for $description in $descriptions

let $acceptability   :=  collection(concat($get:strTerminologyData,'/nictiz-demo-data/import'))//language[@referencedComponentId=$description/@id]/@acceptabilityId
let $type            := 
      if ($acceptability='900000000000548007' and $description/@typeId='900000000000003001') then
         'fsn'
      else if ($acceptability='900000000000548007' and $description/@typeId='900000000000013009') then
         'pref'
      else 'syn'
let $desc :=
   <desc type="{$type}" languageCode="{$description/@languageCode}">{$description/@term/string()}</desc>

return
if ($description) then
   update insert $desc into $concept
else()
    