xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace adterminology       = "http://art-decor.org/ns/terminology" at "../api/api-terminology.xqm";

let $context       := if (request:exists()) then request:get-parameter('context','') else ('')
let $codeSystemIds       := if (request:exists()) then request:get-parameter('codeSystemIds','') else ('')
let $searchLanguages     := if (request:exists()) then request:get-parameter('languages','') else ('')
let $searchString       := if (request:exists()) then util:unescape-uri(request:get-parameter('string',''),'UTF-8') else ()
let $statusCodes        := if (request:exists()) then tokenize(normalize-space(request:get-parameter('statusCode','active')),'\s') else ()
let $searchScope        := if (request:exists()) then tokenize(normalize-space(request:get-parameter('scope','description')),'\s') else ()
let $ancestors          := if (request:exists()) then tokenize(util:unescape-uri(request:get-parameter('ancestors',''),'UTF-8'),'\s') else ()
let $refsets            := if (request:exists()) then tokenize(util:unescape-uri(request:get-parameter('refsets',''),'UTF-8'),'\s') else ()
let $compose            := request:get-data()/compose


(:
let $codeSystemId       := ''
let $searchLanguage     := ''
let $searchString       := 'lo pa ba'
let $statusCodes        := ''
let $searchScope        := ''
let $ancestors          := ''
let $refsets            := '':)

let $maxResults        :=xs:integer('20')


return
    adterminology:searchDesignation($context,$codeSystemIds, $searchLanguages, $searchString,$maxResults, $statusCodes, $searchScope,$ancestors,$refsets,$compose)