xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "../../../art/modules/art-decor-settings.xqm";
import module namespace snomed              = "http://art-decor.org/ns/terminology/snomed" at "../../snomed/api/api-snomed.xqm";

declare variable $maxResults     := xs:integer('50');


let $mappings := collection(concat($get:strTerminologyData,'/nictiz-demo-data/nhg'))//concept

return
    for $concept in $mappings
      let $snomedConcepts :=
         for $id in $concept/conceptId
         let $snomedConcept := $snomed:colDataBase//concept[@conceptId=$id]
         let $patientFriendly := if ($snomedConcept/desc[@languageRefsetId='15551000146102']) then
            'true'
            else 'false'
         return
         <conceptId patientFriendly="{$patientFriendly}">
            {$id/text()}
         </conceptId>
      let $snomedId :=
         if (count($snomedConcepts) gt 1) then
            if ($snomedConcepts[@patientFriendly='true']) then
               $snomedConcepts[@patientFriendly='true'][1]/text()
            else $snomedConcepts[1]/text()
         else $snomedConcepts/text()
    return
    <concept code="{$concept/@code}" conceptId="{$snomedId}">
      {
      
      $snomedConcepts
      ,
      $concept/desc}
    </concept>