xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "../../../art/modules/art-decor-settings.xqm";
import module namespace snomed              = "http://art-decor.org/ns/terminology/snomed" at "../../snomed/api/api-snomed.xqm";

let $descriptions :=collection(concat($get:strTerminologyData,'/nictiz-demo-data/import'))//row

for $description in $descriptions
let $multiConcept :=collection(concat($get:strTerminologyData,'/nictiz-demo-data/import'))//concept[@conceptId=$description/SCTID]
let $desc :=
   <desc type="pref" languageCode="pl">{normalize-space($description/PTN_-_Pools/text())}</desc>

return
if ($multiConcept) then
   update insert $desc into $multiConcept
else
   let $snomedConcept := $snomed:colDataBase//concept[@conceptId=$description/@conceptId]
   let $newConcept :=
              <concept>
        {
            $snomedConcept[1]/@*,
            $snomedConcept[1]/desc,
            $desc

        }
        </concept>
    return
    update insert $newConcept into collection(concat($get:strTerminologyData,'/nictiz-demo-data/import'))//concepts
    