xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace snomed              = "http://art-decor.org/ns/terminology/snomed" at "../api/api-snomed.xqm";

let $conceptId  := request:get-parameter('id','38102005')
let $op         := request:get-parameter('op','is-a')
let $maxstring  := request:get-parameter('max','0')

let $concept    := snomed:getRawConcept($conceptId)
let $max        := if ($maxstring castable as xs:int) then xs:int($maxstring) else 0

return
<conceptHierarchy>{snomed:getConceptHierarchy($op, $concept, $max)}</conceptHierarchy>