xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace snomed              = "http://art-decor.org/ns/terminology/snomed" at "../api/api-snomed.xqm";

let $conceptId      := request:get-parameter('id',())
let $refsetId       := request:get-parameter('refsetId',())

(:let $conceptId := '251000146104'
let $refsetId :='231000146105':)
(:let $refsetEffectiveDate :='2012-12-03':)
(:let $conceptId := '38102005':)

let $concept := $snomed:colDataBase//concept[@conceptId=$conceptId]

return
<concepts>
{
        <concept>
        {
            $concept[1]/@*,
            $concept[1]/*[not(name()='maps')],
            <simpleMaps>
            {
                for $map in $concept[1]/maps/map[empty(@mapGroup)]
                return $map
            }
            </simpleMaps>
            ,
            <complexMaps>
            {
                for $map in $concept[1]/maps/map[@mapGroup]
                let $mapping := $map/@refsetId 
                group by $mapping
                return
                    <map refsetId="{$mapping}" refset="{$map[1]/@refset}">
                    {
                        for $group in $map
                        let $grp := $group/@mapGroup
                        group by $grp
                        order by $grp
                        return
                            <group>
                            {
                                for $item in $group
                                order by $item/@mapPriority
                                return $item
                            }
                            </group>
                    }
                    </map>
            }
            </complexMaps>
        }
        </concept>
}
</concepts>