xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace adterminology       = "http://art-decor.org/ns/terminology" at "../api/api-terminology.xqm";

declare namespace output = "http://www.w3.org/2010/xslt-xquery-serialization";
declare option output:method "json";
declare option output:media-type "application/json";

let $codeSystemId       := if (request:exists()) then request:get-parameter('codeSystem','') else ('')
let $code               := if (request:exists()) then util:unescape-uri(request:get-parameter('code',''),'UTF-8') else ()
let $languages          := if (request:exists()) then request:get-parameter('languages','') else ('')
let $preferred          := if (request:exists()) then request:get-parameter('preferred','') else ('')
let $length          := if (request:exists()) then request:get-parameter('length','') else ('')

(:let $codeSystemId       := '2.16.840.1.113883.6.96'
let $language           := ''
let $code               := '372897005':)
let $compose         := ()
return
  (:  adterminology:getRawConcept($codeSystemId,$code):)
  adterminology:getConceptForLanguages($codeSystemId,$code,$preferred,$languages,$length,$compose)