xquery version "3.1";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
    

    
    
       if ($action='store') then
      try {
      xmldb:store(concat($get:strTerminologyData,'/nictiz-demo-data/zib/nursing-problems'),concat($problemId,'.xml'),$problem)
  
      }
      catch * {()}
   else if ($action='update' and $problem) then
      try {
      update replace collection(concat($get:strTerminologyData,'/nictiz-demo-data/zib/nursing-problems'))//problem[@id=$problemId]  with $problem
      } 
      catch * {()}
   else()
    
:)

import module namespace get      = "http://art-decor.org/ns/art-decor-settings" at "../../../art/modules/art-decor-settings.xqm";
import module namespace aduser   = "http://art-decor.org/ns/art-decor-users" at "../../../art/api/api-user-settings.xqm";

declare namespace request        = "http://exist-db.org/xquery/request";
declare namespace response       = "http://exist-db.org/xquery/response";
declare namespace sm             = "http://exist-db.org/xquery/securitymanager";
declare namespace output         = "http://www.w3.org/2010/xslt-xquery-serialization";
declare namespace fn             = "http://www.w3.org/2005/xpath-functions";

declare option    output:method "json";
declare option    output:media-type "application/json";

let $inputData := util:binary-to-string(request:get-data())

let $nodes     := json-to-xml($inputData)/fn:map
let $id        := util:uuid()
let $problemId := $nodes/fn:string[@key='problemId']/text()

let $treatmentObjective   :=
                  <treatmentObjective id="{$id}" problemId="{$nodes/fn:string[@key='problemId']/text()}" createDate="{current-dateTime()}">
                     <text>{$nodes/fn:string[@key='text']/text()}</text>
                  </treatmentObjective>
           





return
<result>
{
   try {
   if (collection(concat($get:strTerminologyData,'/nictiz-demo-data/zib/nursing-problems'))//problem[@id=$problemId]/treatmentObjective) then
      update insert $treatmentObjective preceding collection(concat($get:strTerminologyData,'/nictiz-demo-data/zib/nursing-problems'))//problem[@id=$problemId]/treatmentObjective[1]
   else
      update insert $treatmentObjective into collection(concat($get:strTerminologyData,'/nictiz-demo-data/zib/nursing-problems'))//problem[@id=$problemId]
   }
   catch * {('error')}
}
</result>