xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace snomed              = "http://art-decor.org/ns/terminology/snomed" at "../api/api-snomed.xqm";

let $conceptId      := request:get-parameter('conceptId','138875005')
(:let $conceptId    := '302619004':)

let $desc           := snomed:getActiveDescriptionsForId($conceptId)
let $current        := if ($desc) then 1 else 0

return
    <result current="{$current}" count="{$current}">
    {
        if ($desc) then 
            <description type="pref" conceptId="{$conceptId}" fullName="{$desc[@type='fsn']/text()}">{$desc[@type='pref'][@languageCode='en'][1]/text()}</description>
        else ()
    }
    </result>