xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get ="http://art-decor.org/ns/art-decor-settings" at "../../../art/modules/art-decor-settings.xqm";
import module namespace art ="http://art-decor.org/ns/art" at "../../../art/modules/art-decor.xqm";
(:declare option exist:serialize "method=text media-type=text/xml charset=utf-8";:)
let $refsetId:= request:get-parameter('id','')

let $refset :=collection(concat($get:strTerminologyData,'/snomed-extension/refsets'))//refset[@id=$refsetId]
let $refsetProject := collection(concat($get:strTerminologyData,'/snomed-extension/meta'))//project[@ref=$refsetId]
return
<refset private="{$refsetId}">
   {
   $refset/@*,
   $refsetProject/name,
   $refsetProject/moduleDependency
   }
   <members>
      {
         for $member in $refset/member[@statusCode='active']
         return
         $member
      }
   </members>
</refset>
