xquery version "1.0";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)
import module namespace get ="http://art-decor.org/ns/art-decor-settings" at "../../../art/modules/art-decor-settings.xqm";

let $mappingId := request:get-parameter('id','')


(: get user for permission check:)
let $user := get:strCurrentUserName()
let $project :=collection(concat($get:strTerminologyData,'/ica-data/meta'))/project
let $edit := xs:boolean($project/author[@username=$user]/@edit)

let $response :=
   (:check if user is authorized:)
   if ($edit) then
      let $mapping := collection(concat($get:strTerminologyData,'/ica-data/concepts'))//ci/*[@id=$mappingId]
       return
       (
       if ($mapping/@statusCode='draft') then
         update delete $mapping
       else(),
       <response>OK</response>
       )
   else(<member>NO PERMISSION</member>)
return
$response