xquery version "1.0";

import module namespace xdb="http://exist-db.org/xquery/xmldb";

(: The following external variables are set by the repo:deploy function :)

(: file path pointing to the exist installation directory :)
declare variable $home external;
(: path to the directory containing the unpacked .xar package :)
declare variable $dir external;
(: the target collection into which the app is deployed :)
declare variable $target external;

declare %private function local:mkcol-recursive($collection, $components) {
    if (exists($components)) then
        let $newColl := concat($collection, "/", $components[1])
        return (
            xdb:create-collection($collection, $components[1]),
            local:mkcol-recursive($newColl, subsequence($components, 2))
        )
    else
        ()
};

(: Helper function to recursively create a collection hierarchy. :)
declare %private function local:mkcol($collection, $path) {
    local:mkcol-recursive($collection, tokenize($path, "/"))
};

(: store the collection configuration :)
let $datacoll := concat($target, '/data')
let $panelcoll := concat($target, '/panels')
let $datadir := concat($dir, '/data')
let $paneldir := concat($dir, '/panels')
return 
(
local:mkcol("/db/system/config", $datacoll),
xdb:store-files-from-pattern(concat("/system/config", $datacoll), $datadir, "*.xconf"),
local:mkcol("/db/system/config", $panelcoll),
xdb:store-files-from-pattern(concat("/system/config", $panelcoll), $paneldir, "*.xconf")
)