xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";
import module namespace adxaccounts = "http://art-decor.org/ns/art-decor/xis/accounts" at "../api/api-xis-accounts.xqm";

declare namespace xmldb         = "http://exist-db.org/xquery/xmldb";
declare namespace expath        = "http://expath.org/ns/pkg";

let $account            := if (request:exists()) then request:get-parameter('account',()) else ('art-decor')

let $packages           := 
    if (string-length($account)=0) then
        xmldb:get-child-collections($get:strHl7)
    else (
        adxaccounts:getXmlResourcesPaths($account)
    )

return
<list>
{
    for $package in $packages
    let $packageName            := if (string-length($account)=0) then $package else tokenize($package,'/')[last()]
    let $packagePath            := if (string-length($account)=0) then concat($get:strHl7,'/',$packageName) else $package
    let $packageDisplayName     := try { collection(concat($get:strHl7,'/',$packageName))/expath:package/expath:title } catch * {()}
    let $packageDisplayName     := if (string-length($packageDisplayName)=0) then $packageName else $packageDisplayName
    order by lower-case($packageName)
    return
    <version name="{$packageName}" displayName="{$packageDisplayName}" uriString="{$packagePath}">
    {
        adxaccounts:getViewersByPackage($packageName)/viewer
    }
    </version>
}
</list>