xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";
import module namespace adxfiles    = "http://art-decor.org/ns/art-decor/xis/files" at "../api/api-xis-files.xqm";
import module namespace adserver    = "http://art-decor.org/ns/art-decor-server" at "../../art/api/api-server-settings.xqm";

declare namespace hl7       = "urn:hl7-org:v3";

let $account                := request:get-parameter('account','')

let $xmlPath                := 
   if (string-length($account)>0) then
      concat($get:strXisAccounts, '/',$account,'/',$adxfiles:_filedir)
   else ()

let $patients               :=
    for $patient in (collection($xmlPath)/file/data//hl7:Patient[hl7:Person/hl7:name] | 
                     collection($xmlPath)/file/data//hl7:patient[hl7:patientPerson/hl7:name])
    let $id := $patient/hl7:id[1]/concat(@root,@extension)
    group by $id
    order by $id
    return $patient[1]

return
<patients>
{
    for $patient in $patients
    let $prescriptionLists  := $patients/ancestor::hl7:MedicationPrescriptionList
    let $dispenseLists      := $patients/ancestor::hl7:MedicationDispenseList
    let $observationReports := $patients/ancestor::hl7:observationReport
    let $conditions         := $patients/ancestor::hl7:Condition
    (:order by $patient/*/hl7:name/hl7:family[1]:)
    return
        <patient>
            <name>{adxfiles:getNameFromHL7Name($patient/hl7:Person/hl7:name | $patient/hl7:patientPerson/hl7:name)}</name>
            <bsn>{$patient/hl7:id[@root='2.16.840.1.113883.2.4.6.3']/@extension/string()}</bsn>
            <birthDate>{adxfiles:getDateFromHL7Date($patient/*/hl7:birthTime/@value)}</birthDate>
            <gender>
            {if ($patient/hl7:Person/hl7:administrativeGenderCode/@code='M') then
                'M'
            else if ($patient/hl7:Person/hl7:administrativeGenderCode/@code='F') then
                'V'
            else ('Onbekend')}
            </gender>
            <conditions>{count($conditions)}</conditions>
            <prescriptions>{count($prescriptionLists//hl7:prescription)}</prescriptions>
            <dispenseEvents>{count($dispenseLists//hl7:medicationDispenseEvent)}</dispenseEvents>
            <labresults>{count($observationReports//hl7:observationEvent)}</labresults>
        </patient>
}
</patients>
