xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";
declare namespace xis   = "http://art-decor.org/ns/xis";

let $user   := (get:strCurrentUserName(),'guest')
(:let $user := 'admin':)

return
<testAccounts xmlns="http://art-decor.org/ns/xis">
{
    for $testAccount in doc($get:strTestAccounts)//xis:testAccount[xis:members/xis:user/@id=$user]
    let $name   := if ($testAccount[string-length(@displayName)>0]) then lower-case($testAccount/@displayName) else lower-case($testAccount/@name)
    order by $name
    return $testAccount
}
</testAccounts>