xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";
import module namespace art = "http://art-decor.org/ns/art" at  "../../art/modules/art-decor.xqm";

declare namespace xis="http://art-decor.org/ns/xis";

let $rawTestsuites := if (request:exists()) then request:get-data()/* else ()

let $editedTestsuites   :=
    <testsuites>
    {
        for $testsuite in $rawTestsuites/testsuite
        order by $testsuite/number(@id)
        return
        <testsuite>
        {
            $testsuite/@*,
            for $name in $testsuite/name
            return
            art:parseNode($name)
            ,
            $testsuite/application-role,
            for $desc in $testsuite/desc
            return
            art:parseNode($desc)
            ,
            $testsuite/xmlResourcesPath,
            for $test in $testsuite/test
            return
            <test>
            {
            $test/@*,
            for $name in $test/name
            return
            art:parseNode($name)
            ,
            for $desc in $test/desc
            return
            art:parseNode($desc)
            }
            </test>
        }
        </testsuite>
    }
    </testsuites>

let $testsuites     := doc($get:strTestSuites)/testsuites
let $update         := update value $testsuites with $editedTestsuites/*

return
<response>
{
    $testsuites
}
</response>

