xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";
import module namespace adxfiles    = "http://art-decor.org/ns/art-decor/xis/files" at "../api/api-xis-files.xqm";

declare namespace xis="http://art-decor.org/ns/xis";

let $account        := request:get-parameter('account','')
let $scenarioId     := request:get-parameter('scenarioId','')
(:let $account := 'art-decor'
let $scenarioId := '1':)
(:let $file := 'XK_HAPIS1_REPC_IN990003NL_555555112_bijlage XI.xml':)
let $resultdir      := concat($get:strXisAccounts, '/',$account,'/',$adxfiles:_filedir)
let $scenario       := collection($get:strXisResources)//xis:scenario[@id=$scenarioId]
let $completedSteps :=
    for $completedStep in $scenario//xis:step
    return 
    if (collection($resultdir)/file[@name=$completedStep/xis:action/@filename]) then $completedStep else ()

let $lastCompletedStep:=
    $completedSteps[position()=count($completedSteps)]

return
    xmldb:remove($resultdir,xmldb:encode-uri($lastCompletedStep/xis:action/@filename))
