xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace adxfiles    = "http://art-decor.org/ns/art-decor/xis/files" at "../api/api-xis-files.xqm";

(: Log debug messages? :)
let $debug              := true()

(: server path:)
let $account            := if (request:exists()) then request:get-parameter('account','') else ('')
let $searchData         := if (request:exists()) then request:get-data()/root else ()

let $param-beforedate   := $searchData/@beforedate[. castable as xs:date]/xs:date(.)
let $param-rootelement  := $searchData/@rootelement[string-length()>0]

let $offsetResults      := if ($searchData/@offset castable as xs:integer) then $searchData/xs:integer(@offset) else 1
let $maxResults         := if ($searchData/@count castable as xs:integer) then $searchData/xs:integer(@count) else $adxfiles:maxResults
let $sortBy             := $searchData/@sort
let $searchTerms        := tokenize(lower-case($searchData/search),'\s')

(:let $account          :='art-decor':)

let $g := if ($debug) then (util:log('DEBUG', concat('============ Supplied parameters (get-message-list): account=',$account,' sort=',$sortBy,' offset=',$offsetResults,' max=',$maxResults))) else ()

return
    adxfiles:getMessageList($account, $sortBy, $offsetResults, $maxResults, $searchTerms, $param-beforedate, $param-rootelement)