xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";
import module namespace adxaccounts = "http://art-decor.org/ns/art-decor/xis/accounts" at "../api/api-xis-accounts.xqm";
declare namespace xis       = "http://art-decor.org/ns/xis";
declare namespace hl7       = "urn:hl7-org:v3";

(: Log debug messages? :)
let $debug              := false()

(: server path:)
let $account           := if (request:exists()) then request:get-parameter('account',()) else ()
let $resources         := if (request:exists()) then request:get-parameter('resources',())[string-length()>0] else ()
(:let $account           := 'art-decor':)
let $query-data        := if (request:exists()) then request:get-data()/queries else ()

let $g := if ($debug) then (util:log('DEBUG', concat('============ Supplied parameters: account=',$account))) else ()

let $resourcesPath     := if (empty($resources)) then adxaccounts:getDefaultXmlResourcesPath($account) else $resources
let $queryManifestFile := concat($resourcesPath,'/message-templates/query_manifest.xml')
let $queryManifest     := if (doc-available($queryManifestFile)) then doc($queryManifestFile)/* else ()

return
    if ($queryManifest) then (
        $queryManifest
    )
    else (
        $query-data
    )