xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)


(: resources path:)
let $resourcesPath := if (request:exists()) then request:get-parameter('resourcesPath','') else '/db/apps/hl7/rivmsp-20130812T114806'

return
<tests>
{
    if (xmldb:collection-available(concat($resourcesPath,'/test_xslt'))) then
        if (collection(concat($resourcesPath,'/test_xslt'))//testset) then
            collection(concat($resourcesPath,'/test_xslt'))//testset/test
        else 
            for $file in xmldb:get-child-resources(concat($resourcesPath,'/test_xslt'))
            order by $file
            return if (not(ends-with($file, '.xsl'))) then () else 
                <test name="{substring-before($file,'.xsl')}">
                    <name>{substring-before($file,'.xsl')}</name>
                </test>
    else ()
}
</tests>