xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";
import module namespace art         = "http://art-decor.org/ns/art" at  "../../art/modules/art-decor.xqm";
import module namespace val         = "http://art-decor.org/ns/art-decor/xis/validation" at "../api/api-xis-validation.xqm";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace xis       = "http://art-decor.org/ns/xis";

declare %private function local:removeTestSuiteFromTest($testAccount as xs:string, $testsuiteId as xs:string) as xs:boolean {
let $testsuite          := val:getTestSuiteById($testsuiteId)
let $accountCollection  := concat($get:strXisAccounts,'/',$testAccount)
let $testseries         := concat($accountCollection,'/testseries.xml')

let $test              := collection($accountCollection)//xis:tests/xis:test[@testsuiteId=$testsuiteId]
let $update             := update delete $test

return true()
};

let $testAccount        := request:get-parameter('account',())
let $testsuiteId        := request:get-parameter('id',())
(:
let $testAccount        := 'art-decor'
let $testsuiteId        := '1':)

let $user               := get:strCurrentUserName()
let $update             :=
    if ($testAccount=sm:get-user-groups($user) or $testAccount='art-decor') then
        local:removeTestSuiteFromTest($testAccount, $testsuiteId)
    else (
        false()
    )

return
    <response>{$update}</response>