xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";
declare namespace xis = "http://art-decor.org/ns/xis";

let $account            := if (request:exists()) then request:get-parameter('account',())[string-length()>0] else ()

(: store which testAccount was last selected, so messages and test screen can show this at startup :)
let $user               := get:strCurrentUserName()
let $check              := sm:has-access(xs:anyURI($get:strTestAccounts),'rw-')
let $result             := 
    if ($account and $check) then (
        let $userAccounts       := doc($get:strTestAccounts)
        let $userAllAccounts    := $userAccounts//xis:testAccount/xis:members/xis:user[@id=$user]
        let $userThisAccount    := $userAccounts//xis:testAccount[@name=$account]/xis:members/xis:user[@id=$user]
        
        let $update             := 
            if (empty($userThisAccount)) then () else (
                update delete $userAllAccounts/@lastSelected,
                update insert attribute lastSelected {'true'} into $userThisAccount
            )
        return ()
    ) else ()
    
return
    <result user="{$user}" account="{$account}"/>