xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms 
    of the GNU General Public License as published by the Free Software Foundation; 
    either version 3 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
    See the GNU General Public License for more details.
    
    See http://www.gnu.org/licenses/gpl.html
:)
import module namespace temple  = "http://art-decor.org/ns/temple" at "temple.xqm";
import module namespace get     = "http://art-decor.org/ns/art-decor-settings" at "../../art/modules/art-decor-settings.xqm";

let $nl                     := "&#10;"
let $id                     := if (request:exists()) then request:get-parameter('id', '') else "2.16.840.1.113883.3.1937.99.62.3.10.11"
let $effectiveDate          := if (request:exists()) then request:get-parameter('effectiveDate', '') else "2012-03-11T00:00:00"
let $language               := if (request:exists()) then request:get-parameter('language', '') else 'nl-NL' (:'2014-10-24T00:00:00':)

let $update     := 
    if ($temple:userData/users/user[@name=get:strCurrentUserName()])
    then ()
    else update insert <user name="{get:strCurrentUserName()}"><preferences/><bookmarks/></user> into $temple:userData/users
let $thing      := $get:colDecorData//*[@id=$id][@effectiveDate=$effectiveDate][not(ancestor::history)][not(self::object)]
let $action     := if ($temple:myBookmarks//*[@id=$id][@effectiveDate=$effectiveDate]) then 'removed' else 'added'
let $update     := 
    if ($temple:myBookmarks//*[@id=$id][@effectiveDate=$effectiveDate]) 
    then update delete $temple:myBookmarks//*[@id=$id][@effectiveDate=$effectiveDate]
    else update insert
        element {local-name($thing)} {$thing/@*, $thing/name[@language=$language]}
        into $temple:myBookmarks
return $action