<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0">
    <xsl:output method="text" indent="yes"/>

    <xsl:template match="/">
        <xsl:text>// DO NOT EDIT THIS FILE! Generated code. Edit /schematools/toCMSchema.xsl instead, convert CDAflat.xsd to cda.js, copy that last one here.</xsl:text>
        <xsl:text>var cda_tags = {&#xa;"!top": ["hl7:ClinicalDocument"]</xsl:text>
        <xsl:apply-templates/>
        <xsl:text>&#xa;}</xsl:text>
    </xsl:template>

    <xsl:template match="xs:complexType">
        <xsl:text>,&#xa;</xsl:text>
        <xsl:variable name="typeName" select="tokenize(@name, '\.')[last()]"/>
        <xsl:if test="$typeName != 'ClinicalDocument'">
            <xsl:value-of select="concat(lower-case(substring($typeName, 1, 1)), substring($typeName, 2))"/>
        </xsl:if>
        <xsl:if test="$typeName = 'ClinicalDocument'">
            <xsl:value-of select="$typeName"/>
        </xsl:if>
        <xsl:text>: {&#xa;</xsl:text>
        <xsl:text>&#x9;attrs: {</xsl:text>
            <xsl:for-each select="xs:attribute">
                <xsl:value-of select="@name"/>
                <xsl:text>: null</xsl:text>
                <xsl:if test="following-sibling::*">, </xsl:if>
            </xsl:for-each>
        <xsl:text>}</xsl:text>
        <xsl:text>,&#xa;</xsl:text>
        <xsl:text>&#x9;children: [</xsl:text>
        <xsl:for-each select=".//xs:element">
            <xsl:if test="@name | @ref">
                <xsl:text>"</xsl:text>
                <xsl:value-of select="if (@name) then @name else @ref"/>
            </xsl:if>
            <xsl:text>"</xsl:text>
            <xsl:if test="following-sibling::*">, </xsl:if>
        </xsl:for-each>
        <xsl:text>]&#xa;}</xsl:text>
    </xsl:template>

    <xsl:template match="node()|@*">
        <xsl:apply-templates/>
    </xsl:template>
</xsl:stylesheet>
