xquery version "3.1";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)
import module namespace servermgmtapi             = "http://art-decor.org/ns/api/server-mgmt" at "../../api/modules/server-mgmt-api.xqm";

(: get login credentials :)
let $secret                         := if (request:exists()) then request:get-parameter('secret', '') else ''
let $theactingnotifierusername      := if (request:exists()) then request:get-parameter('user', '') else ''
let $theactingnotifierpassword      := if (request:exists()) then request:get-parameter('password', '') else ''

let $statusonly                     := if (request:exists()) then request:get-parameter('statusonly', 'false') = 'true' else false()

let $cacheformat                    := if (request:exists()) then request:get-parameter('cacheformat', 'decor') else 'decor'

return
    if ($secret='61fgs756.s9' and xmldb:login('/db', $theactingnotifierusername, $theactingnotifierpassword)) then (
        let $request                :=
            map { 
                "user": map {
                    "name": $theactingnotifierusername,
                    "dba": sm:is-dba($theactingnotifierusername),
                    "groups": sm:get-user-groups($theactingnotifierusername) 
                },
                "parameters" : map {
                    "statusonly": $statusonly,
                    "cacheformat": $cacheformat
                    
                }
            }
        let $results                        := servermgmtapi:postUpdateDecorCache($request)
        
        return
            <cachedBuildingBlockRepositories statusonly="{$statusonly}" xmlns:json="http://www.json.org">
                <result cached="{count($results/ok)}" unreachable="{count($results/unreachable)}" time="{$results/@time}">
                {
                    $results/*
                }
                </result>
            </cachedBuildingBlockRepositories>
    )
    else (
        switch ($cacheformat)
        case "decor" return
            <cachedBuildingBlockRepositories>NOTAUTHORIZED</cachedBuildingBlockRepositories>
        case "fhir" return
            <cachedFHIRRepositories>NOTAUTHORIZED</cachedFHIRRepositories>
        default return
            <ERRORUnknownCacheFormat format="{$cacheformat}"/>
    )
